# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AccountQuota(Model):
    """Represents a set of quotas assocated with an account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar tier: Gets the tier of user
    :vartype tier: str
    :ivar projects: Gets the project quota
    :vartype projects:
     ~azure.cognitiveservices.vision.customvision.training.models.Quota
    :ivar predictions: Gets the prediction quota
    :vartype predictions:
     ~azure.cognitiveservices.vision.customvision.training.models.Quota
    :ivar per_project: Gets a list of quotas that apply per-project for each
     project
    :vartype per_project:
     list[~azure.cognitiveservices.vision.customvision.training.models.PerProjectQuota]
    """

    _validation = {
        'tier': {'readonly': True},
        'projects': {'readonly': True},
        'predictions': {'readonly': True},
        'per_project': {'readonly': True},
    }

    _attribute_map = {
        'tier': {'key': 'Tier', 'type': 'str'},
        'projects': {'key': 'Projects', 'type': 'Quota'},
        'predictions': {'key': 'Predictions', 'type': 'Quota'},
        'per_project': {'key': 'PerProject', 'type': '[PerProjectQuota]'},
    }

    def __init__(self, **kwargs) -> None:
        super(AccountQuota, self).__init__(**kwargs)
        self.tier = None
        self.projects = None
        self.predictions = None
        self.per_project = None
