/**
    Widget for uploading one or more Files to a Zope3 Server. 

    for autentication we need to get a ticket id befor sending the post request.
    
    step1: get the ticket:
    
    ./ticket.html/filename=myfile.jpg
    this returns us a target path:
    targeturl=http://...... 
    this is the target where we post the file
    
    step2: send file to the given url
    
    configuration:
    on _level0 we receive the information about where to get the ticket - inside
    the ticket we receive the url where to upload. 
    
    _level0.target_path -> where to get the ticket
    _level0.allowed_types -> space seperated files of allowed types. 
    
    _level0.allowed_types = "Images (all jpgs and pngs); jpg jpeg png gif|

    @author <manfred.schwendinger@lovelysystems.com>
    @author <gerold.boehler@lovelysystems.com>
*/


import flash.net.FileReferenceList;
import flash.net.FileReference;

class z3c.widgets.flashupload.baseskin.Upload extends MovieClip{
   
    private var sizeinfo_txt:TextField;
    
    private var info_mc:MovieClip;
    private var scrollbox_mc:MovieClip;

    private var file_array:Array;
    private var fileref:FileReferenceList;
    private var file:FileReference; // currently active file for upload
    
    private var allowed_types:Array;
    private var maxSize:Number;
    private var debug_txt:TextField;
    
    private var upload_complete_str:String;
    private var upload_partial_str:String;
    private var not_uploaded_str:String;
    private var max_filesize_str:String;
    
    private var load_vars:LoadVars;
    
    private var overall_total:Number;
    private var overall_loaded:Number;
    
    private var file_counter:Number;
    private var files_loaded:Number;
    private var files_not_loaded:Number;
    private var file_amount:Number;
	
	private var data_xml:XML;
    
	private var error_msg:String;
	
	private var js_command_queue:Array; // only one getURL can be called inside one frame. so lets make a queue to avoid troubles. 
	
    public function Upload()
    {
        allowed_types = new Array();
		js_command_queue = new Array();
        
		overall_total = 0;
        overall_loaded = 0;
        file_counter = 0;
        files_loaded = 0;
        files_not_loaded = 0;
        maxSize = 0;
		log("initialize. target: "+_level0.target_path);
    
        // allow upload from the local host
        System.security.allowDomain("http://localhost/");
        
        fileref = new FileReferenceList();
        fileref.addListener(this);
        
		// we do not want to have an overall info if there is only 1 file uploading...
		info_mc.overallinfo_mc._visible = false;
		
        info_mc.fileinfo_mc.progress_mc.bar_mc.gotoAndStop(1);
        info_mc.overallinfo_mc.progress_mc.bar_mc.gotoAndStop(1);
                
        info_mc._visible = false;
        scrollbox_mc._visible = false;

        onEnterFrame = initAfterFirstFrame;
    }
    
    function initAfterFirstFrame()
    {
        this.onResize();
        Stage.addListener(this);
            
		var xml_url:String = _level0.config_path;
		
		data_xml = new XML();
		data_xml["ptr"] = this;
		data_xml.ignoreWhite = true;
		data_xml.onLoad = function(){ this.ptr.parseDataXML(this); }
		data_xml.load(xml_url);
		
		onEnterFrame = waitForStartBrowse;
    }
    
    private function initAfterXmlLoaded()
    {
        scrollbox_mc.setHeadline(files_not_loaded + " " + not_uploaded_str);
        sizeinfo_txt.autoSize = true;
        sizeinfo_txt._visible = maxSize > 0;
        sizeinfo_txt.text = max_filesize_str + ": " + maxSize + "KB";
    }

    private function onResize(){

        var margin:Number = 5;
        var width:Number = Stage.width - 2*margin;
        
        //sizeinfo_txt._y = 0;
        
		// position of the file info (current file name + number)
		info_mc.filenum_txt._x = width - info_mc.filenum_txt._width; 
		info_mc.filename_txt._width = info_mc.filenum_txt._x - info_mc.filename_txt._x;		
		info_mc.progress_txt.text = "";
		info_mc.progress_txt._x = width - info_mc.progress_txt._width;
		
		// file progress positions
		this.setProgressSize(info_mc.fileinfo_mc, width);
		// overall progress positions
		this.setProgressSize(info_mc.overallinfo_mc, width);
		
		var scrollboxHeight = 90;
		scrollbox_mc._y = Stage.height - scrollboxHeight + 11;
		scrollbox_mc.onParentResize(width, scrollboxHeight);
    }
    
	/*
		sets the size of a bar line (overall and file bars)
	*/
	private function setProgressSize(mc:MovieClip, width:Number):Void{
		mc.label_txt._width = width - mc.progress_txt._width;
		mc.progress_txt._x = width - mc.progress_txt._width;
		mc.progress_mc._width = width;			
	}
	
	
	/**
		parses the language dependend strings. 
	*/
	private function parseDataXML(obj_xml:XML):Void{
		log("xml loaded: "+obj_xml.firstChild);
		var nodes = obj_xml.firstChild.childNodes;
		for (var i=0; i<nodes.length; i++){
			var nodeval:String = nodes[i].firstChild.nodeValue; 
			switch(nodes[i].attributes.name){
				case "file_progress" :
					info_mc.fileinfo_mc.label_txt.text = nodeval;
					break;
				case "overall_progress" :
					info_mc.overallinfo_mc.label_txt.text = nodeval;
					break;
				case "error" :
					error_msg = nodeval;
					break;
				case "uploadcomplete" :
				    upload_complete_str = nodeval;
                    break;
				case "uploadpartial" :
				    upload_partial_str = nodeval;
                    break;
				case "notuploaded" :
				    not_uploaded_str = nodeval;
                    break;
				case "maxfilesize" :
				    max_filesize_str = nodeval;
                    break;
                case "allowedFileType":
                    var allowedType = nodeval;
                    if (allowedType.charAt(0) == "."){
                        allowedType = "*"+allowedType;
                    }
                    allowed_types.push(allowedType);
                    log("add allowed type: "+allowedType+" ("+allowed_types.length+")");
                    break;
                case "maxsize":
                    maxSize = parseInt(nodeval);
            		log("maxsize: " + maxSize)
                    break;
				default:
					log("error: unexpected attribute: "+nodes[i].attributes.name);
					break;
			}
		}
		
		initAfterXmlLoaded();
	}
	
	
    /**
        creates an array with all allowed types
        the data gets parsed from the variable of _level0.allowed_types
        
        var file:FileReference;

        var allTypes:Array = new Array();
        var imageTypes:Object = new Object();
        imageTypes.description = "Images (*.jpg, *.jpeg, *.gif, *.png)";
        imageTypes.extension = "*.jpg; *.jpeg; *.gif; *.png";
        allTypes.push(imageTypes);

        var textTypes:Object = new Object();
        textTypes.description = "Text Files (*.txt, *.rtf)";
        textTypes.extension = "*.txt;*.rtf";
        allTypes.push(textTypes);
        
        arr = [{description:'a description', extension:'*.jpg'}, .....]
    */
    public function saveAllowedTypes(arr:Array):Void{
        allowed_types = arr;
    }
    
    /**
        starts the browsing process for uploading files
    */
    public function browse():Void{
		js_command_queue.push("javascript:z3cFlashUploadDisableBrowseButton()");
        
        if (allowed_types.length>0){
            log("browse with limited filetypes: "+allowed_types);
            var allTypes:Array = new Array();
            var t:Object = new Object();
            t.description = "Files";
            t.extension = "";
            for (var i=0; i<allowed_types.length; i++){
                t.extension += allowed_types[i];
                if (i<allowed_types.length - 1) t.extension+=";";
            }
            log("ALLOWED: "+t.extension);
            allTypes.push(t);
            fileref.browse(allTypes);
        }
        else{
            log("browse");
            fileref.browse();
        }
        
    }

    /**
        starts the upload queue
    */
    public function onSelect(fileRefList:FileReferenceList):Void
    {
        sizeinfo_txt._visible = false;
        
		file_array = fileRefList.fileList;
		log("uploadFiles: "+file_array.length);        
        
		// overall progress should be visible on mutliple fileupload only. 
		info_mc.overallinfo_mc._visible = (file_array.length > 1);
		
        for (var i=0; i<file_array.length; i++){
            overall_total+=file_array[i].size;
        }
        
        if (file_array.length>0){
            info_mc._visible = true;
            file_counter = 0;
            file_amount = file_array.length;
            loadNextTicket();
        }
    }
    
    /**
        loads the next upload ticket via loadvars
        the ticket holds some security information which 
        are required for the upload
    */
    public function loadNextTicket():Void
    {
        // we want to have a 100% bar, even if onProgress was never
        // fired because the file was so small that onProgress was
        // never fired
        // UPDATE: seems like we don't want a 100% progress bar,
        // so set it to 0
        
        this.updateFileProgress(0);

        if (file_array.length == 0)
        {
            log("all files uploaded.");
			// all files uploaded. Fire JavaScript Event
			js_command_queue.push("javascript:z3cFlashUploadOnUploadCompleteFEvent()");
			
			if (files_not_loaded == 0)
			    info_mc.filename_txt.text = upload_complete_str;
			else
			    info_mc.filename_txt.text = files_loaded + " " + upload_partial_str;
			
			this.updateFileProgress(100);
            this.updateOverallProgress(100);
            return;
        }
        
        load_vars = new LoadVars();
        load_vars["ptr"] = this;
        load_vars.onData = function(d:String){
            this["ptr"].log("load data: "+d);
            this["ptr"].loadNextFile(d);
        }
        load_vars.load(_level0.target_path+"/@@ticket");
    }
    
	
    /**
        loads the next file inside the file_array
    */
    public function loadNextFile(ticket:String):Void
    {        
        file = FileReference(file_array.pop());
        
        if (maxSize && (file.size > maxSize * 1000))
        {
            files_not_loaded++;
            scrollbox_mc.setHeadline(files_not_loaded + " " + not_uploaded_str);
            scrollbox_mc._visible = true;
            scrollbox_mc.addText(file.name + "\n");
            this.loadNextTicket();
            return;
        }
            
        
        var url:String = _level0.target_path+"?ticket="+ticket;
        
        log("uploadNextFile: "+url);
        
        file.addListener(this);
        file.upload(url);
    }
    
	
    public function log(msg:String):Void{
        trace(msg);
		
		if (msg.length>500) msg = msg.substring(msg.length-100, msg.length);
		
        _level0.debug_txt.text+=msg+"\n";
		_level0.debug_txt.scroll = _level0.debug_mc.debug_txt.maxscroll;
    }
    
	
	
    /**
        FileReference Listeners....
    */
    public function onProgress(file:FileReference, bytesLoaded:Number, bytesTotal:Number):Void{
        
		var percent:Number = Math.round(bytesLoaded/bytesTotal * 100);
		if (percent>100) percent=100; // for any strange reason, the totalbytes can be smaller then the loade bytes :)
        log("onProgress " + bytesLoaded + " bytesTotal: " + bytesTotal+" = "+percent+"%");

        this.updateFileProgress(percent);
       
        var percent_complete:Number = Math.round((overall_loaded+bytesLoaded) / overall_total * 100);

        // hack for waiting time after last upload is done
        // 100% should only be displayed when the LAST object fired his READY event. 
        if (percent_complete > 95) percent_complete = 95; 
		this.updateOverallProgress(percent_complete);
        
		info_mc.progress_txt.text = getByteString(overall_loaded + bytesLoaded) + "/" + getByteString(overall_total);
    }

    public function updateFileProgress(percent:Number):Void{
        if (percent>100) percent = 100;
        info_mc.fileinfo_mc.progress_mc.bar_mc.gotoAndStop(percent);
        info_mc.fileinfo_mc.progress_txt.text = percent+"%";
    }
    
    public function updateOverallProgress(percent:Number):Void{
        if (percent>100) percent = 100;
        info_mc.overallinfo_mc.progress_mc.bar_mc.gotoAndStop(percent);
        info_mc.overallinfo_mc.progress_txt.text = percent+"%";
    }
    
	/**
		returns a nice prepared string
	*/
	public function getByteString(bytes:Number):String{
		if (bytes<1024){
			// bytes
			return String(Math.round(bytes)+"B");
		}
		else if (bytes>(1024*1024)){
			// MB
			return String(Math.round(bytes/(1024*1024))+"MB");
		}
		else{
			// KB
			return String(Math.round(bytes/1024)+"KB");
		}
	}
	
    public function onComplete(file:FileReference):Void{
        log("file upload complete");
        files_loaded++;
        overall_loaded+=file.size;
        this.loadNextTicket();
		
		// tell javascript that the file is uploaded. 
		js_command_queue.push("javascript:z3cFlashUploadOnFileCompleteFEvent('"+file.name+"')");
    }

    public function onCancel(file:FileReference):Void{
        log("onCancel");
		js_command_queue.push("javascript:z3cFlashUploadEnableBrowseButton()");
		js_command_queue.push("javascript:z3cFlashUploadOnCancelFEvent()");
    }
    
    public function onOpen(file:FileReference):Void{
        log("onOpen: "+file.name+" : "+file.size);
        file_counter++;
        
        info_mc.filename_txt.text = file.name +" ("+Math.round(file.size/1024)+"kb)";
        info_mc.filenum_txt.text = file_counter+"/"+file_amount;
    }

    public function onHTTPError(file:FileReference):Void {
        log("onHTTPError: " + file.name);
		js_command_queue.push("javascript:z3cFlashUploadOnErrorFEvent('"+this.error_msg+"')");
    }

    public function onIOError(file:FileReference):Void {
        log("onIOError: " + file.name);
		js_command_queue.push("javascript:z3cFlashUploadOnErrorFEvent('"+this.error_msg+"')");		
    }
    
    public function onSecurityError(file:FileReference, errorString:String):Void {
        log("onSecurityError: " + file.name + " errorString: " + errorString);
		js_command_queue.push("javascript:z3cFlashUploadOnErrorFEvent('"+this.error_msg+"')");		
    }

    public function waitForStartBrowse():Void{

        if (_level0.startBrowse=="go"){
			log("go event was fired");
            _level0.startBrowse = "";
            this.browse();
        }
		
		if (js_command_queue.length>0){
			var command = js_command_queue.shift();
			getURL(command);
		}
		
    }
	
}
