; Generated by makesimplensi @ 12.04.2004 02:35:59
; from directory "C:\nsis\Contrib\nsisunz"
; Fine-tuned by Saivert

!include "infopage.nsh"
!include "addremoveprograms.nsh"

SetCompressor lzma
OutFile "nsisunz_setup.exe"
Name "nsisunz"
ChangeUI IDD_INST ${NSISDIR}\contrib\uis\classic_buttonstoright.exe
Icon "${NSISDIR}\Contrib\Graphics\Icons\box-install.ico"
UninstallIcon "${NSISDIR}\Contrib\Graphics\Icons\box-uninstall.ico"
XPStyle on

InstallDir "$PROGRAMFILES\nsis"
InstallDirRegKey HKEY_LOCAL_MACHINE \
  "Software\Microsoft\Windows\Currentversion\Uninstall\nsis" "UninstallString"

!insertmacro PAGE_INFO "Please read this..." "info.rtf"
Page components
Page directory
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles


Section "nsisunz NSIS Plug-in"
  SectionIn RO

  SetOutPath $INSTDIR\plugins
  ; plug-in
  File ${NSISDIR}\plugins\nsisunz.dll

  SetOutPath $INSTDIR\3rdparty\nsisunz
  ; Readme & examples (4 Files)
    File "example.nsi"
    File "example_mui.nsi"
    File "nsisunz_readme.html"
    File "zippage.ini"
SectionEnd

Section "Source (MS Visual C++ 6.0 project)"
  SetOutPath "$INSTDIR\3rdparty\nsisunz\source"
  ; Source (3 files + ZLIB)
    File "nsisunz.cpp"
    File "nsisunz.dsp"
    File "nsisunz.dsw"
  SetOutPath "$INSTDIR\3rdparty\nsisunz\source\zlib"
  ; ZLIB (20 Files)
    File "zlib\ADLER32.C"
    File "zlib\CRC32.C"
    File "zlib\INFBLOCK.C"
    File "zlib\INFBLOCK.H"
    File "zlib\INFCODES.C"
    File "zlib\INFCODES.H"
    File "zlib\INFFAST.C"
    File "zlib\INFFAST.H"
    File "zlib\INFFIXED.H"
    File "zlib\INFLATE.C"
    File "zlib\INFTREES.C"
    File "zlib\INFTREES.H"
    File "zlib\INFUTIL.C"
    File "zlib\INFUTIL.H"
    File "zlib\Unzip.c"
    File "zlib\UNZIP.H"
    File "zlib\ZCONF.H"
    File "zlib\ZLIB.H"
    File "zlib\Zutil.c"
    File "zlib\ZUTIL.H"

SectionEnd

Section -post
  !insertmacro ADDTOADDREMOVELIST nsisunz $(^Name) "$INSTDIR\3rdparty\nsisunz\nsisunz_uninstall.exe" 1 1

  DetailPrint "Note: Shortcuts are located in Contrib submenu of NSIS start-menu branch!"
  CreateDirectory "$SMPROGRAMS\NSIS\3rdparty\nsisunz"
  CreateShortcut "$SMPROGRAMS\NSIS\3rdparty\nsisunz\examples and source.lnk" "$INSTDIR\3rdparty\nsisunz\"
  CreateShortcut "$SMPROGRAMS\NSIS\3rdparty\nsisunz\readme.lnk" "$INSTDIR\3rdparty\nsisunz\nsisunz_readme.html"
  CreateShortcut "$SMPROGRAMS\NSIS\3rdparty\nsisunz\Uninstall nsisunz.lnk" "$INSTDIR\3rdparty\nsisunz\nsisunz_uninstall.exe"

  WriteUninstaller "$INSTDIR\3rdparty\nsisunz\nsisunz_uninstall.exe"
  SetAutoClose true
SectionEnd

Function .onInstSuccess
  MessageBox MB_YESNO "Installation done!$\r$\nDo you wish to open the nsisunz examples folder?" IDYES +1 IDNO skiprunapp
  ExecShell open "$INSTDIR\3rdparty\nsisunz\"
  skiprunapp:
FunctionEnd

Section "Uninstall"
  ; Remove plug-in
  Delete "$INSTDIR\plugins\nsisunz.dll"

  ; Remove readme & examples
  Delete "$INSTDIR\example.nsi"
  Delete "$INSTDIR\example_mui.nsi"
  Delete "$INSTDIR\zippage.ini"
  Delete "$INSTDIR\nsisunz_readme.html"


  ; Remove source
  Delete "$INSTDIR\source\nsisunz.cpp"
  Delete "$INSTDIR\source\nsisunz.dsp"
  Delete "$INSTDIR\source\nsisunz.dsw"

  ; Remove included ZLIB
  Delete "$INSTDIR\source\zlib\ADLER32.C"
  Delete "$INSTDIR\source\zlib\CRC32.C"
  Delete "$INSTDIR\source\zlib\INFBLOCK.C"
  Delete "$INSTDIR\source\zlib\INFBLOCK.H"
  Delete "$INSTDIR\source\zlib\INFCODES.C"
  Delete "$INSTDIR\source\zlib\INFCODES.H"
  Delete "$INSTDIR\source\zlib\INFFAST.C"
  Delete "$INSTDIR\source\zlib\INFFAST.H"
  Delete "$INSTDIR\source\zlib\INFFIXED.H"
  Delete "$INSTDIR\source\zlib\INFLATE.C"
  Delete "$INSTDIR\source\zlib\INFTREES.C"
  Delete "$INSTDIR\source\zlib\INFTREES.H"
  Delete "$INSTDIR\source\zlib\INFUTIL.C"
  Delete "$INSTDIR\source\zlib\INFUTIL.H"
  Delete "$INSTDIR\source\zlib\Unzip.c"
  Delete "$INSTDIR\source\zlib\UNZIP.H"
  Delete "$INSTDIR\source\zlib\ZCONF.H"
  Delete "$INSTDIR\source\zlib\ZLIB.H"
  Delete "$INSTDIR\source\zlib\Zutil.c"
  Delete "$INSTDIR\source\zlib\ZUTIL.H"

  Delete "$INSTDIR\nsisunz_uninstall.exe"
  RMDir "$INSTDIR\source\zlib\"
  RMDir "$INSTDIR\source\"
  RMDir "$INSTDIR\"

  ; Remove shortcuts
  Delete "$SMPROGRAMS\NSIS\3rdparty\nsisunz\examples and source.lnk"
  Delete "$SMPROGRAMS\NSIS\3rdparty\nsisunz\readme.lnk"
  Delete "$SMPROGRAMS\NSIS\3rdparty\nsisunz\Uninstall nsisunz.lnk"
  RMDir "$SMPROGRAMS\NSIS\3rdparty\nsisunz"

  !insertmacro REMOVEFROMADDREMOVELIST nsisunz

SectionEnd
; Number of File lines: 28
; Number of SetOutPath lines: 1
; Total size of all files: 298 kB (304897 bytes)
