# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.operations import Operations
from .operations.namespaces_operations import NamespacesOperations
from .operations.disaster_recovery_configs_operations import DisasterRecoveryConfigsOperations
from .operations.queues_operations import QueuesOperations
from .operations.topics_operations import TopicsOperations
from .operations.subscriptions_operations import SubscriptionsOperations
from .operations.rules_operations import RulesOperations
from .operations.regions_operations import RegionsOperations
from .operations.premium_messaging_regions_operations import PremiumMessagingRegionsOperations
from .operations.event_hubs_operations import EventHubsOperations
from . import models


class ServiceBusManagementClientConfiguration(AzureConfiguration):
    """Configuration for ServiceBusManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials that uniquely identify a
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(ServiceBusManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-servicebus/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class ServiceBusManagementClient(object):
    """Azure Service Bus client

    :ivar config: Configuration for client.
    :vartype config: ServiceBusManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.servicebus.operations.Operations
    :ivar namespaces: Namespaces operations
    :vartype namespaces: azure.mgmt.servicebus.operations.NamespacesOperations
    :ivar disaster_recovery_configs: DisasterRecoveryConfigs operations
    :vartype disaster_recovery_configs: azure.mgmt.servicebus.operations.DisasterRecoveryConfigsOperations
    :ivar queues: Queues operations
    :vartype queues: azure.mgmt.servicebus.operations.QueuesOperations
    :ivar topics: Topics operations
    :vartype topics: azure.mgmt.servicebus.operations.TopicsOperations
    :ivar subscriptions: Subscriptions operations
    :vartype subscriptions: azure.mgmt.servicebus.operations.SubscriptionsOperations
    :ivar rules: Rules operations
    :vartype rules: azure.mgmt.servicebus.operations.RulesOperations
    :ivar regions: Regions operations
    :vartype regions: azure.mgmt.servicebus.operations.RegionsOperations
    :ivar premium_messaging_regions: PremiumMessagingRegions operations
    :vartype premium_messaging_regions: azure.mgmt.servicebus.operations.PremiumMessagingRegionsOperations
    :ivar event_hubs: EventHubs operations
    :vartype event_hubs: azure.mgmt.servicebus.operations.EventHubsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials that uniquely identify a
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = ServiceBusManagementClientConfiguration(credentials, subscription_id, base_url)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2017-04-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.namespaces = NamespacesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.disaster_recovery_configs = DisasterRecoveryConfigsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.queues = QueuesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.topics = TopicsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.subscriptions = SubscriptionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.rules = RulesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.regions = RegionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.premium_messaging_regions = PremiumMessagingRegionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.event_hubs = EventHubsOperations(
            self._client, self.config, self._serialize, self._deserialize)
