/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.resourcemanager.common.event;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;

public class SortedUniqueSet<T extends Unique & Comparable<T>>
implements Serializable {
    private TreeSet<T> sortedItems = new TreeSet();
    private HashMap<String, T> items = new HashMap();
    private static final long serialVersionUID = 110L;

    public void add(T toAdd) {
        this.remove(toAdd);
        this.items.put(toAdd.getKey(), toAdd);
        this.sortedItems.add(toAdd);
    }

    public Optional<T> get(String key) {
        Unique value = (Unique)this.items.get(key);
        if (value != null) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public boolean remove(T toRemove) {
        if (this.items.containsKey(toRemove.getKey())) {
            Unique oldItem = (Unique)this.items.remove(toRemove.getKey());
            this.sortedItems.remove(oldItem);
            return true;
        }
        return false;
    }

    public SortedSet<T> getSortedItems() {
        return this.sortedItems;
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Iterator<T> iterator() {
        return this.sortedItems.iterator();
    }

    public boolean contains(String key) {
        return this.items.containsKey(key);
    }

    public void clear() {
        this.items.clear();
        this.sortedItems.clear();
    }

    static interface Unique {
        public String getKey();

        public long getCounter();
    }
}

