/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.task;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.job.JobIdImpl;

@XmlAccessorType(value=XmlAccessType.FIELD)
public final class TaskIdImpl
implements TaskId {
    private long id;
    private String readableName = "NOT SET";
    private String tag;
    private JobId jobId;
    private static final long serialVersionUID = 110L;

    private TaskIdImpl(JobId jobId, long taskId) {
        this.jobId = jobId;
        this.id = taskId;
    }

    private TaskIdImpl(JobId jobId, String name, long taskId) {
        this(jobId, taskId);
        this.readableName = name;
    }

    public static TaskId createTaskId(JobId jobId, String readableName, long taskId) {
        return new TaskIdImpl(jobId, readableName, taskId);
    }

    public static TaskId createTaskId(JobId jobId, String readableName, long taskId, String tag) {
        TaskIdImpl t = new TaskIdImpl(jobId, readableName, taskId);
        t.setTag(tag);
        return t;
    }

    @Override
    public JobId getJobId() {
        return this.jobId;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public String getReadableName() {
        return this.readableName;
    }

    public void setReadableName(String readableName) {
        this.readableName = readableName;
    }

    @Override
    public int compareTo(TaskId that) {
        return Long.compare(this.id, ((TaskIdImpl)that).id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskIdImpl taskId = (TaskIdImpl)o;
        return this.id == taskId.id;
    }

    public int hashCode() {
        return (int)(this.id % Integer.MAX_VALUE);
    }

    @Override
    public String value() {
        return Long.toString(this.id);
    }

    @Override
    public long longValue() {
        return this.id;
    }

    @Override
    public int getIterationIndex() {
        int iterationPos = this.readableName.indexOf("#");
        if (iterationPos != -1) {
            int replicationPos = this.readableName.indexOf("*");
            if (replicationPos == -1) {
                replicationPos = this.readableName.length();
            }
            int read = Integer.parseInt(this.readableName.substring(iterationPos + 1, replicationPos));
            return Math.max(0, read);
        }
        return 0;
    }

    @Override
    public int getReplicationIndex() {
        int pos = this.readableName.indexOf("*");
        if (pos != -1) {
            int read = Integer.parseInt(this.readableName.substring(pos + 1));
            return Math.max(0, read);
        }
        return 0;
    }

    @Override
    public String toString() {
        return this.jobId.value() + 't' + this.value();
    }

    public static TaskId makeTaskId(String str) {
        String[] strSplitted = str.split("t");
        if (!str.contains("t") || strSplitted.length != 2) {
            throw new IllegalArgumentException("A valid task id must be supplied");
        }
        JobId jobId = JobIdImpl.makeJobId(strSplitted[0]);
        long taskId = Long.parseLong(strSplitted[1]);
        return new TaskIdImpl(jobId, taskId);
    }
}

