# Created: 01.05.14
# License: MIT License
from __future__ import unicode_literals
__author__ = "mozman <mozman@gmx.at>"

import unittest
from dxfgrabber.tags import ClassifiedTags
from dxfgrabber.entities import entity_factory


class TestHelix(unittest.TestCase):
    def setUp(self):
        tags = ClassifiedTags.from_text(HELIX)
        self.entity = entity_factory(tags, 'AC1024')

    def test_helix_properties(self):
        helix = self.entity
        self.assertEqual(helix.dxftype, 'HELIX')
        self.assertEqual(helix.color, 256)
        self.assertEqual(helix.layer, '0')
        self.assertEqual(helix.linetype, None)
        self.assertFalse(helix.paperspace)

    def test_helix_data(self):
        helix = self.entity
        self.assertEqual(helix.axis_base_point, (0, 0, 0))
        self.assertEqual(helix.start_point, (1.330227762078963, 0.6931768179868629, 0.0))
        self.assertEqual(helix.axis_vector, (0, 0, 1))
        self.assertEqual(helix.radius, 1.5)
        self.assertEqual(helix.turns, 3)
        self.assertEqual(helix.turn_height, 3.333333333333333)
        self.assertEqual(helix.handedness, 1)
        self.assertEqual(helix.constrain, 1)

    def test_spline_data(self):
        helix = self.entity
        self.assertEqual(helix.flags, 0)
        self.assertEqual(helix.degree, 3)
        self.assertEqual(len(helix.fitpoints), 0)
        self.assertEqual(len(helix.controlpoints), 52)
        self.assertEqual(len(helix.weights), 52)
        self.assertEqual(len(helix.knots), 56)


HELIX = """0
HELIX
  5
223
330
1F
100
AcDbEntity
  8
0
100
AcDbSpline
 70
     0
 71
     3
 72
    56
 73
    52
 74
     0
 42
0.0000000001
 43
0.0000000001
 40
0.0
 40
0.0
 40
0.0
 40
0.0
 40
1.166423713244438
 40
1.166423713244438
 40
1.166423713244438
 40
2.332847426488877
 40
2.332847426488877
 40
2.332847426488877
 40
3.499271139733315
 40
3.499271139733315
 40
3.499271139733315
 40
4.665694852977754
 40
4.665694852977754
 40
4.665694852977754
 40
5.832118566222193
 40
5.832118566222193
 40
5.832118566222193
 40
6.998542279466631
 40
6.998542279466631
 40
6.998542279466631
 40
8.164965992711071
 40
8.164965992711071
 40
8.164965992711071
 40
9.331389705955508
 40
9.331389705955508
 40
9.331389705955508
 40
10.49781341919994
 40
10.49781341919994
 40
10.49781341919994
 40
11.66423713244438
 40
11.66423713244438
 40
11.66423713244438
 40
12.83066084568882
 40
12.83066084568882
 40
12.83066084568882
 40
13.99708455893326
 40
13.99708455893326
 40
13.99708455893326
 40
15.1635082721777
 40
15.1635082721777
 40
15.1635082721777
 40
16.32993198542213
 40
16.32993198542213
 40
16.32993198542213
 40
17.49635569866657
 40
17.49635569866657
 40
17.49635569866657
 40
18.66277941191101
 40
18.66277941191101
 40
18.66277941191101
 40
18.84955592153876
 40
18.84955592153876
 40
18.84955592153876
 40
18.84955592153876
 10
1.330227762078963
 20
0.6931768179868629
 30
0.0
 10
1.060715136088563
 20
1.21037988655519
 30
0.2062689996693954
 10
0.4676237743438182
 20
1.539955867995306
 30
0.412537999338791
 10
-0.1139041660829722
 20
1.495669027876469
 30
0.6188069990081864
 10
-0.6954321065097626
 20
1.451382187757632
 30
0.8250759986775817
 10
-1.231774674813586
 20
1.035793039266348
 30
1.031344998346977
 10
-1.419857139401232
 20
0.4837413603273451
 30
1.237613998016372
 10
-1.607939603988878
 20
-0.0683103186116587
 30
1.443882997685768
 10
-1.436887681903262
 20
-0.7249067935254887
 30
1.650151997355163
 10
-1.003358842527336
 20
-1.115020642464614
 30
1.856420997024559
 10
-0.5698300031514119
 20
-1.50513449140374
 30
2.062689996693954
 10
0.1011106030779345
 20
-1.606210669759714
 30
2.26895899636335
 10
0.6303300186723159
 20
-1.361133376109981
 30
2.475227996032745
 10
1.159549434266697
 20
-1.116056082460249
 30
2.68149699570214
 10
1.516450007902408
 20
-0.538994845279175
 30
2.887765995371536
 10
1.499355512569938
 20
0.0439664295359402
 30
3.094034995040931
 10
1.482261017237467
 20
0.6269277043510554
 30
3.300303994710326
 10
1.092159798020773
 20
1.182084195517375
 30
3.506572994379722
 10
0.5494889958355654
 20
1.395729860487201
 30
3.712841994049118
 10
0.0068181936503572
 20
1.609375525457027
 30
3.919110993718513
 10
-0.6570468271468443
 20
1.469158104712015
 30
4.125379993387909
 10
-1.066971358101835
 20
1.054311206897813
 30
4.331648993057305
 10
-1.476895889056826
 20
0.6394643090836123
 30
4.5379179927267
 10
-1.609179499880013
 20
-0.0260270411426922
 30
4.744186992396095
 10
-1.389071793691269
 20
-0.5661091343295196
 30
4.95045599206549
 10
-1.168964087502525
 20
-1.106191227516347
 30
5.156724991734885
 10
-0.609190936877896
 20
-1.489638369581881
 30
5.362993991404281
 10
-0.0260671514271629
 20
-1.49977348410234
 30
5.569262991073676
 10
0.5570566340235703
 20
-1.509908598622798
 30
5.775531990743071
 10
1.12981683721005
 20
-1.146145708041265
 30
5.981800990412467
 10
1.368559966676268
 20
-0.61403877533186
 30
6.188069990081862
 10
1.607303096142486
 20
-0.0819318426224544
 30
6.394338989751257
 10
1.498225843060227
 20
0.5877545345560571
 30
6.600607989420653
 10
1.10296523039669
 20
1.016596134428995
 30
6.806876989090048
 10
0.7077046177331537
 20
1.445437734301933
 30
7.013145988759442
 10
0.049113258321318
 20
1.608640406542679
 30
7.219414988428839
 10
-0.5006541629802391
 20
1.413982110597781
 30
7.425683988098234
 10
-1.050421584281796
 20
1.219323814652882
 30
7.631952987767629
 10
-1.4595794009415
 20
0.6780590254926096
 30
7.838221987437024
 10
-1.496922031318554
 20
0.0960439074232779
 30
8.044490987106419
 10
-1.534264661695609
 20
-0.4859712106460539
 30
8.250759986775815
 10
-1.197633082991307
 20
-1.075086539879218
 30
8.457028986445209
 10
-0.6772499838209799
 20
-1.338406686853619
 30
8.663297986114605
 10
-0.1568668846506518
 20
-1.60172683382802
 30
8.869566985784
 10
0.5171809691680122
 20
-1.52402753086523
 30
9.075835985453396
 10
0.9640047866835018
 20
-1.149214849908969
 30
9.282104985122792
 10
1.410828604198991
 20
-0.7744021689527088
 30
9.488373984792188
 10
1.604594564941756
 20
-0.1241464935634939
 30
9.694642984461582
 10
1.43581002369862
 20
0.434107792888549
 30
9.900911984130978
 10
1.40878297757931
 20
0.5234996544602031
 30
9.933941322753986
 10
1.373384144285115
 20
0.610358385183182
 30
9.966970661376993
 10
1.330227762078963
 20
0.6931768179868618
 30
10.0
100
AcDbHelix
 90
       29
 91
       63
 10
0.0
 20
0.0
 30
0.0
 11
1.330227762078963
 21
0.6931768179868629
 31
0.0
 12
0.0
 22
0.0
 32
1.0
 40
1.5
 41
3.0
 42
3.333333333333333
290
     1
280
     1
"""
