# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ScheduleEntry(Model):
    """ScheduleEntry.

    :param day_of_week: Day of week when cache can be patched. Possible
     values include: 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
     'Saturday', 'Sunday'
    :type day_of_week: str or :class:`DayOfWeek
     <azure.mgmt.redis.models.DayOfWeek>`
    :param start_hour_utc: Start hour after which cache patching can start.
    :type start_hour_utc: int
    :param maintenance_window: ISO8601 timespan specifying how much time
     cache patching can take.
    :type maintenance_window: timedelta
    """ 

    _validation = {
        'day_of_week': {'required': True},
        'start_hour_utc': {'required': True},
    }

    _attribute_map = {
        'day_of_week': {'key': 'dayOfWeek', 'type': 'str'},
        'start_hour_utc': {'key': 'startHourUtc', 'type': 'int'},
        'maintenance_window': {'key': 'maintenanceWindow', 'type': 'duration'},
    }

    def __init__(self, day_of_week, start_hour_utc, maintenance_window=None):
        self.day_of_week = day_of_week
        self.start_hour_utc = start_hour_utc
        self.maintenance_window = maintenance_window
