!/* RMNLIB - Library of useful routines for C and FORTRAN programming
! * Copyright (C) 1975-2005  Environnement Canada
! *
! * This library is free software; you can redistribute it and/or
! * modify it under the terms of the GNU Lesser General Public
! * License as published by the Free Software Foundation,
! * version 2.1 of the License.
! *
! * This library is distributed in the hope that it will be useful,
! * but WITHOUT ANY WARRANTY; without even the implied warranty of
! * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
! * Lesser General Public License for more details.
! *
! * You should have received a copy of the GNU Lesser General Public
! * License along with this library; if not, write to the
! * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
! * Boston, MA 02111-1307, USA.
! */
subroutine bmf_splitname(pe_file,pex,pey,path,prefix,date,hour,min,sec)
!SUBROUTINE bmf_splitname(pe_file,pex,pey,path,prefix,date,&
! & hour,min,sec,num,numlen,unit), L. Corbeil
!
! ARGUMENTS
!
! IN
! npex    Number of processors for x axis
! npey    Number of processors for y axis
! path    Path to the splitted files   
! prefix   Prefix (character*2)
! date    date (integer, YYYYMMDD)
! hour    hours
! min     minutes
! sec     seconds
! num     multiple of unit;: optional
! numlen   number of digits for num, optional
! unit    1 character to represent type of units, optional
!
! Prefix, date, hour, min, sec, num, numlen and unit are passed directly
! to prog_filename: please refer to librmn documentation.
!  
! DESCRIPTION
! Routine which returns a filename generated by prog_filename
! for a BMF file (see also bmf_splitstart)

  implicit none
  integer pex,pey,date,hour,min,sec,num,numlen
  character*2 unit, prefix
  character* (*) path, pe_file
  integer ierr,prog_filename,fnom,longueur
  external prog_filename,fnom,longueur
  unit=''
  num=1
  numlen=-1
 
  ierr=prog_filename(pe_file,prefix,date,hour,min,sec, &
                     pex,pey,num,numlen,unit)
  if(ierr.ne.0) then
      write(*,*) 'BMF_SPLITNAME: Error prog_filename, abort'
      stop
  endif
!      write(*,*) i,split_unit(i),split_files(i)
  pe_file=pe_file(1:longueur(pe_file)-4)    
  pe_file=path(1:longueur(path))//'/'//pe_file
  return 
  end subroutine
