#!/usr/bin/env python
# -*- coding: utf-8 -*-

# CAVEAT UTILITOR
#
# This file was automatically generated by Grako.
#
#    https://pypi.python.org/pypi/grako/
#
# Any changes you make to it will be overwritten the next time
# the file is generated.


from __future__ import print_function, division, absolute_import, unicode_literals

from grako.buffering import Buffer
from grako.parsing import graken, Parser
from grako.util import re, RE_FLAGS, generic_main  # noqa


__all__ = [
    'shakespeareParser',
    'shakespeareSemantics',
    'main'
]

KEYWORDS = {}


class shakespeareBuffer(Buffer):
    def __init__(
        self,
        text,
        whitespace=None,
        nameguard=None,
        comments_re=None,
        eol_comments_re=None,
        ignorecase=True,
        namechars='',
        **kwargs
    ):
        super(shakespeareBuffer, self).__init__(
            text,
            whitespace=whitespace,
            nameguard=nameguard,
            comments_re=comments_re,
            eol_comments_re=eol_comments_re,
            ignorecase=ignorecase,
            namechars=namechars,
            **kwargs
        )


class shakespeareParser(Parser):
    def __init__(
        self,
        whitespace=None,
        nameguard=None,
        comments_re=None,
        eol_comments_re=None,
        ignorecase=True,
        left_recursion=False,
        parseinfo=True,
        keywords=None,
        namechars='',
        buffer_class=shakespeareBuffer,
        **kwargs
    ):
        if keywords is None:
            keywords = KEYWORDS
        super(shakespeareParser, self).__init__(
            whitespace=whitespace,
            nameguard=nameguard,
            comments_re=comments_re,
            eol_comments_re=eol_comments_re,
            ignorecase=ignorecase,
            left_recursion=left_recursion,
            parseinfo=parseinfo,
            keywords=keywords,
            namechars=namechars,
            buffer_class=buffer_class,
            **kwargs
        )

    @graken()
    def _be_(self):
        with self._choice():
            with self._option():
                self._token('am')
            with self._option():
                self._token('are')
            with self._option():
                self._token('art')
            with self._option():
                self._token('be')
            with self._option():
                self._token('is')
            self._error('expecting one of: am are art be is')

    @graken()
    def _article_(self):
        with self._choice():
            with self._option():
                self._token('a')
            with self._option():
                self._token('an')
            with self._option():
                self._token('the')
            self._error('expecting one of: a an the')

    @graken()
    def _first_person_(self):
        with self._choice():
            with self._option():
                self._token('I')
            with self._option():
                self._token('me')
            self._error('expecting one of: I me')

    @graken()
    def _first_person_reflexive_(self):
        self._token('myself')

    @graken()
    def _first_person_possessive_(self):
        with self._choice():
            with self._option():
                self._token('mine')
            with self._option():
                self._token('my')
            self._error('expecting one of: mine my')

    @graken()
    def _second_person_(self):
        with self._choice():
            with self._option():
                self._token('thee')
            with self._option():
                self._token('thou')
            with self._option():
                self._token('you')
            self._error('expecting one of: thee thou you')

    @graken()
    def _second_person_reflexive_(self):
        with self._choice():
            with self._option():
                self._token('thyself')
            with self._option():
                self._token('yourself')
            self._error('expecting one of: thyself yourself')

    @graken()
    def _second_person_possessive_(self):
        with self._choice():
            with self._option():
                self._token('thine')
            with self._option():
                self._token('thy')
            with self._option():
                self._token('your')
            self._error('expecting one of: thine thy your')

    @graken()
    def _third_person_possessive_(self):
        with self._choice():
            with self._option():
                self._token('his')
            with self._option():
                self._token('her')
            with self._option():
                self._token('its')
            with self._option():
                self._token('their')
            self._error('expecting one of: her his its their')

    @graken()
    def _possessive_(self):
        with self._choice():
            with self._option():
                self._first_person_possessive_()
            with self._option():
                self._second_person_possessive_()
            with self._option():
                self._third_person_possessive_()
            self._error('no available options')

    @graken()
    def _positive_comparative_(self):
        with self._group():
            with self._choice():
                with self._option():
                    self._token('better')
                with self._option():
                    self._token('bigger')
                with self._option():
                    self._token('fresher')
                with self._option():
                    self._token('friendlier')
                with self._option():
                    self._token('nicer')
                with self._option():
                    self._token('jollier')
                with self._option():
                    self._token('more')
                    self._positive_adjective_()
                self._error('expecting one of: better bigger fresher friendlier jollier nicer')
        self.name_last_node('comparison')
        self._token('than')
        self.ast._define(
            ['comparison'],
            []
        )

    @graken()
    def _negative_comparative_(self):
        with self._group():
            with self._choice():
                with self._option():
                    self._token('punier')
                with self._option():
                    self._token('smaller')
                with self._option():
                    self._token('worse')
                with self._option():
                    self._token('more')
                    self._negative_adjective_()
                self._error('expecting one of: punier smaller worse')
        self.name_last_node('comparison')
        self._token('than')
        self.ast._define(
            ['comparison'],
            []
        )

    @graken()
    def _negative_adjective_(self):
        with self._choice():
            with self._option():
                self._token('bad')
            with self._option():
                self._token('cowardly')
            with self._option():
                self._token('cursed')
            with self._option():
                self._token('damned')
            with self._option():
                self._token('dirty')
            with self._option():
                self._token('disgusting')
            with self._option():
                self._token('distasteful')
            with self._option():
                self._token('dusty')
            with self._option():
                self._token('evil')
            with self._option():
                self._token('fat')
            with self._option():
                self._token('fat-kidneyed')
            with self._option():
                self._token('fatherless')
            with self._option():
                self._token('foul')
            with self._option():
                self._token('hairy')
            with self._option():
                self._token('half-witted')
            with self._option():
                self._token('horrible')
            with self._option():
                self._token('horrid')
            with self._option():
                self._token('infected')
            with self._option():
                self._token('lying')
            with self._option():
                self._token('miserable')
            with self._option():
                self._token('misused')
            with self._option():
                self._token('oozing')
            with self._option():
                self._token('rotten')
            with self._option():
                self._token('rotten')
            with self._option():
                self._token('smelly')
            with self._option():
                self._token('snotty')
            with self._option():
                self._token('sorry')
            with self._option():
                self._token('stinking')
            with self._option():
                self._token('stuffed')
            with self._option():
                self._token('stupid')
            with self._option():
                self._token('vile')
            with self._option():
                self._token('villainous')
            with self._option():
                self._token('worried')
            self._error('expecting one of: bad cowardly cursed damned dirty disgusting distasteful dusty evil fat fat-kidneyed fatherless foul hairy half-witted horrible horrid infected lying miserable misused oozing rotten smelly snotty sorry stinking stuffed stupid vile villainous worried')

    @graken()
    def _neutral_adjective_(self):
        with self._choice():
            with self._option():
                self._token('big')
            with self._option():
                self._token('black')
            with self._option():
                self._token('blue')
            with self._option():
                self._token('bluest')
            with self._option():
                self._token('bottomless')
            with self._option():
                self._token('furry')
            with self._option():
                self._token('green')
            with self._option():
                self._token('hard')
            with self._option():
                self._token('huge')
            with self._option():
                self._token('large')
            with self._option():
                self._token('little')
            with self._option():
                self._token('normal')
            with self._option():
                self._token('old')
            with self._option():
                self._token('purple')
            with self._option():
                self._token('red')
            with self._option():
                self._token('rural')
            with self._option():
                self._token('small')
            with self._option():
                self._token('tiny')
            with self._option():
                self._token('white')
            with self._option():
                self._token('yellow')
            self._error('expecting one of: big black blue bluest bottomless furry green hard huge large little normal old purple red rural small tiny white yellow')

    @graken()
    def _positive_adjective_(self):
        with self._choice():
            with self._option():
                self._token('amazing')
            with self._option():
                self._token('beautiful')
            with self._option():
                self._token('blossoming')
            with self._option():
                self._token('bold')
            with self._option():
                self._token('brave')
            with self._option():
                self._token('charming')
            with self._option():
                self._token('clearest')
            with self._option():
                self._token('cunning')
            with self._option():
                self._token('cute')
            with self._option():
                self._token('delicious')
            with self._option():
                self._token('embroidered')
            with self._option():
                self._token('fair')
            with self._option():
                self._token('fine')
            with self._option():
                self._token('gentle')
            with self._option():
                self._token('golden')
            with self._option():
                self._token('good')
            with self._option():
                self._token('handsome')
            with self._option():
                self._token('happy')
            with self._option():
                self._token('healthy')
            with self._option():
                self._token('honest')
            with self._option():
                self._token('lovely')
            with self._option():
                self._token('loving')
            with self._option():
                self._token('mighty')
            with self._option():
                self._token('noble')
            with self._option():
                self._token('peaceful')
            with self._option():
                self._token('pretty')
            with self._option():
                self._token('prompt')
            with self._option():
                self._token('proud')
            with self._option():
                self._token('reddest')
            with self._option():
                self._token('rich')
            with self._option():
                self._token('smooth')
            with self._option():
                self._token('sunny')
            with self._option():
                self._token('sweet')
            with self._option():
                self._token('sweetest')
            with self._option():
                self._token('trustworthy')
            with self._option():
                self._token('warm')
            self._error('expecting one of: amazing beautiful blossoming bold brave charming clearest cunning cute delicious embroidered fair fine gentle golden good handsome happy healthy honest lovely loving mighty noble peaceful pretty prompt proud reddest rich smooth sunny sweet sweetest trustworthy warm')

    @graken()
    def _negative_noun_(self):
        with self._choice():
            with self._option():
                self._token('Hell')
            with self._option():
                self._token('Microsoft')
            with self._option():
                self._token('bastard')
            with self._option():
                self._token('beggar')
            with self._option():
                self._token('blister')
            with self._option():
                self._token('codpiece')
            with self._option():
                self._token('coward')
            with self._option():
                self._token('curse')
            with self._option():
                self._token('death')
            with self._option():
                self._token('devil')
            with self._option():
                self._token('draught')
            with self._option():
                self._token('famine')
            with self._option():
                self._token('flirt-gill')
            with self._option():
                self._token('goat')
            with self._option():
                self._token('hate')
            with self._option():
                self._token('hog')
            with self._option():
                self._token('hound')
            with self._option():
                self._token('leech')
            with self._option():
                self._token('lie')
            with self._option():
                self._token('pig')
            with self._option():
                self._token('plague')
            with self._option():
                self._token('starvation')
            with self._option():
                self._token('toad')
            with self._option():
                self._token('war')
            with self._option():
                self._token('wolf')
            self._error('expecting one of: Hell Microsoft bastard beggar blister codpiece coward curse death devil draught famine flirt-gill goat hate hog hound leech lie pig plague starvation toad war wolf')

    @graken()
    def _neutral_noun_(self):
        with self._choice():
            with self._option():
                self._token('animal')
            with self._option():
                self._token('aunt')
            with self._option():
                self._token('brother')
            with self._option():
                self._token('cat')
            with self._option():
                self._token('chihuahua')
            with self._option():
                self._token('cousin')
            with self._option():
                self._token('cow')
            with self._option():
                self._token('daughter')
            with self._option():
                self._token('door')
            with self._option():
                self._token('face')
            with self._option():
                self._token('father')
            with self._option():
                self._token('fellow')
            with self._option():
                self._token('granddaughter')
            with self._option():
                self._token('grandfather')
            with self._option():
                self._token('grandmother')
            with self._option():
                self._token('grandson')
            with self._option():
                self._token('hair')
            with self._option():
                self._token('hamster')
            with self._option():
                self._token('horse')
            with self._option():
                self._token('lamp')
            with self._option():
                self._token('lantern')
            with self._option():
                self._token('mistletoe')
            with self._option():
                self._token('moon')
            with self._option():
                self._token('morning')
            with self._option():
                self._token('mother')
            with self._option():
                self._token('nephew')
            with self._option():
                self._token('niece')
            with self._option():
                self._token('nose')
            with self._option():
                self._token('purse')
            with self._option():
                self._token('road')
            with self._option():
                self._token('roman')
            with self._option():
                self._token('sister')
            with self._option():
                self._token('sky')
            with self._option():
                self._token('son')
            with self._option():
                self._token('squirrel')
            with self._option():
                self._token('stone')
                self._token('wall')
            with self._option():
                self._token('thing')
            with self._option():
                self._token('town')
            with self._option():
                self._token('tree')
            with self._option():
                self._token('uncle')
            with self._option():
                self._token('wind')
            self._error('expecting one of: animal aunt brother cat chihuahua cousin cow daughter door face father fellow granddaughter grandfather grandmother grandson hair hamster horse lamp lantern mistletoe moon morning mother nephew niece nose purse road roman sister sky son squirrel stone thing town tree uncle wind')

    @graken()
    def _positive_noun_(self):
        with self._choice():
            with self._option():
                self._token('Heaven')
            with self._option():
                self._token('King')
            with self._option():
                self._token('Lord')
            with self._option():
                self._token('angel')
            with self._option():
                self._token('flower')
            with self._option():
                self._token('happiness')
            with self._option():
                self._token('joy')
            with self._option():
                self._token('plum')
            with self._option():
                self._token("summer's")
                self._token('day')
            with self._option():
                self._token('hero')
            with self._option():
                self._token('rose')
            with self._option():
                self._token('kingdom')
            with self._option():
                self._token('pony')
            self._error("expecting one of: Heaven King Lord angel flower happiness hero joy kingdom plum pony rose summer's")

    @graken()
    def _character_(self):
        with self._choice():
            with self._option():
                self._token('Achilles')
            with self._option():
                self._token('Adonis')
            with self._option():
                self._token('Adriana')
            with self._option():
                self._token('Aegeon')
            with self._option():
                self._token('Aemilia')
            with self._option():
                self._token('Agamemnon')
            with self._option():
                self._token('Agrippa')
            with self._option():
                self._token('Ajax')
            with self._option():
                self._token('Alonso')
            with self._option():
                self._token('Andromache')
            with self._option():
                self._token('Angelo')
            with self._option():
                self._token('Antiochus')
            with self._option():
                self._token('Antonio')
            with self._option():
                self._token('Arthur')
            with self._option():
                self._token('Autolycus')
            with self._option():
                self._token('Balthazar')
            with self._option():
                self._token('Banquo')
            with self._option():
                self._token('Beatrice')
            with self._option():
                self._token('Benedick')
            with self._option():
                self._token('Benvolio')
            with self._option():
                self._token('Bianca')
            with self._option():
                self._token('Brabantio')
            with self._option():
                self._token('Brutus')
            with self._option():
                self._token('Capulet')
            with self._option():
                self._token('Cassandra')
            with self._option():
                self._token('Cassius')
            with self._option():
                self._token('Christopher')
                self._token('Sly')
            with self._option():
                self._token('Cicero')
            with self._option():
                self._token('Claudio')
            with self._option():
                self._token('Claudius')
            with self._option():
                self._token('Cleopatra')
            with self._option():
                self._token('Cordelia')
            with self._option():
                self._token('Cornelius')
            with self._option():
                self._token('Cressida')
            with self._option():
                self._token('Cymberline')
            with self._option():
                self._token('Demetrius')
            with self._option():
                self._token('Desdemona')
            with self._option():
                self._token('Dionyza')
            with self._option():
                self._token('Doctor')
                self._token('Caius')
            with self._option():
                self._token('Dogberry')
            with self._option():
                self._token('Don')
                self._token('John')
            with self._option():
                self._token('Don')
                self._token('Pedro')
            with self._option():
                self._token('Donalbain')
            with self._option():
                self._token('Dorcas')
            with self._option():
                self._token('Duncan')
            with self._option():
                self._token('Egeus')
            with self._option():
                self._token('Emilia')
            with self._option():
                self._token('Escalus')
            with self._option():
                self._token('Falstaff')
            with self._option():
                self._token('Fenton')
            with self._option():
                self._token('Ferdinand')
            with self._option():
                self._token('Ford')
            with self._option():
                self._token('Fortinbras')
            with self._option():
                self._token('Francisca')
            with self._option():
                self._token('Friar')
                self._token('John')
            with self._option():
                self._token('Friar')
                self._token('Laurence')
            with self._option():
                self._token('Gertrude')
            with self._option():
                self._token('Goneril')
            with self._option():
                self._token('Hamlet')
            with self._option():
                self._token('Hecate')
            with self._option():
                self._token('Hector')
            with self._option():
                self._token('Helen')
            with self._option():
                self._token('Helena')
            with self._option():
                self._token('Hermia')
            with self._option():
                self._token('Hermonie')
            with self._option():
                self._token('Hippolyta')
            with self._option():
                self._token('Horatio')
            with self._option():
                self._token('Imogen')
            with self._option():
                self._token('Isabella')
            with self._option():
                self._token('John')
                self._token('of')
                self._token('Gaunt')
            with self._option():
                self._token('John')
                self._token('of')
                self._token('Lancaster')
            with self._option():
                self._token('Julia')
            with self._option():
                self._token('Juliet')
            with self._option():
                self._token('Julius')
                self._token('Caesar')
            with self._option():
                self._token('King')
                self._token('Henry')
            with self._option():
                self._token('King')
                self._token('John')
            with self._option():
                self._token('King')
                self._token('Lear')
            with self._option():
                self._token('King')
                self._token('Richard')
            with self._option():
                self._token('Lady')
                self._token('Capulet')
            with self._option():
                self._token('Lady')
                self._token('Macbeth')
            with self._option():
                self._token('Lady')
                self._token('Macduff')
            with self._option():
                self._token('Lady')
                self._token('Montague')
            with self._option():
                self._token('Lennox')
            with self._option():
                self._token('Leonato')
            with self._option():
                self._token('Luciana')
            with self._option():
                self._token('Lucio')
            with self._option():
                self._token('Lychorida')
            with self._option():
                self._token('Lysander')
            with self._option():
                self._token('Macbeth')
            with self._option():
                self._token('Macduff')
            with self._option():
                self._token('Malcolm')
            with self._option():
                self._token('Mariana')
            with self._option():
                self._token('Mark')
                self._token('Antony')
            with self._option():
                self._token('Mercutio')
            with self._option():
                self._token('Miranda')
            with self._option():
                self._token('Mistress')
                self._token('Ford')
            with self._option():
                self._token('Mistress')
                self._token('Overdone')
            with self._option():
                self._token('Mistress')
                self._token('Page')
            with self._option():
                self._token('Montague')
            with self._option():
                self._token('Mopsa')
            with self._option():
                self._token('Oberon')
            with self._option():
                self._token('Octavia')
            with self._option():
                self._token('Octavius')
                self._token('Caesar')
            with self._option():
                self._token('Olivia')
            with self._option():
                self._token('Ophelia')
            with self._option():
                self._token('Orlando')
            with self._option():
                self._token('Orsino')
            with self._option():
                self._token('Othello')
            with self._option():
                self._token('Page')
            with self._option():
                self._token('Pantino')
            with self._option():
                self._token('Paris')
            with self._option():
                self._token('Pericles')
            with self._option():
                self._token('Pinch')
            with self._option():
                self._token('Polonius')
            with self._option():
                self._token('Pompeius')
            with self._option():
                self._token('Portia')
            with self._option():
                self._token('Priam')
            with self._option():
                self._token('Prince')
                self._token('Henry')
            with self._option():
                self._token('Prospero')
            with self._option():
                self._token('Proteus')
            with self._option():
                self._token('Publius')
            with self._option():
                self._token('Puck')
            with self._option():
                self._token('Queen')
                self._token('Elinor')
            with self._option():
                self._token('Regan')
            with self._option():
                self._token('Robin')
            with self._option():
                self._token('Romeo')
            with self._option():
                self._token('Rosalind')
            with self._option():
                self._token('Sebastian')
            with self._option():
                self._token('Shallow')
            with self._option():
                self._token('Shylock')
            with self._option():
                self._token('Slender')
            with self._option():
                self._token('Solinus')
            with self._option():
                self._token('Stephano')
            with self._option():
                self._token('Thaisa')
            with self._option():
                self._token('The')
                self._token('Abbot')
                self._token('of')
                self._token('Westminster')
            with self._option():
                self._token('The')
                self._token('Apothecary')
            with self._option():
                self._token('The')
                self._token('Archbishop')
                self._token('of')
                self._token('Canterbury')
            with self._option():
                self._token('The')
                self._token('Duke')
                self._token('of')
                self._token('Milan')
            with self._option():
                self._token('The')
                self._token('Duke')
                self._token('of')
                self._token('Venice')
            with self._option():
                self._token('The')
                self._token('Ghost')
            with self._option():
                self._token('Theseus')
            with self._option():
                self._token('Thurio')
            with self._option():
                self._token('Timon')
            with self._option():
                self._token('Titania')
            with self._option():
                self._token('Titus')
            with self._option():
                self._token('Troilus')
            with self._option():
                self._token('Tybalt')
            with self._option():
                self._token('Ulysses')
            with self._option():
                self._token('Valentine')
            with self._option():
                self._token('Venus')
            with self._option():
                self._token('Vincentio')
            with self._option():
                self._token('Viola')
            self._error('expecting one of: Achilles Adonis Adriana Aegeon Aemilia Agamemnon Agrippa Ajax Alonso Andromache Angelo Antiochus Antonio Arthur Autolycus Balthazar Banquo Beatrice Benedick Benvolio Bianca Brabantio Brutus Capulet Cassandra Cassius Christopher Cicero Claudio Claudius Cleopatra Cordelia Cornelius Cressida Cymberline Demetrius Desdemona Dionyza Doctor Dogberry Don Donalbain Dorcas Duncan Egeus Emilia Escalus Falstaff Fenton Ferdinand Ford Fortinbras Francisca Friar Gertrude Goneril Hamlet Hecate Hector Helen Helena Hermia Hermonie Hippolyta Horatio Imogen Isabella John Julia Juliet Julius King Lady Lennox Leonato Luciana Lucio Lychorida Lysander Macbeth Macduff Malcolm Mariana Mark Mercutio Miranda Mistress Montague Mopsa Oberon Octavia Octavius Olivia Ophelia Orlando Orsino Othello Page Pantino Paris Pericles Pinch Polonius Pompeius Portia Priam Prince Prospero Proteus Publius Puck Queen Regan Robin Romeo Rosalind Sebastian Shallow Shylock Slender Solinus Stephano Thaisa The Theseus Thurio Timon Titania Titus Troilus Tybalt Ulysses Valentine Venus Vincentio Viola')

    @graken()
    def _nothing_(self):
        with self._group():
            with self._choice():
                with self._option():
                    self._token('nothing')
                with self._option():
                    self._token('zero')
                self._error('expecting one of: nothing zero')
        self.name_last_node('nothing_word')
        self.ast._define(
            ['nothing_word'],
            []
        )

    @graken()
    def _positive_or_neutral_adjective_(self):
        with self._choice():
            with self._option():
                self._positive_adjective_()
            with self._option():
                self._neutral_adjective_()
            self._error('no available options')

    @graken()
    def _positive_or_neutral_noun_(self):
        with self._choice():
            with self._option():
                self._positive_noun_()
            with self._option():
                self._neutral_noun_()
            self._error('no available options')

    @graken()
    def _neutral_comparative_(self):
        self._token('as')
        with self._group():
            with self._choice():
                with self._option():
                    self._negative_adjective_()
                with self._option():
                    self._positive_or_neutral_adjective_()
                self._error('no available options')
        self.name_last_node('comparison')
        self._token('as')
        self.ast._define(
            ['comparison'],
            []
        )

    @graken()
    def _negative_noun_phrase_(self):
        with self._optional():
            with self._choice():
                with self._option():
                    self._article_()
                with self._option():
                    self._possessive_()
                self._error('no available options')

        def block2():
            with self._group():
                with self._choice():
                    with self._option():
                        self._negative_adjective_()
                    with self._option():
                        self._neutral_adjective_()
                    self._error('no available options')
        self._closure(block2)
        self.name_last_node('adjectives')
        self._negative_noun_()
        self.name_last_node('noun')
        self.ast._define(
            ['adjectives', 'noun'],
            []
        )

    @graken()
    def _positive_noun_phrase_(self):
        with self._optional():
            with self._choice():
                with self._option():
                    self._article_()
                with self._option():
                    self._possessive_()
                self._error('no available options')

        def block2():
            self._positive_or_neutral_adjective_()
        self._closure(block2)
        self.name_last_node('adjectives')
        self._positive_or_neutral_noun_()
        self.name_last_node('noun')
        self.ast._define(
            ['adjectives', 'noun'],
            []
        )

    @graken()
    def _noun_phrase_(self):
        with self._choice():
            with self._option():
                self._negative_noun_phrase_()
            with self._option():
                self._positive_noun_phrase_()
            self._error('no available options')

    @graken()
    def _first_person_value_(self):
        with self._group():
            with self._choice():
                with self._option():
                    self._first_person_()
                with self._option():
                    self._first_person_reflexive_()
                self._error('no available options')
        self.name_last_node('first_person_word')
        self.ast._define(
            ['first_person_word'],
            []
        )

    @graken()
    def _second_person_value_(self):
        with self._group():
            with self._choice():
                with self._option():
                    self._second_person_()
                with self._option():
                    self._second_person_reflexive_()
                self._error('no available options')
        self.name_last_node('second_person_word')
        self.ast._define(
            ['second_person_word'],
            []
        )

    @graken()
    def _character_name_(self):
        self._character_()
        self.name_last_node('name')
        self.ast._define(
            ['name'],
            []
        )

    @graken()
    def _value_(self):
        with self._choice():
            with self._option():
                self._expression_()
            with self._option():
                self._first_person_value_()
            with self._option():
                self._second_person_value_()
            with self._option():
                self._noun_phrase_()
            with self._option():
                self._character_name_()
            with self._option():
                self._nothing_()
            self._error('no available options')

    @graken()
    def _binary_operation_(self):
        with self._choice():
            with self._option():
                self._token('the')
                self._token('difference')
                self._token('between')
            with self._option():
                self._token('the')
                self._token('product')
                self._token('of')
            with self._option():
                self._token('the')
                self._token('quotient')
                self._token('between')
            with self._option():
                self._token('the')
                self._token('remainder')
                self._token('of')
                self._token('the')
                self._token('quotient')
                self._token('between')
            with self._option():
                self._token('the')
                self._token('sum')
                self._token('of')
            self._error('expecting one of: the')

    @graken()
    def _binary_expression_(self):
        self._binary_operation_()
        self.name_last_node('operation')
        self._value_()
        self.name_last_node('first_value')
        self._token('and')
        self._value_()
        self.name_last_node('second_value')
        self.ast._define(
            ['first_value', 'operation', 'second_value'],
            []
        )

    @graken()
    def _unary_operation_(self):
        with self._choice():
            with self._option():
                self._token('the')
                self._token('cube')
                self._token('of')
            with self._option():
                self._token('the')
                self._token('factorial')
                self._token('of')
            with self._option():
                self._token('the')
                self._token('square')
                self._token('of')
            with self._option():
                self._token('the')
                self._token('square')
                self._token('root')
                self._token('of')
            with self._option():
                self._token('twice')
            self._error('expecting one of: the twice')

    @graken()
    def _unary_expression_(self):
        self._unary_operation_()
        self.name_last_node('operation')
        self._value_()
        self.name_last_node('value')
        self.ast._define(
            ['operation', 'value'],
            []
        )

    @graken()
    def _expression_(self):
        with self._choice():
            with self._option():
                self._binary_expression_()
            with self._option():
                self._unary_expression_()
            self._error('no available options')

    @graken()
    def _negative_if_(self):
        with self._group():
            self._token('If')
            self._token('not,')
        self.name_last_node('if_')
        self.ast._define(
            ['if_'],
            []
        )

    @graken()
    def _positive_if_(self):
        with self._group():
            self._token('If')
            self._token('so,')
        self.name_last_node('if_')
        self.ast._define(
            ['if_'],
            []
        )

    @graken()
    def _question_(self):
        self._be_()
        self._value_()
        self.name_last_node('first_value')
        with self._group():
            with self._choice():
                with self._option():
                    self._positive_comparative_()
                with self._option():
                    self._neutral_comparative_()
                with self._option():
                    self._negative_comparative_()
                self._error('no available options')
        self.name_last_node('comparative')
        self._value_()
        self.name_last_node('second_value')
        self._token('?')
        self.ast._define(
            ['comparative', 'first_value', 'second_value'],
            []
        )

    @graken()
    def _assignment_(self):
        self._second_person_()
        with self._optional():
            self._be_()
        with self._optional():
            self._token('as')
            with self._optional():
                with self._group():
                    with self._choice():
                        with self._option():
                            self._positive_or_neutral_adjective_()
                        with self._option():
                            self._negative_adjective_()
                        self._error('no available options')
                self._token('as')
        self._value_()
        self.name_last_node('value')
        with self._group():
            with self._choice():
                with self._option():
                    self._token('!')
                with self._option():
                    self._token('.')
                self._error('expecting one of: ! .')
        self.ast._define(
            ['value'],
            []
        )

    @graken()
    def _let_us_(self):
        with self._choice():
            with self._option():
                self._token('Let')
                self._token('us')
            with self._option():
                self._token('We')
                self._token('shall')
            with self._option():
                self._token('We')
                self._token('must')
            self._error('expecting one of: Let We')

    @graken()
    def _proceed_to_(self):
        with self._choice():
            with self._option():
                self._token('proceed')
                self._token('to')
            with self._option():
                self._token('return')
                self._token('to')
            self._error('expecting one of: proceed return')

    @graken()
    def _roman_numeral_(self):
        self._pattern(r'M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})')

    @graken()
    def _goto_(self):
        with self._optional():
            with self._choice():
                with self._option():
                    self._negative_if_()
                with self._option():
                    self._positive_if_()
                self._error('no available options')
        self.name_last_node('condition')
        self._let_us_()
        self._proceed_to_()
        self._token('scene')
        self._roman_numeral_()
        self.name_last_node('destination')
        with self._group():
            with self._choice():
                with self._option():
                    self._token('!')
                with self._option():
                    self._token('.')
                self._error('expecting one of: ! .')
        self.ast._define(
            ['condition', 'destination'],
            []
        )

    @graken()
    def _output_(self):
        with self._group():
            with self._choice():
                with self._option():
                    with self._group():
                        self._token('open')
                        self._second_person_possessive_()
                        self._token('heart')
                    self.name_last_node('output_number')
                with self._option():
                    with self._group():
                        self._token('speak')
                        self._second_person_possessive_()
                        self._token('mind')
                    self.name_last_node('output_char')
                self._error('no available options')
        with self._group():
            with self._choice():
                with self._option():
                    self._token('!')
                with self._option():
                    self._token('.')
                self._error('expecting one of: ! .')
        self.ast._define(
            ['output_char', 'output_number'],
            []
        )

    @graken()
    def _input_(self):
        with self._group():
            with self._choice():
                with self._option():
                    with self._group():
                        self._token('listen')
                        self._token('to')
                        self._second_person_possessive_()
                        self._token('heart')
                    self.name_last_node('input_number')
                with self._option():
                    with self._group():
                        self._token('open')
                        self._second_person_possessive_()
                        self._token('mind')
                    self.name_last_node('input_char')
                self._error('no available options')
        with self._group():
            with self._choice():
                with self._option():
                    self._token('!')
                with self._option():
                    self._token('.')
                self._error('expecting one of: ! .')
        self.ast._define(
            ['input_char', 'input_number'],
            []
        )

    @graken()
    def _push_(self):
        self._token('Remember')
        self._value_()
        self.name_last_node('value')
        with self._group():
            with self._choice():
                with self._option():
                    self._token('!')
                with self._option():
                    self._token('.')
                self._error('expecting one of: ! .')
        self.ast._define(
            ['value'],
            []
        )

    @graken()
    def _pop_(self):
        self._token('Recall')
        self._text_before_punctuation_()
        self.name_last_node('recall_string')
        with self._group():
            with self._choice():
                with self._option():
                    self._token('!')
                with self._option():
                    self._token('.')
                self._error('expecting one of: ! .')
        self.ast._define(
            ['recall_string'],
            []
        )

    @graken()
    def _sentence_(self):
        with self._choice():
            with self._option():
                self._question_()
            with self._option():
                self._assignment_()
            with self._option():
                self._goto_()
            with self._option():
                self._output_()
            with self._option():
                self._input_()
            with self._option():
                self._push_()
            with self._option():
                self._pop_()
            self._error('no available options')

    @graken()
    def _line_(self):
        self._character_()
        self.name_last_node('character')
        self._token(':')
        with self._group():

            def block2():
                self._sentence_()
            self._positive_closure(block2)
        self.name_last_node('contents')
        self.ast._define(
            ['character', 'contents'],
            []
        )

    @graken()
    def _character_list_(self):
        with self._choice():
            with self._option():
                self._character_()
                self.add_last_node_to_name('@')

                def block1():
                    self._token(',')
                    self._character_()
                    self.add_last_node_to_name('@')
                self._closure(block1)
                self._token('and')
                self._character_()
                self.add_last_node_to_name('@')
            with self._option():
                self._character_()
                self.add_last_node_to_name('@')
            self._error('no available options')

    @graken()
    def _breakpoint_(self):
        with self._group():
            self._token('[')
            self._token('A')
            self._token('pause')
            self._token(']')
        self.name_last_node('dummy')
        self.ast._define(
            ['dummy'],
            []
        )

    @graken()
    def _entrance_(self):
        self._token('[')
        self._token('Enter')
        self._character_list_()
        self.name_last_node('characters')
        self._token(']')
        self.ast._define(
            ['characters'],
            []
        )

    @graken()
    def _exit_(self):
        self._token('[')
        self._token('Exit')
        self._character_()
        self.name_last_node('character')
        self._token(']')
        self.ast._define(
            ['character'],
            []
        )

    @graken()
    def _exeunt_(self):
        self._token('[')
        self._token('Exeunt')
        self.name_last_node('action')
        with self._optional():
            self._character_list_()
            self.name_last_node('characters')
        self._token(']')
        self.ast._define(
            ['action', 'characters'],
            []
        )

    @graken()
    def _event_(self):
        with self._choice():
            with self._option():
                self._line_()
            with self._option():
                self._breakpoint_()
            with self._option():
                self._entrance_()
            with self._option():
                self._exit_()
            with self._option():
                self._exeunt_()
            self._error('no available options')

    @graken()
    def _repl_input_(self):
        with self._choice():
            with self._option():
                with self._ifnot():
                    with self._group():
                        self._character_()
                        self._token(':')
                self._character_()
                self.name_last_node('character')
                self._check_eof()
            with self._option():
                with self._ifnot():
                    with self._group():
                        self._character_()
                        self._token(':')
                        self._pattern(r'.*\.')
                with self._optional():
                    self._character_()
                    self.name_last_node('character')
                    self._token(':')
                self._value_()
                self.name_last_node('value')
                self._check_eof()
            with self._option():
                self._event_()
                self.name_last_node('event')
                self._check_eof()
            with self._option():
                with self._group():

                    def block5():
                        self._sentence_()
                    self._positive_closure(block5)
                self.name_last_node('sentences')
                self._check_eof()
            self._error('no available options')
        self.ast._define(
            ['character', 'event', 'sentences', 'value'],
            []
        )

    @graken()
    def _text_before_punctuation_(self):
        self._pattern(r'[^!\.]*')

    @graken()
    def _scene_(self):
        self._token('Scene')
        self._roman_numeral_()
        self.name_last_node('number')
        self._token(':')
        self._text_before_punctuation_()
        self.name_last_node('name')
        with self._group():
            with self._choice():
                with self._option():
                    self._token('!')
                with self._option():
                    self._token('.')
                self._error('expecting one of: ! .')
        with self._group():

            def block4():
                self._event_()
            self._closure(block4)
        self.name_last_node('events')
        self.ast._define(
            ['events', 'name', 'number'],
            []
        )

    @graken()
    def _act_(self):
        self._token('Act')
        self._roman_numeral_()
        self.name_last_node('number')
        self._token(':')
        self._text_before_punctuation_()
        self.name_last_node('name')
        with self._group():
            with self._choice():
                with self._option():
                    self._token('!')
                with self._option():
                    self._token('.')
                self._error('expecting one of: ! .')
        with self._group():

            def block4():
                self._scene_()
            self._closure(block4)
        self.name_last_node('scenes')
        self.ast._define(
            ['name', 'number', 'scenes'],
            []
        )

    @graken()
    def _dramatis_personae_(self):
        self._character_()
        self.name_last_node('character')
        self._token(',')
        self._text_before_punctuation_()
        with self._group():
            with self._choice():
                with self._option():
                    self._token('!')
                with self._option():
                    self._token('.')
                self._error('expecting one of: ! .')
        self.ast._define(
            ['character'],
            []
        )

    @graken()
    def _play_(self):
        self._text_before_punctuation_()
        self.name_last_node('title')
        with self._group():
            with self._choice():
                with self._option():
                    self._token('!')
                with self._option():
                    self._token('.')
                self._error('expecting one of: ! .')

        def block3():
            self._dramatis_personae_()
        self._closure(block3)
        self.name_last_node('dramatis_personae')
        with self._group():

            def block5():
                self._act_()
            self._closure(block5)
        self.name_last_node('acts')
        self._check_eof()
        self.ast._define(
            ['acts', 'dramatis_personae', 'title'],
            []
        )


class shakespeareSemantics(object):
    def be(self, ast):
        return ast

    def article(self, ast):
        return ast

    def first_person(self, ast):
        return ast

    def first_person_reflexive(self, ast):
        return ast

    def first_person_possessive(self, ast):
        return ast

    def second_person(self, ast):
        return ast

    def second_person_reflexive(self, ast):
        return ast

    def second_person_possessive(self, ast):
        return ast

    def third_person_possessive(self, ast):
        return ast

    def possessive(self, ast):
        return ast

    def positive_comparative(self, ast):
        return ast

    def negative_comparative(self, ast):
        return ast

    def negative_adjective(self, ast):
        return ast

    def neutral_adjective(self, ast):
        return ast

    def positive_adjective(self, ast):
        return ast

    def negative_noun(self, ast):
        return ast

    def neutral_noun(self, ast):
        return ast

    def positive_noun(self, ast):
        return ast

    def character(self, ast):
        return ast

    def nothing(self, ast):
        return ast

    def positive_or_neutral_adjective(self, ast):
        return ast

    def positive_or_neutral_noun(self, ast):
        return ast

    def neutral_comparative(self, ast):
        return ast

    def negative_noun_phrase(self, ast):
        return ast

    def positive_noun_phrase(self, ast):
        return ast

    def noun_phrase(self, ast):
        return ast

    def first_person_value(self, ast):
        return ast

    def second_person_value(self, ast):
        return ast

    def character_name(self, ast):
        return ast

    def value(self, ast):
        return ast

    def binary_operation(self, ast):
        return ast

    def binary_expression(self, ast):
        return ast

    def unary_operation(self, ast):
        return ast

    def unary_expression(self, ast):
        return ast

    def expression(self, ast):
        return ast

    def negative_if(self, ast):
        return ast

    def positive_if(self, ast):
        return ast

    def question(self, ast):
        return ast

    def assignment(self, ast):
        return ast

    def let_us(self, ast):
        return ast

    def proceed_to(self, ast):
        return ast

    def roman_numeral(self, ast):
        return ast

    def goto(self, ast):
        return ast

    def output(self, ast):
        return ast

    def input(self, ast):
        return ast

    def push(self, ast):
        return ast

    def pop(self, ast):
        return ast

    def sentence(self, ast):
        return ast

    def line(self, ast):
        return ast

    def character_list(self, ast):
        return ast

    def breakpoint(self, ast):
        return ast

    def entrance(self, ast):
        return ast

    def exit(self, ast):
        return ast

    def exeunt(self, ast):
        return ast

    def event(self, ast):
        return ast

    def repl_input(self, ast):
        return ast

    def text_before_punctuation(self, ast):
        return ast

    def scene(self, ast):
        return ast

    def act(self, ast):
        return ast

    def dramatis_personae(self, ast):
        return ast

    def play(self, ast):
        return ast


def main(filename, startrule, **kwargs):
    with open(filename) as f:
        text = f.read()
    parser = shakespeareParser(parseinfo=False)
    return parser.parse(text, startrule, filename=filename, **kwargs)


if __name__ == '__main__':
    import json
    ast = generic_main(main, shakespeareParser, name='shakespeare')
    print('AST:')
    print(ast)
    print()
    print('JSON:')
    print(json.dumps(ast, indent=2))
    print()
