class AthleteList(list):
    def __init__(self, a_name, a_dob=None, a_times=[]):
        list.__init__([])
        self.name=a_name
        self.dob=a_dob
        self.extend(a_times)
    
    def top3(self):
        return sorted(set(sanitize(t) for t in self))[0:3]

def sanitize(time_string):
    if '-' in time_string:
        splitter = '-'
    elif ':' in time_string:
        splitter = ':'
    else:
        return time_string
    (mins, secs) = time_string.split(splitter)
    return (mins + '.' + secs)


def get_coach_data(file_name):
    try:
        with open(file_name) as array:
            array = array.readline().strip().split(',')
            return AthleteList(array.pop(0), array.pop(0), array)
    except IOError as err:
        print('IOError: ' + str(err))
        return (None)

james = get_coach_data('james2.txt')
julie = get_coach_data('julie2.txt')
mikey = get_coach_data('mikey2.txt')
sarah = get_coach_data('sarah2.txt')

print(james.name + "'s fastest times are: '" + str(james.top3()))
print(julie.name + "'s fastest times are: '" + str(julie.top3()))
print(mikey.name + "'s fastest times are: '" + str(mikey.top3()))
print(sarah.name + "'s fastest times are: '" + str(sarah.top3()))
