from flopy.mbase import BaseModel, Package
from .mtadv import Mt3dAdv
from .mtbtn import Mt3dBtn
from .mtdsp import Mt3dDsp
from .mtgcg import Mt3dGcg
from .mtphc import Mt3dPhc
from .mtrct import Mt3dRct
from .mtssm import Mt3dSsm
from .mttob import Mt3dTob
import os

class Mt3dList(Package):
    '''
    List package class
    '''
    def __init__(self, model, extension='list', listunit=7):
        #Call ancestor's init to set self.parent, extension, name and 
        #unit number
        Package.__init__(self, model, extension, 'LIST', listunit)
        #self.parent.add_package(self) This package is not added to the base 
        #model so that it is not included in get_name_file_entries()
        return

    def __repr__( self ):
        return 'List package class'

    def write_file(self):
    	# Not implemented for list class
    	return


class Mt3dms(BaseModel):
    'MT3DMS base class'
    def __init__(self, modelname='mt3dmstest', namefile_ext='nam',
                 modflowmodel=None, ftlfilename=None,
                 model_ws=None, external_path=None,verbose=False,
                 load=True, listunit=7, exe_name = 'mt3dms.exe', ):
        BaseModel.__init__(self, modelname, namefile_ext, model_ws=model_ws,
                           exe_name=exe_name)
        self.heading = '# Name file for MT3DMS, generated by Flopy.'
        self.__mf = modflowmodel
        self.lst = Mt3dList(self, listunit=listunit)
        self.ftlfilename = ftlfilename
        self.__adv = None
        self.__btn = None        
        self.__dsp = None
        self.__gcg = None
        self.__rct = None
        self.__ssm = None
        self.free_format = False
        self.external_path = external_path
        self.external = False
        self.external_fnames = []
        self.external_units = []
        self.external_binflag = []
        self.load = load
        self.__next_ext_unit = 500
        if external_path is not None:
            if os.path.exists(external_path):
                print("Note: external_path " + str(external_path) +\
                    " already exists")
            #assert os.path.exists(external_path),'external_path does not exist'
            else:
                os.mkdir(external_path)
            self.external = True         
        self.verbose = verbose            
        return
        
    def __repr__( self ):
        return 'MT3DMS model'

    def get_ncomp(self):
        btn = self.get_package('BTN')
        if (btn):
            return btn.ncomp
        else:
            return 1
    
    #--function to encapsulate next_ext_unit attribute
    def next_ext_unit(self):
        self.__next_ext_unit += 1
        return self.__next_ext_unit
    
    def getadv(self):
        if (self.__adv == None):
            for p in (self.packagelist):
                if isinstance(p, Mt3dAdv):
                    self.__adv = p
        return self.__adv
    def getbtn(self):
        if (self.__btn == None):
            for p in (self.packagelist):
                if isinstance(p, Mt3dBtn):
                    self.__btn = p
        return self.__btn
    def getdsp(self):
        if (self.__dsp == None):
            for p in (self.packagelist):
                if isinstance(p, Mt3dDsp):
                    self.__dsp = p
        return self.__dsp
    def getgcg(self):
        if (self.__gcg == None):
            for p in (self.packagelist):
                if isinstance(p, Mt3dGcg):
                    self.__gcg = p
        return self.__gcg
    def getmf(self):
        return self.__mf
    def getrct(self):
        if (self.__rct == None):
            for p in (self.packagelist):
                if isinstance(p, Mt3dRct):
                    self.__rct = p
        return self.__rct
    def getssm(self):
        if (self.__ssm == None):
            for p in (self.packagelist):
                if isinstance(p, Mt3dSsm):
                    self.__ssm = p
        return self.__ssm
    
    def write_name_file(self):
        fn_path = os.path.join(self.model_ws,self.namefile)       
        f_nam = open( fn_path, 'w' )
        f_nam.write('%s\n' % (self.heading) )
        f_nam.write('%s %3i %s\n' % (self.lst.name[0], self.lst.unit_number[0], 
                    self.lst.file_name[0]))
        if self.ftlfilename is not None:
            f_nam.write('%s %3i %s\n' % ('FTL', 39, self.ftlfilename))
        f_nam.write('%s' % self.get_name_file_entries())
        for u,f in zip(self.external_units,self.external_fnames):
            f_nam.write('DATA  {0:3d}  '.format(u)+f+'\n'	)
        f_nam.close()
    
    
    
    adv = property(getadv) # Property has no setter, so read-only
    btn = property(getbtn) # Property has no setter, so read-only
    dsp = property(getdsp) # Property has no setter, so read-only
    gcg = property(getgcg) # Property has no setter, so read-only
    mf = property(getmf) # Property has no setter, so read-only
    rct = property(getrct) # Property has no setter, so read-only
    ssm = property(getssm) # Property has no setter, so read-only
    
    
    
