# Purpose: Standard definitions
# Created: 08.07.2015
# Copyright (c) 2015-2020, Manfred Moitzi
# License: MIT License
# pattern type: predefined (1)

PATTERN_OLD = {
    "ANSI31": [[45.0, (0.0, 0.0), (-0.0884, 0.0884), []]],
    "ANSI32": [
        [45.0, (0.0, 0.0), (-0.2652, 0.2652), []],
        [45.0, (0.1768, 0.0), (-0.2652, 0.2652), []],
    ],
    "ANSI33": [
        [45.0, (20.0, 0.0), (-0.1768, 0.1768), []],
        [45.0, (20.1768, 0.0), (-0.1768, 0.1768), [0.125, -0.0625]],
    ],
    "ANSI34": [
        [45.0, (0.0, 0.0), (-0.5303, 0.5303), []],
        [45.0, (0.1768, 0.0), (-0.5303, 0.5303), []],
        [45.0, (0.3536, 0.0), (-0.5303, 0.5303), []],
        [45.0, (0.5303, 0.0), (-0.5303, 0.5303), []],
    ],
    "ANSI35": [
        [45.0, (-40.0, -10.0), (-0.1768, 0.1768), []],
        [45.0, (-39.8232, -10.0), (-0.1768, 0.1768), [0.3125, -0.0625, 0.0, -0.0625]],
    ],
    "ANSI36": [
        [45.0, (-40.0, -10.0), (0.0663, 0.2431), [0.3125, -0.0625, 0.0, -0.0625]]
    ],
    "ANSI37": [
        [45.0, (0.0, 0.0), (-0.0884, 0.0884), []],
        [135.0, (0.0, 0.0), (-0.0884, -0.0884), []],
    ],
    "ANSI38": [
        [45.0, (0.0, 0.0), (-0.0884, 0.0884), []],
        [135.0, (0.0, 0.0), (-0.2652, 0.0884), [0.3125, -0.1875]],
    ],
    "ACAD_ISO02W100": [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3]]],
    "ACAD_ISO03W100": [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -1.8]]],
    "ACAD_ISO04W100": [[0.0, (0.0, 0.0), (0.0, 0.5), [2.4, -0.3, 0.05, -0.3]]],
    "ACAD_ISO05W100": [
        [0.0, (0.0, 0.0), (0.0, 0.5), [2.4, -0.3, 0.05, -0.3, 0.05, -0.3]]
    ],
    "ACAD_ISO06W100": [
        [0.0, (0.0, 0.0), (0.0, 0.5), [2.4, -0.3, 0.05, -0.3, 0.05, -0.65]],
        [0.0, (0.0, 0.0), (0.0, 0.5), [-3.4, 0.05, -0.3]],
    ],
    "ACAD_ISO07W100": [[0.0, (0.0, 0.0), (0.0, 0.5), [0.05, -0.3]]],
    "ACAD_ISO08W100": [[0.0, (0.0, 0.0), (0.0, 0.5), [2.4, -0.3, 0.6, -0.3]]],
    "ACAD_ISO09W100": [
        [0.0, (0.0, 0.0), (0.0, 0.5), [2.4, -0.3, 0.6, -0.3, 0.6, -0.3]]
    ],
    "ACAD_ISO10W100": [[0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 0.05, -0.3]]],
    "ACAD_ISO11W100": [
        [0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 1.2, -0.3, 0.05, -0.3]]
    ],
    "ACAD_ISO12W100": [
        [0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 0.05, -0.3, 0.05, -0.3]]
    ],
    "ACAD_ISO13W100": [
        [0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 1.2, -0.3, 0.05, -0.65]],
        [0.0, (0.0, 0.0), (0.0, 0.5), [-3.35, 0.05, -0.3]],
    ],
    "ACAD_ISO14W100": [
        [0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 0.05, -0.3, 0.05, -0.65]],
        [0.0, (0.0, 0.0), (0.0, 0.5), [-2.2, 0.05, -0.3]],
    ],
    "ACAD_ISO15W100": [
        [0.0, (0.0, 0.0), (0.0, 0.5), [1.2, -0.3, 1.2, -0.3, 0.05, -1.0]],
        [0.0, (0.0, 0.0), (0.0, 0.5), [-3.35, 0.05, -0.3, 0.05, -0.3]],
    ],
    "ANGLE": [
        [0.0, (0.0, 0.0), (0.0, 0.275), [0.2, -0.075]],
        [90.0, (0.0, 0.0), (-0.275, 0.0), [0.2, -0.075]],
    ],
    "AR-B816": [
        [0.0, (0.0, 0.0), (0.0, 0.8), []],
        [90.0, (0.0, 0.0), (-0.8, 0.8), [0.8, -0.8]],
    ],
    "AR-B816C": [
        [0.0, (0.0, 0.0), (0.8, 0.8), [1.5625, -0.0375]],
        [0.0, (-0.8, 0.0375), (0.8, 0.8), [1.5625, -0.0375]],
        [90.0, (0.0, 0.0), (-0.8, 0.8), [-0.8375, 0.7625]],
        [90.0, (-0.0375, 0.0), (-0.8, 0.8), [-0.8375, 0.7625]],
    ],
    "AR-B88": [
        [0.0, (0.0, 0.0), (0.0, 0.8), []],
        [90.0, (0.0, 0.0), (-0.4, 0.8), [0.8, -0.8]],
    ],
    "AR-BRELM": [
        [0.0, (0.0, 0.0), (0.0, 2.667), [3.8125, -0.1875]],
        [0.0, (0.0, 1.125), (0.0, 2.667), [3.8125, -0.1875]],
        [0.0, (1.0, 1.3335), (0.0, 2.667), [1.8125, -0.1875]],
        [0.0, (1.0, 2.4585), (0.0, 2.667), [1.8125, -0.1875]],
        [90.0, (0.0, 0.0), (-4.0, 0.0), [1.125, -1.542]],
        [90.0, (-0.1875, 0.0), (-4.0, 0.0), [1.125, -1.542]],
        [90.0, (1.0, 1.3335), (-2.0, 0.0), [1.125, -1.542]],
        [90.0, (0.8125, 1.3335), (-2.0, 0.0), [1.125, -1.542]],
    ],
    "AR-BRSTD": [
        [0.0, (0.0, 0.0), (0.0, 2.667), []],
        [90.0, (0.0, 0.0), (-4.0, 2.667), [2.667, -2.667]],
    ],
    "AR-CONC": [
        [50.0, (0.0, 0.0), (1.4345, -0.1255), [0.15, -1.65]],
        [355.0, (0.0, 0.0), (-0.2775, 1.5044), [0.12, -1.32]],
        [100.4514, (0.1195, -0.0105), (1.157, 1.3789), [0.1275, -1.4023]],
        [46.1842, (0.0, 0.4), (2.1345, -0.331), [0.225, -2.475]],
        [96.6356, (0.1779, 0.3724), (1.8693, 1.9482), [0.1912, -2.1034]],
        [351.1842, (0.0, 0.4), (1.8693, 1.9482), [0.18, -1.98]],
        [21.0, (0.2, 0.3), (1.1938, -0.8052), [0.15, -1.65]],
        [326.0, (0.2, 0.3), (0.4866, 1.4503), [0.12, -1.32]],
        [71.4514, (0.2995, 0.2329), (1.6804, 0.6451), [0.1275, -1.4023]],
        [37.5, (0.0, 0.0), (0.0243, 0.6658), [0.0, -1.304, 0.0, -1.34, 0.0, -1.325]],
        [7.5, (0.0, 0.0), (0.5261, 0.7888), [0.0, -0.764, 0.0, -1.274, 0.0, -0.505]],
        [327.5, (-0.446, 0.0), (1.0676, -0.0451), [0.0, -0.5, 0.0, -1.56, 0.0, -2.07]],
        [317.5, (-0.646, 0.0), (1.1664, 0.2002), [0.0, -0.65, 0.0, -1.036, 0.0, -1.47]],
    ],
    "AR-HBONE": [
        [45.0, (0.0, 0.0), (0.0, 1.1314), [2.4, -0.8]],
        [135.0, (0.5657, 0.5657), (0.0, 1.1314), [2.4, -0.8]],
    ],
    "AR-PARQ1": [
        [90.0, (0.0, 0.0), (-2.4, 2.4), [2.4, -2.4]],
        [90.0, (0.4, 0.0), (-2.4, 2.4), [2.4, -2.4]],
        [90.0, (0.8, 0.0), (-2.4, 2.4), [2.4, -2.4]],
        [90.0, (1.2, 0.0), (-2.4, 2.4), [2.4, -2.4]],
        [90.0, (1.6, 0.0), (-2.4, 2.4), [2.4, -2.4]],
        [90.0, (2.0, 0.0), (-2.4, 2.4), [2.4, -2.4]],
        [90.0, (2.4, 0.0), (-2.4, 2.4), [2.4, -2.4]],
        [0.0, (0.0, 2.4), (2.4, -2.4), [2.4, -2.4]],
        [0.0, (0.0, 2.8), (2.4, -2.4), [2.4, -2.4]],
        [0.0, (0.0, 3.2), (2.4, -2.4), [2.4, -2.4]],
        [0.0, (0.0, 3.6), (2.4, -2.4), [2.4, -2.4]],
        [0.0, (0.0, 4.0), (2.4, -2.4), [2.4, -2.4]],
        [0.0, (0.0, 4.4), (2.4, -2.4), [2.4, -2.4]],
        [0.0, (0.0, 4.8), (2.4, -2.4), [2.4, -2.4]],
    ],
    "AR-RROOF": [
        [0.0, (0.0, 0.0), (2.2, 1.0), [15.0, -2.0, 5.0, -1.0]],
        [0.0, (1.33, 0.5), (-1.0, 1.33), [3.0, -0.33, 6.0, -0.75]],
        [0.0, (0.5, 0.85), (5.2, 0.67), [8.0, -1.4, 4.0, -1.0]],
    ],
    "AR-RSHKE": [
        [0.0, (0.0, 0.0), (2.55, 1.2), [0.6, -0.5, 0.7, -0.3, 0.9, -0.4]],
        [0.0, (0.6, 0.05), (2.55, 1.2), [0.5, -1.9, 0.4, -0.6]],
        [0.0, (1.8, -0.075), (2.55, 1.2), [0.3, -3.1]],
        [90.0, (0.0, 0.0), (-0.85, 1.2), [1.15, -3.65]],
        [90.0, (0.6, 0.0), (-0.85, 1.2), [1.125, -3.675]],
        [90.0, (1.1, 0.0), (-0.85, 1.2), [1.05, -3.75]],
        [90.0, (1.8, -0.075), (-0.85, 1.2), [1.15, -3.65]],
        [90.0, (2.1, -0.075), (-0.85, 1.2), [1.15, -3.65]],
        [90.0, (3.0, 0.0), (-0.85, 1.2), [1.1, -3.7]],
    ],
    "AR-SAND": [
        [37.5, (0.0, 0.0), (-0.063, 1.9268), [0.0, -1.52, 0.0, -1.7, 0.0, -1.625]],
        [7.5, (0.0, 0.0), (1.7698, 2.8221), [0.0, -0.82, 0.0, -1.37, 0.0, -0.525]],
        [327.5, (-1.23, 0.0), (3.1141, 0.0057), [0.0, -0.5, 0.0, -1.8, 0.0, -2.35]],
        [317.5, (-1.23, 0.0), (3.0061, 0.8777), [0.0, -0.25, 0.0, -1.18, 0.0, -1.35]],
    ],
    "BOX": [
        [90.0, (0.0, 0.0), (-1.0, 0.0), []],
        [90.0, (0.25, 0.0), (-1.0, 0.0), []],
        [0.0, (0.0, 0.0), (0.0, 1.0), [-0.25, 0.25]],
        [0.0, (0.0, 0.25), (0.0, 1.0), [-0.25, 0.25]],
        [0.0, (0.0, 0.5), (0.0, 1.0), [0.25, -0.25]],
        [0.0, (0.0, 0.75), (0.0, 1.0), [0.25, -0.25]],
        [90.0, (0.5, 0.0), (-1.0, 0.0), [0.25, -0.25]],
        [90.0, (0.75, 0.0), (-1.0, 0.0), [0.25, -0.25]],
    ],
    "BRASS": [
        [0.0, (0.0, 0.0), (0.0, 0.25), []],
        [0.0, (0.0, 0.125), (0.0, 0.25), [0.125, -0.0625]],
    ],
    "BRICK": [
        [0.0, (0.0, 0.0), (0.0, 0.25), []],
        [90.0, (0.0, 0.0), (-0.5, 0.0), [0.25, -0.25]],
        [90.0, (0.25, 0.0), (-0.5, 0.0), [-0.25, 0.25]],
    ],
    "BRSTONE": [
        [0.0, (0.0, 0.0), (0.0, 0.33), []],
        [90.0, (0.9, 0.0), (-0.5, 0.33), [0.33, -0.33]],
        [90.0, (0.8, 0.0), (-0.5, 0.33), [0.33, -0.33]],
        [0.0, (0.9, 0.055), (0.5, 0.33), [-0.9, 0.1]],
        [0.0, (0.9, 0.11), (0.5, 0.33), [-0.9, 0.1]],
        [0.0, (0.9, 0.165), (0.5, 0.33), [-0.9, 0.1]],
        [0.0, (0.9, 0.22), (0.5, 0.33), [-0.9, 0.1]],
        [0.0, (0.9, 0.275), (0.5, 0.33), [-0.9, 0.1]],
    ],
    "CLAY": [
        [0.0, (0.0, 0.0), (0.0, 0.1875), []],
        [0.0, (0.0, 0.0312), (0.0, 0.1875), []],
        [0.0, (0.0, 0.0625), (0.0, 0.1875), []],
        [0.0, (0.0, 0.125), (0.0, 0.1875), [0.1875, -0.125]],
    ],
    "CORK": [
        [0.0, (0.0, 0.0), (0.0, 0.125), []],
        [135.0, (0.0625, -0.0625), (-0.25, -0.25), [0.1768, -0.1768]],
        [135.0, (0.0938, -0.0625), (-0.25, -0.25), [0.1768, -0.1768]],
        [135.0, (0.125, -0.0625), (-0.25, -0.25), [0.1768, -0.1768]],
    ],
    "CROSS": [
        [0.0, (0.0, 0.0), (0.25, 0.25), [0.125, -0.375]],
        [90.0, (0.0625, -0.0625), (-0.25, 0.25), [0.125, -0.375]],
    ],
    "DASH": [[0.0, (0.0, 0.0), (0.125, 0.125), [0.125, -0.125]]],
    "DOLMIT": [
        [0.0, (0.0, 0.0), (0.0, 0.25), []],
        [45.0, (0.0, 0.0), (-0.5, 0.5), [0.3536, -0.7071]],
    ],
    "DOTS": [[0.0, (0.0, 0.0), (0.0312, 0.0625), [0.0, -0.0625]]],
    "EARTH": [
        [0.0, (0.0, 0.0), (0.25, 0.25), [0.25, -0.25]],
        [0.0, (0.0, 0.0938), (0.25, 0.25), [0.25, -0.25]],
        [0.0, (0.0, 0.1875), (0.25, 0.25), [0.25, -0.25]],
        [90.0, (0.0312, 0.2188), (-0.25, 0.25), [0.25, -0.25]],
        [90.0, (0.125, 0.2188), (-0.25, 0.25), [0.25, -0.25]],
        [90.0, (0.2188, 0.2188), (-0.25, 0.25), [0.25, -0.25]],
    ],
    "ESCHER": [
        [60.0, (0.0, 0.0), (-1.2, -0.0), [1.1, -0.1]],
        [180.0, (0.0, 0.0), (0.6, -1.0392), [1.1, -0.1]],
        [300.0, (0.0, 0.0), (1.2, -0.0), [1.1, -0.1]],
        [60.0, (0.1, 0.0), (-1.2, -0.0), [0.2, -1.0]],
        [300.0, (0.1, 0.0), (1.2, -0.0), [0.2, -1.0]],
        [60.0, (-0.05, 0.0866), (-1.2, -0.0), [0.2, -1.0]],
        [180.0, (-0.05, 0.0866), (0.6, -1.0392), [0.2, -1.0]],
        [300.0, (-0.05, -0.0866), (1.2, -0.0), [0.2, -1.0]],
        [180.0, (-0.05, -0.0866), (0.6, -1.0392), [0.2, -1.0]],
        [60.0, (-0.4, 0.0), (-1.2, -0.0), [0.2, -1.0]],
        [300.0, (-0.4, 0.0), (1.2, -0.0), [0.2, -1.0]],
        [60.0, (0.2, -0.3464), (-1.2, -0.0), [0.2, -1.0]],
        [180.0, (0.2, -0.3464), (0.6, -1.0392), [0.2, -1.0]],
        [300.0, (0.2, 0.3464), (1.2, -0.0), [0.2, -1.0]],
        [180.0, (0.2, 0.3464), (0.6, -1.0392), [0.2, -1.0]],
        [0.0, (0.2, 0.1732), (-0.6, 1.0392), [0.7, -0.5]],
        [0.0, (0.2, -0.1732), (-0.6, 1.0392), [0.7, -0.5]],
        [120.0, (0.05, 0.2598), (-1.2, 0.0), [0.7, -0.5]],
        [120.0, (-0.25, 0.0866), (-1.2, 0.0), [0.7, -0.5]],
        [240.0, (-0.25, -0.0866), (0.6, -1.0392), [0.7, -0.5]],
        [240.0, (0.05, -0.2598), (0.6, -1.0392), [0.7, -0.5]],
    ],
    "FLEX": [
        [0.0, (0.0, 0.0), (0.0, 0.25), [0.25, -0.25]],
        [45.0, (0.25, 0.0), (0.0, 0.25), [0.0625, -0.2286, 0.0625, -0.3536]],
    ],
    "GOST_GLASS": [
        [45.0, (0.0, 0.0), (0.8485, -0.0), [0.5, -0.7]],
        [45.0, (0.2121, 0.0), (0.8485, -0.0), [0.2, -1.0]],
        [45.0, (0.0, 0.2121), (0.8485, -0.0), [0.2, -1.0]],
    ],
    "GOST_WOOD": [
        [90.0, (0.0, 0.0), (1.2, -0.0), [2.0, -0.4]],
        [90.0, (0.4, -0.4), (1.2, -0.0), [1.2, -0.3, 0.6, -0.3]],
        [90.0, (0.8, -1.0), (1.2, -0.0), [2.0, -0.4]],
    ],
    "GOST_GROUND": [
        [45.0, (0.0, 0.0), (2.8284, -0.0), [4.0]],
        [45.0, (0.6, 0.0), (2.8284, -0.0), [4.0]],
        [45.0, (1.2, 0.0), (2.8284, -0.0), [4.0]],
    ],
    "GRASS": [
        [90.0, (0.0, 0.0), (-0.7071, 0.7071), [0.1875, -1.2267]],
        [45.0, (0.0, 0.0), (-0.7071, 0.7071), [0.1875, -0.8125]],
        [135.0, (0.0, 0.0), (-0.7071, -0.7071), [0.1875, -0.8125]],
    ],
    "GRATE": [
        [0.0, (0.0, 0.0), (0.0, 0.0312), []],
        [90.0, (0.0, 0.0), (-0.125, 0.0), []],
    ],
    "GRAVEL": [
        [228.0128, (0.72, 1.0), (-8.0, -9.0), [0.1345, -13.3191]],
        [184.9697, (0.63, 0.9), (12.0, 1.0), [0.2309, -22.8559]],
        [132.5104, (0.4, 0.88), (10.0, -11.0), [0.1628, -16.116]],
        [267.2737, (0.01, 0.63), (1.0, 20.0), [0.2102, -20.8136]],
        [292.8337, (0.0, 0.42), (-5.0, 12.0), [0.2062, -20.4094]],
        [357.2737, (0.08, 0.23), (-20.0, 1.0), [0.2102, -20.8136]],
        [37.6942, (0.29, 0.22), (-13.0, -10.0), [0.278, -27.5248]],
        [72.2553, (0.51, 0.39), (7.0, 22.0), [0.2625, -25.9863]],
        [121.4296, (0.59, 0.64), (-8.0, 13.0), [0.2109, -20.8841]],
        [175.2364, (0.48, 0.82), (11.0, -1.0), [0.2408, -11.8008]],
        [222.3974, (0.24, 0.84), (-12.0, -11.0), [0.3114, -30.8334]],
        [138.8141, (1.0, 0.62), (-7.0, 6.0), [0.1063, -10.5238]],
        [171.4692, (0.92, 0.69), (13.0, -2.0), [0.2022, -20.0215]],
        [225.0, (0.72, 0.72), (-0.0, -1.0), [0.1414, -1.2728]],
        [203.1986, (0.65, 0.84), (5.0, 2.0), [0.0762, -7.5396]],
        [291.8014, (0.58, 0.81), (-1.0, 3.0), [0.1077, -5.2775]],
        [30.9638, (0.62, 0.71), (3.0, 2.0), [0.1749, -5.656]],
        [161.5651, (0.77, 0.8), (2.0, -1.0), [0.1265, -3.0358]],
        [16.3895, (0.0, 0.81), (10.0, 3.0), [0.1772, -17.5428]],
        [70.3462, (0.17, 0.86), (-4.0, -11.0), [0.1487, -14.7174]],
        [293.1986, (0.77, 1.0), (-2.0, 5.0), [0.1523, -7.4635]],
        [343.6105, (0.83, 0.86), (-10.0, 3.0), [0.1772, -17.5428]],
        [339.444, (0.0, 0.19), (-5.0, 2.0), [0.1709, -8.3731]],
        [294.7751, (0.16, 0.13), (-5.0, 11.0), [0.1432, -14.1746]],
        [66.8014, (0.78, 0.0), (2.0, 5.0), [0.1523, -7.4635]],
        [17.354, (0.84, 0.14), (-13.0, -4.0), [0.1676, -16.5954]],
        [69.444, (0.29, 0.0), (-2.0, -5.0), [0.0854, -8.4586]],
        [101.3099, (0.72, 0.0), (-1.0, 4.0), [0.051, -5.048]],
        [165.9638, (0.71, 0.05), (3.0, -1.0), [0.2062, -3.917]],
        [186.009, (0.51, 0.1), (10.0, 1.0), [0.191, -18.9139]],
        [303.6901, (0.62, 0.62), (-1.0, 2.0), [0.1442, -3.4613]],
        [353.1572, (0.7, 0.5), (17.0, -2.0), [0.2518, -24.9276]],
        [60.9454, (0.95, 0.47), (-4.0, -7.0), [0.103, -10.1927]],
        [90.0, (1.0, 0.56), (-1.0, 1.0), [0.06, -0.94]],
        [120.2564, (0.49, 0.13), (4.0, -7.0), [0.1389, -13.7535]],
        [48.0128, (0.42, 0.25), (8.0, 9.0), [0.2691, -13.1846]],
        [0.0, (0.6, 0.45), (1.0, 1.0), [0.26, -0.74]],
        [325.3048, (0.86, 0.45), (10.0, -7.0), [0.1581, -15.6533]],
        [254.0546, (0.99, 0.36), (-1.0, -4.0), [0.1456, -7.1345]],
        [207.646, (0.95, 0.22), (-19.0, -10.0), [0.2371, -23.4695]],
        [175.4261, (0.74, 0.11), (-13.0, 1.0), [0.2508, -24.8291]],
    ],
    "HEX": [
        [0.0, (0.0, 0.0), (0.0, 0.2165), [0.125, -0.25]],
        [120.0, (0.0, 0.0), (-0.1875, -0.1083), [0.125, -0.25]],
        [60.0, (0.125, 0.0), (-0.1875, 0.1083), [0.125, -0.25]],
    ],
    "HONEY": [
        [0.0, (0.0, 0.0), (0.1875, 0.1083), [0.125, -0.25]],
        [120.0, (0.0, 0.0), (-0.1875, 0.1083), [0.125, -0.25]],
        [60.0, (0.0, 0.0), (0.0, 0.2165), [-0.25, 0.125]],
    ],
    "HOUND": [
        [0.0, (0.0, 0.0), (0.25, 0.0625), [1.0, -0.5]],
        [90.0, (0.0, 0.0), (-0.0625, -0.25), [1.0, -0.5]],
    ],
    "INSUL": [
        [0.0, (0.0, 0.0), (0.0, 0.375), []],
        [0.0, (0.0, 0.125), (0.0, 0.375), [0.125, -0.125]],
        [0.0, (0.0, 0.25), (0.0, 0.375), [0.125, -0.125]],
    ],
    "LINE": [[0.0, (0.0, 0.0), (0.0, 0.125), []]],
    "MUDST": [[0.0, (0.0, 0.0), (0.5, 0.25), [0.25, -0.25, 0.0, -0.25, 0.0, -0.25]]],
    "NET": [[0.0, (0.0, 0.0), (0.0, 0.125), []], [90.0, (0.0, 0.0), (-0.125, 0.0), []]],
    "NET3": [
        [0.0, (0.0, 0.0), (0.0, 0.125), []],
        [60.0, (0.0, 0.0), (-0.1083, 0.0625), []],
        [120.0, (0.0, 0.0), (-0.1083, -0.0625), []],
    ],
    "PLAST": [
        [0.0, (0.0, 0.0), (0.0, 0.25), []],
        [0.0, (0.0, 0.0312), (0.0, 0.25), []],
        [0.0, (0.0, 0.0625), (0.0, 0.25), []],
    ],
    "PLASTI": [
        [0.0, (0.0, 0.0), (0.0, 0.25), []],
        [0.0, (0.0, 0.0312), (0.0, 0.25), []],
        [0.0, (0.0, 0.0625), (0.0, 0.25), []],
        [0.0, (0.0, 0.1562), (0.0, 0.25), []],
    ],
    "SACNCR": [
        [45.0, (0.0, 0.0), (-0.0663, 0.0663), []],
        [45.0, (0.0663, 0.0), (-0.0663, 0.0663), [0.0, -0.0938]],
    ],
    "SQUARE": [
        [0.0, (0.0, 0.0), (0.0, 0.125), [0.125, -0.125]],
        [90.0, (0.0, 0.0), (-0.125, 0.0), [0.125, -0.125]],
    ],
    "STARS": [
        [0.0, (0.0, 0.0), (0.0, 0.2165), [0.125, -0.125]],
        [60.0, (0.0, 0.0), (-0.1875, 0.1083), [0.125, -0.125]],
        [120.0, (0.0625, 0.1083), (-0.1875, -0.1083), [0.125, -0.125]],
    ],
    "STEEL": [
        [45.0, (0.0, 0.0), (-0.0884, 0.0884), []],
        [45.0, (0.0, 0.0625), (-0.0884, 0.0884), []],
    ],
    "SWAMP": [
        [0.0, (0.0, 0.0), (0.5, 0.866), [0.125, -0.875]],
        [90.0, (0.0625, 0.0), (-0.5, 0.866), [0.0625, -1.6696]],
        [90.0, (0.0781, 0.0), (-0.5, 0.866), [0.05, -1.6821]],
        [90.0, (0.0469, 0.0), (-0.5, 0.866), [0.05, -1.6821]],
        [60.0, (0.0938, 0.0), (-0.5, 0.866), [0.04, -0.96]],
        [120.0, (0.0312, 0.0), (-1.0, 0.0), [0.04, -0.96]],
    ],
    "TRANS": [
        [0.0, (0.0, 0.0), (0.0, 0.25), []],
        [0.0, (0.0, 0.125), (0.0, 0.25), [0.125, -0.125]],
    ],
    "TRIANG": [
        [60.0, (0.0, 0.0), (-0.1875, 0.3248), [0.1875, -0.1875]],
        [120.0, (0.0, 0.0), (-0.375, 0.0), [0.1875, -0.1875]],
        [0.0, (-0.0938, 0.1624), (0.1875, 0.3248), [0.1875, -0.1875]],
    ],
    "ZIGZAG": [
        [0.0, (0.0, 0.0), (0.125, 0.125), [0.125, -0.125]],
        [90.0, (0.125, 0.0), (-0.125, 0.125), [0.125, -0.125]],
    ],
}

PATTERN_NEW = {
    "ANSI31": [[45.0, (0.0, 0.0), (-2.2627, 2.2627), []]],
    "ANSI32": [
        [45.0, (0.0, 0.0), (-6.7882, 6.7882), []],
        [45.0, (4.5255, 0.0), (-6.7882, 6.7882), []],
    ],
    "ANSI33": [
        [45.0, (512.0, 0.0), (-4.5255, 4.5255), []],
        [45.0, (516.5255, 0.0), (-4.5255, 4.5255), [3.2, -1.6]],
    ],
    "ANSI34": [
        [45.0, (0.0, 0.0), (-13.5765, 13.5765), []],
        [45.0, (4.5255, 0.0), (-13.5765, 13.5765), []],
        [45.0, (9.051, 0.0), (-13.5765, 13.5765), []],
        [45.0, (13.5765, 0.0), (-13.5765, 13.5765), []],
    ],
    "ANSI35": [
        [45.0, (-1024.0, -256.0), (-4.5255, 4.5255), []],
        [45.0, (-1019.4745, -256.0), (-4.5255, 4.5255), [8.0, -1.6, 0.0, -1.6]],
    ],
    "ANSI36": [[45.0, (-1024.0, -256.0), (1.6971, 6.2225), [8.0, -1.6, 0.0, -1.6]]],
    "ANSI37": [
        [45.0, (0.0, 0.0), (-2.2627, 2.2627), []],
        [135.0, (0.0, 0.0), (-2.2627, -2.2627), []],
    ],
    "ANSI38": [
        [45.0, (0.0, 0.0), (-2.2627, 2.2627), []],
        [135.0, (0.0, 0.0), (-6.7882, 2.2627), [8.0, -4.8]],
    ],
    "ACAD_ISO02W100": [[0.0, (0.0, 0.0), (0.0, 12.8), [30.72, -7.68]]],
    "ACAD_ISO03W100": [[0.0, (0.0, 0.0), (0.0, 12.8), [30.72, -46.08]]],
    "ACAD_ISO04W100": [[0.0, (0.0, 0.0), (0.0, 12.8), [61.44, -7.68, 1.28, -7.68]]],
    "ACAD_ISO05W100": [
        [0.0, (0.0, 0.0), (0.0, 12.8), [61.44, -7.68, 1.28, -7.68, 1.28, -7.68]]
    ],
    "ACAD_ISO06W100": [
        [0.0, (0.0, 0.0), (0.0, 12.8), [61.44, -7.68, 1.28, -7.68, 1.28, -16.64]],
        [0.0, (0.0, 0.0), (0.0, 12.8), [-87.04, 1.28, -7.68]],
    ],
    "ACAD_ISO07W100": [[0.0, (0.0, 0.0), (0.0, 12.8), [1.28, -7.68]]],
    "ACAD_ISO08W100": [[0.0, (0.0, 0.0), (0.0, 12.8), [61.44, -7.68, 15.36, -7.68]]],
    "ACAD_ISO09W100": [
        [0.0, (0.0, 0.0), (0.0, 12.8), [61.44, -7.68, 15.36, -7.68, 15.36, -7.68]]
    ],
    "ACAD_ISO10W100": [[0.0, (0.0, 0.0), (0.0, 12.8), [30.72, -7.68, 1.28, -7.68]]],
    "ACAD_ISO11W100": [
        [0.0, (0.0, 0.0), (0.0, 12.8), [30.72, -7.68, 30.72, -7.68, 1.28, -7.68]]
    ],
    "ACAD_ISO12W100": [
        [0.0, (0.0, 0.0), (0.0, 12.8), [30.72, -7.68, 1.28, -7.68, 1.28, -7.68]]
    ],
    "ACAD_ISO13W100": [
        [0.0, (0.0, 0.0), (0.0, 12.8), [30.72, -7.68, 30.72, -7.68, 1.28, -16.64]],
        [0.0, (0.0, 0.0), (0.0, 12.8), [-85.76, 1.28, -7.68]],
    ],
    "ACAD_ISO14W100": [
        [0.0, (0.0, 0.0), (0.0, 12.8), [30.72, -7.68, 1.28, -7.68, 1.28, -16.64]],
        [0.0, (0.0, 0.0), (0.0, 12.8), [-56.32, 1.28, -7.68]],
    ],
    "ACAD_ISO15W100": [
        [0.0, (0.0, 0.0), (0.0, 12.8), [30.72, -7.68, 30.72, -7.68, 1.28, -25.6]],
        [0.0, (0.0, 0.0), (0.0, 12.8), [-85.76, 1.28, -7.68, 1.28, -7.68]],
    ],
    "ANGLE": [
        [0.0, (0.0, 0.0), (0.0, 7.04), [5.12, -1.92]],
        [90.0, (0.0, 0.0), (-7.04, 0.0), [5.12, -1.92]],
    ],
    "AR-B816": [
        [0.0, (0.0, 0.0), (0.0, 20.48), []],
        [90.0, (0.0, 0.0), (-20.48, 20.48), [20.48, -20.48]],
    ],
    "AR-B816C": [
        [0.0, (0.0, 0.0), (20.48, 20.48), [40.0, -0.96]],
        [0.0, (-20.48, 0.96), (20.48, 20.48), [40.0, -0.96]],
        [90.0, (0.0, 0.0), (-20.48, 20.48), [-21.44, 19.52]],
        [90.0, (-0.96, 0.0), (-20.48, 20.48), [-21.44, 19.52]],
    ],
    "AR-B88": [
        [0.0, (0.0, 0.0), (0.0, 20.48), []],
        [90.0, (0.0, 0.0), (-10.24, 20.48), [20.48, -20.48]],
    ],
    "AR-BRELM": [
        [0.0, (0.0, 0.0), (0.0, 68.2752), [97.6, -4.8]],
        [0.0, (0.0, 28.8), (0.0, 68.2752), [97.6, -4.8]],
        [0.0, (25.6, 34.1376), (0.0, 68.2752), [46.4, -4.8]],
        [0.0, (25.6, 62.9376), (0.0, 68.2752), [46.4, -4.8]],
        [90.0, (0.0, 0.0), (-102.4, 0.0), [28.8, -39.4752]],
        [90.0, (-4.8, 0.0), (-102.4, 0.0), [28.8, -39.4752]],
        [90.0, (25.6, 34.1376), (-51.2, 0.0), [28.8, -39.4752]],
        [90.0, (20.8, 34.1376), (-51.2, 0.0), [28.8, -39.4752]],
    ],
    "AR-BRSTD": [
        [0.0, (0.0, 0.0), (0.0, 68.2752), []],
        [90.0, (0.0, 0.0), (-102.4, 68.2752), [68.2752, -68.2752]],
    ],
    "AR-CONC": [
        [50.0, (0.0, 0.0), (36.7237, -3.2129), [3.84, -42.24]],
        [355.0, (0.0, 0.0), (-7.1041, 38.5122), [3.072, -33.792]],
        [100.4514, (3.0603, -0.2677), (29.6197, 35.2993), [3.2635, -35.8985]],
        [46.1842, (0.0, 10.24), (54.6428, -8.4746), [5.76, -63.36]],
        [96.6356, (4.5536, 9.5338), (47.8547, 49.8749), [4.8952, -53.8477]],
        [351.1842, (0.0, 10.24), (47.8547, 49.8749), [4.608, -50.688]],
        [21.0, (5.12, 7.68), (30.5616, -20.6141), [3.84, -42.24]],
        [326.0, (5.12, 7.68), (12.4577, 37.1277), [3.072, -33.792]],
        [71.4514, (7.6668, 5.9622), (43.0194, 16.5136), [3.2635, -35.8985]],
        [
            37.5,
            (0.0, 0.0),
            (0.6226, 17.0442),
            [0.0, -33.3824, 0.0, -34.304, 0.0, -33.92],
        ],
        [
            7.5,
            (0.0, 0.0),
            (13.4692, 20.1939),
            [0.0, -19.5584, 0.0, -32.6144, 0.0, -12.928],
        ],
        [
            327.5,
            (-11.4176, 0.0),
            (27.3317, -1.1548),
            [0.0, -12.8, 0.0, -39.936, 0.0, -52.992],
        ],
        [
            317.5,
            (-16.5376, 0.0),
            (29.8591, 5.1254),
            [0.0, -16.64, 0.0, -26.5216, 0.0, -37.632],
        ],
    ],
    "AR-HBONE": [
        [45.0, (0.0, 0.0), (0.0, 28.9631), [61.44, -20.48]],
        [135.0, (14.4815, 14.4815), (0.0, 28.9631), [61.44, -20.48]],
    ],
    "AR-PARQ1": [
        [90.0, (0.0, 0.0), (-61.44, 61.44), [61.44, -61.44]],
        [90.0, (10.24, 0.0), (-61.44, 61.44), [61.44, -61.44]],
        [90.0, (20.48, 0.0), (-61.44, 61.44), [61.44, -61.44]],
        [90.0, (30.72, 0.0), (-61.44, 61.44), [61.44, -61.44]],
        [90.0, (40.96, 0.0), (-61.44, 61.44), [61.44, -61.44]],
        [90.0, (51.2, 0.0), (-61.44, 61.44), [61.44, -61.44]],
        [90.0, (61.44, 0.0), (-61.44, 61.44), [61.44, -61.44]],
        [0.0, (0.0, 61.44), (61.44, -61.44), [61.44, -61.44]],
        [0.0, (0.0, 71.68), (61.44, -61.44), [61.44, -61.44]],
        [0.0, (0.0, 81.92), (61.44, -61.44), [61.44, -61.44]],
        [0.0, (0.0, 92.16), (61.44, -61.44), [61.44, -61.44]],
        [0.0, (0.0, 102.4), (61.44, -61.44), [61.44, -61.44]],
        [0.0, (0.0, 112.64), (61.44, -61.44), [61.44, -61.44]],
        [0.0, (0.0, 122.88), (61.44, -61.44), [61.44, -61.44]],
    ],
    "AR-RROOF": [
        [0.0, (0.0, 0.0), (56.32, 25.6), [384.0, -51.2, 128.0, -25.6]],
        [0.0, (34.048, 12.8), (-25.6, 34.048), [76.8, -8.448, 153.6, -19.2]],
        [0.0, (12.8, 21.76), (133.12, 17.152), [204.8, -35.84, 102.4, -25.6]],
    ],
    "AR-RSHKE": [
        [0.0, (0.0, 0.0), (65.28, 30.72), [15.36, -12.8, 17.92, -7.68, 23.04, -10.24]],
        [0.0, (15.36, 1.28), (65.28, 30.72), [12.8, -48.64, 10.24, -15.36]],
        [0.0, (46.08, -1.92), (65.28, 30.72), [7.68, -79.36]],
        [90.0, (0.0, 0.0), (-21.76, 30.72), [29.44, -93.44]],
        [90.0, (15.36, 0.0), (-21.76, 30.72), [28.8, -94.08]],
        [90.0, (28.16, 0.0), (-21.76, 30.72), [26.88, -96.0]],
        [90.0, (46.08, -1.92), (-21.76, 30.72), [29.44, -93.44]],
        [90.0, (53.76, -1.92), (-21.76, 30.72), [29.44, -93.44]],
        [90.0, (76.8, 0.0), (-21.76, 30.72), [28.16, -94.72]],
    ],
    "AR-SAND": [
        [37.5, (0.0, 0.0), (-1.6126, 49.3267), [0.0, -38.912, 0.0, -43.52, 0.0, -41.6]],
        [
            7.5,
            (0.0, 0.0),
            (45.3063, 72.2469),
            [0.0, -20.992, 0.0, -35.072, 0.0, -13.44],
        ],
        [
            327.5,
            (-31.488, 0.0),
            (79.722, 0.1449),
            [0.0, -12.8, 0.0, -46.08, 0.0, -60.16],
        ],
        [
            317.5,
            (-31.488, 0.0),
            (76.9568, 22.4685),
            [0.0, -6.4, 0.0, -30.208, 0.0, -34.56],
        ],
    ],
    "BOX": [
        [90.0, (0.0, 0.0), (-25.6, 0.0), []],
        [90.0, (6.4, 0.0), (-25.6, 0.0), []],
        [0.0, (0.0, 0.0), (0.0, 25.6), [-6.4, 6.4]],
        [0.0, (0.0, 6.4), (0.0, 25.6), [-6.4, 6.4]],
        [0.0, (0.0, 12.8), (0.0, 25.6), [6.4, -6.4]],
        [0.0, (0.0, 19.2), (0.0, 25.6), [6.4, -6.4]],
        [90.0, (12.8, 0.0), (-25.6, 0.0), [6.4, -6.4]],
        [90.0, (19.2, 0.0), (-25.6, 0.0), [6.4, -6.4]],
    ],
    "BRASS": [
        [0.0, (0.0, 0.0), (0.0, 6.4), []],
        [0.0, (0.0, 3.2), (0.0, 6.4), [3.2, -1.6]],
    ],
    "BRICK": [
        [0.0, (0.0, 0.0), (0.0, 6.4), []],
        [90.0, (0.0, 0.0), (-12.8, 0.0), [6.4, -6.4]],
        [90.0, (6.4, 0.0), (-12.8, 0.0), [-6.4, 6.4]],
    ],
    "BRSTONE": [
        [0.0, (0.0, 0.0), (0.0, 8.448), []],
        [90.0, (23.04, 0.0), (-12.8, 8.448), [8.448, -8.448]],
        [90.0, (20.48, 0.0), (-12.8, 8.448), [8.448, -8.448]],
        [0.0, (23.04, 1.408), (12.8, 8.448), [-23.04, 2.56]],
        [0.0, (23.04, 2.816), (12.8, 8.448), [-23.04, 2.56]],
        [0.0, (23.04, 4.224), (12.8, 8.448), [-23.04, 2.56]],
        [0.0, (23.04, 5.632), (12.8, 8.448), [-23.04, 2.56]],
        [0.0, (23.04, 7.04), (12.8, 8.448), [-23.04, 2.56]],
    ],
    "CLAY": [
        [0.0, (0.0, 0.0), (0.0, 4.8), []],
        [0.0, (0.0, 0.8), (0.0, 4.8), []],
        [0.0, (0.0, 1.6), (0.0, 4.8), []],
        [0.0, (0.0, 3.2), (0.0, 4.8), [4.8, -3.2]],
    ],
    "CORK": [
        [0.0, (0.0, 0.0), (0.0, 3.2), []],
        [135.0, (1.6, -1.6), (-6.4, -6.4), [4.5255, -4.5255]],
        [135.0, (2.4, -1.6), (-6.4, -6.4), [4.5255, -4.5255]],
        [135.0, (3.2, -1.6), (-6.4, -6.4), [4.5255, -4.5255]],
    ],
    "CROSS": [
        [0.0, (0.0, 0.0), (6.4, 6.4), [3.2, -9.6]],
        [90.0, (1.6, -1.6), (-6.4, 6.4), [3.2, -9.6]],
    ],
    "DASH": [[0.0, (0.0, 0.0), (3.2, 3.2), [3.2, -3.2]]],
    "DOLMIT": [
        [0.0, (0.0, 0.0), (0.0, 6.4), []],
        [45.0, (0.0, 0.0), (-12.8, 12.8), [9.051, -18.1019]],
    ],
    "DOTS": [[0.0, (0.0, 0.0), (0.8, 1.6), [0.0, -1.6]]],
    "EARTH": [
        [0.0, (0.0, 0.0), (6.4, 6.4), [6.4, -6.4]],
        [0.0, (0.0, 2.4), (6.4, 6.4), [6.4, -6.4]],
        [0.0, (0.0, 4.8), (6.4, 6.4), [6.4, -6.4]],
        [90.0, (0.8, 5.6), (-6.4, 6.4), [6.4, -6.4]],
        [90.0, (3.2, 5.6), (-6.4, 6.4), [6.4, -6.4]],
        [90.0, (5.6, 5.6), (-6.4, 6.4), [6.4, -6.4]],
    ],
    "ESCHER": [
        [60.0, (0.0, 0.0), (-30.72, -0.0), [28.16, -2.56]],
        [180.0, (0.0, 0.0), (15.36, -26.6043), [28.16, -2.56]],
        [300.0, (0.0, 0.0), (30.72, -0.0), [28.16, -2.56]],
        [60.0, (2.56, 0.0), (-30.72, -0.0), [5.12, -25.6]],
        [300.0, (2.56, 0.0), (30.72, -0.0), [5.12, -25.6]],
        [60.0, (-1.28, 2.217), (-30.72, -0.0), [5.12, -25.6]],
        [180.0, (-1.28, 2.217), (15.36, -26.6043), [5.12, -25.6]],
        [300.0, (-1.28, -2.217), (30.72, -0.0), [5.12, -25.6]],
        [180.0, (-1.28, -2.217), (15.36, -26.6043), [5.12, -25.6]],
        [60.0, (-10.24, 0.0), (-30.72, -0.0), [5.12, -25.6]],
        [300.0, (-10.24, 0.0), (30.72, -0.0), [5.12, -25.6]],
        [60.0, (5.12, -8.8681), (-30.72, -0.0), [5.12, -25.6]],
        [180.0, (5.12, -8.8681), (15.36, -26.6043), [5.12, -25.6]],
        [300.0, (5.12, 8.8681), (30.72, -0.0), [5.12, -25.6]],
        [180.0, (5.12, 8.8681), (15.36, -26.6043), [5.12, -25.6]],
        [0.0, (5.12, 4.4341), (-15.36, 26.6043), [17.92, -12.8]],
        [0.0, (5.12, -4.4341), (-15.36, 26.6043), [17.92, -12.8]],
        [120.0, (1.28, 6.6511), (-30.72, 0.0), [17.92, -12.8]],
        [120.0, (-6.4, 2.217), (-30.72, 0.0), [17.92, -12.8]],
        [240.0, (-6.4, -2.217), (15.36, -26.6043), [17.92, -12.8]],
        [240.0, (1.28, -6.6511), (15.36, -26.6043), [17.92, -12.8]],
    ],
    "FLEX": [
        [0.0, (0.0, 0.0), (0.0, 6.4), [6.4, -6.4]],
        [45.0, (6.4, 0.0), (0.0, 6.4), [1.6, -5.851, 1.6, -9.051]],
    ],
    "GOST_GLASS": [
        [45.0, (0.0, 0.0), (21.7223, -0.0), [12.8, -17.92]],
        [45.0, (5.4306, 0.0), (21.7223, -0.0), [5.12, -25.6]],
        [45.0, (0.0, 5.4306), (21.7223, -0.0), [5.12, -25.6]],
    ],
    "GOST_WOOD": [
        [90.0, (0.0, 0.0), (30.72, -0.0), [51.2, -10.24]],
        [90.0, (10.24, -10.24), (30.72, -0.0), [30.72, -7.68, 15.36, -7.68]],
        [90.0, (20.48, -25.6), (30.72, -0.0), [51.2, -10.24]],
    ],
    "GOST_GROUND": [
        [45.0, (0.0, 0.0), (72.4077, -0.0), [102.4]],
        [45.0, (15.36, 0.0), (72.4077, -0.0), [102.4]],
        [45.0, (30.72, 0.0), (72.4077, -0.0), [102.4]],
    ],
    "GRASS": [
        [90.0, (0.0, 0.0), (-18.1019, 18.1019), [4.8, -31.4039]],
        [45.0, (0.0, 0.0), (-18.1019, 18.1019), [4.8, -20.8]],
        [135.0, (0.0, 0.0), (-18.1019, -18.1019), [4.8, -20.8]],
    ],
    "GRATE": [[0.0, (0.0, 0.0), (0.0, 0.8), []], [90.0, (0.0, 0.0), (-3.2, 0.0), []]],
    "GRAVEL": [
        [228.0128, (18.432, 25.6), (-204.8, -230.4), [3.4441, -340.9687]],
        [184.9697, (16.128, 23.04), (307.2, 25.6), [5.9102, -585.1117]],
        [132.5104, (10.24, 22.528), (256.0, -281.6), [4.1674, -412.5704]],
        [267.2737, (0.256, 16.128), (25.6, 512.0), [5.3821, -532.8271]],
        [292.8337, (0.0, 10.752), (-128.0, 307.2), [5.2776, -522.48]],
        [357.2737, (2.048, 5.888), (-512.0, 25.6), [5.3821, -532.8271]],
        [37.6942, (7.424, 5.632), (-332.8, -256.0), [7.1175, -704.6361]],
        [72.2553, (13.056, 9.984), (179.2, 563.2), [6.7197, -665.2498]],
        [121.4296, (15.104, 16.384), (-204.8, 332.8), [5.4003, -534.6323]],
        [175.2364, (12.288, 20.992), (281.6, -25.6), [6.1653, -302.0995]],
        [222.3974, (6.144, 21.504), (-307.2, -281.6), [7.9731, -789.3344]],
        [138.8141, (25.6, 15.872), (-179.2, 153.6), [2.7213, -269.4104]],
        [171.4692, (23.552, 17.664), (332.8, -51.2), [5.1773, -512.5507]],
        [225.0, (18.432, 18.432), (-0.0, -25.6), [3.6204, -32.5835]],
        [203.1986, (16.64, 21.504), (128.0, 51.2), [1.9496, -193.0141]],
        [291.8014, (14.848, 20.736), (-25.6, 76.8), [2.7572, -135.103]],
        [30.9638, (15.872, 18.176), (76.8, 51.2), [4.4782, -144.7942]],
        [161.5651, (19.712, 20.48), (51.2, -25.6), [3.2382, -77.7161]],
        [16.3895, (0.0, 20.736), (256.0, 76.8), [4.5363, -449.0968]],
        [70.3462, (4.352, 22.016), (-102.4, -281.6), [3.8057, -376.7656]],
        [293.1986, (19.712, 25.6), (-51.2, 128.0), [3.8993, -191.0645]],
        [343.6105, (21.248, 22.016), (-256.0, 76.8), [4.5363, -449.0968]],
        [339.444, (0.0, 4.864), (-128.0, 51.2), [4.3745, -214.352]],
        [294.7751, (4.096, 3.328), (-128.0, 281.6), [3.6654, -362.8709]],
        [66.8014, (19.968, 0.0), (51.2, 128.0), [3.8993, -191.0645]],
        [17.354, (21.504, 3.584), (-332.8, -102.4), [4.2914, -424.8428]],
        [69.444, (7.424, 0.0), (-51.2, -128.0), [2.1873, -216.5392]],
        [101.3099, (18.432, 0.0), (-25.6, 102.4), [1.3053, -129.2296]],
        [165.9638, (18.176, 1.28), (76.8, -25.6), [5.2776, -100.2739]],
        [186.009, (13.056, 2.56), (256.0, 25.6), [4.8909, -484.1964]],
        [303.6901, (15.872, 15.872), (-25.6, 51.2), [3.6921, -88.61]],
        [353.1572, (17.92, 12.8), (435.2, -51.2), [6.4459, -638.1456]],
        [60.9454, (24.32, 12.032), (-102.4, -179.2), [2.6357, -260.9325]],
        [90.0, (25.6, 14.336), (-25.6, 25.6), [1.536, -24.064]],
        [120.2564, (12.544, 3.328), (102.4, -179.2), [3.5565, -352.0901]],
        [48.0128, (10.752, 6.4), (204.8, 230.4), [6.8882, -337.5245]],
        [0.0, (15.36, 11.52), (25.6, 25.6), [6.656, -18.944]],
        [325.3048, (22.016, 11.52), (256.0, -179.2), [4.0477, -400.7238]],
        [254.0546, (25.344, 9.216), (-25.6, -102.4), [3.7274, -182.6434]],
        [207.646, (24.32, 5.632), (-486.4, -256.0), [6.0689, -600.8185]],
        [175.4261, (18.944, 2.816), (-332.8, 25.6), [6.4205, -635.6243]],
    ],
    "HEX": [
        [0.0, (0.0, 0.0), (0.0, 5.5426), [3.2, -6.4]],
        [120.0, (0.0, 0.0), (-4.8, -2.7713), [3.2, -6.4]],
        [60.0, (3.2, 0.0), (-4.8, 2.7713), [3.2, -6.4]],
    ],
    "HONEY": [
        [0.0, (0.0, 0.0), (4.8, 2.7713), [3.2, -6.4]],
        [120.0, (0.0, 0.0), (-4.8, 2.7713), [3.2, -6.4]],
        [60.0, (0.0, 0.0), (0.0, 5.5426), [-6.4, 3.2]],
    ],
    "HOUND": [
        [0.0, (0.0, 0.0), (6.4, 1.6), [25.6, -12.8]],
        [90.0, (0.0, 0.0), (-1.6, -6.4), [25.6, -12.8]],
    ],
    "INSUL": [
        [0.0, (0.0, 0.0), (0.0, 9.6), []],
        [0.0, (0.0, 3.2), (0.0, 9.6), [3.2, -3.2]],
        [0.0, (0.0, 6.4), (0.0, 9.6), [3.2, -3.2]],
    ],
    "LINE": [[0.0, (0.0, 0.0), (0.0, 3.2), []]],
    "MUDST": [[0.0, (0.0, 0.0), (12.8, 6.4), [6.4, -6.4, 0.0, -6.4, 0.0, -6.4]]],
    "NET": [[0.0, (0.0, 0.0), (0.0, 3.2), []], [90.0, (0.0, 0.0), (-3.2, 0.0), []]],
    "NET3": [
        [0.0, (0.0, 0.0), (0.0, 3.2), []],
        [60.0, (0.0, 0.0), (-2.7713, 1.6), []],
        [120.0, (0.0, 0.0), (-2.7713, -1.6), []],
    ],
    "PLAST": [
        [0.0, (0.0, 0.0), (0.0, 6.4), []],
        [0.0, (0.0, 0.8), (0.0, 6.4), []],
        [0.0, (0.0, 1.6), (0.0, 6.4), []],
    ],
    "PLASTI": [
        [0.0, (0.0, 0.0), (0.0, 6.4), []],
        [0.0, (0.0, 0.8), (0.0, 6.4), []],
        [0.0, (0.0, 1.6), (0.0, 6.4), []],
        [0.0, (0.0, 4.0), (0.0, 6.4), []],
    ],
    "SACNCR": [
        [45.0, (0.0, 0.0), (-1.6971, 1.6971), []],
        [45.0, (1.6971, 0.0), (-1.6971, 1.6971), [0.0, -2.4]],
    ],
    "SQUARE": [
        [0.0, (0.0, 0.0), (0.0, 3.2), [3.2, -3.2]],
        [90.0, (0.0, 0.0), (-3.2, 0.0), [3.2, -3.2]],
    ],
    "STARS": [
        [0.0, (0.0, 0.0), (0.0, 5.5426), [3.2, -3.2]],
        [60.0, (0.0, 0.0), (-4.8, 2.7713), [3.2, -3.2]],
        [120.0, (1.6, 2.7713), (-4.8, -2.7713), [3.2, -3.2]],
    ],
    "STEEL": [
        [45.0, (0.0, 0.0), (-2.2627, 2.2627), []],
        [45.0, (0.0, 1.6), (-2.2627, 2.2627), []],
    ],
    "SWAMP": [
        [0.0, (0.0, 0.0), (12.8, 22.1703), [3.2, -22.4]],
        [90.0, (1.6, 0.0), (-12.8, 22.1703), [1.6, -42.7405]],
        [90.0, (2.0, 0.0), (-12.8, 22.1703), [1.28, -43.0605]],
        [90.0, (1.2, 0.0), (-12.8, 22.1703), [1.28, -43.0605]],
        [60.0, (2.4, 0.0), (-12.8, 22.1703), [1.024, -24.576]],
        [120.0, (0.8, 0.0), (-25.6, 0.0), [1.024, -24.576]],
    ],
    "TRANS": [
        [0.0, (0.0, 0.0), (0.0, 6.4), []],
        [0.0, (0.0, 3.2), (0.0, 6.4), [3.2, -3.2]],
    ],
    "TRIANG": [
        [60.0, (0.0, 0.0), (-4.8, 8.3138), [4.8, -4.8]],
        [120.0, (0.0, 0.0), (-9.6, 0.0), [4.8, -4.8]],
        [0.0, (-2.4, 4.1569), (4.8, 8.3138), [4.8, -4.8]],
    ],
    "ZIGZAG": [
        [0.0, (0.0, 0.0), (3.2, 3.2), [3.2, -3.2]],
        [90.0, (3.2, 0.0), (-3.2, 3.2), [3.2, -3.2]],
    ],
}


def load(old_pattern=None):
    from ezdxf.options import options
    if old_pattern is not None:
        use_old = bool(old_pattern)
        options.use_old_predefined_pattern_scaling = use_old
    else:
        use_old = options.use_old_predefined_pattern_scaling
    return PATTERN_OLD if use_old else PATTERN_NEW


def scale_pattern(pattern, factor: float = 1, ndigits=4):
    def _scale(iterable):
        return [round(i * factor, ndigits) for i in iterable]

    def _scale_line(line):
        angle, base_point, offset, dash_length_items = line
        return [
            round(angle, ndigits),
            tuple(_scale(base_point)),
            tuple(_scale(offset)),
            _scale(dash_length_items)
        ]

    return [_scale_line(line) for line in pattern]


def scale_all(pattern: dict, factor: float = 1, ndigits=4):
    return {name: scale_pattern(p, factor, ndigits) for name, p in pattern.items()}
