/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class Lambda {
    public static final BiConsumer<Integer, RunnableThatThrows> repeater = (limit, func) -> {
        for (int i = 0; i < limit; ++i) {
            try {
                func.run();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    private Lambda() {
    }

    public static void withLock(Lock lock, Runnable runnable) {
        lock.lock();
        try {
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T withLock(Lock lock, Callable<T> callable) {
        lock.lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    public static <T, R> Function<T, R> silent(FunctionThatThrows<T, R> functionThatThrows) {
        return arg -> {
            try {
                return functionThatThrows.apply(arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> Callable<T> silent(CallableThatThrows<T> functionThatThrows) {
        return () -> {
            try {
                return functionThatThrows.apply();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Runnable silent(RunnableThatThrows functionThatThrows) {
        return () -> {
            try {
                functionThatThrows.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> void forEachWithIndex(Iterable<T> iterable, IteratorWithIndex<T> iteratorWithIndex) {
        Iterator<T> iterator = iterable.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            T nextT = iterator.next();
            iteratorWithIndex.forEachWithIndex(nextT, index);
            ++index;
        }
    }

    @FunctionalInterface
    public static interface FunctionThatThrows<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface CallableThatThrows<T> {
        public T apply() throws Exception;
    }

    @FunctionalInterface
    public static interface RunnableThatThrows {
        public void run() throws Exception;
    }

    public static interface IteratorWithIndex<T> {
        public void forEachWithIndex(T var1, int var2);
    }
}

