/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import com.google.common.collect.Range;
import java.util.Date;
import java.util.List;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.DateTimeConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.RangeParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.AcceptAllValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.RangeValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class DateTimeParserValidator
extends RangeParserValidator<Date> {
    public static final String DATETIME_TYPE = "DATETIME";
    public static final String LEFT_DELIMITER = "(";
    public static final String RIGHT_DELIMITER = ")";
    protected static final String DATETIME_TYPE_REGEXP = "[Dd][Aa][Tt][Ee][Tt][Ii][Mm][Ee]";
    protected static final String LEFT_DELIMITER_REGEXP = "\\(";
    protected static final String RIGHT_DELIMITER_REGEXP = "\\)";
    protected static final String DATETYPE_MAIN_REGEXP = "[Dd][Aa][Tt][Ee][Tt][Ii][Mm][Ee]\\(([^)]+)\\)";

    public DateTimeParserValidator(String model) throws ModelSyntaxException {
        super(model);
    }

    @Override
    public String getType() {
        return DATETIME_TYPE;
    }

    @Override
    protected String getTypeRegexp() {
        return DATETIME_TYPE_REGEXP;
    }

    @Override
    public Class getClassType() {
        return Date.class;
    }

    @Override
    protected Converter<Date> createConverter(String model) throws ModelSyntaxException {
        List<String> modelArguments = this.getDateModelArguments(model);
        try {
            return new DateTimeConverter(modelArguments.get(0));
        }
        catch (IllegalArgumentException e) {
            throw new ModelSyntaxException(e.getMessage(), e);
        }
    }

    @Override
    protected Validator<Date> createValidator(String model, Converter<Date> converter) throws ModelSyntaxException {
        List<String> modelArguments = this.getDateModelArguments(model);
        if (modelArguments.size() == 2) {
            Range<Date> range = super.extractRange(modelArguments.get(1), converter);
            return new RangeValidator<Date>(range);
        }
        return new AcceptAllValidator<Date>();
    }

    private List<String> getDateModelArguments(String model) throws ModelSyntaxException {
        String dateTimeMainRegexp = "^[Dd][Aa][Tt][Ee][Tt][Ii][Mm][Ee]\\(([^)]+)\\)$|^[Dd][Aa][Tt][Ee][Tt][Ii][Mm][Ee]\\(([^)]+)\\)\\[([^)]+)\\]$";
        List<String> modelArguments = DateTimeParserValidator.parseAndGetRegexGroups(model, dateTimeMainRegexp);
        if (modelArguments.size() == 1 || modelArguments.size() == 2) {
            return modelArguments;
        }
        throw new ModelSyntaxException("Internal error, regular expression for " + this.getType() + " '" + dateTimeMainRegexp + "' is invalid.");
    }
}

