# Copyright (c) 2015, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

from mixbox.namespaces import Namespace, NamespaceSet, register_namespace

NS_CYBOX_CORE = Namespace('http://docs.oasis-open.org/cti/ns/cybox/core-2', 'cybox', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/core.xsd')
NS_CYBOX_COMMON = Namespace('http://docs.oasis-open.org/cti/ns/cybox/common-2', 'cyboxCommon', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/common.xsd')
NS_CYBOX_VOCABS = Namespace('http://docs.oasis-open.org/cti/ns/cybox/vocabularies-2', 'cyboxVocabs', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/default-vocabularies.xsd')
NS_ACCOUNT_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/account-2', 'AccountObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Account-Object.xsd')
NS_ADDRESS_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/address-2', 'AddressObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Address-Object.xsd')
NS_API_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/api-2', 'APIObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/API-Object.xsd')
NS_ARCHIVEFILE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/archive-file-1', 'ArchiveFileObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Archive-File-Object.xsd')
NS_ARPCACHE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/arp-cache-1', 'ARPCacheObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/ARP-Cache-Object.xsd')
NS_ARTIFACT_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/artifact-2', 'ArtifactObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Artifact-Object.xsd')
NS_AS_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/as-1', 'ASObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/AS-Object.xsd')
NS_CODE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/code-2', 'CodeObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Code-Object.xsd')
NS_CUSTOM_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/custom-1', 'CustomObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Custom-Object.xsd')
NS_DEVICE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/device-2', 'DeviceObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Device-Object.xsd')
NS_DISK_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/disk-2', 'DiskObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Disk-Object.xsd')
NS_DISKPARTITION_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/disk-partition-2', 'DiskPartitionObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Disk-Partition-Object.xsd')
NS_DNSCACHE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/dns-cache-2', 'DNSCacheObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/DNS-Cache-Object.xsd')
NS_DNSQUERY_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/dns-query-2', 'DNSQueryObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/DNS-Query-Object.xsd')
NS_DNSRECORD_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/dns-record-2', 'DNSRecordObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/DNS-Record-Object.xsd')
NS_DOMAINNAME_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/domain-name-1', 'DomainNameObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Domain-Name-Object.xsd')
NS_EMAILMESSAGE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/email-message-2', 'EmailMessageObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Email-Message-Object.xsd')
NS_FILE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/file-2', 'FileObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/File-Object.xsd')
NS_GUIDIALOGBOX_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/gui-dialogbox-2', 'GUIDialogboxObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/GUI-Dialogbox-Object.xsd')
NS_GUI_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/gui-2', 'GUIObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/GUI-Object.xsd')
NS_GUIWINDOW_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/gui-window-2', 'GUIWindowObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/GUI-Window-Object.xsd')
NS_HOSTNAME_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/hostname-1', 'HostnameObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Hostname-Object.xsd')
NS_HTTPSESSION_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/http-session-2', 'HTTPSessionObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/HTTP-Session-Object.xsd')
NS_IMAGEFILE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/image-file-1', 'ImageFileObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Image-File-Object.xsd')
NS_LIBRARY_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/library-2', 'LibraryObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Library-Object.xsd')
NS_LINK_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/link-1', 'LinkObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Link-Object.xsd')
NS_LINUXPACKAGE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/linux-package-2', 'LinuxPackageObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Linux-Package-Object.xsd')
NS_MEMORY_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/memory-2', 'MemoryObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Memory-Object.xsd')
NS_MUTEX_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/mutex-2', 'MutexObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Mutex-Object.xsd')
NS_NETWORKCONNECTION_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/network-connection-2', 'NetworkConnectionObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Network-Connection-Object.xsd')
NS_NETWORKFLOW_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/network-flow-2', 'NetFlowObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Network-Flow-Object.xsd')
NS_NETWORKROUTEENTRY_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/network-route-entry-2', 'NetworkRouteEntryObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Network-Route-Entry-Object.xsd')
NS_NETWORKROUTE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/network-route-2', 'NetworkRouteObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Network-Route-Object.xsd')
NS_NETWORKSOCKET_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/network-socket-2', 'NetworkSocketObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Network-Socket-Object.xsd')
NS_NETWORKSUBNET_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/network-subnet-2', 'NetworkSubnetObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Network-Subnet-Object.xsd')
NS_PACKET_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/network-packet-2', 'PacketObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Network-Packet-Object.xsd')
NS_PDFFILE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/pdf-file-1', 'PDFFileObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/PDF-File-Object.xsd')
NS_PIPE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/pipe-2', 'PipeObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Pipe-Object.xsd')
NS_PORT_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/port-2', 'PortObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Port-Object.xsd')
NS_PROCESS_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/process-2', 'ProcessObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Process-Object.xsd')
NS_PRODUCT_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/product-2', 'ProductObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Product-Object.xsd')
NS_SEMAPHORE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/semaphore-2', 'SemaphoreObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Semaphore-Object.xsd')
NS_SMSMESSAGE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/sms-message-1', 'SMSMessageObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/SMS-Message-Object.xsd')
NS_SOCKETADDRESS_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/socket-address-1', 'SocketAddressObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Socket-Address-Object.xsd')
NS_SYSTEM_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/system-2', 'SystemObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/System-Object.xsd')
NS_UNIXFILE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/unix-file-2', 'UnixFileObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Unix-File-Object.xsd')
NS_UNIXNETWORKROUTEENTRY_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/unix-network-route-entry-2', 'UnixNetworkRouteEntryObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Unix-Network-Route-Entry-Object.xsd')
NS_UNIXPIPE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/unix-pipe-2', 'UnixPipeObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Unix-Pipe-Object.xsd')
NS_UNIXPROCESS_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/unix-process-2', 'UnixProcessObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Unix-Process-Object.xsd')
NS_UNIXUSERACCOUNT_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/unix-user-account-2', 'UnixUserAccountObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Unix-User-Account-Object.xsd')
NS_UNIXVOLUME_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/unix-volume-2', 'UnixVolumeObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Unix-Volume-Object.xsd')
NS_URI_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/uri-2', 'URIObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/URI-Object.xsd')
NS_URLHISTORY_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/url-history-1', 'URLHistoryObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/URL-History-Object.xsd')
NS_USERACCOUNT_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/user-account-2', 'UserAccountObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/User-Account-Object.xsd')
NS_VOLUME_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/volume-2', 'VolumeObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Volume-Object.xsd')
NS_WHOIS_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/whois-2', 'WhoisObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Whois-Object.xsd')
NS_WINCOMPUTERACCOUNT_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-computer-account-2', 'WinComputerAccountObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Computer-Account-Object.xsd')
NS_WINCRITICALSECTION_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-critical-section-2', 'WinCriticalSectionObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Critical-Section-Object.xsd')
NS_WINDRIVER_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-driver-3', 'WinDriverObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Driver-Object.xsd')
NS_WINEVENTLOG_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-event-log-2', 'WinEventLogObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Event-Log-Object.xsd')
NS_WINEVENT_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-event-2', 'WinEventObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Event-Object.xsd')
NS_WINEXECUTABLEFILE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-executable-file-2', 'WinExecutableFileObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Executable-File-Object.xsd')
NS_WINFILE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-file-2', 'WinFileObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-File-Object.xsd')
NS_WINFILEMAPPING_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-filemapping-1', 'WinFilemappingObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Filemapping-Object.xsd')
NS_WINHANDLE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-handle-2', 'WinHandleObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Handle-Object.xsd')
NS_WINHOOK_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-hook-1', 'WinHookObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Hook-Object.xsd')
NS_WINKERNELHOOK_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-kernel-hook-2', 'WinKernelHookObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Kernel-Hook-Object.xsd')
NS_WINKERNEL_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-kernel-2', 'WinKernelObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Kernel-Object.xsd')
NS_WINMAILSLOT_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-mailslot-2', 'WinMailslotObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Mailslot-Object.xsd')
NS_WINMEMORYPAGEREGION_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-memory-page-region-2', 'WinMemoryPageRegionObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Memory-Page-Region-Object.xsd')
NS_WINMUTEX_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-mutex-2', 'WinMutexObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Mutex-Object.xsd')
NS_WINNETWORKROUTEENTRY_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-network-route-entry-2', 'WinNetworkRouteEntryObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Network-Route-Entry-Object.xsd')
NS_WINNETWORKSHARE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-network-share-2', 'WinNetworkShareObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Network-Share-Object.xsd')
NS_WINPIPE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-pipe-2', 'WinPipeObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Pipe-Object.xsd')
NS_WINPREFETCH_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-prefetch-2', 'WinPrefetchObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Prefetch-Object.xsd')
NS_WINPROCESS_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-process-2', 'WinProcessObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Process-Object.xsd')
NS_WINREGISTRYKEY_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-registry-key-2', 'WinRegistryKeyObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Registry-Key-Object.xsd')
NS_WINSEMAPHORE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-semaphore-2', 'WinSemaphoreObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Semaphore-Object.xsd')
NS_WINSERVICE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-service-2', 'WinServiceObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Service-Object.xsd')
NS_WINSYSTEM_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-system-2', 'WinSystemObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-System-Object.xsd')
NS_WINSYSTEMRESTORE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-system-restore-2', 'WinSystemRestoreObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-System-Restore-Object.xsd')
NS_WINTASK_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-task-2', 'WinTaskObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Task-Object.xsd')
NS_WINTHREAD_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-thread-2', 'WinThreadObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Thread-Object.xsd')
NS_WINUSERACCOUNT_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-user-account-2', 'WinUserAccountObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-User-Account-Object.xsd')
NS_WINVOLUME_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-volume-2', 'WinVolumeObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Volume-Object.xsd')
NS_WINWAITABLETIMER_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/win-waitable-timer-2', 'WinWaitableTimerObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/Win-Waitable-Timer-Object.xsd')
NS_X509CERTIFICATE_OBJECT = Namespace('http://docs.oasis-open.org/cti/ns/cybox/objects/x509-certificate-2', 'X509CertificateObj', 'http://docs.oasis-open.org/cti/cybox/v2.1.1/csd01/xml-schemas/objects/X509-Certificate-Object.xsd')

CYBOX_NAMESPACES = NamespaceSet()

# Magic to automatically register all Namespaces defined in this module.
for k, v in dict(globals()).items():
    if k.startswith('NS_'):
        register_namespace(v)
        CYBOX_NAMESPACES.add_namespace(v)
