from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
from __future__ import unicode_literals


from pando.http.request import Request
from pando.http.response import Response


def test_website_can_respond(harness):
    harness.fs.www.mk(('index.html.spt', '[---]\n[---]\nGreetings, program!'))
    assert harness.client.GET().body == b'Greetings, program!'


def test_website_can_respond_with_negotiation(harness):
    harness.fs.www.mk(('index.spt', '''
        [---]
        [---] text/plain
        Greetings, program!
        [---] text/html
        <h1>Hi!
    '''))
    assert harness.client.GET(HTTP_ACCEPT=b'text/html').body == b'<h1>Hi!\n'


def test_404_comes_out_404(harness):
    harness.fs.project.mk(('404.spt', '[---]\n[---] text/plain\nEep!'))
    assert harness.client.GET(raise_immediately=False).code == 404


def test_user_can_influence_request_context_via_algorithm_state(harness):
    harness.fs.www.mk(('index.html.spt', '[---]\n[---]\n%(foo)s'))
    def add_foo_to_context(request):
        return {'foo': 'bar'}
    harness.client.website.algorithm.insert_after('parse_environ_into_request', add_foo_to_context)
    assert harness.client.GET().body == b'bar'


def test_early_failures_dont_break_everything(harness):
    old_from_wsgi = Request.from_wsgi
    def broken_from_wsgi(*a, **kw):
        raise Response(400)
    try:
        Request.from_wsgi = classmethod(broken_from_wsgi)
        assert harness.client.GET("/", raise_immediately=False).code == 400
    finally:
        Request.from_wsgi = old_from_wsgi
