import socket
import requests
import bs4


class RouterDAuth(object):
    '''Router Default Authentication Check.'''
    def __init__(self):
        self.page = "http://www.routerpasswords.com/"
        self.login_page = ""
        self.models = []
        self.protocols = []
        self.usernames = []
        self.passwords = []

    def __enter__(self):
        return self

    def __exit__(self, type, error, traceback):
        if error:
            print(error)

    def getpasswords(self, router_name):
        '''Fetches passwords given router manufacture name from
        http://www.routerpasswords.com/.'''
        payload = {"findpass": "1",
                    "router": router_name,
                    "findpassword": "Find Password"}
        page = requests.post(self.page, data=payload)
        parser = bs4.BeautifulSoup(page.content, 'html.parser')
        for table_rows in parser.find_all('tr')[1:]:
            table_data = table_rows.find_all('td')
            self.models.append(table_data[1].text)
            self.protocols.append(table_data[2].text)
            self.usernames.append(table_data[3].text)
            self.passwords.append(table_data[4].text)

    def target(self, login_page):
        '''Set target using url.'''
        self.login_page = login_page
        return login_page

    def check(self, usernames, passwords):
        '''Checks router Authentication using default credentials.'''
        for username in usernames:
            for password in passwords:
                page = requests.get(self.login_page, auth=(username, password))
                if page.status_code == 200:
                    return True
        return False


class NetFuzzer(object):
    '''Fuzzer For Network Services.'''
    def __init__(self, host, port):
        self.sock = socket.socket()
        self.host = host
        self.port = port

    def __len__(self):
        return len(self.buffer)

    def __enter__(self):
        return self

    def __exit__(self, type, error, traceback):
        if error:
            print(error)

    def buildbuffer(self, chars, length):
        '''Creates a buffer.'''
        self.buffer = chars * length
        return self.buffer

    def fuzz(self):
        '''Fuzzez the target.'''
        self.sock.settimeout(10)
        self.sock.connect((self.host, self.port))
        self.sock.recv(recvsize)
        self.sock.send(self.buffer.encode())
        self.sock.recv(recvsize)
        return self.sock.recv(4096)

    def status(self):
        '''Checks if service is still running.'''
        service = socket()
        service.settimeout(10)
        service.connect((self.host, self.port))
        if service.recv(4096):
            return True
        return False


class SQLInject(object):
    '''SQL Injection.'''
    def __init__(self, url):
        self.errors = []
        self.url = url

    def __len__(self):
        return len(self.errors)

    def __enter__(self):
        return self

    def __exit__(self, type, error, traceback):
        if error:
            print(error)

    def urlinject(self, injection):
        '''Inject in url.'''
        page = requests.get(self.url + injection)
        errors = re.findall('You have an error in your SQL syntax;',
                            page.content.decode())
        for error in errors:
            if error:
                self.errors.append(error)
                return True
        return False

    def forminject(self, injection):
        '''Sql inject into a form.'''
        page = request.post(self.url, data=injection)
        return page.content()
