﻿

/* map-view.js */
Exhibit.MapView=function(C,B){Exhibit.MapView._initialize();
this._div=C;
this._uiContext=B;
this._settings={};
this._accessors={getProxy:function(F,E,D){D(F);
},getColorKey:null,getSizeKey:null,getIconKey:null,getIcon:null};
this._colorCoder=null;
this._sizeCoder=null;
this._iconCoder=null;
this._selectListener=null;
this._itemIDToMarker={};
var A=this;
this._listener={onItemsChanged:function(){A._reconstruct();
}};
B.getCollection().addListener(this._listener);
};
Exhibit.MapView._settingSpecs={"center":{type:"float",defaultValue:[20,0],dimensions:2},"zoom":{type:"float",defaultValue:2},"size":{type:"text",defaultValue:"small"},"scaleControl":{type:"boolean",defaultValue:true},"overviewControl":{type:"boolean",defaultValue:false},"type":{type:"enum",defaultValue:"normal",choices:["normal","satellite","hybrid"]},"bubbleTip":{type:"enum",defaultValue:"top",choices:["top","bottom"]},"mapHeight":{type:"int",defaultValue:400},"mapConstructor":{type:"function",defaultValue:null},"color":{type:"text",defaultValue:"#FF9000"},"colorCoder":{type:"text",defaultValue:null},"sizeCoder":{type:"text",defaultValue:null},"iconCoder":{type:"text",defaultValue:null},"selectCoordinator":{type:"text",defaultValue:null},"iconSize":{type:"int",defaultValue:0},"iconFit":{type:"text",defaultValue:"smaller"},"iconScale":{type:"float",defaultValue:1},"iconOffsetX":{type:"float",defaultValue:0},"iconOffsetY":{type:"float",defaultValue:0},"shape":{type:"text",defaultValue:"circle"},"shapeWidth":{type:"int",defaultValue:24},"shapeHeight":{type:"int",defaultValue:24},"shapeAlpha":{type:"float",defaultValue:0.7},"pin":{type:"boolean",defaultValue:true},"pinHeight":{type:"int",defaultValue:6},"pinWidth":{type:"int",defaultValue:6},"sizeLegendLabel":{type:"text",defaultValue:null},"colorLegendLabel":{type:"text",defaultValue:null},"iconLegendLabel":{type:"text",defaultValue:null},"markerScale":{type:"text",defaultValue:null},"showHeader":{type:"boolean",defaultValue:true},"showSummary":{type:"boolean",defaultValue:true},"showFooter":{type:"boolean",defaultValue:true},"showToolbox":{type:"boolean",defaultValue:true}};
Exhibit.MapView._accessorSpecs=[{accessorName:"getProxy",attributeName:"proxy"},{accessorName:"getLatlng",alternatives:[{bindings:[{attributeName:"latlng",types:["float","float"],bindingNames:["lat","lng"]},{attributeName:"maxAutoZoom",type:"float",bindingName:"maxAutoZoom",optional:true}]},{bindings:[{attributeName:"lat",type:"float",bindingName:"lat"},{attributeName:"lng",type:"float",bindingName:"lng"},{attributeName:"maxAutoZoom",type:"float",bindingName:"maxAutoZoom",optional:true}]}]},{accessorName:"getColorKey",attributeName:"marker",type:"text"},{accessorName:"getColorKey",attributeName:"colorKey",type:"text"},{accessorName:"getSizeKey",attributeName:"sizeKey",type:"text"},{accessorName:"getIconKey",attributeName:"iconKey",type:"text"},{accessorName:"getIcon",attributeName:"icon",type:"url"}];
Exhibit.MapView._initialize=function(){var B=[];
var F=document.documentElement.getElementsByTagName("head");
for(var C=0;
C<F.length;
C++){var E=F[C].getElementsByTagName("link");
for(var A=0;
A<E.length;
A++){var D=E[A];
if(D.rel.match(/\bexhibit\/map-painter\b/)){Exhibit.MapView._markerUrlPrefix=D.href+"?";
}}}Exhibit.MapView._initialize=function(){};
};
Exhibit.MapView.create=function(D,C,B){var A=new Exhibit.MapView(C,Exhibit.UIContext.create(D,B));
Exhibit.MapView._configure(A,D);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.MapView.createFromDOM=function(D,C,B){var E=Exhibit.getConfigurationFromDOM(D);
var A=new Exhibit.MapView(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,B));
Exhibit.SettingsUtilities.createAccessorsFromDOM(D,Exhibit.MapView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettingsFromDOM(D,Exhibit.MapView._settingSpecs,A._settings);
Exhibit.MapView._configure(A,E);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.MapView._configure=function(A,C){Exhibit.SettingsUtilities.createAccessors(C,Exhibit.MapView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettings(C,Exhibit.MapView._settingSpecs,A._settings);
var B=A._accessors;
A._getLatlng=function(F,E,D){B.getProxy(F,E,function(G){B.getLatlng(G,E,D);
});
};
};
Exhibit.MapView.lookupLatLng=function(H,J,A,F,I,B){if(B==undefined){B=4;
}var G=Exhibit.ExpressionParser.parse(J);
var D=[];
H.visit(function(M){var L=G.evaluateSingle({"value":M},{"value":"item"},"value",I).value;
if(L!=null){D.push({item:M,address:L});
}});
var E=[];
var C=new GClientGeocoder();
var K=function(){if(D.length>0){var L=D.shift();
C.getLocations(L.address,function(O){if("Placemark" in O){O.Placemark.sort(function(S,R){return R.AddressDetails.Accuracy-S.AddressDetails.Accuracy;
});
}if("Placemark" in O&&O.Placemark.length>0&&O.Placemark[0].AddressDetails.Accuracy>=B){var P=O.Placemark[0].Point.coordinates;
var Q=P[1];
var N=P[0];
E.push("\t{ id: '"+L.item+"', "+A+": '"+Q+","+N+"' }");
}else{var M=L.address.split(",");
if(M.length==1){E.push("\t{ id: '"+L.item+"' }");
}else{L.address=M.slice(1).join(",").replace(/^\s+/,"");
D.unshift(L);
}}K();
});
}else{F.value=E.join(",\n");
}};
K();
};
Exhibit.MapView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
this._map=null;
if(this._selectListener!=null){this._selectListener.dispose();
this._selectListener=null;
}this._itemIDToMarker={};
if(this._settings.showToolbox){this._toolboxWidget.dispose();
this._toolboxWidget=null;
}this._dom.dispose();
this._dom=null;
this._uiContext.dispose();
this._uiContext=null;
this._div.innerHTML="";
this._div=null;
GUnload();
};
Exhibit.MapView.prototype._internalValidate=function(){var B=this._uiContext.getExhibit();
if(this._accessors.getColorKey!=null){if(this._settings.colorCoder!=null){this._colorCoder=B.getComponent(this._settings.colorCoder);
}if(this._colorCoder==null){this._colorCoder=new Exhibit.DefaultColorCoder(this._uiContext);
}}if(this._accessors.getSizeKey!=null){if(this._settings.sizeCoder!=null){this._sizeCoder=B.getComponent(this._settings.sizeCoder);
if("markerScale" in this._settings){this._sizeCoder._settings.markerScale=this._settings.markerScale;
}}}if(this._accessors.getIconKey!=null){if(this._settings.iconCoder!=null){this._iconCoder=B.getComponent(this._settings.iconCoder);
}}if("selectCoordinator" in this._settings){var C=B.getComponent(this._settings.selectCoordinator);
if(C!=null){var A=this;
this._selectListener=C.addListener(function(D){A._select(D);
});
}}};
Exhibit.MapView.prototype._initializeUI=function(){var B=this;
var C={};
C.colorGradient=(this._colorCoder!=null&&"_gradientPoints" in this._colorCoder);
C.colorMarkerGenerator=this._createColorMarkerGenerator();
C.sizeMarkerGenerator=this._createSizeMarkerGenerator();
C.iconMarkerGenerator=this._createIconMarkerGenerator();
this._div.innerHTML="";
this._dom=Exhibit.ViewUtilities.constructPlottingViewDom(this._div,this._uiContext,this._settings.showSummary&&this._settings.showHeader,{onResize:function(){B._map.checkResize();
}},C);
if(this._settings.showToolbox){this._toolboxWidget=Exhibit.ToolboxWidget.createFromDOM(this._div,this._div,this._uiContext);
}var A=this._dom.plotContainer;
A.style.height=this._settings.mapHeight+"px";
A.className="exhibit-mapView-map";
this._map=this._constructGMap(A);
this._reconstruct();
};
Exhibit.MapView.prototype._constructGMap=function(A){var B=this._settings;
if(B.mapConstructor!=null){return B.mapConstructor(A);
}else{var C=new GMap2(A);
C.enableDoubleClickZoom();
C.enableContinuousZoom();
C.setCenter(new GLatLng(B.center[0],B.center[1]),B.zoom);
C.addControl(B.size=="small"?new GSmallMapControl():new GLargeMapControl());
if(B.overviewControl){C.addControl(new GOverviewMapControl);
}if(B.scaleControl){C.addControl(new GScaleControl());
}C.addControl(new GMapTypeControl());
switch(B.type){case"normal":C.setMapType(G_NORMAL_MAP);
break;
case"satellite":C.setMapType(G_SATELLITE_MAP);
break;
case"hybrid":C.setMapType(G_HYBRID_MAP);
break;
}return C;
}};
Exhibit.MapView.prototype._createColorMarkerGenerator=function(){var A=this._settings.shape;
return function(B){return SimileAjax.Graphics.createTranslucentImage(Exhibit.MapView._markerUrlPrefix+"?renderer=map-marker&shape="+A+"&width=20&height=20&pinHeight=5&background="+B.substr(1),"middle");
};
};
Exhibit.MapView.prototype._createSizeMarkerGenerator=function(){var A=this._settings.shape;
return function(B){return SimileAjax.Graphics.createTranslucentImage(Exhibit.MapView._markerUrlPrefix+"?renderer=map-marker&shape="+A+"&width="+B+"&height="+B+"&pinHeight=0","middle");
};
};
Exhibit.MapView.prototype._createIconMarkerGenerator=function(){return function(A){elmt=document.createElement("img");
elmt.src=A;
elmt.style.verticalAlign="middle";
elmt.style.height="40px";
return elmt;
};
};
Exhibit.MapView.prototype._reconstruct=function(){this._map.clearOverlays();
this._dom.legendWidget.clear();
this._itemIDToMarker={};
var B=this._uiContext.getCollection().countRestrictedItems();
var A=[];
if(B>0){this._rePlotItems(A);
}this._dom.setUnplottableMessage(B,A);
};
Exhibit.MapView.prototype._rePlotItems=function(P){var O=this;
var M=this._uiContext.getCollection();
var L=this._uiContext.getDatabase();
var e=this._settings;
var g=this._accessors;
var C=M.getRestrictedItems();
var f={};
var F=(this._accessors.getColorKey!=null);
var Y=(this._accessors.getSizeKey!=null);
var D=(this._accessors.getIconKey!=null);
var R=(this._accessors.getIcon!=null);
C.visit(function(j){var i=[];
O._getLatlng(j,L,function(n){if(n!=null&&"lat" in n&&"lng" in n){i.push(n);
}});
if(i.length>0){var q=null;
if(F){q=new Exhibit.Set();
g.getColorKey(j,L,function(n){q.add(n);
});
}var m=null;
if(Y){m=new Exhibit.Set();
g.getSizeKey(j,L,function(n){m.add(n);
});
}var p=null;
if(D){p=new Exhibit.Set();
g.getIconKey(j,L,function(n){p.add(n);
});
}for(var l=0;
l<i.length;
l++){var k=i[l];
var r=k.lat+","+k.lng;
if(r in f){var o=f[r];
o.items.push(j);
if(F){o.colorKeys.addSet(q);
}if(Y){o.sizeKeys.addSet(m);
}if(D){o.iconKeys.addSet(p);
}}else{var o={latlng:k,items:[j]};
if(F){o.colorKeys=q;
}if(Y){o.sizeKeys=m;
}if(D){o.iconKeys=p;
}f[r]=o;
}}}else{P.push(j);
}});
var I={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var S={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var Q={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var G,E=Infinity;
var T=function(l){var i=l.items.length;
if(!G){G=new GLatLngBounds();
}var m=O._settings.shape;
var j=O._settings.color;
if(F){j=O._colorCoder.translateSet(l.colorKeys,I);
}var n=O._settings.iconSize;
if(Y){n=O._sizeCoder.translateSet(l.sizeKeys,S);
}var o=null;
if(i==1){if(R){g.getIcon(l.items[0],L,function(r){o=r;
});
}}if(D){o=O._iconCoder.translateSet(l.iconKeys,Q);
}var o=Exhibit.MapView._makeIcon(m,j,n,i==1?"":i.toString(),o,O._settings);
var q=new GLatLng(l.latlng.lat,l.latlng.lng);
var k=new GMarker(q,o);
if(E>l.latlng.maxAutoZoom){E=l.latlng.maxAutoZoom;
}G.extend(q);
GEvent.addListener(k,"click",function(){k.openInfoWindow(O._createInfoWindow(l.items));
if(O._selectListener!=null){O._selectListener.fire({itemIDs:l.items});
}});
O._map.addOverlay(k);
for(var p=0;
p<l.items.length;
p++){O._itemIDToMarker[l.items[p]]=k;
}};
for(var B in f){T(f[B]);
}if(F){var a=this._dom.legendWidget;
var Z=this._colorCoder;
var K=I.keys.toArray().sort();
if(e.colorLegendLabel!==null){a.addLegendLabel(e.colorLegendLabel,"color");
}if(Z._gradientPoints!=null){var J=this._dom.legendWidget;
J.addGradient(this._colorCoder._gradientPoints);
}else{for(var V=0;
V<K.length;
V++){var h=K[V];
var U=Z.translate(h);
a.addEntry(U,h);
}}if(I.others){a.addEntry(Z.getOthersColor(),Z.getOthersLabel());
}if(I.mixed){a.addEntry(Z.getMixedColor(),Z.getMixedLabel());
}if(I.missing){a.addEntry(Z.getMissingColor(),Z.getMissingLabel());
}}if(Y){var a=this._dom.legendWidget;
var d=this._sizeCoder;
var K=S.keys.toArray().sort();
if(e.sizeLegendLabel!==null){a.addLegendLabel(e.sizeLegendLabel,"size");
}if(d._gradientPoints!=null){var X=d._gradientPoints;
var c=(X[X.length-1].value-X[0].value)/5;
K=[];
for(var W=0;
W<6;
W++){K.push(Math.floor(X[0].value+c*W));
}for(var V=0;
V<K.length;
V++){var h=K[V];
var N=d.translate(h);
a.addEntry(N,h,"size");
}}else{for(var V=0;
V<K.length;
V++){var h=K[V];
var N=d.translate(h);
a.addEntry(N,h,"size");
}if(S.others){a.addEntry(d.getOthersSize(),d.getOthersLabel(),"size");
}if(S.mixed){a.addEntry(d.getMixedSize(),d.getMixedLabel(),"size");
}if(S.missing){a.addEntry(d.getMissingSize(),d.getMissingLabel(),"size");
}}}if(D){var a=this._dom.legendWidget;
var H=this._iconCoder;
var K=Q.keys.toArray().sort();
if(e.iconLegendLabel!=null){a.addLegendLabel(e.iconLegendLabel,"icon");
}for(var V=0;
V<K.length;
V++){var h=K[V];
var b=H.translate(h);
a.addEntry(b,h,"icon");
}if(Q.others){a.addEntry(H.getOthersIcon(),H.getOthersLabel(),"icon");
}if(Q.mixed){a.addEntry(H.getMixedIcon(),H.getMixedLabel(),"icon");
}if(Q.missing){a.addEntry(H.getMissingIcon(),H.getMissingLabel(),"icon");
}}if(G&&typeof e.zoom=="undefined"){var A=Math.max(0,O._map.getBoundsZoomLevel(G)-1);
A=Math.min(A,E,e.maxAutoZoom);
O._map.setZoom(A);
}if(G&&typeof e.center=="undefined"){O._map.setCenter(G.getCenter());
}};
Exhibit.MapView.prototype._select=function(B){var C=B.itemIDs[0];
var A=this._itemIDToMarker[C];
if(A){A.openInfoWindow(this._createInfoWindow([C]));
}};
Exhibit.MapView.prototype._createInfoWindow=function(A){return Exhibit.ViewUtilities.fillBubbleWithItems(null,A,this._uiContext);
};
Exhibit.MapView._iconData=null;
Exhibit.MapView._markerUrlPrefix="http://service.simile-widgets.org/painter/painter?";
Exhibit.MapView._defaultMarkerShape="circle";
Exhibit.MapView._makeIcon=function(L,G,M,O,K,E){var D=O.length*3;
var I=Math.ceil(E.shapeWidth/2)+D;
var Q=E.shapeHeight;
var B=I*2;
var P=Q;
if(M>0){B=M;
I=Math.ceil(M/2);
P=M;
Q=M;
E.pin=false;
}var N=new GIcon();
var H=["renderer=map-marker","shape="+L,"alpha="+E.shapeAlpha,"width="+B,"height="+Q,"background="+G.substr(1),"label="+O];
var A=["renderer=map-marker-shadow","shape="+L,"width="+B,"height="+Q];
var J=[];
if(K!=null){H.push("icon="+K);
if(E.iconFit!="smaller"){H.push("iconFit="+E.iconFit);
}if(E.iconScale!=1){H.push("iconScale="+E.iconScale);
}if(E.iconOffsetX!=1){H.push("iconX="+E.iconOffsetX);
}if(E.iconOffsetY!=1){H.push("iconY="+E.iconOffsetY);
}}if(E.pin){var F=E.pinHeight;
var C=Math.ceil(E.pinWidth/2);
P+=F;
J.push("pinHeight="+F);
J.push("pinWidth="+(C*2));
N.iconAnchor=new GPoint(I,P);
N.imageMap=[0,0,0,Q,I-C,Q,I,P,I+C,Q,B,Q,B,0];
N.shadowSize=new GSize(B*1.5,P-2);
N.infoWindowAnchor=(E.bubbleTip=="bottom")?new GPoint(I,P):new GPoint(I,0);
}else{J.push("pin=false");
N.iconAnchor=new GPoint(I,Math.ceil(P/2));
N.imageMap=[0,0,0,Q,B,Q,B,0];
N.infoWindowAnchor=new GPoint(I,0);
}N.image=Exhibit.MapView._markerUrlPrefix+H.concat(J).join("&")+"&.png";
if(M==0){N.shadow=Exhibit.MapView._markerUrlPrefix+A.concat(J).join("&")+"&.png";
}N.iconSize=new GSize(B,P);
N.shadowSize=new GSize(B*1.5,P-2);
return N;
};


/* vemap-view.js */
Exhibit.VEMapView=function(C,B){this._div=C;
this._uiContext=B;
this._settings={};
this._accessors={getProxy:function(F,E,D){D(F);
},getColorKey:null,getIcon:null};
this._colorCoder=null;
var A=this;
this._listener={onItemsChanged:function(){A._reconstruct();
}};
B.getCollection().addListener(this._listener);
};
Exhibit.VEMapView._id=1;
Exhibit.VEMapView._settingSpecs={"center":{type:"float",defaultValue:[20,0],dimensions:2},"zoom":{type:"float",defaultValue:2},"size":{type:"text",defaultValue:"small"},"scaleControl":{type:"boolean",defaultValue:true},"overviewControl":{type:"boolean",defaultValue:false},"type":{type:"enum",defaultValue:"normal",choices:["normal","satellite","hybrid"]},"bubbleTip":{type:"enum",defaultValue:"top",choices:["top","bottom"]},"mapHeight":{type:"int",defaultValue:400},"mapConstructor":{type:"function",defaultValue:null},"color":{type:"text",defaultValue:"#FF9000"},"colorCoder":{type:"text",defaultValue:null},"iconScale":{type:"float",defaultValue:1},"iconOffsetX":{type:"float",defaultValue:0},"iconOffsetY":{type:"float",defaultValue:0},"shape":{type:"text",defaultValue:"circle"},"bodyWidth":{type:"int",defaultValue:24},"bodyHeight":{type:"int",defaultValue:24},"pin":{type:"boolean",defaultValue:true},"pinHeight":{type:"int",defaultValue:6},"pinWidth":{type:"int",defaultValue:6}};
Exhibit.VEMapView._accessorSpecs=[{accessorName:"getProxy",attributeName:"proxy"},{accessorName:"getLatlng",alternatives:[{bindings:[{attributeName:"latlng",types:["float","float"],bindingNames:["lat","lng"]},{attributeName:"maxAutoZoom",type:"float",bindingName:"maxAutoZoom",optional:true}]},{bindings:[{attributeName:"lat",type:"float",bindingName:"lat"},{attributeName:"lng",type:"float",bindingName:"lng"},{attributeName:"maxAutoZoom",type:"float",bindingName:"maxAutoZoom",optional:true}]}]},{accessorName:"getColorKey",attributeName:"marker",type:"text"},{accessorName:"getColorKey",attributeName:"colorKey",type:"text"},{accessorName:"getIcon",attributeName:"icon",type:"url"}];
Exhibit.VEMapView.create=function(D,C,B){var A=new Exhibit.VEMapView(C,Exhibit.UIContext.create(D,B));
Exhibit.VEMapView._configure(A,D);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.VEMapView.createFromDOM=function(D,C,B){var E=Exhibit.getConfigurationFromDOM(D);
var A=new Exhibit.VEMapView(C!=null?C:D,Exhibit.UIContext.createFromDOM(D,B));
Exhibit.SettingsUtilities.createAccessorsFromDOM(D,Exhibit.VEMapView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettingsFromDOM(D,Exhibit.VEMapView._settingSpecs,A._settings);
Exhibit.VEMapView._configure(A,E);
A._internalValidate();
A._initializeUI();
return A;
};
Exhibit.VEMapView._configure=function(A,C){Exhibit.SettingsUtilities.createAccessors(C,Exhibit.VEMapView._accessorSpecs,A._accessors);
Exhibit.SettingsUtilities.collectSettings(C,Exhibit.VEMapView._settingSpecs,A._settings);
var B=A._accessors;
A._getLatlng=function(F,E,D){B.getProxy(F,E,function(G){B.getLatlng(G,E,D);
});
};
};
Exhibit.VEMapView.prototype.dispose=function(){this._uiContext.getCollection().removeListener(this._listener);
this._map=null;
this._toolboxWidget.dispose();
this._toolboxWidget=null;
this._dom.dispose();
this._dom=null;
this._uiContext.dispose();
this._uiContext=null;
this._div.innerHTML="";
this._div=null;
};
Exhibit.VEMapView.prototype._internalValidate=function(){if("getColorKey" in this._accessors){if("colorCoder" in this._settings){this._colorCoder=this._uiContext.getExhibit().getComponent(this._settings.colorCoder);
}if(this._colorCoder==null){this._colorCoder=new Exhibit.DefaultColorCoder(this._uiContext);
}}};
Exhibit.VEMapView.prototype._initializeUI=function(){var B=this;
var C=this._settings;
var D="_gradientPoints" in this._colorCoder?"gradient":{markerGenerator:function(F){var E="square";
return SimileAjax.Graphics.createTranslucentImage(Exhibit.MapView._markerUrlPrefix+"?renderer=map-marker&shape="+Exhibit.MapView._defaultMarkerShape+"&width=20&height=20&pinHeight=0&background="+F.substr(1),"middle");
}};
this._div.innerHTML="";
this._dom=Exhibit.ViewUtilities.constructPlottingViewDom(this._div,this._uiContext,true,{},D);
this._toolboxWidget=Exhibit.ToolboxWidget.createFromDOM(this._div,this._div,this._uiContext);
var A=this._dom.plotContainer;
A.style.height=C.mapHeight+"px";
A.className="exhibit-mapView-map";
A.style.position="relative";
A.id="map-"+Exhibit.VEMapView._id++;
var C=this._settings;
if(C._mapConstructor!=null){this._map=C._mapConstructor(A);
}else{this._map=new VEMap(A.id);
this._map.LoadMap(new VELatLong(C.center[0],C.center[1]),C.zoom);
}this._reconstruct();
};
Exhibit.VEMapView.prototype._reconstruct=function(){var L=this;
var K=this._uiContext.getCollection();
var J=this._uiContext.getDatabase();
var T=this._settings;
var V=this._accessors;
var A=K.countAllItems();
var B=K.countRestrictedItems();
var M=[];
this._map.DeleteAllShapeLayers();
this._dom.legendWidget.clear();
if(B>0){var D=K.getRestrictedItems();
var U={};
var F=(this._accessors.getColorKey!=null);
var N=(this._accessors.getIcon!=null);
D.visit(function(b){var X=[];
L._getLatlng(b,J,function(e){if(e!=null&&"lat" in e&&"lng" in e){X.push(e);
}});
if(X.length>0){var Z=null;
if(F){Z=new Exhibit.Set();
V.getColorKey(b,J,function(e){Z.add(e);
});
}for(var d=0;
d<X.length;
d++){var c=X[d];
var Y=c.lat+","+c.lng;
if(Y in U){var a=U[Y];
a.items.push(b);
if(F){a.colorKeys.addSet(Z);
}}else{var a={latlng:c,items:[b]};
if(F){a.colorKeys=Z;
}U[Y]=a;
}}}else{M.push(b);
}});
var H={mixed:false,missing:false,others:false,keys:new Exhibit.Set()};
var G,E=Infinity;
var O=function(a){var X=a.items.length;
var c=L._settings.shape;
var Y=L._settings.color;
if(F){Y=L._colorCoder.translateSet(a.colorKeys,H);
}var d=null;
if(X==1){if(N){V.getIcon(a.items[0],J,function(h){d=h;
});
}}var d=Exhibit.VEMapView._makeIcon(c,Y,X==1?"":X.toString(),d,L._settings);
var b=new VEShapeLayer();
var f=new VELatLong(a.latlng.lat,a.latlng.lng);
var Z=new VEShape(VEShapeType.Pushpin,f);
var e=a.items[0];
var g=L._createDescription(a.items);
Z.SetCustomIcon(d);
Z.SetTitle(e);
Z.SetDescription(g);
Z.SetIconAnchor(f);
L._map.AddShapeLayer(b);
b.AddShape(Z);
};
for(var C in U){O(U[C]);
}if(F){var S=this._dom.legendWidget;
var R=this._colorCoder;
var I=H.keys.toArray().sort();
if(this._colorCoder._gradientPoints!=null){S.addGradient(this._colorCoder._gradientPoints);
}else{for(var Q=0;
Q<I.length;
Q++){var W=I[Q];
var P=R.translate(W);
S.addEntry(P,W);
}}if(H.others){S.addEntry(R.getOthersColor(),R.getOthersLabel());
}if(H.mixed){S.addEntry(R.getMixedColor(),R.getMixedLabel());
}if(H.missing){S.addEntry(R.getMissingColor(),R.getMissingLabel());
}}}this._dom.setUnplottableMessage(B,M);
};
Exhibit.VEMapView.prototype._createDescription=function(B){var C=Exhibit.ViewUtilities.fillBubbleWithItems(null,B,this._uiContext);
var A=document.createElement("div");
A.appendChild(C);
return A.innerHTML;
};
Exhibit.VEMapView._iconData=null;
Exhibit.VEMapView._markerUrlPrefix="http://simile.mit.edu/painter/painter?";
Exhibit.VEMapView._defaultMarkerShape="circle";
Exhibit.VEMapView._makeIcon=function(K,F,M,J,D){var C=M.length*3;
var H=Math.ceil(D.bodyWidth/2)+C;
var O=D.bodyHeight;
var A=H*2;
var N=O;
var L=new VECustomIconSpecification;
var G=["renderer=map-marker","shape="+K,"width="+A,"height="+O,"background="+F.substr(1),"label="+M];
var I=[];
if(J!=null){G.push("icon="+J);
if(D.iconScale!=1){G.push("iconScale="+D.iconScale);
}if(D.iconOffsetX!=1){G.push("iconX="+D.iconOffsetX);
}if(D.iconOffsetY!=1){G.push("iconY="+D.iconOffsetY);
}}if(D.pin){var E=D.pinHeight;
var B=Math.ceil(D.pinWidth/4);
N+=E;
I.push("pinHeight="+E);
I.push("pinWidth="+(B*2));
}else{I.push("pin=false");
}L.TextContent=" ";
L.Image=Exhibit.MapView._markerUrlPrefix+G.concat(I).join("&");
L.ImageHeight=N;
L.ImageWidth=A;
return L;
};
