# Copyright 2010 Boris Figovsky <borfig@gmail.com>
#
# This file is part of pybfc.

# pybfc is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# pybfc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with pybfc.  If not, see <http://www.gnu.org/licenses/>.
"""
A handly wrapper for the exec statement

>>> code = '''
... bug = 5
... foo = bug
... foo = bar()
... del bug
... '''
>>> def bar(): return 5
>>> l = {}
>>> wrapped_exec(code, l, ({'bar':bar},))
>>> l
{'foo': 5}

"""

__all__ = ['wrapped_exec', 'ExecutionContext']

class ExecutionContext(object):
    __slots__ = ['_locals', '_readonly_parts','_chain']

    def __init__(self, locals, readonly_parts = ()):
        self._locals = locals
        self._readonly_parts = readonly_parts

    def __getitem__(self, key):
        for part in self._readonly_parts:
            try:
                return part[key]
            except KeyError:
                pass
        return self._locals[key]

    def __setitem__(self, key, value):
        assert all(key not in part for part in self._readonly_parts)
        self._locals[key] = value

    def __delitem__(self, key):
        assert all(key not in part for part in self._readonly_parts)
        del self._locals[key]

def wrapped_exec(executed, locals, readonly_parts = ()):
    exec executed in {}, ExecutionContext(locals, readonly_parts)
