# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._cost_management_client_enums import *


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = None


class Alert(Resource):
    """An individual alert.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param definition: defines the type of alert.
    :type definition: ~azure.mgmt.costmanagement.models.AlertPropertiesDefinition
    :param description: Alert description.
    :type description: str
    :param source: Source of alert. Possible values include: "Preset", "User".
    :type source: str or ~azure.mgmt.costmanagement.models.AlertSource
    :param details: Alert details.
    :type details: ~azure.mgmt.costmanagement.models.AlertPropertiesDetails
    :param cost_entity_id: related budget.
    :type cost_entity_id: str
    :param status: alert status. Possible values include: "None", "Active", "Overridden",
     "Resolved", "Dismissed".
    :type status: str or ~azure.mgmt.costmanagement.models.AlertStatus
    :param creation_time: dateTime in which alert was created.
    :type creation_time: str
    :param close_time: dateTime in which alert was closed.
    :type close_time: str
    :param modification_time: dateTime in which alert was last modified.
    :type modification_time: str
    :param status_modification_user_name:
    :type status_modification_user_name: str
    :param status_modification_time: dateTime in which the alert status was last modified.
    :type status_modification_time: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'definition': {'key': 'properties.definition', 'type': 'AlertPropertiesDefinition'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'details': {'key': 'properties.details', 'type': 'AlertPropertiesDetails'},
        'cost_entity_id': {'key': 'properties.costEntityId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'str'},
        'close_time': {'key': 'properties.closeTime', 'type': 'str'},
        'modification_time': {'key': 'properties.modificationTime', 'type': 'str'},
        'status_modification_user_name': {'key': 'properties.statusModificationUserName', 'type': 'str'},
        'status_modification_time': {'key': 'properties.statusModificationTime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        definition: Optional["AlertPropertiesDefinition"] = None,
        description: Optional[str] = None,
        source: Optional[Union[str, "AlertSource"]] = None,
        details: Optional["AlertPropertiesDetails"] = None,
        cost_entity_id: Optional[str] = None,
        status: Optional[Union[str, "AlertStatus"]] = None,
        creation_time: Optional[str] = None,
        close_time: Optional[str] = None,
        modification_time: Optional[str] = None,
        status_modification_user_name: Optional[str] = None,
        status_modification_time: Optional[str] = None,
        **kwargs
    ):
        super(Alert, self).__init__(**kwargs)
        self.definition = definition
        self.description = description
        self.source = source
        self.details = details
        self.cost_entity_id = cost_entity_id
        self.status = status
        self.creation_time = creation_time
        self.close_time = close_time
        self.modification_time = modification_time
        self.status_modification_user_name = status_modification_user_name
        self.status_modification_time = status_modification_time


class AlertPropertiesDefinition(msrest.serialization.Model):
    """defines the type of alert.

    :param type: type of alert. Possible values include: "Budget", "Invoice", "Credit", "Quota",
     "General", "xCloud", "BudgetForecast".
    :type type: str or ~azure.mgmt.costmanagement.models.AlertType
    :param category: Alert category. Possible values include: "Cost", "Usage", "Billing", "System".
    :type category: str or ~azure.mgmt.costmanagement.models.AlertCategory
    :param criteria: Criteria that triggered alert. Possible values include:
     "CostThresholdExceeded", "UsageThresholdExceeded", "CreditThresholdApproaching",
     "CreditThresholdReached", "QuotaThresholdApproaching", "QuotaThresholdReached",
     "MultiCurrency", "ForecastCostThresholdExceeded", "ForecastUsageThresholdExceeded",
     "InvoiceDueDateApproaching", "InvoiceDueDateReached", "CrossCloudNewDataAvailable",
     "CrossCloudCollectionError", "GeneralThresholdError".
    :type criteria: str or ~azure.mgmt.costmanagement.models.AlertCriteria
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'criteria': {'key': 'criteria', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "AlertType"]] = None,
        category: Optional[Union[str, "AlertCategory"]] = None,
        criteria: Optional[Union[str, "AlertCriteria"]] = None,
        **kwargs
    ):
        super(AlertPropertiesDefinition, self).__init__(**kwargs)
        self.type = type
        self.category = category
        self.criteria = criteria


class AlertPropertiesDetails(msrest.serialization.Model):
    """Alert details.

    :param time_grain_type: Type of timegrain cadence. Possible values include: "None", "Monthly",
     "Quarterly", "Annually", "BillingMonth", "BillingQuarter", "BillingAnnual".
    :type time_grain_type: str or ~azure.mgmt.costmanagement.models.AlertTimeGrainType
    :param period_start_date: datetime of periodStartDate.
    :type period_start_date: str
    :param triggered_by: notificationId that triggered this alert.
    :type triggered_by: str
    :param resource_group_filter: array of resourceGroups to filter by.
    :type resource_group_filter: list[any]
    :param resource_filter: array of resources to filter by.
    :type resource_filter: list[any]
    :param meter_filter: array of meters to filter by.
    :type meter_filter: list[any]
    :param tag_filter: tags to filter by.
    :type tag_filter: any
    :param threshold: notification threshold percentage as a decimal which activated this alert.
    :type threshold: float
    :param operator: operator used to compare currentSpend with amount. Possible values include:
     "None", "EqualTo", "GreaterThan", "GreaterThanOrEqualTo", "LessThan", "LessThanOrEqualTo".
    :type operator: str or ~azure.mgmt.costmanagement.models.AlertOperator
    :param amount: budget threshold amount.
    :type amount: float
    :param unit: unit of currency being used.
    :type unit: str
    :param current_spend: current spend.
    :type current_spend: float
    :param contact_emails: list of emails to contact.
    :type contact_emails: list[str]
    :param contact_groups: list of action groups to broadcast to.
    :type contact_groups: list[str]
    :param contact_roles: list of contact roles.
    :type contact_roles: list[str]
    :param overriding_alert: overriding alert.
    :type overriding_alert: str
    """

    _attribute_map = {
        'time_grain_type': {'key': 'timeGrainType', 'type': 'str'},
        'period_start_date': {'key': 'periodStartDate', 'type': 'str'},
        'triggered_by': {'key': 'triggeredBy', 'type': 'str'},
        'resource_group_filter': {'key': 'resourceGroupFilter', 'type': '[object]'},
        'resource_filter': {'key': 'resourceFilter', 'type': '[object]'},
        'meter_filter': {'key': 'meterFilter', 'type': '[object]'},
        'tag_filter': {'key': 'tagFilter', 'type': 'object'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'operator': {'key': 'operator', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_spend': {'key': 'currentSpend', 'type': 'float'},
        'contact_emails': {'key': 'contactEmails', 'type': '[str]'},
        'contact_groups': {'key': 'contactGroups', 'type': '[str]'},
        'contact_roles': {'key': 'contactRoles', 'type': '[str]'},
        'overriding_alert': {'key': 'overridingAlert', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time_grain_type: Optional[Union[str, "AlertTimeGrainType"]] = None,
        period_start_date: Optional[str] = None,
        triggered_by: Optional[str] = None,
        resource_group_filter: Optional[List[Any]] = None,
        resource_filter: Optional[List[Any]] = None,
        meter_filter: Optional[List[Any]] = None,
        tag_filter: Optional[Any] = None,
        threshold: Optional[float] = None,
        operator: Optional[Union[str, "AlertOperator"]] = None,
        amount: Optional[float] = None,
        unit: Optional[str] = None,
        current_spend: Optional[float] = None,
        contact_emails: Optional[List[str]] = None,
        contact_groups: Optional[List[str]] = None,
        contact_roles: Optional[List[str]] = None,
        overriding_alert: Optional[str] = None,
        **kwargs
    ):
        super(AlertPropertiesDetails, self).__init__(**kwargs)
        self.time_grain_type = time_grain_type
        self.period_start_date = period_start_date
        self.triggered_by = triggered_by
        self.resource_group_filter = resource_group_filter
        self.resource_filter = resource_filter
        self.meter_filter = meter_filter
        self.tag_filter = tag_filter
        self.threshold = threshold
        self.operator = operator
        self.amount = amount
        self.unit = unit
        self.current_spend = current_spend
        self.contact_emails = contact_emails
        self.contact_groups = contact_groups
        self.contact_roles = contact_roles
        self.overriding_alert = overriding_alert


class AlertsResult(msrest.serialization.Model):
    """Result of alerts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of alerts.
    :vartype value: list[~azure.mgmt.costmanagement.models.Alert]
    :ivar next_link: URL to get the next set of alerts results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Alert]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertsResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CacheItem(msrest.serialization.Model):
    """CacheItem.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource ID used by Resource Manager to uniquely identify the scope.
    :type id: str
    :param name: Required. Display name for the scope.
    :type name: str
    :param channel: Required. Indicates the account type. Allowed values include: EA, PAYG, Modern,
     Internal, Unknown.
    :type channel: str
    :param subchannel: Required. Indicates the type of modern account. Allowed values include:
     Individual, Enterprise, Partner, Indirect, NotApplicable.
    :type subchannel: str
    :param parent: Resource ID of the parent scope. For instance, subscription's resource ID for a
     resource group or a management group resource ID for a subscription.
    :type parent: str
    :param status: Indicates the status of the scope. Status only applies to subscriptions and
     billing accounts.
    :type status: str
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'channel': {'required': True},
        'subchannel': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'channel': {'key': 'channel', 'type': 'str'},
        'subchannel': {'key': 'subchannel', 'type': 'str'},
        'parent': {'key': 'parent', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        channel: str,
        subchannel: str,
        parent: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(CacheItem, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.channel = channel
        self.subchannel = subchannel
        self.parent = parent
        self.status = status


class CommonExportProperties(msrest.serialization.Model):
    """The common properties of the export.

    All required parameters must be populated in order to send to Azure.

    :param format: The format of the export being delivered. Possible values include: "Csv".
    :type format: str or ~azure.mgmt.costmanagement.models.FormatType
    :param delivery_info: Required. Has delivery information for the export.
    :type delivery_info: ~azure.mgmt.costmanagement.models.ExportDeliveryInfo
    :param definition: Required. Has definition for the export.
    :type definition: ~azure.mgmt.costmanagement.models.ExportDefinition
    """

    _validation = {
        'delivery_info': {'required': True},
        'definition': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'delivery_info': {'key': 'deliveryInfo', 'type': 'ExportDeliveryInfo'},
        'definition': {'key': 'definition', 'type': 'ExportDefinition'},
    }

    def __init__(
        self,
        *,
        delivery_info: "ExportDeliveryInfo",
        definition: "ExportDefinition",
        format: Optional[Union[str, "FormatType"]] = None,
        **kwargs
    ):
        super(CommonExportProperties, self).__init__(**kwargs)
        self.format = format
        self.delivery_info = delivery_info
        self.definition = definition


class Dimension(Resource):
    """Dimension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: Dimension description.
    :vartype description: str
    :ivar filter_enabled: Filter enabled.
    :vartype filter_enabled: bool
    :ivar grouping_enabled: Grouping enabled.
    :vartype grouping_enabled: bool
    :param data:
    :type data: list[str]
    :ivar total: Total number of data for the dimension.
    :vartype total: int
    :ivar category: Dimension category.
    :vartype category: str
    :ivar usage_start: Usage start.
    :vartype usage_start: ~datetime.datetime
    :ivar usage_end: Usage end.
    :vartype usage_end: ~datetime.datetime
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'description': {'readonly': True},
        'filter_enabled': {'readonly': True},
        'grouping_enabled': {'readonly': True},
        'total': {'readonly': True},
        'category': {'readonly': True},
        'usage_start': {'readonly': True},
        'usage_end': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'filter_enabled': {'key': 'properties.filterEnabled', 'type': 'bool'},
        'grouping_enabled': {'key': 'properties.groupingEnabled', 'type': 'bool'},
        'data': {'key': 'properties.data', 'type': '[str]'},
        'total': {'key': 'properties.total', 'type': 'int'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'usage_start': {'key': 'properties.usageStart', 'type': 'iso-8601'},
        'usage_end': {'key': 'properties.usageEnd', 'type': 'iso-8601'},
        'next_link': {'key': 'properties.nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data: Optional[List[str]] = None,
        **kwargs
    ):
        super(Dimension, self).__init__(**kwargs)
        self.description = None
        self.filter_enabled = None
        self.grouping_enabled = None
        self.data = data
        self.total = None
        self.category = None
        self.usage_start = None
        self.usage_end = None
        self.next_link = None


class DimensionsListResult(msrest.serialization.Model):
    """Result of listing dimensions. It contains a list of available dimensions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of dimensions.
    :vartype value: list[~azure.mgmt.costmanagement.models.Dimension]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Dimension]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DimensionsListResult, self).__init__(**kwargs)
        self.value = None


class DismissAlertPayload(msrest.serialization.Model):
    """The request payload to update an alert.

    :param definition: defines the type of alert.
    :type definition: ~azure.mgmt.costmanagement.models.AlertPropertiesDefinition
    :param description: Alert description.
    :type description: str
    :param source: Source of alert. Possible values include: "Preset", "User".
    :type source: str or ~azure.mgmt.costmanagement.models.AlertSource
    :param details: Alert details.
    :type details: ~azure.mgmt.costmanagement.models.AlertPropertiesDetails
    :param cost_entity_id: related budget.
    :type cost_entity_id: str
    :param status: alert status. Possible values include: "None", "Active", "Overridden",
     "Resolved", "Dismissed".
    :type status: str or ~azure.mgmt.costmanagement.models.AlertStatus
    :param creation_time: dateTime in which alert was created.
    :type creation_time: str
    :param close_time: dateTime in which alert was closed.
    :type close_time: str
    :param modification_time: dateTime in which alert was last modified.
    :type modification_time: str
    :param status_modification_user_name:
    :type status_modification_user_name: str
    :param status_modification_time: dateTime in which the alert status was last modified.
    :type status_modification_time: str
    """

    _attribute_map = {
        'definition': {'key': 'properties.definition', 'type': 'AlertPropertiesDefinition'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'details': {'key': 'properties.details', 'type': 'AlertPropertiesDetails'},
        'cost_entity_id': {'key': 'properties.costEntityId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'str'},
        'close_time': {'key': 'properties.closeTime', 'type': 'str'},
        'modification_time': {'key': 'properties.modificationTime', 'type': 'str'},
        'status_modification_user_name': {'key': 'properties.statusModificationUserName', 'type': 'str'},
        'status_modification_time': {'key': 'properties.statusModificationTime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        definition: Optional["AlertPropertiesDefinition"] = None,
        description: Optional[str] = None,
        source: Optional[Union[str, "AlertSource"]] = None,
        details: Optional["AlertPropertiesDetails"] = None,
        cost_entity_id: Optional[str] = None,
        status: Optional[Union[str, "AlertStatus"]] = None,
        creation_time: Optional[str] = None,
        close_time: Optional[str] = None,
        modification_time: Optional[str] = None,
        status_modification_user_name: Optional[str] = None,
        status_modification_time: Optional[str] = None,
        **kwargs
    ):
        super(DismissAlertPayload, self).__init__(**kwargs)
        self.definition = definition
        self.description = description
        self.source = source
        self.details = details
        self.cost_entity_id = cost_entity_id
        self.status = status
        self.creation_time = creation_time
        self.close_time = close_time
        self.modification_time = modification_time
        self.status_modification_user_name = status_modification_user_name
        self.status_modification_time = status_modification_time


class ErrorDetails(msrest.serialization.Model):
    """The details of the error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = None
        self.message = None


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The reason is provided in the error message. 

Some Error responses: 


* 
  429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the "x-ms-ratelimit-microsoft.consumption-retry-after" header. 

* 
  503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time specified in the "Retry-After" header.

    :param error: The details of the error.
    :type error: ~azure.mgmt.costmanagement.models.ErrorDetails
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetails'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetails"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class ProxyResource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :type e_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        e_tag: Optional[str] = None,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.e_tag = e_tag


class Export(ProxyResource):
    """A export resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :type e_tag: str
    :param format: The format of the export being delivered. Possible values include: "Csv".
    :type format: str or ~azure.mgmt.costmanagement.models.FormatType
    :param delivery_info: Has delivery information for the export.
    :type delivery_info: ~azure.mgmt.costmanagement.models.ExportDeliveryInfo
    :param definition: Has definition for the export.
    :type definition: ~azure.mgmt.costmanagement.models.ExportDefinition
    :param schedule: Has schedule information for the export.
    :type schedule: ~azure.mgmt.costmanagement.models.ExportSchedule
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'delivery_info': {'key': 'properties.deliveryInfo', 'type': 'ExportDeliveryInfo'},
        'definition': {'key': 'properties.definition', 'type': 'ExportDefinition'},
        'schedule': {'key': 'properties.schedule', 'type': 'ExportSchedule'},
    }

    def __init__(
        self,
        *,
        e_tag: Optional[str] = None,
        format: Optional[Union[str, "FormatType"]] = None,
        delivery_info: Optional["ExportDeliveryInfo"] = None,
        definition: Optional["ExportDefinition"] = None,
        schedule: Optional["ExportSchedule"] = None,
        **kwargs
    ):
        super(Export, self).__init__(e_tag=e_tag, **kwargs)
        self.format = format
        self.delivery_info = delivery_info
        self.definition = definition
        self.schedule = schedule


class ExportDefinition(msrest.serialization.Model):
    """The definition of a query.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the query. Possible values include: "Usage", "ActualCost",
     "AmortizedCost".
    :type type: str or ~azure.mgmt.costmanagement.models.ExportType
    :param timeframe: Required. The time frame for pulling data for the query. If custom, then a
     specific time period must be provided. Possible values include: "MonthToDate",
     "BillingMonthToDate", "TheLastMonth", "TheLastBillingMonth", "WeekToDate", "Custom".
    :type timeframe: str or ~azure.mgmt.costmanagement.models.TimeframeType
    :param time_period: Has time period for pulling data for the query.
    :type time_period: ~azure.mgmt.costmanagement.models.QueryTimePeriod
    :param data_set: Has definition for data in this query.
    :type data_set: ~azure.mgmt.costmanagement.models.QueryDatasetAutoGenerated
    """

    _validation = {
        'type': {'required': True},
        'timeframe': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'timeframe': {'key': 'timeframe', 'type': 'str'},
        'time_period': {'key': 'timePeriod', 'type': 'QueryTimePeriod'},
        'data_set': {'key': 'dataSet', 'type': 'QueryDatasetAutoGenerated'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ExportType"],
        timeframe: Union[str, "TimeframeType"],
        time_period: Optional["QueryTimePeriod"] = None,
        data_set: Optional["QueryDatasetAutoGenerated"] = None,
        **kwargs
    ):
        super(ExportDefinition, self).__init__(**kwargs)
        self.type = type
        self.timeframe = timeframe
        self.time_period = time_period
        self.data_set = data_set


class ExportDeliveryDestination(msrest.serialization.Model):
    """The destination information for the delivery of the export. To allow access to a storage account, you must register the account's subscription with the Microsoft.CostManagementExports resource provider. This is required once per subscription. When creating an export in the Azure portal, it is done automatically, however API users need to register the subscription. For more information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services .

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The resource id of the storage account where exports will be
     delivered.
    :type resource_id: str
    :param container: Required. The name of the container where exports will be uploaded.
    :type container: str
    :param root_folder_path: The name of the directory where exports will be uploaded.
    :type root_folder_path: str
    """

    _validation = {
        'resource_id': {'required': True},
        'container': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'container': {'key': 'container', 'type': 'str'},
        'root_folder_path': {'key': 'rootFolderPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        container: str,
        root_folder_path: Optional[str] = None,
        **kwargs
    ):
        super(ExportDeliveryDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.container = container
        self.root_folder_path = root_folder_path


class ExportDeliveryInfo(msrest.serialization.Model):
    """The delivery information associated with a export.

    All required parameters must be populated in order to send to Azure.

    :param destination: Required. Has destination for the export being delivered.
    :type destination: ~azure.mgmt.costmanagement.models.ExportDeliveryDestination
    """

    _validation = {
        'destination': {'required': True},
    }

    _attribute_map = {
        'destination': {'key': 'destination', 'type': 'ExportDeliveryDestination'},
    }

    def __init__(
        self,
        *,
        destination: "ExportDeliveryDestination",
        **kwargs
    ):
        super(ExportDeliveryInfo, self).__init__(**kwargs)
        self.destination = destination


class ExportExecution(Resource):
    """A export execution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param execution_type: The type of the export execution. Possible values include: "OnDemand",
     "Scheduled".
    :type execution_type: str or ~azure.mgmt.costmanagement.models.ExecutionType
    :param status: The status of the export execution. Possible values include: "Queued",
     "InProgress", "Completed", "Failed", "Timeout", "NewDataNotAvailable", "DataNotAvailable".
    :type status: str or ~azure.mgmt.costmanagement.models.ExecutionStatus
    :param submitted_by: The identifier for the entity that executed the export. For OnDemand
     executions, it is the email id. For Scheduled executions, it is the constant value - System.
    :type submitted_by: str
    :param submitted_time: The time when export was queued to be executed.
    :type submitted_time: ~datetime.datetime
    :param processing_start_time: The time when export was picked up to be executed.
    :type processing_start_time: ~datetime.datetime
    :param processing_end_time: The time when export execution finished.
    :type processing_end_time: ~datetime.datetime
    :param file_name: The name of the file export got written to.
    :type file_name: str
    :param run_settings: The common properties of the export.
    :type run_settings: ~azure.mgmt.costmanagement.models.CommonExportProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'execution_type': {'key': 'properties.executionType', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'submitted_by': {'key': 'properties.submittedBy', 'type': 'str'},
        'submitted_time': {'key': 'properties.submittedTime', 'type': 'iso-8601'},
        'processing_start_time': {'key': 'properties.processingStartTime', 'type': 'iso-8601'},
        'processing_end_time': {'key': 'properties.processingEndTime', 'type': 'iso-8601'},
        'file_name': {'key': 'properties.fileName', 'type': 'str'},
        'run_settings': {'key': 'properties.runSettings', 'type': 'CommonExportProperties'},
    }

    def __init__(
        self,
        *,
        execution_type: Optional[Union[str, "ExecutionType"]] = None,
        status: Optional[Union[str, "ExecutionStatus"]] = None,
        submitted_by: Optional[str] = None,
        submitted_time: Optional[datetime.datetime] = None,
        processing_start_time: Optional[datetime.datetime] = None,
        processing_end_time: Optional[datetime.datetime] = None,
        file_name: Optional[str] = None,
        run_settings: Optional["CommonExportProperties"] = None,
        **kwargs
    ):
        super(ExportExecution, self).__init__(**kwargs)
        self.execution_type = execution_type
        self.status = status
        self.submitted_by = submitted_by
        self.submitted_time = submitted_time
        self.processing_start_time = processing_start_time
        self.processing_end_time = processing_end_time
        self.file_name = file_name
        self.run_settings = run_settings


class ExportExecutionListResult(msrest.serialization.Model):
    """Result of listing exports execution history of a export by name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of export executions.
    :vartype value: list[~azure.mgmt.costmanagement.models.ExportExecution]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExportExecution]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportExecutionListResult, self).__init__(**kwargs)
        self.value = None


class ExportListResult(msrest.serialization.Model):
    """Result of listing exports. It contains a list of available exports in the scope provided.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of exports.
    :vartype value: list[~azure.mgmt.costmanagement.models.Export]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Export]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportListResult, self).__init__(**kwargs)
        self.value = None


class ExportProperties(CommonExportProperties):
    """The properties of the export.

    All required parameters must be populated in order to send to Azure.

    :param format: The format of the export being delivered. Possible values include: "Csv".
    :type format: str or ~azure.mgmt.costmanagement.models.FormatType
    :param delivery_info: Required. Has delivery information for the export.
    :type delivery_info: ~azure.mgmt.costmanagement.models.ExportDeliveryInfo
    :param definition: Required. Has definition for the export.
    :type definition: ~azure.mgmt.costmanagement.models.ExportDefinition
    :param schedule: Has schedule information for the export.
    :type schedule: ~azure.mgmt.costmanagement.models.ExportSchedule
    """

    _validation = {
        'delivery_info': {'required': True},
        'definition': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'delivery_info': {'key': 'deliveryInfo', 'type': 'ExportDeliveryInfo'},
        'definition': {'key': 'definition', 'type': 'ExportDefinition'},
        'schedule': {'key': 'schedule', 'type': 'ExportSchedule'},
    }

    def __init__(
        self,
        *,
        delivery_info: "ExportDeliveryInfo",
        definition: "ExportDefinition",
        format: Optional[Union[str, "FormatType"]] = None,
        schedule: Optional["ExportSchedule"] = None,
        **kwargs
    ):
        super(ExportProperties, self).__init__(format=format, delivery_info=delivery_info, definition=definition, **kwargs)
        self.schedule = schedule


class ExportRecurrencePeriod(msrest.serialization.Model):
    """The start and end date for recurrence schedule.

    All required parameters must be populated in order to send to Azure.

    :param from_property: Required. The start date of recurrence.
    :type from_property: ~datetime.datetime
    :param to: The end date of recurrence.
    :type to: ~datetime.datetime
    """

    _validation = {
        'from_property': {'required': True},
    }

    _attribute_map = {
        'from_property': {'key': 'from', 'type': 'iso-8601'},
        'to': {'key': 'to', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        from_property: datetime.datetime,
        to: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(ExportRecurrencePeriod, self).__init__(**kwargs)
        self.from_property = from_property
        self.to = to


class ExportSchedule(msrest.serialization.Model):
    """The schedule associated with a export.

    All required parameters must be populated in order to send to Azure.

    :param status: The status of the schedule. Whether active or not. If inactive, the export's
     scheduled execution is paused. Possible values include: "Active", "Inactive".
    :type status: str or ~azure.mgmt.costmanagement.models.StatusType
    :param recurrence: Required. The schedule recurrence. Possible values include: "Daily",
     "Weekly", "Monthly", "Annually".
    :type recurrence: str or ~azure.mgmt.costmanagement.models.RecurrenceType
    :param recurrence_period: Has start and end date of the recurrence. The start date must be in
     future. If present, the end date must be greater than start date.
    :type recurrence_period: ~azure.mgmt.costmanagement.models.ExportRecurrencePeriod
    """

    _validation = {
        'recurrence': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'recurrence': {'key': 'recurrence', 'type': 'str'},
        'recurrence_period': {'key': 'recurrencePeriod', 'type': 'ExportRecurrencePeriod'},
    }

    def __init__(
        self,
        *,
        recurrence: Union[str, "RecurrenceType"],
        status: Optional[Union[str, "StatusType"]] = None,
        recurrence_period: Optional["ExportRecurrencePeriod"] = None,
        **kwargs
    ):
        super(ExportSchedule, self).__init__(**kwargs)
        self.status = status
        self.recurrence = recurrence
        self.recurrence_period = recurrence_period


class ForecastDefinition(msrest.serialization.Model):
    """The definition of a forecast.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the forecast. Possible values include: "Usage",
     "ActualCost", "AmortizedCost".
    :type type: str or ~azure.mgmt.costmanagement.models.ForecastType
    :param timeframe: Required. The time frame for pulling data for the forecast. If custom, then a
     specific time period must be provided. Possible values include: "MonthToDate",
     "BillingMonthToDate", "TheLastMonth", "TheLastBillingMonth", "WeekToDate", "Custom".
    :type timeframe: str or ~azure.mgmt.costmanagement.models.ForecastTimeframeType
    :param time_period: Has time period for pulling data for the forecast.
    :type time_period: ~azure.mgmt.costmanagement.models.QueryTimePeriod
    :param dataset: Has definition for data in this forecast.
    :type dataset: ~azure.mgmt.costmanagement.models.QueryDataset
    :param include_actual_cost: a boolean determining if actualCost will be included.
    :type include_actual_cost: bool
    :param include_fresh_partial_cost: a boolean determining if FreshPartialCost will be included.
    :type include_fresh_partial_cost: bool
    """

    _validation = {
        'type': {'required': True},
        'timeframe': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'timeframe': {'key': 'timeframe', 'type': 'str'},
        'time_period': {'key': 'timePeriod', 'type': 'QueryTimePeriod'},
        'dataset': {'key': 'dataset', 'type': 'QueryDataset'},
        'include_actual_cost': {'key': 'includeActualCost', 'type': 'bool'},
        'include_fresh_partial_cost': {'key': 'includeFreshPartialCost', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ForecastType"],
        timeframe: Union[str, "ForecastTimeframeType"],
        time_period: Optional["QueryTimePeriod"] = None,
        dataset: Optional["QueryDataset"] = None,
        include_actual_cost: Optional[bool] = None,
        include_fresh_partial_cost: Optional[bool] = None,
        **kwargs
    ):
        super(ForecastDefinition, self).__init__(**kwargs)
        self.type = type
        self.timeframe = timeframe
        self.time_period = time_period
        self.dataset = dataset
        self.include_actual_cost = include_actual_cost
        self.include_fresh_partial_cost = include_fresh_partial_cost


class KpiProperties(msrest.serialization.Model):
    """Each KPI must contain a 'type' and 'enabled' key.

    :param type: KPI type (Forecast, Budget). Possible values include: "Forecast", "Budget".
    :type type: str or ~azure.mgmt.costmanagement.models.KpiType
    :param id: ID of resource related to metric (budget).
    :type id: str
    :param enabled: show the KPI in the UI?.
    :type enabled: bool
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "KpiType"]] = None,
        id: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        super(KpiProperties, self).__init__(**kwargs)
        self.type = type
        self.id = id
        self.enabled = enabled


class Operation(msrest.serialization.Model):
    """A Cost management REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.costmanagement.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.CostManagement.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Dimensions, Query.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationListResult(msrest.serialization.Model):
    """Result of listing cost management operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of cost management operations supported by the Microsoft.CostManagement
     resource provider.
    :vartype value: list[~azure.mgmt.costmanagement.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatus(msrest.serialization.Model):
    """The status of the long running operation.

    :param status: The status of the long running operation.
    :type status: ~azure.mgmt.costmanagement.models.Status
    :param report_url: The URL to download the generated report.
    :type report_url: str
    :param valid_until: The time at which report URL becomes invalid.
    :type valid_until: ~datetime.datetime
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'Status'},
        'report_url': {'key': 'properties.reportUrl', 'type': 'str'},
        'valid_until': {'key': 'properties.validUntil', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        status: Optional["Status"] = None,
        report_url: Optional[str] = None,
        valid_until: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(OperationStatus, self).__init__(**kwargs)
        self.status = status
        self.report_url = report_url
        self.valid_until = valid_until


class PivotProperties(msrest.serialization.Model):
    """Each pivot must contain a 'type' and 'name'.

    :param type: Data type to show in view. Possible values include: "Dimension", "TagKey".
    :type type: str or ~azure.mgmt.costmanagement.models.PivotType
    :param name: Data field to show in view.
    :type name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "PivotType"]] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(PivotProperties, self).__init__(**kwargs)
        self.type = type
        self.name = name


class ProxySettingResource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'kind': {'readonly': True, 'max_length': 10, 'min_length': 0},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxySettingResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = None
        self.type = None


class QueryAggregation(msrest.serialization.Model):
    """The aggregation expression to be used in the query.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the column to aggregate.
    :type name: str
    :param function: Required. The name of the aggregation function to use. Possible values
     include: "Sum".
    :type function: str or ~azure.mgmt.costmanagement.models.FunctionType
    """

    _validation = {
        'name': {'required': True},
        'function': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'function': {'key': 'function', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        function: Union[str, "FunctionType"],
        **kwargs
    ):
        super(QueryAggregation, self).__init__(**kwargs)
        self.name = name
        self.function = function


class QueryColumn(msrest.serialization.Model):
    """QueryColumn.

    :param name: The name of column.
    :type name: str
    :param type: The type of column.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(QueryColumn, self).__init__(**kwargs)
        self.name = name
        self.type = type


class QueryComparisonExpression(msrest.serialization.Model):
    """The comparison expression to be used in the query.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the column to use in comparison.
    :type name: str
    :param operator: Required. The operator to use for comparison. Possible values include: "In",
     "Contains".
    :type operator: str or ~azure.mgmt.costmanagement.models.OperatorType
    :param values: Required. Array of values to use for comparison.
    :type values: list[str]
    """

    _validation = {
        'name': {'required': True},
        'operator': {'required': True},
        'values': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        operator: Union[str, "OperatorType"],
        values: List[str],
        **kwargs
    ):
        super(QueryComparisonExpression, self).__init__(**kwargs)
        self.name = name
        self.operator = operator
        self.values = values


class QueryDataset(msrest.serialization.Model):
    """The definition of data present in the query.

    :param granularity: The granularity of rows in the query. Possible values include: "Daily".
    :type granularity: str or ~azure.mgmt.costmanagement.models.GranularityType
    :param configuration: Has configuration information for the data in the export. The
     configuration will be ignored if aggregation and grouping are provided.
    :type configuration: ~azure.mgmt.costmanagement.models.QueryDatasetConfiguration
    :param aggregation: Dictionary of aggregation expression to use in the query. The key of each
     item in the dictionary is the alias for the aggregated column. Query can have up to 2
     aggregation clauses.
    :type aggregation: dict[str, ~azure.mgmt.costmanagement.models.QueryAggregation]
    :param grouping: Array of group by expression to use in the query. Query can have up to 2 group
     by clauses.
    :type grouping: list[~azure.mgmt.costmanagement.models.QueryGrouping]
    :param filter: Has filter expression to use in the query.
    :type filter: ~azure.mgmt.costmanagement.models.QueryFilter
    """

    _validation = {
        'grouping': {'max_items': 2, 'min_items': 0},
    }

    _attribute_map = {
        'granularity': {'key': 'granularity', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': 'QueryDatasetConfiguration'},
        'aggregation': {'key': 'aggregation', 'type': '{QueryAggregation}'},
        'grouping': {'key': 'grouping', 'type': '[QueryGrouping]'},
        'filter': {'key': 'filter', 'type': 'QueryFilter'},
    }

    def __init__(
        self,
        *,
        granularity: Optional[Union[str, "GranularityType"]] = None,
        configuration: Optional["QueryDatasetConfiguration"] = None,
        aggregation: Optional[Dict[str, "QueryAggregation"]] = None,
        grouping: Optional[List["QueryGrouping"]] = None,
        filter: Optional["QueryFilter"] = None,
        **kwargs
    ):
        super(QueryDataset, self).__init__(**kwargs)
        self.granularity = granularity
        self.configuration = configuration
        self.aggregation = aggregation
        self.grouping = grouping
        self.filter = filter


class QueryDatasetAutoGenerated(msrest.serialization.Model):
    """The definition of data present in the query.

    :param granularity: The granularity of rows in the query. Possible values include: "Daily".
    :type granularity: str or ~azure.mgmt.costmanagement.models.GranularityType
    :param configuration: Has configuration information for the data in the export. The
     configuration will be ignored if aggregation and grouping are provided.
    :type configuration: ~azure.mgmt.costmanagement.models.QueryDatasetConfiguration
    :param aggregation: Dictionary of aggregation expression to use in the query. The key of each
     item in the dictionary is the alias for the aggregated column. Query can have up to 2
     aggregation clauses.
    :type aggregation: dict[str, ~azure.mgmt.costmanagement.models.QueryAggregation]
    :param grouping: Array of group by expression to use in the query. Query can have up to 2 group
     by clauses.
    :type grouping: list[~azure.mgmt.costmanagement.models.QueryGrouping]
    :param filter: Has filter expression to use in the query.
    :type filter: ~azure.mgmt.costmanagement.models.QueryFilterAutoGenerated
    """

    _validation = {
        'grouping': {'max_items': 2, 'min_items': 0},
    }

    _attribute_map = {
        'granularity': {'key': 'granularity', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': 'QueryDatasetConfiguration'},
        'aggregation': {'key': 'aggregation', 'type': '{QueryAggregation}'},
        'grouping': {'key': 'grouping', 'type': '[QueryGrouping]'},
        'filter': {'key': 'filter', 'type': 'QueryFilterAutoGenerated'},
    }

    def __init__(
        self,
        *,
        granularity: Optional[Union[str, "GranularityType"]] = None,
        configuration: Optional["QueryDatasetConfiguration"] = None,
        aggregation: Optional[Dict[str, "QueryAggregation"]] = None,
        grouping: Optional[List["QueryGrouping"]] = None,
        filter: Optional["QueryFilterAutoGenerated"] = None,
        **kwargs
    ):
        super(QueryDatasetAutoGenerated, self).__init__(**kwargs)
        self.granularity = granularity
        self.configuration = configuration
        self.aggregation = aggregation
        self.grouping = grouping
        self.filter = filter


class QueryDatasetConfiguration(msrest.serialization.Model):
    """The configuration of dataset in the query.

    :param columns: Array of column names to be included in the query. Any valid query column name
     is allowed. If not provided, then query includes all columns.
    :type columns: list[str]
    """

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        columns: Optional[List[str]] = None,
        **kwargs
    ):
        super(QueryDatasetConfiguration, self).__init__(**kwargs)
        self.columns = columns


class QueryDefinition(msrest.serialization.Model):
    """The definition of a query.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the query. Possible values include: "Usage", "ActualCost",
     "AmortizedCost".
    :type type: str or ~azure.mgmt.costmanagement.models.ExportType
    :param timeframe: Required. The time frame for pulling data for the query. If custom, then a
     specific time period must be provided. Possible values include: "MonthToDate",
     "BillingMonthToDate", "TheLastMonth", "TheLastBillingMonth", "WeekToDate", "Custom".
    :type timeframe: str or ~azure.mgmt.costmanagement.models.TimeframeType
    :param time_period: Has time period for pulling data for the query.
    :type time_period: ~azure.mgmt.costmanagement.models.QueryTimePeriod
    :param dataset: Has definition for data in this query.
    :type dataset: ~azure.mgmt.costmanagement.models.QueryDataset
    """

    _validation = {
        'type': {'required': True},
        'timeframe': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'timeframe': {'key': 'timeframe', 'type': 'str'},
        'time_period': {'key': 'timePeriod', 'type': 'QueryTimePeriod'},
        'dataset': {'key': 'dataset', 'type': 'QueryDataset'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ExportType"],
        timeframe: Union[str, "TimeframeType"],
        time_period: Optional["QueryTimePeriod"] = None,
        dataset: Optional["QueryDataset"] = None,
        **kwargs
    ):
        super(QueryDefinition, self).__init__(**kwargs)
        self.type = type
        self.timeframe = timeframe
        self.time_period = time_period
        self.dataset = dataset


class QueryFilter(msrest.serialization.Model):
    """The filter expression to be used in the export.

    :param and_property: The logical "AND" expression. Must have at least 2 items.
    :type and_property: list[~azure.mgmt.costmanagement.models.QueryFilter]
    :param or_property: The logical "OR" expression. Must have at least 2 items.
    :type or_property: list[~azure.mgmt.costmanagement.models.QueryFilter]
    :param dimensions: Has comparison expression for a dimension.
    :type dimensions: ~azure.mgmt.costmanagement.models.QueryComparisonExpression
    :param tags: A set of tags. Has comparison expression for a tag.
    :type tags: ~azure.mgmt.costmanagement.models.QueryComparisonExpression
    """

    _validation = {
        'and_property': {'min_items': 2},
        'or_property': {'min_items': 2},
    }

    _attribute_map = {
        'and_property': {'key': 'and', 'type': '[QueryFilter]'},
        'or_property': {'key': 'or', 'type': '[QueryFilter]'},
        'dimensions': {'key': 'dimensions', 'type': 'QueryComparisonExpression'},
        'tags': {'key': 'tags', 'type': 'QueryComparisonExpression'},
    }

    def __init__(
        self,
        *,
        and_property: Optional[List["QueryFilter"]] = None,
        or_property: Optional[List["QueryFilter"]] = None,
        dimensions: Optional["QueryComparisonExpression"] = None,
        tags: Optional["QueryComparisonExpression"] = None,
        **kwargs
    ):
        super(QueryFilter, self).__init__(**kwargs)
        self.and_property = and_property
        self.or_property = or_property
        self.dimensions = dimensions
        self.tags = tags


class QueryFilterAutoGenerated(msrest.serialization.Model):
    """The filter expression to be used in the export.

    :param and_property: The logical "AND" expression. Must have at least 2 items.
    :type and_property: list[~azure.mgmt.costmanagement.models.QueryFilterAutoGenerated]
    :param or_property: The logical "OR" expression. Must have at least 2 items.
    :type or_property: list[~azure.mgmt.costmanagement.models.QueryFilterAutoGenerated]
    :param dimensions: Has comparison expression for a dimension.
    :type dimensions: ~azure.mgmt.costmanagement.models.QueryComparisonExpression
    :param tags: A set of tags. Has comparison expression for a tag.
    :type tags: ~azure.mgmt.costmanagement.models.QueryComparisonExpression
    """

    _validation = {
        'and_property': {'min_items': 2},
        'or_property': {'min_items': 2},
    }

    _attribute_map = {
        'and_property': {'key': 'and', 'type': '[QueryFilterAutoGenerated]'},
        'or_property': {'key': 'or', 'type': '[QueryFilterAutoGenerated]'},
        'dimensions': {'key': 'dimensions', 'type': 'QueryComparisonExpression'},
        'tags': {'key': 'tags', 'type': 'QueryComparisonExpression'},
    }

    def __init__(
        self,
        *,
        and_property: Optional[List["QueryFilterAutoGenerated"]] = None,
        or_property: Optional[List["QueryFilterAutoGenerated"]] = None,
        dimensions: Optional["QueryComparisonExpression"] = None,
        tags: Optional["QueryComparisonExpression"] = None,
        **kwargs
    ):
        super(QueryFilterAutoGenerated, self).__init__(**kwargs)
        self.and_property = and_property
        self.or_property = or_property
        self.dimensions = dimensions
        self.tags = tags


class QueryGrouping(msrest.serialization.Model):
    """The group by expression to be used in the query.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Has type of the column to group. Possible values include: "Tag",
     "Dimension".
    :type type: str or ~azure.mgmt.costmanagement.models.QueryColumnType
    :param name: Required. The name of the column to group.
    :type name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "QueryColumnType"],
        name: str,
        **kwargs
    ):
        super(QueryGrouping, self).__init__(**kwargs)
        self.type = type
        self.name = name


class QueryResult(Resource):
    """Result of query. It contains all columns listed under groupings and aggregation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :type e_tag: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar sku: Resource SKU.
    :vartype sku: str
    :param next_link: The link (url) to the next page of results.
    :type next_link: str
    :param columns: Array of columns.
    :type columns: list[~azure.mgmt.costmanagement.models.QueryColumn]
    :param rows: Array of rows.
    :type rows: list[list[any]]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'location': {'readonly': True},
        'sku': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'next_link': {'key': 'properties.nextLink', 'type': 'str'},
        'columns': {'key': 'properties.columns', 'type': '[QueryColumn]'},
        'rows': {'key': 'properties.rows', 'type': '[[object]]'},
    }

    def __init__(
        self,
        *,
        e_tag: Optional[str] = None,
        next_link: Optional[str] = None,
        columns: Optional[List["QueryColumn"]] = None,
        rows: Optional[List[List[Any]]] = None,
        **kwargs
    ):
        super(QueryResult, self).__init__(**kwargs)
        self.e_tag = e_tag
        self.location = None
        self.sku = None
        self.next_link = next_link
        self.columns = columns
        self.rows = rows


class QueryTimePeriod(msrest.serialization.Model):
    """The start and end date for pulling data for the query.

    All required parameters must be populated in order to send to Azure.

    :param from_property: Required. The start date to pull data from.
    :type from_property: ~datetime.datetime
    :param to: Required. The end date to pull data to.
    :type to: ~datetime.datetime
    """

    _validation = {
        'from_property': {'required': True},
        'to': {'required': True},
    }

    _attribute_map = {
        'from_property': {'key': 'from', 'type': 'iso-8601'},
        'to': {'key': 'to', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        from_property: datetime.datetime,
        to: datetime.datetime,
        **kwargs
    ):
        super(QueryTimePeriod, self).__init__(**kwargs)
        self.from_property = from_property
        self.to = to


class ReportConfigAggregation(msrest.serialization.Model):
    """The aggregation expression to be used in the report.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the column to aggregate.
    :type name: str
    :param function: Required. The name of the aggregation function to use. Possible values
     include: "Sum".
    :type function: str or ~azure.mgmt.costmanagement.models.FunctionType
    """

    _validation = {
        'name': {'required': True},
        'function': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'function': {'key': 'function', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        function: Union[str, "FunctionType"],
        **kwargs
    ):
        super(ReportConfigAggregation, self).__init__(**kwargs)
        self.name = name
        self.function = function


class ReportConfigComparisonExpression(msrest.serialization.Model):
    """The comparison expression to be used in the report.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the column to use in comparison.
    :type name: str
    :param operator: Required. The operator to use for comparison. Possible values include: "In",
     "Contains".
    :type operator: str or ~azure.mgmt.costmanagement.models.OperatorType
    :param values: Required. Array of values to use for comparison.
    :type values: list[str]
    """

    _validation = {
        'name': {'required': True},
        'operator': {'required': True},
        'values': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        operator: Union[str, "OperatorType"],
        values: List[str],
        **kwargs
    ):
        super(ReportConfigComparisonExpression, self).__init__(**kwargs)
        self.name = name
        self.operator = operator
        self.values = values


class ReportConfigDataset(msrest.serialization.Model):
    """The definition of data present in the report.

    :param granularity: The granularity of rows in the report. Possible values include: "Daily",
     "Monthly".
    :type granularity: str or ~azure.mgmt.costmanagement.models.ReportGranularityType
    :param configuration: Has configuration information for the data in the report. The
     configuration will be ignored if aggregation and grouping are provided.
    :type configuration: ~azure.mgmt.costmanagement.models.ReportConfigDatasetConfiguration
    :param aggregation: Dictionary of aggregation expression to use in the report. The key of each
     item in the dictionary is the alias for the aggregated column. Report can have up to 2
     aggregation clauses.
    :type aggregation: dict[str, ~azure.mgmt.costmanagement.models.ReportConfigAggregation]
    :param grouping: Array of group by expression to use in the report. Report can have up to 2
     group by clauses.
    :type grouping: list[~azure.mgmt.costmanagement.models.ReportConfigGrouping]
    :param sorting: Array of order by expression to use in the report.
    :type sorting: list[~azure.mgmt.costmanagement.models.ReportConfigSorting]
    :param filter: Has filter expression to use in the report.
    :type filter: ~azure.mgmt.costmanagement.models.ReportConfigFilter
    """

    _validation = {
        'grouping': {'max_items': 2, 'min_items': 0},
    }

    _attribute_map = {
        'granularity': {'key': 'granularity', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': 'ReportConfigDatasetConfiguration'},
        'aggregation': {'key': 'aggregation', 'type': '{ReportConfigAggregation}'},
        'grouping': {'key': 'grouping', 'type': '[ReportConfigGrouping]'},
        'sorting': {'key': 'sorting', 'type': '[ReportConfigSorting]'},
        'filter': {'key': 'filter', 'type': 'ReportConfigFilter'},
    }

    def __init__(
        self,
        *,
        granularity: Optional[Union[str, "ReportGranularityType"]] = None,
        configuration: Optional["ReportConfigDatasetConfiguration"] = None,
        aggregation: Optional[Dict[str, "ReportConfigAggregation"]] = None,
        grouping: Optional[List["ReportConfigGrouping"]] = None,
        sorting: Optional[List["ReportConfigSorting"]] = None,
        filter: Optional["ReportConfigFilter"] = None,
        **kwargs
    ):
        super(ReportConfigDataset, self).__init__(**kwargs)
        self.granularity = granularity
        self.configuration = configuration
        self.aggregation = aggregation
        self.grouping = grouping
        self.sorting = sorting
        self.filter = filter


class ReportConfigDatasetConfiguration(msrest.serialization.Model):
    """The configuration of dataset in the report.

    :param columns: Array of column names to be included in the report. Any valid report column
     name is allowed. If not provided, then report includes all columns.
    :type columns: list[str]
    """

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        columns: Optional[List[str]] = None,
        **kwargs
    ):
        super(ReportConfigDatasetConfiguration, self).__init__(**kwargs)
        self.columns = columns


class ReportConfigFilter(msrest.serialization.Model):
    """The filter expression to be used in the report.

    :param and_property: The logical "AND" expression. Must have at least 2 items.
    :type and_property: list[~azure.mgmt.costmanagement.models.ReportConfigFilter]
    :param or_property: The logical "OR" expression. Must have at least 2 items.
    :type or_property: list[~azure.mgmt.costmanagement.models.ReportConfigFilter]
    :param dimensions: Has comparison expression for a dimension.
    :type dimensions: ~azure.mgmt.costmanagement.models.ReportConfigComparisonExpression
    :param tags: A set of tags. Has comparison expression for a tag.
    :type tags: ~azure.mgmt.costmanagement.models.ReportConfigComparisonExpression
    :param tag_key: Has comparison expression for a tag key.
    :type tag_key: ~azure.mgmt.costmanagement.models.ReportConfigComparisonExpression
    :param tag_value: Has comparison expression for a tag value.
    :type tag_value: ~azure.mgmt.costmanagement.models.ReportConfigComparisonExpression
    """

    _validation = {
        'and_property': {'min_items': 2},
        'or_property': {'min_items': 2},
    }

    _attribute_map = {
        'and_property': {'key': 'and', 'type': '[ReportConfigFilter]'},
        'or_property': {'key': 'or', 'type': '[ReportConfigFilter]'},
        'dimensions': {'key': 'dimensions', 'type': 'ReportConfigComparisonExpression'},
        'tags': {'key': 'tags', 'type': 'ReportConfigComparisonExpression'},
        'tag_key': {'key': 'tagKey', 'type': 'ReportConfigComparisonExpression'},
        'tag_value': {'key': 'tagValue', 'type': 'ReportConfigComparisonExpression'},
    }

    def __init__(
        self,
        *,
        and_property: Optional[List["ReportConfigFilter"]] = None,
        or_property: Optional[List["ReportConfigFilter"]] = None,
        dimensions: Optional["ReportConfigComparisonExpression"] = None,
        tags: Optional["ReportConfigComparisonExpression"] = None,
        tag_key: Optional["ReportConfigComparisonExpression"] = None,
        tag_value: Optional["ReportConfigComparisonExpression"] = None,
        **kwargs
    ):
        super(ReportConfigFilter, self).__init__(**kwargs)
        self.and_property = and_property
        self.or_property = or_property
        self.dimensions = dimensions
        self.tags = tags
        self.tag_key = tag_key
        self.tag_value = tag_value


class ReportConfigGrouping(msrest.serialization.Model):
    """The group by expression to be used in the report.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Has type of the column to group. Possible values include: "Tag",
     "Dimension".
    :type type: str or ~azure.mgmt.costmanagement.models.ReportConfigColumnType
    :param name: Required. The name of the column to group. This version supports subscription
     lowest possible grain.
    :type name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "ReportConfigColumnType"],
        name: str,
        **kwargs
    ):
        super(ReportConfigGrouping, self).__init__(**kwargs)
        self.type = type
        self.name = name


class ReportConfigSorting(msrest.serialization.Model):
    """The order by expression to be used in the report.

    All required parameters must be populated in order to send to Azure.

    :param direction: Direction of sort. Possible values include: "Ascending", "Descending".
    :type direction: str or ~azure.mgmt.costmanagement.models.ReportConfigSortingDirection
    :param name: Required. The name of the column to sort.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'direction': {'key': 'direction', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        direction: Optional[Union[str, "ReportConfigSortingDirection"]] = None,
        **kwargs
    ):
        super(ReportConfigSorting, self).__init__(**kwargs)
        self.direction = direction
        self.name = name


class ReportConfigTimePeriod(msrest.serialization.Model):
    """The start and end date for pulling data for the report.

    All required parameters must be populated in order to send to Azure.

    :param from_property: Required. The start date to pull data from.
    :type from_property: ~datetime.datetime
    :param to: Required. The end date to pull data to.
    :type to: ~datetime.datetime
    """

    _validation = {
        'from_property': {'required': True},
        'to': {'required': True},
    }

    _attribute_map = {
        'from_property': {'key': 'from', 'type': 'iso-8601'},
        'to': {'key': 'to', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        from_property: datetime.datetime,
        to: datetime.datetime,
        **kwargs
    ):
        super(ReportConfigTimePeriod, self).__init__(**kwargs)
        self.from_property = from_property
        self.to = to


class Setting(ProxySettingResource):
    """State of the myscope setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param scope: Sets the default scope the current user will see when they sign into Azure Cost
     Management in the Azure portal.
    :type scope: str
    :param start_on: Indicates what scope Cost Management in the Azure portal should default to.
     Allowed values: LastUsed. Possible values include: "LastUsed", "ScopePicker", "SpecificScope".
    :type start_on: str or ~azure.mgmt.costmanagement.models.SettingsPropertiesStartOn
    :param cache: Array of scopes with additional details used by Cost Management in the Azure
     portal.
    :type cache: list[~azure.mgmt.costmanagement.models.CacheItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'kind': {'readonly': True, 'max_length': 10, 'min_length': 0},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'start_on': {'key': 'properties.startOn', 'type': 'str'},
        'cache': {'key': 'properties.cache', 'type': '[CacheItem]'},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        start_on: Optional[Union[str, "SettingsPropertiesStartOn"]] = None,
        cache: Optional[List["CacheItem"]] = None,
        **kwargs
    ):
        super(Setting, self).__init__(**kwargs)
        self.scope = scope
        self.start_on = start_on
        self.cache = cache


class SettingsListResult(msrest.serialization.Model):
    """Result of listing settings. It contains a list of available settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of settings.
    :vartype value: list[~azure.mgmt.costmanagement.models.Setting]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True, 'max_items': 10, 'min_items': 0},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Setting]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SettingsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Status(msrest.serialization.Model):
    """The status of the long running operation.

    :param status: The status of the long running operation. Possible values include: "Running",
     "Completed", "Failed".
    :type status: str or ~azure.mgmt.costmanagement.models.OperationStatusType
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "OperationStatusType"]] = None,
        **kwargs
    ):
        super(Status, self).__init__(**kwargs)
        self.status = status


class View(ProxyResource):
    """States and configurations of Cost Analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :type e_tag: str
    :param display_name: User input name of the view. Required.
    :type display_name: str
    :param scope: Cost Management scope to save the view on. This includes
     'subscriptions/{subscriptionId}' for subscription scope,
     'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
     Department scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
     for EnrollmentAccount scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
     for BillingProfile scope,
     'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}'
     for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}'
     for Management Group scope,
     '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
     ExternalBillingAccount scope, and
     '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for
     ExternalSubscription scope.
    :type scope: str
    :ivar created_on: Date the user created this view.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: Date when the user last modified this view.
    :vartype modified_on: ~datetime.datetime
    :ivar date_range: Selected date range for viewing cost in.
    :vartype date_range: str
    :ivar currency: Selected currency.
    :vartype currency: str
    :param chart: Chart type of the main view in Cost Analysis. Required. Possible values include:
     "Area", "Line", "StackedColumn", "GroupedColumn", "Table".
    :type chart: str or ~azure.mgmt.costmanagement.models.ChartType
    :param accumulated: Show costs accumulated over time. Possible values include: "true", "false".
    :type accumulated: str or ~azure.mgmt.costmanagement.models.AccumulatedType
    :param metric: Metric to use when displaying costs. Possible values include: "ActualCost",
     "AmortizedCost", "AHUB".
    :type metric: str or ~azure.mgmt.costmanagement.models.MetricType
    :param kpis: List of KPIs to show in Cost Analysis UI.
    :type kpis: list[~azure.mgmt.costmanagement.models.KpiProperties]
    :param pivots: Configuration of 3 sub-views in the Cost Analysis UI.
    :type pivots: list[~azure.mgmt.costmanagement.models.PivotProperties]
    :param type_properties_query_type: The type of the report. Usage represents actual usage,
     forecast represents forecasted data and UsageAndForecast represents both usage and forecasted
     data. Actual usage and forecasted data can be differentiated based on dates. Possible values
     include: "Usage".
    :type type_properties_query_type: str or ~azure.mgmt.costmanagement.models.ReportType
    :param timeframe: The time frame for pulling data for the report. If custom, then a specific
     time period must be provided. Possible values include: "WeekToDate", "MonthToDate",
     "YearToDate", "Custom".
    :type timeframe: str or ~azure.mgmt.costmanagement.models.ReportTimeframeType
    :param time_period: Has time period for pulling data for the report.
    :type time_period: ~azure.mgmt.costmanagement.models.ReportConfigTimePeriod
    :param data_set: Has definition for data in this report config.
    :type data_set: ~azure.mgmt.costmanagement.models.ReportConfigDataset
    :ivar include_monetary_commitment: Include monetary commitment.
    :vartype include_monetary_commitment: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'date_range': {'readonly': True},
        'currency': {'readonly': True},
        'include_monetary_commitment': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'properties.modifiedOn', 'type': 'iso-8601'},
        'date_range': {'key': 'properties.dateRange', 'type': 'str'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
        'chart': {'key': 'properties.chart', 'type': 'str'},
        'accumulated': {'key': 'properties.accumulated', 'type': 'str'},
        'metric': {'key': 'properties.metric', 'type': 'str'},
        'kpis': {'key': 'properties.kpis', 'type': '[KpiProperties]'},
        'pivots': {'key': 'properties.pivots', 'type': '[PivotProperties]'},
        'type_properties_query_type': {'key': 'properties.query.type', 'type': 'str'},
        'timeframe': {'key': 'properties.query.timeframe', 'type': 'str'},
        'time_period': {'key': 'properties.query.timePeriod', 'type': 'ReportConfigTimePeriod'},
        'data_set': {'key': 'properties.query.dataSet', 'type': 'ReportConfigDataset'},
        'include_monetary_commitment': {'key': 'properties.query.includeMonetaryCommitment', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        e_tag: Optional[str] = None,
        display_name: Optional[str] = None,
        scope: Optional[str] = None,
        chart: Optional[Union[str, "ChartType"]] = None,
        accumulated: Optional[Union[str, "AccumulatedType"]] = None,
        metric: Optional[Union[str, "MetricType"]] = None,
        kpis: Optional[List["KpiProperties"]] = None,
        pivots: Optional[List["PivotProperties"]] = None,
        type_properties_query_type: Optional[Union[str, "ReportType"]] = None,
        timeframe: Optional[Union[str, "ReportTimeframeType"]] = None,
        time_period: Optional["ReportConfigTimePeriod"] = None,
        data_set: Optional["ReportConfigDataset"] = None,
        **kwargs
    ):
        super(View, self).__init__(e_tag=e_tag, **kwargs)
        self.display_name = display_name
        self.scope = scope
        self.created_on = None
        self.modified_on = None
        self.date_range = None
        self.currency = None
        self.chart = chart
        self.accumulated = accumulated
        self.metric = metric
        self.kpis = kpis
        self.pivots = pivots
        self.type_properties_query_type = type_properties_query_type
        self.timeframe = timeframe
        self.time_period = time_period
        self.data_set = data_set
        self.include_monetary_commitment = None


class ViewListResult(msrest.serialization.Model):
    """Result of listing views. It contains a list of available views.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of views.
    :vartype value: list[~azure.mgmt.costmanagement.models.View]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[View]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ViewListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
