# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._dns_resolver_management_client_enums import *


class CloudErrorBody(msrest.serialization.Model):
    """The body of an error message.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: A description of what caused the error.
    :vartype message: str
    :ivar target: The target resource of the error message.
    :vartype target: str
    :ivar details: Extra error information.
    :vartype details: list[~dns_resolver_management_client.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword message: A description of what caused the error.
        :paramtype message: str
        :keyword target: The target resource of the error message.
        :paramtype target: str
        :keyword details: Extra error information.
        :paramtype details: list[~dns_resolver_management_client.models.CloudErrorBody]
        """
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class DnsForwardingRuleset(TrackedResource):
    """Describes a DNS forwarding ruleset.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar etag: ETag of the DNS forwarding ruleset.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~dns_resolver_management_client.models.SystemData
    :ivar dns_resolver_outbound_endpoints: The reference to the DNS resolver outbound endpoints
     that are used to route DNS queries matching the forwarding rules in the ruleset to the target
     DNS servers.
    :vartype dns_resolver_outbound_endpoints:
     list[~dns_resolver_management_client.models.SubResource]
    :ivar provisioning_state: The current provisioning state of the DNS forwarding ruleset. This is
     a read-only property and any attempt to set this value will be ignored. Possible values
     include: "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or ~dns_resolver_management_client.models.ProvisioningState
    :ivar resource_guid: The resourceGuid for the DNS forwarding ruleset.
    :vartype resource_guid: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_guid': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'dns_resolver_outbound_endpoints': {'key': 'properties.dnsResolverOutboundEndpoints', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        dns_resolver_outbound_endpoints: Optional[List["SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword dns_resolver_outbound_endpoints: The reference to the DNS resolver outbound endpoints
         that are used to route DNS queries matching the forwarding rules in the ruleset to the target
         DNS servers.
        :paramtype dns_resolver_outbound_endpoints:
         list[~dns_resolver_management_client.models.SubResource]
        """
        super(DnsForwardingRuleset, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = None
        self.system_data = None
        self.dns_resolver_outbound_endpoints = dns_resolver_outbound_endpoints
        self.provisioning_state = None
        self.resource_guid = None


class DnsForwardingRulesetListResult(msrest.serialization.Model):
    """The response to an enumeration operation on DNS forwarding rulesets.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Enumeration of the DNS forwarding rulesets.
    :vartype value: list[~dns_resolver_management_client.models.DnsForwardingRuleset]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DnsForwardingRuleset]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DnsForwardingRuleset"]] = None,
        **kwargs
    ):
        """
        :keyword value: Enumeration of the DNS forwarding rulesets.
        :paramtype value: list[~dns_resolver_management_client.models.DnsForwardingRuleset]
        """
        super(DnsForwardingRulesetListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DnsForwardingRulesetPatch(msrest.serialization.Model):
    """Describes a DNS forwarding ruleset PATCH operation.

    :ivar tags: A set of tags. Tags for DNS Resolver.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Tags for DNS Resolver.
        :paramtype tags: dict[str, str]
        """
        super(DnsForwardingRulesetPatch, self).__init__(**kwargs)
        self.tags = tags


class DnsResolver(TrackedResource):
    """Describes a DNS resolver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar etag: ETag of the DNS resolver.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~dns_resolver_management_client.models.SystemData
    :ivar virtual_network: The reference to the virtual network. This cannot be changed after
     creation.
    :vartype virtual_network: ~dns_resolver_management_client.models.SubResource
    :ivar dns_resolver_state: The current status of the DNS resolver. This is a read-only property
     and any attempt to set this value will be ignored. Possible values include: "Connected",
     "Disconnected".
    :vartype dns_resolver_state: str or ~dns_resolver_management_client.models.DnsResolverState
    :ivar provisioning_state: The current provisioning state of the DNS resolver. This is a
     read-only property and any attempt to set this value will be ignored. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or ~dns_resolver_management_client.models.ProvisioningState
    :ivar resource_guid: The resourceGuid property of the DNS resolver resource.
    :vartype resource_guid: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'dns_resolver_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_guid': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'SubResource'},
        'dns_resolver_state': {'key': 'properties.dnsResolverState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        virtual_network: Optional["SubResource"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword virtual_network: The reference to the virtual network. This cannot be changed after
         creation.
        :paramtype virtual_network: ~dns_resolver_management_client.models.SubResource
        """
        super(DnsResolver, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = None
        self.system_data = None
        self.virtual_network = virtual_network
        self.dns_resolver_state = None
        self.provisioning_state = None
        self.resource_guid = None


class DnsResolverListResult(msrest.serialization.Model):
    """The response to an enumeration operation on DNS resolvers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Enumeration of the DNS resolvers.
    :vartype value: list[~dns_resolver_management_client.models.DnsResolver]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DnsResolver]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DnsResolver"]] = None,
        **kwargs
    ):
        """
        :keyword value: Enumeration of the DNS resolvers.
        :paramtype value: list[~dns_resolver_management_client.models.DnsResolver]
        """
        super(DnsResolverListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DnsResolverPatch(msrest.serialization.Model):
    """Describes a DNS resolver for PATCH operation.

    :ivar tags: A set of tags. Tags for DNS Resolver.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Tags for DNS Resolver.
        :paramtype tags: dict[str, str]
        """
        super(DnsResolverPatch, self).__init__(**kwargs)
        self.tags = tags


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class ForwardingRule(ProxyResource):
    """Describes a forwarding rule within a DNS forwarding ruleset.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: ETag of the forwarding rule.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~dns_resolver_management_client.models.SystemData
    :ivar domain_name: The domain name for the forwarding rule.
    :vartype domain_name: str
    :ivar target_dns_servers: DNS servers to forward the DNS query to.
    :vartype target_dns_servers: list[~dns_resolver_management_client.models.TargetDnsServer]
    :ivar metadata: Metadata attached to the forwarding rule.
    :vartype metadata: dict[str, str]
    :ivar forwarding_rule_state: The state of forwarding rule. Possible values include: "Enabled",
     "Disabled".
    :vartype forwarding_rule_state: str or
     ~dns_resolver_management_client.models.ForwardingRuleState
    :ivar provisioning_state: The current provisioning state of the forwarding rule. This is a
     read-only property and any attempt to set this value will be ignored. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or ~dns_resolver_management_client.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'domain_name': {'key': 'properties.domainName', 'type': 'str'},
        'target_dns_servers': {'key': 'properties.targetDnsServers', 'type': '[TargetDnsServer]'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'forwarding_rule_state': {'key': 'properties.forwardingRuleState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        target_dns_servers: Optional[List["TargetDnsServer"]] = None,
        metadata: Optional[Dict[str, str]] = None,
        forwarding_rule_state: Optional[Union[str, "ForwardingRuleState"]] = None,
        **kwargs
    ):
        """
        :keyword domain_name: The domain name for the forwarding rule.
        :paramtype domain_name: str
        :keyword target_dns_servers: DNS servers to forward the DNS query to.
        :paramtype target_dns_servers: list[~dns_resolver_management_client.models.TargetDnsServer]
        :keyword metadata: Metadata attached to the forwarding rule.
        :paramtype metadata: dict[str, str]
        :keyword forwarding_rule_state: The state of forwarding rule. Possible values include:
         "Enabled", "Disabled".
        :paramtype forwarding_rule_state: str or
         ~dns_resolver_management_client.models.ForwardingRuleState
        """
        super(ForwardingRule, self).__init__(**kwargs)
        self.etag = None
        self.system_data = None
        self.domain_name = domain_name
        self.target_dns_servers = target_dns_servers
        self.metadata = metadata
        self.forwarding_rule_state = forwarding_rule_state
        self.provisioning_state = None


class ForwardingRuleListResult(msrest.serialization.Model):
    """The response to an enumeration operation on forwarding rules within a DNS forwarding ruleset.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Enumeration of the forwarding rules.
    :vartype value: list[~dns_resolver_management_client.models.ForwardingRule]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ForwardingRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ForwardingRule"]] = None,
        **kwargs
    ):
        """
        :keyword value: Enumeration of the forwarding rules.
        :paramtype value: list[~dns_resolver_management_client.models.ForwardingRule]
        """
        super(ForwardingRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ForwardingRulePatch(msrest.serialization.Model):
    """Describes a forwarding rule for PATCH operation.

    :ivar target_dns_servers: DNS servers to forward the DNS query to.
    :vartype target_dns_servers: list[~dns_resolver_management_client.models.TargetDnsServer]
    :ivar metadata: Metadata attached to the forwarding rule.
    :vartype metadata: dict[str, str]
    :ivar forwarding_rule_state: The state of forwarding rule. Possible values include: "Enabled",
     "Disabled".
    :vartype forwarding_rule_state: str or
     ~dns_resolver_management_client.models.ForwardingRuleState
    """

    _attribute_map = {
        'target_dns_servers': {'key': 'properties.targetDnsServers', 'type': '[TargetDnsServer]'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'forwarding_rule_state': {'key': 'properties.forwardingRuleState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_dns_servers: Optional[List["TargetDnsServer"]] = None,
        metadata: Optional[Dict[str, str]] = None,
        forwarding_rule_state: Optional[Union[str, "ForwardingRuleState"]] = None,
        **kwargs
    ):
        """
        :keyword target_dns_servers: DNS servers to forward the DNS query to.
        :paramtype target_dns_servers: list[~dns_resolver_management_client.models.TargetDnsServer]
        :keyword metadata: Metadata attached to the forwarding rule.
        :paramtype metadata: dict[str, str]
        :keyword forwarding_rule_state: The state of forwarding rule. Possible values include:
         "Enabled", "Disabled".
        :paramtype forwarding_rule_state: str or
         ~dns_resolver_management_client.models.ForwardingRuleState
        """
        super(ForwardingRulePatch, self).__init__(**kwargs)
        self.target_dns_servers = target_dns_servers
        self.metadata = metadata
        self.forwarding_rule_state = forwarding_rule_state


class InboundEndpoint(TrackedResource):
    """Describes an inbound endpoint for a DNS resolver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar etag: ETag of the inbound endpoint.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~dns_resolver_management_client.models.SystemData
    :ivar ip_configurations: IP configurations for the inbound endpoint.
    :vartype ip_configurations: list[~dns_resolver_management_client.models.IpConfiguration]
    :ivar provisioning_state: The current provisioning state of the inbound endpoint. This is a
     read-only property and any attempt to set this value will be ignored. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or ~dns_resolver_management_client.models.ProvisioningState
    :ivar resource_guid: The resourceGuid property of the inbound endpoint resource.
    :vartype resource_guid: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_guid': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[IpConfiguration]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        ip_configurations: Optional[List["IpConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword ip_configurations: IP configurations for the inbound endpoint.
        :paramtype ip_configurations: list[~dns_resolver_management_client.models.IpConfiguration]
        """
        super(InboundEndpoint, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = None
        self.system_data = None
        self.ip_configurations = ip_configurations
        self.provisioning_state = None
        self.resource_guid = None


class InboundEndpointListResult(msrest.serialization.Model):
    """The response to an enumeration operation on inbound endpoints for a DNS resolver.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Enumeration of the inbound endpoints for a DNS resolver.
    :vartype value: list[~dns_resolver_management_client.models.InboundEndpoint]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InboundEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["InboundEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword value: Enumeration of the inbound endpoints for a DNS resolver.
        :paramtype value: list[~dns_resolver_management_client.models.InboundEndpoint]
        """
        super(InboundEndpointListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class InboundEndpointPatch(msrest.serialization.Model):
    """Describes an inbound endpoint for a DNS resolver for PATCH operation.

    :ivar tags: A set of tags. Tags for inbound endpoint.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Tags for inbound endpoint.
        :paramtype tags: dict[str, str]
        """
        super(InboundEndpointPatch, self).__init__(**kwargs)
        self.tags = tags


class IpConfiguration(msrest.serialization.Model):
    """IP configuration.

    :ivar subnet: The reference to the subnet bound to the IP configuration.
    :vartype subnet: ~dns_resolver_management_client.models.SubResource
    :ivar private_ip_address: Private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: Private IP address allocation method. Possible values
     include: "Static", "Dynamic". Default value: "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~dns_resolver_management_client.models.IpAllocationMethod
    """

    _attribute_map = {
        'subnet': {'key': 'subnet', 'type': 'SubResource'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'privateIpAllocationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subnet: Optional["SubResource"] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "IpAllocationMethod"]] = "Dynamic",
        **kwargs
    ):
        """
        :keyword subnet: The reference to the subnet bound to the IP configuration.
        :paramtype subnet: ~dns_resolver_management_client.models.SubResource
        :keyword private_ip_address: Private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: Private IP address allocation method. Possible values
         include: "Static", "Dynamic". Default value: "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~dns_resolver_management_client.models.IpAllocationMethod
        """
        super(IpConfiguration, self).__init__(**kwargs)
        self.subnet = subnet
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method


class OutboundEndpoint(TrackedResource):
    """Describes an outbound endpoint for a DNS resolver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar etag: ETag of the outbound endpoint.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~dns_resolver_management_client.models.SystemData
    :ivar subnet: The reference to the subnet used for the outbound endpoint.
    :vartype subnet: ~dns_resolver_management_client.models.SubResource
    :ivar provisioning_state: The current provisioning state of the outbound endpoint. This is a
     read-only property and any attempt to set this value will be ignored. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or ~dns_resolver_management_client.models.ProvisioningState
    :ivar resource_guid: The resourceGuid property of the outbound endpoint resource.
    :vartype resource_guid: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_guid': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        subnet: Optional["SubResource"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword subnet: The reference to the subnet used for the outbound endpoint.
        :paramtype subnet: ~dns_resolver_management_client.models.SubResource
        """
        super(OutboundEndpoint, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = None
        self.system_data = None
        self.subnet = subnet
        self.provisioning_state = None
        self.resource_guid = None


class OutboundEndpointListResult(msrest.serialization.Model):
    """The response to an enumeration operation on outbound endpoints for a DNS resolver.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Enumeration of the outbound endpoints for a DNS resolver.
    :vartype value: list[~dns_resolver_management_client.models.OutboundEndpoint]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OutboundEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword value: Enumeration of the outbound endpoints for a DNS resolver.
        :paramtype value: list[~dns_resolver_management_client.models.OutboundEndpoint]
        """
        super(OutboundEndpointListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class OutboundEndpointPatch(msrest.serialization.Model):
    """Describes an outbound endpoint for a DNS resolver for PATCH operation.

    :ivar tags: A set of tags. Tags for outbound endpoint.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Tags for outbound endpoint.
        :paramtype tags: dict[str, str]
        """
        super(OutboundEndpointPatch, self).__init__(**kwargs)
        self.tags = tags


class SubResource(msrest.serialization.Model):
    """Reference to another ARM resource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class SubResourceListResult(msrest.serialization.Model):
    """The response to an enumeration operation on sub-resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Enumeration of the sub-resources.
    :vartype value: list[~dns_resolver_management_client.models.SubResource]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SubResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: Enumeration of the sub-resources.
        :paramtype value: list[~dns_resolver_management_client.models.SubResource]
        """
        super(SubResourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~dns_resolver_management_client.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~dns_resolver_management_client.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~dns_resolver_management_client.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~dns_resolver_management_client.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TargetDnsServer(msrest.serialization.Model):
    """Describes a server to forward the DNS queries to.

    :ivar ip_address: DNS server IP address.
    :vartype ip_address: str
    :ivar port: DNS server port.
    :vartype port: int
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = 53,
        **kwargs
    ):
        """
        :keyword ip_address: DNS server IP address.
        :paramtype ip_address: str
        :keyword port: DNS server port.
        :paramtype port: int
        """
        super(TargetDnsServer, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port


class VirtualNetworkDnsForwardingRuleset(msrest.serialization.Model):
    """Reference to DNS forwarding ruleset and associated virtual network link.

    :ivar id: DNS Forwarding Ruleset Resource ID.
    :vartype id: str
    :ivar virtual_network_link: The reference to the virtual network link.
    :vartype virtual_network_link: ~dns_resolver_management_client.models.SubResource
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'virtual_network_link': {'key': 'properties.virtualNetworkLink', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        virtual_network_link: Optional["SubResource"] = None,
        **kwargs
    ):
        """
        :keyword id: DNS Forwarding Ruleset Resource ID.
        :paramtype id: str
        :keyword virtual_network_link: The reference to the virtual network link.
        :paramtype virtual_network_link: ~dns_resolver_management_client.models.SubResource
        """
        super(VirtualNetworkDnsForwardingRuleset, self).__init__(**kwargs)
        self.id = id
        self.virtual_network_link = virtual_network_link


class VirtualNetworkDnsForwardingRulesetListResult(msrest.serialization.Model):
    """The response to an enumeration operation on Virtual Network DNS Forwarding Ruleset.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Enumeration of the Virtual Network DNS Forwarding Ruleset.
    :vartype value: list[~dns_resolver_management_client.models.VirtualNetworkDnsForwardingRuleset]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkDnsForwardingRuleset]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetworkDnsForwardingRuleset"]] = None,
        **kwargs
    ):
        """
        :keyword value: Enumeration of the Virtual Network DNS Forwarding Ruleset.
        :paramtype value:
         list[~dns_resolver_management_client.models.VirtualNetworkDnsForwardingRuleset]
        """
        super(VirtualNetworkDnsForwardingRulesetListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkLink(ProxyResource):
    """Describes a virtual network link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: ETag of the virtual network link.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~dns_resolver_management_client.models.SystemData
    :ivar virtual_network: The reference to the virtual network. This cannot be changed after
     creation.
    :vartype virtual_network: ~dns_resolver_management_client.models.SubResource
    :ivar metadata: Metadata attached to the virtual network link.
    :vartype metadata: dict[str, str]
    :ivar provisioning_state: The current provisioning state of the virtual network link. This is a
     read-only property and any attempt to set this value will be ignored. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or ~dns_resolver_management_client.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'SubResource'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network: Optional["SubResource"] = None,
        metadata: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword virtual_network: The reference to the virtual network. This cannot be changed after
         creation.
        :paramtype virtual_network: ~dns_resolver_management_client.models.SubResource
        :keyword metadata: Metadata attached to the virtual network link.
        :paramtype metadata: dict[str, str]
        """
        super(VirtualNetworkLink, self).__init__(**kwargs)
        self.etag = None
        self.system_data = None
        self.virtual_network = virtual_network
        self.metadata = metadata
        self.provisioning_state = None


class VirtualNetworkLinkListResult(msrest.serialization.Model):
    """The response to an enumeration operation on virtual network links.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Enumeration of the virtual network links.
    :vartype value: list[~dns_resolver_management_client.models.VirtualNetworkLink]
    :ivar next_link: The continuation token for the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetworkLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetworkLink"]] = None,
        **kwargs
    ):
        """
        :keyword value: Enumeration of the virtual network links.
        :paramtype value: list[~dns_resolver_management_client.models.VirtualNetworkLink]
        """
        super(VirtualNetworkLinkListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualNetworkLinkPatch(msrest.serialization.Model):
    """Describes a virtual network link for PATCH operation.

    :ivar metadata: Metadata attached to the virtual network link.
    :vartype metadata: dict[str, str]
    """

    _attribute_map = {
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword metadata: Metadata attached to the virtual network link.
        :paramtype metadata: dict[str, str]
        """
        super(VirtualNetworkLinkPatch, self).__init__(**kwargs)
        self.metadata = metadata
