# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import AzureMediaServicesConfiguration
from .operations import AccountFiltersOperations
from .operations import Operations
from .operations import MediaservicesOperations
from .operations import PrivateLinkResourcesOperations
from .operations import PrivateEndpointConnectionsOperations
from .operations import LocationsOperations
from .operations import AssetsOperations
from .operations import AssetFiltersOperations
from .operations import ContentKeyPoliciesOperations
from .operations import TransformsOperations
from .operations import JobsOperations
from .operations import StreamingPoliciesOperations
from .operations import StreamingLocatorsOperations
from .operations import LiveEventsOperations
from .operations import LiveOutputsOperations
from .operations import StreamingEndpointsOperations
from . import models


class AzureMediaServices(SDKClient):
    """AzureMediaServices

    :ivar config: Configuration for client.
    :vartype config: AzureMediaServicesConfiguration

    :ivar account_filters: AccountFilters operations
    :vartype account_filters: azure.mgmt.media.operations.AccountFiltersOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.media.operations.Operations
    :ivar mediaservices: Mediaservices operations
    :vartype mediaservices: azure.mgmt.media.operations.MediaservicesOperations
    :ivar private_link_resources: PrivateLinkResources operations
    :vartype private_link_resources: azure.mgmt.media.operations.PrivateLinkResourcesOperations
    :ivar private_endpoint_connections: PrivateEndpointConnections operations
    :vartype private_endpoint_connections: azure.mgmt.media.operations.PrivateEndpointConnectionsOperations
    :ivar locations: Locations operations
    :vartype locations: azure.mgmt.media.operations.LocationsOperations
    :ivar assets: Assets operations
    :vartype assets: azure.mgmt.media.operations.AssetsOperations
    :ivar asset_filters: AssetFilters operations
    :vartype asset_filters: azure.mgmt.media.operations.AssetFiltersOperations
    :ivar content_key_policies: ContentKeyPolicies operations
    :vartype content_key_policies: azure.mgmt.media.operations.ContentKeyPoliciesOperations
    :ivar transforms: Transforms operations
    :vartype transforms: azure.mgmt.media.operations.TransformsOperations
    :ivar jobs: Jobs operations
    :vartype jobs: azure.mgmt.media.operations.JobsOperations
    :ivar streaming_policies: StreamingPolicies operations
    :vartype streaming_policies: azure.mgmt.media.operations.StreamingPoliciesOperations
    :ivar streaming_locators: StreamingLocators operations
    :vartype streaming_locators: azure.mgmt.media.operations.StreamingLocatorsOperations
    :ivar live_events: LiveEvents operations
    :vartype live_events: azure.mgmt.media.operations.LiveEventsOperations
    :ivar live_outputs: LiveOutputs operations
    :vartype live_outputs: azure.mgmt.media.operations.LiveOutputsOperations
    :ivar streaming_endpoints: StreamingEndpoints operations
    :vartype streaming_endpoints: azure.mgmt.media.operations.StreamingEndpointsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The unique identifier for a Microsoft Azure
     subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = AzureMediaServicesConfiguration(credentials, subscription_id, base_url)
        super(AzureMediaServices, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2020-05-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.account_filters = AccountFiltersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.mediaservices = MediaservicesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.locations = LocationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.assets = AssetsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.asset_filters = AssetFiltersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.content_key_policies = ContentKeyPoliciesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.transforms = TransformsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.jobs = JobsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.streaming_policies = StreamingPoliciesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.streaming_locators = StreamingLocatorsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.live_events = LiveEventsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.live_outputs = LiveOutputsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.streaming_endpoints = StreamingEndpointsOperations(
            self._client, self.config, self._serialize, self._deserialize)
