# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

from . import models
from ._configuration import RecoveryServicesBackupPassiveClientConfiguration
from .operations import AadPropertiesOperations, BackupCrrJobDetailsOperations, BackupCrrJobsOperations, BackupProtectedItemsCrrOperations, BackupResourceStorageConfigsOperations, BackupUsageSummariesCRROperations, CrossRegionRestoreOperations, CrrOperationResultsOperations, CrrOperationStatusOperations, RecoveryPointsCrrOperations, RecoveryPointsOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential
    from azure.core.rest import HttpRequest, HttpResponse

class RecoveryServicesBackupPassiveClient(object):
    """Open API 2.0 Specs for Azure RecoveryServices Backup service.

    :ivar backup_usage_summaries_crr: BackupUsageSummariesCRROperations operations
    :vartype backup_usage_summaries_crr:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.BackupUsageSummariesCRROperations
    :ivar aad_properties: AadPropertiesOperations operations
    :vartype aad_properties:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.AadPropertiesOperations
    :ivar cross_region_restore: CrossRegionRestoreOperations operations
    :vartype cross_region_restore:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.CrossRegionRestoreOperations
    :ivar backup_crr_job_details: BackupCrrJobDetailsOperations operations
    :vartype backup_crr_job_details:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.BackupCrrJobDetailsOperations
    :ivar backup_crr_jobs: BackupCrrJobsOperations operations
    :vartype backup_crr_jobs:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.BackupCrrJobsOperations
    :ivar crr_operation_results: CrrOperationResultsOperations operations
    :vartype crr_operation_results:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.CrrOperationResultsOperations
    :ivar crr_operation_status: CrrOperationStatusOperations operations
    :vartype crr_operation_status:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.CrrOperationStatusOperations
    :ivar recovery_points: RecoveryPointsOperations operations
    :vartype recovery_points:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.RecoveryPointsOperations
    :ivar backup_resource_storage_configs: BackupResourceStorageConfigsOperations operations
    :vartype backup_resource_storage_configs:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.BackupResourceStorageConfigsOperations
    :ivar recovery_points_crr: RecoveryPointsCrrOperations operations
    :vartype recovery_points_crr:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.RecoveryPointsCrrOperations
    :ivar backup_protected_items_crr: BackupProtectedItemsCrrOperations operations
    :vartype backup_protected_items_crr:
     azure.mgmt.recoveryservicesbackup.passivestamp.operations.BackupProtectedItemsCrrOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The subscription Id.
    :type subscription_id: str
    :param base_url: Service URL. Default value is 'https://management.azure.com'.
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url="https://management.azure.com",  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        self._config = RecoveryServicesBackupPassiveClientConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.backup_usage_summaries_crr = BackupUsageSummariesCRROperations(self._client, self._config, self._serialize, self._deserialize)
        self.aad_properties = AadPropertiesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.cross_region_restore = CrossRegionRestoreOperations(self._client, self._config, self._serialize, self._deserialize)
        self.backup_crr_job_details = BackupCrrJobDetailsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.backup_crr_jobs = BackupCrrJobsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.crr_operation_results = CrrOperationResultsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.crr_operation_status = CrrOperationStatusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.recovery_points = RecoveryPointsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.backup_resource_storage_configs = BackupResourceStorageConfigsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.recovery_points_crr = RecoveryPointsCrrOperations(self._client, self._config, self._serialize, self._deserialize)
        self.backup_protected_items_crr = BackupProtectedItemsCrrOperations(self._client, self._config, self._serialize, self._deserialize)


    def _send_request(
        self,
        request,  # type: HttpRequest
        **kwargs  # type: Any
    ):
        # type: (...) -> HttpResponse
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> RecoveryServicesBackupPassiveClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
