/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.permissions;

import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.ow2.proactive.permissions.RoleAdmin;
import org.ow2.proactive.permissions.RoleBasic;
import org.ow2.proactive.permissions.RoleNSAdmin;
import org.ow2.proactive.permissions.RoleProvider;
import org.ow2.proactive.permissions.RoleRead;
import org.ow2.proactive.permissions.RoleWrite;

public class RoleUtils {
    private static final Logger logger = Logger.getLogger(RoleUtils.class);

    public static String findRole(Method method) {
        if (method.getAnnotation(RoleBasic.class) != null) {
            return Role.basic.name();
        }
        if (method.getAnnotation(RoleRead.class) != null) {
            return Role.read.name();
        }
        if (method.getAnnotation(RoleWrite.class) != null) {
            return Role.write.name();
        }
        if (method.getAnnotation(RoleProvider.class) != null) {
            return Role.provider.name();
        }
        if (method.getAnnotation(RoleNSAdmin.class) != null) {
            return Role.nsadmin.name();
        }
        if (method.getAnnotation(RoleAdmin.class) != null) {
            return Role.admin.name();
        }
        return Role.none.name();
    }

    public static Method findMethod(Class clazz, String methodName) {
        for (Method method : clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        logger.warn((Object)("Method " + methodName + " does not exist in " + clazz.getName()));
        throw new SecurityException("Method " + methodName + " does not exist in " + clazz.getName());
    }

    public static enum Role {
        basic,
        read,
        write,
        provider,
        nsadmin,
        admin,
        none;

    }
}

