/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.scheduler.client.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.VFS;
import org.apache.log4j.Logger;

public class Zipper {
    private static final Logger logger = Logger.getLogger(Zipper.class);
    private static byte[] MAGIC = new byte[]{80, 75, 3, 4};

    private Zipper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipFile(File file) throws FileNotFoundException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            boolean bl = Zipper.isZipFile(inputStream);
            return bl;
        }
        catch (IOException e) {
            throw new FileNotFoundException("Error when reading file " + file + " " + e.getMessage());
        }
    }

    public static boolean isZipFile(InputStream is) {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        boolean isZipStream = true;
        try {
            is.mark(MAGIC.length);
            for (int i = 0; i < MAGIC.length; ++i) {
                if (MAGIC[i] == (byte)is.read()) continue;
                isZipStream = false;
                break;
            }
            is.reset();
        }
        catch (IOException ioe) {
            isZipStream = false;
        }
        return isZipStream;
    }

    private static class FilesOnlyPredicate
    implements Predicate<File> {
        private FilesOnlyPredicate() {
        }

        public boolean apply(File file) {
            boolean answer;
            boolean bl = answer = !file.isDirectory();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Analysing file " + file + " : " + answer));
            }
            return answer;
        }
    }

    public static class ZIP {
        private static List<File> findFiles(File root, org.objectweb.proactive.extensions.dataspaces.vfs.selector.FileSelector selector) {
            ArrayList<File> listFiles = new ArrayList<File>();
            try {
                FileObject[] fos;
                FileObject rootObject = VFS.getManager().toFileObject(root);
                for (FileObject fo : fos = rootObject.findFiles((FileSelector)selector)) {
                    listFiles.add(new File(new URI(fo.getName().getURI())));
                }
            }
            catch (Exception e) {
                logger.error((Object)"An error occurred while zipping files: ", (Throwable)e);
            }
            return listFiles;
        }

        private static ImmutableList<File> filterNotEmpty(File root, List<String> includes, List<String> excludes) {
            org.objectweb.proactive.extensions.dataspaces.vfs.selector.FileSelector fileSelector = new org.objectweb.proactive.extensions.dataspaces.vfs.selector.FileSelector();
            fileSelector.addIncludes(includes);
            fileSelector.addExcludes(excludes);
            return ImmutableList.copyOf(ZIP.findFiles(root, fileSelector));
        }

        private static ImmutableList<File> filterEmpty(File root) {
            FluentIterable fi = FluentIterable.from((Iterable)Files.fileTraverser().depthFirstPostOrder((Object)root));
            return fi.filter((Predicate)new FilesOnlyPredicate()).toList();
        }

        public static void zip(File root, List<String> includes, List<String> excludes, OutputStream os) throws IOException {
            ArrayList<String> logIncludes = ZIP.nullOrEmpty(includes) ? new ArrayList<String>() : includes;
            ArrayList<String> logExcludes = ZIP.nullOrEmpty(excludes) ? new ArrayList<String>() : excludes;
            logger.trace((Object)("Includes list : " + ((Object)logIncludes).toString()));
            logger.trace((Object)("Excludes list : " + ((Object)logExcludes).toString()));
            Preconditions.checkNotNull((Object)root);
            Preconditions.checkNotNull((Object)os);
            ImmutableList<File> fileList = ZIP.nullOrEmpty(includes) && ZIP.nullOrEmpty(excludes) ? ZIP.filterEmpty(root) : ZIP.filterNotEmpty(root, includes, excludes);
            logger.trace((Object)("Zipping files :" + fileList));
            ZIP.zipFiles(fileList, root.getAbsolutePath(), os);
        }

        private static boolean nullOrEmpty(List<String> strings) {
            return strings == null || strings.size() == 0;
        }

        private static void zipFiles(List<File> files, String basepath, OutputStream os) throws IOException {
            try (Closer closer = Closer.create();){
                ZipOutputStream zos = new ZipOutputStream(os);
                closer.register((Closeable)zos);
                for (File file : files) {
                    if (file.isFile()) {
                        FileInputStream inputStream = new FileInputStream(file);
                        closer.register((Closeable)inputStream);
                        ZIP.writeZipEntry(ZIP.zipEntry(basepath, file), inputStream, zos);
                        continue;
                    }
                    ZipEntry ze = ZIP.zipEntry(basepath, file);
                    logger.trace((Object)("Adding directory zip entry: " + ze.toString()));
                    zos.putNextEntry(ze);
                }
            }
        }

        public static void writeZipEntry(ZipEntry zipEntry, InputStream is, ZipOutputStream zos) throws IOException {
            Closer closer = Closer.create();
            closer.register((Closeable)is);
            try {
                logger.trace((Object)("Adding file zip entry: " + zipEntry.toString()));
                zos.putNextEntry(zipEntry);
                ByteStreams.copy((InputStream)is, (OutputStream)zos);
                zos.flush();
            }
            catch (IOException ioe) {
                throw closer.rethrow((Throwable)ioe);
            }
            finally {
                closer.close();
            }
        }

        public static void unzip(InputStream is, File outFile) throws IOException {
            try (Closer closer = Closer.create();){
                ZipInputStream zis = new ZipInputStream(is);
                closer.register((Closeable)zis);
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    File entryFile = new File(outFile, zipEntry.getName());
                    File entryContainer = entryFile.getParentFile();
                    if (!entryContainer.exists()) {
                        entryContainer.mkdirs();
                    }
                    if (!entryFile.isDirectory()) {
                        FileOutputStream outputStream = new FileOutputStream(entryFile);
                        closer.register((Closeable)outputStream);
                        ZIP.unzipEntry(zis, outputStream);
                    }
                    zipEntry = zis.getNextEntry();
                }
            }
        }

        public static void unzipEntry(ZipInputStream zis, OutputStream os) throws IOException {
            Closer closer = Closer.create();
            closer.register((Closeable)os);
            try {
                ByteStreams.copy((InputStream)zis, (OutputStream)os);
            }
            catch (IOException ioe) {
                throw closer.rethrow((Throwable)ioe);
            }
            finally {
                closer.close();
            }
        }

        private static String getRealRelativeFilePath(String basepath, String absolutePath) throws IOException {
            String realAbsolutePath = Paths.get(absolutePath, new String[0]).toRealPath(new LinkOption[0]).toString();
            String realBasePath = Paths.get(basepath, new String[0]).toRealPath(new LinkOption[0]).toString();
            return basepath.endsWith(File.separator) ? realAbsolutePath.substring(realBasePath.length()) : realAbsolutePath.substring(realBasePath.length() + 1);
        }

        private static ZipEntry zipEntry(String basepath, File file) throws IOException {
            String name = Strings.isNullOrEmpty((String)basepath) || basepath.equals(file.getAbsolutePath()) ? file.getPath() : ZIP.getRealRelativeFilePath(basepath, file.getAbsolutePath());
            name = file.isDirectory() ? new File(name, File.separator).toString() : name;
            return new ZipEntry(name);
        }
    }

    public static class GZIP {
        public static void zip(File file, OutputStream os) throws IOException {
            Preconditions.checkNotNull((Object)file);
            Preconditions.checkNotNull((Object)os);
            try (FileInputStream inputStream = new FileInputStream(file);){
                GZIP.zip(inputStream, os);
            }
        }

        public static void zip(InputStream is, OutputStream os) throws IOException {
            Closer closer = Closer.create();
            closer.register((Closeable)is);
            try {
                GZIPOutputStream zos = new GZIPOutputStream(os);
                closer.register((Closeable)zos);
                ByteStreams.copy((InputStream)is, (OutputStream)zos);
            }
            catch (IOException ioe) {
                throw closer.rethrow((Throwable)ioe);
            }
            finally {
                closer.close();
            }
        }

        public static void unzip(InputStream is, File file) throws IOException {
            Preconditions.checkNotNull((Object)is);
            Preconditions.checkNotNull((Object)file);
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                GZIP.unzip(is, outputStream);
            }
        }

        public static void unzip(InputStream is, OutputStream os) throws IOException {
            Closer closer = Closer.create();
            closer.register((Closeable)os);
            try {
                GZIPInputStream gis = new GZIPInputStream(is);
                closer.register((Closeable)gis);
                ByteStreams.copy((InputStream)gis, (OutputStream)os);
            }
            catch (IOException ioe) {
                throw closer.rethrow((Throwable)ioe);
            }
            finally {
                closer.close();
            }
        }
    }
}

