# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActiveDirectory(Model):
    """Active Directory.

    :param active_directory_id: Id of the Active Directory
    :type active_directory_id: str
    :param username: Username of Active Directory domain administrator
    :type username: str
    :param password: Plain text password of Active Directory domain
     administrator
    :type password: str
    :param domain: Name of the Active Directory domain
    :type domain: str
    :param d_ns: Comma separated list of DNS server IP addresses for the
     Active Directory domain
    :type d_ns: str
    :param status: Status of the Active Directory
    :type status: str
    :param s_mb_server_name: NetBIOS name of the SMB server. This name will be
     registered as a computer account in the AD and used to mount volumes
    :type s_mb_server_name: str
    :param organizational_unit: The Organizational Unit (OU) within the
     Windows Active Directory
    :type organizational_unit: str
    """

    _attribute_map = {
        'active_directory_id': {'key': 'activeDirectoryId', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'd_ns': {'key': 'dNS', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        's_mb_server_name': {'key': 'sMBServerName', 'type': 'str'},
        'organizational_unit': {'key': 'organizationalUnit', 'type': 'str'},
    }

    def __init__(self, *, active_directory_id: str=None, username: str=None, password: str=None, domain: str=None, d_ns: str=None, status: str=None, s_mb_server_name: str=None, organizational_unit: str=None, **kwargs) -> None:
        super(ActiveDirectory, self).__init__(**kwargs)
        self.active_directory_id = active_directory_id
        self.username = username
        self.password = password
        self.domain = domain
        self.d_ns = d_ns
        self.status = status
        self.s_mb_server_name = s_mb_server_name
        self.organizational_unit = organizational_unit
