/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.nio.charset.Charset;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.zip.ZipFileSystem;

public class ZipFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String _PREFIX = ZipFileSystemConfigBuilder.class.getName();
    private static final ZipFileSystemConfigBuilder INSTANCE = new ZipFileSystemConfigBuilder();
    private static final String KEY_CHARSET = _PREFIX + ".charset";

    public static final ZipFileSystemConfigBuilder getInstance() {
        return INSTANCE;
    }

    private ZipFileSystemConfigBuilder() {
        super("zip.");
    }

    public Charset getCharset(FileSystemOptions opts) {
        return (Charset)this.getParam(opts, KEY_CHARSET);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return ZipFileSystem.class;
    }

    public void setCharset(FileSystemOptions opts, Charset charset) {
        this.setParam(opts, KEY_CHARSET, charset);
    }
}

