/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;

public class JobDeadline {
    private final Date absoluteDeadline;
    private final Duration relativeDeadline;

    public JobDeadline(Date absoluteDeadline) {
        this.absoluteDeadline = absoluteDeadline;
        this.relativeDeadline = null;
    }

    public JobDeadline(Duration relativeDeadline) {
        this.absoluteDeadline = null;
        this.relativeDeadline = relativeDeadline;
    }

    public Date getAbsoluteDeadline() {
        assert (this.isAbsolute()) : "Job deadline is not absolute: " + this.relativeDeadline;
        return this.absoluteDeadline;
    }

    public Duration getRelativeDeadline() {
        assert (this.isRelative()) : "Job deadline is not relative: " + this.absoluteDeadline;
        return this.relativeDeadline;
    }

    public boolean isAbsolute() {
        return this.absoluteDeadline != null;
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public static Optional<Duration> parseDuration(String stringAsDuration) throws Exception {
        if (stringAsDuration != null && stringAsDuration.length() > 0) {
            Date date = JobDeadline.applyFormats(stringAsDuration, new SimpleDateFormat("HH:mm:ss"), new SimpleDateFormat("mm:ss"), new SimpleDateFormat("ss"));
            return Optional.of(Duration.ofMillis(date.getTime()));
        }
        return Optional.empty();
    }

    public static Date applyFormats(String expression, DateFormat ... dateFormats) throws ParseException {
        int i;
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        for (i = 0; i < dateFormats.length - 1; ++i) {
            try {
                dateFormats[i].setTimeZone(timeZone);
                return dateFormats[i].parse(expression);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        dateFormats[i].setTimeZone(timeZone);
        return dateFormats[i].parse(expression);
    }
}

