/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.resourcemanager.common.event;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.resourcemanager.common.event.RMEvent;
import org.ow2.proactive.resourcemanager.common.event.RMEventType;

@PublicAPI
public class RMNodeSourceEvent
extends RMEvent {
    private String nodeSourceName = null;
    private String nodeSourceDescription = null;
    private LinkedHashMap<String, String> additionalInformation = null;
    private String nodeSourceAdmin = null;
    private String nodeSourceStatus;
    private String infrastructureType;
    private String policyType;
    private List<String> accessTokens;
    private static final long serialVersionUID = 142L;

    public RMNodeSourceEvent() {
    }

    public RMNodeSourceEvent(String nodeSourceName, String nodeSourceDescription, LinkedHashMap<String, String> additionalInformation, String nodeSourceAdmin, String nodeSourceStatus, String infrastructureType, String policyType, String[] accessTokens) {
        this.nodeSourceName = nodeSourceName;
        this.nodeSourceDescription = nodeSourceDescription;
        this.additionalInformation = new LinkedHashMap<String, String>(additionalInformation);
        this.nodeSourceAdmin = nodeSourceAdmin;
        this.nodeSourceStatus = nodeSourceStatus;
        this.infrastructureType = infrastructureType;
        this.policyType = policyType;
        this.accessTokens = accessTokens != null ? Arrays.asList(accessTokens) : Collections.emptyList();
    }

    public RMNodeSourceEvent(RMEventType type, String initiator, String nodeSourceName, String nodeSourceDescription, LinkedHashMap<String, String> additionalInformation, String nodeSourceAdmin, String nodeSourceStatus, String infrastructureType, String policyType, String[] accessTokens) {
        super(type);
        this.initiator = initiator;
        this.nodeSourceName = nodeSourceName;
        this.nodeSourceDescription = nodeSourceDescription;
        this.additionalInformation = new LinkedHashMap<String, String>(additionalInformation);
        this.nodeSourceAdmin = nodeSourceAdmin;
        this.nodeSourceStatus = nodeSourceStatus;
        this.infrastructureType = infrastructureType;
        this.policyType = policyType;
        this.accessTokens = accessTokens != null ? Arrays.asList(accessTokens) : Collections.emptyList();
    }

    public RMNodeSourceEvent(String nodeSourceName, long counter) {
        this.nodeSourceName = nodeSourceName;
        this.counter = counter;
    }

    @Override
    public String getKey() {
        return this.getSourceName();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getKey() == null ? 0 : this.getKey().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RMNodeSourceEvent)) {
            return false;
        }
        RMNodeSourceEvent other = (RMNodeSourceEvent)obj;
        return !(this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey()));
    }

    public String getSourceName() {
        return this.nodeSourceName;
    }

    public String getSourceDescription() {
        return this.nodeSourceDescription;
    }

    public LinkedHashMap<String, String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public String getNodeSourceAdmin() {
        return this.nodeSourceAdmin;
    }

    public String getNodeSourceStatus() {
        return this.nodeSourceStatus;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getEventType()) + (this.counter > 0L ? " counter: " + this.counter + " " : "") + "[" + this.getSourceName() + "]";
    }

    public String getNodeSourceName() {
        return this.nodeSourceName;
    }

    public String getNodeSourceDescription() {
        return this.nodeSourceDescription;
    }

    public String getInfrastructureType() {
        return this.infrastructureType;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public List<String> getAccessTokens() {
        return this.accessTokens;
    }
}

