"""GLES 2 wrapper for PyOpenGL"""
from OpenGL import constants as _cs 
from OpenGL import platform as _p
from OpenGL import arrays
from OpenGL.constant import IntConstant as _C
import ctypes

def _f( function ):
    return _p.createFunction( function,_p.GL,None,False)
GL_ES_VERSION_2_0=_C('GL_ES_VERSION_2_0',1)
GL_DEPTH_BUFFER_BIT=_C('GL_DEPTH_BUFFER_BIT',0x00000100)
GL_STENCIL_BUFFER_BIT=_C('GL_STENCIL_BUFFER_BIT',0x00000400)
GL_COLOR_BUFFER_BIT=_C('GL_COLOR_BUFFER_BIT',0x00004000)
GL_FALSE=_C('GL_FALSE',0)
GL_TRUE=_C('GL_TRUE',1)
GL_POINTS=_C('GL_POINTS',0x0000)
GL_LINES=_C('GL_LINES',0x0001)
GL_LINE_LOOP=_C('GL_LINE_LOOP',0x0002)
GL_LINE_STRIP=_C('GL_LINE_STRIP',0x0003)
GL_TRIANGLES=_C('GL_TRIANGLES',0x0004)
GL_TRIANGLE_STRIP=_C('GL_TRIANGLE_STRIP',0x0005)
GL_TRIANGLE_FAN=_C('GL_TRIANGLE_FAN',0x0006)
GL_ZERO=_C('GL_ZERO',0)
GL_ONE=_C('GL_ONE',1)
GL_SRC_COLOR=_C('GL_SRC_COLOR',0x0300)
GL_ONE_MINUS_SRC_COLOR=_C('GL_ONE_MINUS_SRC_COLOR',0x0301)
GL_SRC_ALPHA=_C('GL_SRC_ALPHA',0x0302)
GL_ONE_MINUS_SRC_ALPHA=_C('GL_ONE_MINUS_SRC_ALPHA',0x0303)
GL_DST_ALPHA=_C('GL_DST_ALPHA',0x0304)
GL_ONE_MINUS_DST_ALPHA=_C('GL_ONE_MINUS_DST_ALPHA',0x0305)
GL_DST_COLOR=_C('GL_DST_COLOR',0x0306)
GL_ONE_MINUS_DST_COLOR=_C('GL_ONE_MINUS_DST_COLOR',0x0307)
GL_SRC_ALPHA_SATURATE=_C('GL_SRC_ALPHA_SATURATE',0x0308)
GL_FUNC_ADD=_C('GL_FUNC_ADD',0x8006)
GL_BLEND_EQUATION=_C('GL_BLEND_EQUATION',0x8009)
GL_BLEND_EQUATION_RGB=_C('GL_BLEND_EQUATION_RGB',0x8009)
GL_BLEND_EQUATION_ALPHA=_C('GL_BLEND_EQUATION_ALPHA',0x883D)
GL_FUNC_SUBTRACT=_C('GL_FUNC_SUBTRACT',0x800A)
GL_FUNC_REVERSE_SUBTRACT=_C('GL_FUNC_REVERSE_SUBTRACT',0x800B)
GL_BLEND_DST_RGB=_C('GL_BLEND_DST_RGB',0x80C8)
GL_BLEND_SRC_RGB=_C('GL_BLEND_SRC_RGB',0x80C9)
GL_BLEND_DST_ALPHA=_C('GL_BLEND_DST_ALPHA',0x80CA)
GL_BLEND_SRC_ALPHA=_C('GL_BLEND_SRC_ALPHA',0x80CB)
GL_CONSTANT_COLOR=_C('GL_CONSTANT_COLOR',0x8001)
GL_ONE_MINUS_CONSTANT_COLOR=_C('GL_ONE_MINUS_CONSTANT_COLOR',0x8002)
GL_CONSTANT_ALPHA=_C('GL_CONSTANT_ALPHA',0x8003)
GL_ONE_MINUS_CONSTANT_ALPHA=_C('GL_ONE_MINUS_CONSTANT_ALPHA',0x8004)
GL_BLEND_COLOR=_C('GL_BLEND_COLOR',0x8005)
GL_ARRAY_BUFFER=_C('GL_ARRAY_BUFFER',0x8892)
GL_ELEMENT_ARRAY_BUFFER=_C('GL_ELEMENT_ARRAY_BUFFER',0x8893)
GL_ARRAY_BUFFER_BINDING=_C('GL_ARRAY_BUFFER_BINDING',0x8894)
GL_ELEMENT_ARRAY_BUFFER_BINDING=_C('GL_ELEMENT_ARRAY_BUFFER_BINDING',0x8895)
GL_STREAM_DRAW=_C('GL_STREAM_DRAW',0x88E0)
GL_STATIC_DRAW=_C('GL_STATIC_DRAW',0x88E4)
GL_DYNAMIC_DRAW=_C('GL_DYNAMIC_DRAW',0x88E8)
GL_BUFFER_SIZE=_C('GL_BUFFER_SIZE',0x8764)
GL_BUFFER_USAGE=_C('GL_BUFFER_USAGE',0x8765)
GL_CURRENT_VERTEX_ATTRIB=_C('GL_CURRENT_VERTEX_ATTRIB',0x8626)
GL_FRONT=_C('GL_FRONT',0x0404)
GL_BACK=_C('GL_BACK',0x0405)
GL_FRONT_AND_BACK=_C('GL_FRONT_AND_BACK',0x0408)
GL_TEXTURE_2D=_C('GL_TEXTURE_2D',0x0DE1)
GL_CULL_FACE=_C('GL_CULL_FACE',0x0B44)
GL_BLEND=_C('GL_BLEND',0x0BE2)
GL_DITHER=_C('GL_DITHER',0x0BD0)
GL_STENCIL_TEST=_C('GL_STENCIL_TEST',0x0B90)
GL_DEPTH_TEST=_C('GL_DEPTH_TEST',0x0B71)
GL_SCISSOR_TEST=_C('GL_SCISSOR_TEST',0x0C11)
GL_POLYGON_OFFSET_FILL=_C('GL_POLYGON_OFFSET_FILL',0x8037)
GL_SAMPLE_ALPHA_TO_COVERAGE=_C('GL_SAMPLE_ALPHA_TO_COVERAGE',0x809E)
GL_SAMPLE_COVERAGE=_C('GL_SAMPLE_COVERAGE',0x80A0)
GL_NO_ERROR=_C('GL_NO_ERROR',0)
GL_INVALID_ENUM=_C('GL_INVALID_ENUM',0x0500)
GL_INVALID_VALUE=_C('GL_INVALID_VALUE',0x0501)
GL_INVALID_OPERATION=_C('GL_INVALID_OPERATION',0x0502)
GL_OUT_OF_MEMORY=_C('GL_OUT_OF_MEMORY',0x0505)
GL_CW=_C('GL_CW',0x0900)
GL_CCW=_C('GL_CCW',0x0901)
GL_LINE_WIDTH=_C('GL_LINE_WIDTH',0x0B21)
GL_ALIASED_POINT_SIZE_RANGE=_C('GL_ALIASED_POINT_SIZE_RANGE',0x846D)
GL_ALIASED_LINE_WIDTH_RANGE=_C('GL_ALIASED_LINE_WIDTH_RANGE',0x846E)
GL_CULL_FACE_MODE=_C('GL_CULL_FACE_MODE',0x0B45)
GL_FRONT_FACE=_C('GL_FRONT_FACE',0x0B46)
GL_DEPTH_RANGE=_C('GL_DEPTH_RANGE',0x0B70)
GL_DEPTH_WRITEMASK=_C('GL_DEPTH_WRITEMASK',0x0B72)
GL_DEPTH_CLEAR_VALUE=_C('GL_DEPTH_CLEAR_VALUE',0x0B73)
GL_DEPTH_FUNC=_C('GL_DEPTH_FUNC',0x0B74)
GL_STENCIL_CLEAR_VALUE=_C('GL_STENCIL_CLEAR_VALUE',0x0B91)
GL_STENCIL_FUNC=_C('GL_STENCIL_FUNC',0x0B92)
GL_STENCIL_FAIL=_C('GL_STENCIL_FAIL',0x0B94)
GL_STENCIL_PASS_DEPTH_FAIL=_C('GL_STENCIL_PASS_DEPTH_FAIL',0x0B95)
GL_STENCIL_PASS_DEPTH_PASS=_C('GL_STENCIL_PASS_DEPTH_PASS',0x0B96)
GL_STENCIL_REF=_C('GL_STENCIL_REF',0x0B97)
GL_STENCIL_VALUE_MASK=_C('GL_STENCIL_VALUE_MASK',0x0B93)
GL_STENCIL_WRITEMASK=_C('GL_STENCIL_WRITEMASK',0x0B98)
GL_STENCIL_BACK_FUNC=_C('GL_STENCIL_BACK_FUNC',0x8800)
GL_STENCIL_BACK_FAIL=_C('GL_STENCIL_BACK_FAIL',0x8801)
GL_STENCIL_BACK_PASS_DEPTH_FAIL=_C('GL_STENCIL_BACK_PASS_DEPTH_FAIL',0x8802)
GL_STENCIL_BACK_PASS_DEPTH_PASS=_C('GL_STENCIL_BACK_PASS_DEPTH_PASS',0x8803)
GL_STENCIL_BACK_REF=_C('GL_STENCIL_BACK_REF',0x8CA3)
GL_STENCIL_BACK_VALUE_MASK=_C('GL_STENCIL_BACK_VALUE_MASK',0x8CA4)
GL_STENCIL_BACK_WRITEMASK=_C('GL_STENCIL_BACK_WRITEMASK',0x8CA5)
GL_VIEWPORT=_C('GL_VIEWPORT',0x0BA2)
GL_SCISSOR_BOX=_C('GL_SCISSOR_BOX',0x0C10)
GL_COLOR_CLEAR_VALUE=_C('GL_COLOR_CLEAR_VALUE',0x0C22)
GL_COLOR_WRITEMASK=_C('GL_COLOR_WRITEMASK',0x0C23)
GL_UNPACK_ALIGNMENT=_C('GL_UNPACK_ALIGNMENT',0x0CF5)
GL_PACK_ALIGNMENT=_C('GL_PACK_ALIGNMENT',0x0D05)
GL_MAX_TEXTURE_SIZE=_C('GL_MAX_TEXTURE_SIZE',0x0D33)
GL_MAX_VIEWPORT_DIMS=_C('GL_MAX_VIEWPORT_DIMS',0x0D3A)
GL_SUBPIXEL_BITS=_C('GL_SUBPIXEL_BITS',0x0D50)
GL_RED_BITS=_C('GL_RED_BITS',0x0D52)
GL_GREEN_BITS=_C('GL_GREEN_BITS',0x0D53)
GL_BLUE_BITS=_C('GL_BLUE_BITS',0x0D54)
GL_ALPHA_BITS=_C('GL_ALPHA_BITS',0x0D55)
GL_DEPTH_BITS=_C('GL_DEPTH_BITS',0x0D56)
GL_STENCIL_BITS=_C('GL_STENCIL_BITS',0x0D57)
GL_POLYGON_OFFSET_UNITS=_C('GL_POLYGON_OFFSET_UNITS',0x2A00)
GL_POLYGON_OFFSET_FACTOR=_C('GL_POLYGON_OFFSET_FACTOR',0x8038)
GL_TEXTURE_BINDING_2D=_C('GL_TEXTURE_BINDING_2D',0x8069)
GL_SAMPLE_BUFFERS=_C('GL_SAMPLE_BUFFERS',0x80A8)
GL_SAMPLES=_C('GL_SAMPLES',0x80A9)
GL_SAMPLE_COVERAGE_VALUE=_C('GL_SAMPLE_COVERAGE_VALUE',0x80AA)
GL_SAMPLE_COVERAGE_INVERT=_C('GL_SAMPLE_COVERAGE_INVERT',0x80AB)
GL_NUM_COMPRESSED_TEXTURE_FORMATS=_C('GL_NUM_COMPRESSED_TEXTURE_FORMATS',0x86A2)
GL_COMPRESSED_TEXTURE_FORMATS=_C('GL_COMPRESSED_TEXTURE_FORMATS',0x86A3)
GL_DONT_CARE=_C('GL_DONT_CARE',0x1100)
GL_FASTEST=_C('GL_FASTEST',0x1101)
GL_NICEST=_C('GL_NICEST',0x1102)
GL_GENERATE_MIPMAP_HINT=_C('GL_GENERATE_MIPMAP_HINT',0x8192)
GL_BYTE=_C('GL_BYTE',0x1400)
GL_UNSIGNED_BYTE=_C('GL_UNSIGNED_BYTE',0x1401)
GL_SHORT=_C('GL_SHORT',0x1402)
GL_UNSIGNED_SHORT=_C('GL_UNSIGNED_SHORT',0x1403)
GL_INT=_C('GL_INT',0x1404)
GL_UNSIGNED_INT=_C('GL_UNSIGNED_INT',0x1405)
GL_FLOAT=_C('GL_FLOAT',0x1406)
GL_FIXED=_C('GL_FIXED',0x140C)
GL_DEPTH_COMPONENT=_C('GL_DEPTH_COMPONENT',0x1902)
GL_ALPHA=_C('GL_ALPHA',0x1906)
GL_RGB=_C('GL_RGB',0x1907)
GL_RGBA=_C('GL_RGBA',0x1908)
GL_LUMINANCE=_C('GL_LUMINANCE',0x1909)
GL_LUMINANCE_ALPHA=_C('GL_LUMINANCE_ALPHA',0x190A)
GL_UNSIGNED_SHORT_4_4_4_4=_C('GL_UNSIGNED_SHORT_4_4_4_4',0x8033)
GL_UNSIGNED_SHORT_5_5_5_1=_C('GL_UNSIGNED_SHORT_5_5_5_1',0x8034)
GL_UNSIGNED_SHORT_5_6_5=_C('GL_UNSIGNED_SHORT_5_6_5',0x8363)
GL_FRAGMENT_SHADER=_C('GL_FRAGMENT_SHADER',0x8B30)
GL_VERTEX_SHADER=_C('GL_VERTEX_SHADER',0x8B31)
GL_MAX_VERTEX_ATTRIBS=_C('GL_MAX_VERTEX_ATTRIBS',0x8869)
GL_MAX_VERTEX_UNIFORM_VECTORS=_C('GL_MAX_VERTEX_UNIFORM_VECTORS',0x8DFB)
GL_MAX_VARYING_VECTORS=_C('GL_MAX_VARYING_VECTORS',0x8DFC)
GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS=_C('GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS',0x8B4D)
GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS=_C('GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS',0x8B4C)
GL_MAX_TEXTURE_IMAGE_UNITS=_C('GL_MAX_TEXTURE_IMAGE_UNITS',0x8872)
GL_MAX_FRAGMENT_UNIFORM_VECTORS=_C('GL_MAX_FRAGMENT_UNIFORM_VECTORS',0x8DFD)
GL_SHADER_TYPE=_C('GL_SHADER_TYPE',0x8B4F)
GL_DELETE_STATUS=_C('GL_DELETE_STATUS',0x8B80)
GL_LINK_STATUS=_C('GL_LINK_STATUS',0x8B82)
GL_VALIDATE_STATUS=_C('GL_VALIDATE_STATUS',0x8B83)
GL_ATTACHED_SHADERS=_C('GL_ATTACHED_SHADERS',0x8B85)
GL_ACTIVE_UNIFORMS=_C('GL_ACTIVE_UNIFORMS',0x8B86)
GL_ACTIVE_UNIFORM_MAX_LENGTH=_C('GL_ACTIVE_UNIFORM_MAX_LENGTH',0x8B87)
GL_ACTIVE_ATTRIBUTES=_C('GL_ACTIVE_ATTRIBUTES',0x8B89)
GL_ACTIVE_ATTRIBUTE_MAX_LENGTH=_C('GL_ACTIVE_ATTRIBUTE_MAX_LENGTH',0x8B8A)
GL_SHADING_LANGUAGE_VERSION=_C('GL_SHADING_LANGUAGE_VERSION',0x8B8C)
GL_CURRENT_PROGRAM=_C('GL_CURRENT_PROGRAM',0x8B8D)
GL_NEVER=_C('GL_NEVER',0x0200)
GL_LESS=_C('GL_LESS',0x0201)
GL_EQUAL=_C('GL_EQUAL',0x0202)
GL_LEQUAL=_C('GL_LEQUAL',0x0203)
GL_GREATER=_C('GL_GREATER',0x0204)
GL_NOTEQUAL=_C('GL_NOTEQUAL',0x0205)
GL_GEQUAL=_C('GL_GEQUAL',0x0206)
GL_ALWAYS=_C('GL_ALWAYS',0x0207)
GL_KEEP=_C('GL_KEEP',0x1E00)
GL_REPLACE=_C('GL_REPLACE',0x1E01)
GL_INCR=_C('GL_INCR',0x1E02)
GL_DECR=_C('GL_DECR',0x1E03)
GL_INVERT=_C('GL_INVERT',0x150A)
GL_INCR_WRAP=_C('GL_INCR_WRAP',0x8507)
GL_DECR_WRAP=_C('GL_DECR_WRAP',0x8508)
GL_VENDOR=_C('GL_VENDOR',0x1F00)
GL_RENDERER=_C('GL_RENDERER',0x1F01)
GL_VERSION=_C('GL_VERSION',0x1F02)
GL_EXTENSIONS=_C('GL_EXTENSIONS',0x1F03)
GL_NEAREST=_C('GL_NEAREST',0x2600)
GL_LINEAR=_C('GL_LINEAR',0x2601)
GL_NEAREST_MIPMAP_NEAREST=_C('GL_NEAREST_MIPMAP_NEAREST',0x2700)
GL_LINEAR_MIPMAP_NEAREST=_C('GL_LINEAR_MIPMAP_NEAREST',0x2701)
GL_NEAREST_MIPMAP_LINEAR=_C('GL_NEAREST_MIPMAP_LINEAR',0x2702)
GL_LINEAR_MIPMAP_LINEAR=_C('GL_LINEAR_MIPMAP_LINEAR',0x2703)
GL_TEXTURE_MAG_FILTER=_C('GL_TEXTURE_MAG_FILTER',0x2800)
GL_TEXTURE_MIN_FILTER=_C('GL_TEXTURE_MIN_FILTER',0x2801)
GL_TEXTURE_WRAP_S=_C('GL_TEXTURE_WRAP_S',0x2802)
GL_TEXTURE_WRAP_T=_C('GL_TEXTURE_WRAP_T',0x2803)
GL_TEXTURE=_C('GL_TEXTURE',0x1702)
GL_TEXTURE_CUBE_MAP=_C('GL_TEXTURE_CUBE_MAP',0x8513)
GL_TEXTURE_BINDING_CUBE_MAP=_C('GL_TEXTURE_BINDING_CUBE_MAP',0x8514)
GL_TEXTURE_CUBE_MAP_POSITIVE_X=_C('GL_TEXTURE_CUBE_MAP_POSITIVE_X',0x8515)
GL_TEXTURE_CUBE_MAP_NEGATIVE_X=_C('GL_TEXTURE_CUBE_MAP_NEGATIVE_X',0x8516)
GL_TEXTURE_CUBE_MAP_POSITIVE_Y=_C('GL_TEXTURE_CUBE_MAP_POSITIVE_Y',0x8517)
GL_TEXTURE_CUBE_MAP_NEGATIVE_Y=_C('GL_TEXTURE_CUBE_MAP_NEGATIVE_Y',0x8518)
GL_TEXTURE_CUBE_MAP_POSITIVE_Z=_C('GL_TEXTURE_CUBE_MAP_POSITIVE_Z',0x8519)
GL_TEXTURE_CUBE_MAP_NEGATIVE_Z=_C('GL_TEXTURE_CUBE_MAP_NEGATIVE_Z',0x851A)
GL_MAX_CUBE_MAP_TEXTURE_SIZE=_C('GL_MAX_CUBE_MAP_TEXTURE_SIZE',0x851C)
GL_TEXTURE0=_C('GL_TEXTURE0',0x84C0)
GL_TEXTURE1=_C('GL_TEXTURE1',0x84C1)
GL_TEXTURE2=_C('GL_TEXTURE2',0x84C2)
GL_TEXTURE3=_C('GL_TEXTURE3',0x84C3)
GL_TEXTURE4=_C('GL_TEXTURE4',0x84C4)
GL_TEXTURE5=_C('GL_TEXTURE5',0x84C5)
GL_TEXTURE6=_C('GL_TEXTURE6',0x84C6)
GL_TEXTURE7=_C('GL_TEXTURE7',0x84C7)
GL_TEXTURE8=_C('GL_TEXTURE8',0x84C8)
GL_TEXTURE9=_C('GL_TEXTURE9',0x84C9)
GL_TEXTURE10=_C('GL_TEXTURE10',0x84CA)
GL_TEXTURE11=_C('GL_TEXTURE11',0x84CB)
GL_TEXTURE12=_C('GL_TEXTURE12',0x84CC)
GL_TEXTURE13=_C('GL_TEXTURE13',0x84CD)
GL_TEXTURE14=_C('GL_TEXTURE14',0x84CE)
GL_TEXTURE15=_C('GL_TEXTURE15',0x84CF)
GL_TEXTURE16=_C('GL_TEXTURE16',0x84D0)
GL_TEXTURE17=_C('GL_TEXTURE17',0x84D1)
GL_TEXTURE18=_C('GL_TEXTURE18',0x84D2)
GL_TEXTURE19=_C('GL_TEXTURE19',0x84D3)
GL_TEXTURE20=_C('GL_TEXTURE20',0x84D4)
GL_TEXTURE21=_C('GL_TEXTURE21',0x84D5)
GL_TEXTURE22=_C('GL_TEXTURE22',0x84D6)
GL_TEXTURE23=_C('GL_TEXTURE23',0x84D7)
GL_TEXTURE24=_C('GL_TEXTURE24',0x84D8)
GL_TEXTURE25=_C('GL_TEXTURE25',0x84D9)
GL_TEXTURE26=_C('GL_TEXTURE26',0x84DA)
GL_TEXTURE27=_C('GL_TEXTURE27',0x84DB)
GL_TEXTURE28=_C('GL_TEXTURE28',0x84DC)
GL_TEXTURE29=_C('GL_TEXTURE29',0x84DD)
GL_TEXTURE30=_C('GL_TEXTURE30',0x84DE)
GL_TEXTURE31=_C('GL_TEXTURE31',0x84DF)
GL_ACTIVE_TEXTURE=_C('GL_ACTIVE_TEXTURE',0x84E0)
GL_REPEAT=_C('GL_REPEAT',0x2901)
GL_CLAMP_TO_EDGE=_C('GL_CLAMP_TO_EDGE',0x812F)
GL_MIRRORED_REPEAT=_C('GL_MIRRORED_REPEAT',0x8370)
GL_FLOAT_VEC2=_C('GL_FLOAT_VEC2',0x8B50)
GL_FLOAT_VEC3=_C('GL_FLOAT_VEC3',0x8B51)
GL_FLOAT_VEC4=_C('GL_FLOAT_VEC4',0x8B52)
GL_INT_VEC2=_C('GL_INT_VEC2',0x8B53)
GL_INT_VEC3=_C('GL_INT_VEC3',0x8B54)
GL_INT_VEC4=_C('GL_INT_VEC4',0x8B55)
GL_BOOL=_C('GL_BOOL',0x8B56)
GL_BOOL_VEC2=_C('GL_BOOL_VEC2',0x8B57)
GL_BOOL_VEC3=_C('GL_BOOL_VEC3',0x8B58)
GL_BOOL_VEC4=_C('GL_BOOL_VEC4',0x8B59)
GL_FLOAT_MAT2=_C('GL_FLOAT_MAT2',0x8B5A)
GL_FLOAT_MAT3=_C('GL_FLOAT_MAT3',0x8B5B)
GL_FLOAT_MAT4=_C('GL_FLOAT_MAT4',0x8B5C)
GL_SAMPLER_2D=_C('GL_SAMPLER_2D',0x8B5E)
GL_SAMPLER_CUBE=_C('GL_SAMPLER_CUBE',0x8B60)
GL_VERTEX_ATTRIB_ARRAY_ENABLED=_C('GL_VERTEX_ATTRIB_ARRAY_ENABLED',0x8622)
GL_VERTEX_ATTRIB_ARRAY_SIZE=_C('GL_VERTEX_ATTRIB_ARRAY_SIZE',0x8623)
GL_VERTEX_ATTRIB_ARRAY_STRIDE=_C('GL_VERTEX_ATTRIB_ARRAY_STRIDE',0x8624)
GL_VERTEX_ATTRIB_ARRAY_TYPE=_C('GL_VERTEX_ATTRIB_ARRAY_TYPE',0x8625)
GL_VERTEX_ATTRIB_ARRAY_NORMALIZED=_C('GL_VERTEX_ATTRIB_ARRAY_NORMALIZED',0x886A)
GL_VERTEX_ATTRIB_ARRAY_POINTER=_C('GL_VERTEX_ATTRIB_ARRAY_POINTER',0x8645)
GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING=_C('GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING',0x889F)
GL_IMPLEMENTATION_COLOR_READ_TYPE=_C('GL_IMPLEMENTATION_COLOR_READ_TYPE',0x8B9A)
GL_IMPLEMENTATION_COLOR_READ_FORMAT=_C('GL_IMPLEMENTATION_COLOR_READ_FORMAT',0x8B9B)
GL_COMPILE_STATUS=_C('GL_COMPILE_STATUS',0x8B81)
GL_INFO_LOG_LENGTH=_C('GL_INFO_LOG_LENGTH',0x8B84)
GL_SHADER_SOURCE_LENGTH=_C('GL_SHADER_SOURCE_LENGTH',0x8B88)
GL_SHADER_COMPILER=_C('GL_SHADER_COMPILER',0x8DFA)
GL_SHADER_BINARY_FORMATS=_C('GL_SHADER_BINARY_FORMATS',0x8DF8)
GL_NUM_SHADER_BINARY_FORMATS=_C('GL_NUM_SHADER_BINARY_FORMATS',0x8DF9)
GL_LOW_FLOAT=_C('GL_LOW_FLOAT',0x8DF0)
GL_MEDIUM_FLOAT=_C('GL_MEDIUM_FLOAT',0x8DF1)
GL_HIGH_FLOAT=_C('GL_HIGH_FLOAT',0x8DF2)
GL_LOW_INT=_C('GL_LOW_INT',0x8DF3)
GL_MEDIUM_INT=_C('GL_MEDIUM_INT',0x8DF4)
GL_HIGH_INT=_C('GL_HIGH_INT',0x8DF5)
GL_FRAMEBUFFER=_C('GL_FRAMEBUFFER',0x8D40)
GL_RENDERBUFFER=_C('GL_RENDERBUFFER',0x8D41)
GL_RGBA4=_C('GL_RGBA4',0x8056)
GL_RGB5_A1=_C('GL_RGB5_A1',0x8057)
GL_RGB565=_C('GL_RGB565',0x8D62)
GL_DEPTH_COMPONENT16=_C('GL_DEPTH_COMPONENT16',0x81A5)
GL_STENCIL_INDEX8=_C('GL_STENCIL_INDEX8',0x8D48)
GL_RENDERBUFFER_WIDTH=_C('GL_RENDERBUFFER_WIDTH',0x8D42)
GL_RENDERBUFFER_HEIGHT=_C('GL_RENDERBUFFER_HEIGHT',0x8D43)
GL_RENDERBUFFER_INTERNAL_FORMAT=_C('GL_RENDERBUFFER_INTERNAL_FORMAT',0x8D44)
GL_RENDERBUFFER_RED_SIZE=_C('GL_RENDERBUFFER_RED_SIZE',0x8D50)
GL_RENDERBUFFER_GREEN_SIZE=_C('GL_RENDERBUFFER_GREEN_SIZE',0x8D51)
GL_RENDERBUFFER_BLUE_SIZE=_C('GL_RENDERBUFFER_BLUE_SIZE',0x8D52)
GL_RENDERBUFFER_ALPHA_SIZE=_C('GL_RENDERBUFFER_ALPHA_SIZE',0x8D53)
GL_RENDERBUFFER_DEPTH_SIZE=_C('GL_RENDERBUFFER_DEPTH_SIZE',0x8D54)
GL_RENDERBUFFER_STENCIL_SIZE=_C('GL_RENDERBUFFER_STENCIL_SIZE',0x8D55)
GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE=_C('GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE',0x8CD0)
GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME=_C('GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME',0x8CD1)
GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL=_C('GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL',0x8CD2)
GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE=_C('GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE',0x8CD3)
GL_COLOR_ATTACHMENT0=_C('GL_COLOR_ATTACHMENT0',0x8CE0)
GL_DEPTH_ATTACHMENT=_C('GL_DEPTH_ATTACHMENT',0x8D00)
GL_STENCIL_ATTACHMENT=_C('GL_STENCIL_ATTACHMENT',0x8D20)
GL_NONE=_C('GL_NONE',0)
GL_FRAMEBUFFER_COMPLETE=_C('GL_FRAMEBUFFER_COMPLETE',0x8CD5)
GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT=_C('GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT',0x8CD6)
GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT=_C('GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT',0x8CD7)
GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS=_C('GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS',0x8CD9)
GL_FRAMEBUFFER_UNSUPPORTED=_C('GL_FRAMEBUFFER_UNSUPPORTED',0x8CDD)
GL_FRAMEBUFFER_BINDING=_C('GL_FRAMEBUFFER_BINDING',0x8CA6)
GL_RENDERBUFFER_BINDING=_C('GL_RENDERBUFFER_BINDING',0x8CA7)
GL_MAX_RENDERBUFFER_SIZE=_C('GL_MAX_RENDERBUFFER_SIZE',0x84E8)
GL_INVALID_FRAMEBUFFER_OPERATION=_C('GL_INVALID_FRAMEBUFFER_OPERATION',0x0506)
GL_ETC1_RGB8_OES=_C('GL_ETC1_RGB8_OES',0x8D64)
GL_PALETTE4_RGB8_OES=_C('GL_PALETTE4_RGB8_OES',0x8B90)
GL_PALETTE4_RGBA8_OES=_C('GL_PALETTE4_RGBA8_OES',0x8B91)
GL_PALETTE4_R5_G6_B5_OES=_C('GL_PALETTE4_R5_G6_B5_OES',0x8B92)
GL_PALETTE4_RGBA4_OES=_C('GL_PALETTE4_RGBA4_OES',0x8B93)
GL_PALETTE4_RGB5_A1_OES=_C('GL_PALETTE4_RGB5_A1_OES',0x8B94)
GL_PALETTE8_RGB8_OES=_C('GL_PALETTE8_RGB8_OES',0x8B95)
GL_PALETTE8_RGBA8_OES=_C('GL_PALETTE8_RGBA8_OES',0x8B96)
GL_PALETTE8_R5_G6_B5_OES=_C('GL_PALETTE8_R5_G6_B5_OES',0x8B97)
GL_PALETTE8_RGBA4_OES=_C('GL_PALETTE8_RGBA4_OES',0x8B98)
GL_PALETTE8_RGB5_A1_OES=_C('GL_PALETTE8_RGB5_A1_OES',0x8B99)
GL_DEPTH_COMPONENT24_OES=_C('GL_DEPTH_COMPONENT24_OES',0x81A6)
GL_DEPTH_COMPONENT32_OES=_C('GL_DEPTH_COMPONENT32_OES',0x81A7)
GL_TEXTURE_EXTERNAL_OES=_C('GL_TEXTURE_EXTERNAL_OES',0x8D65)
GL_SAMPLER_EXTERNAL_OES=_C('GL_SAMPLER_EXTERNAL_OES',0x8D66)
GL_TEXTURE_BINDING_EXTERNAL_OES=_C('GL_TEXTURE_BINDING_EXTERNAL_OES',0x8D67)
GL_REQUIRED_TEXTURE_IMAGE_UNITS_OES=_C('GL_REQUIRED_TEXTURE_IMAGE_UNITS_OES',0x8D68)
GL_UNSIGNED_INT=_C('GL_UNSIGNED_INT',0x1405)
GL_PROGRAM_BINARY_LENGTH_OES=_C('GL_PROGRAM_BINARY_LENGTH_OES',0x8741)
GL_NUM_PROGRAM_BINARY_FORMATS_OES=_C('GL_NUM_PROGRAM_BINARY_FORMATS_OES',0x87FE)
GL_PROGRAM_BINARY_FORMATS_OES=_C('GL_PROGRAM_BINARY_FORMATS_OES',0x87FF)
GL_WRITE_ONLY_OES=_C('GL_WRITE_ONLY_OES',0x88B9)
GL_BUFFER_ACCESS_OES=_C('GL_BUFFER_ACCESS_OES',0x88BB)
GL_BUFFER_MAPPED_OES=_C('GL_BUFFER_MAPPED_OES',0x88BC)
GL_BUFFER_MAP_POINTER_OES=_C('GL_BUFFER_MAP_POINTER_OES',0x88BD)
GL_DEPTH_STENCIL_OES=_C('GL_DEPTH_STENCIL_OES',0x84F9)
GL_UNSIGNED_INT_24_8_OES=_C('GL_UNSIGNED_INT_24_8_OES',0x84FA)
GL_DEPTH24_STENCIL8_OES=_C('GL_DEPTH24_STENCIL8_OES',0x88F0)
GL_ALPHA8_OES=_C('GL_ALPHA8_OES',0x803C)
GL_DEPTH_COMPONENT16_OES=_C('GL_DEPTH_COMPONENT16_OES',0x81A5)
GL_LUMINANCE4_ALPHA4_OES=_C('GL_LUMINANCE4_ALPHA4_OES',0x8043)
GL_LUMINANCE8_ALPHA8_OES=_C('GL_LUMINANCE8_ALPHA8_OES',0x8045)
GL_LUMINANCE8_OES=_C('GL_LUMINANCE8_OES',0x8040)
GL_RGBA4_OES=_C('GL_RGBA4_OES',0x8056)
GL_RGB5_A1_OES=_C('GL_RGB5_A1_OES',0x8057)
GL_RGB565_OES=_C('GL_RGB565_OES',0x8D62)
GL_RGB8_OES=_C('GL_RGB8_OES',0x8051)
GL_RGBA8_OES=_C('GL_RGBA8_OES',0x8058)
GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES=_C('GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES',0x8B8B)
GL_STENCIL_INDEX1_OES=_C('GL_STENCIL_INDEX1_OES',0x8D46)
GL_STENCIL_INDEX4_OES=_C('GL_STENCIL_INDEX4_OES',0x8D47)
GL_FRAMEBUFFER_UNDEFINED_OES=_C('GL_FRAMEBUFFER_UNDEFINED_OES',0x8219)
GL_TEXTURE_WRAP_R_OES=_C('GL_TEXTURE_WRAP_R_OES',0x8072)
GL_TEXTURE_3D_OES=_C('GL_TEXTURE_3D_OES',0x806F)
GL_TEXTURE_BINDING_3D_OES=_C('GL_TEXTURE_BINDING_3D_OES',0x806A)
GL_MAX_3D_TEXTURE_SIZE_OES=_C('GL_MAX_3D_TEXTURE_SIZE_OES',0x8073)
GL_SAMPLER_3D_OES=_C('GL_SAMPLER_3D_OES',0x8B5F)
GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES=_C('GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES',0x8CD4)
GL_HALF_FLOAT_OES=_C('GL_HALF_FLOAT_OES',0x8D61)
GL_VERTEX_ARRAY_BINDING_OES=_C('GL_VERTEX_ARRAY_BINDING_OES',0x85B5)
GL_UNSIGNED_INT_10_10_10_2_OES=_C('GL_UNSIGNED_INT_10_10_10_2_OES',0x8DF6)
GL_INT_10_10_10_2_OES=_C('GL_INT_10_10_10_2_OES',0x8DF7)
GL_DEBUG_OUTPUT_SYNCHRONOUS=_C('GL_DEBUG_OUTPUT_SYNCHRONOUS',0x8242)
GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH=_C('GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH',0x8243)
GL_DEBUG_CALLBACK_FUNCTION=_C('GL_DEBUG_CALLBACK_FUNCTION',0x8244)
GL_DEBUG_CALLBACK_USER_PARAM=_C('GL_DEBUG_CALLBACK_USER_PARAM',0x8245)
GL_DEBUG_SOURCE_API=_C('GL_DEBUG_SOURCE_API',0x8246)
GL_DEBUG_SOURCE_WINDOW_SYSTEM=_C('GL_DEBUG_SOURCE_WINDOW_SYSTEM',0x8247)
GL_DEBUG_SOURCE_SHADER_COMPILER=_C('GL_DEBUG_SOURCE_SHADER_COMPILER',0x8248)
GL_DEBUG_SOURCE_THIRD_PARTY=_C('GL_DEBUG_SOURCE_THIRD_PARTY',0x8249)
GL_DEBUG_SOURCE_APPLICATION=_C('GL_DEBUG_SOURCE_APPLICATION',0x824A)
GL_DEBUG_SOURCE_OTHER=_C('GL_DEBUG_SOURCE_OTHER',0x824B)
GL_DEBUG_TYPE_ERROR=_C('GL_DEBUG_TYPE_ERROR',0x824C)
GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR=_C('GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR',0x824D)
GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR=_C('GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR',0x824E)
GL_DEBUG_TYPE_PORTABILITY=_C('GL_DEBUG_TYPE_PORTABILITY',0x824F)
GL_DEBUG_TYPE_PERFORMANCE=_C('GL_DEBUG_TYPE_PERFORMANCE',0x8250)
GL_DEBUG_TYPE_OTHER=_C('GL_DEBUG_TYPE_OTHER',0x8251)
GL_DEBUG_TYPE_MARKER=_C('GL_DEBUG_TYPE_MARKER',0x8268)
GL_DEBUG_TYPE_PUSH_GROUP=_C('GL_DEBUG_TYPE_PUSH_GROUP',0x8269)
GL_DEBUG_TYPE_POP_GROUP=_C('GL_DEBUG_TYPE_POP_GROUP',0x826A)
GL_DEBUG_SEVERITY_NOTIFICATION=_C('GL_DEBUG_SEVERITY_NOTIFICATION',0x826B)
GL_MAX_DEBUG_GROUP_STACK_DEPTH=_C('GL_MAX_DEBUG_GROUP_STACK_DEPTH',0x826C)
GL_DEBUG_GROUP_STACK_DEPTH=_C('GL_DEBUG_GROUP_STACK_DEPTH',0x826D)
GL_BUFFER=_C('GL_BUFFER',0x82E0)
GL_SHADER=_C('GL_SHADER',0x82E1)
GL_PROGRAM=_C('GL_PROGRAM',0x82E2)
GL_QUERY=_C('GL_QUERY',0x82E3)
GL_SAMPLER=_C('GL_SAMPLER',0x82E6)
GL_MAX_LABEL_LENGTH=_C('GL_MAX_LABEL_LENGTH',0x82E8)
GL_MAX_DEBUG_MESSAGE_LENGTH=_C('GL_MAX_DEBUG_MESSAGE_LENGTH',0x9143)
GL_MAX_DEBUG_LOGGED_MESSAGES=_C('GL_MAX_DEBUG_LOGGED_MESSAGES',0x9144)
GL_DEBUG_LOGGED_MESSAGES=_C('GL_DEBUG_LOGGED_MESSAGES',0x9145)
GL_DEBUG_SEVERITY_HIGH=_C('GL_DEBUG_SEVERITY_HIGH',0x9146)
GL_DEBUG_SEVERITY_MEDIUM=_C('GL_DEBUG_SEVERITY_MEDIUM',0x9147)
GL_DEBUG_SEVERITY_LOW=_C('GL_DEBUG_SEVERITY_LOW',0x9148)
GL_DEBUG_OUTPUT=_C('GL_DEBUG_OUTPUT',0x92E0)
GL_CONTEXT_FLAG_DEBUG_BIT=_C('GL_CONTEXT_FLAG_DEBUG_BIT',0x00000002)
GL_STACK_OVERFLOW=_C('GL_STACK_OVERFLOW',0x0503)
GL_STACK_UNDERFLOW=_C('GL_STACK_UNDERFLOW',0x0504)
GL_COMPRESSED_RGBA_ASTC_4x4_KHR=_C('GL_COMPRESSED_RGBA_ASTC_4x4_KHR',0x93B0)
GL_COMPRESSED_RGBA_ASTC_5x4_KHR=_C('GL_COMPRESSED_RGBA_ASTC_5x4_KHR',0x93B1)
GL_COMPRESSED_RGBA_ASTC_5x5_KHR=_C('GL_COMPRESSED_RGBA_ASTC_5x5_KHR',0x93B2)
GL_COMPRESSED_RGBA_ASTC_6x5_KHR=_C('GL_COMPRESSED_RGBA_ASTC_6x5_KHR',0x93B3)
GL_COMPRESSED_RGBA_ASTC_6x6_KHR=_C('GL_COMPRESSED_RGBA_ASTC_6x6_KHR',0x93B4)
GL_COMPRESSED_RGBA_ASTC_8x5_KHR=_C('GL_COMPRESSED_RGBA_ASTC_8x5_KHR',0x93B5)
GL_COMPRESSED_RGBA_ASTC_8x6_KHR=_C('GL_COMPRESSED_RGBA_ASTC_8x6_KHR',0x93B6)
GL_COMPRESSED_RGBA_ASTC_8x8_KHR=_C('GL_COMPRESSED_RGBA_ASTC_8x8_KHR',0x93B7)
GL_COMPRESSED_RGBA_ASTC_10x5_KHR=_C('GL_COMPRESSED_RGBA_ASTC_10x5_KHR',0x93B8)
GL_COMPRESSED_RGBA_ASTC_10x6_KHR=_C('GL_COMPRESSED_RGBA_ASTC_10x6_KHR',0x93B9)
GL_COMPRESSED_RGBA_ASTC_10x8_KHR=_C('GL_COMPRESSED_RGBA_ASTC_10x8_KHR',0x93BA)
GL_COMPRESSED_RGBA_ASTC_10x10_KHR=_C('GL_COMPRESSED_RGBA_ASTC_10x10_KHR',0x93BB)
GL_COMPRESSED_RGBA_ASTC_12x10_KHR=_C('GL_COMPRESSED_RGBA_ASTC_12x10_KHR',0x93BC)
GL_COMPRESSED_RGBA_ASTC_12x12_KHR=_C('GL_COMPRESSED_RGBA_ASTC_12x12_KHR',0x93BD)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR',0x93D0)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR',0x93D1)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR',0x93D2)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR',0x93D3)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR',0x93D4)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR',0x93D5)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR',0x93D6)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR',0x93D7)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR',0x93D8)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR',0x93D9)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR',0x93DA)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR',0x93DB)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR',0x93DC)
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR=_C('GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR',0x93DD)
GL_3DC_X_AMD=_C('GL_3DC_X_AMD',0x87F9)
GL_3DC_XY_AMD=_C('GL_3DC_XY_AMD',0x87FA)
GL_ATC_RGB_AMD=_C('GL_ATC_RGB_AMD',0x8C92)
GL_ATC_RGBA_EXPLICIT_ALPHA_AMD=_C('GL_ATC_RGBA_EXPLICIT_ALPHA_AMD',0x8C93)
GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD=_C('GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD',0x87EE)
GL_COUNTER_TYPE_AMD=_C('GL_COUNTER_TYPE_AMD',0x8BC0)
GL_COUNTER_RANGE_AMD=_C('GL_COUNTER_RANGE_AMD',0x8BC1)
GL_UNSIGNED_INT64_AMD=_C('GL_UNSIGNED_INT64_AMD',0x8BC2)
GL_PERCENTAGE_AMD=_C('GL_PERCENTAGE_AMD',0x8BC3)
GL_PERFMON_RESULT_AVAILABLE_AMD=_C('GL_PERFMON_RESULT_AVAILABLE_AMD',0x8BC4)
GL_PERFMON_RESULT_SIZE_AMD=_C('GL_PERFMON_RESULT_SIZE_AMD',0x8BC5)
GL_PERFMON_RESULT_AMD=_C('GL_PERFMON_RESULT_AMD',0x8BC6)
GL_Z400_BINARY_AMD=_C('GL_Z400_BINARY_AMD',0x8740)
GL_DEPTH_COMPONENT=_C('GL_DEPTH_COMPONENT',0x1902)
GL_DEPTH_STENCIL_OES=_C('GL_DEPTH_STENCIL_OES',0x84F9)
GL_UNSIGNED_SHORT=_C('GL_UNSIGNED_SHORT',0x1403)
GL_UNSIGNED_INT=_C('GL_UNSIGNED_INT',0x1405)
GL_UNSIGNED_INT_24_8_OES=_C('GL_UNSIGNED_INT_24_8_OES',0x84FA)
GL_DEPTH_COMPONENT16=_C('GL_DEPTH_COMPONENT16',0x81A5)
GL_DEPTH_COMPONENT32_OES=_C('GL_DEPTH_COMPONENT32_OES',0x81A7)
GL_DEPTH24_STENCIL8_OES=_C('GL_DEPTH24_STENCIL8_OES',0x88F0)
GL_READ_FRAMEBUFFER_ANGLE=_C('GL_READ_FRAMEBUFFER_ANGLE',0x8CA8)
GL_DRAW_FRAMEBUFFER_ANGLE=_C('GL_DRAW_FRAMEBUFFER_ANGLE',0x8CA9)
GL_DRAW_FRAMEBUFFER_BINDING_ANGLE=_C('GL_DRAW_FRAMEBUFFER_BINDING_ANGLE',0x8CA6)
GL_READ_FRAMEBUFFER_BINDING_ANGLE=_C('GL_READ_FRAMEBUFFER_BINDING_ANGLE',0x8CAA)
GL_RENDERBUFFER_SAMPLES_ANGLE=_C('GL_RENDERBUFFER_SAMPLES_ANGLE',0x8CAB)
GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE=_C('GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE',0x8D56)
GL_MAX_SAMPLES_ANGLE=_C('GL_MAX_SAMPLES_ANGLE',0x8D57)
GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE=_C('GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE',0x88FE)
GL_PACK_REVERSE_ROW_ORDER_ANGLE=_C('GL_PACK_REVERSE_ROW_ORDER_ANGLE',0x93A4)
GL_PROGRAM_BINARY_ANGLE=_C('GL_PROGRAM_BINARY_ANGLE',0x93A6)
GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE=_C('GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE',0x83F2)
GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE=_C('GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE',0x83F3)
GL_TEXTURE_USAGE_ANGLE=_C('GL_TEXTURE_USAGE_ANGLE',0x93A2)
GL_FRAMEBUFFER_ATTACHMENT_ANGLE=_C('GL_FRAMEBUFFER_ATTACHMENT_ANGLE',0x93A3)
GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE=_C('GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE',0x93A0)
GL_RENDERBUFFER_SAMPLES_APPLE=_C('GL_RENDERBUFFER_SAMPLES_APPLE',0x8CAB)
GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE=_C('GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE',0x8D56)
GL_MAX_SAMPLES_APPLE=_C('GL_MAX_SAMPLES_APPLE',0x8D57)
GL_READ_FRAMEBUFFER_APPLE=_C('GL_READ_FRAMEBUFFER_APPLE',0x8CA8)
GL_DRAW_FRAMEBUFFER_APPLE=_C('GL_DRAW_FRAMEBUFFER_APPLE',0x8CA9)
GL_DRAW_FRAMEBUFFER_BINDING_APPLE=_C('GL_DRAW_FRAMEBUFFER_BINDING_APPLE',0x8CA6)
GL_READ_FRAMEBUFFER_BINDING_APPLE=_C('GL_READ_FRAMEBUFFER_BINDING_APPLE',0x8CAA)
GL_RGB_422_APPLE=_C('GL_RGB_422_APPLE',0x8A1F)
GL_UNSIGNED_SHORT_8_8_APPLE=_C('GL_UNSIGNED_SHORT_8_8_APPLE',0x85BA)
GL_UNSIGNED_SHORT_8_8_REV_APPLE=_C('GL_UNSIGNED_SHORT_8_8_REV_APPLE',0x85BB)
GL_SYNC_OBJECT_APPLE=_C('GL_SYNC_OBJECT_APPLE',0x8A53)
GL_MAX_SERVER_WAIT_TIMEOUT_APPLE=_C('GL_MAX_SERVER_WAIT_TIMEOUT_APPLE',0x9111)
GL_OBJECT_TYPE_APPLE=_C('GL_OBJECT_TYPE_APPLE',0x9112)
GL_SYNC_CONDITION_APPLE=_C('GL_SYNC_CONDITION_APPLE',0x9113)
GL_SYNC_STATUS_APPLE=_C('GL_SYNC_STATUS_APPLE',0x9114)
GL_SYNC_FLAGS_APPLE=_C('GL_SYNC_FLAGS_APPLE',0x9115)
GL_SYNC_FENCE_APPLE=_C('GL_SYNC_FENCE_APPLE',0x9116)
GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE=_C('GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE',0x9117)
GL_UNSIGNALED_APPLE=_C('GL_UNSIGNALED_APPLE',0x9118)
GL_SIGNALED_APPLE=_C('GL_SIGNALED_APPLE',0x9119)
GL_ALREADY_SIGNALED_APPLE=_C('GL_ALREADY_SIGNALED_APPLE',0x911A)
GL_TIMEOUT_EXPIRED_APPLE=_C('GL_TIMEOUT_EXPIRED_APPLE',0x911B)
GL_CONDITION_SATISFIED_APPLE=_C('GL_CONDITION_SATISFIED_APPLE',0x911C)
GL_WAIT_FAILED_APPLE=_C('GL_WAIT_FAILED_APPLE',0x911D)
GL_SYNC_FLUSH_COMMANDS_BIT_APPLE=_C('GL_SYNC_FLUSH_COMMANDS_BIT_APPLE',0x00000001)
GL_TIMEOUT_IGNORED_APPLE=_C('GL_TIMEOUT_IGNORED_APPLE',0xFFFFFFFFFFFFFFFF)
GL_BGRA_EXT=_C('GL_BGRA_EXT',0x80E1)
GL_TEXTURE_MAX_LEVEL_APPLE=_C('GL_TEXTURE_MAX_LEVEL_APPLE',0x813D)
GL_MALI_PROGRAM_BINARY_ARM=_C('GL_MALI_PROGRAM_BINARY_ARM',0x8F61)
GL_MALI_SHADER_BINARY_ARM=_C('GL_MALI_SHADER_BINARY_ARM',0x8F60)
GL_MIN_EXT=_C('GL_MIN_EXT',0x8007)
GL_MAX_EXT=_C('GL_MAX_EXT',0x8008)
GL_RGBA16F_EXT=_C('GL_RGBA16F_EXT',0x881A)
GL_RGB16F_EXT=_C('GL_RGB16F_EXT',0x881B)
GL_RG16F_EXT=_C('GL_RG16F_EXT',0x822F)
GL_R16F_EXT=_C('GL_R16F_EXT',0x822D)
GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT=_C('GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT',0x8211)
GL_UNSIGNED_NORMALIZED_EXT=_C('GL_UNSIGNED_NORMALIZED_EXT',0x8C17)
GL_PROGRAM_PIPELINE_OBJECT_EXT=_C('GL_PROGRAM_PIPELINE_OBJECT_EXT',0x8A4F)
GL_PROGRAM_OBJECT_EXT=_C('GL_PROGRAM_OBJECT_EXT',0x8B40)
GL_SHADER_OBJECT_EXT=_C('GL_SHADER_OBJECT_EXT',0x8B48)
GL_BUFFER_OBJECT_EXT=_C('GL_BUFFER_OBJECT_EXT',0x9151)
GL_QUERY_OBJECT_EXT=_C('GL_QUERY_OBJECT_EXT',0x9153)
GL_VERTEX_ARRAY_OBJECT_EXT=_C('GL_VERTEX_ARRAY_OBJECT_EXT',0x9154)
GL_COLOR_EXT=_C('GL_COLOR_EXT',0x1800)
GL_DEPTH_EXT=_C('GL_DEPTH_EXT',0x1801)
GL_STENCIL_EXT=_C('GL_STENCIL_EXT',0x1802)
GL_MAP_READ_BIT_EXT=_C('GL_MAP_READ_BIT_EXT',0x0001)
GL_MAP_WRITE_BIT_EXT=_C('GL_MAP_WRITE_BIT_EXT',0x0002)
GL_MAP_INVALIDATE_RANGE_BIT_EXT=_C('GL_MAP_INVALIDATE_RANGE_BIT_EXT',0x0004)
GL_MAP_INVALIDATE_BUFFER_BIT_EXT=_C('GL_MAP_INVALIDATE_BUFFER_BIT_EXT',0x0008)
GL_MAP_FLUSH_EXPLICIT_BIT_EXT=_C('GL_MAP_FLUSH_EXPLICIT_BIT_EXT',0x0010)
GL_MAP_UNSYNCHRONIZED_BIT_EXT=_C('GL_MAP_UNSYNCHRONIZED_BIT_EXT',0x0020)
GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT=_C('GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT',0x8D6C)
GL_RENDERBUFFER_SAMPLES_EXT=_C('GL_RENDERBUFFER_SAMPLES_EXT',0x8CAB)
GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT=_C('GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT',0x8D56)
GL_MAX_SAMPLES_EXT=_C('GL_MAX_SAMPLES_EXT',0x8D57)
GL_COLOR_ATTACHMENT_EXT=_C('GL_COLOR_ATTACHMENT_EXT',0x90F0)
GL_MULTIVIEW_EXT=_C('GL_MULTIVIEW_EXT',0x90F1)
GL_DRAW_BUFFER_EXT=_C('GL_DRAW_BUFFER_EXT',0x0C01)
GL_READ_BUFFER_EXT=_C('GL_READ_BUFFER_EXT',0x0C02)
GL_MAX_MULTIVIEW_BUFFERS_EXT=_C('GL_MAX_MULTIVIEW_BUFFERS_EXT',0x90F2)
GL_ANY_SAMPLES_PASSED_EXT=_C('GL_ANY_SAMPLES_PASSED_EXT',0x8C2F)
GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT=_C('GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT',0x8D6A)
GL_CURRENT_QUERY_EXT=_C('GL_CURRENT_QUERY_EXT',0x8865)
GL_QUERY_RESULT_EXT=_C('GL_QUERY_RESULT_EXT',0x8866)
GL_QUERY_RESULT_AVAILABLE_EXT=_C('GL_QUERY_RESULT_AVAILABLE_EXT',0x8867)
GL_BGRA_EXT=_C('GL_BGRA_EXT',0x80E1)
GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT=_C('GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT',0x8365)
GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT=_C('GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT',0x8366)
GL_GUILTY_CONTEXT_RESET_EXT=_C('GL_GUILTY_CONTEXT_RESET_EXT',0x8253)
GL_INNOCENT_CONTEXT_RESET_EXT=_C('GL_INNOCENT_CONTEXT_RESET_EXT',0x8254)
GL_UNKNOWN_CONTEXT_RESET_EXT=_C('GL_UNKNOWN_CONTEXT_RESET_EXT',0x8255)
GL_CONTEXT_ROBUST_ACCESS_EXT=_C('GL_CONTEXT_ROBUST_ACCESS_EXT',0x90F3)
GL_RESET_NOTIFICATION_STRATEGY_EXT=_C('GL_RESET_NOTIFICATION_STRATEGY_EXT',0x8256)
GL_LOSE_CONTEXT_ON_RESET_EXT=_C('GL_LOSE_CONTEXT_ON_RESET_EXT',0x8252)
GL_NO_RESET_NOTIFICATION_EXT=_C('GL_NO_RESET_NOTIFICATION_EXT',0x8261)
GL_VERTEX_SHADER_BIT_EXT=_C('GL_VERTEX_SHADER_BIT_EXT',0x00000001)
GL_FRAGMENT_SHADER_BIT_EXT=_C('GL_FRAGMENT_SHADER_BIT_EXT',0x00000002)
GL_ALL_SHADER_BITS_EXT=_C('GL_ALL_SHADER_BITS_EXT',0xFFFFFFFF)
GL_PROGRAM_SEPARABLE_EXT=_C('GL_PROGRAM_SEPARABLE_EXT',0x8258)
GL_ACTIVE_PROGRAM_EXT=_C('GL_ACTIVE_PROGRAM_EXT',0x8259)
GL_PROGRAM_PIPELINE_BINDING_EXT=_C('GL_PROGRAM_PIPELINE_BINDING_EXT',0x825A)
GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT=_C('GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT',0x8A52)
GL_TEXTURE_COMPARE_MODE_EXT=_C('GL_TEXTURE_COMPARE_MODE_EXT',0x884C)
GL_TEXTURE_COMPARE_FUNC_EXT=_C('GL_TEXTURE_COMPARE_FUNC_EXT',0x884D)
GL_COMPARE_REF_TO_TEXTURE_EXT=_C('GL_COMPARE_REF_TO_TEXTURE_EXT',0x884E)
GL_SAMPLER_2D_SHADOW_EXT=_C('GL_SAMPLER_2D_SHADOW_EXT',0x8B62)
GL_SRGB_EXT=_C('GL_SRGB_EXT',0x8C40)
GL_SRGB_ALPHA_EXT=_C('GL_SRGB_ALPHA_EXT',0x8C42)
GL_SRGB8_ALPHA8_EXT=_C('GL_SRGB8_ALPHA8_EXT',0x8C43)
GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT=_C('GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT',0x8210)
GL_COMPRESSED_RGB_S3TC_DXT1_EXT=_C('GL_COMPRESSED_RGB_S3TC_DXT1_EXT',0x83F0)
GL_COMPRESSED_RGBA_S3TC_DXT1_EXT=_C('GL_COMPRESSED_RGBA_S3TC_DXT1_EXT',0x83F1)
GL_TEXTURE_MAX_ANISOTROPY_EXT=_C('GL_TEXTURE_MAX_ANISOTROPY_EXT',0x84FE)
GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT=_C('GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT',0x84FF)
GL_BGRA_EXT=_C('GL_BGRA_EXT',0x80E1)
GL_RED_EXT=_C('GL_RED_EXT',0x1903)
GL_RG_EXT=_C('GL_RG_EXT',0x8227)
GL_R8_EXT=_C('GL_R8_EXT',0x8229)
GL_RG8_EXT=_C('GL_RG8_EXT',0x822B)
GL_TEXTURE_IMMUTABLE_FORMAT_EXT=_C('GL_TEXTURE_IMMUTABLE_FORMAT_EXT',0x912F)
GL_ALPHA8_EXT=_C('GL_ALPHA8_EXT',0x803C)
GL_LUMINANCE8_EXT=_C('GL_LUMINANCE8_EXT',0x8040)
GL_LUMINANCE8_ALPHA8_EXT=_C('GL_LUMINANCE8_ALPHA8_EXT',0x8045)
GL_RGBA32F_EXT=_C('GL_RGBA32F_EXT',0x8814)
GL_RGB32F_EXT=_C('GL_RGB32F_EXT',0x8815)
GL_ALPHA32F_EXT=_C('GL_ALPHA32F_EXT',0x8816)
GL_LUMINANCE32F_EXT=_C('GL_LUMINANCE32F_EXT',0x8818)
GL_LUMINANCE_ALPHA32F_EXT=_C('GL_LUMINANCE_ALPHA32F_EXT',0x8819)
GL_ALPHA16F_EXT=_C('GL_ALPHA16F_EXT',0x881C)
GL_LUMINANCE16F_EXT=_C('GL_LUMINANCE16F_EXT',0x881E)
GL_LUMINANCE_ALPHA16F_EXT=_C('GL_LUMINANCE_ALPHA16F_EXT',0x881F)
GL_RGB10_A2_EXT=_C('GL_RGB10_A2_EXT',0x8059)
GL_RGB10_EXT=_C('GL_RGB10_EXT',0x8052)
GL_BGRA8_EXT=_C('GL_BGRA8_EXT',0x93A1)
GL_R8_EXT=_C('GL_R8_EXT',0x8229)
GL_RG8_EXT=_C('GL_RG8_EXT',0x822B)
GL_R32F_EXT=_C('GL_R32F_EXT',0x822E)
GL_RG32F_EXT=_C('GL_RG32F_EXT',0x8230)
GL_R16F_EXT=_C('GL_R16F_EXT',0x822D)
GL_RG16F_EXT=_C('GL_RG16F_EXT',0x822F)
GL_UNSIGNED_INT_2_10_10_10_REV_EXT=_C('GL_UNSIGNED_INT_2_10_10_10_REV_EXT',0x8368)
GL_UNPACK_ROW_LENGTH_EXT=_C('GL_UNPACK_ROW_LENGTH_EXT',0x0CF2)
GL_UNPACK_SKIP_ROWS_EXT=_C('GL_UNPACK_SKIP_ROWS_EXT',0x0CF3)
GL_UNPACK_SKIP_PIXELS_EXT=_C('GL_UNPACK_SKIP_PIXELS_EXT',0x0CF4)
GL_SHADER_BINARY_DMP=_C('GL_SHADER_BINARY_DMP',0x9250)
GL_GCCSO_SHADER_BINARY_FJ=_C('GL_GCCSO_SHADER_BINARY_FJ',0x9260)
GL_SGX_PROGRAM_BINARY_IMG=_C('GL_SGX_PROGRAM_BINARY_IMG',0x9130)
GL_BGRA_IMG=_C('GL_BGRA_IMG',0x80E1)
GL_UNSIGNED_SHORT_4_4_4_4_REV_IMG=_C('GL_UNSIGNED_SHORT_4_4_4_4_REV_IMG',0x8365)
GL_SGX_BINARY_IMG=_C('GL_SGX_BINARY_IMG',0x8C0A)
GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG=_C('GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG',0x8C00)
GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG=_C('GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG',0x8C01)
GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG=_C('GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG',0x8C02)
GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG=_C('GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG',0x8C03)
GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG=_C('GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG',0x9137)
GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG=_C('GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG',0x9138)
GL_RENDERBUFFER_SAMPLES_IMG=_C('GL_RENDERBUFFER_SAMPLES_IMG',0x9133)
GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG=_C('GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG',0x9134)
GL_MAX_SAMPLES_IMG=_C('GL_MAX_SAMPLES_IMG',0x9135)
GL_TEXTURE_SAMPLES_IMG=_C('GL_TEXTURE_SAMPLES_IMG',0x9136)
GL_COVERAGE_COMPONENT_NV=_C('GL_COVERAGE_COMPONENT_NV',0x8ED0)
GL_COVERAGE_COMPONENT4_NV=_C('GL_COVERAGE_COMPONENT4_NV',0x8ED1)
GL_COVERAGE_ATTACHMENT_NV=_C('GL_COVERAGE_ATTACHMENT_NV',0x8ED2)
GL_COVERAGE_BUFFERS_NV=_C('GL_COVERAGE_BUFFERS_NV',0x8ED3)
GL_COVERAGE_SAMPLES_NV=_C('GL_COVERAGE_SAMPLES_NV',0x8ED4)
GL_COVERAGE_ALL_FRAGMENTS_NV=_C('GL_COVERAGE_ALL_FRAGMENTS_NV',0x8ED5)
GL_COVERAGE_EDGE_FRAGMENTS_NV=_C('GL_COVERAGE_EDGE_FRAGMENTS_NV',0x8ED6)
GL_COVERAGE_AUTOMATIC_NV=_C('GL_COVERAGE_AUTOMATIC_NV',0x8ED7)
GL_COVERAGE_BUFFER_BIT_NV=_C('GL_COVERAGE_BUFFER_BIT_NV',0x00008000)
GL_DEPTH_COMPONENT16_NONLINEAR_NV=_C('GL_DEPTH_COMPONENT16_NONLINEAR_NV',0x8E2C)
GL_MAX_DRAW_BUFFERS_NV=_C('GL_MAX_DRAW_BUFFERS_NV',0x8824)
GL_DRAW_BUFFER0_NV=_C('GL_DRAW_BUFFER0_NV',0x8825)
GL_DRAW_BUFFER1_NV=_C('GL_DRAW_BUFFER1_NV',0x8826)
GL_DRAW_BUFFER2_NV=_C('GL_DRAW_BUFFER2_NV',0x8827)
GL_DRAW_BUFFER3_NV=_C('GL_DRAW_BUFFER3_NV',0x8828)
GL_DRAW_BUFFER4_NV=_C('GL_DRAW_BUFFER4_NV',0x8829)
GL_DRAW_BUFFER5_NV=_C('GL_DRAW_BUFFER5_NV',0x882A)
GL_DRAW_BUFFER6_NV=_C('GL_DRAW_BUFFER6_NV',0x882B)
GL_DRAW_BUFFER7_NV=_C('GL_DRAW_BUFFER7_NV',0x882C)
GL_DRAW_BUFFER8_NV=_C('GL_DRAW_BUFFER8_NV',0x882D)
GL_DRAW_BUFFER9_NV=_C('GL_DRAW_BUFFER9_NV',0x882E)
GL_DRAW_BUFFER10_NV=_C('GL_DRAW_BUFFER10_NV',0x882F)
GL_DRAW_BUFFER11_NV=_C('GL_DRAW_BUFFER11_NV',0x8830)
GL_DRAW_BUFFER12_NV=_C('GL_DRAW_BUFFER12_NV',0x8831)
GL_DRAW_BUFFER13_NV=_C('GL_DRAW_BUFFER13_NV',0x8832)
GL_DRAW_BUFFER14_NV=_C('GL_DRAW_BUFFER14_NV',0x8833)
GL_DRAW_BUFFER15_NV=_C('GL_DRAW_BUFFER15_NV',0x8834)
GL_COLOR_ATTACHMENT0_NV=_C('GL_COLOR_ATTACHMENT0_NV',0x8CE0)
GL_COLOR_ATTACHMENT1_NV=_C('GL_COLOR_ATTACHMENT1_NV',0x8CE1)
GL_COLOR_ATTACHMENT2_NV=_C('GL_COLOR_ATTACHMENT2_NV',0x8CE2)
GL_COLOR_ATTACHMENT3_NV=_C('GL_COLOR_ATTACHMENT3_NV',0x8CE3)
GL_COLOR_ATTACHMENT4_NV=_C('GL_COLOR_ATTACHMENT4_NV',0x8CE4)
GL_COLOR_ATTACHMENT5_NV=_C('GL_COLOR_ATTACHMENT5_NV',0x8CE5)
GL_COLOR_ATTACHMENT6_NV=_C('GL_COLOR_ATTACHMENT6_NV',0x8CE6)
GL_COLOR_ATTACHMENT7_NV=_C('GL_COLOR_ATTACHMENT7_NV',0x8CE7)
GL_COLOR_ATTACHMENT8_NV=_C('GL_COLOR_ATTACHMENT8_NV',0x8CE8)
GL_COLOR_ATTACHMENT9_NV=_C('GL_COLOR_ATTACHMENT9_NV',0x8CE9)
GL_COLOR_ATTACHMENT10_NV=_C('GL_COLOR_ATTACHMENT10_NV',0x8CEA)
GL_COLOR_ATTACHMENT11_NV=_C('GL_COLOR_ATTACHMENT11_NV',0x8CEB)
GL_COLOR_ATTACHMENT12_NV=_C('GL_COLOR_ATTACHMENT12_NV',0x8CEC)
GL_COLOR_ATTACHMENT13_NV=_C('GL_COLOR_ATTACHMENT13_NV',0x8CED)
GL_COLOR_ATTACHMENT14_NV=_C('GL_COLOR_ATTACHMENT14_NV',0x8CEE)
GL_COLOR_ATTACHMENT15_NV=_C('GL_COLOR_ATTACHMENT15_NV',0x8CEF)
GL_MAX_COLOR_ATTACHMENTS_NV=_C('GL_MAX_COLOR_ATTACHMENTS_NV',0x8CDF)
GL_ALL_COMPLETED_NV=_C('GL_ALL_COMPLETED_NV',0x84F2)
GL_FENCE_STATUS_NV=_C('GL_FENCE_STATUS_NV',0x84F3)
GL_FENCE_CONDITION_NV=_C('GL_FENCE_CONDITION_NV',0x84F4)
GL_READ_FRAMEBUFFER_NV=_C('GL_READ_FRAMEBUFFER_NV',0x8CA8)
GL_DRAW_FRAMEBUFFER_NV=_C('GL_DRAW_FRAMEBUFFER_NV',0x8CA9)
GL_DRAW_FRAMEBUFFER_BINDING_NV=_C('GL_DRAW_FRAMEBUFFER_BINDING_NV',0x8CA6)
GL_READ_FRAMEBUFFER_BINDING_NV=_C('GL_READ_FRAMEBUFFER_BINDING_NV',0x8CAA)
GL_RENDERBUFFER_SAMPLES_NV=_C('GL_RENDERBUFFER_SAMPLES_NV',0x8CAB)
GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV=_C('GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV',0x8D56)
GL_MAX_SAMPLES_NV=_C('GL_MAX_SAMPLES_NV',0x8D57)
GL_VERTEX_ATTRIB_ARRAY_DIVISOR_NV=_C('GL_VERTEX_ATTRIB_ARRAY_DIVISOR_NV',0x88FE)
GL_READ_BUFFER_NV=_C('GL_READ_BUFFER_NV',0x0C02)
GL_SAMPLER_2D_ARRAY_SHADOW_NV=_C('GL_SAMPLER_2D_ARRAY_SHADOW_NV',0x8DC4)
GL_SAMPLER_CUBE_SHADOW_NV=_C('GL_SAMPLER_CUBE_SHADOW_NV',0x8DC5)
GL_SLUMINANCE_NV=_C('GL_SLUMINANCE_NV',0x8C46)
GL_SLUMINANCE_ALPHA_NV=_C('GL_SLUMINANCE_ALPHA_NV',0x8C44)
GL_SRGB8_NV=_C('GL_SRGB8_NV',0x8C41)
GL_SLUMINANCE8_NV=_C('GL_SLUMINANCE8_NV',0x8C47)
GL_SLUMINANCE8_ALPHA8_NV=_C('GL_SLUMINANCE8_ALPHA8_NV',0x8C45)
GL_COMPRESSED_SRGB_S3TC_DXT1_NV=_C('GL_COMPRESSED_SRGB_S3TC_DXT1_NV',0x8C4C)
GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV=_C('GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV',0x8C4D)
GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV=_C('GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV',0x8C4E)
GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV=_C('GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV',0x8C4F)
GL_ETC1_SRGB8_NV=_C('GL_ETC1_SRGB8_NV',0x88EE)
GL_TEXTURE_BORDER_COLOR_NV=_C('GL_TEXTURE_BORDER_COLOR_NV',0x1004)
GL_CLAMP_TO_BORDER_NV=_C('GL_CLAMP_TO_BORDER_NV',0x812D)
GL_ALPHA_TEST_QCOM=_C('GL_ALPHA_TEST_QCOM',0x0BC0)
GL_ALPHA_TEST_FUNC_QCOM=_C('GL_ALPHA_TEST_FUNC_QCOM',0x0BC1)
GL_ALPHA_TEST_REF_QCOM=_C('GL_ALPHA_TEST_REF_QCOM',0x0BC2)
GL_BINNING_CONTROL_HINT_QCOM=_C('GL_BINNING_CONTROL_HINT_QCOM',0x8FB0)
GL_CPU_OPTIMIZED_QCOM=_C('GL_CPU_OPTIMIZED_QCOM',0x8FB1)
GL_GPU_OPTIMIZED_QCOM=_C('GL_GPU_OPTIMIZED_QCOM',0x8FB2)
GL_RENDER_DIRECT_TO_FRAMEBUFFER_QCOM=_C('GL_RENDER_DIRECT_TO_FRAMEBUFFER_QCOM',0x8FB3)
GL_TEXTURE_WIDTH_QCOM=_C('GL_TEXTURE_WIDTH_QCOM',0x8BD2)
GL_TEXTURE_HEIGHT_QCOM=_C('GL_TEXTURE_HEIGHT_QCOM',0x8BD3)
GL_TEXTURE_DEPTH_QCOM=_C('GL_TEXTURE_DEPTH_QCOM',0x8BD4)
GL_TEXTURE_INTERNAL_FORMAT_QCOM=_C('GL_TEXTURE_INTERNAL_FORMAT_QCOM',0x8BD5)
GL_TEXTURE_FORMAT_QCOM=_C('GL_TEXTURE_FORMAT_QCOM',0x8BD6)
GL_TEXTURE_TYPE_QCOM=_C('GL_TEXTURE_TYPE_QCOM',0x8BD7)
GL_TEXTURE_IMAGE_VALID_QCOM=_C('GL_TEXTURE_IMAGE_VALID_QCOM',0x8BD8)
GL_TEXTURE_NUM_LEVELS_QCOM=_C('GL_TEXTURE_NUM_LEVELS_QCOM',0x8BD9)
GL_TEXTURE_TARGET_QCOM=_C('GL_TEXTURE_TARGET_QCOM',0x8BDA)
GL_TEXTURE_OBJECT_VALID_QCOM=_C('GL_TEXTURE_OBJECT_VALID_QCOM',0x8BDB)
GL_STATE_RESTORE=_C('GL_STATE_RESTORE',0x8BDC)
GL_PERFMON_GLOBAL_MODE_QCOM=_C('GL_PERFMON_GLOBAL_MODE_QCOM',0x8FA0)
GL_WRITEONLY_RENDERING_QCOM=_C('GL_WRITEONLY_RENDERING_QCOM',0x8823)
GL_COLOR_BUFFER_BIT0_QCOM=_C('GL_COLOR_BUFFER_BIT0_QCOM',0x00000001)
GL_COLOR_BUFFER_BIT1_QCOM=_C('GL_COLOR_BUFFER_BIT1_QCOM',0x00000002)
GL_COLOR_BUFFER_BIT2_QCOM=_C('GL_COLOR_BUFFER_BIT2_QCOM',0x00000004)
GL_COLOR_BUFFER_BIT3_QCOM=_C('GL_COLOR_BUFFER_BIT3_QCOM',0x00000008)
GL_COLOR_BUFFER_BIT4_QCOM=_C('GL_COLOR_BUFFER_BIT4_QCOM',0x00000010)
GL_COLOR_BUFFER_BIT5_QCOM=_C('GL_COLOR_BUFFER_BIT5_QCOM',0x00000020)
GL_COLOR_BUFFER_BIT6_QCOM=_C('GL_COLOR_BUFFER_BIT6_QCOM',0x00000040)
GL_COLOR_BUFFER_BIT7_QCOM=_C('GL_COLOR_BUFFER_BIT7_QCOM',0x00000080)
GL_DEPTH_BUFFER_BIT0_QCOM=_C('GL_DEPTH_BUFFER_BIT0_QCOM',0x00000100)
GL_DEPTH_BUFFER_BIT1_QCOM=_C('GL_DEPTH_BUFFER_BIT1_QCOM',0x00000200)
GL_DEPTH_BUFFER_BIT2_QCOM=_C('GL_DEPTH_BUFFER_BIT2_QCOM',0x00000400)
GL_DEPTH_BUFFER_BIT3_QCOM=_C('GL_DEPTH_BUFFER_BIT3_QCOM',0x00000800)
GL_DEPTH_BUFFER_BIT4_QCOM=_C('GL_DEPTH_BUFFER_BIT4_QCOM',0x00001000)
GL_DEPTH_BUFFER_BIT5_QCOM=_C('GL_DEPTH_BUFFER_BIT5_QCOM',0x00002000)
GL_DEPTH_BUFFER_BIT6_QCOM=_C('GL_DEPTH_BUFFER_BIT6_QCOM',0x00004000)
GL_DEPTH_BUFFER_BIT7_QCOM=_C('GL_DEPTH_BUFFER_BIT7_QCOM',0x00008000)
GL_STENCIL_BUFFER_BIT0_QCOM=_C('GL_STENCIL_BUFFER_BIT0_QCOM',0x00010000)
GL_STENCIL_BUFFER_BIT1_QCOM=_C('GL_STENCIL_BUFFER_BIT1_QCOM',0x00020000)
GL_STENCIL_BUFFER_BIT2_QCOM=_C('GL_STENCIL_BUFFER_BIT2_QCOM',0x00040000)
GL_STENCIL_BUFFER_BIT3_QCOM=_C('GL_STENCIL_BUFFER_BIT3_QCOM',0x00080000)
GL_STENCIL_BUFFER_BIT4_QCOM=_C('GL_STENCIL_BUFFER_BIT4_QCOM',0x00100000)
GL_STENCIL_BUFFER_BIT5_QCOM=_C('GL_STENCIL_BUFFER_BIT5_QCOM',0x00200000)
GL_STENCIL_BUFFER_BIT6_QCOM=_C('GL_STENCIL_BUFFER_BIT6_QCOM',0x00400000)
GL_STENCIL_BUFFER_BIT7_QCOM=_C('GL_STENCIL_BUFFER_BIT7_QCOM',0x00800000)
GL_MULTISAMPLE_BUFFER_BIT0_QCOM=_C('GL_MULTISAMPLE_BUFFER_BIT0_QCOM',0x01000000)
GL_MULTISAMPLE_BUFFER_BIT1_QCOM=_C('GL_MULTISAMPLE_BUFFER_BIT1_QCOM',0x02000000)
GL_MULTISAMPLE_BUFFER_BIT2_QCOM=_C('GL_MULTISAMPLE_BUFFER_BIT2_QCOM',0x04000000)
GL_MULTISAMPLE_BUFFER_BIT3_QCOM=_C('GL_MULTISAMPLE_BUFFER_BIT3_QCOM',0x08000000)
GL_MULTISAMPLE_BUFFER_BIT4_QCOM=_C('GL_MULTISAMPLE_BUFFER_BIT4_QCOM',0x10000000)
GL_MULTISAMPLE_BUFFER_BIT5_QCOM=_C('GL_MULTISAMPLE_BUFFER_BIT5_QCOM',0x20000000)
GL_MULTISAMPLE_BUFFER_BIT6_QCOM=_C('GL_MULTISAMPLE_BUFFER_BIT6_QCOM',0x40000000)
GL_MULTISAMPLE_BUFFER_BIT7_QCOM=_C('GL_MULTISAMPLE_BUFFER_BIT7_QCOM',0x80000000)
GL_SHADER_BINARY_VIV=_C('GL_SHADER_BINARY_VIV',0x8FC4)
GL_OES_compressed_ETC1_RGB8_texture=_C('GL_OES_compressed_ETC1_RGB8_texture',1)
GL_OES_compressed_paletted_texture=_C('GL_OES_compressed_paletted_texture',1)
GL_OES_depth24=_C('GL_OES_depth24',1)
GL_OES_depth32=_C('GL_OES_depth32',1)
GL_OES_depth_texture=_C('GL_OES_depth_texture',1)
GL_OES_EGL_image=_C('GL_OES_EGL_image',1)
GL_OES_EGL_image_external=_C('GL_OES_EGL_image_external',1)
GL_OES_element_index_uint=_C('GL_OES_element_index_uint',1)
GL_OES_fbo_render_mipmap=_C('GL_OES_fbo_render_mipmap',1)
GL_OES_fragment_precision_high=_C('GL_OES_fragment_precision_high',1)
GL_OES_get_program_binary=_C('GL_OES_get_program_binary',1)
GL_OES_mapbuffer=_C('GL_OES_mapbuffer',1)
GL_OES_packed_depth_stencil=_C('GL_OES_packed_depth_stencil',1)
GL_OES_required_internalformat=_C('GL_OES_required_internalformat',1)
GL_OES_rgb8_rgba8=_C('GL_OES_rgb8_rgba8',1)
GL_OES_standard_derivatives=_C('GL_OES_standard_derivatives',1)
GL_OES_stencil1=_C('GL_OES_stencil1',1)
GL_OES_stencil4=_C('GL_OES_stencil4',1)
GL_OES_surfaceless_context=_C('GL_OES_surfaceless_context',1)
GL_OES_texture_3D=_C('GL_OES_texture_3D',1)
GL_OES_texture_float=_C('GL_OES_texture_float',1)
GL_OES_texture_float_linear=_C('GL_OES_texture_float_linear',1)
GL_OES_texture_half_float=_C('GL_OES_texture_half_float',1)
GL_OES_texture_half_float_linear=_C('GL_OES_texture_half_float_linear',1)
GL_OES_texture_npot=_C('GL_OES_texture_npot',1)
GL_OES_vertex_array_object=_C('GL_OES_vertex_array_object',1)
GL_OES_vertex_half_float=_C('GL_OES_vertex_half_float',1)
GL_OES_vertex_type_10_10_10_2=_C('GL_OES_vertex_type_10_10_10_2',1)
GL_KHR_debug=_C('GL_KHR_debug',1)
GL_KHR_texture_compression_astc_ldr=_C('GL_KHR_texture_compression_astc_ldr',1)
GL_AMD_compressed_3DC_texture=_C('GL_AMD_compressed_3DC_texture',1)
GL_AMD_compressed_ATC_texture=_C('GL_AMD_compressed_ATC_texture',1)
GL_AMD_performance_monitor=_C('GL_AMD_performance_monitor',1)
GL_AMD_program_binary_Z400=_C('GL_AMD_program_binary_Z400',1)
GL_ANGLE_depth_texture=_C('GL_ANGLE_depth_texture',1)
GL_ANGLE_framebuffer_blit=_C('GL_ANGLE_framebuffer_blit',1)
GL_ANGLE_framebuffer_multisample=_C('GL_ANGLE_framebuffer_multisample',1)
GL_ANGLE_instanced_arrays=_C('GL_ANGLE_instanced_arrays',1)
GL_ANGLE_pack_reverse_row_order=_C('GL_ANGLE_pack_reverse_row_order',1)
GL_ANGLE_program_binary=_C('GL_ANGLE_program_binary',1)
GL_ANGLE_texture_compression_dxt3=_C('GL_ANGLE_texture_compression_dxt3',1)
GL_ANGLE_texture_compression_dxt5=_C('GL_ANGLE_texture_compression_dxt5',1)
GL_ANGLE_texture_usage=_C('GL_ANGLE_texture_usage',1)
GL_ANGLE_translated_shader_source=_C('GL_ANGLE_translated_shader_source',1)
GL_APPLE_copy_texture_levels=_C('GL_APPLE_copy_texture_levels',1)
GL_APPLE_framebuffer_multisample=_C('GL_APPLE_framebuffer_multisample',1)
GL_APPLE_rgb_422=_C('GL_APPLE_rgb_422',1)
GL_APPLE_sync=_C('GL_APPLE_sync',1)
GL_APPLE_texture_format_BGRA8888=_C('GL_APPLE_texture_format_BGRA8888',1)
GL_APPLE_texture_max_level=_C('GL_APPLE_texture_max_level',1)
GL_ARM_mali_program_binary=_C('GL_ARM_mali_program_binary',1)
GL_ARM_mali_shader_binary=_C('GL_ARM_mali_shader_binary',1)
GL_ARM_rgba8=_C('GL_ARM_rgba8',1)
GL_EXT_blend_minmax=_C('GL_EXT_blend_minmax',1)
GL_EXT_color_buffer_half_float=_C('GL_EXT_color_buffer_half_float',1)
GL_EXT_debug_label=_C('GL_EXT_debug_label',1)
GL_EXT_debug_marker=_C('GL_EXT_debug_marker',1)
GL_EXT_discard_framebuffer=_C('GL_EXT_discard_framebuffer',1)
GL_EXT_map_buffer_range=_C('GL_EXT_map_buffer_range',1)
GL_EXT_multisampled_render_to_texture=_C('GL_EXT_multisampled_render_to_texture',1)
GL_EXT_multiview_draw_buffers=_C('GL_EXT_multiview_draw_buffers',1)
GL_EXT_multi_draw_arrays=_C('GL_EXT_multi_draw_arrays',1)
GL_EXT_occlusion_query_boolean=_C('GL_EXT_occlusion_query_boolean',1)
GL_EXT_read_format_bgra=_C('GL_EXT_read_format_bgra',1)
GL_EXT_robustness=_C('GL_EXT_robustness',1)
GL_EXT_separate_shader_objects=_C('GL_EXT_separate_shader_objects',1)
GL_EXT_shader_framebuffer_fetch=_C('GL_EXT_shader_framebuffer_fetch',1)
GL_EXT_shader_texture_lod=_C('GL_EXT_shader_texture_lod',1)
GL_EXT_shadow_samplers=_C('GL_EXT_shadow_samplers',1)
GL_EXT_sRGB=_C('GL_EXT_sRGB',1)
GL_EXT_texture_compression_dxt1=_C('GL_EXT_texture_compression_dxt1',1)
GL_EXT_texture_filter_anisotropic=_C('GL_EXT_texture_filter_anisotropic',1)
GL_EXT_texture_format_BGRA8888=_C('GL_EXT_texture_format_BGRA8888',1)
GL_EXT_texture_rg=_C('GL_EXT_texture_rg',1)
GL_EXT_texture_storage=_C('GL_EXT_texture_storage',1)
GL_EXT_texture_type_2_10_10_10_REV=_C('GL_EXT_texture_type_2_10_10_10_REV',1)
GL_EXT_unpack_subimage=_C('GL_EXT_unpack_subimage',1)
GL_DMP_shader_binary=_C('GL_DMP_shader_binary',1)
GL_FJ_shader_binary_GCCSO=_C('GL_FJ_shader_binary_GCCSO',1)
GL_IMG_program_binary=_C('GL_IMG_program_binary',1)
GL_IMG_read_format=_C('GL_IMG_read_format',1)
GL_IMG_shader_binary=_C('GL_IMG_shader_binary',1)
GL_IMG_texture_compression_pvrtc=_C('GL_IMG_texture_compression_pvrtc',1)
GL_IMG_texture_compression_pvrtc2=_C('GL_IMG_texture_compression_pvrtc2',1)
GL_IMG_multisampled_render_to_texture=_C('GL_IMG_multisampled_render_to_texture',1)
GL_NV_coverage_sample=_C('GL_NV_coverage_sample',1)
GL_NV_depth_nonlinear=_C('GL_NV_depth_nonlinear',1)
GL_NV_draw_buffers=_C('GL_NV_draw_buffers',1)
GL_NV_draw_instanced=_C('GL_NV_draw_instanced',1)
GL_NV_fbo_color_attachments=_C('GL_NV_fbo_color_attachments',1)
GL_NV_fence=_C('GL_NV_fence',1)
GL_NV_framebuffer_blit=_C('GL_NV_framebuffer_blit',1)
GL_NV_framebuffer_multisample=_C('GL_NV_framebuffer_multisample',1)
GL_NV_generate_mipmap_sRGB=_C('GL_NV_generate_mipmap_sRGB',1)
GL_NV_instanced_arrays=_C('GL_NV_instanced_arrays',1)
GL_NV_read_buffer=_C('GL_NV_read_buffer',1)
GL_NV_read_buffer_front=_C('GL_NV_read_buffer_front',1)
GL_NV_read_depth=_C('GL_NV_read_depth',1)
GL_NV_read_depth_stencil=_C('GL_NV_read_depth_stencil',1)
GL_NV_read_stencil=_C('GL_NV_read_stencil',1)
GL_NV_shadow_samplers_array=_C('GL_NV_shadow_samplers_array',1)
GL_NV_shadow_samplers_cube=_C('GL_NV_shadow_samplers_cube',1)
GL_NV_sRGB_formats=_C('GL_NV_sRGB_formats',1)
GL_NV_texture_border_clamp=_C('GL_NV_texture_border_clamp',1)
GL_NV_texture_compression_s3tc_update=_C('GL_NV_texture_compression_s3tc_update',1)
GL_NV_texture_npot_2D_mipmap=_C('GL_NV_texture_npot_2D_mipmap',1)
GL_QCOM_alpha_test=_C('GL_QCOM_alpha_test',1)
GL_QCOM_binning_control=_C('GL_QCOM_binning_control',1)
GL_QCOM_driver_control=_C('GL_QCOM_driver_control',1)
GL_QCOM_extended_get=_C('GL_QCOM_extended_get',1)
GL_QCOM_extended_get2=_C('GL_QCOM_extended_get2',1)
GL_QCOM_perfmon_global_mode=_C('GL_QCOM_perfmon_global_mode',1)
GL_QCOM_writeonly_rendering=_C('GL_QCOM_writeonly_rendering',1)
GL_QCOM_tiled_rendering=_C('GL_QCOM_tiled_rendering',1)
GL_VIV_shader_binary=_C('GL_VIV_shader_binary',1)
@_f
@_p.types(None,_cs.GLenum)
def glActiveTexture(texture):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint)
def glAttachShader(program,shader):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint,arrays.GLcharArray)
def glBindAttribLocation(program,index,name):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint)
def glBindBuffer(target,buffer):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint)
def glBindFramebuffer(target,framebuffer):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint)
def glBindRenderbuffer(target,renderbuffer):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint)
def glBindTexture(target,texture):pass
@_f
@_p.types(None,_cs.GLclampf,_cs.GLclampf,_cs.GLclampf,_cs.GLclampf)
def glBlendColor(red,green,blue,alpha):pass
@_f
@_p.types(None,_cs.GLenum)
def glBlendEquation(mode):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum)
def glBlendEquationSeparate(modeRGB,modeAlpha):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum)
def glBlendFunc(sfactor,dfactor):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLenum,_cs.GLenum)
def glBlendFuncSeparate(srcRGB,dstRGB,srcAlpha,dstAlpha):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizeiptr,ctypes.c_void_p,_cs.GLenum)
def glBufferData(target,size,data,usage):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLintptr,_cs.GLsizeiptr,ctypes.c_void_p)
def glBufferSubData(target,offset,size,data):pass
@_f
@_p.types(_cs.GLenum,_cs.GLenum)
def glCheckFramebufferStatus(target):pass
@_f
@_p.types(None,_cs.GLbitfield)
def glClear(mask):pass
@_f
@_p.types(None,_cs.GLclampf,_cs.GLclampf,_cs.GLclampf,_cs.GLclampf)
def glClearColor(red,green,blue,alpha):pass
@_f
@_p.types(None,_cs.GLclampf)
def glClearDepthf(depth):pass
@_f
@_p.types(None,_cs.GLint)
def glClearStencil(s):pass
@_f
@_p.types(None,_cs.GLboolean,_cs.GLboolean,_cs.GLboolean,_cs.GLboolean)
def glColorMask(red,green,blue,alpha):pass
@_f
@_p.types(None,_cs.GLuint)
def glCompileShader(shader):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLenum,_cs.GLsizei,_cs.GLsizei,_cs.GLint,_cs.GLsizei,ctypes.c_void_p)
def glCompressedTexImage2D(target,level,internalformat,width,height,border,imageSize,data):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,ctypes.c_void_p)
def glCompressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,imageSize,data):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLenum,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei,_cs.GLint)
def glCopyTexImage2D(target,level,internalformat,x,y,width,height,border):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei)
def glCopyTexSubImage2D(target,level,xoffset,yoffset,x,y,width,height):pass
@_f
@_p.types(_cs.GLuint,)
def glCreateProgram():pass
@_f
@_p.types(_cs.GLuint,_cs.GLenum)
def glCreateShader(type):pass
@_f
@_p.types(None,_cs.GLenum)
def glCullFace(mode):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glDeleteBuffers(n,buffers):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glDeleteFramebuffers(n,framebuffers):pass
@_f
@_p.types(None,_cs.GLuint)
def glDeleteProgram(program):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glDeleteRenderbuffers(n,renderbuffers):pass
@_f
@_p.types(None,_cs.GLuint)
def glDeleteShader(shader):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glDeleteTextures(n,textures):pass
@_f
@_p.types(None,_cs.GLenum)
def glDepthFunc(func):pass
@_f
@_p.types(None,_cs.GLboolean)
def glDepthMask(flag):pass
@_f
@_p.types(None,_cs.GLclampf,_cs.GLclampf)
def glDepthRangef(zNear,zFar):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint)
def glDetachShader(program,shader):pass
@_f
@_p.types(None,_cs.GLenum)
def glDisable(cap):pass
@_f
@_p.types(None,_cs.GLuint)
def glDisableVertexAttribArray(index):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLsizei)
def glDrawArrays(mode,first,count):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,ctypes.c_void_p)
def glDrawElements(mode,count,type,indices):pass
@_f
@_p.types(None,_cs.GLenum)
def glEnable(cap):pass
@_f
@_p.types(None,_cs.GLuint)
def glEnableVertexAttribArray(index):pass
@_f
@_p.types(None,)
def glFinish():pass
@_f
@_p.types(None,)
def glFlush():pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLenum,_cs.GLuint)
def glFramebufferRenderbuffer(target,attachment,renderbuffertarget,renderbuffer):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLenum,_cs.GLuint,_cs.GLint)
def glFramebufferTexture2D(target,attachment,textarget,texture,level):pass
@_f
@_p.types(None,_cs.GLenum)
def glFrontFace(mode):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glGenBuffers(n,buffers):pass
@_f
@_p.types(None,_cs.GLenum)
def glGenerateMipmap(target):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glGenFramebuffers(n,framebuffers):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glGenRenderbuffers(n,renderbuffers):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glGenTextures(n,textures):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLintArray,arrays.GLuintArray,arrays.GLcharArray)
def glGetActiveAttrib(program,index,bufsize,length,size,type,name):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLintArray,arrays.GLuintArray,arrays.GLcharArray)
def glGetActiveUniform(program,index,bufsize,length,size,type,name):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLuintArray)
def glGetAttachedShaders(program,maxcount,count,shaders):pass
@_f
@_p.types(_cs.GLint,_cs.GLuint,arrays.GLcharArray)
def glGetAttribLocation(program,name):pass
@_f
@_p.types(None,_cs.GLenum,arrays.GLbooleanArray)
def glGetBooleanv(pname,params):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,arrays.GLintArray)
def glGetBufferParameteriv(target,pname,params):pass
@_f
@_p.types(_cs.GLenum,)
def glGetError():pass
@_f
@_p.types(None,_cs.GLenum,arrays.GLfloatArray)
def glGetFloatv(pname,params):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLenum,arrays.GLintArray)
def glGetFramebufferAttachmentParameteriv(target,attachment,pname,params):pass
@_f
@_p.types(None,_cs.GLenum,arrays.GLintArray)
def glGetIntegerv(pname,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,arrays.GLintArray)
def glGetProgramiv(program,pname,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetProgramInfoLog(program,bufsize,length,infolog):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,arrays.GLintArray)
def glGetRenderbufferParameteriv(target,pname,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,arrays.GLintArray)
def glGetShaderiv(shader,pname,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetShaderInfoLog(shader,bufsize,length,infolog):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,arrays.GLintArray,arrays.GLintArray)
def glGetShaderPrecisionFormat(shadertype,precisiontype,range,precision):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetShaderSource(shader,bufsize,length,source):pass
@_f
@_p.types(arrays.GLubyteArray,_cs.GLenum)
def glGetString(name):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,arrays.GLfloatArray)
def glGetTexParameterfv(target,pname,params):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,arrays.GLintArray)
def glGetTexParameteriv(target,pname,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,arrays.GLfloatArray)
def glGetUniformfv(program,location,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,arrays.GLintArray)
def glGetUniformiv(program,location,params):pass
@_f
@_p.types(_cs.GLint,_cs.GLuint,arrays.GLcharArray)
def glGetUniformLocation(program,name):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,arrays.GLfloatArray)
def glGetVertexAttribfv(index,pname,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,arrays.GLintArray)
def glGetVertexAttribiv(index,pname,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,arrays.GLvoidpArray)
def glGetVertexAttribPointerv(index,pname,pointer):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum)
def glHint(target,mode):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glIsBuffer(buffer):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLenum)
def glIsEnabled(cap):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glIsFramebuffer(framebuffer):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glIsProgram(program):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glIsRenderbuffer(renderbuffer):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glIsShader(shader):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glIsTexture(texture):pass
@_f
@_p.types(None,_cs.GLfloat)
def glLineWidth(width):pass
@_f
@_p.types(None,_cs.GLuint)
def glLinkProgram(program):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint)
def glPixelStorei(pname,param):pass
@_f
@_p.types(None,_cs.GLfloat,_cs.GLfloat)
def glPolygonOffset(factor,units):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei,_cs.GLenum,_cs.GLenum,ctypes.c_void_p)
def glReadPixels(x,y,width,height,format,type,pixels):pass
@_f
@_p.types(None,)
def glReleaseShaderCompiler():pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLsizei,_cs.GLsizei)
def glRenderbufferStorage(target,internalformat,width,height):pass
@_f
@_p.types(None,_cs.GLclampf,_cs.GLboolean)
def glSampleCoverage(value,invert):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei)
def glScissor(x,y,width,height):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray,_cs.GLenum,ctypes.c_void_p,_cs.GLsizei)
def glShaderBinary(n,shaders,binaryformat,binary,length):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLsizei,ctypes.POINTER( ctypes.POINTER( _cs.GLchar )),arrays.GLintArray)
def glShaderSource(shader,count,string,length):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLuint)
def glStencilFunc(func,ref,mask):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLint,_cs.GLuint)
def glStencilFuncSeparate(face,func,ref,mask):pass
@_f
@_p.types(None,_cs.GLuint)
def glStencilMask(mask):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint)
def glStencilMaskSeparate(face,mask):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLenum)
def glStencilOp(fail,zfail,zpass):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLenum,_cs.GLenum)
def glStencilOpSeparate(face,fail,zfail,zpass):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei,_cs.GLint,_cs.GLenum,_cs.GLenum,ctypes.c_void_p)
def glTexImage2D(target,level,internalformat,width,height,border,format,type,pixels):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLfloat)
def glTexParameterf(target,pname,param):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,arrays.GLfloatArray)
def glTexParameterfv(target,pname,params):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLint)
def glTexParameteri(target,pname,param):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,arrays.GLintArray)
def glTexParameteriv(target,pname,params):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei,_cs.GLenum,_cs.GLenum,ctypes.c_void_p)
def glTexSubImage2D(target,level,xoffset,yoffset,width,height,format,type,pixels):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLfloat)
def glUniform1f(location,x):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,arrays.GLfloatArray)
def glUniform1fv(location,count,v):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLint)
def glUniform1i(location,x):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,arrays.GLintArray)
def glUniform1iv(location,count,v):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLfloat,_cs.GLfloat)
def glUniform2f(location,x,y):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,arrays.GLfloatArray)
def glUniform2fv(location,count,v):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLint,_cs.GLint)
def glUniform2i(location,x,y):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,arrays.GLintArray)
def glUniform2iv(location,count,v):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLfloat,_cs.GLfloat,_cs.GLfloat)
def glUniform3f(location,x,y,z):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,arrays.GLfloatArray)
def glUniform3fv(location,count,v):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint)
def glUniform3i(location,x,y,z):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,arrays.GLintArray)
def glUniform3iv(location,count,v):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLfloat,_cs.GLfloat,_cs.GLfloat,_cs.GLfloat)
def glUniform4f(location,x,y,z,w):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,arrays.GLfloatArray)
def glUniform4fv(location,count,v):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint)
def glUniform4i(location,x,y,z,w):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,arrays.GLintArray)
def glUniform4iv(location,count,v):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,_cs.GLboolean,arrays.GLfloatArray)
def glUniformMatrix2fv(location,count,transpose,value):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,_cs.GLboolean,arrays.GLfloatArray)
def glUniformMatrix3fv(location,count,transpose,value):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLsizei,_cs.GLboolean,arrays.GLfloatArray)
def glUniformMatrix4fv(location,count,transpose,value):pass
@_f
@_p.types(None,_cs.GLuint)
def glUseProgram(program):pass
@_f
@_p.types(None,_cs.GLuint)
def glValidateProgram(program):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLfloat)
def glVertexAttrib1f(indx,x):pass
@_f
@_p.types(None,_cs.GLuint,arrays.GLfloatArray)
def glVertexAttrib1fv(indx,values):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLfloat,_cs.GLfloat)
def glVertexAttrib2f(indx,x,y):pass
@_f
@_p.types(None,_cs.GLuint,arrays.GLfloatArray)
def glVertexAttrib2fv(indx,values):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLfloat,_cs.GLfloat,_cs.GLfloat)
def glVertexAttrib3f(indx,x,y,z):pass
@_f
@_p.types(None,_cs.GLuint,arrays.GLfloatArray)
def glVertexAttrib3fv(indx,values):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLfloat,_cs.GLfloat,_cs.GLfloat,_cs.GLfloat)
def glVertexAttrib4f(indx,x,y,z,w):pass
@_f
@_p.types(None,_cs.GLuint,arrays.GLfloatArray)
def glVertexAttrib4fv(indx,values):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLenum,_cs.GLboolean,_cs.GLsizei,ctypes.c_void_p)
def glVertexAttribPointer(indx,size,type,normalized,stride,ptr):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei)
def glViewport(x,y,width,height):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLeglImageOES)
def glEGLImageTargetTexture2DOES(target,image):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLeglImageOES)
def glEGLImageTargetRenderbufferStorageOES(target,image):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLuintArray,ctypes.c_void_p)
def glGetProgramBinaryOES(program,bufSize,length,binaryFormat,binary):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,ctypes.c_void_p,_cs.GLint)
def glProgramBinaryOES(program,binaryFormat,binary,length):pass
@_f
@_p.types(ctypes.POINTER(_cs.void),_cs.GLenum,_cs.GLenum)
def glMapBufferOES(target,access):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLenum)
def glUnmapBufferOES(target):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,arrays.GLvoidpArray)
def glGetBufferPointervOES(target,pname,params):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLenum,_cs.GLsizei,_cs.GLsizei,_cs.GLsizei,_cs.GLint,_cs.GLenum,_cs.GLenum,ctypes.c_void_p)
def glTexImage3DOES(target,level,internalformat,width,height,depth,border,format,type,pixels):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei,_cs.GLsizei,_cs.GLenum,_cs.GLenum,ctypes.c_void_p)
def glTexSubImage3DOES(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,pixels):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei)
def glCopyTexSubImage3DOES(target,level,xoffset,yoffset,zoffset,x,y,width,height):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLenum,_cs.GLsizei,_cs.GLsizei,_cs.GLsizei,_cs.GLint,_cs.GLsizei,ctypes.c_void_p)
def glCompressedTexImage3DOES(target,level,internalformat,width,height,depth,border,imageSize,data):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,ctypes.c_void_p)
def glCompressedTexSubImage3DOES(target,level,xoffset,yoffset,zoffset,width,height,depth,format,imageSize,data):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLenum,_cs.GLuint,_cs.GLint,_cs.GLint)
def glFramebufferTexture3DOES(target,attachment,textarget,texture,level,zoffset):pass
@_f
@_p.types(None,_cs.GLuint)
def glBindVertexArrayOES(array):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glDeleteVertexArraysOES(n,arrays):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glGenVertexArraysOES(n,arrays):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glIsVertexArrayOES(array):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLenum,_cs.GLsizei,arrays.GLuintArray,_cs.GLboolean)
def glDebugMessageControl(source,type,severity,count,ids,enabled):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLuint,_cs.GLenum,_cs.GLsizei,arrays.GLcharArray)
def glDebugMessageInsert(source,type,id,severity,length,buf):pass
@_f
@_p.types(None,_cs.GLDEBUGPROC,ctypes.POINTER(_cs.void))
def glDebugMessageCallback(callback,userParam):pass
@_f
@_p.types(_cs.GLuint,_cs.GLuint,_cs.GLsizei,arrays.GLuintArray,arrays.GLuintArray,arrays.GLuintArray,arrays.GLuintArray,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetDebugMessageLog(count,bufsize,sources,types,ids,severities,lengths,messageLog):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint,_cs.GLsizei,arrays.GLcharArray)
def glPushDebugGroup(source,id,length,message):pass
@_f
@_p.types(None,)
def glPopDebugGroup():pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint,_cs.GLsizei,arrays.GLcharArray)
def glObjectLabel(identifier,name,length,label):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetObjectLabel(identifier,name,bufSize,length,label):pass
@_f
@_p.types(None,ctypes.POINTER(_cs.void),_cs.GLsizei,arrays.GLcharArray)
def glObjectPtrLabel(ptr,length,label):pass
@_f
@_p.types(None,ctypes.POINTER(_cs.void),_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetObjectPtrLabel(ptr,bufSize,length,label):pass
@_f
@_p.types(None,_cs.GLenum,ctypes.POINTER(ctypes.POINTER(_cs.void)))
def glGetPointerv(pname,params):pass
@_f
@_p.types(None,arrays.GLintArray,_cs.GLsizei,arrays.GLuintArray)
def glGetPerfMonitorGroupsAMD(numGroups,groupsSize,groups):pass
@_f
@_p.types(None,_cs.GLuint,arrays.GLintArray,arrays.GLintArray,_cs.GLsizei,arrays.GLuintArray)
def glGetPerfMonitorCountersAMD(group,numCounters,maxActiveCounters,counterSize,counters):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetPerfMonitorGroupStringAMD(group,bufSize,length,groupString):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetPerfMonitorCounterStringAMD(group,counter,bufSize,length,counterString):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint,_cs.GLenum,ctypes.c_void_p)
def glGetPerfMonitorCounterInfoAMD(group,counter,pname,data):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glGenPerfMonitorsAMD(n,monitors):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glDeletePerfMonitorsAMD(n,monitors):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLboolean,_cs.GLuint,_cs.GLint,arrays.GLuintArray)
def glSelectPerfMonitorCountersAMD(monitor,enable,group,numCounters,countersList):pass
@_f
@_p.types(None,_cs.GLuint)
def glBeginPerfMonitorAMD(monitor):pass
@_f
@_p.types(None,_cs.GLuint)
def glEndPerfMonitorAMD(monitor):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,_cs.GLsizei,arrays.GLuintArray,arrays.GLintArray)
def glGetPerfMonitorCounterDataAMD(monitor,pname,dataSize,data,bytesWritten):pass
@_f
@_p.types(None,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLbitfield,_cs.GLenum)
def glBlitFramebufferANGLE(srcX0,srcY0,srcX1,srcY1,dstX0,dstY0,dstX1,dstY1,mask,filter):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,_cs.GLsizei)
def glRenderbufferStorageMultisampleANGLE(target,samples,internalformat,width,height):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLsizei,_cs.GLsizei)
def glDrawArraysInstancedANGLE(mode,first,count,primcount):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,ctypes.POINTER(_cs.void),_cs.GLsizei)
def glDrawElementsInstancedANGLE(mode,count,type,indices,primcount):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint)
def glVertexAttribDivisorANGLE(index,divisor):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetTranslatedShaderSourceANGLE(shader,bufsize,length,source):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint,_cs.GLint,_cs.GLsizei)
def glCopyTextureLevelsAPPLE(destinationTexture,sourceTexture,sourceBaseLevel,sourceLevelCount):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,_cs.GLsizei)
def glRenderbufferStorageMultisampleAPPLE(arg_0,arg_1,arg_2,arg_3,arg_4):pass
@_f
@_p.types(None,)
def glResolveMultisampleFramebufferAPPLE():pass
@_f
@_p.types(_cs.GLsync,_cs.GLenum,_cs.GLbitfield)
def glFenceSyncAPPLE(condition,flags):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLsync)
def glIsSyncAPPLE(sync):pass
@_f
@_p.types(None,_cs.GLsync)
def glDeleteSyncAPPLE(sync):pass
@_f
@_p.types(_cs.GLenum,_cs.GLsync,_cs.GLbitfield,_cs.GLuint64)
def glClientWaitSyncAPPLE(sync,flags,timeout):pass
@_f
@_p.types(None,_cs.GLsync,_cs.GLbitfield,_cs.GLuint64)
def glWaitSyncAPPLE(sync,flags,timeout):pass
@_f
@_p.types(None,_cs.GLenum,arrays.GLint64Array)
def glGetInteger64vAPPLE(pname,params):pass
@_f
@_p.types(None,_cs.GLsync,_cs.GLenum,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLintArray)
def glGetSyncivAPPLE(sync,pname,bufSize,length,values):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint,_cs.GLsizei,arrays.GLcharArray)
def glLabelObjectEXT(type,object,length,label):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetObjectLabelEXT(type,object,bufSize,length,label):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLcharArray)
def glInsertEventMarkerEXT(length,marker):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLcharArray)
def glPushGroupMarkerEXT(length,marker):pass
@_f
@_p.types(None,)
def glPopGroupMarkerEXT():pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,arrays.GLuintArray)
def glDiscardFramebufferEXT(target,numAttachments,attachments):pass
@_f
@_p.types(ctypes.POINTER(_cs.void),_cs.GLenum,_cs.GLintptr,_cs.GLsizeiptr,_cs.GLbitfield)
def glMapBufferRangeEXT(target,offset,length,access):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLintptr,_cs.GLsizeiptr)
def glFlushMappedBufferRangeEXT(target,offset,length):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,_cs.GLsizei)
def glRenderbufferStorageMultisampleEXT(arg_0,arg_1,arg_2,arg_3,arg_4):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLenum,_cs.GLuint,_cs.GLint,_cs.GLsizei)
def glFramebufferTexture2DMultisampleEXT(arg_0,arg_1,arg_2,arg_3,arg_4,arg_5):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint)
def glReadBufferIndexedEXT(src,index):pass
@_f
@_p.types(None,_cs.GLint,arrays.GLuintArray,arrays.GLintArray)
def glDrawBuffersIndexedEXT(n,location,indices):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint,arrays.GLintArray)
def glGetIntegeri_vEXT(target,index,data):pass
@_f
@_p.types(None,_cs.GLenum,arrays.GLintArray,arrays.GLsizeiArray,_cs.GLsizei)
def glMultiDrawArraysEXT(arg_0,arg_1,arg_2,arg_3):pass
@_f
@_p.types(None,_cs.GLenum,arrays.GLsizeiArray,_cs.GLenum,arrays.GLvoidpArray,_cs.GLsizei)
def glMultiDrawElementsEXT(arg_0,arg_1,arg_2,arg_3,arg_4):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glGenQueriesEXT(n,ids):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glDeleteQueriesEXT(n,ids):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glIsQueryEXT(id):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLuint)
def glBeginQueryEXT(target,id):pass
@_f
@_p.types(None,_cs.GLenum)
def glEndQueryEXT(target):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,arrays.GLintArray)
def glGetQueryivEXT(target,pname,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,arrays.GLuintArray)
def glGetQueryObjectuivEXT(id,pname,params):pass
@_f
@_p.types(_cs.GLenum,)
def glGetGraphicsResetStatusEXT():pass
@_f
@_p.types(None,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei,_cs.GLenum,_cs.GLenum,_cs.GLsizei,ctypes.POINTER(_cs.void))
def glReadnPixelsEXT(x,y,width,height,format,type,bufSize,data):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,arrays.GLfloatArray)
def glGetnUniformfvEXT(program,location,bufSize,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,arrays.GLintArray)
def glGetnUniformivEXT(program,location,bufSize,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLbitfield,_cs.GLuint)
def glUseProgramStagesEXT(pipeline,stages,program):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint)
def glActiveShaderProgramEXT(pipeline,program):pass
@_f
@_p.types(_cs.GLuint,_cs.GLenum,_cs.GLsizei,ctypes.POINTER( ctypes.POINTER( _cs.GLchar )))
def glCreateShaderProgramvEXT(type,count,strings):pass
@_f
@_p.types(None,_cs.GLuint)
def glBindProgramPipelineEXT(pipeline):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glDeleteProgramPipelinesEXT(n,pipelines):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glGenProgramPipelinesEXT(n,pipelines):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glIsProgramPipelineEXT(pipeline):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,_cs.GLint)
def glProgramParameteriEXT(program,pname,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,arrays.GLintArray)
def glGetProgramPipelineivEXT(pipeline,pname,params):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLint)
def glProgramUniform1iEXT(program,location,x):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLint,_cs.GLint)
def glProgramUniform2iEXT(program,location,x,y):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint)
def glProgramUniform3iEXT(program,location,x,y,z):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint)
def glProgramUniform4iEXT(program,location,x,y,z,w):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLfloat)
def glProgramUniform1fEXT(program,location,x):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLfloat,_cs.GLfloat)
def glProgramUniform2fEXT(program,location,x,y):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLfloat,_cs.GLfloat,_cs.GLfloat)
def glProgramUniform3fEXT(program,location,x,y,z):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLfloat,_cs.GLfloat,_cs.GLfloat,_cs.GLfloat)
def glProgramUniform4fEXT(program,location,x,y,z,w):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,arrays.GLintArray)
def glProgramUniform1ivEXT(program,location,count,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,arrays.GLintArray)
def glProgramUniform2ivEXT(program,location,count,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,arrays.GLintArray)
def glProgramUniform3ivEXT(program,location,count,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,arrays.GLintArray)
def glProgramUniform4ivEXT(program,location,count,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,arrays.GLfloatArray)
def glProgramUniform1fvEXT(program,location,count,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,arrays.GLfloatArray)
def glProgramUniform2fvEXT(program,location,count,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,arrays.GLfloatArray)
def glProgramUniform3fvEXT(program,location,count,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,arrays.GLfloatArray)
def glProgramUniform4fvEXT(program,location,count,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,_cs.GLboolean,arrays.GLfloatArray)
def glProgramUniformMatrix2fvEXT(program,location,count,transpose,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,_cs.GLboolean,arrays.GLfloatArray)
def glProgramUniformMatrix3fvEXT(program,location,count,transpose,value):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLint,_cs.GLsizei,_cs.GLboolean,arrays.GLfloatArray)
def glProgramUniformMatrix4fvEXT(program,location,count,transpose,value):pass
@_f
@_p.types(None,_cs.GLuint)
def glValidateProgramPipelineEXT(pipeline):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetProgramPipelineInfoLogEXT(pipeline,bufSize,length,infoLog):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei)
def glTexStorage1DEXT(target,levels,internalformat,width):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,_cs.GLsizei)
def glTexStorage2DEXT(target,levels,internalformat,width,height):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,_cs.GLsizei,_cs.GLsizei)
def glTexStorage3DEXT(target,levels,internalformat,width,height,depth):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei)
def glTextureStorage1DEXT(texture,target,levels,internalformat,width):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,_cs.GLsizei)
def glTextureStorage2DEXT(texture,target,levels,internalformat,width,height):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,_cs.GLsizei,_cs.GLsizei)
def glTextureStorage3DEXT(texture,target,levels,internalformat,width,height,depth):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,_cs.GLsizei)
def glRenderbufferStorageMultisampleIMG(arg_0,arg_1,arg_2,arg_3,arg_4):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLenum,_cs.GLuint,_cs.GLint,_cs.GLsizei)
def glFramebufferTexture2DMultisampleIMG(arg_0,arg_1,arg_2,arg_3,arg_4,arg_5):pass
@_f
@_p.types(None,_cs.GLboolean)
def glCoverageMaskNV(mask):pass
@_f
@_p.types(None,_cs.GLenum)
def glCoverageOperationNV(operation):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glDrawBuffersNV(n,bufs):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLsizei,_cs.GLsizei)
def glDrawArraysInstancedNV(mode,first,count,primcount):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,ctypes.c_void_p,_cs.GLsizei)
def glDrawElementsInstancedNV(mode,count,type,indices,primcount):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glDeleteFencesNV(arg_0,arg_1):pass
@_f
@_p.types(None,_cs.GLsizei,arrays.GLuintArray)
def glGenFencesNV(arg_0,arg_1):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glIsFenceNV(arg_0):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glTestFenceNV(arg_0):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,arrays.GLintArray)
def glGetFenceivNV(arg_0,arg_1,arg_2):pass
@_f
@_p.types(None,_cs.GLuint)
def glFinishFenceNV(arg_0):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum)
def glSetFenceNV(arg_0,arg_1):pass
@_f
@_p.types(None,_cs.c_int,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLbitfield,_cs.GLenum)
def glBlitFramebufferNV(srcX0,srcY0,srcX1,srcY1,dstX0,dstY0,dstX1,dstY1,mask,filter):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLsizei,_cs.GLenum,_cs.GLsizei,_cs.GLsizei)
def glRenderbufferStorageMultisampleNV(target,samples,internalformat,width,height):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint)
def glVertexAttribDivisorNV(index,divisor):pass
@_f
@_p.types(None,_cs.GLenum)
def glReadBufferNV(mode):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLclampf)
def glAlphaFuncQCOM(func,ref):pass
@_f
@_p.types(None,arrays.GLintArray,_cs.GLsizei,arrays.GLuintArray)
def glGetDriverControlsQCOM(num,size,driverControls):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLsizei,arrays.GLsizeiArray,arrays.GLcharArray)
def glGetDriverControlStringQCOM(driverControl,bufSize,length,driverControlString):pass
@_f
@_p.types(None,_cs.GLuint)
def glEnableDriverControlQCOM(driverControl):pass
@_f
@_p.types(None,_cs.GLuint)
def glDisableDriverControlQCOM(driverControl):pass
@_f
@_p.types(None,arrays.GLuintArray,_cs.GLint,arrays.GLintArray)
def glExtGetTexturesQCOM(textures,maxTextures,numTextures):pass
@_f
@_p.types(None,arrays.GLuintArray,_cs.GLint,arrays.GLintArray)
def glExtGetBuffersQCOM(buffers,maxBuffers,numBuffers):pass
@_f
@_p.types(None,arrays.GLuintArray,_cs.GLint,arrays.GLintArray)
def glExtGetRenderbuffersQCOM(renderbuffers,maxRenderbuffers,numRenderbuffers):pass
@_f
@_p.types(None,arrays.GLuintArray,_cs.GLint,arrays.GLintArray)
def glExtGetFramebuffersQCOM(framebuffers,maxFramebuffers,numFramebuffers):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,_cs.GLint,_cs.GLenum,arrays.GLintArray)
def glExtGetTexLevelParameterivQCOM(texture,face,level,pname,params):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLenum,_cs.GLint)
def glExtTexObjectStateOverrideiQCOM(target,pname,param):pass
@_f
@_p.types(None,_cs.GLenum,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLint,_cs.GLsizei,_cs.GLsizei,_cs.GLsizei,_cs.GLenum,_cs.GLenum,ctypes.c_void_p)
def glExtGetTexSubImageQCOM(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,texels):pass
@_f
@_p.types(None,_cs.GLenum,arrays.GLvoidpArray)
def glExtGetBufferPointervQCOM(target,params):pass
@_f
@_p.types(None,arrays.GLuintArray,_cs.GLint,arrays.GLintArray)
def glExtGetShadersQCOM(shaders,maxShaders,numShaders):pass
@_f
@_p.types(None,arrays.GLuintArray,_cs.GLint,arrays.GLintArray)
def glExtGetProgramsQCOM(programs,maxPrograms,numPrograms):pass
@_f
@_p.types(_cs.GLboolean,_cs.GLuint)
def glExtIsProgramBinaryQCOM(program):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLenum,arrays.GLcharArray,arrays.GLintArray)
def glExtGetProgramBinarySourceQCOM(program,shadertype,source,length):pass
@_f
@_p.types(None,_cs.GLuint,_cs.GLuint,_cs.GLuint,_cs.GLuint,_cs.GLbitfield)
def glStartTilingQCOM(x,y,width,height,preserveMask):pass
@_f
@_p.types(None,_cs.GLbitfield)
def glEndTilingQCOM(preserveMask):pass

