# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceIdentity(Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :param type: The identity type. Set this to 'SystemAssigned' in order to
     automatically create and assign an Azure Active Directory principal for
     the resource. Possible values include: 'SystemAssigned'
    :type type: str or ~azure.mgmt.sqlvirtualmachine.models.IdentityType
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(ResourceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.type = type
        self.tenant_id = None
