# HTMLcolors.py
# COPYRIGHT (C) 1996, 1997  ROBIN FRIEDRICH
# Permission to use, copy, modify, and distribute this software and
# its documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and
# that both that copyright notice and this permission notice appear in
# supporting documentation.
# ROBIN FRIEDRICH DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL ROBIN FRIEDRICH BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
# RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
# CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

"""Selected colors useful for HTML 2.0 backgrounds/foregrounds.

These are some hex triplet codes corresponding to colors which are displayed
without dithering.  Numbered colors get darker as their numbers increase.
There are 256 such colors in Netscape's colorcube but only visually distinct colors
are set here.
"""
__version__ = '$Id: HTMLcolors.py,v 1.1 2007/02/22 17:02:49 geoff Exp $'
GREY1,     GREY2,    GREY3,     GREY4,   GREY5,    GREY6 = \
GRAY1,     GRAY2,    GRAY3,     GRAY4,   GRAY5,    GRAY6 = \
'#EEEEEE','#DDDDDD','#CCCCCC','#BBBBBB','#AAAAAA','#999999'
RED1,      RED2,     RED3,     RED4,     RED5,     RED6 = \
'#FF0000','#EE0000','#DD0000','#CC0000','#BB0000','#990000'
BLUE1,     BLUE2,    BLUE3,    BLUE4,    BLUE5,    BLUE6 = \
'#0000FF','#0000EE','#0000DD','#0000CC','#0000BB','#000099'
GREEN1,    GREEN2,   GREEN3,   GREEN4,   GREEN5,   GREEN6 = \
'#00EE00','#00DD00','#00CC00','#00BB00','#00AA00','#009900'
RED = RED2
GREEN = GREEN2
BLUE = BLUE1
GREY = GRAY = '#0C0C0C'
WHITE = '#FFFFFF'
BLACK = '#000000'
PURPLE = '#AAAAFF'
ORANGE = '#FFCC33'
SKYBLUE = '#99CCFF'
BROWN = '#CC9966'
SEAGREEN = '#0099CC'
MOROON = '#CC3366'
CADETBLUE = '#9999CC'
AQUA = '#33CCCC'
YELLOW = '#FFFF66'
PURPLE = '#CC66FF'
PEACH = '#FFCC99'
LIME = '#CCFF66'
OLIVE = '#999966'
TAN = '#FFCCCC'
PINK = '#FF99CC'
COPPER = '#CC6600'
