# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.0
#
# <auto-generated>
#
# Generated from file `LocalException.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Ice_Identity_ice
import Ice_Version_ice
import Ice_BuiltinSequences_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module Ice
__name__ = 'Ice'

if 'InitializationException' not in _M_Ice.__dict__:
    _M_Ice.InitializationException = Ice.createTempClass()
    class InitializationException(Ice.LocalException):
        '''This exception is raised when a failure occurs during initialization.'''
        def __init__(self, reason=''):
            self.reason = reason

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::InitializationException'

    _M_Ice._t_InitializationException = IcePy.defineException('::Ice::InitializationException', InitializationException, (), False, None, (('reason', (), IcePy._t_string, False, 0),))
    InitializationException._ice_type = _M_Ice._t_InitializationException

    _M_Ice.InitializationException = InitializationException
    del InitializationException

if 'PluginInitializationException' not in _M_Ice.__dict__:
    _M_Ice.PluginInitializationException = Ice.createTempClass()
    class PluginInitializationException(Ice.LocalException):
        '''This exception indicates that a failure occurred while initializing
a plug-in.'''
        def __init__(self, reason=''):
            self.reason = reason

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::PluginInitializationException'

    _M_Ice._t_PluginInitializationException = IcePy.defineException('::Ice::PluginInitializationException', PluginInitializationException, (), False, None, (('reason', (), IcePy._t_string, False, 0),))
    PluginInitializationException._ice_type = _M_Ice._t_PluginInitializationException

    _M_Ice.PluginInitializationException = PluginInitializationException
    del PluginInitializationException

if 'CollocationOptimizationException' not in _M_Ice.__dict__:
    _M_Ice.CollocationOptimizationException = Ice.createTempClass()
    class CollocationOptimizationException(Ice.LocalException):
        '''This exception is raised if a feature is requested that is not
supported with collocation optimization.'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::CollocationOptimizationException'

    _M_Ice._t_CollocationOptimizationException = IcePy.defineException('::Ice::CollocationOptimizationException', CollocationOptimizationException, (), False, None, ())
    CollocationOptimizationException._ice_type = _M_Ice._t_CollocationOptimizationException

    _M_Ice.CollocationOptimizationException = CollocationOptimizationException
    del CollocationOptimizationException

if 'AlreadyRegisteredException' not in _M_Ice.__dict__:
    _M_Ice.AlreadyRegisteredException = Ice.createTempClass()
    class AlreadyRegisteredException(Ice.LocalException):
        '''An attempt was made to register something more than once with
the Ice run time.

This exception is raised if an attempt is made to register a
servant, servant locator, facet, object factory, plug-in, object
adapter, object, or user exception factory more than once for the
same ID.'''
        def __init__(self, kindOfObject='', id=''):
            self.kindOfObject = kindOfObject
            self.id = id

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::AlreadyRegisteredException'

    _M_Ice._t_AlreadyRegisteredException = IcePy.defineException('::Ice::AlreadyRegisteredException', AlreadyRegisteredException, (), False, None, (
        ('kindOfObject', (), IcePy._t_string, False, 0),
        ('id', (), IcePy._t_string, False, 0)
    ))
    AlreadyRegisteredException._ice_type = _M_Ice._t_AlreadyRegisteredException

    _M_Ice.AlreadyRegisteredException = AlreadyRegisteredException
    del AlreadyRegisteredException

if 'NotRegisteredException' not in _M_Ice.__dict__:
    _M_Ice.NotRegisteredException = Ice.createTempClass()
    class NotRegisteredException(Ice.LocalException):
        '''An attempt was made to find or deregister something that is not
registered with the Ice run time or Ice locator.

This exception is raised if an attempt is made to remove a servant,
servant locator, facet, object factory, plug-in, object adapter,
object, or user exception factory that is not currently registered.

It's also raised if the Ice locator can't find an object or object
adapter when resolving an indirect proxy or when an object adapter
is activated.'''
        def __init__(self, kindOfObject='', id=''):
            self.kindOfObject = kindOfObject
            self.id = id

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::NotRegisteredException'

    _M_Ice._t_NotRegisteredException = IcePy.defineException('::Ice::NotRegisteredException', NotRegisteredException, (), False, None, (
        ('kindOfObject', (), IcePy._t_string, False, 0),
        ('id', (), IcePy._t_string, False, 0)
    ))
    NotRegisteredException._ice_type = _M_Ice._t_NotRegisteredException

    _M_Ice.NotRegisteredException = NotRegisteredException
    del NotRegisteredException

if 'TwowayOnlyException' not in _M_Ice.__dict__:
    _M_Ice.TwowayOnlyException = Ice.createTempClass()
    class TwowayOnlyException(Ice.LocalException):
        '''The operation can only be invoked with a twoway request.

This exception is raised if an attempt is made to invoke an
operation with ice_oneway, ice_batchOneway, ice_datagram,
or ice_batchDatagram and the operation has a return value,
out-parameters, or an exception specification.'''
        def __init__(self, operation=''):
            self.operation = operation

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::TwowayOnlyException'

    _M_Ice._t_TwowayOnlyException = IcePy.defineException('::Ice::TwowayOnlyException', TwowayOnlyException, (), False, None, (('operation', (), IcePy._t_string, False, 0),))
    TwowayOnlyException._ice_type = _M_Ice._t_TwowayOnlyException

    _M_Ice.TwowayOnlyException = TwowayOnlyException
    del TwowayOnlyException

if 'CloneNotImplementedException' not in _M_Ice.__dict__:
    _M_Ice.CloneNotImplementedException = Ice.createTempClass()
    class CloneNotImplementedException(Ice.LocalException):
        '''An attempt was made to clone a class that does not support
cloning.

This exception is raised if ice_clone is called on
a class that is derived from an abstract Slice class (that is,
a class containing operations), and the derived class does not
provide an implementation of the ice_clone operation (C++ only).'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::CloneNotImplementedException'

    _M_Ice._t_CloneNotImplementedException = IcePy.defineException('::Ice::CloneNotImplementedException', CloneNotImplementedException, (), False, None, ())
    CloneNotImplementedException._ice_type = _M_Ice._t_CloneNotImplementedException

    _M_Ice.CloneNotImplementedException = CloneNotImplementedException
    del CloneNotImplementedException

if 'UnknownException' not in _M_Ice.__dict__:
    _M_Ice.UnknownException = Ice.createTempClass()
    class UnknownException(Ice.LocalException):
        '''This exception is raised if an operation call on a server raises an
unknown exception. For example, for C++, this exception is raised
if the server throws a C++ exception that is not directly or
indirectly derived from Ice::LocalException or
Ice::UserException.'''
        def __init__(self, unknown=''):
            self.unknown = unknown

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::UnknownException'

    _M_Ice._t_UnknownException = IcePy.defineException('::Ice::UnknownException', UnknownException, (), False, None, (('unknown', (), IcePy._t_string, False, 0),))
    UnknownException._ice_type = _M_Ice._t_UnknownException

    _M_Ice.UnknownException = UnknownException
    del UnknownException

if 'UnknownLocalException' not in _M_Ice.__dict__:
    _M_Ice.UnknownLocalException = Ice.createTempClass()
    class UnknownLocalException(_M_Ice.UnknownException):
        '''This exception is raised if an operation call on a server raises a
local exception. Because local exceptions are not transmitted by
the Ice protocol, the client receives all local exceptions raised
by the server as UnknownLocalException. The only exception to this
rule are all exceptions derived from RequestFailedException,
which are transmitted by the Ice protocol even though they are
declared local.'''
        def __init__(self, unknown=''):
            _M_Ice.UnknownException.__init__(self, unknown)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::UnknownLocalException'

    _M_Ice._t_UnknownLocalException = IcePy.defineException('::Ice::UnknownLocalException', UnknownLocalException, (), False, _M_Ice._t_UnknownException, ())
    UnknownLocalException._ice_type = _M_Ice._t_UnknownLocalException

    _M_Ice.UnknownLocalException = UnknownLocalException
    del UnknownLocalException

if 'UnknownUserException' not in _M_Ice.__dict__:
    _M_Ice.UnknownUserException = Ice.createTempClass()
    class UnknownUserException(_M_Ice.UnknownException):
        '''An operation raised an incorrect user exception.

This exception is raised if an operation raises a
user exception that is not declared in the exception's
throws clause. Such undeclared exceptions are
not transmitted from the server to the client by the Ice
protocol, but instead the client just gets an
UnknownUserException. This is necessary in order to not violate
the contract established by an operation's signature: Only local
exceptions and user exceptions declared in the
throws clause can be raised.'''
        def __init__(self, unknown=''):
            _M_Ice.UnknownException.__init__(self, unknown)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::UnknownUserException'

    _M_Ice._t_UnknownUserException = IcePy.defineException('::Ice::UnknownUserException', UnknownUserException, (), False, _M_Ice._t_UnknownException, ())
    UnknownUserException._ice_type = _M_Ice._t_UnknownUserException

    _M_Ice.UnknownUserException = UnknownUserException
    del UnknownUserException

if 'VersionMismatchException' not in _M_Ice.__dict__:
    _M_Ice.VersionMismatchException = Ice.createTempClass()
    class VersionMismatchException(Ice.LocalException):
        '''This exception is raised if the Ice library version does not match
the version in the Ice header files.'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::VersionMismatchException'

    _M_Ice._t_VersionMismatchException = IcePy.defineException('::Ice::VersionMismatchException', VersionMismatchException, (), False, None, ())
    VersionMismatchException._ice_type = _M_Ice._t_VersionMismatchException

    _M_Ice.VersionMismatchException = VersionMismatchException
    del VersionMismatchException

if 'CommunicatorDestroyedException' not in _M_Ice.__dict__:
    _M_Ice.CommunicatorDestroyedException = Ice.createTempClass()
    class CommunicatorDestroyedException(Ice.LocalException):
        '''This exception is raised if the Communicator has been destroyed.'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::CommunicatorDestroyedException'

    _M_Ice._t_CommunicatorDestroyedException = IcePy.defineException('::Ice::CommunicatorDestroyedException', CommunicatorDestroyedException, (), False, None, ())
    CommunicatorDestroyedException._ice_type = _M_Ice._t_CommunicatorDestroyedException

    _M_Ice.CommunicatorDestroyedException = CommunicatorDestroyedException
    del CommunicatorDestroyedException

if 'ObjectAdapterDeactivatedException' not in _M_Ice.__dict__:
    _M_Ice.ObjectAdapterDeactivatedException = Ice.createTempClass()
    class ObjectAdapterDeactivatedException(Ice.LocalException):
        '''This exception is raised if an attempt is made to use a deactivated
ObjectAdapter.'''
        def __init__(self, name=''):
            self.name = name

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ObjectAdapterDeactivatedException'

    _M_Ice._t_ObjectAdapterDeactivatedException = IcePy.defineException('::Ice::ObjectAdapterDeactivatedException', ObjectAdapterDeactivatedException, (), False, None, (('name', (), IcePy._t_string, False, 0),))
    ObjectAdapterDeactivatedException._ice_type = _M_Ice._t_ObjectAdapterDeactivatedException

    _M_Ice.ObjectAdapterDeactivatedException = ObjectAdapterDeactivatedException
    del ObjectAdapterDeactivatedException

if 'ObjectAdapterIdInUseException' not in _M_Ice.__dict__:
    _M_Ice.ObjectAdapterIdInUseException = Ice.createTempClass()
    class ObjectAdapterIdInUseException(Ice.LocalException):
        '''This exception is raised if an ObjectAdapter cannot be activated.

This happens if the Locator detects another active ObjectAdapter with
the same adapter id.'''
        def __init__(self, id=''):
            self.id = id

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ObjectAdapterIdInUseException'

    _M_Ice._t_ObjectAdapterIdInUseException = IcePy.defineException('::Ice::ObjectAdapterIdInUseException', ObjectAdapterIdInUseException, (), False, None, (('id', (), IcePy._t_string, False, 0),))
    ObjectAdapterIdInUseException._ice_type = _M_Ice._t_ObjectAdapterIdInUseException

    _M_Ice.ObjectAdapterIdInUseException = ObjectAdapterIdInUseException
    del ObjectAdapterIdInUseException

if 'NoEndpointException' not in _M_Ice.__dict__:
    _M_Ice.NoEndpointException = Ice.createTempClass()
    class NoEndpointException(Ice.LocalException):
        '''This exception is raised if no suitable endpoint is available.'''
        def __init__(self, proxy=''):
            self.proxy = proxy

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::NoEndpointException'

    _M_Ice._t_NoEndpointException = IcePy.defineException('::Ice::NoEndpointException', NoEndpointException, (), False, None, (('proxy', (), IcePy._t_string, False, 0),))
    NoEndpointException._ice_type = _M_Ice._t_NoEndpointException

    _M_Ice.NoEndpointException = NoEndpointException
    del NoEndpointException

if 'EndpointParseException' not in _M_Ice.__dict__:
    _M_Ice.EndpointParseException = Ice.createTempClass()
    class EndpointParseException(Ice.LocalException):
        '''This exception is raised if there was an error while parsing an
endpoint.'''
        def __init__(self, str=''):
            self.str = str

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::EndpointParseException'

    _M_Ice._t_EndpointParseException = IcePy.defineException('::Ice::EndpointParseException', EndpointParseException, (), False, None, (('str', (), IcePy._t_string, False, 0),))
    EndpointParseException._ice_type = _M_Ice._t_EndpointParseException

    _M_Ice.EndpointParseException = EndpointParseException
    del EndpointParseException

if 'EndpointSelectionTypeParseException' not in _M_Ice.__dict__:
    _M_Ice.EndpointSelectionTypeParseException = Ice.createTempClass()
    class EndpointSelectionTypeParseException(Ice.LocalException):
        '''This exception is raised if there was an error while parsing an
endpoint selection type.'''
        def __init__(self, str=''):
            self.str = str

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::EndpointSelectionTypeParseException'

    _M_Ice._t_EndpointSelectionTypeParseException = IcePy.defineException('::Ice::EndpointSelectionTypeParseException', EndpointSelectionTypeParseException, (), False, None, (('str', (), IcePy._t_string, False, 0),))
    EndpointSelectionTypeParseException._ice_type = _M_Ice._t_EndpointSelectionTypeParseException

    _M_Ice.EndpointSelectionTypeParseException = EndpointSelectionTypeParseException
    del EndpointSelectionTypeParseException

if 'VersionParseException' not in _M_Ice.__dict__:
    _M_Ice.VersionParseException = Ice.createTempClass()
    class VersionParseException(Ice.LocalException):
        '''This exception is raised if there was an error while parsing a
version.'''
        def __init__(self, str=''):
            self.str = str

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::VersionParseException'

    _M_Ice._t_VersionParseException = IcePy.defineException('::Ice::VersionParseException', VersionParseException, (), False, None, (('str', (), IcePy._t_string, False, 0),))
    VersionParseException._ice_type = _M_Ice._t_VersionParseException

    _M_Ice.VersionParseException = VersionParseException
    del VersionParseException

if 'IdentityParseException' not in _M_Ice.__dict__:
    _M_Ice.IdentityParseException = Ice.createTempClass()
    class IdentityParseException(Ice.LocalException):
        '''This exception is raised if there was an error while parsing a
stringified identity.'''
        def __init__(self, str=''):
            self.str = str

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::IdentityParseException'

    _M_Ice._t_IdentityParseException = IcePy.defineException('::Ice::IdentityParseException', IdentityParseException, (), False, None, (('str', (), IcePy._t_string, False, 0),))
    IdentityParseException._ice_type = _M_Ice._t_IdentityParseException

    _M_Ice.IdentityParseException = IdentityParseException
    del IdentityParseException

if 'ProxyParseException' not in _M_Ice.__dict__:
    _M_Ice.ProxyParseException = Ice.createTempClass()
    class ProxyParseException(Ice.LocalException):
        '''This exception is raised if there was an error while parsing a
stringified proxy.'''
        def __init__(self, str=''):
            self.str = str

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ProxyParseException'

    _M_Ice._t_ProxyParseException = IcePy.defineException('::Ice::ProxyParseException', ProxyParseException, (), False, None, (('str', (), IcePy._t_string, False, 0),))
    ProxyParseException._ice_type = _M_Ice._t_ProxyParseException

    _M_Ice.ProxyParseException = ProxyParseException
    del ProxyParseException

if 'IllegalIdentityException' not in _M_Ice.__dict__:
    _M_Ice.IllegalIdentityException = Ice.createTempClass()
    class IllegalIdentityException(Ice.LocalException):
        '''This exception is raised if an illegal identity is encountered.'''
        def __init__(self, id=Ice._struct_marker):
            if id is Ice._struct_marker:
                self.id = _M_Ice.Identity()
            else:
                self.id = id

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::IllegalIdentityException'

    _M_Ice._t_IllegalIdentityException = IcePy.defineException('::Ice::IllegalIdentityException', IllegalIdentityException, (), False, None, (('id', (), _M_Ice._t_Identity, False, 0),))
    IllegalIdentityException._ice_type = _M_Ice._t_IllegalIdentityException

    _M_Ice.IllegalIdentityException = IllegalIdentityException
    del IllegalIdentityException

if 'IllegalServantException' not in _M_Ice.__dict__:
    _M_Ice.IllegalServantException = Ice.createTempClass()
    class IllegalServantException(Ice.LocalException):
        '''This exception is raised to reject an illegal servant (typically
a null servant)'''
        def __init__(self, reason=''):
            self.reason = reason

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::IllegalServantException'

    _M_Ice._t_IllegalServantException = IcePy.defineException('::Ice::IllegalServantException', IllegalServantException, (), False, None, (('reason', (), IcePy._t_string, False, 0),))
    IllegalServantException._ice_type = _M_Ice._t_IllegalServantException

    _M_Ice.IllegalServantException = IllegalServantException
    del IllegalServantException

if 'RequestFailedException' not in _M_Ice.__dict__:
    _M_Ice.RequestFailedException = Ice.createTempClass()
    class RequestFailedException(Ice.LocalException):
        '''This exception is raised if a request failed. This exception, and
all exceptions derived from RequestFailedException, are
transmitted by the Ice protocol, even though they are declared
local.'''
        def __init__(self, id=Ice._struct_marker, facet='', operation=''):
            if id is Ice._struct_marker:
                self.id = _M_Ice.Identity()
            else:
                self.id = id
            self.facet = facet
            self.operation = operation

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::RequestFailedException'

    _M_Ice._t_RequestFailedException = IcePy.defineException('::Ice::RequestFailedException', RequestFailedException, (), False, None, (
        ('id', (), _M_Ice._t_Identity, False, 0),
        ('facet', (), IcePy._t_string, False, 0),
        ('operation', (), IcePy._t_string, False, 0)
    ))
    RequestFailedException._ice_type = _M_Ice._t_RequestFailedException

    _M_Ice.RequestFailedException = RequestFailedException
    del RequestFailedException

if 'ObjectNotExistException' not in _M_Ice.__dict__:
    _M_Ice.ObjectNotExistException = Ice.createTempClass()
    class ObjectNotExistException(_M_Ice.RequestFailedException):
        '''This exception is raised if an object does not exist on the server,
that is, if no facets with the given identity exist.'''
        def __init__(self, id=Ice._struct_marker, facet='', operation=''):
            _M_Ice.RequestFailedException.__init__(self, id, facet, operation)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ObjectNotExistException'

    _M_Ice._t_ObjectNotExistException = IcePy.defineException('::Ice::ObjectNotExistException', ObjectNotExistException, (), False, _M_Ice._t_RequestFailedException, ())
    ObjectNotExistException._ice_type = _M_Ice._t_ObjectNotExistException

    _M_Ice.ObjectNotExistException = ObjectNotExistException
    del ObjectNotExistException

if 'FacetNotExistException' not in _M_Ice.__dict__:
    _M_Ice.FacetNotExistException = Ice.createTempClass()
    class FacetNotExistException(_M_Ice.RequestFailedException):
        '''This exception is raised if no facet with the given name exists,
but at least one facet with the given identity exists.'''
        def __init__(self, id=Ice._struct_marker, facet='', operation=''):
            _M_Ice.RequestFailedException.__init__(self, id, facet, operation)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::FacetNotExistException'

    _M_Ice._t_FacetNotExistException = IcePy.defineException('::Ice::FacetNotExistException', FacetNotExistException, (), False, _M_Ice._t_RequestFailedException, ())
    FacetNotExistException._ice_type = _M_Ice._t_FacetNotExistException

    _M_Ice.FacetNotExistException = FacetNotExistException
    del FacetNotExistException

if 'OperationNotExistException' not in _M_Ice.__dict__:
    _M_Ice.OperationNotExistException = Ice.createTempClass()
    class OperationNotExistException(_M_Ice.RequestFailedException):
        '''This exception is raised if an operation for a given object does
not exist on the server. Typically this is caused by either the
client or the server using an outdated Slice specification.'''
        def __init__(self, id=Ice._struct_marker, facet='', operation=''):
            _M_Ice.RequestFailedException.__init__(self, id, facet, operation)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::OperationNotExistException'

    _M_Ice._t_OperationNotExistException = IcePy.defineException('::Ice::OperationNotExistException', OperationNotExistException, (), False, _M_Ice._t_RequestFailedException, ())
    OperationNotExistException._ice_type = _M_Ice._t_OperationNotExistException

    _M_Ice.OperationNotExistException = OperationNotExistException
    del OperationNotExistException

if 'SyscallException' not in _M_Ice.__dict__:
    _M_Ice.SyscallException = Ice.createTempClass()
    class SyscallException(Ice.LocalException):
        '''This exception is raised if a system error occurred in the server
or client process. There are many possible causes for such a system
exception. For details on the cause, SyscallException#error
should be inspected.'''
        def __init__(self, error=0):
            self.error = error

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::SyscallException'

    _M_Ice._t_SyscallException = IcePy.defineException('::Ice::SyscallException', SyscallException, (), False, None, (('error', (), IcePy._t_int, False, 0),))
    SyscallException._ice_type = _M_Ice._t_SyscallException

    _M_Ice.SyscallException = SyscallException
    del SyscallException

if 'SocketException' not in _M_Ice.__dict__:
    _M_Ice.SocketException = Ice.createTempClass()
    class SocketException(_M_Ice.SyscallException):
        '''This exception indicates socket errors.'''
        def __init__(self, error=0):
            _M_Ice.SyscallException.__init__(self, error)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::SocketException'

    _M_Ice._t_SocketException = IcePy.defineException('::Ice::SocketException', SocketException, (), False, _M_Ice._t_SyscallException, ())
    SocketException._ice_type = _M_Ice._t_SocketException

    _M_Ice.SocketException = SocketException
    del SocketException

if 'FileException' not in _M_Ice.__dict__:
    _M_Ice.FileException = Ice.createTempClass()
    class FileException(_M_Ice.SyscallException):
        '''This exception indicates file errors.'''
        def __init__(self, error=0, path=''):
            _M_Ice.SyscallException.__init__(self, error)
            self.path = path

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::FileException'

    _M_Ice._t_FileException = IcePy.defineException('::Ice::FileException', FileException, (), False, _M_Ice._t_SyscallException, (('path', (), IcePy._t_string, False, 0),))
    FileException._ice_type = _M_Ice._t_FileException

    _M_Ice.FileException = FileException
    del FileException

if 'ConnectFailedException' not in _M_Ice.__dict__:
    _M_Ice.ConnectFailedException = Ice.createTempClass()
    class ConnectFailedException(_M_Ice.SocketException):
        '''This exception indicates connection failures.'''
        def __init__(self, error=0):
            _M_Ice.SocketException.__init__(self, error)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ConnectFailedException'

    _M_Ice._t_ConnectFailedException = IcePy.defineException('::Ice::ConnectFailedException', ConnectFailedException, (), False, _M_Ice._t_SocketException, ())
    ConnectFailedException._ice_type = _M_Ice._t_ConnectFailedException

    _M_Ice.ConnectFailedException = ConnectFailedException
    del ConnectFailedException

if 'ConnectionRefusedException' not in _M_Ice.__dict__:
    _M_Ice.ConnectionRefusedException = Ice.createTempClass()
    class ConnectionRefusedException(_M_Ice.ConnectFailedException):
        '''This exception indicates a connection failure for which
the server host actively refuses a connection.'''
        def __init__(self, error=0):
            _M_Ice.ConnectFailedException.__init__(self, error)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ConnectionRefusedException'

    _M_Ice._t_ConnectionRefusedException = IcePy.defineException('::Ice::ConnectionRefusedException', ConnectionRefusedException, (), False, _M_Ice._t_ConnectFailedException, ())
    ConnectionRefusedException._ice_type = _M_Ice._t_ConnectionRefusedException

    _M_Ice.ConnectionRefusedException = ConnectionRefusedException
    del ConnectionRefusedException

if 'ConnectionLostException' not in _M_Ice.__dict__:
    _M_Ice.ConnectionLostException = Ice.createTempClass()
    class ConnectionLostException(_M_Ice.SocketException):
        '''This exception indicates a lost connection.'''
        def __init__(self, error=0):
            _M_Ice.SocketException.__init__(self, error)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ConnectionLostException'

    _M_Ice._t_ConnectionLostException = IcePy.defineException('::Ice::ConnectionLostException', ConnectionLostException, (), False, _M_Ice._t_SocketException, ())
    ConnectionLostException._ice_type = _M_Ice._t_ConnectionLostException

    _M_Ice.ConnectionLostException = ConnectionLostException
    del ConnectionLostException

if 'DNSException' not in _M_Ice.__dict__:
    _M_Ice.DNSException = Ice.createTempClass()
    class DNSException(Ice.LocalException):
        '''This exception indicates a DNS problem. For details on the cause,
DNSException#error should be inspected.'''
        def __init__(self, error=0, host=''):
            self.error = error
            self.host = host

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::DNSException'

    _M_Ice._t_DNSException = IcePy.defineException('::Ice::DNSException', DNSException, (), False, None, (
        ('error', (), IcePy._t_int, False, 0),
        ('host', (), IcePy._t_string, False, 0)
    ))
    DNSException._ice_type = _M_Ice._t_DNSException

    _M_Ice.DNSException = DNSException
    del DNSException

if 'OperationInterruptedException' not in _M_Ice.__dict__:
    _M_Ice.OperationInterruptedException = Ice.createTempClass()
    class OperationInterruptedException(Ice.LocalException):
        '''This exception indicates a request was interrupted.'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::OperationInterruptedException'

    _M_Ice._t_OperationInterruptedException = IcePy.defineException('::Ice::OperationInterruptedException', OperationInterruptedException, (), False, None, ())
    OperationInterruptedException._ice_type = _M_Ice._t_OperationInterruptedException

    _M_Ice.OperationInterruptedException = OperationInterruptedException
    del OperationInterruptedException

if 'TimeoutException' not in _M_Ice.__dict__:
    _M_Ice.TimeoutException = Ice.createTempClass()
    class TimeoutException(Ice.LocalException):
        '''This exception indicates a timeout condition.'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::TimeoutException'

    _M_Ice._t_TimeoutException = IcePy.defineException('::Ice::TimeoutException', TimeoutException, (), False, None, ())
    TimeoutException._ice_type = _M_Ice._t_TimeoutException

    _M_Ice.TimeoutException = TimeoutException
    del TimeoutException

if 'ConnectTimeoutException' not in _M_Ice.__dict__:
    _M_Ice.ConnectTimeoutException = Ice.createTempClass()
    class ConnectTimeoutException(_M_Ice.TimeoutException):
        '''This exception indicates a connection establishment timeout condition.'''
        def __init__(self):
            _M_Ice.TimeoutException.__init__(self)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ConnectTimeoutException'

    _M_Ice._t_ConnectTimeoutException = IcePy.defineException('::Ice::ConnectTimeoutException', ConnectTimeoutException, (), False, _M_Ice._t_TimeoutException, ())
    ConnectTimeoutException._ice_type = _M_Ice._t_ConnectTimeoutException

    _M_Ice.ConnectTimeoutException = ConnectTimeoutException
    del ConnectTimeoutException

if 'CloseTimeoutException' not in _M_Ice.__dict__:
    _M_Ice.CloseTimeoutException = Ice.createTempClass()
    class CloseTimeoutException(_M_Ice.TimeoutException):
        '''This exception indicates a connection closure timeout condition.'''
        def __init__(self):
            _M_Ice.TimeoutException.__init__(self)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::CloseTimeoutException'

    _M_Ice._t_CloseTimeoutException = IcePy.defineException('::Ice::CloseTimeoutException', CloseTimeoutException, (), False, _M_Ice._t_TimeoutException, ())
    CloseTimeoutException._ice_type = _M_Ice._t_CloseTimeoutException

    _M_Ice.CloseTimeoutException = CloseTimeoutException
    del CloseTimeoutException

if 'ConnectionTimeoutException' not in _M_Ice.__dict__:
    _M_Ice.ConnectionTimeoutException = Ice.createTempClass()
    class ConnectionTimeoutException(_M_Ice.TimeoutException):
        '''This exception indicates that a connection has been shut down because it has been
idle for some time.'''
        def __init__(self):
            _M_Ice.TimeoutException.__init__(self)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ConnectionTimeoutException'

    _M_Ice._t_ConnectionTimeoutException = IcePy.defineException('::Ice::ConnectionTimeoutException', ConnectionTimeoutException, (), False, _M_Ice._t_TimeoutException, ())
    ConnectionTimeoutException._ice_type = _M_Ice._t_ConnectionTimeoutException

    _M_Ice.ConnectionTimeoutException = ConnectionTimeoutException
    del ConnectionTimeoutException

if 'InvocationTimeoutException' not in _M_Ice.__dict__:
    _M_Ice.InvocationTimeoutException = Ice.createTempClass()
    class InvocationTimeoutException(_M_Ice.TimeoutException):
        '''This exception indicates that an invocation failed because it timed
out.'''
        def __init__(self):
            _M_Ice.TimeoutException.__init__(self)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::InvocationTimeoutException'

    _M_Ice._t_InvocationTimeoutException = IcePy.defineException('::Ice::InvocationTimeoutException', InvocationTimeoutException, (), False, _M_Ice._t_TimeoutException, ())
    InvocationTimeoutException._ice_type = _M_Ice._t_InvocationTimeoutException

    _M_Ice.InvocationTimeoutException = InvocationTimeoutException
    del InvocationTimeoutException

if 'InvocationCanceledException' not in _M_Ice.__dict__:
    _M_Ice.InvocationCanceledException = Ice.createTempClass()
    class InvocationCanceledException(Ice.LocalException):
        '''This exception indicates that an asynchronous invocation failed
because it was canceled explicitly by the user using the
Ice::AsyncResult::cancel method.'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::InvocationCanceledException'

    _M_Ice._t_InvocationCanceledException = IcePy.defineException('::Ice::InvocationCanceledException', InvocationCanceledException, (), False, None, ())
    InvocationCanceledException._ice_type = _M_Ice._t_InvocationCanceledException

    _M_Ice.InvocationCanceledException = InvocationCanceledException
    del InvocationCanceledException

if 'ProtocolException' not in _M_Ice.__dict__:
    _M_Ice.ProtocolException = Ice.createTempClass()
    class ProtocolException(Ice.LocalException):
        '''A generic exception base for all kinds of protocol error
conditions.'''
        def __init__(self, reason=''):
            self.reason = reason

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ProtocolException'

    _M_Ice._t_ProtocolException = IcePy.defineException('::Ice::ProtocolException', ProtocolException, (), False, None, (('reason', (), IcePy._t_string, False, 0),))
    ProtocolException._ice_type = _M_Ice._t_ProtocolException

    _M_Ice.ProtocolException = ProtocolException
    del ProtocolException

if 'BadMagicException' not in _M_Ice.__dict__:
    _M_Ice.BadMagicException = Ice.createTempClass()
    class BadMagicException(_M_Ice.ProtocolException):
        '''This exception indicates that a message did not start with the expected
magic number ('I', 'c', 'e', 'P').'''
        def __init__(self, reason='', badMagic=None):
            _M_Ice.ProtocolException.__init__(self, reason)
            self.badMagic = badMagic

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::BadMagicException'

    _M_Ice._t_BadMagicException = IcePy.defineException('::Ice::BadMagicException', BadMagicException, (), False, _M_Ice._t_ProtocolException, (('badMagic', (), _M_Ice._t_ByteSeq, False, 0),))
    BadMagicException._ice_type = _M_Ice._t_BadMagicException

    _M_Ice.BadMagicException = BadMagicException
    del BadMagicException

if 'UnsupportedProtocolException' not in _M_Ice.__dict__:
    _M_Ice.UnsupportedProtocolException = Ice.createTempClass()
    class UnsupportedProtocolException(_M_Ice.ProtocolException):
        '''This exception indicates an unsupported protocol version.'''
        def __init__(self, reason='', bad=Ice._struct_marker, supported=Ice._struct_marker):
            _M_Ice.ProtocolException.__init__(self, reason)
            if bad is Ice._struct_marker:
                self.bad = _M_Ice.ProtocolVersion()
            else:
                self.bad = bad
            if supported is Ice._struct_marker:
                self.supported = _M_Ice.ProtocolVersion()
            else:
                self.supported = supported

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::UnsupportedProtocolException'

    _M_Ice._t_UnsupportedProtocolException = IcePy.defineException('::Ice::UnsupportedProtocolException', UnsupportedProtocolException, (), False, _M_Ice._t_ProtocolException, (
        ('bad', (), _M_Ice._t_ProtocolVersion, False, 0),
        ('supported', (), _M_Ice._t_ProtocolVersion, False, 0)
    ))
    UnsupportedProtocolException._ice_type = _M_Ice._t_UnsupportedProtocolException

    _M_Ice.UnsupportedProtocolException = UnsupportedProtocolException
    del UnsupportedProtocolException

if 'UnsupportedEncodingException' not in _M_Ice.__dict__:
    _M_Ice.UnsupportedEncodingException = Ice.createTempClass()
    class UnsupportedEncodingException(_M_Ice.ProtocolException):
        '''This exception indicates an unsupported data encoding version.'''
        def __init__(self, reason='', bad=Ice._struct_marker, supported=Ice._struct_marker):
            _M_Ice.ProtocolException.__init__(self, reason)
            if bad is Ice._struct_marker:
                self.bad = _M_Ice.EncodingVersion()
            else:
                self.bad = bad
            if supported is Ice._struct_marker:
                self.supported = _M_Ice.EncodingVersion()
            else:
                self.supported = supported

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::UnsupportedEncodingException'

    _M_Ice._t_UnsupportedEncodingException = IcePy.defineException('::Ice::UnsupportedEncodingException', UnsupportedEncodingException, (), False, _M_Ice._t_ProtocolException, (
        ('bad', (), _M_Ice._t_EncodingVersion, False, 0),
        ('supported', (), _M_Ice._t_EncodingVersion, False, 0)
    ))
    UnsupportedEncodingException._ice_type = _M_Ice._t_UnsupportedEncodingException

    _M_Ice.UnsupportedEncodingException = UnsupportedEncodingException
    del UnsupportedEncodingException

if 'UnknownMessageException' not in _M_Ice.__dict__:
    _M_Ice.UnknownMessageException = Ice.createTempClass()
    class UnknownMessageException(_M_Ice.ProtocolException):
        '''This exception indicates that an unknown protocol message has been received.'''
        def __init__(self, reason=''):
            _M_Ice.ProtocolException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::UnknownMessageException'

    _M_Ice._t_UnknownMessageException = IcePy.defineException('::Ice::UnknownMessageException', UnknownMessageException, (), False, _M_Ice._t_ProtocolException, ())
    UnknownMessageException._ice_type = _M_Ice._t_UnknownMessageException

    _M_Ice.UnknownMessageException = UnknownMessageException
    del UnknownMessageException

if 'ConnectionNotValidatedException' not in _M_Ice.__dict__:
    _M_Ice.ConnectionNotValidatedException = Ice.createTempClass()
    class ConnectionNotValidatedException(_M_Ice.ProtocolException):
        '''This exception is raised if a message is received over a connection
that is not yet validated.'''
        def __init__(self, reason=''):
            _M_Ice.ProtocolException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ConnectionNotValidatedException'

    _M_Ice._t_ConnectionNotValidatedException = IcePy.defineException('::Ice::ConnectionNotValidatedException', ConnectionNotValidatedException, (), False, _M_Ice._t_ProtocolException, ())
    ConnectionNotValidatedException._ice_type = _M_Ice._t_ConnectionNotValidatedException

    _M_Ice.ConnectionNotValidatedException = ConnectionNotValidatedException
    del ConnectionNotValidatedException

if 'UnknownRequestIdException' not in _M_Ice.__dict__:
    _M_Ice.UnknownRequestIdException = Ice.createTempClass()
    class UnknownRequestIdException(_M_Ice.ProtocolException):
        '''This exception indicates that a response for an unknown request ID has been
received.'''
        def __init__(self, reason=''):
            _M_Ice.ProtocolException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::UnknownRequestIdException'

    _M_Ice._t_UnknownRequestIdException = IcePy.defineException('::Ice::UnknownRequestIdException', UnknownRequestIdException, (), False, _M_Ice._t_ProtocolException, ())
    UnknownRequestIdException._ice_type = _M_Ice._t_UnknownRequestIdException

    _M_Ice.UnknownRequestIdException = UnknownRequestIdException
    del UnknownRequestIdException

if 'UnknownReplyStatusException' not in _M_Ice.__dict__:
    _M_Ice.UnknownReplyStatusException = Ice.createTempClass()
    class UnknownReplyStatusException(_M_Ice.ProtocolException):
        '''This exception indicates that an unknown reply status has been received.'''
        def __init__(self, reason=''):
            _M_Ice.ProtocolException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::UnknownReplyStatusException'

    _M_Ice._t_UnknownReplyStatusException = IcePy.defineException('::Ice::UnknownReplyStatusException', UnknownReplyStatusException, (), False, _M_Ice._t_ProtocolException, ())
    UnknownReplyStatusException._ice_type = _M_Ice._t_UnknownReplyStatusException

    _M_Ice.UnknownReplyStatusException = UnknownReplyStatusException
    del UnknownReplyStatusException

if 'CloseConnectionException' not in _M_Ice.__dict__:
    _M_Ice.CloseConnectionException = Ice.createTempClass()
    class CloseConnectionException(_M_Ice.ProtocolException):
        '''This exception indicates that the connection has been gracefully shut down by the
server. The operation call that caused this exception has not been
executed by the server. In most cases you will not get this
exception, because the client will automatically retry the
operation call in case the server shut down the connection. However,
if upon retry the server shuts down the connection again, and the
retry limit has been reached, then this exception is propagated to
the application code.'''
        def __init__(self, reason=''):
            _M_Ice.ProtocolException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::CloseConnectionException'

    _M_Ice._t_CloseConnectionException = IcePy.defineException('::Ice::CloseConnectionException', CloseConnectionException, (), False, _M_Ice._t_ProtocolException, ())
    CloseConnectionException._ice_type = _M_Ice._t_CloseConnectionException

    _M_Ice.CloseConnectionException = CloseConnectionException
    del CloseConnectionException

if 'ForcedCloseConnectionException' not in _M_Ice.__dict__:
    _M_Ice.ForcedCloseConnectionException = Ice.createTempClass()
    class ForcedCloseConnectionException(_M_Ice.ProtocolException):
        '''This exception is raised by an operation call if the application
forcefully closes the connection Connection#close.'''
        def __init__(self, reason=''):
            _M_Ice.ProtocolException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ForcedCloseConnectionException'

    _M_Ice._t_ForcedCloseConnectionException = IcePy.defineException('::Ice::ForcedCloseConnectionException', ForcedCloseConnectionException, (), False, _M_Ice._t_ProtocolException, ())
    ForcedCloseConnectionException._ice_type = _M_Ice._t_ForcedCloseConnectionException

    _M_Ice.ForcedCloseConnectionException = ForcedCloseConnectionException
    del ForcedCloseConnectionException

if 'IllegalMessageSizeException' not in _M_Ice.__dict__:
    _M_Ice.IllegalMessageSizeException = Ice.createTempClass()
    class IllegalMessageSizeException(_M_Ice.ProtocolException):
        '''This exception indicates that a message size is less
than the minimum required size.'''
        def __init__(self, reason=''):
            _M_Ice.ProtocolException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::IllegalMessageSizeException'

    _M_Ice._t_IllegalMessageSizeException = IcePy.defineException('::Ice::IllegalMessageSizeException', IllegalMessageSizeException, (), False, _M_Ice._t_ProtocolException, ())
    IllegalMessageSizeException._ice_type = _M_Ice._t_IllegalMessageSizeException

    _M_Ice.IllegalMessageSizeException = IllegalMessageSizeException
    del IllegalMessageSizeException

if 'CompressionException' not in _M_Ice.__dict__:
    _M_Ice.CompressionException = Ice.createTempClass()
    class CompressionException(_M_Ice.ProtocolException):
        '''This exception indicates a problem with compressing or uncompressing data.'''
        def __init__(self, reason=''):
            _M_Ice.ProtocolException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::CompressionException'

    _M_Ice._t_CompressionException = IcePy.defineException('::Ice::CompressionException', CompressionException, (), False, _M_Ice._t_ProtocolException, ())
    CompressionException._ice_type = _M_Ice._t_CompressionException

    _M_Ice.CompressionException = CompressionException
    del CompressionException

if 'DatagramLimitException' not in _M_Ice.__dict__:
    _M_Ice.DatagramLimitException = Ice.createTempClass()
    class DatagramLimitException(_M_Ice.ProtocolException):
        '''A datagram exceeds the configured size.

This exception is raised if a datagram exceeds the configured send or receive buffer
size, or exceeds the maximum payload size of a UDP packet (65507 bytes).'''
        def __init__(self, reason=''):
            _M_Ice.ProtocolException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::DatagramLimitException'

    _M_Ice._t_DatagramLimitException = IcePy.defineException('::Ice::DatagramLimitException', DatagramLimitException, (), False, _M_Ice._t_ProtocolException, ())
    DatagramLimitException._ice_type = _M_Ice._t_DatagramLimitException

    _M_Ice.DatagramLimitException = DatagramLimitException
    del DatagramLimitException

if 'MarshalException' not in _M_Ice.__dict__:
    _M_Ice.MarshalException = Ice.createTempClass()
    class MarshalException(_M_Ice.ProtocolException):
        '''This exception is raised for errors during marshaling or unmarshaling data.'''
        def __init__(self, reason=''):
            _M_Ice.ProtocolException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::MarshalException'

    _M_Ice._t_MarshalException = IcePy.defineException('::Ice::MarshalException', MarshalException, (), False, _M_Ice._t_ProtocolException, ())
    MarshalException._ice_type = _M_Ice._t_MarshalException

    _M_Ice.MarshalException = MarshalException
    del MarshalException

if 'ProxyUnmarshalException' not in _M_Ice.__dict__:
    _M_Ice.ProxyUnmarshalException = Ice.createTempClass()
    class ProxyUnmarshalException(_M_Ice.MarshalException):
        '''This exception is raised if inconsistent data is received while unmarshaling a proxy.'''
        def __init__(self, reason=''):
            _M_Ice.MarshalException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ProxyUnmarshalException'

    _M_Ice._t_ProxyUnmarshalException = IcePy.defineException('::Ice::ProxyUnmarshalException', ProxyUnmarshalException, (), False, _M_Ice._t_MarshalException, ())
    ProxyUnmarshalException._ice_type = _M_Ice._t_ProxyUnmarshalException

    _M_Ice.ProxyUnmarshalException = ProxyUnmarshalException
    del ProxyUnmarshalException

if 'UnmarshalOutOfBoundsException' not in _M_Ice.__dict__:
    _M_Ice.UnmarshalOutOfBoundsException = Ice.createTempClass()
    class UnmarshalOutOfBoundsException(_M_Ice.MarshalException):
        '''This exception is raised if an out-of-bounds condition occurs during unmarshaling.'''
        def __init__(self, reason=''):
            _M_Ice.MarshalException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::UnmarshalOutOfBoundsException'

    _M_Ice._t_UnmarshalOutOfBoundsException = IcePy.defineException('::Ice::UnmarshalOutOfBoundsException', UnmarshalOutOfBoundsException, (), False, _M_Ice._t_MarshalException, ())
    UnmarshalOutOfBoundsException._ice_type = _M_Ice._t_UnmarshalOutOfBoundsException

    _M_Ice.UnmarshalOutOfBoundsException = UnmarshalOutOfBoundsException
    del UnmarshalOutOfBoundsException

if 'NoObjectFactoryException' not in _M_Ice.__dict__:
    _M_Ice.NoObjectFactoryException = Ice.createTempClass()
    class NoObjectFactoryException(_M_Ice.MarshalException):
        '''This exception is raised if no suitable object factory was found during
unmarshaling of a Slice class instance.'''
        def __init__(self, reason='', type=''):
            _M_Ice.MarshalException.__init__(self, reason)
            self.type = type

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::NoObjectFactoryException'

    _M_Ice._t_NoObjectFactoryException = IcePy.defineException('::Ice::NoObjectFactoryException', NoObjectFactoryException, (), False, _M_Ice._t_MarshalException, (('type', (), IcePy._t_string, False, 0),))
    NoObjectFactoryException._ice_type = _M_Ice._t_NoObjectFactoryException

    _M_Ice.NoObjectFactoryException = NoObjectFactoryException
    del NoObjectFactoryException

if 'UnexpectedObjectException' not in _M_Ice.__dict__:
    _M_Ice.UnexpectedObjectException = Ice.createTempClass()
    class UnexpectedObjectException(_M_Ice.MarshalException):
        '''This exception is raised if the type of an unmarshaled Slice class instance does
not match its expected type.
This can happen if client and server are compiled with mismatched Slice
definitions or if a class of the wrong type is passed as a parameter
or return value using dynamic invocation. This exception can also be
raised if IceStorm is used to send Slice class instances and
an operation is subscribed to the wrong topic.'''
        def __init__(self, reason='', type='', expectedType=''):
            _M_Ice.MarshalException.__init__(self, reason)
            self.type = type
            self.expectedType = expectedType

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::UnexpectedObjectException'

    _M_Ice._t_UnexpectedObjectException = IcePy.defineException('::Ice::UnexpectedObjectException', UnexpectedObjectException, (), False, _M_Ice._t_MarshalException, (
        ('type', (), IcePy._t_string, False, 0),
        ('expectedType', (), IcePy._t_string, False, 0)
    ))
    UnexpectedObjectException._ice_type = _M_Ice._t_UnexpectedObjectException

    _M_Ice.UnexpectedObjectException = UnexpectedObjectException
    del UnexpectedObjectException

if 'MemoryLimitException' not in _M_Ice.__dict__:
    _M_Ice.MemoryLimitException = Ice.createTempClass()
    class MemoryLimitException(_M_Ice.MarshalException):
        '''This exception is raised when Ice receives a request or reply
message whose size exceeds the limit specified by the
Ice.MessageSizeMax property.'''
        def __init__(self, reason=''):
            _M_Ice.MarshalException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::MemoryLimitException'

    _M_Ice._t_MemoryLimitException = IcePy.defineException('::Ice::MemoryLimitException', MemoryLimitException, (), False, _M_Ice._t_MarshalException, ())
    MemoryLimitException._ice_type = _M_Ice._t_MemoryLimitException

    _M_Ice.MemoryLimitException = MemoryLimitException
    del MemoryLimitException

if 'StringConversionException' not in _M_Ice.__dict__:
    _M_Ice.StringConversionException = Ice.createTempClass()
    class StringConversionException(_M_Ice.MarshalException):
        '''This exception is raised when a string conversion to or from UTF-8
fails during marshaling or unmarshaling.'''
        def __init__(self, reason=''):
            _M_Ice.MarshalException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::StringConversionException'

    _M_Ice._t_StringConversionException = IcePy.defineException('::Ice::StringConversionException', StringConversionException, (), False, _M_Ice._t_MarshalException, ())
    StringConversionException._ice_type = _M_Ice._t_StringConversionException

    _M_Ice.StringConversionException = StringConversionException
    del StringConversionException

if 'EncapsulationException' not in _M_Ice.__dict__:
    _M_Ice.EncapsulationException = Ice.createTempClass()
    class EncapsulationException(_M_Ice.MarshalException):
        '''This exception indicates a malformed data encapsulation.'''
        def __init__(self, reason=''):
            _M_Ice.MarshalException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::EncapsulationException'

    _M_Ice._t_EncapsulationException = IcePy.defineException('::Ice::EncapsulationException', EncapsulationException, (), False, _M_Ice._t_MarshalException, ())
    EncapsulationException._ice_type = _M_Ice._t_EncapsulationException

    _M_Ice.EncapsulationException = EncapsulationException
    del EncapsulationException

if 'FeatureNotSupportedException' not in _M_Ice.__dict__:
    _M_Ice.FeatureNotSupportedException = Ice.createTempClass()
    class FeatureNotSupportedException(Ice.LocalException):
        '''This exception is raised if an unsupported feature is used. The
unsupported feature string contains the name of the unsupported
feature'''
        def __init__(self, unsupportedFeature=''):
            self.unsupportedFeature = unsupportedFeature

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::FeatureNotSupportedException'

    _M_Ice._t_FeatureNotSupportedException = IcePy.defineException('::Ice::FeatureNotSupportedException', FeatureNotSupportedException, (), False, None, (('unsupportedFeature', (), IcePy._t_string, False, 0),))
    FeatureNotSupportedException._ice_type = _M_Ice._t_FeatureNotSupportedException

    _M_Ice.FeatureNotSupportedException = FeatureNotSupportedException
    del FeatureNotSupportedException

if 'SecurityException' not in _M_Ice.__dict__:
    _M_Ice.SecurityException = Ice.createTempClass()
    class SecurityException(Ice.LocalException):
        '''This exception indicates a failure in a security subsystem,
such as the IceSSL plug-in.'''
        def __init__(self, reason=''):
            self.reason = reason

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::SecurityException'

    _M_Ice._t_SecurityException = IcePy.defineException('::Ice::SecurityException', SecurityException, (), False, None, (('reason', (), IcePy._t_string, False, 0),))
    SecurityException._ice_type = _M_Ice._t_SecurityException

    _M_Ice.SecurityException = SecurityException
    del SecurityException

if 'FixedProxyException' not in _M_Ice.__dict__:
    _M_Ice.FixedProxyException = Ice.createTempClass()
    class FixedProxyException(Ice.LocalException):
        '''This exception indicates that an attempt has been made to
change the connection properties of a fixed proxy.'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::FixedProxyException'

    _M_Ice._t_FixedProxyException = IcePy.defineException('::Ice::FixedProxyException', FixedProxyException, (), False, None, ())
    FixedProxyException._ice_type = _M_Ice._t_FixedProxyException

    _M_Ice.FixedProxyException = FixedProxyException
    del FixedProxyException

if 'ResponseSentException' not in _M_Ice.__dict__:
    _M_Ice.ResponseSentException = Ice.createTempClass()
    class ResponseSentException(Ice.LocalException):
        '''Indicates that the response to a request has already been sent;
re-dispatching such a request is not possible.'''
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::ResponseSentException'

    _M_Ice._t_ResponseSentException = IcePy.defineException('::Ice::ResponseSentException', ResponseSentException, (), False, None, ())
    ResponseSentException._ice_type = _M_Ice._t_ResponseSentException

    _M_Ice.ResponseSentException = ResponseSentException
    del ResponseSentException

# End of module Ice
