# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.0
#
# <auto-generated>
#
# Generated from file `Communicator.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Ice_LoggerF_ice
import Ice_InstrumentationF_ice
import Ice_ObjectAdapterF_ice
import Ice_ObjectFactoryF_ice
import Ice_RouterF_ice
import Ice_LocatorF_ice
import Ice_PluginF_ice
import Ice_ImplicitContextF_ice
import Ice_Current_ice
import Ice_Properties_ice
import Ice_FacetMap_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module Ice.Instrumentation
_M_Ice.Instrumentation = Ice.openModule('Ice.Instrumentation')

# Start of module Ice
__name__ = 'Ice'
_M_Ice.__doc__ = '''The Ice core library. Among many other features, the Ice core
library manages all the communication tasks using an efficient
protocol (including protocol compression and support for both TCP
and UDP), provides a thread pool for multi-threaded servers, and
additional functionality that supports high scalability.'''

if 'Communicator' not in _M_Ice.__dict__:
    _M_Ice.Communicator = Ice.createTempClass()
    class Communicator(object):
        '''The central object in Ice. One or more communicators can be
instantiated for an Ice application. Communicator instantiation
is language-specific, and not specified in Slice code.'''
        def __init__(self):
            if Ice.getType(self) == _M_Ice.Communicator:
                raise RuntimeError('Ice.Communicator is an abstract class')

        def destroy(self):
            '''Destroy the communicator. This operation calls shutdown
implicitly.  Calling destroy cleans up memory, and shuts down
this communicator's client functionality and destroys all object
adapters. Subsequent calls to destroy are ignored.'''
            pass

        def shutdown(self):
            '''Shuts down this communicator's server functionality, which
includes the deactivation of all object adapters. (Attempts to use
a deactivated object adapter raise ObjectAdapterDeactivatedException.)
Subsequent calls to shutdown are ignored.

 After shutdown returns, no new requests are
processed. However, requests that have been started before
shutdown was called might still be active. You can use
waitForShutdown to wait for the completion of all
requests.'''
            pass

        def waitForShutdown(self):
            '''Wait until the application has called shutdown (or destroy).
On the server side, this operation blocks the calling thread
until all currently-executing operations have completed.
On the client side, the operation simply block until another
thread has called shutdown or destroy.

A typical use of this operation is to call it
from the main thread, which then waits until some other thread
calls shutdown. After shut-down is complete, the main thread
returns and can do some cleanup work before it finally calls
destroy to shut down the client functionality, and then
exits the application.'''
            pass

        def isShutdown(self):
            '''Check whether communicator has been shut down.

Returns:
    True if the communicator has been shut down; false otherwise.'''
            pass

        def stringToProxy(self, str):
            '''Convert a stringified proxy into a proxy. For example,
MyCategory/MyObject:tcp -h some_host -p
10000 creates a proxy that refers to the Ice object
having an identity with a name "MyObject" and a category
"MyCategory", with the server running on host "some_host", port
10000. If the stringified proxy does not parse correctly, the
operation throws one of ProxyParseException,
EndpointParseException, or IdentityParseException.
An appendix in the Ice manual provides a detailed description
of the syntax supported by stringified proxies.

Arguments:
    str The stringified proxy to convert into a proxy.

Returns:
    The proxy, or nil if str is an empty string.'''
            pass

        def proxyToString(self, obj):
            '''Convert a proxy into a string.

Arguments:
    obj The proxy to convert into a stringified proxy.

Returns:
    The stringified proxy, or an empty string if
obj is nil.'''
            pass

        def propertyToProxy(self, property):
            '''Convert a set of proxy properties into a proxy. The "base"
name supplied in the property argument refers to a
property containing a stringified proxy, such as
MyProxy=id:tcp -h localhost -p 10000. Additional
properties configure local settings for the proxy, such as
MyProxy.PreferSecure=1. The "Properties"
appendix in the Ice manual describes each of the supported
proxy properties.

Arguments:
    property The base property name.

Returns:
    The proxy.'''
            pass

        def proxyToProperty(self, proxy, property):
            '''Convert a proxy to a set of proxy properties.

Arguments:
    proxy The proxy.

    property The base property name.

Returns:
    The property set.'''
            pass

        def stringToIdentity(self, str):
            '''Convert a string into an identity. If the string does not parse
correctly, the operation throws IdentityParseException.

Arguments:
    str The string to convert into an identity.

Returns:
    The identity.'''
            pass

        def identityToString(self, ident):
            '''Convert an identity into a string.

Arguments:
    ident The identity to convert into a string.

Returns:
    The "stringified" identity.'''
            pass

        def createObjectAdapter(self, name):
            '''Create a new object adapter. The endpoints for the object
adapter are taken from the property name.Endpoints.

It is legal to create an object adapter with the empty string as
its name. Such an object adapter is accessible via bidirectional
connections or by collocated invocations that originate from the
same communicator as is used by the adapter.

Attempts to create a named object adapter for which no configuration
can be found raise InitializationException.

Arguments:
    name The object adapter name.

Returns:
    The new object adapter.'''
            pass

        def createObjectAdapterWithEndpoints(self, name, endpoints):
            '''Create a new object adapter with endpoints. This operation sets
the property name.Endpoints,
and then calls createObjectAdapter. It is provided as a
convenience function.

Calling this operation with an empty name will result in a
UUID being generated for the name.

Arguments:
    name The object adapter name.

    endpoints The endpoints for the object adapter.

Returns:
    The new object adapter.'''
            pass

        def createObjectAdapterWithRouter(self, name, rtr):
            '''Create a new object adapter with a router. This operation
creates a routed object adapter.

Calling this operation with an empty name will result in a
UUID being generated for the name.

Arguments:
    name The object adapter name.

    rtr The router.

Returns:
    The new object adapter.'''
            pass

        def addObjectFactory(self, factory, id):
            '''Add an object factory to this communicator. Installing a
factory with an id for which a factory is already registered
throws AlreadyRegisteredException.

When unmarshaling an Ice object, the Ice run time reads the
most-derived type id off the wire and attempts to create an
instance of the type using a factory. If no instance is created,
either because no factory was found, or because all factories
returned nil, the behavior of the Ice run time depends on the
format with which the object was marshaled:

If the object uses the "sliced" format, Ice ascends the class
hierarchy until it finds a type that is recognized by a factory,
or it reaches the least-derived type. If no factory is found that
can create an instance, the run time throws
NoObjectFactoryException.

If the object uses the "compact" format, Ice immediately raises
NoObjectFactoryException.

The following order is used to locate a factory for a type:

The Ice run-time looks for a factory registered
specifically for the type.

If no instance has been created, the Ice run-time looks
for the default factory, which is registered with an empty type id.

If no instance has been created by any of the preceding
steps, the Ice run-time looks for a factory that may have been
statically generated by the language mapping for non-abstract classes.

Arguments:
    factory The factory to add.

    id The type id for which the factory can create instances, or
an empty string for the default factory.'''
            pass

        def findObjectFactory(self, id):
            '''Find an object factory registered with this communicator.

Arguments:
    id The type id for which the factory can create instances,
or an empty string for the default factory.

Returns:
    The object factory, or null if no object factory was
found for the given id.'''
            pass

        def getImplicitContext(self):
            '''Get the implicit context associated with this communicator.

Returns:
    The implicit context associated with this communicator;
returns null when the property Ice.ImplicitContext is not set
or is set to None.'''
            pass

        def getProperties(self):
            '''Get the properties for this communicator.

Returns:
    This communicator's properties.'''
            pass

        def getLogger(self):
            '''Get the logger for this communicator.

Returns:
    This communicator's logger.'''
            pass

        def getObserver(self):
            '''Get the observer resolver object for this communicator.

Returns:
    This communicator's observer resolver object.'''
            pass

        def getDefaultRouter(self):
            '''Get the default router this communicator.

Returns:
    The default router for this communicator.'''
            pass

        def setDefaultRouter(self, rtr):
            '''Set a default router for this communicator. All newly
created proxies will use this default router. To disable the
default router, null can be used. Note that this
operation has no effect on existing proxies.

You can also set a router for an individual proxy
by calling the operation ice_router on the proxy.

Arguments:
    rtr The default router to use for this communicator.'''
            pass

        def getDefaultLocator(self):
            '''Get the default locator this communicator.

Returns:
    The default locator for this communicator.'''
            pass

        def setDefaultLocator(self, loc):
            '''Set a default Ice locator for this communicator. All newly
created proxy and object adapters will use this default
locator. To disable the default locator, null can be used.
Note that this operation has no effect on existing proxies or
object adapters.

 You can also set a locator for an individual proxy
by calling the operation ice_locator on the proxy, or for an
object adapter by calling the operation setLocator on the
object adapter.

Arguments:
    loc The default locator to use for this communicator.'''
            pass

        def getPluginManager(self):
            '''Get the plug-in manager for this communicator.

Returns:
    This communicator's plug-in manager.'''
            pass

        def flushBatchRequests(self):
            '''Flush any pending batch requests for this communicator.
This means all batch requests invoked on fixed proxies
for all connections associated with the communicator.
Any errors that occur while flushing a connection are ignored.'''
            pass

        def createAdmin(self, adminAdapter, adminId):
            '''Add the Admin object with all its facets to the provided object adapter.
If Ice.Admin.ServerId is set and the provided object adapter has a Locator,
createAdmin registers the Admin's Process facet with the Locator's LocatorRegistry.

createAdmin call only be called once; subsequent calls raise InitializationException.

Arguments:
    adminAdapter The object adapter used to host the Admin object; if null and
Ice.Admin.Endpoints is set, create, activate and use the Ice.Admin object adapter.

    adminId The identity of the Admin object.

Returns:
    A proxy to the main ("") facet of the Admin object. Never returns a null proxy.'''
            pass

        def getAdmin(self):
            '''Get a proxy to the main facet of the Admin object.

getAdmin also creates the Admin object and creates and activates the Ice.Admin object
adapter to host this Admin object if Ice.Admin.Enpoints is set. The identity of the Admin
object created by getAdmin is /admin, or /admin
when Ice.Admin.InstanceName is not set.

If Ice.Admin.DelayCreation is 0 or not set, getAdmin is called by the communicator
initialization, after initialization of all plugins.

Returns:
    A proxy to the main ("") facet of the Admin object, or a null proxy if no
Admin object is configured.'''
            pass

        def addAdminFacet(self, servant, facet):
            '''Add a new facet to the Admin object.
Adding a servant with a facet that is already registered
throws AlreadyRegisteredException.

Arguments:
    servant The servant that implements the new Admin facet.
    facet The name of the new Admin facet.'''
            pass

        def removeAdminFacet(self, facet):
            '''Remove the following facet to the Admin object.
Removing a facet that was not previously registered throws
NotRegisteredException.

Arguments:
    facet The name of the Admin facet.
Returns:
    The servant associated with this Admin facet.'''
            pass

        def findAdminFacet(self, facet):
            '''Returns a facet of the Admin object.

Arguments:
    facet The name of the Admin facet.
Returns:
    The servant associated with this Admin facet, or
null if no facet is registered with the given name.'''
            pass

        def findAllAdminFacets(self):
            '''Returns a map of all facets of the Admin object.

Returns:
    A collection containing all the facet names and
servants of the Admin object.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_Communicator)

        __repr__ = __str__

    _M_Ice._t_Communicator = IcePy.defineClass('::Ice::Communicator', Communicator, -1, (), True, False, None, (), ())
    Communicator._ice_type = _M_Ice._t_Communicator

    _M_Ice.Communicator = Communicator
    del Communicator

# End of module Ice
