# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.0
#
# <auto-generated>
#
# Generated from file `Admin.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Ice_Identity_ice
import Ice_BuiltinSequences_ice
import Ice_Properties_ice
import Ice_SliceChecksumDict_ice
import Glacier2_Session_ice
import IceGrid_Exception_ice
import IceGrid_Descriptor_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module Glacier2
_M_Glacier2 = Ice.openModule('Glacier2')

# Included module IceGrid
_M_IceGrid = Ice.openModule('IceGrid')

# Start of module IceGrid
__name__ = 'IceGrid'

if 'ServerState' not in _M_IceGrid.__dict__:
    _M_IceGrid.ServerState = Ice.createTempClass()
    class ServerState(Ice.EnumBase):
        '''An enumeration representing the state of the server.'''

        def __init__(self, _n, _v):
            Ice.EnumBase.__init__(self, _n, _v)

        def valueOf(self, _n):
            if _n in self._enumerators:
                return self._enumerators[_n]
            return None
        valueOf = classmethod(valueOf)

    ServerState.Inactive = ServerState("Inactive", 0)
    ServerState.Activating = ServerState("Activating", 1)
    ServerState.ActivationTimedOut = ServerState("ActivationTimedOut", 2)
    ServerState.Active = ServerState("Active", 3)
    ServerState.Deactivating = ServerState("Deactivating", 4)
    ServerState.Destroying = ServerState("Destroying", 5)
    ServerState.Destroyed = ServerState("Destroyed", 6)
    ServerState._enumerators = { 0:ServerState.Inactive, 1:ServerState.Activating, 2:ServerState.ActivationTimedOut, 3:ServerState.Active, 4:ServerState.Deactivating, 5:ServerState.Destroying, 6:ServerState.Destroyed }

    _M_IceGrid._t_ServerState = IcePy.defineEnum('::IceGrid::ServerState', ServerState, (), ServerState._enumerators)

    _M_IceGrid.ServerState = ServerState
    del ServerState

if '_t_StringObjectProxyDict' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_StringObjectProxyDict = IcePy.defineDictionary('::IceGrid::StringObjectProxyDict', (), IcePy._t_string, IcePy._t_ObjectPrx)

if 'ObjectInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.ObjectInfo = Ice.createTempClass()
    class ObjectInfo(object):
        '''Information about an Ice object.'''
        def __init__(self, proxy=None, type=''):
            self.proxy = proxy
            self.type = type

        def __eq__(self, other):
            if other is None:
                return False
            elif not isinstance(other, _M_IceGrid.ObjectInfo):
                return NotImplemented
            else:
                if self.proxy != other.proxy:
                    return False
                if self.type != other.type:
                    return False
                return True

        def __ne__(self, other):
            return not self.__eq__(other)

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_ObjectInfo)

        __repr__ = __str__

    _M_IceGrid._t_ObjectInfo = IcePy.defineStruct('::IceGrid::ObjectInfo', ObjectInfo, (), (
        ('proxy', (), IcePy._t_ObjectPrx),
        ('type', (), IcePy._t_string)
    ))

    _M_IceGrid.ObjectInfo = ObjectInfo
    del ObjectInfo

if '_t_ObjectInfoSeq' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_ObjectInfoSeq = IcePy.defineSequence('::IceGrid::ObjectInfoSeq', (), _M_IceGrid._t_ObjectInfo)

if 'AdapterInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.AdapterInfo = Ice.createTempClass()
    class AdapterInfo(object):
        '''Information about an adapter registered with the IceGrid registry.'''
        def __init__(self, id='', proxy=None, replicaGroupId=''):
            self.id = id
            self.proxy = proxy
            self.replicaGroupId = replicaGroupId

        def __eq__(self, other):
            if other is None:
                return False
            elif not isinstance(other, _M_IceGrid.AdapterInfo):
                return NotImplemented
            else:
                if self.id != other.id:
                    return False
                if self.proxy != other.proxy:
                    return False
                if self.replicaGroupId != other.replicaGroupId:
                    return False
                return True

        def __ne__(self, other):
            return not self.__eq__(other)

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_AdapterInfo)

        __repr__ = __str__

    _M_IceGrid._t_AdapterInfo = IcePy.defineStruct('::IceGrid::AdapterInfo', AdapterInfo, (), (
        ('id', (), IcePy._t_string),
        ('proxy', (), IcePy._t_ObjectPrx),
        ('replicaGroupId', (), IcePy._t_string)
    ))

    _M_IceGrid.AdapterInfo = AdapterInfo
    del AdapterInfo

if '_t_AdapterInfoSeq' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_AdapterInfoSeq = IcePy.defineSequence('::IceGrid::AdapterInfoSeq', (), _M_IceGrid._t_AdapterInfo)

if 'ServerInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.ServerInfo = Ice.createTempClass()
    class ServerInfo(object):
        '''Information about a server managed by an IceGrid node.'''
        def __init__(self, application='', uuid='', revision=0, node='', descriptor=None, sessionId=''):
            self.application = application
            self.uuid = uuid
            self.revision = revision
            self.node = node
            self.descriptor = descriptor
            self.sessionId = sessionId

        def __eq__(self, other):
            if other is None:
                return False
            elif not isinstance(other, _M_IceGrid.ServerInfo):
                return NotImplemented
            else:
                if self.application != other.application:
                    return False
                if self.uuid != other.uuid:
                    return False
                if self.revision != other.revision:
                    return False
                if self.node != other.node:
                    return False
                if self.descriptor != other.descriptor:
                    return False
                if self.sessionId != other.sessionId:
                    return False
                return True

        def __ne__(self, other):
            return not self.__eq__(other)

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_ServerInfo)

        __repr__ = __str__

    _M_IceGrid._t_ServerInfo = IcePy.defineStruct('::IceGrid::ServerInfo', ServerInfo, (), (
        ('application', (), IcePy._t_string),
        ('uuid', (), IcePy._t_string),
        ('revision', (), IcePy._t_int),
        ('node', (), IcePy._t_string),
        ('descriptor', (), _M_IceGrid._t_ServerDescriptor),
        ('sessionId', (), IcePy._t_string)
    ))

    _M_IceGrid.ServerInfo = ServerInfo
    del ServerInfo

if 'NodeInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.NodeInfo = Ice.createTempClass()
    class NodeInfo(object):
        '''Information about an IceGrid node.'''
        def __init__(self, name='', os='', hostname='', release='', version='', machine='', nProcessors=0, dataDir=''):
            self.name = name
            self.os = os
            self.hostname = hostname
            self.release = release
            self.version = version
            self.machine = machine
            self.nProcessors = nProcessors
            self.dataDir = dataDir

        def __hash__(self):
            _h = 0
            _h = 5 * _h + Ice.getHash(self.name)
            _h = 5 * _h + Ice.getHash(self.os)
            _h = 5 * _h + Ice.getHash(self.hostname)
            _h = 5 * _h + Ice.getHash(self.release)
            _h = 5 * _h + Ice.getHash(self.version)
            _h = 5 * _h + Ice.getHash(self.machine)
            _h = 5 * _h + Ice.getHash(self.nProcessors)
            _h = 5 * _h + Ice.getHash(self.dataDir)
            return _h % 0x7fffffff

        def __compare(self, other):
            if other is None:
                return 1
            elif not isinstance(other, _M_IceGrid.NodeInfo):
                return NotImplemented
            else:
                if self.name is None or other.name is None:
                    if self.name != other.name:
                        return (-1 if self.name is None else 1)
                else:
                    if self.name < other.name:
                        return -1
                    elif self.name > other.name:
                        return 1
                if self.os is None or other.os is None:
                    if self.os != other.os:
                        return (-1 if self.os is None else 1)
                else:
                    if self.os < other.os:
                        return -1
                    elif self.os > other.os:
                        return 1
                if self.hostname is None or other.hostname is None:
                    if self.hostname != other.hostname:
                        return (-1 if self.hostname is None else 1)
                else:
                    if self.hostname < other.hostname:
                        return -1
                    elif self.hostname > other.hostname:
                        return 1
                if self.release is None or other.release is None:
                    if self.release != other.release:
                        return (-1 if self.release is None else 1)
                else:
                    if self.release < other.release:
                        return -1
                    elif self.release > other.release:
                        return 1
                if self.version is None or other.version is None:
                    if self.version != other.version:
                        return (-1 if self.version is None else 1)
                else:
                    if self.version < other.version:
                        return -1
                    elif self.version > other.version:
                        return 1
                if self.machine is None or other.machine is None:
                    if self.machine != other.machine:
                        return (-1 if self.machine is None else 1)
                else:
                    if self.machine < other.machine:
                        return -1
                    elif self.machine > other.machine:
                        return 1
                if self.nProcessors is None or other.nProcessors is None:
                    if self.nProcessors != other.nProcessors:
                        return (-1 if self.nProcessors is None else 1)
                else:
                    if self.nProcessors < other.nProcessors:
                        return -1
                    elif self.nProcessors > other.nProcessors:
                        return 1
                if self.dataDir is None or other.dataDir is None:
                    if self.dataDir != other.dataDir:
                        return (-1 if self.dataDir is None else 1)
                else:
                    if self.dataDir < other.dataDir:
                        return -1
                    elif self.dataDir > other.dataDir:
                        return 1
                return 0

        def __lt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r < 0

        def __le__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r <= 0

        def __gt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r > 0

        def __ge__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r >= 0

        def __eq__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r == 0

        def __ne__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r != 0

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_NodeInfo)

        __repr__ = __str__

    _M_IceGrid._t_NodeInfo = IcePy.defineStruct('::IceGrid::NodeInfo', NodeInfo, (), (
        ('name', (), IcePy._t_string),
        ('os', (), IcePy._t_string),
        ('hostname', (), IcePy._t_string),
        ('release', (), IcePy._t_string),
        ('version', (), IcePy._t_string),
        ('machine', (), IcePy._t_string),
        ('nProcessors', (), IcePy._t_int),
        ('dataDir', (), IcePy._t_string)
    ))

    _M_IceGrid.NodeInfo = NodeInfo
    del NodeInfo

if 'RegistryInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.RegistryInfo = Ice.createTempClass()
    class RegistryInfo(object):
        '''Information about an IceGrid registry replica.'''
        def __init__(self, name='', hostname=''):
            self.name = name
            self.hostname = hostname

        def __hash__(self):
            _h = 0
            _h = 5 * _h + Ice.getHash(self.name)
            _h = 5 * _h + Ice.getHash(self.hostname)
            return _h % 0x7fffffff

        def __compare(self, other):
            if other is None:
                return 1
            elif not isinstance(other, _M_IceGrid.RegistryInfo):
                return NotImplemented
            else:
                if self.name is None or other.name is None:
                    if self.name != other.name:
                        return (-1 if self.name is None else 1)
                else:
                    if self.name < other.name:
                        return -1
                    elif self.name > other.name:
                        return 1
                if self.hostname is None or other.hostname is None:
                    if self.hostname != other.hostname:
                        return (-1 if self.hostname is None else 1)
                else:
                    if self.hostname < other.hostname:
                        return -1
                    elif self.hostname > other.hostname:
                        return 1
                return 0

        def __lt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r < 0

        def __le__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r <= 0

        def __gt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r > 0

        def __ge__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r >= 0

        def __eq__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r == 0

        def __ne__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r != 0

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_RegistryInfo)

        __repr__ = __str__

    _M_IceGrid._t_RegistryInfo = IcePy.defineStruct('::IceGrid::RegistryInfo', RegistryInfo, (), (
        ('name', (), IcePy._t_string),
        ('hostname', (), IcePy._t_string)
    ))

    _M_IceGrid.RegistryInfo = RegistryInfo
    del RegistryInfo

if '_t_RegistryInfoSeq' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_RegistryInfoSeq = IcePy.defineSequence('::IceGrid::RegistryInfoSeq', (), _M_IceGrid._t_RegistryInfo)

if 'LoadInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.LoadInfo = Ice.createTempClass()
    class LoadInfo(object):
        '''Information about the load of a node.'''
        def __init__(self, avg1=0.0, avg5=0.0, avg15=0.0):
            self.avg1 = avg1
            self.avg5 = avg5
            self.avg15 = avg15

        def __eq__(self, other):
            if other is None:
                return False
            elif not isinstance(other, _M_IceGrid.LoadInfo):
                return NotImplemented
            else:
                if self.avg1 != other.avg1:
                    return False
                if self.avg5 != other.avg5:
                    return False
                if self.avg15 != other.avg15:
                    return False
                return True

        def __ne__(self, other):
            return not self.__eq__(other)

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_LoadInfo)

        __repr__ = __str__

    _M_IceGrid._t_LoadInfo = IcePy.defineStruct('::IceGrid::LoadInfo', LoadInfo, (), (
        ('avg1', (), IcePy._t_float),
        ('avg5', (), IcePy._t_float),
        ('avg15', (), IcePy._t_float)
    ))

    _M_IceGrid.LoadInfo = LoadInfo
    del LoadInfo

if 'ApplicationInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.ApplicationInfo = Ice.createTempClass()
    class ApplicationInfo(object):
        '''Information about an IceGrid application.'''
        def __init__(self, uuid='', createTime=0, createUser='', updateTime=0, updateUser='', revision=0, descriptor=Ice._struct_marker):
            self.uuid = uuid
            self.createTime = createTime
            self.createUser = createUser
            self.updateTime = updateTime
            self.updateUser = updateUser
            self.revision = revision
            if descriptor is Ice._struct_marker:
                self.descriptor = _M_IceGrid.ApplicationDescriptor()
            else:
                self.descriptor = descriptor

        def __eq__(self, other):
            if other is None:
                return False
            elif not isinstance(other, _M_IceGrid.ApplicationInfo):
                return NotImplemented
            else:
                if self.uuid != other.uuid:
                    return False
                if self.createTime != other.createTime:
                    return False
                if self.createUser != other.createUser:
                    return False
                if self.updateTime != other.updateTime:
                    return False
                if self.updateUser != other.updateUser:
                    return False
                if self.revision != other.revision:
                    return False
                if self.descriptor != other.descriptor:
                    return False
                return True

        def __ne__(self, other):
            return not self.__eq__(other)

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_ApplicationInfo)

        __repr__ = __str__

    _M_IceGrid._t_ApplicationInfo = IcePy.defineStruct('::IceGrid::ApplicationInfo', ApplicationInfo, (), (
        ('uuid', (), IcePy._t_string),
        ('createTime', (), IcePy._t_long),
        ('createUser', (), IcePy._t_string),
        ('updateTime', (), IcePy._t_long),
        ('updateUser', (), IcePy._t_string),
        ('revision', (), IcePy._t_int),
        ('descriptor', (), _M_IceGrid._t_ApplicationDescriptor)
    ))

    _M_IceGrid.ApplicationInfo = ApplicationInfo
    del ApplicationInfo

if '_t_ApplicationInfoSeq' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_ApplicationInfoSeq = IcePy.defineSequence('::IceGrid::ApplicationInfoSeq', (), _M_IceGrid._t_ApplicationInfo)

if 'ApplicationUpdateInfo' not in _M_IceGrid.__dict__:
    _M_IceGrid.ApplicationUpdateInfo = Ice.createTempClass()
    class ApplicationUpdateInfo(object):
        '''Information about updates to an IceGrid application.'''
        def __init__(self, updateTime=0, updateUser='', revision=0, descriptor=Ice._struct_marker):
            self.updateTime = updateTime
            self.updateUser = updateUser
            self.revision = revision
            if descriptor is Ice._struct_marker:
                self.descriptor = _M_IceGrid.ApplicationUpdateDescriptor()
            else:
                self.descriptor = descriptor

        def __eq__(self, other):
            if other is None:
                return False
            elif not isinstance(other, _M_IceGrid.ApplicationUpdateInfo):
                return NotImplemented
            else:
                if self.updateTime != other.updateTime:
                    return False
                if self.updateUser != other.updateUser:
                    return False
                if self.revision != other.revision:
                    return False
                if self.descriptor != other.descriptor:
                    return False
                return True

        def __ne__(self, other):
            return not self.__eq__(other)

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_ApplicationUpdateInfo)

        __repr__ = __str__

    _M_IceGrid._t_ApplicationUpdateInfo = IcePy.defineStruct('::IceGrid::ApplicationUpdateInfo', ApplicationUpdateInfo, (), (
        ('updateTime', (), IcePy._t_long),
        ('updateUser', (), IcePy._t_string),
        ('revision', (), IcePy._t_int),
        ('descriptor', (), _M_IceGrid._t_ApplicationUpdateDescriptor)
    ))

    _M_IceGrid.ApplicationUpdateInfo = ApplicationUpdateInfo
    del ApplicationUpdateInfo

if 'Admin' not in _M_IceGrid.__dict__:
    _M_IceGrid.Admin = Ice.createTempClass()
    class Admin(Ice.Object):
        '''The IceGrid administrative interface. 
Allowing access to this interface
is a security risk! Please see the IceGrid documentation
for further information.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceGrid.Admin:
                raise RuntimeError('IceGrid.Admin is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::Admin')

        def ice_id(self, current=None):
            return '::IceGrid::Admin'

        def ice_staticId():
            return '::IceGrid::Admin'
        ice_staticId = staticmethod(ice_staticId)

        def addApplication(self, descriptor, current=None):
            '''Add an application to IceGrid.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.'''
            pass

        def syncApplication(self, descriptor, current=None):
            '''Synchronize a deployed application with the given application
descriptor. This operation will replace the current descriptor
with this new descriptor.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
            pass

        def updateApplication(self, descriptor, current=None):
            '''Update a deployed application with the given update application
descriptor.

Arguments:
    descriptor The update descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
            pass

        def syncApplicationWithoutRestart(self, descriptor, current=None):
            '''Synchronize a deployed application with the given application
descriptor. This operation will replace the current descriptor
with this new descriptor only if no server restarts are
necessary for the update of the application. If some servers
need to be restarted, the synchronization is rejected with a
DeploymentException.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
            pass

        def updateApplicationWithoutRestart(self, descriptor, current=None):
            '''Update a deployed application with the given update application
descriptor only if no server restarts are necessary for the
update of the application. If some servers need to be
restarted, the synchronization is rejected with a
DeploymentException.

Arguments:
    descriptor The update descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
            pass

        def removeApplication(self, name, current=None):
            '''Remove an application from IceGrid.

Arguments:
    name The application name.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
            pass

        def instantiateServer(self, application, node, desc, current=None):
            '''Instantiate a server template from an application on the given
node.

Arguments:
    application The application name.

    node The name of the node where the server will be
deployed.

    desc The descriptor of the server instance to deploy.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if server instantiation
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
            pass

        def patchApplication_async(self, _cb, name, shutdown, current=None):
            '''Patch the given application data.

Arguments:
    name The application name.

    shutdown If true, the servers depending on the data to
patch will be shut down if necessary.

Exceptions:
    ApplicationNotExistException Raised if the application
doesn't exist.

    PatchException Raised if the patch failed.'''
            pass

        def getApplicationInfo(self, name, current=None):
            '''Get an application descriptor.

Arguments:
    name The application name.

Returns:
    The application descriptor.

Exceptions:
    ApplicationNotExistException Raised if the application
doesn't exist.'''
            pass

        def getDefaultApplicationDescriptor(self, current=None):
            '''Get the default application descriptor.

Exceptions:
    DeploymentException Raised if the default application
descriptor can't be accessed or is invalid.'''
            pass

        def getAllApplicationNames(self, current=None):
            '''Get all the IceGrid applications currently registered.

Returns:
    The application names.'''
            pass

        def getServerInfo(self, id, current=None):
            '''Get the server information for the server with the given id.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

Returns:
    The server information.'''
            pass

        def getServerState(self, id, current=None):
            '''Get a server's state.

Arguments:
    id The server id.

Returns:
    The server state.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
            pass

        def getServerPid(self, id, current=None):
            '''Get a server's system process id. The process id is operating
system dependent.

Arguments:
    id The server id.

Returns:
    The server's process id.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
            pass

        def getServerAdminCategory(self, current=None):
            '''Get the category for server admin objects. You can manufacture a server admin
proxy from the admin proxy by changing its identity: use the server ID as name
and the returned category as category.

Returns:
    The category for server admin objects.'''
            pass

        def getServerAdmin(self, id, current=None):
            '''Get a proxy to the server's admin object.

Arguments:
    id The server id.

Returns:
    A proxy to the server's admin object

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
            pass

        def enableServer(self, id, enabled, current=None):
            '''Enable or disable a server. A disabled server can't be started
on demand or administratively. The enable state of the server
is not persistent: if the node is shut down and restarted, the
server will be enabled by default.

Arguments:
    id The server id.

    enabled True to enable the server, false to disable it.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
            pass

        def isServerEnabled(self, id, current=None):
            '''Check if the server is enabled or disabled.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
            pass

        def startServer_async(self, _cb, id, current=None):
            '''Start a server and wait for its activation.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    ServerStartException Raised if the server couldn't be
started.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
            pass

        def stopServer_async(self, _cb, id, current=None):
            '''Stop a server.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    ServerStopException Raised if the server couldn't be
stopped.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
            pass

        def patchServer_async(self, _cb, id, shutdown, current=None):
            '''Patch a server.

Arguments:
    id The server id.

    shutdown If true, servers depending on the data to patch
will be shut down if necessary.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.

    PatchException Raised if the patch failed.'''
            pass

        def sendSignal(self, id, signal, current=None):
            '''Send signal to a server.

Arguments:
    id The server id.

    signal The signal, for example SIGTERM or 15.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.

    BadSignalException Raised if the signal is not recognized
by the target server.'''
            pass

        def getAllServerIds(self, current=None):
            '''Get all the server ids registered with IceGrid.

Returns:
    The server ids.'''
            pass

        def getAdapterInfo(self, id, current=None):
            '''Get the adapter information for the replica group or adapter
with the given id.

Arguments:
    id The adapter id.

Returns:
    A sequence of adapter information structures. If the
given id refers to an adapter, this sequence will contain only
one element. If the given id refers to a replica group, the
sequence will contain the adapter information of each member of
the replica group.

Exceptions:
    AdapterNotExistException Raised if the adapter or
replica group doesn't exist.'''
            pass

        def removeAdapter(self, id, current=None):
            '''Remove the adapter with the given id.

Arguments:
    id The adapter id.
Exceptions:
    AdapterNotExistException Raised if the adapter doesn't
exist.'''
            pass

        def getAllAdapterIds(self, current=None):
            '''Get all the adapter ids registered with IceGrid.

Returns:
    The adapter ids.'''
            pass

        def addObject(self, obj, current=None):
            '''Add an object to the object registry. IceGrid will get the
object type by calling ice_id on the given proxy. The object
must be reachable.

Arguments:
    obj The object to be added to the registry.

Exceptions:
    ObjectExistsException Raised if the object is already
registered.

    DeploymentException Raised if the object can't be
added. This might be raised if the invocation on the proxy to
get the object type failed.'''
            pass

        def updateObject(self, obj, current=None):
            '''Update an object in the object registry. Only objects added
with this interface can be updated with this operation. Objects
added with deployment descriptors should be updated with the
deployment mechanism.

Arguments:
    obj The object to be updated to the registry.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.

    DeploymentException Raised if the object can't be
updated. This might happen if the object was added with a
deployment descriptor.'''
            pass

        def addObjectWithType(self, obj, type, current=None):
            '''Add an object to the object registry and explicitly specify
its type.

Arguments:
    obj The object to be added to the registry.

    type The object type.

Exceptions:
    ObjectExistsException Raised if the object is already
registered.'''
            pass

        def removeObject(self, id, current=None):
            '''Remove an object from the object registry. Only objects added
with this interface can be removed with this operation. Objects
added with deployment descriptors should be removed with the
deployment mechanism.

Arguments:
    id The identity of the object to be removed from the
registry.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.

    DeploymentException Raised if the object can't be
removed. This might happen if the object was added with a
deployment descriptor.'''
            pass

        def getObjectInfo(self, id, current=None):
            '''Get the object info for the object with the given identity.

Arguments:
    id The identity of the object.

Returns:
    The object info.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.'''
            pass

        def getObjectInfosByType(self, type, current=None):
            '''Get the object info of all the registered objects with the
given type.

Arguments:
    type The type of the object.

Returns:
    The object infos.'''
            pass

        def getAllObjectInfos(self, expr, current=None):
            '''Get the object info of all the registered objects whose stringified
identities match the given expression.

Arguments:
    expr The expression to match against the stringified
identities of registered objects. The expression may contain
a trailing wildcard (*) character.

Returns:
    All the object infos with a stringified identity
matching the given expression.'''
            pass

        def pingNode(self, name, current=None):
            '''Ping an IceGrid node to see if it is active.

Arguments:
    name The node name.

Returns:
    true if the node ping succeeded, false otherwise.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.'''
            pass

        def getNodeLoad(self, name, current=None):
            '''Get the load averages of the node.

Arguments:
    name The node name.

Returns:
    The node load information.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
            pass

        def getNodeInfo(self, name, current=None):
            '''Get the node information for the node with the given name.

Arguments:
    name The node name.

Returns:
    The node information.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
            pass

        def getNodeAdmin(self, name, current=None):
            '''Get a proxy to the IceGrid node's admin object.

Arguments:
    name The IceGrid node name

Returns:
    A proxy to the IceGrid node's admin object

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
            pass

        def getNodeProcessorSocketCount(self, name, current=None):
            '''Get the number of physical processor sockets for the machine
running the node with the given name.

Note that this method will return 1 on operating systems where
this can't be automatically determined and where the
IceGrid.Node.ProcessorSocketCount property for the node is not
set.

Arguments:
    name The node name.

Returns:
    The number of processor sockets or 1 if the number of
sockets can't determined.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
            pass

        def shutdownNode(self, name, current=None):
            '''Shutdown an IceGrid node.

Arguments:
    name The node name.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
            pass

        def getNodeHostname(self, name, current=None):
            '''Get the hostname of this node.

Arguments:
    name The node name.

Returns:
    The node hostname.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
            pass

        def getAllNodeNames(self, current=None):
            '''Get all the IceGrid nodes currently registered.

Returns:
    The node names.'''
            pass

        def pingRegistry(self, name, current=None):
            '''Ping an IceGrid registry to see if it is active.

Arguments:
    name The registry name.

Returns:
    true if the registry ping succeeded, false otherwise.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.'''
            pass

        def getRegistryInfo(self, name, current=None):
            '''Get the registry information for the registry with the given name.

Arguments:
    name The registry name.

Returns:
    The registry information.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.

    RegistryUnreachableException Raised if the registry could not be
reached.'''
            pass

        def getRegistryAdmin(self, name, current=None):
            '''Get a proxy to the IceGrid registry's admin object.

Arguments:
    name The registry name

Returns:
    A proxy to the IceGrid registry's admin object

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.'''
            pass

        def shutdownRegistry(self, name, current=None):
            '''Shutdown an IceGrid registry.

Arguments:
    name The registry name.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.

    RegistryUnreachableException Raised if the registry could not be
reached.'''
            pass

        def getAllRegistryNames(self, current=None):
            '''Get all the IceGrid registries currently registered.

Returns:
    The registry names.'''
            pass

        def shutdown(self, current=None):
            '''Shut down the IceGrid registry.'''
            pass

        def getSliceChecksums(self, current=None):
            '''Returns the checksums for the IceGrid Slice definitions.

Returns:
    A dictionary mapping Slice type ids to their checksums.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_Admin)

        __repr__ = __str__

    _M_IceGrid.AdminPrx = Ice.createTempClass()
    class AdminPrx(Ice.ObjectPrx):

        '''Add an application to IceGrid.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.'''
        def addApplication(self, descriptor, _ctx=None):
            return _M_IceGrid.Admin._op_addApplication.invoke(self, ((descriptor, ), _ctx))

        '''Add an application to IceGrid.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.'''
        def begin_addApplication(self, descriptor, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_addApplication.begin(self, ((descriptor, ), _response, _ex, _sent, _ctx))

        '''Add an application to IceGrid.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.'''
        def end_addApplication(self, _r):
            return _M_IceGrid.Admin._op_addApplication.end(self, _r)

        '''Synchronize a deployed application with the given application
descriptor. This operation will replace the current descriptor
with this new descriptor.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def syncApplication(self, descriptor, _ctx=None):
            return _M_IceGrid.Admin._op_syncApplication.invoke(self, ((descriptor, ), _ctx))

        '''Synchronize a deployed application with the given application
descriptor. This operation will replace the current descriptor
with this new descriptor.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def begin_syncApplication(self, descriptor, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_syncApplication.begin(self, ((descriptor, ), _response, _ex, _sent, _ctx))

        '''Synchronize a deployed application with the given application
descriptor. This operation will replace the current descriptor
with this new descriptor.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def end_syncApplication(self, _r):
            return _M_IceGrid.Admin._op_syncApplication.end(self, _r)

        '''Update a deployed application with the given update application
descriptor.

Arguments:
    descriptor The update descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def updateApplication(self, descriptor, _ctx=None):
            return _M_IceGrid.Admin._op_updateApplication.invoke(self, ((descriptor, ), _ctx))

        '''Update a deployed application with the given update application
descriptor.

Arguments:
    descriptor The update descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def begin_updateApplication(self, descriptor, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_updateApplication.begin(self, ((descriptor, ), _response, _ex, _sent, _ctx))

        '''Update a deployed application with the given update application
descriptor.

Arguments:
    descriptor The update descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def end_updateApplication(self, _r):
            return _M_IceGrid.Admin._op_updateApplication.end(self, _r)

        '''Synchronize a deployed application with the given application
descriptor. This operation will replace the current descriptor
with this new descriptor only if no server restarts are
necessary for the update of the application. If some servers
need to be restarted, the synchronization is rejected with a
DeploymentException.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def syncApplicationWithoutRestart(self, descriptor, _ctx=None):
            return _M_IceGrid.Admin._op_syncApplicationWithoutRestart.invoke(self, ((descriptor, ), _ctx))

        '''Synchronize a deployed application with the given application
descriptor. This operation will replace the current descriptor
with this new descriptor only if no server restarts are
necessary for the update of the application. If some servers
need to be restarted, the synchronization is rejected with a
DeploymentException.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def begin_syncApplicationWithoutRestart(self, descriptor, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_syncApplicationWithoutRestart.begin(self, ((descriptor, ), _response, _ex, _sent, _ctx))

        '''Synchronize a deployed application with the given application
descriptor. This operation will replace the current descriptor
with this new descriptor only if no server restarts are
necessary for the update of the application. If some servers
need to be restarted, the synchronization is rejected with a
DeploymentException.

Arguments:
    descriptor The application descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def end_syncApplicationWithoutRestart(self, _r):
            return _M_IceGrid.Admin._op_syncApplicationWithoutRestart.end(self, _r)

        '''Update a deployed application with the given update application
descriptor only if no server restarts are necessary for the
update of the application. If some servers need to be
restarted, the synchronization is rejected with a
DeploymentException.

Arguments:
    descriptor The update descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def updateApplicationWithoutRestart(self, descriptor, _ctx=None):
            return _M_IceGrid.Admin._op_updateApplicationWithoutRestart.invoke(self, ((descriptor, ), _ctx))

        '''Update a deployed application with the given update application
descriptor only if no server restarts are necessary for the
update of the application. If some servers need to be
restarted, the synchronization is rejected with a
DeploymentException.

Arguments:
    descriptor The update descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def begin_updateApplicationWithoutRestart(self, descriptor, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_updateApplicationWithoutRestart.begin(self, ((descriptor, ), _response, _ex, _sent, _ctx))

        '''Update a deployed application with the given update application
descriptor only if no server restarts are necessary for the
update of the application. If some servers need to be
restarted, the synchronization is rejected with a
DeploymentException.

Arguments:
    descriptor The update descriptor.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if application deployment
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def end_updateApplicationWithoutRestart(self, _r):
            return _M_IceGrid.Admin._op_updateApplicationWithoutRestart.end(self, _r)

        '''Remove an application from IceGrid.

Arguments:
    name The application name.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def removeApplication(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_removeApplication.invoke(self, ((name, ), _ctx))

        '''Remove an application from IceGrid.

Arguments:
    name The application name.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def begin_removeApplication(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_removeApplication.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Remove an application from IceGrid.

Arguments:
    name The application name.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def end_removeApplication(self, _r):
            return _M_IceGrid.Admin._op_removeApplication.end(self, _r)

        '''Instantiate a server template from an application on the given
node.

Arguments:
    application The application name.

    node The name of the node where the server will be
deployed.

    desc The descriptor of the server instance to deploy.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if server instantiation
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def instantiateServer(self, application, node, desc, _ctx=None):
            return _M_IceGrid.Admin._op_instantiateServer.invoke(self, ((application, node, desc), _ctx))

        '''Instantiate a server template from an application on the given
node.

Arguments:
    application The application name.

    node The name of the node where the server will be
deployed.

    desc The descriptor of the server instance to deploy.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if server instantiation
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def begin_instantiateServer(self, application, node, desc, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_instantiateServer.begin(self, ((application, node, desc), _response, _ex, _sent, _ctx))

        '''Instantiate a server template from an application on the given
node.

Arguments:
    application The application name.

    node The name of the node where the server will be
deployed.

    desc The descriptor of the server instance to deploy.

Exceptions:
    AccessDeniedException Raised if the session doesn't
hold the exclusive lock or if another session is holding the
lock.

    DeploymentException Raised if server instantiation
failed.

    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def end_instantiateServer(self, _r):
            return _M_IceGrid.Admin._op_instantiateServer.end(self, _r)

        '''Patch the given application data.

Arguments:
    name The application name.

    shutdown If true, the servers depending on the data to
patch will be shut down if necessary.

Exceptions:
    ApplicationNotExistException Raised if the application
doesn't exist.

    PatchException Raised if the patch failed.'''
        def patchApplication(self, name, shutdown, _ctx=None):
            return _M_IceGrid.Admin._op_patchApplication.invoke(self, ((name, shutdown), _ctx))

        '''Patch the given application data.

Arguments:
    name The application name.

    shutdown If true, the servers depending on the data to
patch will be shut down if necessary.

Exceptions:
    ApplicationNotExistException Raised if the application
doesn't exist.

    PatchException Raised if the patch failed.'''
        def begin_patchApplication(self, name, shutdown, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_patchApplication.begin(self, ((name, shutdown), _response, _ex, _sent, _ctx))

        '''Patch the given application data.

Arguments:
    name The application name.

    shutdown If true, the servers depending on the data to
patch will be shut down if necessary.

Exceptions:
    ApplicationNotExistException Raised if the application
doesn't exist.

    PatchException Raised if the patch failed.'''
        def end_patchApplication(self, _r):
            return _M_IceGrid.Admin._op_patchApplication.end(self, _r)

        '''Get an application descriptor.

Arguments:
    name The application name.

Returns:
    The application descriptor.

Exceptions:
    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def getApplicationInfo(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getApplicationInfo.invoke(self, ((name, ), _ctx))

        '''Get an application descriptor.

Arguments:
    name The application name.

Returns:
    The application descriptor.

Exceptions:
    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def begin_getApplicationInfo(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getApplicationInfo.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Get an application descriptor.

Arguments:
    name The application name.

Returns:
    The application descriptor.

Exceptions:
    ApplicationNotExistException Raised if the application
doesn't exist.'''
        def end_getApplicationInfo(self, _r):
            return _M_IceGrid.Admin._op_getApplicationInfo.end(self, _r)

        '''Get the default application descriptor.

Exceptions:
    DeploymentException Raised if the default application
descriptor can't be accessed or is invalid.'''
        def getDefaultApplicationDescriptor(self, _ctx=None):
            return _M_IceGrid.Admin._op_getDefaultApplicationDescriptor.invoke(self, ((), _ctx))

        '''Get the default application descriptor.

Exceptions:
    DeploymentException Raised if the default application
descriptor can't be accessed or is invalid.'''
        def begin_getDefaultApplicationDescriptor(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getDefaultApplicationDescriptor.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get the default application descriptor.

Exceptions:
    DeploymentException Raised if the default application
descriptor can't be accessed or is invalid.'''
        def end_getDefaultApplicationDescriptor(self, _r):
            return _M_IceGrid.Admin._op_getDefaultApplicationDescriptor.end(self, _r)

        '''Get all the IceGrid applications currently registered.

Returns:
    The application names.'''
        def getAllApplicationNames(self, _ctx=None):
            return _M_IceGrid.Admin._op_getAllApplicationNames.invoke(self, ((), _ctx))

        '''Get all the IceGrid applications currently registered.

Returns:
    The application names.'''
        def begin_getAllApplicationNames(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getAllApplicationNames.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get all the IceGrid applications currently registered.

Returns:
    The application names.'''
        def end_getAllApplicationNames(self, _r):
            return _M_IceGrid.Admin._op_getAllApplicationNames.end(self, _r)

        '''Get the server information for the server with the given id.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

Returns:
    The server information.'''
        def getServerInfo(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getServerInfo.invoke(self, ((id, ), _ctx))

        '''Get the server information for the server with the given id.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

Returns:
    The server information.'''
        def begin_getServerInfo(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getServerInfo.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Get the server information for the server with the given id.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

Returns:
    The server information.'''
        def end_getServerInfo(self, _r):
            return _M_IceGrid.Admin._op_getServerInfo.end(self, _r)

        '''Get a server's state.

Arguments:
    id The server id.

Returns:
    The server state.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def getServerState(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getServerState.invoke(self, ((id, ), _ctx))

        '''Get a server's state.

Arguments:
    id The server id.

Returns:
    The server state.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def begin_getServerState(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getServerState.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Get a server's state.

Arguments:
    id The server id.

Returns:
    The server state.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def end_getServerState(self, _r):
            return _M_IceGrid.Admin._op_getServerState.end(self, _r)

        '''Get a server's system process id. The process id is operating
system dependent.

Arguments:
    id The server id.

Returns:
    The server's process id.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def getServerPid(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getServerPid.invoke(self, ((id, ), _ctx))

        '''Get a server's system process id. The process id is operating
system dependent.

Arguments:
    id The server id.

Returns:
    The server's process id.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def begin_getServerPid(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getServerPid.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Get a server's system process id. The process id is operating
system dependent.

Arguments:
    id The server id.

Returns:
    The server's process id.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def end_getServerPid(self, _r):
            return _M_IceGrid.Admin._op_getServerPid.end(self, _r)

        '''Get the category for server admin objects. You can manufacture a server admin
proxy from the admin proxy by changing its identity: use the server ID as name
and the returned category as category.

Returns:
    The category for server admin objects.'''
        def getServerAdminCategory(self, _ctx=None):
            return _M_IceGrid.Admin._op_getServerAdminCategory.invoke(self, ((), _ctx))

        '''Get the category for server admin objects. You can manufacture a server admin
proxy from the admin proxy by changing its identity: use the server ID as name
and the returned category as category.

Returns:
    The category for server admin objects.'''
        def begin_getServerAdminCategory(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getServerAdminCategory.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get the category for server admin objects. You can manufacture a server admin
proxy from the admin proxy by changing its identity: use the server ID as name
and the returned category as category.

Returns:
    The category for server admin objects.'''
        def end_getServerAdminCategory(self, _r):
            return _M_IceGrid.Admin._op_getServerAdminCategory.end(self, _r)

        '''Get a proxy to the server's admin object.

Arguments:
    id The server id.

Returns:
    A proxy to the server's admin object

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def getServerAdmin(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getServerAdmin.invoke(self, ((id, ), _ctx))

        '''Get a proxy to the server's admin object.

Arguments:
    id The server id.

Returns:
    A proxy to the server's admin object

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def begin_getServerAdmin(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getServerAdmin.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Get a proxy to the server's admin object.

Arguments:
    id The server id.

Returns:
    A proxy to the server's admin object

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def end_getServerAdmin(self, _r):
            return _M_IceGrid.Admin._op_getServerAdmin.end(self, _r)

        '''Enable or disable a server. A disabled server can't be started
on demand or administratively. The enable state of the server
is not persistent: if the node is shut down and restarted, the
server will be enabled by default.

Arguments:
    id The server id.

    enabled True to enable the server, false to disable it.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def enableServer(self, id, enabled, _ctx=None):
            return _M_IceGrid.Admin._op_enableServer.invoke(self, ((id, enabled), _ctx))

        '''Enable or disable a server. A disabled server can't be started
on demand or administratively. The enable state of the server
is not persistent: if the node is shut down and restarted, the
server will be enabled by default.

Arguments:
    id The server id.

    enabled True to enable the server, false to disable it.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def begin_enableServer(self, id, enabled, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_enableServer.begin(self, ((id, enabled), _response, _ex, _sent, _ctx))

        '''Enable or disable a server. A disabled server can't be started
on demand or administratively. The enable state of the server
is not persistent: if the node is shut down and restarted, the
server will be enabled by default.

Arguments:
    id The server id.

    enabled True to enable the server, false to disable it.

Exceptions:
    ServerNotExistException Raised if the server doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def end_enableServer(self, _r):
            return _M_IceGrid.Admin._op_enableServer.end(self, _r)

        '''Check if the server is enabled or disabled.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def isServerEnabled(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_isServerEnabled.invoke(self, ((id, ), _ctx))

        '''Check if the server is enabled or disabled.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def begin_isServerEnabled(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_isServerEnabled.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Check if the server is enabled or disabled.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def end_isServerEnabled(self, _r):
            return _M_IceGrid.Admin._op_isServerEnabled.end(self, _r)

        '''Start a server and wait for its activation.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    ServerStartException Raised if the server couldn't be
started.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def startServer(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_startServer.invoke(self, ((id, ), _ctx))

        '''Start a server and wait for its activation.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    ServerStartException Raised if the server couldn't be
started.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def begin_startServer(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_startServer.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Start a server and wait for its activation.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    ServerStartException Raised if the server couldn't be
started.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def end_startServer(self, _r):
            return _M_IceGrid.Admin._op_startServer.end(self, _r)

        '''Stop a server.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    ServerStopException Raised if the server couldn't be
stopped.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def stopServer(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_stopServer.invoke(self, ((id, ), _ctx))

        '''Stop a server.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    ServerStopException Raised if the server couldn't be
stopped.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def begin_stopServer(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_stopServer.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Stop a server.

Arguments:
    id The server id.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    ServerStopException Raised if the server couldn't be
stopped.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def end_stopServer(self, _r):
            return _M_IceGrid.Admin._op_stopServer.end(self, _r)

        '''Patch a server.

Arguments:
    id The server id.

    shutdown If true, servers depending on the data to patch
will be shut down if necessary.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.

    PatchException Raised if the patch failed.'''
        def patchServer(self, id, shutdown, _ctx=None):
            return _M_IceGrid.Admin._op_patchServer.invoke(self, ((id, shutdown), _ctx))

        '''Patch a server.

Arguments:
    id The server id.

    shutdown If true, servers depending on the data to patch
will be shut down if necessary.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.

    PatchException Raised if the patch failed.'''
        def begin_patchServer(self, id, shutdown, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_patchServer.begin(self, ((id, shutdown), _response, _ex, _sent, _ctx))

        '''Patch a server.

Arguments:
    id The server id.

    shutdown If true, servers depending on the data to patch
will be shut down if necessary.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.

    PatchException Raised if the patch failed.'''
        def end_patchServer(self, _r):
            return _M_IceGrid.Admin._op_patchServer.end(self, _r)

        '''Send signal to a server.

Arguments:
    id The server id.

    signal The signal, for example SIGTERM or 15.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.

    BadSignalException Raised if the signal is not recognized
by the target server.'''
        def sendSignal(self, id, signal, _ctx=None):
            return _M_IceGrid.Admin._op_sendSignal.invoke(self, ((id, signal), _ctx))

        '''Send signal to a server.

Arguments:
    id The server id.

    signal The signal, for example SIGTERM or 15.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.

    BadSignalException Raised if the signal is not recognized
by the target server.'''
        def begin_sendSignal(self, id, signal, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_sendSignal.begin(self, ((id, signal), _response, _ex, _sent, _ctx))

        '''Send signal to a server.

Arguments:
    id The server id.

    signal The signal, for example SIGTERM or 15.

Exceptions:
    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not be
reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.

    BadSignalException Raised if the signal is not recognized
by the target server.'''
        def end_sendSignal(self, _r):
            return _M_IceGrid.Admin._op_sendSignal.end(self, _r)

        '''Get all the server ids registered with IceGrid.

Returns:
    The server ids.'''
        def getAllServerIds(self, _ctx=None):
            return _M_IceGrid.Admin._op_getAllServerIds.invoke(self, ((), _ctx))

        '''Get all the server ids registered with IceGrid.

Returns:
    The server ids.'''
        def begin_getAllServerIds(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getAllServerIds.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get all the server ids registered with IceGrid.

Returns:
    The server ids.'''
        def end_getAllServerIds(self, _r):
            return _M_IceGrid.Admin._op_getAllServerIds.end(self, _r)

        '''Get the adapter information for the replica group or adapter
with the given id.

Arguments:
    id The adapter id.

Returns:
    A sequence of adapter information structures. If the
given id refers to an adapter, this sequence will contain only
one element. If the given id refers to a replica group, the
sequence will contain the adapter information of each member of
the replica group.

Exceptions:
    AdapterNotExistException Raised if the adapter or
replica group doesn't exist.'''
        def getAdapterInfo(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getAdapterInfo.invoke(self, ((id, ), _ctx))

        '''Get the adapter information for the replica group or adapter
with the given id.

Arguments:
    id The adapter id.

Returns:
    A sequence of adapter information structures. If the
given id refers to an adapter, this sequence will contain only
one element. If the given id refers to a replica group, the
sequence will contain the adapter information of each member of
the replica group.

Exceptions:
    AdapterNotExistException Raised if the adapter or
replica group doesn't exist.'''
        def begin_getAdapterInfo(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getAdapterInfo.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Get the adapter information for the replica group or adapter
with the given id.

Arguments:
    id The adapter id.

Returns:
    A sequence of adapter information structures. If the
given id refers to an adapter, this sequence will contain only
one element. If the given id refers to a replica group, the
sequence will contain the adapter information of each member of
the replica group.

Exceptions:
    AdapterNotExistException Raised if the adapter or
replica group doesn't exist.'''
        def end_getAdapterInfo(self, _r):
            return _M_IceGrid.Admin._op_getAdapterInfo.end(self, _r)

        '''Remove the adapter with the given id.

Arguments:
    id The adapter id.
Exceptions:
    AdapterNotExistException Raised if the adapter doesn't
exist.'''
        def removeAdapter(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_removeAdapter.invoke(self, ((id, ), _ctx))

        '''Remove the adapter with the given id.

Arguments:
    id The adapter id.
Exceptions:
    AdapterNotExistException Raised if the adapter doesn't
exist.'''
        def begin_removeAdapter(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_removeAdapter.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Remove the adapter with the given id.

Arguments:
    id The adapter id.
Exceptions:
    AdapterNotExistException Raised if the adapter doesn't
exist.'''
        def end_removeAdapter(self, _r):
            return _M_IceGrid.Admin._op_removeAdapter.end(self, _r)

        '''Get all the adapter ids registered with IceGrid.

Returns:
    The adapter ids.'''
        def getAllAdapterIds(self, _ctx=None):
            return _M_IceGrid.Admin._op_getAllAdapterIds.invoke(self, ((), _ctx))

        '''Get all the adapter ids registered with IceGrid.

Returns:
    The adapter ids.'''
        def begin_getAllAdapterIds(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getAllAdapterIds.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get all the adapter ids registered with IceGrid.

Returns:
    The adapter ids.'''
        def end_getAllAdapterIds(self, _r):
            return _M_IceGrid.Admin._op_getAllAdapterIds.end(self, _r)

        '''Add an object to the object registry. IceGrid will get the
object type by calling ice_id on the given proxy. The object
must be reachable.

Arguments:
    obj The object to be added to the registry.

Exceptions:
    ObjectExistsException Raised if the object is already
registered.

    DeploymentException Raised if the object can't be
added. This might be raised if the invocation on the proxy to
get the object type failed.'''
        def addObject(self, obj, _ctx=None):
            return _M_IceGrid.Admin._op_addObject.invoke(self, ((obj, ), _ctx))

        '''Add an object to the object registry. IceGrid will get the
object type by calling ice_id on the given proxy. The object
must be reachable.

Arguments:
    obj The object to be added to the registry.

Exceptions:
    ObjectExistsException Raised if the object is already
registered.

    DeploymentException Raised if the object can't be
added. This might be raised if the invocation on the proxy to
get the object type failed.'''
        def begin_addObject(self, obj, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_addObject.begin(self, ((obj, ), _response, _ex, _sent, _ctx))

        '''Add an object to the object registry. IceGrid will get the
object type by calling ice_id on the given proxy. The object
must be reachable.

Arguments:
    obj The object to be added to the registry.

Exceptions:
    ObjectExistsException Raised if the object is already
registered.

    DeploymentException Raised if the object can't be
added. This might be raised if the invocation on the proxy to
get the object type failed.'''
        def end_addObject(self, _r):
            return _M_IceGrid.Admin._op_addObject.end(self, _r)

        '''Update an object in the object registry. Only objects added
with this interface can be updated with this operation. Objects
added with deployment descriptors should be updated with the
deployment mechanism.

Arguments:
    obj The object to be updated to the registry.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.

    DeploymentException Raised if the object can't be
updated. This might happen if the object was added with a
deployment descriptor.'''
        def updateObject(self, obj, _ctx=None):
            return _M_IceGrid.Admin._op_updateObject.invoke(self, ((obj, ), _ctx))

        '''Update an object in the object registry. Only objects added
with this interface can be updated with this operation. Objects
added with deployment descriptors should be updated with the
deployment mechanism.

Arguments:
    obj The object to be updated to the registry.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.

    DeploymentException Raised if the object can't be
updated. This might happen if the object was added with a
deployment descriptor.'''
        def begin_updateObject(self, obj, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_updateObject.begin(self, ((obj, ), _response, _ex, _sent, _ctx))

        '''Update an object in the object registry. Only objects added
with this interface can be updated with this operation. Objects
added with deployment descriptors should be updated with the
deployment mechanism.

Arguments:
    obj The object to be updated to the registry.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.

    DeploymentException Raised if the object can't be
updated. This might happen if the object was added with a
deployment descriptor.'''
        def end_updateObject(self, _r):
            return _M_IceGrid.Admin._op_updateObject.end(self, _r)

        '''Add an object to the object registry and explicitly specify
its type.

Arguments:
    obj The object to be added to the registry.

    type The object type.

Exceptions:
    ObjectExistsException Raised if the object is already
registered.'''
        def addObjectWithType(self, obj, type, _ctx=None):
            return _M_IceGrid.Admin._op_addObjectWithType.invoke(self, ((obj, type), _ctx))

        '''Add an object to the object registry and explicitly specify
its type.

Arguments:
    obj The object to be added to the registry.

    type The object type.

Exceptions:
    ObjectExistsException Raised if the object is already
registered.'''
        def begin_addObjectWithType(self, obj, type, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_addObjectWithType.begin(self, ((obj, type), _response, _ex, _sent, _ctx))

        '''Add an object to the object registry and explicitly specify
its type.

Arguments:
    obj The object to be added to the registry.

    type The object type.

Exceptions:
    ObjectExistsException Raised if the object is already
registered.'''
        def end_addObjectWithType(self, _r):
            return _M_IceGrid.Admin._op_addObjectWithType.end(self, _r)

        '''Remove an object from the object registry. Only objects added
with this interface can be removed with this operation. Objects
added with deployment descriptors should be removed with the
deployment mechanism.

Arguments:
    id The identity of the object to be removed from the
registry.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.

    DeploymentException Raised if the object can't be
removed. This might happen if the object was added with a
deployment descriptor.'''
        def removeObject(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_removeObject.invoke(self, ((id, ), _ctx))

        '''Remove an object from the object registry. Only objects added
with this interface can be removed with this operation. Objects
added with deployment descriptors should be removed with the
deployment mechanism.

Arguments:
    id The identity of the object to be removed from the
registry.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.

    DeploymentException Raised if the object can't be
removed. This might happen if the object was added with a
deployment descriptor.'''
        def begin_removeObject(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_removeObject.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Remove an object from the object registry. Only objects added
with this interface can be removed with this operation. Objects
added with deployment descriptors should be removed with the
deployment mechanism.

Arguments:
    id The identity of the object to be removed from the
registry.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.

    DeploymentException Raised if the object can't be
removed. This might happen if the object was added with a
deployment descriptor.'''
        def end_removeObject(self, _r):
            return _M_IceGrid.Admin._op_removeObject.end(self, _r)

        '''Get the object info for the object with the given identity.

Arguments:
    id The identity of the object.

Returns:
    The object info.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.'''
        def getObjectInfo(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getObjectInfo.invoke(self, ((id, ), _ctx))

        '''Get the object info for the object with the given identity.

Arguments:
    id The identity of the object.

Returns:
    The object info.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.'''
        def begin_getObjectInfo(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getObjectInfo.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Get the object info for the object with the given identity.

Arguments:
    id The identity of the object.

Returns:
    The object info.

Exceptions:
    ObjectNotRegisteredException Raised if the object isn't
registered with the registry.'''
        def end_getObjectInfo(self, _r):
            return _M_IceGrid.Admin._op_getObjectInfo.end(self, _r)

        '''Get the object info of all the registered objects with the
given type.

Arguments:
    type The type of the object.

Returns:
    The object infos.'''
        def getObjectInfosByType(self, type, _ctx=None):
            return _M_IceGrid.Admin._op_getObjectInfosByType.invoke(self, ((type, ), _ctx))

        '''Get the object info of all the registered objects with the
given type.

Arguments:
    type The type of the object.

Returns:
    The object infos.'''
        def begin_getObjectInfosByType(self, type, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getObjectInfosByType.begin(self, ((type, ), _response, _ex, _sent, _ctx))

        '''Get the object info of all the registered objects with the
given type.

Arguments:
    type The type of the object.

Returns:
    The object infos.'''
        def end_getObjectInfosByType(self, _r):
            return _M_IceGrid.Admin._op_getObjectInfosByType.end(self, _r)

        '''Get the object info of all the registered objects whose stringified
identities match the given expression.

Arguments:
    expr The expression to match against the stringified
identities of registered objects. The expression may contain
a trailing wildcard (*) character.

Returns:
    All the object infos with a stringified identity
matching the given expression.'''
        def getAllObjectInfos(self, expr, _ctx=None):
            return _M_IceGrid.Admin._op_getAllObjectInfos.invoke(self, ((expr, ), _ctx))

        '''Get the object info of all the registered objects whose stringified
identities match the given expression.

Arguments:
    expr The expression to match against the stringified
identities of registered objects. The expression may contain
a trailing wildcard (*) character.

Returns:
    All the object infos with a stringified identity
matching the given expression.'''
        def begin_getAllObjectInfos(self, expr, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getAllObjectInfos.begin(self, ((expr, ), _response, _ex, _sent, _ctx))

        '''Get the object info of all the registered objects whose stringified
identities match the given expression.

Arguments:
    expr The expression to match against the stringified
identities of registered objects. The expression may contain
a trailing wildcard (*) character.

Returns:
    All the object infos with a stringified identity
matching the given expression.'''
        def end_getAllObjectInfos(self, _r):
            return _M_IceGrid.Admin._op_getAllObjectInfos.end(self, _r)

        '''Ping an IceGrid node to see if it is active.

Arguments:
    name The node name.

Returns:
    true if the node ping succeeded, false otherwise.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.'''
        def pingNode(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_pingNode.invoke(self, ((name, ), _ctx))

        '''Ping an IceGrid node to see if it is active.

Arguments:
    name The node name.

Returns:
    true if the node ping succeeded, false otherwise.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.'''
        def begin_pingNode(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_pingNode.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Ping an IceGrid node to see if it is active.

Arguments:
    name The node name.

Returns:
    true if the node ping succeeded, false otherwise.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.'''
        def end_pingNode(self, _r):
            return _M_IceGrid.Admin._op_pingNode.end(self, _r)

        '''Get the load averages of the node.

Arguments:
    name The node name.

Returns:
    The node load information.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def getNodeLoad(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeLoad.invoke(self, ((name, ), _ctx))

        '''Get the load averages of the node.

Arguments:
    name The node name.

Returns:
    The node load information.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def begin_getNodeLoad(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeLoad.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Get the load averages of the node.

Arguments:
    name The node name.

Returns:
    The node load information.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def end_getNodeLoad(self, _r):
            return _M_IceGrid.Admin._op_getNodeLoad.end(self, _r)

        '''Get the node information for the node with the given name.

Arguments:
    name The node name.

Returns:
    The node information.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def getNodeInfo(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeInfo.invoke(self, ((name, ), _ctx))

        '''Get the node information for the node with the given name.

Arguments:
    name The node name.

Returns:
    The node information.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def begin_getNodeInfo(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeInfo.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Get the node information for the node with the given name.

Arguments:
    name The node name.

Returns:
    The node information.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def end_getNodeInfo(self, _r):
            return _M_IceGrid.Admin._op_getNodeInfo.end(self, _r)

        '''Get a proxy to the IceGrid node's admin object.

Arguments:
    name The IceGrid node name

Returns:
    A proxy to the IceGrid node's admin object

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def getNodeAdmin(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeAdmin.invoke(self, ((name, ), _ctx))

        '''Get a proxy to the IceGrid node's admin object.

Arguments:
    name The IceGrid node name

Returns:
    A proxy to the IceGrid node's admin object

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def begin_getNodeAdmin(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeAdmin.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Get a proxy to the IceGrid node's admin object.

Arguments:
    name The IceGrid node name

Returns:
    A proxy to the IceGrid node's admin object

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def end_getNodeAdmin(self, _r):
            return _M_IceGrid.Admin._op_getNodeAdmin.end(self, _r)

        '''Get the number of physical processor sockets for the machine
running the node with the given name.

Note that this method will return 1 on operating systems where
this can't be automatically determined and where the
IceGrid.Node.ProcessorSocketCount property for the node is not
set.

Arguments:
    name The node name.

Returns:
    The number of processor sockets or 1 if the number of
sockets can't determined.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def getNodeProcessorSocketCount(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeProcessorSocketCount.invoke(self, ((name, ), _ctx))

        '''Get the number of physical processor sockets for the machine
running the node with the given name.

Note that this method will return 1 on operating systems where
this can't be automatically determined and where the
IceGrid.Node.ProcessorSocketCount property for the node is not
set.

Arguments:
    name The node name.

Returns:
    The number of processor sockets or 1 if the number of
sockets can't determined.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def begin_getNodeProcessorSocketCount(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeProcessorSocketCount.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Get the number of physical processor sockets for the machine
running the node with the given name.

Note that this method will return 1 on operating systems where
this can't be automatically determined and where the
IceGrid.Node.ProcessorSocketCount property for the node is not
set.

Arguments:
    name The node name.

Returns:
    The number of processor sockets or 1 if the number of
sockets can't determined.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def end_getNodeProcessorSocketCount(self, _r):
            return _M_IceGrid.Admin._op_getNodeProcessorSocketCount.end(self, _r)

        '''Shutdown an IceGrid node.

Arguments:
    name The node name.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def shutdownNode(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_shutdownNode.invoke(self, ((name, ), _ctx))

        '''Shutdown an IceGrid node.

Arguments:
    name The node name.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def begin_shutdownNode(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_shutdownNode.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Shutdown an IceGrid node.

Arguments:
    name The node name.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def end_shutdownNode(self, _r):
            return _M_IceGrid.Admin._op_shutdownNode.end(self, _r)

        '''Get the hostname of this node.

Arguments:
    name The node name.

Returns:
    The node hostname.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def getNodeHostname(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeHostname.invoke(self, ((name, ), _ctx))

        '''Get the hostname of this node.

Arguments:
    name The node name.

Returns:
    The node hostname.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def begin_getNodeHostname(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeHostname.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Get the hostname of this node.

Arguments:
    name The node name.

Returns:
    The node hostname.

Exceptions:
    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not be
reached.'''
        def end_getNodeHostname(self, _r):
            return _M_IceGrid.Admin._op_getNodeHostname.end(self, _r)

        '''Get all the IceGrid nodes currently registered.

Returns:
    The node names.'''
        def getAllNodeNames(self, _ctx=None):
            return _M_IceGrid.Admin._op_getAllNodeNames.invoke(self, ((), _ctx))

        '''Get all the IceGrid nodes currently registered.

Returns:
    The node names.'''
        def begin_getAllNodeNames(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getAllNodeNames.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get all the IceGrid nodes currently registered.

Returns:
    The node names.'''
        def end_getAllNodeNames(self, _r):
            return _M_IceGrid.Admin._op_getAllNodeNames.end(self, _r)

        '''Ping an IceGrid registry to see if it is active.

Arguments:
    name The registry name.

Returns:
    true if the registry ping succeeded, false otherwise.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.'''
        def pingRegistry(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_pingRegistry.invoke(self, ((name, ), _ctx))

        '''Ping an IceGrid registry to see if it is active.

Arguments:
    name The registry name.

Returns:
    true if the registry ping succeeded, false otherwise.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.'''
        def begin_pingRegistry(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_pingRegistry.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Ping an IceGrid registry to see if it is active.

Arguments:
    name The registry name.

Returns:
    true if the registry ping succeeded, false otherwise.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.'''
        def end_pingRegistry(self, _r):
            return _M_IceGrid.Admin._op_pingRegistry.end(self, _r)

        '''Get the registry information for the registry with the given name.

Arguments:
    name The registry name.

Returns:
    The registry information.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.

    RegistryUnreachableException Raised if the registry could not be
reached.'''
        def getRegistryInfo(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getRegistryInfo.invoke(self, ((name, ), _ctx))

        '''Get the registry information for the registry with the given name.

Arguments:
    name The registry name.

Returns:
    The registry information.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.

    RegistryUnreachableException Raised if the registry could not be
reached.'''
        def begin_getRegistryInfo(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getRegistryInfo.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Get the registry information for the registry with the given name.

Arguments:
    name The registry name.

Returns:
    The registry information.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.

    RegistryUnreachableException Raised if the registry could not be
reached.'''
        def end_getRegistryInfo(self, _r):
            return _M_IceGrid.Admin._op_getRegistryInfo.end(self, _r)

        '''Get a proxy to the IceGrid registry's admin object.

Arguments:
    name The registry name

Returns:
    A proxy to the IceGrid registry's admin object

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.'''
        def getRegistryAdmin(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getRegistryAdmin.invoke(self, ((name, ), _ctx))

        '''Get a proxy to the IceGrid registry's admin object.

Arguments:
    name The registry name

Returns:
    A proxy to the IceGrid registry's admin object

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.'''
        def begin_getRegistryAdmin(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getRegistryAdmin.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Get a proxy to the IceGrid registry's admin object.

Arguments:
    name The registry name

Returns:
    A proxy to the IceGrid registry's admin object

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.'''
        def end_getRegistryAdmin(self, _r):
            return _M_IceGrid.Admin._op_getRegistryAdmin.end(self, _r)

        '''Shutdown an IceGrid registry.

Arguments:
    name The registry name.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.

    RegistryUnreachableException Raised if the registry could not be
reached.'''
        def shutdownRegistry(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_shutdownRegistry.invoke(self, ((name, ), _ctx))

        '''Shutdown an IceGrid registry.

Arguments:
    name The registry name.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.

    RegistryUnreachableException Raised if the registry could not be
reached.'''
        def begin_shutdownRegistry(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_shutdownRegistry.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        '''Shutdown an IceGrid registry.

Arguments:
    name The registry name.

Exceptions:
    RegistryNotExistException Raised if the registry doesn't exist.

    RegistryUnreachableException Raised if the registry could not be
reached.'''
        def end_shutdownRegistry(self, _r):
            return _M_IceGrid.Admin._op_shutdownRegistry.end(self, _r)

        '''Get all the IceGrid registries currently registered.

Returns:
    The registry names.'''
        def getAllRegistryNames(self, _ctx=None):
            return _M_IceGrid.Admin._op_getAllRegistryNames.invoke(self, ((), _ctx))

        '''Get all the IceGrid registries currently registered.

Returns:
    The registry names.'''
        def begin_getAllRegistryNames(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getAllRegistryNames.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get all the IceGrid registries currently registered.

Returns:
    The registry names.'''
        def end_getAllRegistryNames(self, _r):
            return _M_IceGrid.Admin._op_getAllRegistryNames.end(self, _r)

        '''Shut down the IceGrid registry.'''
        def shutdown(self, _ctx=None):
            return _M_IceGrid.Admin._op_shutdown.invoke(self, ((), _ctx))

        '''Shut down the IceGrid registry.'''
        def begin_shutdown(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_shutdown.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Shut down the IceGrid registry.'''
        def end_shutdown(self, _r):
            return _M_IceGrid.Admin._op_shutdown.end(self, _r)

        '''Returns the checksums for the IceGrid Slice definitions.

Returns:
    A dictionary mapping Slice type ids to their checksums.'''
        def getSliceChecksums(self, _ctx=None):
            return _M_IceGrid.Admin._op_getSliceChecksums.invoke(self, ((), _ctx))

        '''Returns the checksums for the IceGrid Slice definitions.

Returns:
    A dictionary mapping Slice type ids to their checksums.'''
        def begin_getSliceChecksums(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Admin._op_getSliceChecksums.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Returns the checksums for the IceGrid Slice definitions.

Returns:
    A dictionary mapping Slice type ids to their checksums.'''
        def end_getSliceChecksums(self, _r):
            return _M_IceGrid.Admin._op_getSliceChecksums.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.AdminPrx.ice_checkedCast(proxy, '::IceGrid::Admin', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceGrid.AdminPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceGrid::Admin'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceGrid._t_AdminPrx = IcePy.defineProxy('::IceGrid::Admin', AdminPrx)

    _M_IceGrid._t_Admin = IcePy.defineClass('::IceGrid::Admin', Admin, -1, (), True, False, None, (), ())
    Admin._ice_type = _M_IceGrid._t_Admin

    Admin._op_addApplication = IcePy.Operation('addApplication', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_ApplicationDescriptor, False, 0),), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_DeploymentException))
    Admin._op_syncApplication = IcePy.Operation('syncApplication', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_ApplicationDescriptor, False, 0),), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_ApplicationNotExistException))
    Admin._op_updateApplication = IcePy.Operation('updateApplication', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_ApplicationUpdateDescriptor, False, 0),), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_ApplicationNotExistException))
    Admin._op_syncApplicationWithoutRestart = IcePy.Operation('syncApplicationWithoutRestart', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_ApplicationDescriptor, False, 0),), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_ApplicationNotExistException))
    Admin._op_updateApplicationWithoutRestart = IcePy.Operation('updateApplicationWithoutRestart', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceGrid._t_ApplicationUpdateDescriptor, False, 0),), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_ApplicationNotExistException))
    Admin._op_removeApplication = IcePy.Operation('removeApplication', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0),), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_ApplicationNotExistException))
    Admin._op_instantiateServer = IcePy.Operation('instantiateServer', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_string, False, 0), ((), _M_IceGrid._t_ServerInstanceDescriptor, False, 0)), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_ApplicationNotExistException, _M_IceGrid._t_DeploymentException))
    Admin._op_patchApplication = IcePy.Operation('patchApplication', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_bool, False, 0)), (), None, (_M_IceGrid._t_ApplicationNotExistException, _M_IceGrid._t_PatchException))
    Admin._op_getApplicationInfo = IcePy.Operation('getApplicationInfo', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceGrid._t_ApplicationInfo, False, 0), (_M_IceGrid._t_ApplicationNotExistException,))
    Admin._op_getDefaultApplicationDescriptor = IcePy.Operation('getDefaultApplicationDescriptor', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_IceGrid._t_ApplicationDescriptor, False, 0), (_M_IceGrid._t_DeploymentException,))
    Admin._op_getAllApplicationNames = IcePy.Operation('getAllApplicationNames', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_Ice._t_StringSeq, False, 0), ())
    Admin._op_getServerInfo = IcePy.Operation('getServerInfo', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceGrid._t_ServerInfo, False, 0), (_M_IceGrid._t_ServerNotExistException,))
    Admin._op_getServerState = IcePy.Operation('getServerState', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceGrid._t_ServerState, False, 0), (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_getServerPid = IcePy.Operation('getServerPid', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_int, False, 0), (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_getServerAdminCategory = IcePy.Operation('getServerAdminCategory', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (), (), ((), IcePy._t_string, False, 0), ())
    Admin._op_getServerAdmin = IcePy.Operation('getServerAdmin', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_ObjectPrx, False, 0), (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_enableServer = IcePy.Operation('enableServer', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_bool, False, 0)), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_isServerEnabled = IcePy.Operation('isServerEnabled', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_bool, False, 0), (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_startServer = IcePy.Operation('startServer', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), IcePy._t_string, False, 0),), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_ServerStartException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_stopServer = IcePy.Operation('stopServer', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), IcePy._t_string, False, 0),), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_ServerStopException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_patchServer = IcePy.Operation('patchServer', Ice.OperationMode.Normal, Ice.OperationMode.Normal, True, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_bool, False, 0)), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_PatchException))
    Admin._op_sendSignal = IcePy.Operation('sendSignal', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_string, False, 0)), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_BadSignalException))
    Admin._op_getAllServerIds = IcePy.Operation('getAllServerIds', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_Ice._t_StringSeq, False, 0), ())
    Admin._op_getAdapterInfo = IcePy.Operation('getAdapterInfo', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceGrid._t_AdapterInfoSeq, False, 0), (_M_IceGrid._t_AdapterNotExistException,))
    Admin._op_removeAdapter = IcePy.Operation('removeAdapter', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0),), (), None, (_M_IceGrid._t_AdapterNotExistException, _M_IceGrid._t_DeploymentException))
    Admin._op_getAllAdapterIds = IcePy.Operation('getAllAdapterIds', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_Ice._t_StringSeq, False, 0), ())
    Admin._op_addObject = IcePy.Operation('addObject', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_ObjectPrx, False, 0),), (), None, (_M_IceGrid._t_ObjectExistsException, _M_IceGrid._t_DeploymentException))
    Admin._op_updateObject = IcePy.Operation('updateObject', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_ObjectPrx, False, 0),), (), None, (_M_IceGrid._t_ObjectNotRegisteredException, _M_IceGrid._t_DeploymentException))
    Admin._op_addObjectWithType = IcePy.Operation('addObjectWithType', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_ObjectPrx, False, 0), ((), IcePy._t_string, False, 0)), (), None, (_M_IceGrid._t_ObjectExistsException, _M_IceGrid._t_DeploymentException))
    Admin._op_removeObject = IcePy.Operation('removeObject', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_Ice._t_Identity, False, 0),), (), None, (_M_IceGrid._t_ObjectNotRegisteredException, _M_IceGrid._t_DeploymentException))
    Admin._op_getObjectInfo = IcePy.Operation('getObjectInfo', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), _M_Ice._t_Identity, False, 0),), (), ((), _M_IceGrid._t_ObjectInfo, False, 0), (_M_IceGrid._t_ObjectNotRegisteredException,))
    Admin._op_getObjectInfosByType = IcePy.Operation('getObjectInfosByType', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceGrid._t_ObjectInfoSeq, False, 0), ())
    Admin._op_getAllObjectInfos = IcePy.Operation('getAllObjectInfos', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceGrid._t_ObjectInfoSeq, False, 0), ())
    Admin._op_pingNode = IcePy.Operation('pingNode', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_bool, False, 0), (_M_IceGrid._t_NodeNotExistException,))
    Admin._op_getNodeLoad = IcePy.Operation('getNodeLoad', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceGrid._t_LoadInfo, False, 0), (_M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    Admin._op_getNodeInfo = IcePy.Operation('getNodeInfo', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceGrid._t_NodeInfo, False, 0), (_M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    Admin._op_getNodeAdmin = IcePy.Operation('getNodeAdmin', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_ObjectPrx, False, 0), (_M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    Admin._op_getNodeProcessorSocketCount = IcePy.Operation('getNodeProcessorSocketCount', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_int, False, 0), (_M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    Admin._op_shutdownNode = IcePy.Operation('shutdownNode', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0),), (), None, (_M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    Admin._op_getNodeHostname = IcePy.Operation('getNodeHostname', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_string, False, 0), (_M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    Admin._op_getAllNodeNames = IcePy.Operation('getAllNodeNames', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_Ice._t_StringSeq, False, 0), ())
    Admin._op_pingRegistry = IcePy.Operation('pingRegistry', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_bool, False, 0), (_M_IceGrid._t_RegistryNotExistException,))
    Admin._op_getRegistryInfo = IcePy.Operation('getRegistryInfo', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceGrid._t_RegistryInfo, False, 0), (_M_IceGrid._t_RegistryNotExistException, _M_IceGrid._t_RegistryUnreachableException))
    Admin._op_getRegistryAdmin = IcePy.Operation('getRegistryAdmin', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_ObjectPrx, False, 0), (_M_IceGrid._t_RegistryNotExistException,))
    Admin._op_shutdownRegistry = IcePy.Operation('shutdownRegistry', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), IcePy._t_string, False, 0),), (), None, (_M_IceGrid._t_RegistryNotExistException, _M_IceGrid._t_RegistryUnreachableException))
    Admin._op_getAllRegistryNames = IcePy.Operation('getAllRegistryNames', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (), (), ((), _M_Ice._t_StringSeq, False, 0), ())
    Admin._op_shutdown = IcePy.Operation('shutdown', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), None, ())
    Admin._op_getSliceChecksums = IcePy.Operation('getSliceChecksums', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_Ice._t_SliceChecksumDict, False, 0), ())

    _M_IceGrid.Admin = Admin
    del Admin

    _M_IceGrid.AdminPrx = AdminPrx
    del AdminPrx

if 'FileIterator' not in _M_IceGrid.__dict__:
    _M_IceGrid.FileIterator = Ice.createTempClass()
    class FileIterator(Ice.Object):
        '''This interface provides access to IceGrid log file contents.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceGrid.FileIterator:
                raise RuntimeError('IceGrid.FileIterator is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::FileIterator')

        def ice_id(self, current=None):
            return '::IceGrid::FileIterator'

        def ice_staticId():
            return '::IceGrid::FileIterator'
        ice_staticId = staticmethod(ice_staticId)

        def read(self, size, current=None):
            '''Read lines from the log file.

Arguments:
    size Specifies the maximum number of bytes to be
received. The server will ensure that the returned message
doesn't exceed the given size.

    lines The lines read from the file. If there was nothing to
read from the file since the last call to read, an empty
sequence is returned. The last line of the sequence is always
incomplete (and therefore no '\n' should be added when writing
the last line to the to the output device).

Returns:
    True if EOF is encountered.

Exceptions:
    FileNotAvailableException Raised if there was a problem
to read lines from the file.'''
            pass

        def destroy(self, current=None):
            '''Destroy the iterator.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_FileIterator)

        __repr__ = __str__

    _M_IceGrid.FileIteratorPrx = Ice.createTempClass()
    class FileIteratorPrx(Ice.ObjectPrx):

        '''Read lines from the log file.

Arguments:
    size Specifies the maximum number of bytes to be
received. The server will ensure that the returned message
doesn't exceed the given size.

    lines The lines read from the file. If there was nothing to
read from the file since the last call to read, an empty
sequence is returned. The last line of the sequence is always
incomplete (and therefore no '\n' should be added when writing
the last line to the to the output device).

Returns:
    True if EOF is encountered.

Exceptions:
    FileNotAvailableException Raised if there was a problem
to read lines from the file.'''
        def read(self, size, _ctx=None):
            return _M_IceGrid.FileIterator._op_read.invoke(self, ((size, ), _ctx))

        '''Read lines from the log file.

Arguments:
    size Specifies the maximum number of bytes to be
received. The server will ensure that the returned message
doesn't exceed the given size.

    lines The lines read from the file. If there was nothing to
read from the file since the last call to read, an empty
sequence is returned. The last line of the sequence is always
incomplete (and therefore no '\n' should be added when writing
the last line to the to the output device).

Returns:
    True if EOF is encountered.

Exceptions:
    FileNotAvailableException Raised if there was a problem
to read lines from the file.'''
        def begin_read(self, size, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.FileIterator._op_read.begin(self, ((size, ), _response, _ex, _sent, _ctx))

        '''Read lines from the log file.

Arguments:
    size Specifies the maximum number of bytes to be
received. The server will ensure that the returned message
doesn't exceed the given size.

    lines The lines read from the file. If there was nothing to
read from the file since the last call to read, an empty
sequence is returned. The last line of the sequence is always
incomplete (and therefore no '\n' should be added when writing
the last line to the to the output device).

Returns:
    True if EOF is encountered.

Exceptions:
    FileNotAvailableException Raised if there was a problem
to read lines from the file.'''
        def end_read(self, _r):
            return _M_IceGrid.FileIterator._op_read.end(self, _r)

        '''Destroy the iterator.'''
        def destroy(self, _ctx=None):
            return _M_IceGrid.FileIterator._op_destroy.invoke(self, ((), _ctx))

        '''Destroy the iterator.'''
        def begin_destroy(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.FileIterator._op_destroy.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Destroy the iterator.'''
        def end_destroy(self, _r):
            return _M_IceGrid.FileIterator._op_destroy.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.FileIteratorPrx.ice_checkedCast(proxy, '::IceGrid::FileIterator', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceGrid.FileIteratorPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceGrid::FileIterator'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceGrid._t_FileIteratorPrx = IcePy.defineProxy('::IceGrid::FileIterator', FileIteratorPrx)

    _M_IceGrid._t_FileIterator = IcePy.defineClass('::IceGrid::FileIterator', FileIterator, -1, (), True, False, None, (), ())
    FileIterator._ice_type = _M_IceGrid._t_FileIterator

    FileIterator._op_read = IcePy.Operation('read', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_int, False, 0),), (((), _M_Ice._t_StringSeq, False, 0),), ((), IcePy._t_bool, False, 0), (_M_IceGrid._t_FileNotAvailableException,))
    FileIterator._op_destroy = IcePy.Operation('destroy', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), None, ())

    _M_IceGrid.FileIterator = FileIterator
    del FileIterator

    _M_IceGrid.FileIteratorPrx = FileIteratorPrx
    del FileIteratorPrx

if 'RegistryObserver' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_RegistryObserver = IcePy.declareClass('::IceGrid::RegistryObserver')
    _M_IceGrid._t_RegistryObserverPrx = IcePy.declareProxy('::IceGrid::RegistryObserver')

if 'NodeObserver' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_NodeObserver = IcePy.declareClass('::IceGrid::NodeObserver')
    _M_IceGrid._t_NodeObserverPrx = IcePy.declareProxy('::IceGrid::NodeObserver')

if 'ApplicationObserver' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_ApplicationObserver = IcePy.declareClass('::IceGrid::ApplicationObserver')
    _M_IceGrid._t_ApplicationObserverPrx = IcePy.declareProxy('::IceGrid::ApplicationObserver')

if 'AdapterObserver' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_AdapterObserver = IcePy.declareClass('::IceGrid::AdapterObserver')
    _M_IceGrid._t_AdapterObserverPrx = IcePy.declareProxy('::IceGrid::AdapterObserver')

if 'ObjectObserver' not in _M_IceGrid.__dict__:
    _M_IceGrid._t_ObjectObserver = IcePy.declareClass('::IceGrid::ObjectObserver')
    _M_IceGrid._t_ObjectObserverPrx = IcePy.declareProxy('::IceGrid::ObjectObserver')

if 'AdminSession' not in _M_IceGrid.__dict__:
    _M_IceGrid.AdminSession = Ice.createTempClass()
    class AdminSession(_M_Glacier2.Session):
        '''Used by administrative clients to view,
update, and receive observer updates from the IceGrid
registry. Admin sessions are created either with the Registry
object or the registry admin Glacier2.SessionManager object.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceGrid.AdminSession:
                raise RuntimeError('IceGrid.AdminSession is an abstract class')

        def ice_ids(self, current=None):
            return ('::Glacier2::Session', '::Ice::Object', '::IceGrid::AdminSession')

        def ice_id(self, current=None):
            return '::IceGrid::AdminSession'

        def ice_staticId():
            return '::IceGrid::AdminSession'
        ice_staticId = staticmethod(ice_staticId)

        def keepAlive(self, current=None):
            '''Keep the session alive. Clients should call this operation
regularly to prevent the server from reaping the session.'''
            pass

        def getAdmin(self, current=None):
            '''Get the admin interface. The admin object returned by this
operation can only be accessed by the session.

Returns:
    The admin interface proxy.'''
            pass

        def getAdminCallbackTemplate(self, current=None):
            '''Get a "template" proxy for admin callback objects.
An Admin client uses this proxy to set the category of its callback
objects, and the published endpoints of the object adapter hosting
the admin callback objects.

Returns:
    A template proxy. The returned proxy is null when the Admin
session was established using Glacier2.'''
            pass

        def setObservers(self, registryObs, nodeObs, appObs, adptObs, objObs, current=None):
            '''Set the observer proxies that receive
notifications when the state of the registry
or nodes changes.

Arguments:
    registryObs The registry observer.

    nodeObs The node observer.

    appObs The application observer.

    adptObs The adapter observer.

    objObs The object observer.

Exceptions:
    ObserverAlreadyRegisteredException Raised if an
observer is already registered with this registry.'''
            pass

        def setObserversByIdentity(self, registryObs, nodeObs, appObs, adptObs, objObs, current=None):
            '''Set the observer identities that receive
notifications the state of the registry
or nodes changes. This operation should be used by clients that
are using a bidirectional connection to communicate with the
session.

Arguments:
    registryObs The registry observer identity.

    nodeObs The node observer identity.

    appObs The application observer.

    adptObs The adapter observer.

    objObs The object observer.

Exceptions:
    ObserverAlreadyRegisteredException Raised if an
observer is already registered with this registry.'''
            pass

        def startUpdate(self, current=None):
            '''Acquires an exclusive lock to start updating the registry applications.

Returns:
    The current serial.

Exceptions:
    AccessDeniedException Raised if the exclusive lock can't be
acquired. This might happen if the lock is currently acquired by
another session.'''
            pass

        def finishUpdate(self, current=None):
            '''Finish updating the registry and release the exclusive lock.

Exceptions:
    AccessDeniedException Raised if the session doesn't hold the
exclusive lock.'''
            pass

        def getReplicaName(self, current=None):
            '''Get the name of the registry replica hosting this session.

Returns:
    The replica name of the registry.'''
            pass

        def openServerLog(self, id, path, count, current=None):
            '''Open the given server log file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    path The path of the log file. A log file can be opened
only if it's declared in the server or service deployment
descriptor.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
            pass

        def openServerStdErr(self, id, count, current=None):
            '''Open the given server stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
            pass

        def openServerStdOut(self, id, count, current=None):
            '''Open the given server stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
            pass

        def openNodeStdErr(self, name, count, current=None):
            '''Open the given node stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The node name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.'''
            pass

        def openNodeStdOut(self, name, count, current=None):
            '''Open the given node stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The node name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.'''
            pass

        def openRegistryStdErr(self, name, count, current=None):
            '''Open the given registry stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The registry name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    RegistryNotExistException Raised if the registry
doesn't exist.

    RegistryUnreachableException Raised if the registry
could not be reached.'''
            pass

        def openRegistryStdOut(self, name, count, current=None):
            '''Open the given registry stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The registry name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    RegistryNotExistException Raised if the registry
doesn't exist.

    RegistryUnreachableException Raised if the registry
could not be reached.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_AdminSession)

        __repr__ = __str__

    _M_IceGrid.AdminSessionPrx = Ice.createTempClass()
    class AdminSessionPrx(_M_Glacier2.SessionPrx):

        '''Keep the session alive. Clients should call this operation
regularly to prevent the server from reaping the session.'''
        def keepAlive(self, _ctx=None):
            return _M_IceGrid.AdminSession._op_keepAlive.invoke(self, ((), _ctx))

        '''Keep the session alive. Clients should call this operation
regularly to prevent the server from reaping the session.'''
        def begin_keepAlive(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_keepAlive.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Keep the session alive. Clients should call this operation
regularly to prevent the server from reaping the session.'''
        def end_keepAlive(self, _r):
            return _M_IceGrid.AdminSession._op_keepAlive.end(self, _r)

        '''Get the admin interface. The admin object returned by this
operation can only be accessed by the session.

Returns:
    The admin interface proxy.'''
        def getAdmin(self, _ctx=None):
            return _M_IceGrid.AdminSession._op_getAdmin.invoke(self, ((), _ctx))

        '''Get the admin interface. The admin object returned by this
operation can only be accessed by the session.

Returns:
    The admin interface proxy.'''
        def begin_getAdmin(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_getAdmin.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get the admin interface. The admin object returned by this
operation can only be accessed by the session.

Returns:
    The admin interface proxy.'''
        def end_getAdmin(self, _r):
            return _M_IceGrid.AdminSession._op_getAdmin.end(self, _r)

        '''Get a "template" proxy for admin callback objects.
An Admin client uses this proxy to set the category of its callback
objects, and the published endpoints of the object adapter hosting
the admin callback objects.

Returns:
    A template proxy. The returned proxy is null when the Admin
session was established using Glacier2.'''
        def getAdminCallbackTemplate(self, _ctx=None):
            return _M_IceGrid.AdminSession._op_getAdminCallbackTemplate.invoke(self, ((), _ctx))

        '''Get a "template" proxy for admin callback objects.
An Admin client uses this proxy to set the category of its callback
objects, and the published endpoints of the object adapter hosting
the admin callback objects.

Returns:
    A template proxy. The returned proxy is null when the Admin
session was established using Glacier2.'''
        def begin_getAdminCallbackTemplate(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_getAdminCallbackTemplate.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get a "template" proxy for admin callback objects.
An Admin client uses this proxy to set the category of its callback
objects, and the published endpoints of the object adapter hosting
the admin callback objects.

Returns:
    A template proxy. The returned proxy is null when the Admin
session was established using Glacier2.'''
        def end_getAdminCallbackTemplate(self, _r):
            return _M_IceGrid.AdminSession._op_getAdminCallbackTemplate.end(self, _r)

        '''Set the observer proxies that receive
notifications when the state of the registry
or nodes changes.

Arguments:
    registryObs The registry observer.

    nodeObs The node observer.

    appObs The application observer.

    adptObs The adapter observer.

    objObs The object observer.

Exceptions:
    ObserverAlreadyRegisteredException Raised if an
observer is already registered with this registry.'''
        def setObservers(self, registryObs, nodeObs, appObs, adptObs, objObs, _ctx=None):
            return _M_IceGrid.AdminSession._op_setObservers.invoke(self, ((registryObs, nodeObs, appObs, adptObs, objObs), _ctx))

        '''Set the observer proxies that receive
notifications when the state of the registry
or nodes changes.

Arguments:
    registryObs The registry observer.

    nodeObs The node observer.

    appObs The application observer.

    adptObs The adapter observer.

    objObs The object observer.

Exceptions:
    ObserverAlreadyRegisteredException Raised if an
observer is already registered with this registry.'''
        def begin_setObservers(self, registryObs, nodeObs, appObs, adptObs, objObs, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_setObservers.begin(self, ((registryObs, nodeObs, appObs, adptObs, objObs), _response, _ex, _sent, _ctx))

        '''Set the observer proxies that receive
notifications when the state of the registry
or nodes changes.

Arguments:
    registryObs The registry observer.

    nodeObs The node observer.

    appObs The application observer.

    adptObs The adapter observer.

    objObs The object observer.

Exceptions:
    ObserverAlreadyRegisteredException Raised if an
observer is already registered with this registry.'''
        def end_setObservers(self, _r):
            return _M_IceGrid.AdminSession._op_setObservers.end(self, _r)

        '''Set the observer identities that receive
notifications the state of the registry
or nodes changes. This operation should be used by clients that
are using a bidirectional connection to communicate with the
session.

Arguments:
    registryObs The registry observer identity.

    nodeObs The node observer identity.

    appObs The application observer.

    adptObs The adapter observer.

    objObs The object observer.

Exceptions:
    ObserverAlreadyRegisteredException Raised if an
observer is already registered with this registry.'''
        def setObserversByIdentity(self, registryObs, nodeObs, appObs, adptObs, objObs, _ctx=None):
            return _M_IceGrid.AdminSession._op_setObserversByIdentity.invoke(self, ((registryObs, nodeObs, appObs, adptObs, objObs), _ctx))

        '''Set the observer identities that receive
notifications the state of the registry
or nodes changes. This operation should be used by clients that
are using a bidirectional connection to communicate with the
session.

Arguments:
    registryObs The registry observer identity.

    nodeObs The node observer identity.

    appObs The application observer.

    adptObs The adapter observer.

    objObs The object observer.

Exceptions:
    ObserverAlreadyRegisteredException Raised if an
observer is already registered with this registry.'''
        def begin_setObserversByIdentity(self, registryObs, nodeObs, appObs, adptObs, objObs, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_setObserversByIdentity.begin(self, ((registryObs, nodeObs, appObs, adptObs, objObs), _response, _ex, _sent, _ctx))

        '''Set the observer identities that receive
notifications the state of the registry
or nodes changes. This operation should be used by clients that
are using a bidirectional connection to communicate with the
session.

Arguments:
    registryObs The registry observer identity.

    nodeObs The node observer identity.

    appObs The application observer.

    adptObs The adapter observer.

    objObs The object observer.

Exceptions:
    ObserverAlreadyRegisteredException Raised if an
observer is already registered with this registry.'''
        def end_setObserversByIdentity(self, _r):
            return _M_IceGrid.AdminSession._op_setObserversByIdentity.end(self, _r)

        '''Acquires an exclusive lock to start updating the registry applications.

Returns:
    The current serial.

Exceptions:
    AccessDeniedException Raised if the exclusive lock can't be
acquired. This might happen if the lock is currently acquired by
another session.'''
        def startUpdate(self, _ctx=None):
            return _M_IceGrid.AdminSession._op_startUpdate.invoke(self, ((), _ctx))

        '''Acquires an exclusive lock to start updating the registry applications.

Returns:
    The current serial.

Exceptions:
    AccessDeniedException Raised if the exclusive lock can't be
acquired. This might happen if the lock is currently acquired by
another session.'''
        def begin_startUpdate(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_startUpdate.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Acquires an exclusive lock to start updating the registry applications.

Returns:
    The current serial.

Exceptions:
    AccessDeniedException Raised if the exclusive lock can't be
acquired. This might happen if the lock is currently acquired by
another session.'''
        def end_startUpdate(self, _r):
            return _M_IceGrid.AdminSession._op_startUpdate.end(self, _r)

        '''Finish updating the registry and release the exclusive lock.

Exceptions:
    AccessDeniedException Raised if the session doesn't hold the
exclusive lock.'''
        def finishUpdate(self, _ctx=None):
            return _M_IceGrid.AdminSession._op_finishUpdate.invoke(self, ((), _ctx))

        '''Finish updating the registry and release the exclusive lock.

Exceptions:
    AccessDeniedException Raised if the session doesn't hold the
exclusive lock.'''
        def begin_finishUpdate(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_finishUpdate.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Finish updating the registry and release the exclusive lock.

Exceptions:
    AccessDeniedException Raised if the session doesn't hold the
exclusive lock.'''
        def end_finishUpdate(self, _r):
            return _M_IceGrid.AdminSession._op_finishUpdate.end(self, _r)

        '''Get the name of the registry replica hosting this session.

Returns:
    The replica name of the registry.'''
        def getReplicaName(self, _ctx=None):
            return _M_IceGrid.AdminSession._op_getReplicaName.invoke(self, ((), _ctx))

        '''Get the name of the registry replica hosting this session.

Returns:
    The replica name of the registry.'''
        def begin_getReplicaName(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_getReplicaName.begin(self, ((), _response, _ex, _sent, _ctx))

        '''Get the name of the registry replica hosting this session.

Returns:
    The replica name of the registry.'''
        def end_getReplicaName(self, _r):
            return _M_IceGrid.AdminSession._op_getReplicaName.end(self, _r)

        '''Open the given server log file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    path The path of the log file. A log file can be opened
only if it's declared in the server or service deployment
descriptor.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def openServerLog(self, id, path, count, _ctx=None):
            return _M_IceGrid.AdminSession._op_openServerLog.invoke(self, ((id, path, count), _ctx))

        '''Open the given server log file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    path The path of the log file. A log file can be opened
only if it's declared in the server or service deployment
descriptor.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def begin_openServerLog(self, id, path, count, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_openServerLog.begin(self, ((id, path, count), _response, _ex, _sent, _ctx))

        '''Open the given server log file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    path The path of the log file. A log file can be opened
only if it's declared in the server or service deployment
descriptor.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def end_openServerLog(self, _r):
            return _M_IceGrid.AdminSession._op_openServerLog.end(self, _r)

        '''Open the given server stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def openServerStdErr(self, id, count, _ctx=None):
            return _M_IceGrid.AdminSession._op_openServerStdErr.invoke(self, ((id, count), _ctx))

        '''Open the given server stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def begin_openServerStdErr(self, id, count, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_openServerStdErr.begin(self, ((id, count), _response, _ex, _sent, _ctx))

        '''Open the given server stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def end_openServerStdErr(self, _r):
            return _M_IceGrid.AdminSession._op_openServerStdErr.end(self, _r)

        '''Open the given server stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def openServerStdOut(self, id, count, _ctx=None):
            return _M_IceGrid.AdminSession._op_openServerStdOut.invoke(self, ((id, count), _ctx))

        '''Open the given server stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def begin_openServerStdOut(self, id, count, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_openServerStdOut.begin(self, ((id, count), _response, _ex, _sent, _ctx))

        '''Open the given server stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    id The server id.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    ServerNotExistException Raised if the server doesn't
exist.

    NodeUnreachableException Raised if the node could not
be reached.

    DeploymentException Raised if the server couldn't be
deployed on the node.'''
        def end_openServerStdOut(self, _r):
            return _M_IceGrid.AdminSession._op_openServerStdOut.end(self, _r)

        '''Open the given node stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The node name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.'''
        def openNodeStdErr(self, name, count, _ctx=None):
            return _M_IceGrid.AdminSession._op_openNodeStdErr.invoke(self, ((name, count), _ctx))

        '''Open the given node stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The node name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.'''
        def begin_openNodeStdErr(self, name, count, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_openNodeStdErr.begin(self, ((name, count), _response, _ex, _sent, _ctx))

        '''Open the given node stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The node name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.'''
        def end_openNodeStdErr(self, _r):
            return _M_IceGrid.AdminSession._op_openNodeStdErr.end(self, _r)

        '''Open the given node stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The node name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.'''
        def openNodeStdOut(self, name, count, _ctx=None):
            return _M_IceGrid.AdminSession._op_openNodeStdOut.invoke(self, ((name, count), _ctx))

        '''Open the given node stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The node name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.'''
        def begin_openNodeStdOut(self, name, count, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_openNodeStdOut.begin(self, ((name, count), _response, _ex, _sent, _ctx))

        '''Open the given node stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The node name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    NodeNotExistException Raised if the node doesn't exist.

    NodeUnreachableException Raised if the node could not
be reached.'''
        def end_openNodeStdOut(self, _r):
            return _M_IceGrid.AdminSession._op_openNodeStdOut.end(self, _r)

        '''Open the given registry stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The registry name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    RegistryNotExistException Raised if the registry
doesn't exist.

    RegistryUnreachableException Raised if the registry
could not be reached.'''
        def openRegistryStdErr(self, name, count, _ctx=None):
            return _M_IceGrid.AdminSession._op_openRegistryStdErr.invoke(self, ((name, count), _ctx))

        '''Open the given registry stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The registry name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    RegistryNotExistException Raised if the registry
doesn't exist.

    RegistryUnreachableException Raised if the registry
could not be reached.'''
        def begin_openRegistryStdErr(self, name, count, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_openRegistryStdErr.begin(self, ((name, count), _response, _ex, _sent, _ctx))

        '''Open the given registry stderr file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The registry name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    RegistryNotExistException Raised if the registry
doesn't exist.

    RegistryUnreachableException Raised if the registry
could not be reached.'''
        def end_openRegistryStdErr(self, _r):
            return _M_IceGrid.AdminSession._op_openRegistryStdErr.end(self, _r)

        '''Open the given registry stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The registry name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    RegistryNotExistException Raised if the registry
doesn't exist.

    RegistryUnreachableException Raised if the registry
could not be reached.'''
        def openRegistryStdOut(self, name, count, _ctx=None):
            return _M_IceGrid.AdminSession._op_openRegistryStdOut.invoke(self, ((name, count), _ctx))

        '''Open the given registry stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The registry name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    RegistryNotExistException Raised if the registry
doesn't exist.

    RegistryUnreachableException Raised if the registry
could not be reached.'''
        def begin_openRegistryStdOut(self, name, count, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.AdminSession._op_openRegistryStdOut.begin(self, ((name, count), _response, _ex, _sent, _ctx))

        '''Open the given registry stdout file for reading. The file can be
read with the returned file iterator.

Arguments:
    name The registry name.

    count Specifies where to start reading the file. If
negative, the file is read from the begining. If 0 or positive,
the file is read from the last count lines.

Returns:
    An iterator to read the file.

Exceptions:
    FileNotAvailableException Raised if the file can't be
read.

    RegistryNotExistException Raised if the registry
doesn't exist.

    RegistryUnreachableException Raised if the registry
could not be reached.'''
        def end_openRegistryStdOut(self, _r):
            return _M_IceGrid.AdminSession._op_openRegistryStdOut.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.AdminSessionPrx.ice_checkedCast(proxy, '::IceGrid::AdminSession', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceGrid.AdminSessionPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceGrid::AdminSession'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceGrid._t_AdminSessionPrx = IcePy.defineProxy('::IceGrid::AdminSession', AdminSessionPrx)

    _M_IceGrid._t_AdminSession = IcePy.defineClass('::IceGrid::AdminSession', AdminSession, -1, (), True, False, None, (_M_Glacier2._t_Session,), ())
    AdminSession._ice_type = _M_IceGrid._t_AdminSession

    AdminSession._op_keepAlive = IcePy.Operation('keepAlive', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (), (), None, ())
    AdminSession._op_getAdmin = IcePy.Operation('getAdmin', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_IceGrid._t_AdminPrx, False, 0), ())
    AdminSession._op_getAdminCallbackTemplate = IcePy.Operation('getAdminCallbackTemplate', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (), (), ((), IcePy._t_ObjectPrx, False, 0), ())
    AdminSession._op_setObservers = IcePy.Operation('setObservers', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), _M_IceGrid._t_RegistryObserverPrx, False, 0), ((), _M_IceGrid._t_NodeObserverPrx, False, 0), ((), _M_IceGrid._t_ApplicationObserverPrx, False, 0), ((), _M_IceGrid._t_AdapterObserverPrx, False, 0), ((), _M_IceGrid._t_ObjectObserverPrx, False, 0)), (), None, (_M_IceGrid._t_ObserverAlreadyRegisteredException,))
    AdminSession._op_setObserversByIdentity = IcePy.Operation('setObserversByIdentity', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), _M_Ice._t_Identity, False, 0), ((), _M_Ice._t_Identity, False, 0), ((), _M_Ice._t_Identity, False, 0), ((), _M_Ice._t_Identity, False, 0), ((), _M_Ice._t_Identity, False, 0)), (), None, (_M_IceGrid._t_ObserverAlreadyRegisteredException,))
    AdminSession._op_startUpdate = IcePy.Operation('startUpdate', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), ((), IcePy._t_int, False, 0), (_M_IceGrid._t_AccessDeniedException,))
    AdminSession._op_finishUpdate = IcePy.Operation('finishUpdate', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), None, (_M_IceGrid._t_AccessDeniedException,))
    AdminSession._op_getReplicaName = IcePy.Operation('getReplicaName', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (), (), ((), IcePy._t_string, False, 0), ())
    AdminSession._op_openServerLog = IcePy.Operation('openServerLog', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_string, False, 0), ((), IcePy._t_int, False, 0)), (), ((), _M_IceGrid._t_FileIteratorPrx, False, 0), (_M_IceGrid._t_FileNotAvailableException, _M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    AdminSession._op_openServerStdErr = IcePy.Operation('openServerStdErr', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_int, False, 0)), (), ((), _M_IceGrid._t_FileIteratorPrx, False, 0), (_M_IceGrid._t_FileNotAvailableException, _M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    AdminSession._op_openServerStdOut = IcePy.Operation('openServerStdOut', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_int, False, 0)), (), ((), _M_IceGrid._t_FileIteratorPrx, False, 0), (_M_IceGrid._t_FileNotAvailableException, _M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    AdminSession._op_openNodeStdErr = IcePy.Operation('openNodeStdErr', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_int, False, 0)), (), ((), _M_IceGrid._t_FileIteratorPrx, False, 0), (_M_IceGrid._t_FileNotAvailableException, _M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    AdminSession._op_openNodeStdOut = IcePy.Operation('openNodeStdOut', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_int, False, 0)), (), ((), _M_IceGrid._t_FileIteratorPrx, False, 0), (_M_IceGrid._t_FileNotAvailableException, _M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    AdminSession._op_openRegistryStdErr = IcePy.Operation('openRegistryStdErr', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_int, False, 0)), (), ((), _M_IceGrid._t_FileIteratorPrx, False, 0), (_M_IceGrid._t_FileNotAvailableException, _M_IceGrid._t_RegistryNotExistException, _M_IceGrid._t_RegistryUnreachableException))
    AdminSession._op_openRegistryStdOut = IcePy.Operation('openRegistryStdOut', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_int, False, 0)), (), ((), _M_IceGrid._t_FileIteratorPrx, False, 0), (_M_IceGrid._t_FileNotAvailableException, _M_IceGrid._t_RegistryNotExistException, _M_IceGrid._t_RegistryUnreachableException))

    _M_IceGrid.AdminSession = AdminSession
    del AdminSession

    _M_IceGrid.AdminSessionPrx = AdminSessionPrx
    del AdminSessionPrx

# End of module IceGrid

Ice.sliceChecksums["::IceGrid::AdapterInfo"] = "a22de437e0d82d91cca7d476992b2a43"
Ice.sliceChecksums["::IceGrid::AdapterInfoSeq"] = "9fdbbb3c2d938b4e5f3bf5a21f234147"
Ice.sliceChecksums["::IceGrid::Admin"] = "35cb721cd375fb13818304b7c87217a"
Ice.sliceChecksums["::IceGrid::AdminSession"] = "ca6f21e8ff4210158f382cdbc66c2566"
Ice.sliceChecksums["::IceGrid::ApplicationInfo"] = "44ab5928481a1441216f93965f9e6c5"
Ice.sliceChecksums["::IceGrid::ApplicationInfoSeq"] = "dc7429d6b923c3e66eea573eccc1598"
Ice.sliceChecksums["::IceGrid::ApplicationUpdateInfo"] = "c21c8cfe85e332fd9ad194e611bc6b7f"
Ice.sliceChecksums["::IceGrid::FileIterator"] = "54341a38932f89d199f28ffc4712c7"
Ice.sliceChecksums["::IceGrid::LoadInfo"] = "c28c339f5af52a46ac64c33864ae6"
Ice.sliceChecksums["::IceGrid::NodeInfo"] = "f348b389deb653ac28b2b991e23d63b9"
Ice.sliceChecksums["::IceGrid::ObjectInfo"] = "6c8a382c348df5cbda50e58d87189e33"
Ice.sliceChecksums["::IceGrid::ObjectInfoSeq"] = "1491c01cb93b575c602baed26ed0f989"
Ice.sliceChecksums["::IceGrid::RegistryInfo"] = "60e64fc1e37ce59ecbeed4a0e276ba"
Ice.sliceChecksums["::IceGrid::RegistryInfoSeq"] = "fabb868b9f2164f68bc9eb68240c8a6"
Ice.sliceChecksums["::IceGrid::ServerInfo"] = "7f99dc872345b2c3c741c8b4c23440da"
Ice.sliceChecksums["::IceGrid::ServerState"] = "21e8ecba86a4678f3b783de286583093"
Ice.sliceChecksums["::IceGrid::StringObjectProxyDict"] = "978c325e58cebefb212e5ebde28acdc"
