# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError
import uuid

from .. import models


class MetricsOperations(object):
    """MetricsOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An objec model deserializer.
    :ivar api_version: Client Api Version. Constant value: "2016-09-01".
    """

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self.api_version = "2016-09-01"

        self.config = config

    def list(
            self, resource_uri, filter=None, custom_headers=None, raw=False, **operation_config):
        """Lists the metric values for a resource. The $filter is used to reduce
        the set of metric data returned. Some common properties for this
        expression will be: name.value, aggregationType, startTime, endTime,
        timeGrain. The filter expression uses these properties with comparison
        operators (eg. eq, gt, lt) and multiple expressions can be combined
        with parentheses and 'and/or' operators. Some example filter
        expressions are: - $filter=(name.value eq 'RunsSucceeded') and
        aggregationType eq 'Total' and startTime eq 2016-02-20 and endTime eq
        2016-02-21 and timeGrain eq duration'PT1M', - $filter=(name.value eq
        'RunsSucceeded') and (aggregationType eq 'Total' or aggregationType eq
        'Average') and startTime eq 2016-02-20 and endTime eq 2016-02-21 and
        timeGrain eq duration'PT1H', - $filter=(name.value eq
        'ActionsCompleted' or name.value eq 'RunsSucceeded') and
        (aggregationType eq 'Total' or aggregationType eq 'Average') and
        startTime eq 2016-02-20 and endTime eq 2016-02-21 and timeGrain eq
        duration'PT1M'.

        :param resource_uri: The identifier of the resource.
        :type resource_uri: str
        :param filter: Reduces the set of data collected. The syntax allowed
         depends on the operation. See the operation's description for details.
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`MetricPaged <azure.monitor.models.MetricPaged>`
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = '/{resourceUri}/providers/microsoft.insights/metrics'
                path_format_arguments = {
                    'resourceUri': self._serialize.url("resource_uri", resource_uri, 'str', skip_quote=True)
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Content-Type'] = 'application/json; charset=utf-8'
            if self.config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

            # Construct and send request
            request = self._client.get(url, query_parameters)
            response = self._client.send(
                request, header_parameters, **operation_config)

            if response.status_code not in [200]:
                exp = CloudError(response)
                exp.request_id = response.headers.get('x-ms-request-id')
                raise exp

            return response

        # Deserialize response
        deserialized = models.MetricPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.MetricPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
