# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2018-02-05 14:19
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('oidc_provider', '0023_client_owner'),
    ]

    operations = [
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=100, verbose_name='Name')),
                ('resource_id', models.CharField(max_length=255, unique=True, verbose_name='Resource ID')),
                ('resource_secret', models.CharField(max_length=255, verbose_name='Resource Secret')),
                ('date_created', models.DateField(auto_now_add=True, verbose_name='Date Created')),
                ('date_updated', models.DateField(auto_now=True, verbose_name='Date Updated')),
                ('active', models.BooleanField(default=False, verbose_name='Is Active')),
                ('allowed_clients', models.ManyToManyField(blank=True, help_text='Select which clients can be used to access this resource.', related_name='accessible_resources', to='oidc_provider.Client', verbose_name='Allowed Clients')),
                ('owner', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='oidc_resource_set', to=settings.AUTH_USER_MODEL, verbose_name='Owner')),
            ],
            options={
                'swappable': 'OIDC_RESOURCE_MODEL',
            },
        ),
    ]
