#
# This file is part of Reclaimer.
#
# For authors and copyright check AUTHORS.TXT
#
# Reclaimer is free software under the GNU General Public License v3.0.
# See LICENSE for more information.
#

from ...common_descs import *
from .objs.tag import HekTag
from supyr_struct.defs.tag_def import TagDef

def get(): return udlg_def

def snd_dependency(name):
    return dependency(name, "snd!")

udlg_body = Struct("tagdata",
    Pad(16),
    Struct("idle",
        snd_dependency("noncombat"),
        snd_dependency("combat"),
        snd_dependency("flee"),
        Pad(48),
        ),

    Struct("involuntary",
        snd_dependency("pain_body_minor"),
        snd_dependency("pain_body_maior"),
        snd_dependency("pain_shield"),
        snd_dependency("pain_falling"),
        snd_dependency("scream_fear"),
        snd_dependency("scream_pain"),
        snd_dependency("maimed_limb"),
        snd_dependency("maimed_head"),
        snd_dependency("death_quiet"),
        snd_dependency("death_violent"),
        snd_dependency("death_falling"),
        snd_dependency("death_agonizing"),
        snd_dependency("death_instant"),
        snd_dependency("death_flying"),
        Pad(16),
        ),

    Struct("hurting_people",
        snd_dependency("damaged_friend"),
        snd_dependency("damaged_friend_player"),
        snd_dependency("damaged_enemy"),
        snd_dependency("damaged_enemy_cm"),
        Pad(64),
        ),

    Struct("being_hurt",
        snd_dependency("hurt_friend"),
        snd_dependency("hurt_friend_re"),
        snd_dependency("hurt_friend_player"),
        snd_dependency("hurt_enemy"),
        snd_dependency("hurt_enemy_re"),
        snd_dependency("hurt_enemy_cm"),
        snd_dependency("hurt_enemy_bullet"),
        snd_dependency("hurt_enemy_needler"),
        snd_dependency("hurt_enemy_plasma"),
        snd_dependency("hurt_enemy_sniper"),
        snd_dependency("hurt_enemy_grenade"),
        snd_dependency("hurt_enemy_explosion"),
        snd_dependency("hurt_enemy_melee"),
        snd_dependency("hurt_enemy_flame"),
        snd_dependency("hurt_enemy_shotgun"),
        snd_dependency("hurt_enemy_vehicle"),
        snd_dependency("hurt_enemy_mounted_weapon"),
        Pad(48),
        ),

    Struct("killing_people",
        snd_dependency("killed_friend"),
        snd_dependency("killed_friend_cm"),
        snd_dependency("killed_friend_player"),
        snd_dependency("killed_friend_player_cm"),
        snd_dependency("killed_enemy"),
        snd_dependency("killed_enemy_cm"),
        snd_dependency("killed_enemy_player"),
        snd_dependency("killed_enemy_player_cm"),
        snd_dependency("killed_enemy_covenant"),
        snd_dependency("killed_enemy_covenant_cm"),
        snd_dependency("killed_enemy_floodcombat"),
        snd_dependency("killed_enemy_floodcombat_cm"),
        snd_dependency("killed_enemy_floodcarrier"),
        snd_dependency("killed_enemy_floodcarrier_cm"),
        snd_dependency("killed_enemy_sentinel"),
        snd_dependency("killed_enemy_sentinel_cm"),

        snd_dependency("killed_enemy_bullet"),
        snd_dependency("killed_enemy_needler"),
        snd_dependency("killed_enemy_plasma"),
        snd_dependency("killed_enemy_sniper"),
        snd_dependency("killed_enemy_grenade"),
        snd_dependency("killed_enemy_explosion"),
        snd_dependency("killed_enemy_melee"),
        snd_dependency("killed_enemy_flame"),
        snd_dependency("killed_enemy_shotgun"),
        snd_dependency("killed_enemy_vehicle"),
        snd_dependency("killed_enemy_mounted_weapon"),
        snd_dependency("killing_spree"),
        Pad(48),
        ),

    Struct("player_kill_responses",
        snd_dependency("player_kill_cm"),
        snd_dependency("player_kill_bullet_cm"),
        snd_dependency("player_kill_needler_cm"),
        snd_dependency("player_kill_plasma_cm"),
        snd_dependency("player_kill_sniper_cm"),
        snd_dependency("anyone_kill_grenade_cm"),
        snd_dependency("player_kill_explosion_cm"),
        snd_dependency("player_kill_melee_cm"),
        snd_dependency("player_kill_flame_cm"),
        snd_dependency("player_kill_shotgun_cm"),
        snd_dependency("player_kill_vehicle_cm"),
        snd_dependency("player_kill_mounted_weapon_cm"),
        snd_dependency("player_killing_spree_cm"),
        Pad(48),
        ),

    Struct("friends_dying",
        snd_dependency("friend_died"),
        snd_dependency("friend_player_died"),
        snd_dependency("friend_killed_by_friend"),
        snd_dependency("friend_killed_by_friendly_player"),
        snd_dependency("friend_enemy"),
        snd_dependency("friend_enemy_player"),
        snd_dependency("friend_covenant"),
        snd_dependency("friend_flood"),
        snd_dependency("friend_sentinel"),
        snd_dependency("friend_betrayed"),
        Pad(32),
        ),

    Struct("shouting",
        snd_dependency("new_combat_alone"),
        snd_dependency("new_enemy_recent_combat"),
        snd_dependency("old_enemy_sighted"),
        snd_dependency("unexpected_enemy"),
        snd_dependency("dead_friend_found"),
        snd_dependency("alliance_broken"),
        snd_dependency("alliance_reformed"),
        snd_dependency("grenade_throwing"),
        snd_dependency("grenade_sighted"),
        snd_dependency("grenade_startle"),
        snd_dependency("grenade_danger_enemy"),
        snd_dependency("grenade_danger_self"),
        snd_dependency("grenade_danger_friend"),
        Pad(32),
        ),

    Struct("group_communication",
        snd_dependency("new_combat_group_re"),
        snd_dependency("new_combat_nearby_re"),
        snd_dependency("alert_friend"),
        snd_dependency("alert_friend_re"),
        snd_dependency("alert_lost_contact"),
        snd_dependency("alert_lost_contact_re"),
        snd_dependency("blocked"),
        snd_dependency("blocked_re"),
        snd_dependency("search_start"),
        snd_dependency("search_query"),
        snd_dependency("search_query_re"),
        snd_dependency("search_report"),
        snd_dependency("search_abandon"),
        snd_dependency("search_group_abandon"),
        snd_dependency("group_uncover"),
        snd_dependency("group_uncover_re"),
        snd_dependency("advance"),
        snd_dependency("advance_re"),
        snd_dependency("retreat"),
        snd_dependency("retreat_re"),
        snd_dependency("cover"),
        Pad(64),
        ),

    Struct("actions",
        snd_dependency("sighted_friend_player"),
        snd_dependency("shooting"),
        snd_dependency("shooting_vehicle"),
        snd_dependency("shooting_berserk"),
        snd_dependency("shooting_group"),
        snd_dependency("shooting_traitor"),
        snd_dependency("taunt"),
        snd_dependency("taunt_re"),
        snd_dependency("flee"),
        snd_dependency("flee_re"),
        snd_dependency("free_leader_died"),
        snd_dependency("attempted_flee"),
        snd_dependency("attempted_flee_re"),
        snd_dependency("lost_contact"),
        snd_dependency("hiding_finished"),
        snd_dependency("vehicle_entry"),
        snd_dependency("vehicle_exit"),
        snd_dependency("vehicle_woohoo"),
        snd_dependency("vehicle_scared"),
        snd_dependency("vehicle_collision"),
        snd_dependency("partially_sighted"),
        snd_dependency("nothing_there"),
        snd_dependency("pleading"),
        Pad(96),
        ),

    Struct("exclamations",
        snd_dependency("surprise"),
        snd_dependency("berserk"),
        snd_dependency("melee_attack"),
        snd_dependency("dive"),
        snd_dependency("uncover_exclamation"),
        snd_dependency("leap_attack"),
        snd_dependency("resurrection"),
        Pad(64),
        ),

    Struct("post_combat_actions",
        snd_dependency("celebration"),
        snd_dependency("check_body_enemy"),
        snd_dependency("check_body_friend"),
        snd_dependency("shooting_dead_enemy"),
        snd_dependency("shooting_dead_enemy_player"),
        Pad(64),
        ),

    Struct("post_combat_chatter",
        snd_dependency("alone"),
        snd_dependency("unscathed"),
        snd_dependency("seriously_wounded"),
        snd_dependency("seriously_wounded_re"),
        snd_dependency("massacre"),
        snd_dependency("massacre_re"),
        snd_dependency("rout"),
        snd_dependency("rout_re"),
        ),

    SIZE=4112,
    )

udlg_def = TagDef("udlg",
    blam_header('udlg'),
    udlg_body,

    ext=".dialogue", endian=">", tag_cls=HekTag
    )
