#
# This file is part of Reclaimer.
#
# For authors and copyright check AUTHORS.TXT
#
# Reclaimer is free software under the GNU General Public License v3.0.
# See LICENSE for more information.
#

############# Credits and version info #############
# Definition generated from Assembly XML tag def
#	 Date generated: 2018/12/03  04:56
#
# revision: 1		author: Assembly
# 	Generated plugin from scratch.
# revision: 2		author: DeadCanadian
# 	started naming
# revision: 3		author: Lord Zedd
# 	I don't always add revisions, but when I do it's because I spend hours making these giant enums.
# revision: 4		author: Moses_of_Egypt
# 	Cleaned up and converted to SuPyr definition
#
####################################################

from ..common_descs import *
from .objs.tag import *
from supyr_struct.defs.tag_def import TagDef

sily_parameter = (
    "int_global_teams",
    "int_global_round_reset",
    "int_global_round_time_limit",
    "int_global_round_count",
    "int_global_early_victory_win_count",
    "int_global_respawn_inheritance",
    "int_global_respawn_with_team",
    "int_global_respawn_at_location",
    "int_global_respawn_on_kill",
    "int_global_lives_per_round",
    "int_global_team_lives_per_round",
    "int_global_respawn_time",
    "int_global_suicide_penalty",
    "int_global_betrayal_penalty",
    "int_global_respawn_growth",
    "int_global_respawn_traits_duration",
    "int_global_respawn_traits_damage_resistance",
    "int_global_respawn_traits_shield_multiplier",
    "int_global_respawn_traits_shield_recharge",
    "int_global_respawn_traits_headshot_immunity",
    "int_global_respawn_traits_vampirism",
    "int_global_respawn_traits_damage_modifier",
    "sid_global_respawn_traits_primary_weapon",
    "sid_global_respawn_traits_secondary_weapon",
    "int_global_respawn_traits_grenade_count",
    "int_global_respawn_traits_grenade_recharge",
    "int_global_respawn_traits_infinite_ammo",
    "int_global_respawn_traits_weapon_pickup",
    "int_global_respawn_traits_speed",
    "int_global_respawn_traits_gravity",
    "int_global_respawn_traits_vehicle_use",
    "int_global_respawn_traits_sensor",
    "int_global_respawn_traits_sensor_range",
    "int_global_respawn_traits_waypoint",
    "int_global_respawn_traits_active_camo",
    "int_global_respawn_traits_visual_aura",
    "int_global_respawn_traits_forced_color",
    "int_global_observers",
    "int_global_team_changing",
    "int_global_friendly_fire",
    "int_global_betrayal_booting",
    "int_global_enemy_voice",
    "int_global_open_channel_voice",
    "int_global_dead_player_voice",
    "int_global_grenades_on_map",
    "int_global_indestructible_vehicles",
    "int_global_base_traits_damage_resistance",
    "int_global_base_traits_shield_multiplier",
    "int_global_base_traits_shield_recharge",
    "int_global_base_traits_headshot_immunity",
    "int_global_base_traits_vampirism",
    "int_global_base_traits_damage_modifier",
    "sid_global_base_traits_primary_weapon",
    "sid_global_base_traits_secondary_weapon",
    "int_global_base_traits_grenade_count",
    "int_global_base_traits_grenade_recharge",
    "int_global_base_traits_infinite_ammo",
    "int_global_base_traits_weapon_pickup",
    "int_global_base_traits_speed",
    "int_global_base_traits_gravity",
    "int_global_base_traits_vehicle_use",
    "int_global_base_traits_sensor",
    "int_global_base_traits_sensor_range",
    "int_global_base_traits_waypoint",
    "int_global_base_traits_active_camo",
    "int_global_base_traits_visual_aura",
    "int_global_base_traits_forced_color",
    "sid_global_map_weapon_set",
    "sid_global_map_vehicle_set",
    "int_global_red_traits_damage_resistance",
    "int_global_red_traits_shield_multiplier",
    "int_global_red_traits_shield_recharge",
    "int_global_red_traits_headshot_immunity",
    "int_global_red_traits_vampirism",
    "int_global_red_traits_damage_modifier",
    "sid_global_red_traits_primary_weapon",
    "sid_global_red_traits_secondary_weapon",
    "int_global_red_traits_grenade_count",
    "int_global_red_traits_grenade_recharge",
    "int_global_red_traits_infinite_ammo",
    "int_global_red_traits_weapon_pickup",
    "int_global_red_traits_speed",
    "int_global_red_traits_gravity",
    "int_global_red_traits_vehicle_use",
    "int_global_red_traits_sensor",
    "int_global_red_traits_sensor_range",
    "int_global_red_traits_waypoint",
    "int_global_red_traits_active_camo",
    "int_global_red_traits_visual_aura",
    "int_global_red_traits_forced_color",
    "int_global_blue_traits_damage_resistance",
    "int_global_blue_traits_shield_multiplier",
    "int_global_blue_traits_shield_recharge",
    "int_global_blue_traits_headshot_immunity",
    "int_global_blue_traits_vampirism",
    "int_global_blue_traits_damage_modifier",
    "sid_global_blue_traits_primary_weapon",
    "sid_global_blue_traits_secondary_weapon",
    "int_global_blue_traits_grenade_count",
    "int_global_blue_traits_grenade_recharge",
    "int_global_blue_traits_infinite_ammo",
    "int_global_blue_traits_weapon_pickup",
    "int_global_blue_traits_speed",
    "int_global_blue_traits_gravity",
    "int_global_blue_traits_vehicle_use",
    "int_global_blue_traits_sensor",
    "int_global_blue_traits_sensor_range",
    "int_global_blue_traits_waypoint",
    "int_global_blue_traits_active_camo",
    "int_global_blue_traits_visual_aura",
    "int_global_blue_traits_forced_color",
    "int_global_yellow_traits_damage_resistance",
    "int_global_yellow_traits_shield_multiplier",
    "int_global_yellow_traits_shield_recharge",
    "int_global_yellow_traits_headshot_immunity",
    "int_global_yellow_traits_vampirism",
    "int_global_yellow_traits_damage_modifier",
    "sid_global_yellow_traits_primary_weapon",
    "sid_global_yellow_traits_secondary_weapon",
    "int_global_yellow_traits_grenade_count",
    "int_global_yellow_traits_grenade_recharge",
    "int_global_yellow_traits_infinite_ammo",
    "int_global_yellow_traits_weapon_pickup",
    "int_global_yellow_traits_speed",
    "int_global_yellow_traits_gravity",
    "int_global_yellow_traits_vehicle_use",
    "int_global_yellow_traits_sensor",
    "int_global_yellow_traits_sensor_range",
    "int_global_yellow_traits_waypoint",
    "int_global_yellow_traits_active_camo",
    "int_global_yellow_traits_visual_aura",
    "int_global_yellow_traits_forced_color",
    "int_global_red_traits_duration",
    "int_global_blue_traits_duration",
    "int_global_yellow_traits_duration",
    "int_slayer_team_scoring",
    "int_slayer_score_to_win",
    "int_slayer_kill_points",
    "int_slayer_assist_points",
    "int_slayer_death_points",
    "int_slayer_suicide_points",
    "int_slayer_betrayal_points",
    "int_slayer_leader_points",
    "int_slayer_elimination_points",
    "int_slayer_assassination_points",
    "int_slayer_headshot_points",
    "int_slayer_melee_points",
    "int_slayer_sticky_points",
    "int_slayer_splatter_points",
    "int_slayer_spree_points",
    "int_slayer_leader_traits_damage_resistance",
    "int_slayer_leader_traits_shield_multiplier",
    "int_slayer_leader_traits_shield_recharge",
    "int_slayer_leader_traits_headshot_immunity",
    "int_slayer_leader_traits_vampirism",
    "int_slayer_leader_traits_damage_modifier",
    "sid_slayer_leader_traits_primary_weapon",
    "sid_slayer_leader_traits_secondary_weapon",
    "int_slayer_leader_traits_grenade_count",
    "int_slayer_leader_traits_grenade_recharge",
    "int_slayer_leader_traits_infinite_ammo",
    "int_slayer_leader_traits_weapon_pickup",
    "int_slayer_leader_traits_speed",
    "int_slayer_leader_traits_gravity",
    "int_slayer_leader_traits_vehicle_use",
    "int_slayer_leader_traits_sensor",
    "int_slayer_leader_traits_sensor_range",
    "int_slayer_leader_traits_waypoint",
    "int_slayer_leader_traits_active_camo",
    "int_slayer_leader_traits_visual_aura",
    "int_slayer_leader_traits_forced_color",
    "int_oddball_auto_pickup",
    "int_oddball_ball_effect",
    "int_oddball_team_scoring",
    "int_oddball_unknown",
    "int_oddball_score_to_win",
    "int_oddball_carrier_points",
    "int_oddball_kill_points",
    "int_oddball_ball_kill_points",
    "int_oddball_carrier_kill_points",
    "int_oddball_ball_count",
    "int_oddball_spawn_delay",
    "int_oddball_respawn_delay",
    "int_oddball_carrier_traits_damage_resistance",
    "int_oddball_carrier_traits_shield_multiplier",
    "int_oddball_carrier_traits_shield_recharge",
    "int_oddball_carrier_traits_headshot_immunity",
    "int_oddball_carrier_traits_vampirism",
    "int_oddball_carrier_traits_damage_modifier",
    "sid_oddball_carrier_traits_primary_weapon",
    "sid_oddball_carrier_traits_secondary_weapon",
    "int_oddball_carrier_traits_grenade_count",
    "int_oddball_carrier_traits_grenade_recharge",
    "int_oddball_carrier_traits_infinite_ammo",
    "int_oddball_carrier_traits_weapon_pickup",
    "int_oddball_carrier_traits_speed",
    "int_oddball_carrier_traits_gravity",
    "int_oddball_carrier_traits_vehicle_use",
    "int_oddball_carrier_traits_sensor",
    "int_oddball_carrier_traits_sensor_range",
    "int_oddball_carrier_traits_waypoint",
    "int_oddball_carrier_traits_active_camo",
    "int_oddball_carrier_traits_visual_aura",
    "int_oddball_carrier_traits_forced_color",
    "int_ctf_touch_return_time",
    "int_ctf_flag_at_home",
    "int_ctf_home_waypoint",
    "int_ctf_unknown_0",
    "int_ctf_unknown_1",
    "int_ctf_game_mode",
    "int_ctf_respawn_on_capture",
    "int_ctf_score_to_win",
    "int_ctf_sudden_death",
    "int_ctf_idle_return",
    "int_ctf_unknown_2",
    "int_ctf_unknown_3",
    "int_ctf_carrier_traits_damage_resistance",
    "int_ctf_carrier_traits_shield_multiplier",
    "int_ctf_carrier_traits_shield_recharge",
    "int_ctf_carrier_traits_headshot_immunity",
    "int_ctf_carrier_traits_vampirism",
    "int_ctf_carrier_traits_damage_modifier",
    "sid_ctf_carrier_traits_primary_weapon",
    "sid_ctf_carrier_traits_secondary_weapon",
    "int_ctf_carrier_traits_grenade_count",
    "int_ctf_carrier_traits_grenade_recharge",
    "int_ctf_carrier_traits_infinite_ammo",
    "int_ctf_carrier_traits_weapon_pickup",
    "int_ctf_carrier_traits_speed",
    "int_ctf_carrier_traits_gravity",
    "int_ctf_carrier_traits_vehicle_use",
    "int_ctf_carrier_traits_sensor",
    "int_ctf_carrier_traits_sensor_range",
    "int_ctf_carrier_traits_waypoint",
    "int_ctf_carrier_traits_active_camo",
    "int_ctf_carrier_traits_visual_aura",
    "int_ctf_carrier_traits_forced_color",
    "int_infection_respawn_on_haven_move",
    "int_infection_haven_movement",
    "int_infection_next_zombie",
    "int_infection_initial_count",
    "int_infection_haven_movement_time",
    "int_infection_kill_points",
    "int_infection_infect_points",
    "int_infection_haven_arrival_points",
    "int_infection_suicide_points",
    "int_infection_betrayal_points",
    "int_infection_last_man_standing_points",
    "int_infection_zombie_traits_damage_resistance",
    "int_infection_zombie_traits_shield_multiplier",
    "int_infection_zombie_traits_shield_recharge",
    "int_infection_zombie_traits_headshot_immunity",
    "int_infection_zombie_traits_vampirism",
    "int_infection_zombie_traits_damage_modifier",
    "sid_infection_zombie_traits_primary_weapon",
    "sid_infection_zombie_traits_secondary_weapon",
    "int_infection_zombie_traits_grenade_count",
    "int_infection_zombie_traits_grenade_recharge",
    "int_infection_zombie_traits_infinite_ammo",
    "int_infection_zombie_traits_weapon_pickup",
    "int_infection_zombie_traits_speed",
    "int_infection_zombie_traits_gravity",
    "int_infection_zombie_traits_vehicle_use",
    "int_infection_zombie_traits_sensor",
    "int_infection_zombie_traits_sensor_range",
    "int_infection_zombie_traits_waypoint",
    "int_infection_zombie_traits_active_camo",
    "int_infection_zombie_traits_visual_aura",
    "int_infection_zombie_traits_forced_color",
    "int_infection_alpha_zombie_traits_damage_resistance",
    "int_infection_alpha_zombie_traits_shield_multiplier",
    "int_infection_alpha_zombie_traits_shield_recharge",
    "int_infection_alpha_zombie_traits_headshot_immunity",
    "int_infection_alpha_zombie_traits_vampirism",
    "int_infection_alpha_zombie_traits_damage_modifier",
    "sid_infection_alpha_zombie_traits_primary_weapon",
    "sid_infection_alpha_zombie_traits_secondary_weapon",
    "int_infection_alpha_zombie_traits_grenade_count",
    "int_infection_alpha_zombie_traits_grenade_recharge",
    "int_infection_alpha_zombie_traits_infinite_ammo",
    "int_infection_alpha_zombie_traits_weapon_pickup",
    "int_infection_alpha_zombie_traits_speed",
    "int_infection_alpha_zombie_traits_gravity",
    "int_infection_alpha_zombie_traits_vehicle_use",
    "int_infection_alpha_zombie_traits_sensor",
    "int_infection_alpha_zombie_traits_sensor_range",
    "int_infection_alpha_zombie_traits_waypoint",
    "int_infection_alpha_zombie_traits_active_camo",
    "int_infection_alpha_zombie_traits_visual_aura",
    "int_infection_alpha_zombie_traits_forced_color",
    "int_infection_haven_traits_damage_resistance",
    "int_infection_haven_traits_shield_multiplier",
    "int_infection_haven_traits_shield_recharge",
    "int_infection_haven_traits_headshot_immunity",
    "int_infection_haven_traits_vampirism",
    "int_infection_haven_traits_damage_modifier",
    "sid_infection_haven_traits_primary_weapon",
    "sid_infection_haven_traits_secondary_weapon",
    "int_infection_haven_traits_grenade_count",
    "int_infection_haven_traits_grenade_recharge",
    "int_infection_haven_traits_infinite_ammo",
    "int_infection_haven_traits_weapon_pickup",
    "int_infection_haven_traits_speed",
    "int_infection_haven_traits_gravity",
    "int_infection_haven_traits_vehicle_use",
    "int_infection_haven_traits_sensor",
    "int_infection_haven_traits_sensor_range",
    "int_infection_haven_traits_waypoint",
    "int_infection_haven_traits_active_camo",
    "int_infection_haven_traits_visual_aura",
    "int_infection_haven_traits_forced_color",
    "int_infection_last_man_standing_traits_damage_resistance",
    "int_infection_last_man_standing_traits_shield_multiplier",
    "int_infection_last_man_standing_traits_shield_recharge",
    "int_infection_last_man_standing_traits_headshot_immunity",
    "int_infection_last_man_standing_traits_vampirism",
    "int_infection_last_man_standing_traits_damage_modifier",
    "sid_infection_last_man_standing_traits_primary_weapon",
    "sid_infection_last_man_standing_traits_secondary_weapon",
    "int_infection_last_man_standing_traits_grenade_count",
    "int_infection_last_man_standing_traits_grenade_recharge",
    "int_infection_last_man_standing_traits_infinite_ammo",
    "int_infection_last_man_standing_traits_weapon_pickup",
    "int_infection_last_man_standing_traits_speed",
    "int_infection_last_man_standing_traits_gravity",
    "int_infection_last_man_standing_traits_vehicle_use",
    "int_infection_last_man_standing_traits_sensor",
    "int_infection_last_man_standing_traits_sensor_range",
    "int_infection_last_man_standing_traits_waypoint",
    "int_infection_last_man_standing_traits_active_camo",
    "int_infection_last_man_standing_traits_visual_aura",
    "int_infection_last_man_standing_traits_forced_color",
    "int_koth_opaque_hill",
    "int_koth_score_to_win",
    "int_koth_team_scoring",
    "int_koth_moving_hill",
    "int_koth_moving_hill_order",
    "int_koth_inside_hill_points",
    "int_koth_outside_hill_points",
    "int_koth_uncontested_points",
    "int_koth_kill_points",
    "int_koth_hill_traits_damage_resistance",
    "int_koth_hill_traits_shield_multiplier",
    "int_koth_hill_traits_shield_recharge",
    "int_koth_hill_traits_headshot_immunity",
    "int_koth_hill_traits_vampirism",
    "int_koth_hill_traits_damage_modifier",
    "sid_koth_hill_traits_primary_weapon",
    "sid_koth_hill_traits_secondary_weapon",
    "int_koth_hill_traits_grenade_count",
    "int_koth_hill_traits_grenade_recharge",
    "int_koth_hill_traits_infinite_ammo",
    "int_koth_hill_traits_weapon_pickup",
    "int_koth_hill_traits_speed",
    "int_koth_hill_traits_gravity",
    "int_koth_hill_traits_vehicle_use",
    "int_koth_hill_traits_sensor",
    "int_koth_hill_traits_sensor_range",
    "int_koth_hill_traits_waypoint",
    "int_koth_hill_traits_active_camo",
    "int_koth_hill_traits_visual_aura",
    "int_koth_hill_traits_forced_color",
    "int_territories_capture_time",
    "int_territories_game_mode",
    "int_territories_lock_on_capture",
    "int_territories_sudden_death",
    "int_territories_spawn_on_capture",
    "int_territories_defender_traits_damage_resistance",
    "int_territories_defender_traits_shield_multiplier",
    "int_territories_defender_traits_shield_recharge",
    "int_territories_defender_traits_headshot_immunity",
    "int_territories_defender_traits_vampirism",
    "int_territories_defender_traits_damage_modifier",
    "sid_territories_defender_traits_primary_weapon",
    "sid_territories_defender_traits_secondary_weapon",
    "int_territories_defender_traits_grenade_count",
    "int_territories_defender_traits_grenade_recharge",
    "int_territories_defender_traits_infinite_ammo",
    "int_territories_defender_traits_weapon_pickup",
    "int_territories_defender_traits_speed",
    "int_territories_defender_traits_gravity",
    "int_territories_defender_traits_vehicle_use",
    "int_territories_defender_traits_sensor",
    "int_territories_defender_traits_sensor_range",
    "int_territories_defender_traits_waypoint",
    "int_territories_defender_traits_active_camo",
    "int_territories_defender_traits_visual_aura",
    "int_territories_defender_traits_forced_color",
    "int_territories_attacker_traits_damage_resistance",
    "int_territories_attacker_traits_shield_multiplier",
    "int_territories_attacker_traits_shield_recharge",
    "int_territories_attacker_traits_headshot_immunity",
    "int_territories_attacker_traits_vampirism",
    "int_territories_attacker_traits_damage_modifier",
    "sid_territories_attacker_traits_primary_weapon",
    "sid_territories_attacker_traits_secondary_weapon",
    "int_territories_attacker_traits_grenade_count",
    "int_territories_attacker_traits_grenade_recharge",
    "int_territories_attacker_traits_infinite_ammo",
    "int_territories_attacker_traits_weapon_pickup",
    "int_territories_attacker_traits_speed",
    "int_territories_attacker_traits_gravity",
    "int_territories_attacker_traits_vehicle_use",
    "int_territories_attacker_traits_sensor",
    "int_territories_attacker_traits_sensor_range",
    "int_territories_attacker_traits_waypoint",
    "int_territories_attacker_traits_active_camo",
    "int_territories_attacker_traits_visual_aura",
    "int_territories_attacker_traits_forced_color",
    "int_vip_score_to_win",
    "int_vip_game_mode",
    "int_vip_zone_count",
    "int_vip_end_on_death",
    "int_vip_kill_points",
    "int_vip_takedown_points",
    "int_vip_vip_kill_points",
    "int_vip_death_points",
    "int_vip_zone_arrival_points",
    "int_vip_suicide_points",
    "int_vip_vip_betrayal_points",
    "int_vip_betrayal_points",
    "int_vip_selection",
    "int_vip_zone_movement",
    "int_vip_zone_order",
    "int_vip_influence_radius",
    "int_vip_team_traits_damage_resistance",
    "int_vip_team_traits_shield_multiplier",
    "int_vip_team_traits_shield_recharge",
    "int_vip_team_traits_headshot_immunity",
    "int_vip_team_traits_vampirism",
    "int_vip_team_traits_damage_modifier",
    "sid_vip_team_traits_primary_weapon",
    "sid_vip_team_traits_secondary_weapon",
    "int_vip_team_traits_grenade_count",
    "int_vip_team_traits_grenade_recharge",
    "int_vip_team_traits_infinite_ammo",
    "int_vip_team_traits_weapon_pickup",
    "int_vip_team_traits_speed",
    "int_vip_team_traits_gravity",
    "int_vip_team_traits_vehicle_use",
    "int_vip_team_traits_sensor",
    "int_vip_team_traits_sensor_range",
    "int_vip_team_traits_waypoint",
    "int_vip_team_traits_active_camo",
    "int_vip_team_traits_visual_aura",
    "int_vip_team_traits_forced_color",
    "int_vip_influence_traits_damage_resistance",
    "int_vip_influence_traits_shield_multiplier",
    "int_vip_influence_traits_shield_recharge",
    "int_vip_influence_traits_headshot_immunity",
    "int_vip_influence_traits_vampirism",
    "int_vip_influence_traits_damage_modifier",
    "sid_vip_influence_traits_primary_weapon",
    "sid_vip_influence_traits_secondary_weapon",
    "int_vip_influence_traits_grenade_count",
    "int_vip_influence_traits_grenade_recharge",
    "int_vip_influence_traits_infinite_ammo",
    "int_vip_influence_traits_weapon_pickup",
    "int_vip_influence_traits_speed",
    "int_vip_influence_traits_gravity",
    "int_vip_influence_traits_vehicle_use",
    "int_vip_influence_traits_sensor",
    "int_vip_influence_traits_sensor_range",
    "int_vip_influence_traits_waypoint",
    "int_vip_influence_traits_active_camo",
    "int_vip_influence_traits_visual_aura",
    "int_vip_influence_traits_forced_color",
    "int_vip_vip_traits_damage_resistance",
    "int_vip_vip_traits_shield_multiplier",
    "int_vip_vip_traits_shield_recharge",
    "int_vip_vip_traits_headshot_immunity",
    "int_vip_vip_traits_vampirism",
    "int_vip_vip_traits_damage_modifier",
    "sid_vip_vip_traits_primary_weapon",
    "sid_vip_vip_traits_secondary_weapon",
    "int_vip_vip_traits_grenade_count",
    "int_vip_vip_traits_grenade_recharge",
    "int_vip_vip_traits_infinite_ammo",
    "int_vip_vip_traits_weapon_pickup",
    "int_vip_vip_traits_speed",
    "int_vip_vip_traits_gravity",
    "int_vip_vip_traits_vehicle_use",
    "int_vip_vip_traits_sensor",
    "int_vip_vip_traits_sensor_range",
    "int_vip_vip_traits_waypoint",
    "int_vip_vip_traits_active_camo",
    "int_vip_vip_traits_visual_aura",
    "int_vip_vip_traits_forced_color",
    "int_juggernaut_score_to_win",
    "int_juggernaut_kill_points",
    "int_juggernaut_juggy_kill_points",
    "int_juggernaut_kill_as_juggy_points",
    "int_juggernaut_zone_arrival_points",
    "int_juggernaut_suicide_points",
    "int_juggernaut_betrayal_points",
    "int_juggernaut_initial_juggy_selection",
    "int_juggernaut_next_juggy_selection",
    "int_juggernaut_allied_against_juggy",
    "int_juggernaut_next_juggy_delay",
    "int_juggernaut_zones_enabled",
    "int_juggernaut_zone_movement",
    "int_juggernaut_zone_order",
    "int_juggernaut_respawn_on_lone_juggy",
    "int_juggernaut_juggernaut_traits_damage_resistance",
    "int_juggernaut_juggernaut_traits_shield_multiplier",
    "int_juggernaut_juggernaut_traits_shield_recharge",
    "int_juggernaut_juggernaut_traits_headshot_immunity",
    "int_juggernaut_juggernaut_traits_vampirism",
    "int_juggernaut_juggernaut_traits_damage_modifier",
    "sid_juggernaut_juggernaut_traits_primary_weapon",
    "sid_juggernaut_juggernaut_traits_secondary_weapon",
    "int_juggernaut_juggernaut_traits_grenade_count",
    "int_juggernaut_juggernaut_traits_grenade_recharge",
    "int_juggernaut_juggernaut_traits_infinite_ammo",
    "int_juggernaut_juggernaut_traits_weapon_pickup",
    "int_juggernaut_juggernaut_traits_speed",
    "int_juggernaut_juggernaut_traits_gravity",
    "int_juggernaut_juggernaut_traits_vehicle_use",
    "int_juggernaut_juggernaut_traits_sensor",
    "int_juggernaut_juggernaut_traits_sensor_range",
    "int_juggernaut_juggernaut_traits_waypoint",
    "int_juggernaut_juggernaut_traits_active_camo",
    "int_juggernaut_juggernaut_traits_visual_aura",
    "int_juggernaut_juggernaut_traits_forced_color",
    "int_unknown_traits_damage_resistance",
    "int_unknown_traits_shield_multiplier",
    "int_unknown_traits_shield_recharge",
    "int_unknown_traits_headshot_immunity",
    "int_unknown_traits_vampirism",
    "int_unknown_traits_damage_modifier",
    "sid_unknown_traits_primary_weapon",
    "sid_unknown_traits_secondary_weapon",
    "int_unknown_traits_grenade_count",
    "int_unknown_traits_grenade_recharge",
    "int_unknown_traits_infinite_ammo",
    "int_unknown_traits_weapon_pickup",
    "int_unknown_traits_speed",
    "int_unknown_traits_gravity",
    "int_unknown_traits_vehicle_use",
    "int_unknown_traits_sensor",
    "int_unknown_traits_sensor_range",
    "int_unknown_traits_waypoint",
    "int_unknown_traits_active_camo",
    "int_unknown_traits_visual_aura",
    "int_unknown_traits_forced_color",
    "int_assault_arm_time",
    "int_assault_disarm_time",
    "int_assault_fuse_time",
    "int_assault_reset_time",
    "int_assault_carrier_traits_damage_resistance",
    "int_assault_carrier_traits_shield_multiplier",
    "int_assault_carrier_traits_shield_recharge",
    "int_assault_carrier_traits_headshot_immunity",
    "int_assault_carrier_traits_vampirism",
    "int_assault_carrier_traits_damage_modifier",
    "sid_assault_carrier_traits_primary_weapon",
    "sid_assault_carrier_traits_secondary_weapon",
    "int_assault_carrier_traits_grenade_count",
    "int_assault_carrier_traits_grenade_recharge",
    "int_assault_carrier_traits_infinite_ammo",
    "int_assault_carrier_traits_weapon_pickup",
    "int_assault_carrier_traits_speed",
    "int_assault_carrier_traits_gravity",
    "int_assault_carrier_traits_vehicle_use",
    "int_assault_carrier_traits_sensor",
    "int_assault_carrier_traits_sensor_range",
    "int_assault_carrier_traits_waypoint",
    "int_assault_carrier_traits_active_camo",
    "int_assault_carrier_traits_visual_aura",
    "int_assault_carrier_traits_forced_color",
    "int_assault_unknown",
    "int_assault_game_mode",
    "int_assault_reset_on_disarm",
    "int_assault_enemy_bomb_waypoint",
    "int_assault_score_to_win",
    "int_assault_sudden_death",
    "int_editor_open_channel_voice",
    "int_editor_edit_mode",
    "int_editor_respawn_time",
    "int_editor_editor_traits_damage_resistance",
    "int_editor_editor_traits_shield_multiplier",
    "int_editor_editor_traits_shield_recharge",
    "int_editor_editor_traits_headshot_immunity",
    "int_editor_editor_traits_vampirism",
    "int_editor_editor_traits_damage_modifier",
    "sid_editor_editor_traits_primary_weapon",
    "sid_editor_editor_traits_secondary_weapon",
    "int_editor_editor_traits_grenade_count",
    "int_editor_editor_traits_grenade_recharge",
    "int_editor_editor_traits_infinite_ammo",
    "int_editor_editor_traits_weapon_pickup",
    "int_editor_editor_traits_speed",
    "int_editor_editor_traits_gravity",
    "int_editor_editor_traits_vehicle_use",
    "int_editor_editor_traits_sensor",
    "int_editor_editor_traits_sensor_range",
    "int_editor_editor_traits_waypoint",
    "int_editor_editor_traits_active_camo",
    "int_editor_editor_traits_visual_aura",
    "int_editor_editor_traits_forced_color",
    "int_global_traits_template_damage_resistance",
    "int_global_traits_template_shield_multiplier",
    "int_global_traits_template_shield_recharge",
    "int_global_traits_template_headshot_immunity",
    "int_global_traits_template_vampirism",
    "int_global_traits_template_damage_modifier",
    "sid_global_traits_template_primary_weapon",
    "sid_global_traits_template_secondary_weapon",
    "int_global_traits_template_grenade_count",
    "int_global_traits_template_grenade_recharge",
    "int_global_traits_template_infinite_ammo",
    "int_global_traits_template_weapon_pickup",
    "int_global_traits_template_speed",
    "int_global_traits_template_gravity",
    "int_global_traits_template_vehicle_use",
    "int_global_traits_template_sensor",
    "int_global_traits_template_sensor_range",
    "int_global_traits_template_waypoint",
    "int_global_traits_template_active_camo",
    "int_global_traits_template_visual_aura",
    "int_global_traits_template_forced_color",
    )


sily_text_value_pair = Struct("text_value_pair",
    Bool8("flags",
        "default_setting",
        "unchanged_setting",
        ),
    SEnum8("expected_value_type", *sily_text_value_pair_expected_value_type),
    SInt16("unknown", VISIBLE=False),
    SInt32("integer_value"),
    h3_string_id("stringid_value"),
    h3_string_id("name"),
    h3_string_id("description"),
    ENDIAN=">", SIZE=20
    )


sily_body = Struct("tagdata",
    SEnum32("parameter", *sily_parameter),
    h3_string_id("name"),
    h3_string_id("description"),
    h3_reflexive("text_value_pairs", sily_text_value_pair),
    ENDIAN=">", SIZE=24
    )


def get():
    return sily_def

sily_def = TagDef("sily",
    h3_blam_header('sily'),
    sily_body,

    ext=".%s" % h3_tag_class_fcc_to_ext["sily"], endian=">", tag_cls=H3Tag
    )
