# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AzureMonitorMetricsDestination(Model):
    """Azure Monitor Metrics destination.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A friendly name for the destination.
     This name should be unique across all destinations (regardless of type)
     within the data collection rule.
    :type name: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 32, 'min_length': 0, 'pattern': r'^[-\w\._\(\)]+$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureMonitorMetricsDestination, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class DataCollectionRule(Model):
    """Definition of what monitoring data to collect and where that data should be
    sent.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param description: Description of the data collection rule.
    :type description: str
    :param data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be
     used via direct calls to the provisioned endpoint.
    :type data_sources:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDataSources
    :param destinations: Required. The specification of destinations.
    :type destinations:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDestinations
    :param data_flows: Required. The specification of data flows.
    :type data_flows:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Possible values
     include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleProvisioningState
    """

    _validation = {
        'description': {'max_length': 256},
        'destinations': {'required': True},
        'data_flows': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'data_sources': {'key': 'dataSources', 'type': 'DataCollectionRuleDataSources'},
        'destinations': {'key': 'destinations', 'type': 'DataCollectionRuleDestinations'},
        'data_flows': {'key': 'dataFlows', 'type': '[DataFlow]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataCollectionRule, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.data_sources = kwargs.get('data_sources', None)
        self.destinations = kwargs.get('destinations', None)
        self.data_flows = kwargs.get('data_flows', None)
        self.provisioning_state = None


class DataCollectionRuleAssociation(Model):
    """Definition of association of a data collection rule with a monitored Azure
    resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param description: Description of the association.
    :type description: str
    :param data_collection_rule_id: Required. The resource ID of the data
     collection rule that is to be associated.
    :type data_collection_rule_id: str
    :ivar provisioning_state: The resource provisioning state. Possible values
     include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleAssociationProvisioningState
    """

    _validation = {
        'description': {'max_length': 256},
        'data_collection_rule_id': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'data_collection_rule_id': {'key': 'dataCollectionRuleId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataCollectionRuleAssociation, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.data_collection_rule_id = kwargs.get('data_collection_rule_id', None)
        self.provisioning_state = None


class DataCollectionRuleAssociationProxyOnlyResource(Model):
    """Definition of generic ARM proxy resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param description: Description of the association.
    :type description: str
    :param data_collection_rule_id: Required. The resource ID of the data
     collection rule that is to be associated.
    :type data_collection_rule_id: str
    :ivar provisioning_state: The resource provisioning state. Possible values
     include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleAssociationProvisioningState
    :ivar id: Fully qualified ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    """

    _validation = {
        'description': {'max_length': 256},
        'data_collection_rule_id': {'required': True},
        'provisioning_state': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'data_collection_rule_id': {'key': 'properties.dataCollectionRuleId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataCollectionRuleAssociationProxyOnlyResource, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.data_collection_rule_id = kwargs.get('data_collection_rule_id', None)
        self.provisioning_state = None
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class DataSourcesSpec(Model):
    """Specification of data sources that will be collected.

    :param performance_counters: The list of performance counter data source
     configurations.
    :type performance_counters:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.PerfCounterDataSource]
    :param windows_event_logs: The list of Windows Event Log data source
     configurations.
    :type windows_event_logs:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.WindowsEventLogDataSource]
    :param syslog: The list of Syslog data source configurations.
    :type syslog:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.SyslogDataSource]
    :param extensions: The list of Azure VM extension data source
     configurations.
    :type extensions:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.ExtensionDataSource]
    """

    _attribute_map = {
        'performance_counters': {'key': 'performanceCounters', 'type': '[PerfCounterDataSource]'},
        'windows_event_logs': {'key': 'windowsEventLogs', 'type': '[WindowsEventLogDataSource]'},
        'syslog': {'key': 'syslog', 'type': '[SyslogDataSource]'},
        'extensions': {'key': 'extensions', 'type': '[ExtensionDataSource]'},
    }

    def __init__(self, **kwargs):
        super(DataSourcesSpec, self).__init__(**kwargs)
        self.performance_counters = kwargs.get('performance_counters', None)
        self.windows_event_logs = kwargs.get('windows_event_logs', None)
        self.syslog = kwargs.get('syslog', None)
        self.extensions = kwargs.get('extensions', None)


class DataCollectionRuleDataSources(DataSourcesSpec):
    """The specification of data sources.
    This property is optional and can be omitted if the rule is meant to be
    used via direct calls to the provisioned endpoint.

    :param performance_counters: The list of performance counter data source
     configurations.
    :type performance_counters:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.PerfCounterDataSource]
    :param windows_event_logs: The list of Windows Event Log data source
     configurations.
    :type windows_event_logs:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.WindowsEventLogDataSource]
    :param syslog: The list of Syslog data source configurations.
    :type syslog:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.SyslogDataSource]
    :param extensions: The list of Azure VM extension data source
     configurations.
    :type extensions:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.ExtensionDataSource]
    """

    _attribute_map = {
        'performance_counters': {'key': 'performanceCounters', 'type': '[PerfCounterDataSource]'},
        'windows_event_logs': {'key': 'windowsEventLogs', 'type': '[WindowsEventLogDataSource]'},
        'syslog': {'key': 'syslog', 'type': '[SyslogDataSource]'},
        'extensions': {'key': 'extensions', 'type': '[ExtensionDataSource]'},
    }

    def __init__(self, **kwargs):
        super(DataCollectionRuleDataSources, self).__init__(**kwargs)


class DestinationsSpec(Model):
    """Specification of destinations that can be used in data flows.

    :param log_analytics: List of Log Analytics destinations.
    :type log_analytics:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.LogAnalyticsDestination]
    :param azure_monitor_metrics: Azure Monitor Metrics destination.
    :type azure_monitor_metrics:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DestinationsSpecAzureMonitorMetrics
    """

    _attribute_map = {
        'log_analytics': {'key': 'logAnalytics', 'type': '[LogAnalyticsDestination]'},
        'azure_monitor_metrics': {'key': 'azureMonitorMetrics', 'type': 'DestinationsSpecAzureMonitorMetrics'},
    }

    def __init__(self, **kwargs):
        super(DestinationsSpec, self).__init__(**kwargs)
        self.log_analytics = kwargs.get('log_analytics', None)
        self.azure_monitor_metrics = kwargs.get('azure_monitor_metrics', None)


class DataCollectionRuleDestinations(DestinationsSpec):
    """The specification of destinations.

    :param log_analytics: List of Log Analytics destinations.
    :type log_analytics:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.LogAnalyticsDestination]
    :param azure_monitor_metrics: Azure Monitor Metrics destination.
    :type azure_monitor_metrics:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DestinationsSpecAzureMonitorMetrics
    """

    _attribute_map = {
        'log_analytics': {'key': 'logAnalytics', 'type': '[LogAnalyticsDestination]'},
        'azure_monitor_metrics': {'key': 'azureMonitorMetrics', 'type': 'DestinationsSpecAzureMonitorMetrics'},
    }

    def __init__(self, **kwargs):
        super(DataCollectionRuleDestinations, self).__init__(**kwargs)


class DataCollectionRuleResource(Model):
    """Definition of ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param description: Description of the data collection rule.
    :type description: str
    :param data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be
     used via direct calls to the provisioned endpoint.
    :type data_sources:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDataSources
    :param destinations: Required. The specification of destinations.
    :type destinations:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDestinations
    :param data_flows: Required. The specification of data flows.
    :type data_flows:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Possible values
     include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleProvisioningState
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar id: Fully qualified ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    """

    _validation = {
        'description': {'max_length': 256},
        'destinations': {'required': True},
        'data_flows': {'required': True},
        'provisioning_state': {'readonly': True},
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'data_sources': {'key': 'properties.dataSources', 'type': 'DataCollectionRuleDataSources'},
        'destinations': {'key': 'properties.destinations', 'type': 'DataCollectionRuleDestinations'},
        'data_flows': {'key': 'properties.dataFlows', 'type': '[DataFlow]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataCollectionRuleResource, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.data_sources = kwargs.get('data_sources', None)
        self.destinations = kwargs.get('destinations', None)
        self.data_flows = kwargs.get('data_flows', None)
        self.provisioning_state = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class DataFlow(Model):
    """Definition of which streams are sent to which destinations.

    All required parameters must be populated in order to send to Azure.

    :param streams: Required. List of streams for this data flow.
    :type streams: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataFlowStreams]
    :param destinations: Required. List of destinations for this data flow.
    :type destinations: list[str]
    """

    _validation = {
        'streams': {'required': True},
        'destinations': {'required': True},
    }

    _attribute_map = {
        'streams': {'key': 'streams', 'type': '[str]'},
        'destinations': {'key': 'destinations', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(DataFlow, self).__init__(**kwargs)
        self.streams = kwargs.get('streams', None)
        self.destinations = kwargs.get('destinations', None)


class DestinationsSpecAzureMonitorMetrics(AzureMonitorMetricsDestination):
    """Azure Monitor Metrics destination.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A friendly name for the destination.
     This name should be unique across all destinations (regardless of type)
     within the data collection rule.
    :type name: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 32, 'min_length': 0, 'pattern': r'^[-\w\._\(\)]+$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DestinationsSpecAzureMonitorMetrics, self).__init__(**kwargs)


class ErrorAdditionalInfo(Model):
    """Additional information for common error response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetails(Model):
    """Common error details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error code which can be used to programmatically identify the
     class of error.
    :vartype code: str
    :ivar message: Describes the error in detail and provides debugging
     information.
    :vartype message: str
    :ivar target: The target of the particular error (for example, the name of
     the property in error).
    :vartype target: str
    :ivar details: Additional nested error detail objects.
    :vartype details:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.ErrorDetails]
    :ivar additional_info: Additional error information.
    :vartype additional_info:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(self, **kwargs):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(Model):
    """Common error response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error: Error details.
    :vartype error:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.ErrorResponseError
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseError'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = None


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class ErrorResponseError(ErrorDetails):
    """Error details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error code which can be used to programmatically identify the
     class of error.
    :vartype code: str
    :ivar message: Describes the error in detail and provides debugging
     information.
    :vartype message: str
    :ivar target: The target of the particular error (for example, the name of
     the property in error).
    :vartype target: str
    :ivar details: Additional nested error detail objects.
    :vartype details:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.ErrorDetails]
    :ivar additional_info: Additional error information.
    :vartype additional_info:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponseError, self).__init__(**kwargs)


class ExtensionDataSource(Model):
    """Definition of which data will be collected from a separate VM extension
    that integrates with the Azure Monitor Agent.
    Collected from either Windows and Linux machines, depending on which
    extension is defined.

    All required parameters must be populated in order to send to Azure.

    :param streams: Required. List of streams that this data source will be
     sent to.
     A stream indicates what schema will be used for this data and usually what
     table in Log Analytics the data will be sent to.
    :type streams: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownExtensionDataSourceStreams]
    :param extension_name: Required. The name of the VM extension.
    :type extension_name: str
    :param extension_settings: The extension settings. The format is specific
     for particular extension.
    :type extension_settings: object
    :param name: Required. A friendly name for the data source.
     This name should be unique across all data sources (regardless of type)
     within the data collection rule.
    :type name: str
    """

    _validation = {
        'streams': {'required': True},
        'extension_name': {'required': True, 'max_length': 64, 'min_length': 0, 'pattern': r'^[-\w\._\(\)]+$'},
        'name': {'required': True, 'max_length': 32, 'min_length': 0, 'pattern': r'^[-\w\._\(\)]+$'},
    }

    _attribute_map = {
        'streams': {'key': 'streams', 'type': '[str]'},
        'extension_name': {'key': 'extensionName', 'type': 'str'},
        'extension_settings': {'key': 'extensionSettings', 'type': 'object'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExtensionDataSource, self).__init__(**kwargs)
        self.streams = kwargs.get('streams', None)
        self.extension_name = kwargs.get('extension_name', None)
        self.extension_settings = kwargs.get('extension_settings', None)
        self.name = kwargs.get('name', None)


class LogAnalyticsDestination(Model):
    """Log Analytics destination.

    All required parameters must be populated in order to send to Azure.

    :param workspace_resource_id: Required. The resource ID of the Log
     Analytics workspace.
    :type workspace_resource_id: str
    :param name: Required. A friendly name for the destination.
     This name should be unique across all destinations (regardless of type)
     within the data collection rule.
    :type name: str
    """

    _validation = {
        'workspace_resource_id': {'required': True},
        'name': {'required': True, 'max_length': 32, 'min_length': 0, 'pattern': r'^[-\w\._\(\)]+$'},
    }

    _attribute_map = {
        'workspace_resource_id': {'key': 'workspaceResourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LogAnalyticsDestination, self).__init__(**kwargs)
        self.workspace_resource_id = kwargs.get('workspace_resource_id', None)
        self.name = kwargs.get('name', None)


class PerfCounterDataSource(Model):
    """Definition of which performance counters will be collected and how they
    will be collected by this data collection rule.
    Collected from both Windows and Linux machines where the counter is
    present.

    All required parameters must be populated in order to send to Azure.

    :param streams: Required. List of streams that this data source will be
     sent to.
     A stream indicates what schema will be used for this data and usually what
     table in Log Analytics the data will be sent to.
    :type streams: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownPerfCounterDataSourceStreams]
    :param scheduled_transfer_period: Required. The interval between data
     uploads (scheduled transfers), rounded up to the nearest minute. Possible
     values include: 'PT1M', 'PT5M', 'PT15M', 'PT30M', 'PT60M'
    :type scheduled_transfer_period: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownPerfCounterDataSourceScheduledTransferPeriod
    :param sampling_frequency_in_seconds: Required. The number of seconds
     between consecutive counter measurements (samples).
    :type sampling_frequency_in_seconds: int
    :param counter_specifiers: Required. A list of specifier names of the
     performance counters you want to collect.
     Use a wildcard (*) to collect a counter for all instances.
     To get a list of performance counters on Windows, run the command
     'typeperf'.
    :type counter_specifiers: list[str]
    :param name: Required. A friendly name for the data source.
     This name should be unique across all data sources (regardless of type)
     within the data collection rule.
    :type name: str
    """

    _validation = {
        'streams': {'required': True},
        'scheduled_transfer_period': {'required': True},
        'sampling_frequency_in_seconds': {'required': True, 'maximum': 30, 'minimum': 1},
        'counter_specifiers': {'required': True},
        'name': {'required': True, 'max_length': 32, 'min_length': 0, 'pattern': r'^[-\w\._\(\)]+$'},
    }

    _attribute_map = {
        'streams': {'key': 'streams', 'type': '[str]'},
        'scheduled_transfer_period': {'key': 'scheduledTransferPeriod', 'type': 'str'},
        'sampling_frequency_in_seconds': {'key': 'samplingFrequencyInSeconds', 'type': 'int'},
        'counter_specifiers': {'key': 'counterSpecifiers', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PerfCounterDataSource, self).__init__(**kwargs)
        self.streams = kwargs.get('streams', None)
        self.scheduled_transfer_period = kwargs.get('scheduled_transfer_period', None)
        self.sampling_frequency_in_seconds = kwargs.get('sampling_frequency_in_seconds', None)
        self.counter_specifiers = kwargs.get('counter_specifiers', None)
        self.name = kwargs.get('name', None)


class ResourceForUpdate(Model):
    """Definition of ARM tracked top level resource properties for update
    operation.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ResourceForUpdate, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class SyslogDataSource(Model):
    """Definition of which syslog data will be collected and how it will be
    collected.
    Only collected from Linux machines.

    All required parameters must be populated in order to send to Azure.

    :param streams: Required. List of streams that this data source will be
     sent to.
     A stream indicates what schema will be used for this data and usually what
     table in Log Analytics the data will be sent to.
    :type streams: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownSyslogDataSourceStreams]
    :param facility_names: Required. The list of facility names.
    :type facility_names: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownSyslogDataSourceFacilityNames]
    :param log_levels: The log levels to collect.
    :type log_levels: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownSyslogDataSourceLogLevels]
    :param name: Required. A friendly name for the data source.
     This name should be unique across all data sources (regardless of type)
     within the data collection rule.
    :type name: str
    """

    _validation = {
        'streams': {'required': True},
        'facility_names': {'required': True},
        'name': {'required': True, 'max_length': 32, 'min_length': 0, 'pattern': r'^[-\w\._\(\)]+$'},
    }

    _attribute_map = {
        'streams': {'key': 'streams', 'type': '[str]'},
        'facility_names': {'key': 'facilityNames', 'type': '[str]'},
        'log_levels': {'key': 'logLevels', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyslogDataSource, self).__init__(**kwargs)
        self.streams = kwargs.get('streams', None)
        self.facility_names = kwargs.get('facility_names', None)
        self.log_levels = kwargs.get('log_levels', None)
        self.name = kwargs.get('name', None)


class WindowsEventLogDataSource(Model):
    """Definition of which Windows Event Log events will be collected and how they
    will be collected.
    Only collected from Windows machines.

    All required parameters must be populated in order to send to Azure.

    :param streams: Required. List of streams that this data source will be
     sent to.
     A stream indicates what schema will be used for this data and usually what
     table in Log Analytics the data will be sent to.
    :type streams: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownWindowsEventLogDataSourceStreams]
    :param scheduled_transfer_period: Required. The interval between data
     uploads (scheduled transfers), rounded up to the nearest minute. Possible
     values include: 'PT1M', 'PT5M', 'PT15M', 'PT30M', 'PT60M'
    :type scheduled_transfer_period: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownWindowsEventLogDataSourceScheduledTransferPeriod
    :param x_path_queries: Required. A list of Windows Event Log queries in
     XPATH format.
    :type x_path_queries: list[str]
    :param name: Required. A friendly name for the data source.
     This name should be unique across all data sources (regardless of type)
     within the data collection rule.
    :type name: str
    """

    _validation = {
        'streams': {'required': True},
        'scheduled_transfer_period': {'required': True},
        'x_path_queries': {'required': True},
        'name': {'required': True, 'max_length': 32, 'min_length': 0, 'pattern': r'^[-\w\._\(\)]+$'},
    }

    _attribute_map = {
        'streams': {'key': 'streams', 'type': '[str]'},
        'scheduled_transfer_period': {'key': 'scheduledTransferPeriod', 'type': 'str'},
        'x_path_queries': {'key': 'xPathQueries', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WindowsEventLogDataSource, self).__init__(**kwargs)
        self.streams = kwargs.get('streams', None)
        self.scheduled_transfer_period = kwargs.get('scheduled_transfer_period', None)
        self.x_path_queries = kwargs.get('x_path_queries', None)
        self.name = kwargs.get('name', None)
