# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import MonitorManagementClientConfiguration
from .operations import DataCollectionRuleAssociationsOperations
from .operations import DataCollectionRulesOperations
from . import models


class MonitorManagementClient(SDKClient):
    """Monitor Management Client

    :ivar config: Configuration for client.
    :vartype config: MonitorManagementClientConfiguration

    :ivar data_collection_rule_associations: DataCollectionRuleAssociations operations
    :vartype data_collection_rule_associations: azure.mgmt.monitor.v2019_11_01_preview.operations.DataCollectionRuleAssociationsOperations
    :ivar data_collection_rules: DataCollectionRules operations
    :vartype data_collection_rules: azure.mgmt.monitor.v2019_11_01_preview.operations.DataCollectionRulesOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = MonitorManagementClientConfiguration(credentials, subscription_id, base_url)
        super(MonitorManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2019-11-01-preview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.data_collection_rule_associations = DataCollectionRuleAssociationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.data_collection_rules = DataCollectionRulesOperations(
            self._client, self.config, self._serialize, self._deserialize)
