# -*- coding: utf-8 -*-
"""This code is a part of Yoda extension

.. module:: hydratk.extensions.yoda.translation.en
   :platform: Unix
   :synopsis: English language translation for Yoda extension
.. moduleauthor:: Petr Czaderna <pc@hydratk.org>

"""

language = {
  'name' : 'English',
  'ISO-639-1' : 'en'
}

msg = {
    'yoda_start_test_from' : ['Starting tests from directory: {0}'],
    'yoda_test_repo_root_override' : ['Overriding test_repo_root directory with: {0}'],
    'yoda_invalid_test_base_path' : ['Invalid test base path: {0}'],
    'yoda_invalid_test_repo_root' : ['Invalid test repository root directory: {0}'],
    'yoda_added_helpers_dir' : ['Added helpers directory {0}'],
    'yoda_helpers_dir_not_exists' : ['Helpers directory {0} doesn\'t exists, skipping'],
    'yoda_added_lib_dir' : ['Added shared library directory {0}'],
    'yoda_lib_dir_not_exists' : ['Shared library directory {0} doesn\'t exists, skipping'],    
    'yoda_process_test_sets_total' : ['Found {0} test sets for processing'],
    'yoda_no_tests_found_in_path' : ['No tests found in specified path: {0}'],
    'yoda_process_test_set' : ['Processing test set: {0}'],
    'yoda_test_run_summary' : ['Test Run: test sets: {0}, tests - total: {1}, failed: {2}, passed: {3}'],
    'yoda_test_set_summary' : ['Test Set: {0}'],
    'yoda_test_scenario_summary' : ['Test Scenario: {0}, tests - total: {1}, failed: {2}, passed: {3}'],
    'yoda_test_scenario_prereq_passed' : ['Pre-requirements passed successfully'],
    'yoda_test_scenario_prereq_failed' : ['Pre-requirements failed: {0}'],
    'yoda_test_scenario_postreq_passed' : ['Post-requirements passed successfully'],
    'yoda_test_scenario_postreq_failed' : ['Post-requirements failed: {0}'],    
    'yoda_test_scenario_events_failed' : ['There were problems in test scenario events: \n{0}'],
    'yoda_test_case_events_failed' : ['There were problems in test case events: \n{0}'],
    'yoda_test_condition_events_failed' : ['There were problems in test condition events: \n{0}'],
    'yoda_test_condition_test_exec_failed' : ['There were problems in test execution: \n{0}'],
    'yoda_test_condition_validate_exec_failed' : ['There were problems in test validation: \n{0}'],
    'yoda_test_case' : ['Test Case: {0}'],
    'yoda_test_condition' : ['Test Condition: {0}'],
    'yoda_expected_result' : ['Expected Result: {0}'],
    'yoda_actual_result' : ['Actual Result: {0}'],
    'yoda_log' : ['Log: {0}'],            
}
