/*
 Copyright 2009-2012 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Thu Sep 13 01:20:27 2012 by Lino version 1.5.0.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ];
STRENGTH_CHOICES = [ [ "0", "Certainement pas" ], [ "1", "plut\u00f4t pas" ], [ "2", "moyennement" ], [ "3", "assez bien" ], [ "4", "tr\u00e8s bien" ] ];
KNOWLEDGE_CHOICES = [ [ "0", "pas du tout" ], [ "1", "un peu" ], [ "2", "moyennement" ], [ "3", "bien" ], [ "4", "tr\u00e8s bien" ] ];
MEDIA_URL = '/media';
ROOT_URL = '';

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See http://lino.saffre-rumma.net/blog/2012/0307.html
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20120714,'Lino.set_subst_user',id,name);
    Lino.subst_user = id;
    Lino.eventStore.setBaseParam("su",id);
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) Lino.permalink_handler(Lino.current_window)();
}


//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 8; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.Viewport = Ext.extend(Ext.Viewport,{
  layout:"fit"
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Veuillez attendre..."});
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : ROOT_URL + '/api/main_html',
        waitMsg: "Veuillez attendre...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});



Lino.open_window = function(win,st) {
  //~ console.log("20120203 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st);
  win.show();
};

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url = ROOT_URL + "/"
      //~ console.log("20120222 Lino.close_all_windows() : location.replace(",ROOT_URL,")");
      //~ if (ROOT_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      location.replace(url);
  } else {
    //~ console.log("20120222 Lino.close_all_windows()",Lino.window_history);
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.5.0.'});


Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Enregistrer vos changements au texte?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}





/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;
      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          //~ if (this.isVertical(item) && item.getResizeEl()) {
          if (this.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ item.syncSize()
                  //~ item.doLayout()
                  //~ if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
                  //~ console.log(item.flex);
              }
          } 
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,reponse,arg) {
  //~ throw reponse;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "reponse=",reponse,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run({base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: 'Confirmation',
    msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    buttons: Ext.MessageBox.YESNOCANCEL,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url: ROOT_URL + '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
      if (on_success && result.success) on_success(result);
      if (on_confirm && result.confirm_message) {
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = result.confirm_message;
          config.fn = function(buttonId,text,opt) {
            if (buttonId == "yes") {
                on_confirm(panel,undefined,result.step);
            }
          }
          Ext.MessageBox.show(config);
          return;
      }
      if (result.message) {
          //~ if (result.alert && ! gridmode) {
          if (result.alert) { // 20120628b 
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              if (result.alert === true) result.alert = "Alert";
              Ext.MessageBox.alert(result.alert,result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      // 
      if (result.data_record && ! gridmode) {
          //~ not used
          panel.set_status({data_record:result.data_record});
      }
      else if (result.new_status && ! gridmode) {
          //~ not used
          //~ console.log('20120607 new_status');
          panel.set_status(result.new_status);
      }
      else if (result.goto_record_id != undefined && ! gridmode) {
          //~ console.log('20120607 new_status');
          panel.load_record_id(result.goto_record_id);
      }
      else if (result.refresh_all) {
          var cw = panel.get_containing_window();
          //~ console.log("20120123 refresh_all");
          if (cw) {
            cw.main_item.refresh();
          }
          else console.log("20120123 cannot refresh_all",panel);
      } else {
          if (result.refresh) panel.refresh();
      }
      if (result.open_url) {
          //~ console.log(20111126,result.open_url);
          //~ if (!result.message)
              //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
          window.open(result.open_url,'foo',"");
          //~ document.location = result.open_url;
      }
      if (result.eval_js) {
          //~ console.log(20120618,result.eval_js);
          eval(result.eval_js);
      }
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Veuillez attendre...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    location.replace(ww.main_item.get_permalink());
    //~ console.log(20120715, ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  is_home_page : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { return true; } // overridden by subclasses
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = ROOT_URL + '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = ROOT_URL + '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return ROOT_URL+'/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p['an'] = this.action_name;
      this.add_param_values(p)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        tbar = tbar.concat([{ scope:this, 
          text: "[paramètres]", // gear
          enableToggle: true,
          pressed: ! this.params_panel.hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        }]);
        var t = this;
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox)
              f.on('check',function() {t.refresh()});
          else if (f instanceof Ext.form.TriggerField)
              f.on('select',function() {t.refresh()});
          else
              f.on('change',function() {t.refresh()});
          });
      }
      return tbar;
  }
  ,add_param_values : function (p) {
    if (this.params_panel) {
      //~ var formdata = Lino.form2dict(this.params_panel);
      //~ console.log('20120203 add_param_values formdata', formdata);
      //~ p.pv = formdata;
      //~ return;
      //~ var formdata = Ext.lib.Ajax.serializeForm(frm);
      var fields = this.params_panel.fields;
      //~ console.log('20120116 gonna loop on', fields);
      var pv = Array(fields.length);
      for(var i=0; i < fields.length;i++) {
          var f = fields[i]
          if (f.formatDate) {
              pv[i] = f.formatDate(f.getValue()); 
          } else {
              pv[i] = f.getValue(); 
          }
      }
      p.pv = pv;
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
    
  },
  set_param_values : function(pv) {
    //~ console.log('20120203 set_param_values', pv);
    if (this.params_panel) {
      if (pv) this.params_panel.form.my_loadRecord(pv);
      else this.params_panel.form.reset(); 
      
      //~ var fields = this.params_panel.fields;
      //~ console.log('20120116 gonna loop on', fields);
      //~ for(var i=0; i < fields.length;i++) {
          //~ var f = fields[i]
          //~ f.setValue(pv[i]); 
      //~ }
      //~ this.refresh();
      //~ console.log(20120113,options);
    }
    //~ var test = {test:"foo"};
    //~ this.add_param_values(test);
    //~ console.log('20120203 set_param_values test is ', test);
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 

Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    var t = c.getEl();
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};

  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  Lino.lino.ContentTypes.detail_action.run({record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

//~ Lino.hide_zero_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ console.log("20120510");
  //~ if (value == 0) return ''
  //~ return value;
//~ }

//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run({record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};


Lino.call_row_action = function(panel,url,actionName,step,fn) {
//~ Lino.call_row_action = function(panel,rec_id,actionName,step,fn) {
  //~ var url = panel.get_record_url(rec_id);
  var p = {an : actionName};
  if (!panel) panel = Lino.viewport;
  Ext.apply(p,panel.get_base_params());
  panel.loadMask.show(); 
  //~ p.su = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  if (step) p['as'] = step;
  Ext.Ajax.request({
    method: 'GET',
    url: url,
    params: p,
    success: Lino.action_handler(panel,undefined,fn)
  });
};

Lino.row_action_handler = function(actionName) {
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_row_action(panel,rec.id,actionName,step,fn);
      Lino.call_row_action(panel,panel.get_record_url(rec.id),actionName,step,fn);
    });
  };
  return fn;
};


Lino.run_row_action = function(rp,url,pk,actionName) {
  //~ var panel = action.get_window().main_item;
  url = ROOT_URL + '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(rp);
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_row_action(panel,pk,actionName,step,fn);
    Lino.call_row_action(panel,url,actionName,step,fn);
  }
  fn(panel,null,null);
}


Lino.list_action_handler = function(actionName,gridmode) {
  var fn = function(panel,btn,step) {
    //~ console.log(panel);
    var url = ROOT_URL + '/api' + panel.ls_url ;
    var p = Ext.apply({},panel.get_base_params());
    p.an = actionName;
    //~ p.su = Lino.subst_user;
    //~ Lino.insert_subst_user(p);
    if (step) p['as'] = step;
    panel.loadMask.show(); // 20120211
    Ext.Ajax.request({
      method: 'GET',
      url: url,
      params: p,
      success: Lino.action_handler(panel,undefined,fn)
    });
  };
  return fn;
};

Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      panel.ls_detail_handler.run({
        record_id:rec.id,
        base_params:panel.get_base_params()
      });
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run({record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  panel.ls_insert_handler.run({record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run({data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };



if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};


//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      //~ Lino.do_when_visible(this,todo.createDelegate(this));
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);


Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: ROOT_URL + '/media/lino/extjs/lino.css',
        language: 'de',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = ROOT_URL + '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('query',null); // 20111018
    //~ this.set_base_param('query',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    this.bbar = actions.bbar;
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: config.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: ROOT_URL + '/choices' + config.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Aller vers enregistrement"
        })
        config.tbar = config.tbar.concat([this.record_selector]);
        
        config.tbar = config.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"Premier",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Précédent",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Suivant",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Dernier",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      config.tbar = this.add_params_panel(config.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      config.tbar = config.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      config.tbar = config.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    if (config.content_type && this.action_name != 'insert') {
      config.bbar = config.bbar.concat([
        '->',
        { text: "[Editer textes d'aide]",
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this}
        //~ ,{ text: '[Layout Editor]',
          //~ handler: this.edit_detail_config,
          //~ qtip: "Edit Detail layout",
          //~ scope: this}
      ])
    }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Veuillez attendre..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  is_loading : function() { 
    if (this.current_record == null) return true; 
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      return st;
  },
  set_status : function(status){
    //~ console.log('20120622 FormPanel.set_status()',this,status);
    this.clear_base_params();
    if (status == undefined) status = {};
    if (status.param_values) this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = 'json';
    p.rp = this.getId();
    //~ p.su = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['query'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20120622 load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('goto_record_id success',rec);
          if (rec.navinfo && rec.navinfo.recno == 0) {
              /* 
                recno 0 means "the requested pk exists but is not contained in the requested queryset".
                This can happen e.g. after search_change on a detail.
              */
              //~ this_.goto_record_id(rec.navinfo.first);
              if (rec.navinfo.first) {
                  this.load_record_id(rec.navinfo.first);
              } else this.abandon();
                  
          } else {
              this.set_current_record(rec,after);
          }
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          this.getBottomToolbar().items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (record.navinfo && ! this.hide_top_toolbar && ! this.hide_navigator) {
        this.first.setDisabled(!record.navinfo.first);
        this.prev.setDisabled(!record.navinfo.prev);
        this.next.setDisabled(!record.navinfo.next);
        this.last.setDisabled(!record.navinfo.last);
        this.displayItem.setText(record.navinfo.message);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return ROOT_URL + '/api' + this.ls_url + '/' + rec.id;
      return ROOT_URL + '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after) {
    //~ var panel = this;
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      p.an = this.action_name;
      if (rec.phantom) {
        if (this.action_name != 'insert') 
            console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: ROOT_URL + '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run({
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        if (this.action_name != 'detail') 
            console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: ROOT_URL + '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{tab : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ROOT_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ROOT_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
      
    var ps = this.grid_panel.calculatePageSize();
    
    if (!ps) {
        //~ this.gridpanel.on('render',this.load())
      //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
      return false;
        //~ params.limit = 1;
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    } 
    
    options.params.limit = ps;
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
    } else {
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  //~ quick_search_text : '',
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"No data to display."
        //~ },
  loadMask: {msg:"Veuillez attendre..."},
  
  constructor : function(config){
    config.plugins = [new Lino.GridFilters()];
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  is_loading : function() { 
    //~ return this.store.getCount() > 0; 
    return !this.loadMask.disabled; 
  },
  
  config_containing_window : function(wincfg) { 
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"Save Grid Data",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: ROOT_URL + '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ROOT_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (this_.selModel.getSelectedCell){
            if (this_.getStore().getCount()) // there may be no data
                this_.selModel.select(0,0); 
        } else {
            this_.selModel.selectFirstRow();
            this_.getView().focusEl.focus();
        }
      }, this
    );
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.search_field = new Ext.form.TextField({ 
          fieldLabel: "Search", 
          listeners: { scope:this_, change:this_.search_change }
          //~ value: text
          //~ scope:this, 
          //~ enableKeyEvents: true, 
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          text: "[csv]", 
          handler: function() { 
            var p = Ext.apply({},this.get_base_params());
            p['fmt'] = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.fmt = "printer";
            //~ this.add_param_values(p);
            //~ window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          text: "[html]", 
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "plain";
            this.add_param_values(p);
            window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          text: "[pdf]", 
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p);
            window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Vue",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "de {0}",
        displayMsg: "Affichage  {0} - {1} de {2}",
        firstText: "Première page",
        lastText: "Dernière page",
        prevText: "Page précédente",
        nextText: "Next page",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    delete this.page_length
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    this.cmenu = actions.cmenu;
    
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var p = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        p.current_page = this.getTopToolbar().current;
    }
    //~ console.log("20120213 GridPanel.get_status",p);
    return p;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20120717 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    if (status.param_values) this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
    
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5;
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:ROOT_URL + '/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20120514 GridPanel.on_beforeedit()',e,e.record.data.disabled_fields);
    if(e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      //~ Lino.notify(String.format("Field '{0}' is disabled",e.field));
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    p['an'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      Ext.apply(req,{
        method: 'POST',
        url: ROOT_URL + '/api' + this.ls_url
      });
    } else {
      Ext.apply(req,{
        method: 'PUT',
        url: ROOT_URL + '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'Veuillez attendre...',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  autoSelect: false,
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      config.tools = config.tools.concat([ 
        { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(record_data){
    //~ loadRecord : function(record){
        /* Forward also `record` to field.setValue() 
        so that Lino.Combobox can use it. 
        Lino never uses an array record here, so we can ignore this case. 
        */
        //~ console.log('20110214e loadRecord',record.data)
        var field, id;
        for(id in record_data){
            if(!Ext.isFunction(record_data[id]) && (field = this.findField(id))){
                field.setValue(record_data[id],record_data);
                if(this.trackResetOnLoad){
                    field.originalValue = field.getValue();
                    //~ if (field.hiddenField) {
                      //~ field.hiddenField.originalValue = field.hiddenField.value;
                    //~ }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}


Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run({record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert('Cannot show MTI child if checkbox is off.');
    }
  } else {
    Lino.notify('No current record.');
  }
};




/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


Lino.on_eventclick = function(cp,rec,el) {
  //~ console.log("Lino.on_eventclick",arguments);
  //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  Lino.cal.PanelEvents.detail_action.run({record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}
    
Lino.on_editdetails = function(cp,rec,el) {
  //~ console.log("Lino.on_editdetails",arguments);
  if (rec.data.ID)
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail_action.run({record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: ROOT_URL + '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: ROOT_URL + '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.tv = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: ROOT_URL + '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendrier"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  ,eventStore: Lino.eventStore
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      Lino.calendarStore.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      Lino.eventStore.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      Lino.eventStore.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  //~ empty_title : "$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendrier"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status) { this.refresh();}
  ,refresh : function() {Lino.eventStore.reload();}
  ,layout: 'fit'
  ,is_loading : function() { 
      var loading = Lino.calendarStore.getCount() == 0 | Lino.eventStore.getCount() == 0
      //~ console.log("CalendarPanel loading:",loading);
      return loading; 
  }
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
  }
  ,clear_base_params : function() {
      this.base_params = {};
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.calendar_app = function() { return {
  get_main_panel : function() {
      return new Lino.CalendarAppPanel({ items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              Lino.calendarPanel.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"Vue équipe",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Vue équipe",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      Lino.eventStore.setBaseParam('tv',state);
                      Lino.eventStore.load();
                      //~ Lino.eventStore.load({params:{tv:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: Lino.calendarStore,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel',
              eventStore: Lino.eventStore,
              calendarStore: Lino.calendarStore,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              initComponent: function() {
                  Lino.calendarPanel = this;
                  this.constructor.prototype.initComponent.apply(this, arguments);
              },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          Lino.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
}();



/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 

Lino.main_menu = [ { "menu": { "items": [ { "text": "Organisations", "handler": function(){Lino.contacts.Companies.default_action.run({ "record_id": -99998 })} }, { "text": "Personnes", "handler": function(){Lino.contacts.Persons.default_action.run({ "record_id": -99998 })} }, { "text": "Clients", "handler": function(){Lino.pcsw.Clients.default_action.run({ "record_id": -99998 })} }, { "text": "Alle partners", "handler": function(){Lino.contacts.AllPartners.default_action.run({ "record_id": -99998 })} }, { "text": "Mes Recherches de personnes", "handler": function(){Lino.pcsw.MyPersonSearches.default_action.run({ "record_id": -99998 })} }, { "text": "M\u00e9nages", "handler": function(){Lino.households.Households.default_action.run({ "record_id": -99998 })} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Mes notes", "handler": function(){Lino.notes.MyNotes.default_action.run({ "record_id": -99998 })} }, { "text": "Mes Uploads", "handler": function(){Lino.uploads.MyUploads.default_action.run({ "record_id": -99998 })} }, { "menu": { "items": [ { "text": "My Outbox", "handler": function(){Lino.outbox.MyOutbox.default_action.run({ "record_id": -99998 })} }, { "text": "Mes Postings", "handler": function(){Lino.postings.MyPostings.default_action.run({ "record_id": -99998 })} } ] }, "text": "Outbox" }, { "text": "Mes PIISs", "handler": function(){Lino.isip.MyContracts.default_action.run({ "record_id": -99998 })} }, { "text": "Mes Contrats de travail", "handler": function(){Lino.jobs.MyContracts.default_action.run({ "record_id": -99998 })} }, { "menu": { "items": [ { "text": "Mes clients", "handler": function(){Lino.pcsw.MyClients.default_action.run({ "record_id": -99998 })} }, { "text": "Bilan", "handler": function(){Lino.pcsw.MyClientsByGroup.default_action.run({ "base_params": { "mt": 78, "mk": 1 } })} }, { "text": "Pr\u00e9formation", "handler": function(){Lino.pcsw.MyClientsByGroup.default_action.run({ "base_params": { "mt": 78, "mk": 2 } })} }, { "text": "Formation", "handler": function(){Lino.pcsw.MyClientsByGroup.default_action.run({ "base_params": { "mt": 78, "mk": 3 } })} }, { "text": "Recherche active emplois", "handler": function(){Lino.pcsw.MyClientsByGroup.default_action.run({ "base_params": { "mt": 78, "mk": 4 } })} }, { "text": "Travail", "handler": function(){Lino.pcsw.MyClientsByGroup.default_action.run({ "base_params": { "mt": 78, "mk": 5 } })} }, { "text": "Standby", "handler": function(){Lino.pcsw.MyClientsByGroup.default_action.run({ "base_params": { "mt": 78, "mk": 6 } })} } ] }, "text": "Mes clients" }, { "text": "Mes Coachings", "handler": function(){Lino.pcsw.MyCoachings.default_action.run({ "record_id": -99998 })} }, { "text": "Mes Text Field Templates", "handler": function(){Lino.lino.MyTextFieldTemplates.default_action.run({ "record_id": -99998 })} } ] }, "text": "Mon menu" }, { "menu": { "items": [ { "text": "Calendrier", "handler": function(){Lino.cal.CalendarPanel.default_action.run({ "record_id": -99998 })} }, { "text": "Mes Rendez-vous", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my calendar events.") }, "handler": function(){Lino.cal.MyEvents.default_action.run({ "record_id": -99998 })} }, { "text": "Mes rendez-vous propos\u00e9s", "listeners": { "render": Lino.quicktip_renderer("Foo","Tableau de mes rendez-vous \u00e0 l'\u00e9tat \"Propos\u00e9\".") }, "handler": function(){Lino.cal.MyEventsSuggested.default_action.run({ "record_id": -99998 })} }, { "text": "Mes rendez-vous communiqu\u00e9s", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of my notified events (waiting to become scheduled).") }, "handler": function(){Lino.cal.MyEventsNotified.default_action.run({ "record_id": -99998 })} }, "-", "-", { "text": "Mes T\u00e2ches", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my tasks.") }, "handler": function(){Lino.cal.MyTasks.default_action.run({ "record_id": -99998 })} }, { "text": "To-do list", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of my tasks marked 'to do'.") }, "handler": function(){Lino.cal.MyTasksToDo.default_action.run({ "record_id": -99998 })} }, "-", { "text": "Mes invitations re\u00e7ues", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my received invitations, independently of their state.") }, "handler": function(){Lino.cal.MyInvitations.default_action.run({ "record_id": -99998 })} }, { "text": "Mes invitations re\u00e7ues \u00e0 confirmer", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows received invitations which I must accept or reject.") }, "handler": function(){Lino.cal.MyPendingInvitations.default_action.run({ "record_id": -99998 })} } ] }, "text": "Calendrier" }, { "menu": { "items": [ { "text": "Employants", "handler": function(){Lino.jobs.JobProviders.default_action.run({ "record_id": -99998 })} }, { "text": "Emplois", "handler": function(){Lino.jobs.Jobs.default_action.run({ "record_id": -99998 })} }, { "text": "Offres d'emploi", "handler": function(){Lino.jobs.Offers.default_action.run({ "record_id": -99998 })} }, { "text": "Recherche contrats de travail", "handler": function(){Lino.jobs.ContractsSearch.default_action.run({ "record_id": -99998 })} } ] }, "text": "Emplois" }, { "menu": { "items": [ { "text": "Organisateurs de cours", "handler": function(){Lino.courses.CourseProviders.default_action.run({ "record_id": -99998 })} }, { "text": "Offres de cours", "handler": function(){Lino.courses.CourseOffers.default_action.run({ "record_id": -99998 })} }, { "text": "Pending Course Requests", "handler": function(){Lino.courses.PendingCourseRequests.default_action.run({ "record_id": -99998 })} } ] }, "text": "Cours" }, { "menu": { "items": [ { "text": "Situation contrats Art 60-7", "handler": function(){Lino.jobs.JobsOverview.detail_action.run({ "record_id": -99998 })} }, { "text": "Agents et leurs clients", "handler": function(){Lino.pcsw.UsersWithClients.default_action.run({ "record_id": -99998 })} } ] }, "text": "Listings" }, { "menu": { "items": [ { "text": "\u00e0 propos", "handler": function(){Lino.lino.About.default_action.run({ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "D\u00e9part", "handler": function() { location.replace('javascript:Lino.close_all_windows()'); }, "xtype": "button" } ];
Ext.namespace('Lino.lino.SiteConfigs')
Ext.namespace('Lino.lino.ContentTypes')
Ext.namespace('Lino.lino.HelpTexts')
Ext.namespace('Lino.lino.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.postings.Postings')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Memberships')
Ext.namespace('Lino.cal.Places')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.EventsSuggested')
Ext.namespace('Lino.cal.EventsNotified')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.pcsw.Partners')
Ext.namespace('Lino.contacts.AllPartners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.pcsw.AllClients')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.MyClients')
Ext.namespace('Lino.pcsw.MyActiveClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.PersonSearches')
Ext.namespace('Lino.pcsw.OverlappingContracts')
Ext.namespace('Lino.pcsw.ProjectContacts')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.StudyTypes')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.Newcomers')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.UsersByNewcomer')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.cv.LanguageKnowledgeTable')
Ext.namespace('Lino.pcsw.WantedLanguageKnowledgeTable')
Ext.namespace('Lino.properties.WantedSkillTable')
Ext.namespace('Lino.properties.UnwantedSkillTable')
Ext.namespace('Lino.lino.MyTextFieldTemplates')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.postings.PostingsByPartner')
Ext.namespace('Lino.postings.PostingsByProject')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.MembershipsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByPartner')
Ext.namespace('Lino.cal.EventsByPlace')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyEventsSuggested')
Ext.namespace('Lino.cal.MyEventsNotified')
Ext.namespace('Lino.cal.MyEventsToday')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.MyTasksToDo')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.MyInvitations')
Ext.namespace('Lino.cal.MyPendingInvitations')
Ext.namespace('Lino.cal.RemindersByUser')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.ClientsByCoach1')
Ext.namespace('Lino.pcsw.MyClientsByGroup')
Ext.namespace('Lino.pcsw.ExclusionsByPerson')
Ext.namespace('Lino.pcsw.MyPersonSearches')
Ext.namespace('Lino.pcsw.LanguageKnowledgesBySearch')
Ext.namespace('Lino.pcsw.WantedPropsBySearch')
Ext.namespace('Lino.pcsw.UnwantedPropsBySearch')
Ext.namespace('Lino.pcsw.ClientsBySearch')
Ext.namespace('Lino.pcsw.ContactsByProject')
Ext.namespace('Lino.pcsw.CoachingsByProject')
Ext.namespace('Lino.pcsw.MyCoachings')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.NewcomersByFaculty')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.lino.HelpTextsByModel')
Ext.namespace('Lino.postings.PostingsByController')
Ext.namespace('Lino.postings.MyPostings')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.lino.Models')
Ext.namespace('Lino.lino.FieldsByModel')
Ext.namespace('Lino.lino.Inspector')
Ext.namespace('Lino.pcsw.UsersWithClients')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.BudgetSummary')
Ext.namespace('Lino.lino.About')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.lino.Home')
Ext.namespace('Lino.jobs.JobsOverview')

Lino.lino.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox2880 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "split": true });
    var UsersWithClients_htmlbox2881 = new Lino.HtmlBoxPanel({ "flex": 8, "layout": "fit", "name": "UsersWithClients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Agents et leurs clients", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.UsersWithClients.default_action) ] });
    var coming_reminders_htmlbox2882 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "coming_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Rappels \u00e0 venir", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var missed_reminders_htmlbox2883 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "missed_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Rappels rat\u00e9s", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var main_3_panel2884 = new Ext.Panel({ "flex": 16, "layout": "hbox", "items": [ coming_reminders_htmlbox2882, missed_reminders_htmlbox2883 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 207, "border": false, "region": "south", "labelAlign": "top" });
    var main_panel2885 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "labelWidth": 243, "items": [ quick_links_htmlbox2880, UsersWithClients_htmlbox2881, main_3_panel2884 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2885;
    this.before_row_edit = function(record) {
      quick_links_htmlbox2880.refresh();
      UsersWithClients_htmlbox2881.refresh();
      coming_reminders_htmlbox2882.refresh();
      missed_reminders_htmlbox2883.refresh();
    }
    Lino.lino.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var name1061 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1062 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1063 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1064 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1061, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1062, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1063, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var HouseholdsByType_grid1164 = new Lino.households.HouseholdsByType.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.default_action) ], "master_panel": this });
    var main_panel1165 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1064, HouseholdsByType_grid1164 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1165;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid1164.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 6,
  initComponent : function() {
    var containing_panel = this;
    var username1166 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nom d'utilisateur</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email1167 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "adresse e-mail", "anchor": "-20", "name": "email" });
    var main_1_panel1168 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1166, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1167, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name1171 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name1172 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var main_2_panel1173 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1171, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1172, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner1176 = new Lino.TwinCombo({ "fieldLabel": "partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.AllPartners.detail_action)}, "emptyText": "Choisir partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language1177 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var profile1178 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": [ [ "100", "100 (Integration Agent)" ], [ "110", "110 (Integration Agent (Senior))" ], [ "200", "200 (Newcomers consultant)" ], [ "300", "300 (Debts consultant)" ], [ "400", "400 (Readonly User)" ], [ "500", "500 (CBSS only)" ], [ "900", "900 (Administrator)" ] ], "hiddenName": "profileHidden" });
    var main_4_panel1179 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1177, "labelAlign": "top" }, { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile1178, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1182 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel1168, main_2_panel1173, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1176, "anchor": "-20", "labelAlign": "top" }, main_4_panel1179 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    this.items = main_panel1182;
    this.before_row_edit = function(record) {
    }
    Lino.users.MySettings.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var containing_panel = this;
    var ref1184 = new Ext.form.TextField({ "fieldLabel": "ref", "name": "ref", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name1185 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1186 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1187 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1188 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1184, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1185, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1186, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1187, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var account_type1193 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Type de compte", "name": "account_type", "selectOnFocus": true, "anchor": "-20", "store": [ [ "A", "Assets" ], [ "L", "Obligations" ], [ "I", "Revenus" ], [ "E", "D\u00e9penses" ], [ "C", "Capital" ] ], "hiddenName": "account_typeHidden" });
    var id1194 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var main_2_panel1195 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type1193, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1194, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var help_text1198 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Introduction" });
    var AccountsByGroup_grid1212 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.default_action) ], "master_panel": this });
    var main_panel1213 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel1188, main_2_panel1195, help_text1198, AccountsByGroup_grid1212 ], "autoScroll": true, "labelWidth": 0, "border": false, "labelAlign": "top" });
    this.items = main_panel1213;
    this.before_row_edit = function(record) {
      help_text1198.refresh();
      AccountsByGroup_grid1212.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var startup_time1955 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Server up since", "anchor": "-20", "value": "<br>", "name": "startup_time" });
    var main_1_panel1956 = new Ext.Panel({ "flex": 5, "autoHeight": true, "labelWidth": 162, "items": [ { "flex": 57, "html": "<a href=\"http://code.google.com/p/lino-welfare/\" target=\"_blank\">Lino/Welfare</a> 0.1.0<br/><a href=\"http://lino.saffre-rumma.net\" target=\"_blank\">Lino</a> 1.5.0<br/><a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.dev17942<br/><a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 1.5<br/><a href=\"http://cheetahtemplate.org/\" target=\"_blank\">Cheetah</a> 2.4.4<br/><a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.4<br/><a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.7<br/><a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4.1<br/><a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.08<br/><a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.0 (2011/12/15 22:41)<br/><a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.1<br/><a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>", "xtype": "label" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": startup_time1955, "labelAlign": "top" } ], "frame": false, "split": true, "hideCheckBoxLabels": true, "layout": "hbox", "border": false, "region": "north", "labelAlign": "top" });
    var Models_htmlbox1958 = new Lino.HtmlBoxPanel({ "flex": 10, "layout": "fit", "name": "Models", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Models", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.lino.Models.default_action) ] });
    var main_panel1959 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "labelWidth": 72, "items": [ main_1_panel1956, Models_htmlbox1958 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1959;
    this.before_row_edit = function(record) {
      Models_htmlbox1958.refresh();
    }
    Lino.lino.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var type1306 = new Lino.ChoicesFieldElement({ "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name1307 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1308 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1309 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var id1310 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var main_1_panel1311 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1306, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1307, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1308, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1309, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1310, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var url_template1317 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL template", "anchor": "-20", "name": "url_template" });
    var username1318 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom d'utilisateur", "anchor": "-20", "name": "username" });
    var password1319 = new Ext.form.TextField({ "fieldLabel": "Password", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    var main_2_panel1320 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template1317, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1318, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password1319, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var readonly1324 = new Ext.form.Checkbox({ "boxLabel": "read-only", "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "-20" });
    var invite_team_members1325 = new Ext.form.Checkbox({ "boxLabel": "Inviter membres d'\u00e9quipe", "hideLabel": true, "checked": false, "name": "invite_team_members", "selectOnFocus": true, "anchor": "-20" });
    var color1326 = { "fieldLabel": "Couleur", "xtype": "numberfield", "value": 1, "name": "color", "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var start_date1327 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var main_3_panel1328 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly1324, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members1325, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1326, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1327, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 225, "border": false, "labelAlign": "top" });
    var build_method1333 = new Lino.ChoicesFieldElement({ "fieldLabel": "M\u00e9thode de construction", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1334 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Mod\u00e8le", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }), "name": "template" });
    var email_template1335 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var attach_to_email1336 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel1337 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1333, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1334, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1335, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1336, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 198, "border": false, "labelAlign": "top" });
    var main_panel1374 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1311, main_2_panel1320, main_3_panel1328, main_4_panel1337 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1374;
    this.before_row_edit = function(record) {
      template1334.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method1333.on('change',Lino.chooser_handler(template1334,'build_method'));
      Lino.cal.PanelCalendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.PanelCalendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.AllClients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 75,
  initComponent : function() {
    var containing_panel = this;
    var last_name16 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name17 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var title18 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Allocution", "anchor": "-20", "name": "title" });
    var box1_1_panel19 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name16, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name17, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title18, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country23 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/country", "method": "GET" }) }) });
    var city24 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Endroit", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/city", "method": "GET" }) }) });
    var zip_code25 = new Ext.form.TextField({ "fieldLabel": "Code postal", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel26 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country23, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city24, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code25, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix30 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street31 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no32 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box33 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_3_panel34 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix30, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street31, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no32, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box33, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr239 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_panel40 = new Ext.form.FieldSet({ "flex": 61, "autoHeight": true, "labelWidth": 216, "title": "Adresse", "items": [ box1_1_panel19, box1_2_panel26, box1_3_panel34, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr239, "anchor": "-20", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id42 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language43 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var box2_1_panel44 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id42, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language43, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email47 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var phone48 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var fax49 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var box2_3_panel50 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone48, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax49, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gsm53 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box2_panel54 = new Ext.form.FieldSet({ "flex": 38, "autoHeight": true, "labelWidth": 63, "title": "Contact", "items": [ box2_1_panel44, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email47, "anchor": "-20", "labelAlign": "top" }, box2_3_panel50, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm53, "anchor": "-20", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var tab1_1_panel57 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box1_panel40, box2_panel54 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender58 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ], "hiddenName": "genderHidden" });
    var birth_date59 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","Unkomplette Geburtsdaten sind erlaubt, z.B. \n<ul>\n<li>00.00.1980 : irgendwann in 1980</li>\n<li>00.07.1980 : im Juli 1980</li>\n<li>23.07.0000 : Geburtstag am 23. Juli, Alter unbekannt</li>\n</ul>") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date de naissance</span>", "anchor": "-20", "name": "birth_date" });
    var age_disp60 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "\u00c2ge", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var civil_state61 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Etat civil", "name": "civil_state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "c\u00e9libataire" ], [ "13", "Single cohabitating" ], [ "18", "Single with child" ], [ "20", "mari\u00e9" ], [ "21", "Married (living alone)" ], [ "22", "Married (living with another partner)" ], [ "30", "veuf/veuve" ], [ "33", "Widow cohabitating" ], [ "40", "divorc\u00e9" ], [ "50", "s\u00e9par\u00e9" ] ], "hiddenName": "civil_stateHidden" });
    var noble_condition62 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adelstitel","The eventual noble condition of this person. Imported from TIM.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Titre de noblesse</span>", "name": "noble_condition", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var box3_1_panel63 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender58, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date59, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp60, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": civil_state61, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": noble_condition62, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_country69 = new Lino.TwinCombo({ "fieldLabel": "Pays de naissance", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/birth_country", "method": "GET" }) }) });
    var birth_place70 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Lieu de naissance", "anchor": "-20", "name": "birth_place" });
    var nationality71 = new Lino.TwinCombo({ "fieldLabel": "Nationalit\u00e9", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/nationality", "method": "GET" }) }) });
    var national_id72 = new Ext.form.TextField({ "fieldLabel": "NISS", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var box3_2_panel73 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country69, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place70, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality71, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id72, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel78 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Naissance", "items": [ box3_1_panel63, box3_2_panel73 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "anchor": "-20", "labelAlign": "top" });
    var card_number79 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20, "fieldLabel": "n\u00b0", "anchor": "-20", "name": "card_number" });
    var card_valid_from80 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "valide de", "anchor": "-20", "name": "card_valid_from" });
    var card_valid_until81 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "expire le", "anchor": "-20", "name": "card_valid_until" });
    var card_issuer82 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50, "fieldLabel": "\u00e9mise par", "anchor": "-20", "name": "card_issuer" });
    var card_type83 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Type de carte eID", "name": "card_type", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Registre national" ], [ "6", "Kids card (< 12 year)" ], [ "8", "Habilitation" ], [ "11", "Foreigner card A" ], [ "12", "Foreigner card B" ], [ "13", "Foreigner card C" ], [ "14", "Foreigner card D" ], [ "15", "Foreigner card E" ], [ "16", "Foreigner card E+" ], [ "17", "Foreigner card F" ], [ "18", "Foreigner card F+" ] ], "hiddenName": "card_typeHidden" });
    var eid_panel_1_panel84 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Carte eID", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_number79, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_from80, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_until81, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_issuer82, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_type83, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 252, "border": true, "anchor": "-20", "labelAlign": "top" });
    var box4_panel90 = new Ext.Panel({ "flex": 82, "autoHeight": true, "layout": "form", "items": [ box3_panel78, eid_panel_1_panel84 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var image_htmlbox91 = new Lino.HtmlBoxPanel({ "flex": 17, "layout": "fit", "name": "image", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var tab1_2_panel92 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box4_panel90, image_htmlbox91 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "anchor": "-20", "labelAlign": "top" });
    var tab1_panel93 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Personne", "items": [ tab1_1_panel57, tab1_2_panel92 ], "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var in_belgium_since94 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Lebt in Belgien seit","Since when this person in Belgium lives.\n<b>Important:</b> help_text can be formatted.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">en Belgique depuis</span>", "anchor": "-20", "name": "in_belgium_since" });
    var residence_type95 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Type de s\u00e9jour", "name": "residence_type", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Registre national" ], [ "2", "Registre des \u00e9trangers" ], [ "3", "Registre d'attente " ] ], "hiddenName": "residence_typeHidden" });
    var gesdos_id96 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "N\u00b0 GesDos", "anchor": "-20", "name": "gesdos_id" });
    var group97 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Phase d'int\u00e9gration", "name": "group", "pageSize": 20, "emptyText": "Choisir Phase d'int\u00e9gration...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/group", "method": "GET" }) }) });
    var status_1_panel98 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": in_belgium_since94, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_type95, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id96, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group97, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account1103 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account2104 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var client_state105 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Client state", "allowBlank": false, "hiddenName": "client_stateHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Newcomer" ], [ "20", "Active" ], [ "30", "Official" ], [ "40", "Former" ], [ "50", "Invalid" ] ], "name": "client_state" });
    var status_2_panel106 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1103, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2104, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state105, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var status_panel110 = new Ext.Panel({ "flex": 68, "autoHeight": true, "layout": "form", "items": [ status_1_panel98, status_2_panel106 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var aid_type111 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'aide sociale", "name": "aid_type", "pageSize": 20, "emptyText": "Choisir Type d'aide sociale...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/aid_type", "method": "GET" }) }) });
    var income_ag112 = new Ext.form.Checkbox({ "boxLabel": "allocation de ch\u00f4mage", "hideLabel": true, "checked": false, "name": "income_ag", "selectOnFocus": true, "anchor": "-20" });
    var income_wg113 = new Ext.form.Checkbox({ "boxLabel": "waiting pay", "hideLabel": true, "checked": false, "name": "income_wg", "selectOnFocus": true, "anchor": "-20" });
    var income_2_panel114 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_ag112, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_wg113, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_kg117 = new Ext.form.Checkbox({ "boxLabel": "indemnisation maladie", "hideLabel": true, "checked": false, "name": "income_kg", "selectOnFocus": true, "anchor": "-20" });
    var income_rente118 = new Ext.form.Checkbox({ "boxLabel": "persone de retraite", "hideLabel": true, "checked": false, "name": "income_rente", "selectOnFocus": true, "anchor": "-20" });
    var income_3_panel119 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_kg117, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_rente118, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_misc122 = new Ext.form.Checkbox({ "boxLabel": "autres revenus", "hideLabel": true, "checked": false, "name": "income_misc", "selectOnFocus": true, "anchor": "-20" });
    var income_panel123 = new Ext.Panel({ "flex": 31, "autoHeight": true, "labelWidth": 153, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type111, "anchor": "-20", "labelAlign": "top" }, income_2_panel114, income_3_panel119, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_misc122, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var tab2_1_panel126 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ status_panel110, income_panel123 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var is_seeking127 = new Ext.form.Checkbox({ "boxLabel": "cherche du travail", "hideLabel": true, "checked": false, "name": "is_seeking", "selectOnFocus": true, "anchor": "-20" });
    var unemployed_since128 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Cherche du travail depuis", "anchor": "-20", "name": "unemployed_since" });
    var work_permit_suspended_until129 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "suspendu jusque", "anchor": "-20", "name": "work_permit_suspended_until" });
    var suche_1_panel130 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_seeking127, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unemployed_since128, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_suspended_until129, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var unavailable_until134 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Indidponible jusque", "anchor": "-20", "name": "unavailable_until" });
    var unavailable_why135 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "raison", "anchor": "-20", "name": "unavailable_why" });
    var suche_2_panel136 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_until134, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_why135, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 180, "border": false, "labelAlign": "top" });
    var pcsw_ExclusionsByPerson_grid144 = new Lino.pcsw.ExclusionsByPerson.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ExclusionsByPerson.default_action) ], "master_panel": this });
    var suche_panel145 = new Ext.form.FieldSet({ "flex": 50, "layout": "vbox", "title": "Recherche de travail", "layoutConfig": { "align": "stretch" }, "frame": false, "bodyBorder": true, "items": [ suche_1_panel130, suche_2_panel136, pcsw_ExclusionsByPerson_grid144 ], "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var needs_residence_permit146 = new Ext.form.Checkbox({ "boxLabel": "A besoin d'un permis de s\u00e9jour", "hideLabel": true, "checked": false, "name": "needs_residence_permit", "selectOnFocus": true, "anchor": "-20" });
    var needs_work_permit147 = new Ext.form.Checkbox({ "boxLabel": "A besoin d'un permis de travail", "hideLabel": true, "checked": false, "name": "needs_work_permit", "selectOnFocus": true, "anchor": "-20" });
    var papers_1_panel148 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_residence_permit146, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_work_permit147, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 261, "border": false, "labelAlign": "top" });
    var residence_permit_disp151 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Permis de s\u00e9jour", "name": "residence_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var work_permit_disp152 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Permis de travail", "name": "work_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var driving_licence_disp153 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "permis de conduire", "name": "driving_licence", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var papers_2_panel154 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_disp151, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_disp152, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_disp153, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" });
    var UploadsByController_htmlbox158 = new Lino.HtmlBoxPanel({ "flex": 55, "ls_bbar_actions": [ { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert_action, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.default_action) ] });
    var papers_panel159 = new Ext.form.FieldSet({ "flex": 50, "labelWidth": 72, "title": "Papiers", "layoutConfig": { "align": "stretch" }, "frame": false, "bodyBorder": true, "items": [ papers_1_panel148, papers_2_panel154, UploadsByController_htmlbox158 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": true, "labelAlign": "top" });
    var tab2_2_panel160 = new Ext.Panel({ "flex": 69, "layout": "hbox", "items": [ suche_panel145, papers_panel159 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var tab2_panel161 = new Ext.Panel({ "layout": "vbox", "title": "Statut", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ tab2_1_panel126, tab2_2_panel160 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var broker162 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Interm\u00e9diaire ", "name": "broker", "pageSize": 20, "emptyText": "Choisir Interm\u00e9diaire ...", "selectOnFocus": true, "hiddenName": "brokerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/broker", "method": "GET" }) }) });
    var faculty163 = new Lino.TwinCombo({ "fieldLabel": "Sp\u00e9cificit\u00e9", "name": "faculty", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.newcomers.Faculties.detail_action)}, "emptyText": "Choisir Sp\u00e9cificit\u00e9...", "selectOnFocus": true, "hiddenName": "facultyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/faculty", "method": "GET" }) }) });
    var coaching_1_panel164 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": broker162, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": faculty163, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var coach1167 = new Lino.TwinCombo({ "fieldLabel": "Agent ISP", "name": "coach1", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "disabled": true, "hiddenName": "coach1Hidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({  }) });
    var coach2168 = new Lino.TwinCombo({ "fieldLabel": "Agent SSP", "name": "coach2", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "coach2Hidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/coach2", "method": "GET" }) }) });
    var coached_from169 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Accompagn\u00e9 depuis", "anchor": "-20", "name": "coached_from" });
    var coached_until170 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "jusque", "anchor": "-20", "name": "coached_until" });
    var coaching_2_panel171 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coach1167, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coach2168, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_from169, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_until170, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var health_insurance176 = new Lino.TwinCombo({ "fieldLabel": "Caisse d'assurance maladie", "name": "health_insurance", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail_action)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "health_insuranceHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/health_insurance", "method": "GET" }) }) });
    var pharmacy177 = new Lino.TwinCombo({ "fieldLabel": "Pharmacie", "name": "pharmacy", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail_action)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "pharmacyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/pharmacy", "method": "GET" }) }) });
    var job_office_contact178 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Personne de contacte ALE ?", "name": "job_office_contact", "pageSize": 20, "emptyText": "Choisir Personne de contact...", "selectOnFocus": true, "hiddenName": "job_office_contactHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/job_office_contact", "method": "GET" }) }) });
    var coaching_3_panel179 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": health_insurance176, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pharmacy177, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job_office_contact178, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 162, "border": false, "labelAlign": "top" });
    var job_agents183 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Agences de travail", "anchor": "-20", "name": "job_agents" });
    var ContactsByProject_grid190 = new Lino.pcsw.ContactsByProject.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByProject.default_action) ], "master_panel": this });
    var CoachingsByProject_grid197 = new Lino.pcsw.CoachingsByProject.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByProject.default_action) ], "master_panel": this });
    var coaching_5_panel198 = new Ext.Panel({ "flex": 55, "layout": "hbox", "items": [ ContactsByProject_grid190, CoachingsByProject_grid197 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var coaching_panel199 = new Ext.Panel({ "labelWidth": 162, "title": "Coaching", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ coaching_1_panel164, coaching_2_panel171, coaching_3_panel179, { "items": job_agents183, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, coaching_5_panel198 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var jobs_StudiesByPerson_grid213 = new Lino.jobs.StudiesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByPerson.default_action) ] });
    var jobs_ExperiencesByPerson_grid223 = new Lino.jobs.ExperiencesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByPerson.default_action) ] });
    var tab3_panel224 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Formation", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ jobs_StudiesByPerson_grid213, jobs_ExperiencesByPerson_grid223 ], "border": false, "labelAlign": "top" });
    var cv_LanguageKnowledgesByPerson_grid231 = new Lino.cv.LanguageKnowledgesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.LanguageKnowledgesByPerson.default_action) ] });
    var courses_CourseRequestsByPerson_grid267 = new Lino.courses.CourseRequestsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseRequestsByPerson.default_action) ] });
    var tab4_panel268 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Langues", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ cv_LanguageKnowledgesByPerson_grid231, courses_CourseRequestsByPerson_grid267 ], "border": false, "labelAlign": "top" });
    var cv_SkillsByPerson_grid275 = new Lino.cv.SkillsByPerson.GridPanel({ "flex": 35, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.SkillsByPerson.default_action) ], "master_panel": this });
    var cv_SoftSkillsByPerson_grid282 = new Lino.cv.SoftSkillsByPerson.GridPanel({ "flex": 35, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.SoftSkillsByPerson.default_action) ], "master_panel": this });
    var skills283 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Autres talents", "anchor": "-20 -10", "growMax": 2000, "name": "skills" });
    var tab5_1_panel284 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_SkillsByPerson_grid275, cv_SoftSkillsByPerson_grid282, { "items": skills283, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 28 } ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 180, "border": false, "region": "north", "labelAlign": "top" });
    var cv_ObstaclesByPerson_grid292 = new Lino.cv.ObstaclesByPerson.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.ObstaclesByPerson.default_action) ], "master_panel": this });
    var obstacles293 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Obstacles", "anchor": "-20 -10", "growMax": 2000, "name": "obstacles" });
    var tab5_2_panel294 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_ObstaclesByPerson_grid292, { "items": obstacles293, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 44 } ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "region": "center", "labelAlign": "top" });
    var tab5_panel296 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Comp\u00e9tences", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ tab5_1_panel284, tab5_2_panel294 ], "border": false, "labelAlign": "top" });
    var jobs_CandidaturesByPerson_grid304 = new Lino.jobs.CandidaturesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Demandes d'emploi", "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByPerson.default_action) ], "master_panel": this });
    var pcsw_NotesByPerson_grid468 = new Lino.pcsw.NotesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByPerson.default_action) ] });
    var outbox_MailsByProject_grid480 = new Lino.outbox.MailsByProject.GridPanel({ "flex": 60, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByProject.default_action) ], "master_panel": this });
    var postings_PostingsByProject_grid491 = new Lino.postings.PostingsByProject.GridPanel({ "flex": 40, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByProject.default_action) ], "master_panel": this });
    var history_2_panel492 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ outbox_MailsByProject_grid480, postings_PostingsByProject_grid491 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "border": false, "region": "center", "labelAlign": "top" });
    var history_panel493 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Historique", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ pcsw_NotesByPerson_grid468, history_2_panel492 ], "border": false, "labelAlign": "top" });
    var isip_ContractsByPerson_grid670 = new Lino.isip.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByPerson.default_action) ] });
    var jobs_ContractsByPerson_grid755 = new Lino.jobs.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByPerson.default_action) ] });
    var contracts_panel756 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Contrats", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ isip_ContractsByPerson_grid670, jobs_ContractsByPerson_grid755 ], "border": false, "labelAlign": "top" });
    var cal_EventsByProject_grid781 = new Lino.cal.EventsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByProject.default_action) ] });
    var cal_TasksByProject_grid804 = new Lino.cal.TasksByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByProject.default_action) ] });
    var calendar_panel805 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Calendrier", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ cal_EventsByProject_grid781, cal_TasksByProject_grid804 ], "border": false, "labelAlign": "top" });
    var activity806 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/activity", "method": "GET" }) }) });
    var is_cpas807 = new Ext.form.Checkbox({ "boxLabel": "client CPAS", "hideLabel": true, "checked": false, "name": "is_cpas", "selectOnFocus": true, "anchor": "-20" });
    var is_senior808 = new Ext.form.Checkbox({ "boxLabel": "retrait\u00e9", "hideLabel": true, "checked": false, "name": "is_senior", "selectOnFocus": true, "anchor": "-20" });
    var is_deprecated809 = new Ext.form.Checkbox({ "boxLabel": "obsol\u00e8te", "hideLabel": true, "checked": false, "name": "is_deprecated", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel810 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_cpas807, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_senior808, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_deprecated809, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" });
    var remarks814 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var remarks2815 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque (Bureau Social)", "anchor": "-20 -10", "growMax": 2000, "name": "remarks2" });
    var contacts_RolesByPerson_grid820 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.default_action) ], "master_panel": this });
    var households_MembersByPerson_grid827 = new Lino.households.MembersByPerson.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.default_action) ], "master_panel": this });
    var misc_3_panel828 = new Ext.Panel({ "flex": 71, "layout": "hbox", "items": [ { "items": remarks814, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 25 }, { "items": remarks2815, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 25 }, contacts_RolesByPerson_grid820, households_MembersByPerson_grid827 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 288, "border": false, "labelAlign": "top" });
    var misc_panel831 = new Ext.Panel({ "labelWidth": 54, "title": "Divers", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ { "items": activity806, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, misc_2_panel810, misc_3_panel828 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var cbss_identify_person_disp833 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Requ\u00eates IdentifyPerson", "name": "cbss_identify_person", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_manage_access_disp834 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Requ\u00eates ManageAccess", "name": "cbss_manage_access", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_retrieve_ti_groups_disp835 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Requ\u00eates Tx25", "name": "cbss_retrieve_ti_groups", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_1_panel836 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_identify_person_disp833, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_manage_access_disp834, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_retrieve_ti_groups_disp835, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var cbss_summary_htmlbox840 = new Lino.HtmlBoxPanel({ "flex": 62, "layout": "fit", "name": "cbss_summary", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "CBSS summary", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var cbss_panel841 = new Ext.Panel({ "labelWidth": 117, "title": "CBSS", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ cbss_1_panel836, cbss_summary_htmlbox840 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var main_panel943 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ tab1_panel93, tab2_panel161, coaching_panel199, tab3_panel224, tab4_panel268, tab5_panel296, jobs_CandidaturesByPerson_grid304, history_panel493, contracts_panel756, calendar_panel805, misc_panel831, cbss_panel841 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel943;
    this.before_row_edit = function(record) {
      city24.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city24.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      image_htmlbox91.refresh();
      pcsw_ExclusionsByPerson_grid144.on_master_changed();
      UploadsByController_htmlbox158.refresh();
      ContactsByProject_grid190.on_master_changed();
      CoachingsByProject_grid197.on_master_changed();
      jobs_StudiesByPerson_grid213.on_master_changed();
      jobs_ExperiencesByPerson_grid223.on_master_changed();
      cv_LanguageKnowledgesByPerson_grid231.on_master_changed();
      courses_CourseRequestsByPerson_grid267.on_master_changed();
      cv_SkillsByPerson_grid275.on_master_changed();
      cv_SoftSkillsByPerson_grid282.on_master_changed();
      cv_ObstaclesByPerson_grid292.on_master_changed();
      jobs_CandidaturesByPerson_grid304.on_master_changed();
      pcsw_NotesByPerson_grid468.on_master_changed();
      outbox_MailsByProject_grid480.on_master_changed();
      postings_PostingsByProject_grid491.on_master_changed();
      isip_ContractsByPerson_grid670.on_master_changed();
      jobs_ContractsByPerson_grid755.on_master_changed();
      cal_EventsByProject_grid781.on_master_changed();
      cal_TasksByProject_grid804.on_master_changed();
      contacts_RolesByPerson_grid820.on_master_changed();
      households_MembersByPerson_grid827.on_master_changed();
      cbss_summary_htmlbox840.refresh();
    }
    this.onRender = function(ct, position) {
      country23.on('change',Lino.chooser_handler(city24,'country'));
      Lino.pcsw.AllClients.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.AllClients.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var isocode1375 = new Ext.form.TextField({ "fieldLabel": "isocode", "name": "isocode", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20", "allowBlank": false });
    var name1376 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1377 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1378 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var short_code1379 = new Ext.form.TextField({ "fieldLabel": "short code", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var inscode1380 = new Ext.form.TextField({ "fieldLabel": "Code INS", "name": "inscode", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20" });
    var main_1_panel1381 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode1375, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1376, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1377, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1378, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code1379, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode1380, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var countries_CitiesByCountry_grid1531 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 36, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.default_action) ], "master_panel": this });
    var jobs_StudiesByCountry_grid1544 = new Lino.jobs.StudiesByCountry.GridPanel({ "flex": 63, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCountry.default_action) ], "master_panel": this });
    var main_2_panel1545 = new Ext.Panel({ "flex": 83, "layout": "hbox", "items": [ countries_CitiesByCountry_grid1531, jobs_StudiesByCountry_grid1544 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel1546 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1381, main_2_panel1545 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1546;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid1531.on_master_changed();
      jobs_StudiesByCountry_grid1544.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.AllClients.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 75,
  initComponent : function() {
    var containing_panel = this;
    var title944 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Allocution", "anchor": "-20", "name": "title" });
    var first_name945 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name946 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel947 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title944, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name945, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name946, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender951 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ], "hiddenName": "genderHidden" });
    var language952 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var main_2_panel953 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender951, "labelAlign": "top" }, { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language952, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel956 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel947, main_2_panel953 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel956;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.AllClients.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.Properties.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var id963 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var group964 = new Lino.TwinCombo({ "fieldLabel": "Groupe de propri\u00e9t\u00e9s", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail_action)}, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "name": "group" });
    var type965 = new Lino.TwinCombo({ "fieldLabel": "Type de propri\u00e9t\u00e9", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropTypes.detail_action)}, "emptyText": "Choisir Type de propri\u00e9t\u00e9...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "name": "type" });
    var main_1_panel966 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id963, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group964, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type965, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 198, "border": false, "labelAlign": "top" });
    var name970 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr971 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en972 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var main_2_panel973 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name970, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr971, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en972, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var cv_PersonPropsByProp_grid983 = new Lino.cv.PersonPropsByProp.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.PersonPropsByProp.default_action) ], "master_panel": this });
    var main_panel984 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel966, main_2_panel973, cv_PersonPropsByProp_grid983 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel984;
    this.before_row_edit = function(record) {
      cv_PersonPropsByProp_grid983.on_master_changed();
    }
    Lino.properties.Properties.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 68,
  initComponent : function() {
    var containing_panel = this;
    var person1547 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id1548 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var language1549 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Langue", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "nl", "N\u00e9erlandais" ], [ "fr", "Fran\u00e7ais" ], [ "de", "Allemand" ] ], "hiddenName": "languageHidden" });
    var main_2_panel1550 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1548, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1549, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history1553 = new Ext.form.Checkbox({ "boxLabel": "Historique", "listeners": { "render": Lino.quicktip_renderer("Historie","Whatever this means.") }, "hideLabel": true, "checked": false, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var main_panel1554 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1547, "anchor": "-20", "labelAlign": "top" }, main_2_panel1550, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history1553, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    this.items = main_panel1554;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 9,
  initComponent : function() {
    var containing_panel = this;
    var name1395 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country1396 = new Lino.TwinCombo({ "fieldLabel": "Pays", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var inscode1397 = new Ext.form.TextField({ "fieldLabel": "Code INS", "name": "inscode", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var main_1_panel1398 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1395, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1396, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode1397, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var parent1402 = new Lino.TwinCombo({ "fieldLabel": "Part of", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var type1403 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Settlement Type", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id1404 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var main_2_panel1405 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1402, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1403, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1404, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var CitiesByCity_grid1526 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.default_action) ], "master_panel": this });
    var contacts_PartnersByCity_grid1527 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.default_action) ], "master_panel": this });
    var jobs_StudiesByCity_grid1528 = new Lino.jobs.StudiesByCity.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCity.default_action) ], "master_panel": this });
    var main_4_panel1529 = new Ext.Panel({ "flex": 41, "layout": "hbox", "items": [ contacts_PartnersByCity_grid1527, jobs_StudiesByCity_grid1528 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel1530 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1398, main_2_panel1405, CitiesByCity_grid1526, main_4_panel1529 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1530;
    this.before_row_edit = function(record) {
      type1403.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid1526.on_master_changed();
      contacts_PartnersByCity_grid1527.on_master_changed();
      jobs_StudiesByCity_grid1528.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1396.on('change',Lino.chooser_handler(type1403,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 17,
  initComponent : function() {
    var containing_panel = this;
    var prefix1557 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name1558 = new Ext.form.TextField({ "fieldLabel": "Nom", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id1559 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language1560 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var intro_box_1_panel1561 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix1557, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1558, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1559, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1560, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id1566 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "N\u00b0 de TVA", "anchor": "-20", "name": "vat_id" });
    var activity1567 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var type1568 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var intro_box_2_panel1569 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id1566, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1567, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1568, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel1573 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ intro_box_1_panel1561, intro_box_2_panel1569 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var country1574 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region1575 = new Lino.TwinCombo({ "fieldLabel": "R\u00e9gion", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var box3_1_panel1576 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1574, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1575, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1579 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Endroit", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code1580 = new Ext.form.TextField({ "fieldLabel": "Code postal", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1581 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1579, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1580, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1584 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1585 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1586 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1587 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1588 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1584, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1585, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1586, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1587, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21593 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel1594 = new Ext.Panel({ "flex": 61, "autoHeight": true, "labelWidth": 216, "items": [ box3_1_panel1576, box3_2_panel1581, box3_3_panel1588, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21593, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var email1596 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url1597 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1598 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm1599 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel1600 = new Ext.Panel({ "flex": 38, "autoHeight": true, "labelWidth": 72, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1596, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1597, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1598, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1599, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var address_box_panel1605 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box3_panel1594, box4_panel1600 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks1606 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_courseprovider1607 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est un organisateur de cours (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail_action)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_courseprovider" });
    var is_jobprovider1608 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est Employant (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail_action)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_jobprovider" });
    var box5_2_panel1609 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider1607, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider1608, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var box5_panel1612 = new Ext.Panel({ "flex": 57, "labelWidth": 108, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ { "items": remarks1606, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, box5_2_panel1609 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var contacts_RolesByCompany_grid1618 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.default_action) ], "master_panel": this });
    var bottom_box_panel1619 = new Ext.Panel({ "flex": 50, "layout": "hbox", "items": [ box5_panel1612, contacts_RolesByCompany_grid1618 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var general_panel1620 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ intro_box_panel1573, address_box_panel1605, bottom_box_panel1619 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid1632 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "NOtes", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.default_action) ], "master_panel": this });
    var main_panel1633 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel1620, pcsw_NotesByCompany_grid1632 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel1633;
    this.before_row_edit = function(record) {
      region1575.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1579.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1579.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid1618.on_master_changed();
      pcsw_NotesByCompany_grid1632.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1574.on('change',Lino.chooser_handler(region1575,'country'));
      country1574.on('change',Lino.chooser_handler(city1579,'country'));
      region1575.on('change',Lino.chooser_handler(city1579,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelEvents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var calendar576 = new Lino.TwinCombo({ "fieldLabel": "Calendrier", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail_action)}, "emptyText": "Choisir Calendrier...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary577 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Sommaire", "anchor": "-20", "name": "summary" });
    var user578 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var project579 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.AllClients.detail_action)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel580 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar576, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary577, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user578, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project579, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var start_date585 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var start_time586 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de d\u00e9but", "anchor": "-20", "name": "start_time" });
    var start_panel587 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date585, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time586, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date590 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "end_date" });
    var end_time591 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de fin", "anchor": "-20", "name": "end_time" });
    var end_panel592 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date590, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time591, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var general_2_panel595 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ start_panel587, end_panel592 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var place596 = new Lino.TwinCombo({ "fieldLabel": "Endroit", "name": "place", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Places.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "placeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/place", "method": "GET" }) }) });
    var priority597 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priorit\u00e9", "name": "priority", "pageSize": 20, "emptyText": "Choisir Priorit\u00e9...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class598 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Classe d'acc\u00e8s</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Priv\u00e9" ], [ "20", "Montrer \"occup\u00e9\"" ], [ "30", "Public" ] ], "name": "access_class" });
    var transparent599 = new Ext.form.Checkbox({ "boxLabel": "non bloquant", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel600 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": place596, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority597, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class598, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent599, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 162, "border": false, "labelAlign": "top" });
    var owner_disp605 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var state606 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Etat", "name": "state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Brouillon" ], [ "20", "Propos\u00e9" ], [ "30", "Communiqu\u00e9" ], [ "40", "Planif\u00e9" ], [ "50", "a eu lieu" ], [ "60", "D\u00e9plac\u00e9" ], [ "70", "Annul\u00e9" ], [ "80", "Absent" ], [ "90", "Obsol\u00e8te" ] ], "hiddenName": "stateHidden" });
    var workflow_buttons_disp607 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflows", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_4_panel608 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp605, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state606, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp607, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var description612 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "description", "title": "Description" });
    var GuestsByEvent_grid622 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.default_action) ], "master_panel": this });
    var general_5_panel623 = new Ext.Panel({ "flex": 45, "layout": "hbox", "items": [ description612, GuestsByEvent_grid622 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "labelAlign": "top" });
    var general_panel624 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel580, general_2_panel595, general_3_panel600, general_4_panel608, general_5_panel623 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var id625 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var created626 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified627 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var more_1_panel628 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id625, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created626, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified627, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var outbox_MailsByController_grid632 = new Lino.outbox.MailsByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.default_action) ], "master_panel": this });
    var postings_PostingsByController_grid633 = new Lino.postings.PostingsByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.default_action) ], "master_panel": this });
    var more_2_panel634 = new Ext.Panel({ "flex": 83, "layout": "hbox", "items": [ outbox_MailsByController_grid632, postings_PostingsByController_grid633 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var more_panel635 = new Ext.Panel({ "layout": "vbox", "title": "Plus", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ more_1_panel628, more_2_panel634 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel636 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel624, more_panel635 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel636;
    this.before_row_edit = function(record) {
      description612.refresh();
      GuestsByEvent_grid622.on_master_changed();
      outbox_MailsByController_grid632.on_master_changed();
      postings_PostingsByController_grid633.on_master_changed();
    }
    Lino.cal.PanelEvents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var summary443 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Sommaire", "anchor": "-20", "name": "summary" });
    var user444 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project445 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.AllClients.detail_action)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel446 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user444, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project445, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel449 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary443, "anchor": "-20", "labelAlign": "top" }, main_2_panel446 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    this.items = main_panel449;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.PendingCourseRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var date_submitted242 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("eingereicht am ","Das Datum, an dem die Anfrage erstellt wurde.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">date d'envoi</span>", "name": "date_submitted", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var person243 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Personne</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.AllClients.detail_action)}, "emptyText": "Choisir Client...", "listeners": { "render": Lino.quicktip_renderer("Person","Die Person, die die Anfrage macht.") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/person", "method": "GET" }) }), "name": "person" });
    var content244 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Contenu</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Contenu de cours...", "listeners": { "render": Lino.quicktip_renderer("Kursinhalt","Der gew\u00fcnschte Kursinhalt (ein Objekt vom Typ :class:`CourseConent`.)") }, "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/content", "method": "GET" }) }), "name": "content" });
    var offer245 = new Lino.TwinCombo({ "fieldLabel": "Offre de cours", "name": "offer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail_action)}, "emptyText": "Choisir Offre de cours...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/offer", "method": "GET" }) }) });
    var urgent246 = new Ext.form.Checkbox({ "boxLabel": "cause professionnelle", "listeners": { "render": Lino.quicktip_renderer("professionelle Eingliederung","Ankreuzen, wenn der Kurs f\u00fcr die Arbeitssuche ben\u00f6tigt wird.") }, "hideLabel": true, "checked": false, "name": "urgent", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel247 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_submitted242, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person243, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content244, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer245, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": urgent246, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 261, "border": false, "labelAlign": "top" });
    var course253 = new Lino.TwinCombo({ "fieldLabel": "Cours trouv\u00e9", "name": "course", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail_action)}, "emptyText": "Choisir Cours...", "selectOnFocus": true, "hiddenName": "courseHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/course", "method": "GET" }) }) });
    var state254 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Etat", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Candidat" ], [ "20", "Enregistr\u00e9" ], [ "30", "R\u00e9ussi" ], [ "40", "Bien r\u00e9ussi" ], [ "50", "Echou\u00e9" ], [ "60", "Abandonn\u00e9" ] ], "name": "state" });
    var date_ended255 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Abandon le", "anchor": "-20", "name": "date_ended" });
    var id256 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var main_2_panel257 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course253, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state254, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended255, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id256, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var remark262 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var UploadsByController_htmlbox263 = new Lino.HtmlBoxPanel({ "flex": 33, "ls_bbar_actions": [ { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert_action, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.default_action) ] });
    var main_3_panel264 = new Ext.Panel({ "flex": 71, "layout": "hbox", "items": [ { "items": remark262, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, UploadsByController_htmlbox263 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var main_panel266 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel247, main_2_panel257, main_3_panel264 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel266;
    this.before_row_edit = function(record) {
      offer245.setContextValue('content',record ? record.data['contentHidden'] : undefined);
      UploadsByController_htmlbox263.refresh();
    }
    this.onRender = function(ct, position) {
      content244.on('change',Lino.chooser_handler(offer245,'content'));
      Lino.courses.PendingCourseRequests.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.PendingCourseRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    offer245.on("change",function(){this.save()},this);
  }
});


Lino.jobs.JobsOverview.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var body_disp1710 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contenu", "name": "body", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_panel1711 = new Ext.Panel({ "hideCheckBoxLabels": true, "labelWidth": 63, "items": [ { "items": body_disp1710, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "autoScroll": true, "layout": "fit", "frame": false, "border": false, "labelAlign": "top" });
    this.items = main_panel1711;
    this.before_row_edit = function(record) {
    }
    Lino.jobs.JobsOverview.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MyOutbox.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var subject353 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Objet", "anchor": "-20", "name": "subject" });
    var project354 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.AllClients.detail_action)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date355 = new Lino.DateField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Datum","\n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "anchor": "-20", "name": "date" });
    var main_1_panel356 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject353, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project354, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date355, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var user360 = new Lino.TwinCombo({ "fieldLabel": "Sender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent361 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "sent", "anchor": "-20", "value": "<br>", "name": "sent" });
    var id362 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var owner_disp363 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var main_2_panel364 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user360, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent361, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id362, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp363, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var RecipientsByMail_grid375 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.default_action) ], "master_panel": this });
    var AttachmentsByMail_htmlbox376 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Pi\u00e8ces jointes", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.default_action) ] });
    var UploadsByController_htmlbox377 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert_action, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.default_action) ] });
    var main_3_panel378 = new Ext.Panel({ "flex": 26, "layout": "hbox", "items": [ RecipientsByMail_grid375, AttachmentsByMail_htmlbox376, UploadsByController_htmlbox377 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var body379 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 52, "containing_panel": this, "name": "body", "title": "Contenu" });
    var main_panel380 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel356, main_2_panel364, main_3_panel378, body379 ], "autoScroll": true, "labelWidth": 0, "border": false, "labelAlign": "top" });
    this.items = main_panel380;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid375.on_master_changed();
      AttachmentsByMail_htmlbox376.refresh();
      UploadsByController_htmlbox377.refresh();
      body379.refresh();
    }
    Lino.outbox.MyOutbox.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelEvents.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var summary637 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Sommaire", "anchor": "-20", "name": "summary" });
    var start_date638 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var start_time639 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de d\u00e9but", "anchor": "-20", "name": "start_time" });
    var start_panel640 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date638, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time639, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date643 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de fin", "anchor": "-20", "name": "end_date" });
    var end_time644 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Heure de fin", "anchor": "-20", "name": "end_time" });
    var end_panel645 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date643, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time644, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel648 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ start_panel640, end_panel645 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var calendar649 = new Lino.TwinCombo({ "fieldLabel": "Calendrier", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail_action)}, "emptyText": "Choisir Calendrier...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var project650 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.AllClients.detail_action)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel651 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar649, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project650, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel654 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary637, "anchor": "-20", "labelAlign": "top" }, main_2_panel648, main_3_panel651 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    this.items = main_panel654;
    this.before_row_edit = function(record) {
    }
    Lino.cal.PanelEvents.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Offers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 56,
  initComponent : function() {
    var containing_panel = this;
    var name1713 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Nom", "anchor": "-20", "name": "name" });
    var provider1714 = new Lino.TwinCombo({ "fieldLabel": "Employant", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail_action)}, "emptyText": "Choisir Employant...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/provider", "method": "GET" }) }) });
    var sector1715 = new Lino.TwinCombo({ "fieldLabel": "Secteur d'activit\u00e9", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail_action)}, "emptyText": "Choisir Secteur d'activit\u00e9...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/sector", "method": "GET" }) }) });
    var function1716 = new Lino.TwinCombo({ "fieldLabel": "Fonction", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail_action)}, "emptyText": "Choisir Fonction...", "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/function", "method": "GET" }) }) });
    var main_1_panel1717 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1713, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider1714, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector1715, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function1716, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var selection_from1722 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9but de s\u00e9lection", "anchor": "-20", "name": "selection_from" });
    var selection_until1723 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Fin de s\u00e9lection", "anchor": "-20", "name": "selection_until" });
    var start_date1724 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date de d\u00e9but", "anchor": "-20", "name": "start_date" });
    var main_2_panel1725 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_from1722, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_until1723, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1724, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var remark1729 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var ExperiencesByOffer_grid1741 = new Lino.jobs.ExperiencesByOffer.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByOffer.default_action) ], "master_panel": this });
    var CandidaturesByOffer_grid1750 = new Lino.jobs.CandidaturesByOffer.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByOffer.default_action) ], "master_panel": this });
    var main_4_panel1751 = new Ext.Panel({ "flex": 41, "layout": "hbox", "items": [ ExperiencesByOffer_grid1741, CandidaturesByOffer_grid1750 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel1752 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel1717, main_2_panel1725, { "items": remark1729, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, main_4_panel1751 ], "autoScroll": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    this.items = main_panel1752;
    this.before_row_edit = function(record) {
      function1716.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      ExperiencesByOffer_grid1741.on_master_changed();
      CandidaturesByOffer_grid1750.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector1715.on('change',Lino.chooser_handler(function1716,'sector'));
      Lino.jobs.Offers.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Offers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var id1754 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name1755 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1756 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_1_panel1757 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1754, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1755, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1756, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "region": "north", "labelAlign": "top" });
    var description1761 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Description", "name": "description" });
    var text1762 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Texte mod\u00e8le", "name": "text" });
    var main_panel1763 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "labelWidth": 0, "items": [ main_1_panel1757, description1761, text1762 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1763;
    this.before_row_edit = function(record) {
      description1761.refresh();
      text1762.refresh();
    }
    Lino.lino.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var start_date414 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d\u00e9but", "anchor": "-20", "name": "start_date" });
    var due_date415 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date d'\u00e9ch\u00e9ance", "anchor": "-20", "name": "due_date" });
    var id416 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var state417 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Etat", "name": "state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "\u00e0 faire" ], [ "20", "D\u00e9marr\u00e9" ], [ "30", "accomplie" ], [ "40", "Dormant" ], [ "50", "Annul\u00e9" ] ], "hiddenName": "stateHidden" });
    var workflow_buttons_disp418 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflows", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel419 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date414, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date415, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id416, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state417, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp418, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var summary425 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Sommaire", "anchor": "-20", "name": "summary" });
    var user426 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project427 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.AllClients.detail_action)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel428 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user426, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project427, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var calendar431 = new Lino.TwinCombo({ "fieldLabel": "Calendrier", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail_action)}, "emptyText": "Choisir Calendrier...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp432 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var created433 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified434 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var main_4_panel435 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar431, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp432, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created433, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified434, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var description440 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 38, "containing_panel": this, "name": "description", "title": "Description" });
    var main_panel441 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel419, { "items": summary425, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel428, main_4_panel435, description440 ], "autoScroll": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    this.items = main_panel441;
    this.before_row_edit = function(record) {
      description440.refresh();
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 65,
  initComponent : function() {
    var containing_panel = this;
    var id1764 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var person1765 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var user1766 = new Lino.TwinCombo({ "fieldLabel": "Author", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/user", "method": "GET" }) }), "name": "user" });
    var environment1767 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent1768 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ex\u00e9cut\u00e9</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status1769 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "Etat", "name": "status", "anchor": "-20", "store": [ [ "10", "Ex\u00e9cut\u00e9" ], [ "20", "echec" ], [ "25", "Valid\u00e9" ], [ "30", "OK" ], [ "40", "Avertissements" ], [ "50", "Erreurs" ] ], "hiddenName": "statusHidden" });
    var ticket1770 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel1771 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Information requ\u00eate", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1764, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1765, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1766, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment1767, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent1768, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status1769, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket1770, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": true, "labelAlign": "top" });
    var action1779 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Action", "allowBlank": false, "hiddenName": "actionHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Int\u00e9grer" ], [ "2", "Annuler int\u00e9gration" ], [ "3", "Listing" ] ], "name": "action" });
    var start_date1780 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode du", "anchor": "-20", "name": "start_date" });
    var end_date1781 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode au", "anchor": "-20", "name": "end_date" });
    var p1_1_panel1782 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action1779, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1780, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1781, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose1786 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Code fonction</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Code fonction...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register1787 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Query Register", "allowBlank": false, "hiddenName": "query_registerHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Primaire" ], [ "2", "Secondaire" ], [ "3", "Tous" ] ], "name": "query_register" });
    var p1_2_panel1788 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose1786, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register1787, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel1791 = new Ext.form.FieldSet({ "flex": 35, "autoHeight": true, "layout": "form", "title": "Action demand\u00e9e", "items": [ p1_1_panel1782, p1_2_panel1788 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var national_id1792 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NISS</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no1793 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte SIS</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no1794 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte eID</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel1795 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1792, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no1793, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no1794, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name1799 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name1800 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var birth_date1801 = new Lino.IncompleteDateField({ "selectOnFocus": true, "fieldLabel": "Date de naissance", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel1802 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1799, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1800, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1801, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel1806 = new Ext.form.FieldSet({ "flex": 64, "autoHeight": true, "layout": "form", "title": "Preuve d'identification", "items": [ proof_1_panel1795, proof_2_panel1802 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var parameters_panel1807 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Param\u00e8tres", "bodyBorder": true, "frame": false, "layoutConfig": { "align": "stretchmax" }, "items": [ p1_panel1791, proof_panel1806 ], "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var result_htmlbox1808 = new Lino.HtmlBoxPanel({ "flex": 62, "layout": "fit", "name": "result", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "R\u015bultat", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var request_panel1809 = new Ext.Panel({ "labelWidth": 81, "title": "Requ\u00eate", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ info_1_panel1771, parameters_panel1807, result_htmlbox1808 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var response_xml1810 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">R\u00e9ponse</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages1811 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages info", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages1812 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages debug", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel1813 = new Lino.VBorderPanel({ "labelWidth": 144, "title": "Technique", "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml1810, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages1811, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages1812, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel1817 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ request_panel1809, technical_panel1813 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel1817;
    this.before_row_edit = function(record) {
      purpose1786.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      result_htmlbox1808.refresh();
    }
    Lino.cbss.ManageAccessRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person1765.on("change",function(){this.save()},this);
  }
});


Lino.notes.Notes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 86,
  initComponent : function() {
    var containing_panel = this;
    var date316 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var event_type317 = new Lino.TwinCombo({ "fieldLabel": "Event Type (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail_action)}, "emptyText": "Choisir Event Type...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type318 = new Lino.TwinCombo({ "fieldLabel": "Note Type (Content)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail_action)}, "emptyText": "Choisir Type de note...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel319 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date316, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type317, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type318, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 171, "border": false, "labelAlign": "top" });
    var subject323 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Objet", "anchor": "-20", "name": "subject" });
    var project324 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.AllClients.detail_action)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company325 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail_action)}, "emptyText": "Choisir Organisation...", "listeners": { "render": Lino.quicktip_renderer("Organisation","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var left_3_panel326 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project324, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company325, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var id329 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var user330 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language331 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var build_time332 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "build time", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var left_4_panel333 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id329, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user330, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language331, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time332, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var body338 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Contenu" });
    var left_panel339 = new Ext.Panel({ "flex": 66, "labelWidth": 54, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ left_1_panel319, { "items": subject323, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, left_3_panel326, left_4_panel333, body338 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var UploadsByController_htmlbox341 = new Lino.HtmlBoxPanel({ "flex": 25, "ls_bbar_actions": [ { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert_action, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.default_action) ] });
    var outbox_MailsByController_grid381 = new Lino.outbox.MailsByController.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.default_action) ], "master_panel": this });
    var postings_PostingsByController_grid392 = new Lino.postings.PostingsByController.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.default_action) ], "master_panel": this });
    var cal_TasksByController_grid451 = new Lino.cal.TasksByController.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.default_action) ], "master_panel": this });
    var right_panel452 = new Ext.Panel({ "flex": 33, "labelWidth": 72, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ UploadsByController_htmlbox341, outbox_MailsByController_grid381, postings_PostingsByController_grid392, cal_TasksByController_grid451 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var main_1_panel453 = new Ext.Panel({ "layout": "hbox", "items": [ left_panel339, right_panel452 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel454 = new Ext.Panel({ "hideCheckBoxLabels": true, "layout": "fit", "autoScroll": true, "items": [ main_1_panel453 ], "frame": false, "border": false, "labelAlign": "top" });
    this.items = main_panel454;
    this.before_row_edit = function(record) {
      body338.refresh();
      UploadsByController_htmlbox341.refresh();
      outbox_MailsByController_grid381.on_master_changed();
      postings_PostingsByController_grid392.on_master_changed();
      cal_TasksByController_grid451.on_master_changed();
    }
    Lino.notes.Notes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 65,
  initComponent : function() {
    var containing_panel = this;
    var person1818 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var action1819 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Action", "allowBlank": false, "hiddenName": "actionHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Int\u00e9grer" ], [ "2", "Annuler int\u00e9gration" ], [ "3", "Listing" ] ], "name": "action" });
    var start_date1820 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode du", "anchor": "-20", "name": "start_date" });
    var end_date1821 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "P\u00e9riode au", "anchor": "-20", "name": "end_date" });
    var p1_1_panel1822 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action1819, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1820, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1821, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose1826 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Code fonction</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Code fonction...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register1827 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Query Register", "allowBlank": false, "hiddenName": "query_registerHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Primaire" ], [ "2", "Secondaire" ], [ "3", "Tous" ] ], "name": "query_register" });
    var p1_2_panel1828 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose1826, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register1827, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel1831 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Action demand\u00e9e", "items": [ p1_1_panel1822, p1_2_panel1828 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "anchor": "-20", "labelAlign": "top" });
    var national_id1832 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NISS</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no1833 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte SIS</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no1834 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No carte eID</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel1835 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1832, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no1833, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no1834, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name1839 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name1840 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var birth_date1841 = new Lino.IncompleteDateField({ "selectOnFocus": true, "fieldLabel": "Date de naissance", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel1842 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1839, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1840, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1841, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel1846 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Preuve d'identification", "items": [ proof_1_panel1835, proof_2_panel1842 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "anchor": "-20", "labelAlign": "top" });
    var main_panel1847 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1818, "anchor": "-20", "labelAlign": "top" }, p1_panel1831, proof_panel1846 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    this.items = main_panel1847;
    this.before_row_edit = function(record) {
      purpose1826.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    }
    Lino.cbss.ManageAccessRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person1818.on("change",function(){this.save()},this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var file1924 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1925 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1926 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1924, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1925, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1929 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'upload", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'upload...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until1930 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "expire le", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1931 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1929, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1930, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description1934 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description", "anchor": "-20", "name": "description" });
    var main_panel1935 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel1926, main_2_panel1931, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1934, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    this.items = main_panel1935;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 40,
  initComponent : function() {
    var containing_panel = this;
    var name1937 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1938 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1939 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var name_giving1940 = new Ext.form.Checkbox({ "boxLabel": "donneur de nom", "listeners": { "render": Lino.quicktip_renderer("namensgebend","When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ") }, "hideLabel": true, "checked": false, "name": "name_giving", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1941 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1937, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1938, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1939, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_giving1940, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var MembersByRole_grid1952 = new Lino.households.MembersByRole.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByRole.default_action) ], "master_panel": this });
    var main_panel1953 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1941, MembersByRole_grid1952 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1953;
    this.before_row_edit = function(record) {
      MembersByRole_grid1952.on_master_changed();
    }
    Lino.households.Roles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Jobs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var name1864 = new Ext.form.TextField({ "fieldLabel": "Nom", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var provider1865 = new Lino.TwinCombo({ "fieldLabel": "Employant", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail_action)}, "emptyText": "Choisir Employant...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/provider", "method": "GET" }) }) });
    var contract_type1866 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail_action)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "contract_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/contract_type", "method": "GET" }) }) });
    var type1867 = new Lino.TwinCombo({ "fieldLabel": "Type d'emploi", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail_action)}, "emptyText": "Choisir Type d'emploi...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/type", "method": "GET" }) }) });
    var id1868 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var main_1_panel1869 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1864, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider1865, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type1866, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1867, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1868, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var sector1875 = new Lino.TwinCombo({ "fieldLabel": "Secteur d'activit\u00e9", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail_action)}, "emptyText": "Choisir Secteur d'activit\u00e9...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/sector", "method": "GET" }) }) });
    var function1876 = new Lino.TwinCombo({ "fieldLabel": "Fonction", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail_action)}, "emptyText": "Choisir Fonction...", "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/function", "method": "GET" }) }) });
    var capacity1877 = { "fieldLabel": "Capacit\u00e9", "xtype": "numberfield", "value": 1, "name": "capacity", "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var hourly_rate1878 = { "decimalPrecision": 2, "fieldLabel": "co\u00fbr horaire", "xtype": "numberfield", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "name": "hourly_rate" };
    var main_2_panel1879 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector1875, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function1876, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": capacity1877, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate1878, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var remark1884 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var CandidaturesByJob_grid1892 = new Lino.jobs.CandidaturesByJob.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByJob.default_action) ], "master_panel": this });
    var main_3_panel1893 = new Ext.Panel({ "flex": 41, "layout": "hbox", "items": [ { "items": remark1884, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, CandidaturesByJob_grid1892 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var ContractsByJob_grid1920 = new Lino.jobs.ContractsByJob.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByJob.default_action) ], "master_panel": this });
    var main_panel1921 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1869, main_2_panel1879, main_3_panel1893, ContractsByJob_grid1920 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1921;
    this.before_row_edit = function(record) {
      function1876.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      CandidaturesByJob_grid1892.on_master_changed();
      ContractsByJob_grid1920.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector1875.on('change',Lino.chooser_handler(function1876,'sector'));
      Lino.jobs.Jobs.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Jobs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var type1095 = new Lino.TwinCombo({ "fieldLabel": "Type de m\u00e9nage", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail_action)}, "emptyText": "Choisir Type de m\u00e9nage...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name1096 = new Ext.form.TextField({ "fieldLabel": "Nom", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1097 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var id1098 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var intro_box_1_panel1099 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1095, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1096, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1097, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1098, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var country1104 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region1105 = new Lino.TwinCombo({ "fieldLabel": "R\u00e9gion", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel1106 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1104, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1105, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1109 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Endroit", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code1110 = new Ext.form.TextField({ "fieldLabel": "Code postal", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1111 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1109, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1110, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1114 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1115 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1116 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1117 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1118 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1114, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1115, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1116, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1117, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21123 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity1124 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }) });
    var bank_account11125 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account21126 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Compte en banque 2", "anchor": "-20", "name": "bank_account2" });
    var box3_5_panel1127 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1124, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account11125, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account21126, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel1131 = new Ext.Panel({ "flex": 61, "autoHeight": true, "labelWidth": 216, "items": [ box3_1_panel1106, box3_2_panel1111, box3_3_panel1118, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21123, "anchor": "-20", "labelAlign": "top" }, box3_5_panel1127 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var email1133 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url1134 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1135 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm1136 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel1137 = new Ext.Panel({ "flex": 38, "autoHeight": true, "labelWidth": 72, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1133, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1134, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1135, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1136, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var address_box_panel1142 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box3_panel1131, box4_panel1137 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks1143 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var households_MembersByHousehold_grid1150 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.default_action) ], "master_panel": this });
    var bottom_box_panel1151 = new Ext.Panel({ "flex": 45, "layout": "hbox", "items": [ { "items": remarks1143, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid1150 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var general_panel1153 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ intro_box_1_panel1099, address_box_panel1142, bottom_box_panel1151 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel1155 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel1153 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel1155;
    this.before_row_edit = function(record) {
      region1105.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1109.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1109.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid1150.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1104.on('change',Lino.chooser_handler(region1105,'country'));
      country1104.on('change',Lino.chooser_handler(city1109,'country'));
      region1105.on('change',Lino.chooser_handler(city1109,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var containing_panel = this;
    var id1960 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name1961 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1962 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1963 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1964 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1960, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1961, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1962, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1963, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var PropsByGroup_grid1969 = new Lino.properties.PropsByGroup.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.default_action) ], "master_panel": this });
    var main_panel1970 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1964, PropsByGroup_grid1969 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1970;
    this.before_row_edit = function(record) {
      PropsByGroup_grid1969.on_master_changed();
    }
    Lino.properties.PropGroups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 52,
  initComponent : function() {
    var containing_panel = this;
    var id696 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var person697 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.AllClients.detail_action)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/person", "method": "GET" }) }), "name": "person" });
    var user698 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var user_asd699 = new Lino.TwinCombo({ "fieldLabel": "Responsable (SSG)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "user_asdHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user_asd", "method": "GET" }) }) });
    var language700 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var box1_1_panel701 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id696, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person697, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user698, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd699, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language700, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 207, "border": false, "labelAlign": "top" });
    var job707 = new Lino.TwinCombo({ "fieldLabel": "Emploi", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail_action)}, "emptyText": "Choisir Emploi...", "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var type708 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail_action)}, "emptyText": "Choisir Type de contrat de travail...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var company709 = new Lino.TwinCombo({ "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail_action)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }) });
    var contact710 = new Lino.RemoteComboFieldElement({ "fieldLabel": "repr\u00e9sent\u00e9 par", "name": "contact", "pageSize": 20, "emptyText": "Choisir Personne de contact...", "selectOnFocus": true, "hiddenName": "contactHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact", "method": "GET" }) }) });
    var box1_2_panel711 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job707, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type708, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company709, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact710, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var applies_from716 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9but de contrat", "anchor": "-20", "name": "applies_from" });
    var duration717 = new Lino.SimpleRemoteComboFieldElement({ "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/duration", "method": "GET" }) }), "fieldLabel": "dur\u00e9e (jours)", "name": "duration", "selectOnFocus": true, "anchor": "-20", "value": null });
    var applies_until718 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Fin pr\u00e9vue", "anchor": "-20", "name": "applies_until" });
    var exam_policy719 = new Lino.RemoteComboFieldElement({ "fieldLabel": "M\u00e9thode d'examination", "name": "exam_policy", "pageSize": 20, "emptyText": "Choisir M\u00e9thode d'examination...", "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/exam_policy", "method": "GET" }) }) });
    var box1_3_panel720 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from716, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": duration717, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until718, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy719, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" });
    var regime725 = new Lino.TwinCombo({ "fieldLabel": "R\u00e9gime de travail", "name": "regime", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Regimes.detail_action)}, "emptyText": "Choisir R\u00e9gime de travail...", "selectOnFocus": true, "hiddenName": "regimeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/regime", "method": "GET" }) }) });
    var schedule726 = new Lino.TwinCombo({ "fieldLabel": "Horaire", "name": "schedule", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Schedules.detail_action)}, "emptyText": "Choisir Horaire...", "selectOnFocus": true, "hiddenName": "scheduleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/schedule", "method": "GET" }) }) });
    var hourly_rate727 = { "decimalPrecision": 2, "fieldLabel": "co\u00fbr horaire", "xtype": "numberfield", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "name": "hourly_rate" };
    var refund_rate728 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "tarif de remboursement", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/refund_rate", "method": "GET" }) }), "name": "refund_rate" });
    var box1_4_panel729 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": regime725, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": schedule726, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate727, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refund_rate728, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var date_decided734 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9cid\u00e9 le", "anchor": "-20", "name": "date_decided" });
    var date_issued735 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9livr\u00e9 le", "anchor": "-20", "name": "date_issued" });
    var date_ended736 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Abandon le", "anchor": "-20", "name": "date_ended" });
    var ending737 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Cause d'abandon", "name": "ending", "pageSize": 20, "emptyText": "Choisir Rupture/fin de contrat...", "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }) });
    var box1_5_panel738 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided734, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued735, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended736, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending737, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var reference_person743 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "persone de r\u00e9f\u00e9rence", "anchor": "-20", "name": "reference_person" });
    var build_time744 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "build time", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var box1_6_panel745 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reference_person743, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time744, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var responsibilities748 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "responsibilities", "title": "responsabilit\u00e9s" });
    var box1_panel749 = new Ext.Panel({ "flex": 70, "labelWidth": 0, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ box1_1_panel701, box1_2_panel711, box1_3_panel720, box1_4_panel729, box1_5_panel738, box1_6_panel745, responsibilities748 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var cal_EventsByController_grid750 = new Lino.cal.EventsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.default_action) ] });
    var cal_TasksByController_grid751 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.default_action) ] });
    var right_panel752 = new Lino.VBorderPanel({ "flex": 30, "items": [ cal_EventsByController_grid750, cal_TasksByController_grid751 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var main_1_panel753 = new Ext.Panel({ "layout": "hbox", "items": [ box1_panel749, right_panel752 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel754 = new Ext.Panel({ "hideCheckBoxLabels": true, "layout": "fit", "autoScroll": true, "items": [ main_1_panel753 ], "frame": false, "border": false, "labelAlign": "top" });
    this.items = main_panel754;
    this.before_row_edit = function(record) {
      contact710.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      responsibilities748.refresh();
      cal_EventsByController_grid750.on_master_changed();
      cal_TasksByController_grid751.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company709.on('change',Lino.chooser_handler(contact710,'company'));
      Lino.jobs.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    job707.on("change",function(){this.save()},this);
    company709.on("change",function(){this.save()},this);
    contact710.on("change",function(){this.save()},this);
  }
});


Lino.jobs.JobProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 57,
  initComponent : function() {
    var containing_panel = this;
    var prefix1971 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name1972 = new Ext.form.TextField({ "fieldLabel": "Nom", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id1973 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language1974 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var intro_box_1_panel1975 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix1971, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1972, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1973, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1974, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id1980 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "N\u00b0 de TVA", "anchor": "-20", "name": "vat_id" });
    var activity1981 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/activity", "method": "GET" }) }) });
    var type1982 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel1983 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id1980, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1981, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1982, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel1987 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ intro_box_1_panel1975, intro_box_2_panel1983 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var country1988 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/country", "method": "GET" }) }) });
    var region1989 = new Lino.TwinCombo({ "fieldLabel": "R\u00e9gion", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/region", "method": "GET" }) }) });
    var box3_1_panel1990 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1988, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1989, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1993 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Endroit", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/city", "method": "GET" }) }) });
    var zip_code1994 = new Ext.form.TextField({ "fieldLabel": "Code postal", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1995 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1993, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1994, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1998 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1999 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2000 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2001 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel2002 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1998, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1999, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2000, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2001, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22007 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel2008 = new Ext.Panel({ "flex": 61, "autoHeight": true, "labelWidth": 216, "items": [ box3_1_panel1990, box3_2_panel1995, box3_3_panel2002, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22007, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var email2010 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url2011 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2012 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm2013 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel2014 = new Ext.Panel({ "flex": 38, "autoHeight": true, "labelWidth": 72, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2010, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2011, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2012, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2013, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var address_box_panel2019 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box3_panel2008, box4_panel2014 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks2020 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid2021 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.default_action) ], "master_panel": this });
    var bottom_box_panel2022 = new Ext.Panel({ "flex": 45, "layout": "hbox", "items": [ { "items": remarks2020, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid2021 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var general_panel2024 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ intro_box_panel1987, address_box_panel2019, bottom_box_panel2022 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid2025 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "NOtes", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.default_action) ], "master_panel": this });
    var JobsByProvider_grid2037 = new Lino.jobs.JobsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.JobsByProvider.default_action) ] });
    var ContractsByProvider_grid2063 = new Lino.jobs.ContractsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByProvider.default_action) ] });
    var jobs_panel2064 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Emplois", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ JobsByProvider_grid2037, ContractsByProvider_grid2063 ], "border": false, "labelAlign": "top" });
    var main_panel2065 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel2024, pcsw_NotesByCompany_grid2025, jobs_panel2064 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel2065;
    this.before_row_edit = function(record) {
      region1989.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1993.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1993.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid2021.on_master_changed();
      pcsw_NotesByCompany_grid2025.on_master_changed();
      JobsByProvider_grid2037.on_master_changed();
      ContractsByProvider_grid2063.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1988.on('change',Lino.chooser_handler(region1989,'country'));
      country1988.on('change',Lino.chooser_handler(city1993,'country'));
      region1989.on('change',Lino.chooser_handler(city1993,'region'));
      Lino.jobs.JobProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.JobProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var prefix2066 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name2067 = new Ext.form.TextField({ "fieldLabel": "Nom", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2068 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language2069 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var intro_box_1_panel2070 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix2066, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2067, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2068, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2069, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id2075 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "N\u00b0 de TVA", "anchor": "-20", "name": "vat_id" });
    var activity2076 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Activit\u00e9", "name": "activity", "pageSize": 20, "emptyText": "Choisir Activit\u00e9...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/activity", "method": "GET" }) }) });
    var type2077 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type de soci\u00e9t\u00e9", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'organisation...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel2078 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id2075, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2076, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2077, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel2082 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ intro_box_1_panel2070, intro_box_2_panel2078 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var country2083 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/country", "method": "GET" }) }) });
    var region2084 = new Lino.TwinCombo({ "fieldLabel": "R\u00e9gion", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/region", "method": "GET" }) }) });
    var box3_1_panel2085 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2083, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2084, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2088 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Endroit", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/city", "method": "GET" }) }) });
    var zip_code2089 = new Ext.form.TextField({ "fieldLabel": "Code postal", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2090 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2088, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2089, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2093 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2094 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2095 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2096 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel2097 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2093, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2094, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2095, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2096, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22102 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel2103 = new Ext.Panel({ "flex": 61, "autoHeight": true, "labelWidth": 216, "items": [ box3_1_panel2085, box3_2_panel2090, box3_3_panel2097, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22102, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var email2105 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url2106 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2107 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm2108 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel2109 = new Ext.Panel({ "flex": 38, "autoHeight": true, "labelWidth": 72, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2105, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2106, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2107, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2108, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var address_box_panel2114 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box3_panel2103, box4_panel2109 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks2115 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid2116 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.default_action) ], "master_panel": this });
    var bottom_box_panel2117 = new Ext.Panel({ "flex": 45, "layout": "hbox", "items": [ { "items": remarks2115, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid2116 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var general_panel2119 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ intro_box_panel2082, address_box_panel2114, bottom_box_panel2117 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid2120 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "NOtes", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.default_action) ], "master_panel": this });
    var CourseOffersByProvider_grid2170 = new Lino.courses.CourseOffersByProvider.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Offres de cours", "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByProvider.default_action) ], "master_panel": this });
    var main_panel2171 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel2119, pcsw_NotesByCompany_grid2120, CourseOffersByProvider_grid2170 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel2171;
    this.before_row_edit = function(record) {
      region2084.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2088.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2088.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid2116.on_master_changed();
      pcsw_NotesByCompany_grid2120.on_master_changed();
      CourseOffersByProvider_grid2170.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2083.on('change',Lino.chooser_handler(region2084,'country'));
      country2083.on('change',Lino.chooser_handler(city2088,'country'));
      region2084.on('change',Lino.chooser_handler(city2088,'region'));
      Lino.courses.CourseProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 88,
  initComponent : function() {
    var containing_panel = this;
    var id2141 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var start_date2142 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date de d\u00e9but", "anchor": "-20", "name": "start_date" });
    var offer2143 = new Lino.TwinCombo({ "fieldLabel": "Offre de cours", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail_action)}, "emptyText": "Choisir Offre de cours...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "name": "offer" });
    var title2144 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom", "anchor": "-20", "name": "title" });
    var main_1_panel2145 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2141, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2142, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer2143, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2144, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var remark2150 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Remarque", "anchor": "-20", "name": "remark" });
    var courses_ParticipantsByCourse_grid2157 = new Lino.courses.ParticipantsByCourse.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.courses.ParticipantsByCourse.default_action) ], "master_panel": this });
    var courses_CandidatesByCourse_grid2165 = new Lino.courses.CandidatesByCourse.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.courses.CandidatesByCourse.default_action) ], "master_panel": this });
    var main_panel2166 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel2145, { "items": remark2150, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, courses_ParticipantsByCourse_grid2157, courses_CandidatesByCourse_grid2165 ], "autoScroll": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    this.items = main_panel2166;
    this.before_row_edit = function(record) {
      courses_ParticipantsByCourse_grid2157.on_master_changed();
      courses_CandidatesByCourse_grid2165.on_master_changed();
    }
    Lino.courses.Courses.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 14,
  initComponent : function() {
    var containing_panel = this;
    var id2234 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2235 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2236 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2237 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var choicelist2238 = new Lino.ChoicesFieldElement({ "fieldLabel": "Liste de choix", "name": "choicelist", "selectOnFocus": true, "anchor": "-20", "store": [ [ "CityTypes", "Settlement Type" ], [ "DoYouLike", "Certainement pas...beaucoup" ], [ "Gender", "Sexe" ], [ "HowWell", "pas du tout...tr\u00e8s bien" ], [ "UserGroups", "User Group" ], [ "UserLevels", "User Level" ], [ "UserProfiles", "User Profile" ] ], "hiddenName": "choicelistHidden" });
    var default_value2239 = new Lino.RemoteComboFieldElement({ "fieldLabel": "valeur par d\u00e9fault", "name": "default_value", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }), "hiddenName": "default_valueHidden" });
    var main_1_panel2240 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2234, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2235, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2236, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2237, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist2238, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value2239, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "region": "north", "labelAlign": "top" });
    var ChoicesByType_grid2253 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.default_action) ] });
    var PropsByType_grid2260 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.default_action) ] });
    var main_panel2261 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "items": [ main_1_panel2240, ChoicesByType_grid2253, PropsByType_grid2260 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2261;
    this.before_row_edit = function(record) {
      default_value2239.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid2253.on_master_changed();
      PropsByType_grid2260.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist2238.on('change',Lino.chooser_handler(default_value2239,'choicelist'));
      Lino.properties.PropTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 48,
  initComponent : function() {
    var containing_panel = this;
    var id516 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var person517 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.AllClients.detail_action)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/person", "method": "GET" }) }), "name": "person" });
    var user518 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var user_asd519 = new Lino.TwinCombo({ "fieldLabel": "Responsable (SSG)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "user_asdHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user_asd", "method": "GET" }) }) });
    var language520 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var general_1_panel521 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id516, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person517, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user518, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd519, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language520, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 207, "border": false, "labelAlign": "top" });
    var type527 = new Lino.TwinCombo({ "fieldLabel": "Type de contrat", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail_action)}, "emptyText": "Choisir Type de PIIS...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var company528 = new Lino.TwinCombo({ "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail_action)}, "emptyText": "Choisir Organisation...", "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var contact529 = new Lino.RemoteComboFieldElement({ "fieldLabel": "repr\u00e9sent\u00e9 par", "name": "contact", "pageSize": 20, "emptyText": "Choisir Personne de contact...", "selectOnFocus": true, "hiddenName": "contactHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact", "method": "GET" }) }) });
    var general_2_panel530 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type527, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company528, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact529, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var applies_from534 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9but de contrat", "anchor": "-20", "name": "applies_from" });
    var applies_until535 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Fin pr\u00e9vue", "anchor": "-20", "name": "applies_until" });
    var exam_policy536 = new Lino.RemoteComboFieldElement({ "fieldLabel": "M\u00e9thode d'examination", "name": "exam_policy", "pageSize": 20, "emptyText": "Choisir M\u00e9thode d'examination...", "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/exam_policy", "method": "GET" }) }) });
    var general_3_panel537 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from534, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until535, "labelAlign": "top" }, { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy536, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" });
    var date_decided541 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9cid\u00e9 le", "anchor": "-20", "name": "date_decided" });
    var date_issued542 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "D\u00e9livr\u00e9 le", "anchor": "-20", "name": "date_issued" });
    var general_4_panel543 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided541, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued542, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var date_ended546 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Abandon le", "anchor": "-20", "name": "date_ended" });
    var ending547 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Cause d'abandon", "name": "ending", "pageSize": 20, "emptyText": "Choisir Rupture/fin de contrat...", "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var general_5_panel548 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended546, "labelAlign": "top" }, { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending547, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var cal_TasksByController_grid551 = new Lino.cal.TasksByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.default_action) ], "master_panel": this });
    var cal_EventsByController_grid656 = new Lino.cal.EventsByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.default_action) ], "master_panel": this });
    var general_6_panel657 = new Ext.Panel({ "flex": 50, "layout": "hbox", "items": [ cal_TasksByController_grid551, cal_EventsByController_grid656 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var general_panel658 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel521, general_2_panel530, general_3_panel537, general_4_panel543, general_5_panel548, general_6_panel657 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var stages659 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "stages", "title": "stages" });
    var goals660 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "goals", "title": "buts" });
    var isip_1_panel661 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ stages659, goals660 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "region": "north", "labelAlign": "top" });
    var duties_asd662 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_asd", "title": "devoirs SSG" });
    var duties_dsbe663 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_dsbe", "title": "devois ISP" });
    var isip_2_panel664 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_asd662, duties_dsbe663 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "region": "center", "labelAlign": "top" });
    var duties_company665 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_company", "title": "devoirs entreprise" });
    var duties_person666 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_person", "title": "Devoirs personne" });
    var isip_3_panel667 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_company665, duties_person666 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "region": "south", "labelAlign": "top" });
    var isip_panel668 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "PIIS", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ isip_1_panel661, isip_2_panel664, isip_3_panel667 ], "border": false, "labelAlign": "top" });
    var main_panel669 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel658, isip_panel668 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel669;
    this.before_row_edit = function(record) {
      contact529.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      cal_TasksByController_grid551.on_master_changed();
      cal_EventsByController_grid656.on_master_changed();
      stages659.refresh();
      goals660.refresh();
      duties_asd662.refresh();
      duties_dsbe663.refresh();
      duties_company665.refresh();
      duties_person666.refresh();
    }
    this.onRender = function(ct, position) {
      company528.on('change',Lino.chooser_handler(contact529,'company'));
      Lino.isip.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    company528.on("change",function(){this.save()},this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 43,
  initComponent : function() {
    var containing_panel = this;
    var id2262 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2263 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2264 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2265 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2266 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2262, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2263, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2264, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2265, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var GroupsByChart_grid2279 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.default_action) ], "master_panel": this });
    var main_panel2280 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2266, GroupsByChart_grid2279 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2280;
    this.before_row_edit = function(record) {
      GroupsByChart_grid2279.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 31,
  initComponent : function() {
    var containing_panel = this;
    var id2281 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2282 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2283 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2284 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2285 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2281, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2282, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2283, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2284, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var build_method2290 = new Lino.ChoicesFieldElement({ "fieldLabel": "M\u00e9thode de construction", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template2291 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Mod\u00e8le", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }), "name": "template" });
    var email_template2292 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    var attach_to_email2293 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2294 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method2290, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template2291, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template2292, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email2293, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 198, "border": false, "labelAlign": "top" });
    var cal_GuestsByRole_grid2308 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.default_action) ], "master_panel": this });
    var main_panel2309 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2285, main_2_panel2294, cal_GuestsByRole_grid2308 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2309;
    this.before_row_edit = function(record) {
      template2291.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_GuestsByRole_grid2308.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method2290.on('change',Lino.chooser_handler(template2291,'build_method'));
      Lino.cal.GuestRoles.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var id2310 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2311 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label2312 = new Ext.form.TextField({ "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model2313 = new Ext.form.TextField({ "fieldLabel": "nom de la classe python du mod\u00e8le", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp2314 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel2315 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2310, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2311, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label2312, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model2313, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp2314, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var lino_HelpTextsByModel_grid2327 = new Lino.lino.HelpTextsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.lino.HelpTextsByModel.default_action) ], "master_panel": this });
    var main_panel2328 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2315, lino_HelpTextsByModel_grid2327 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2328;
    this.before_row_edit = function(record) {
      lino_HelpTextsByModel_grid2327.on_master_changed();
    }
    Lino.lino.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Places.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var id2329 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2330 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2331 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2332 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2333 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2329, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2330, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2331, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2332, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var main_panel2363 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2333 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2363;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Places.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseOffers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 90,
  initComponent : function() {
    var containing_panel = this;
    var id2126 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var title2127 = new Ext.form.TextField({ "fieldLabel": "Nom", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var content2128 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Contenu de cours", "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Contenu de cours...", "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "name": "content" });
    var provider2129 = new Lino.TwinCombo({ "fieldLabel": "Organisateur de cours", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail_action)}, "emptyText": "Choisir Organisateur de cours...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "name": "provider" });
    var main_1_panel2130 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2126, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2127, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content2128, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider2129, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "region": "north", "labelAlign": "top" });
    var description2135 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Description", "name": "description" });
    var CoursesByOffer_grid2168 = new Lino.courses.CoursesByOffer.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByOffer.default_action) ] });
    var main_panel2169 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "labelWidth": 0, "items": [ main_1_panel2130, description2135, CoursesByOffer_grid2168 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2169;
    this.before_row_edit = function(record) {
      description2135.refresh();
      CoursesByOffer_grid2168.on_master_changed();
    }
    Lino.courses.CourseOffers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp2364 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp2365 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp2366 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows_disp2367 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Rows", "name": "rows", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel2368 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp2364, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp2365, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp2366, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows_disp2367, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var lino_FieldsByModel_grid2377 = new Lino.lino.FieldsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.lino.FieldsByModel.default_action) ], "master_panel": this });
    var main_panel2378 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2368, lino_FieldsByModel_grid2377 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2378;
    this.before_row_edit = function(record) {
      lino_FieldsByModel_grid2377.on_master_changed();
    }
    Lino.lino.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 86,
  initComponent : function() {
    var containing_panel = this;
    var event_type455 = new Lino.TwinCombo({ "fieldLabel": "Event Type (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail_action)}, "emptyText": "Choisir Event Type...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type456 = new Lino.TwinCombo({ "fieldLabel": "Note Type (Content)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail_action)}, "emptyText": "Choisir Type de note...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel457 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type455, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type456, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject460 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Objet", "anchor": "-20", "name": "subject" });
    var project461 = new Lino.TwinCombo({ "fieldLabel": "Client", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.AllClients.detail_action)}, "emptyText": "Choisir Client...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company462 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail_action)}, "emptyText": "Choisir Organisation...", "listeners": { "render": Lino.quicktip_renderer("Organisation","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel463 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project461, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company462, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel466 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel457, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject460, "anchor": "-20", "labelAlign": "top" }, main_3_panel463 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 54, "border": false, "labelAlign": "top" });
    this.items = main_panel466;
    this.before_row_edit = function(record) {
    }
    Lino.notes.Notes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var id2379 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var person2380 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var user2381 = new Lino.TwinCombo({ "fieldLabel": "Author", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2382 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2383 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ex\u00e9cut\u00e9</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status2384 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "Etat", "name": "status", "anchor": "-20", "store": [ [ "10", "Ex\u00e9cut\u00e9" ], [ "20", "echec" ], [ "25", "Valid\u00e9" ], [ "30", "OK" ], [ "40", "Avertissements" ], [ "50", "Erreurs" ] ], "hiddenName": "statusHidden" });
    var ticket2385 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel2386 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Information requ\u00eate", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2379, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2380, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2381, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2382, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2383, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2384, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2385, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": true, "labelAlign": "top" });
    var national_id2394 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var p1_panel2396 = new Ext.form.FieldSet({ "flex": 25, "labelWidth": 90, "title": "avec NISS", "layoutConfig": { "align": "stretch" }, "frame": false, "bodyBorder": true, "items": [ { "items": national_id2394, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "flex": 50, "html": "<br/>", "xtype": "label" } ], "hideCheckBoxLabels": true, "layout": "vbox", "border": true, "labelAlign": "top" });
    var first_name2398 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var middle_name2399 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Middle name</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name2400 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var p2_1_panel2401 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2398, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name2399, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2400, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date2405 = new Lino.IncompleteDateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date de naissance", "anchor": "-20", "name": "birth_date" });
    var tolerance2406 = { "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Tol\u00e9rance</span>", "xtype": "numberfield", "value": 0, "name": "tolerance", "listeners": { "render": Lino.quicktip_renderer("Toleranz","\n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var gender2407 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ], "hiddenName": "genderHidden" });
    var p2_2_panel2408 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2405, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance2406, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2407, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel2412 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Recherche phon\u00e9tique", "items": [ p2_1_panel2401, p2_2_panel2408 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var parameters_panel2413 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Param\u00e8tres", "bodyBorder": true, "frame": false, "layoutConfig": { "align": "stretchmax" }, "items": [ p1_panel2396, p2_panel2412 ], "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var IdentifyPersonResult_grid2423 = new Lino.cbss.IdentifyPersonResult.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cbss.IdentifyPersonResult.default_action) ], "master_panel": this });
    var request_panel2424 = new Ext.Panel({ "layout": "vbox", "title": "Requ\u00eate", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ info_1_panel2386, parameters_panel2413, IdentifyPersonResult_grid2423 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var response_xml2425 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">R\u00e9ponse</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages2426 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages info", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages2427 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages debug", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel2428 = new Lino.VBorderPanel({ "labelWidth": 144, "title": "Technique", "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml2425, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages2426, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages2427, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel2432 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ request_panel2424, technical_panel2428 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel2432;
    this.before_row_edit = function(record) {
      IdentifyPersonResult_grid2423.on_master_changed();
    }
    Lino.cbss.IdentifyPersonRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2380.on("change",function(){this.save()},this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 68,
  initComponent : function() {
    var containing_panel = this;
    var id2433 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var person2434 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user2435 = new Lino.TwinCombo({ "fieldLabel": "Author", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2436 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2437 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ex\u00e9cut\u00e9</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status2438 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "Etat", "name": "status", "anchor": "-20", "store": [ [ "10", "Ex\u00e9cut\u00e9" ], [ "20", "echec" ], [ "25", "Valid\u00e9" ], [ "30", "OK" ], [ "40", "Avertissements" ], [ "50", "Erreurs" ] ], "hiddenName": "statusHidden" });
    var ticket2439 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel2440 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Information requ\u00eate", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2433, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2434, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2435, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2436, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2437, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2438, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2439, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": true, "labelAlign": "top" });
    var national_id2448 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var language2449 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Langue", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "nl", "N\u00e9erlandais" ], [ "fr", "Fran\u00e7ais" ], [ "de", "Allemand" ] ], "hiddenName": "languageHidden" });
    var history2450 = new Ext.form.Checkbox({ "boxLabel": "Historique", "listeners": { "render": Lino.quicktip_renderer("Historie","Whatever this means.") }, "hideLabel": true, "checked": false, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel2451 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Param\u00e8tres", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2448, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2449, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history2450, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": true, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid2460 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.default_action) ], "master_panel": this });
    var request_panel2461 = new Ext.Panel({ "layout": "vbox", "title": "Requ\u00eate", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ info_1_panel2440, parameters_panel2451, cbss_RetrieveTIGroupsResult_grid2460 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var response_xml2462 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">R\u00e9ponse</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages2463 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages info", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages2464 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Messages debug", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel2465 = new Lino.VBorderPanel({ "labelWidth": 144, "title": "Technique", "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml2462, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages2463, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages2464, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel2469 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ request_panel2461, technical_panel2465 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel2469;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid2460.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name2470 = new Ext.form.TextField({ "fieldLabel": "Nom", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country2471 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/country", "method": "GET" }) }) });
    var region2472 = new Lino.TwinCombo({ "fieldLabel": "R\u00e9gion", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/region", "method": "GET" }) }) });
    var city2473 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Endroit", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/city", "method": "GET" }) }) });
    var zip_code2474 = new Ext.form.TextField({ "fieldLabel": "Code postal", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel2475 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2471, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2472, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2473, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2474, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr12480 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne avant le nom de rue</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix2481 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2482 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2483 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2484 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel2485 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2481, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2482, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2483, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2484, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22490 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel2491 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "labelWidth": 216, "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2470, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel2475, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr12480, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel2485, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22490, "anchor": "-20", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id2495 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language2496 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var info_box_panel2497 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2495, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2496, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email2500 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url2501 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2502 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm2503 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax2504 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel2505 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2503, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax2504, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel2508 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "labelWidth": 72, "title": "Contact", "items": [ info_box_panel2497, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2500, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2501, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2502, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel2505 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var main_1_panel2512 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ address_box_panel2491, contact_box_panel2508 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks2513 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_person2514 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est une Personne (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail_action)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_person" });
    var is_company2515 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est une Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail_action)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_company" });
    var is_household2516 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est un m\u00e9nage (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail_action)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_household" });
    var created2517 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified2518 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var bottom_box_2_panel2519 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person2514, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company2515, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household2516, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2517, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2518, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var bottom_box_panel2525 = new Ext.Panel({ "flex": 54, "labelWidth": 108, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ { "items": remarks2513, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel2519 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var main_panel2527 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2512, bottom_box_panel2525 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2527;
    this.before_row_edit = function(record) {
      region2472.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2473.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2473.setContextValue('region',record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country2471.on('change',Lino.chooser_handler(region2472,'country'));
      country2471.on('change',Lino.chooser_handler(city2473,'country'));
      region2472.on('change',Lino.chooser_handler(city2473,'region'));
      Lino.pcsw.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name1456 = new Ext.form.TextField({ "fieldLabel": "Nom", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country1457 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region1458 = new Lino.TwinCombo({ "fieldLabel": "R\u00e9gion", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city1459 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Endroit", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code1460 = new Ext.form.TextField({ "fieldLabel": "Code postal", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel1461 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1457, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1458, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1459, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1460, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr11466 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne avant le nom de rue</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix1467 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1468 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1469 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1470 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel1471 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1467, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1468, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1469, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1470, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21476 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel1477 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "labelWidth": 216, "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1456, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel1461, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr11466, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel1471, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21476, "anchor": "-20", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id1481 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language1482 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var info_box_panel1483 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1481, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1482, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1486 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url1487 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1488 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm1489 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax1490 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel1491 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1489, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1490, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel1494 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "labelWidth": 72, "title": "Contact", "items": [ info_box_panel1483, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1486, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1487, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1488, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel1491 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var general_1_panel1498 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ address_box_panel1477, contact_box_panel1494 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks1499 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_person1500 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est une Personne (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail_action)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_person" });
    var is_company1501 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "est une Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail_action)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_company" });
    var bottom_box_2_panel1502 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person1500, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company1501, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var bottom_box_panel1505 = new Ext.Panel({ "flex": 54, "labelWidth": 108, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ { "items": remarks1499, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel1502 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var general_panel1507 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel1498, bottom_box_panel1505 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel1509 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel1507 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel1509;
    this.before_row_edit = function(record) {
      region1458.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1459.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1459.setContextValue('region',record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country1457.on('change',Lino.chooser_handler(region1458,'country'));
      country1457.on('change',Lino.chooser_handler(city1459,'country'));
      region1458.on('change',Lino.chooser_handler(city1459,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.PersonSearches.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 79,
  initComponent : function() {
    var containing_panel = this;
    var id2572 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var title2573 = new Ext.form.TextField({ "fieldLabel": "Intitul\u00e9 de la recherche", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel2574 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2572, "labelAlign": "top" }, { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2573, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var only_my_persons2577 = new Ext.form.Checkbox({ "boxLabel": "Only my clients", "hideLabel": true, "checked": false, "name": "only_my_persons", "selectOnFocus": true, "anchor": "-20" });
    var coached_by2578 = new Lino.TwinCombo({ "fieldLabel": "AI", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/PersonSearches/coached_by", "method": "GET" }) }) });
    var period_from2579 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "P\u00e9riode du", "anchor": "-20", "name": "period_from" });
    var period_until2580 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "jusque", "anchor": "-20", "name": "period_until" });
    var aged_from2581 = { "fieldLabel": "Age: de", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "aged_from" };
    var aged_to2582 = { "fieldLabel": "Age: jusque", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "aged_to" };
    var gender2583 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ], "hiddenName": "genderHidden" });
    var main_2_panel2584 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_my_persons2577, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2578, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": period_from2579, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": period_until2580, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2581, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2582, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2583, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var pcsw_LanguageKnowledgesBySearch_grid2597 = new Lino.pcsw.LanguageKnowledgesBySearch.GridPanel({ "flex": 30, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.LanguageKnowledgesBySearch.default_action) ], "master_panel": this });
    var pcsw_WantedPropsBySearch_grid2603 = new Lino.pcsw.WantedPropsBySearch.GridPanel({ "flex": 34, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.WantedPropsBySearch.default_action) ], "master_panel": this });
    var pcsw_UnwantedPropsBySearch_grid2609 = new Lino.pcsw.UnwantedPropsBySearch.GridPanel({ "flex": 34, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.UnwantedPropsBySearch.default_action) ], "master_panel": this });
    var main_3_panel2610 = new Ext.Panel({ "flex": 41, "layout": "hbox", "items": [ pcsw_LanguageKnowledgesBySearch_grid2597, pcsw_WantedPropsBySearch_grid2603, pcsw_UnwantedPropsBySearch_grid2609 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var pcsw_ClientsBySearch_grid2624 = new Lino.pcsw.ClientsBySearch.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ClientsBySearch.default_action) ], "master_panel": this });
    var main_panel2625 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2574, main_2_panel2584, main_3_panel2610, pcsw_ClientsBySearch_grid2624 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2625;
    this.before_row_edit = function(record) {
      pcsw_LanguageKnowledgesBySearch_grid2597.on_master_changed();
      pcsw_WantedPropsBySearch_grid2603.on_master_changed();
      pcsw_UnwantedPropsBySearch_grid2609.on_master_changed();
      pcsw_ClientsBySearch_grid2624.on_master_changed();
    }
    Lino.pcsw.PersonSearches.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 87,
  initComponent : function() {
    var containing_panel = this;
    var id2626 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2627 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2628 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2629 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2630 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2626, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2627, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2628, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2629, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var build_method2635 = new Lino.ChoicesFieldElement({ "fieldLabel": "M\u00e9thode de construction", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template2636 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Mod\u00e8le", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }), "name": "template" });
    var email_template2637 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var attach_to_email2638 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2639 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method2635, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template2636, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template2637, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email2638, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 198, "border": false, "labelAlign": "top" });
    var remark2644 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByType_grid2656 = new Lino.notes.NotesByType.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByType.default_action) ], "master_panel": this });
    var main_panel2657 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel2630, main_2_panel2639, { "items": remark2644, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, notes_NotesByType_grid2656 ], "autoScroll": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    this.items = main_panel2657;
    this.before_row_edit = function(record) {
      template2636.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      notes_NotesByType_grid2656.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method2635.on('change',Lino.chooser_handler(template2636,'build_method'));
      Lino.notes.NoteTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.NoteTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var last_name2659 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name2660 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender2661 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ], "hiddenName": "genderHidden" });
    var title2662 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Allocution", "anchor": "-20", "name": "title" });
    var name_box_panel2663 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2659, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2660, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2661, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2662, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country2668 = new Lino.TwinCombo({ "fieldLabel": "Pays", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Choisir Pays...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region2669 = new Lino.TwinCombo({ "fieldLabel": "R\u00e9gion", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city2670 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Endroit", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Choisir Endroit...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code2671 = new Ext.form.TextField({ "fieldLabel": "Code postal", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel2672 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2668, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2669, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2670, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2671, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr12677 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne avant le nom de rue</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix2678 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e9fixe rue</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2679 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Rue</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2680 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">N\u00b0</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2681 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bo\u00eete</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel2682 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2678, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2679, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2680, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2681, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22687 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Ligne apr\u00e8s le nom de rue</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel2688 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "labelWidth": 216, "title": "Adresse", "items": [ name_box_panel2663, address_box_2_panel2672, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr12677, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel2682, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22687, "anchor": "-20", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id2691 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language2692 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var info_box_panel2693 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2691, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2692, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email2696 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var url2697 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2698 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "T\u00e9l\u00e9phone", "anchor": "-20", "name": "phone" });
    var gsm2699 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax2700 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel2701 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2699, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax2700, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel2704 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "labelWidth": 72, "title": "Contact", "items": [ info_box_panel2693, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2696, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2697, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2698, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel2701 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var main_1_panel2708 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ address_box_panel2688, contact_box_panel2704 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks2709 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByPerson_grid2710 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.default_action) ], "master_panel": this });
    var bottom_box_1_panel2711 = new Ext.Panel({ "flex": 83, "layout": "hbox", "items": [ { "items": remarks2709, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByPerson_grid2710 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var is_client2713 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "is Client (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.AllClients.detail_action)\">montrer</a>)", "hideLabel": true, "anchor": "-20", "name": "is_client" });
    var created2714 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified2715 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var bottom_box_2_panel2716 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client2713, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2714, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2715, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var bottom_box_panel2720 = new Ext.Panel({ "flex": 54, "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "items": [ bottom_box_1_panel2711, bottom_box_2_panel2716 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel2721 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2708, bottom_box_panel2720 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2721;
    this.before_row_edit = function(record) {
      region2669.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2670.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2670.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid2710.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2668.on('change',Lino.chooser_handler(region2669,'country'));
      country2668.on('change',Lino.chooser_handler(city2670,'country'));
      region2669.on('change',Lino.chooser_handler(city2670,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name1156 = new Ext.form.TextField({ "fieldLabel": "Nom", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1157 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var email1158 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-mail", "anchor": "-20", "name": "email" });
    var main_2_panel1159 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1157, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1158, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1162 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1156, "anchor": "-20", "labelAlign": "top" }, main_2_panel1159 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 45, "border": false, "labelAlign": "top" });
    this.items = main_panel1162;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var person2722 = new Lino.TwinCombo({ "fieldLabel": "Client", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Choisir Personne...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id2723 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NISS", "anchor": "-20", "name": "national_id" });
    var main_1_panel2724 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2722, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2723, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name2727 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var middle_name2728 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Middle name</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name2729 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var p2_1_panel2730 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2727, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name2728, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2729, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date2734 = new Lino.IncompleteDateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date de naissance", "anchor": "-20", "name": "birth_date" });
    var tolerance2735 = { "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Tol\u00e9rance</span>", "xtype": "numberfield", "value": 0, "name": "tolerance", "listeners": { "render": Lino.quicktip_renderer("Toleranz","\n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var gender2736 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ], "hiddenName": "genderHidden" });
    var p2_2_panel2737 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2734, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance2735, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2736, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel2741 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Recherche phon\u00e9tique", "items": [ p2_1_panel2730, p2_2_panel2737 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "anchor": "-20", "labelAlign": "top" });
    var main_panel2742 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel2724, p2_panel2741 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2742;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.IdentifyPersonRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2722.on("change",function(){this.save()},this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var file2743 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2744 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Choisir Utilisateur...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel2745 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2743, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2744, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 54, "border": false, "labelAlign": "top" });
    var type2748 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Type d'upload", "name": "type", "pageSize": 20, "emptyText": "Choisir Type d'upload...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description2749 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description", "anchor": "-20", "name": "description" });
    var valid_until2750 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "expire le", "anchor": "-20", "name": "valid_until" });
    var main_2_panel2751 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2748, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2749, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until2750, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var modified2755 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var created2756 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var owner_disp2757 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Contr\u00f4l\u00e9 par", "anchor": "-20", "name": "owner" });
    var main_3_panel2758 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2755, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2756, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp2757, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var cal_TasksByController_grid2762 = new Lino.cal.TasksByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.default_action) ], "master_panel": this });
    var main_panel2763 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2745, main_2_panel2751, main_3_panel2758, cal_TasksByController_grid2762 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2763;
    this.before_row_edit = function(record) {
      cal_TasksByController_grid2762.on_master_changed();
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 85,
  initComponent : function() {
    var containing_panel = this;
    var id2764 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2765 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2766 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2767 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2768 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2764, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2765, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2766, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2767, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "region": "north", "labelAlign": "top" });
    var remark2773 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarque", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByEventType_grid2785 = new Lino.notes.NotesByEventType.GridPanel({ "flex": 6, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByEventType.default_action) ] });
    var main_panel2786 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "labelWidth": 108, "items": [ main_1_panel2768, { "flex": 3, "layout": "form", "xtype": "panel", "items": remark2773, "region": "center", "labelAlign": "top", "split": true }, notes_NotesByEventType_grid2785 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2786;
    this.before_row_edit = function(record) {
      notes_NotesByEventType_grid2785.on_master_changed();
    }
    Lino.notes.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 6,
  initComponent : function() {
    var containing_panel = this;
    var username2788 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nom d'utilisateur</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2789 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var profile2790 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": [ [ "100", "100 (Integration Agent)" ], [ "110", "110 (Integration Agent (Senior))" ], [ "200", "200 (Newcomers consultant)" ], [ "300", "300 (Debts consultant)" ], [ "400", "400 (Readonly User)" ], [ "500", "500 (CBSS only)" ], [ "900", "900 (Administrator)" ] ], "hiddenName": "profileHidden" });
    var box1_1_panel2791 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username2788, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2789, "labelAlign": "top" }, { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile2790, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name2795 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Pr\u00e9nom", "anchor": "-20", "name": "first_name" });
    var last_name2796 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Nom de famille", "anchor": "-20", "name": "last_name" });
    var partner2797 = new Lino.TwinCombo({ "fieldLabel": "partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.AllPartners.detail_action)}, "emptyText": "Choisir partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_2_panel2798 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2795, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2796, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner2797, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email2802 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "adresse e-mail", "anchor": "-20", "name": "email" });
    var language2803 = new Lino.ChoicesFieldElement({ "fieldLabel": "Langue", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var box1_3_panel2804 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2802, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2803, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created2807 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified2808 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box1_4_panel2809 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2807, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2808, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel2812 = new Ext.Panel({ "flex": 66, "autoHeight": true, "layout": "form", "items": [ box1_1_panel2791, box1_2_panel2798, box1_3_panel2804, box1_4_panel2809 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var newcomer_quota2813 = { "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quota nouvelles demandes</span>", "xtype": "numberfield", "value": 0, "name": "newcomer_quota", "listeners": { "render": Lino.quicktip_renderer("Quote NZ","Relative number expressing \n          how many Newcomer requests this User is able to treat.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var general_1_panel2814 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box1_panel2812, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": newcomer_quota2813, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var remarks2816 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarques", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid2819 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 20, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.default_action) ], "master_panel": this });
    var general_2_panel2820 = new Ext.Panel({ "flex": 55, "layout": "hbox", "items": [ { "items": remarks2816, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 80 }, AuthoritiesGiven_grid2819 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var general_panel2822 = new Ext.Panel({ "layout": "vbox", "title": "G\u00e9n\u00e9ral", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel2814, general_2_panel2820 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var calendar2823 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Calendrier par d\u00e9faut</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail_action)}, "emptyText": "Choisir Calendrier...", "listeners": { "render": Lino.quicktip_renderer("Standard-Kalender","The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class2824 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Classe d'acc\u00e8s par d\u00e9faut</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Priv\u00e9" ], [ "20", "Montrer \"occup\u00e9\"" ], [ "30", "Public" ] ], "name": "access_class" });
    var cal_left_1_panel2825 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar2823, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class2824, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 270, "border": false, "region": "north", "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid2832 = new Lino.cal.SubscriptionsByUser.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.default_action) ] });
    var cal_MembershipsByUser_grid2836 = new Lino.cal.MembershipsByUser.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.MembershipsByUser.default_action) ] });
    var cal_left_panel2837 = new Lino.VBorderPanel({ "flex": 33, "items": [ cal_left_1_panel2825, cal_SubscriptionsByUser_grid2832, cal_MembershipsByUser_grid2836 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var cal_RemindersByUser_grid2859 = new Lino.cal.RemindersByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.RemindersByUser.default_action) ], "master_panel": this });
    var cal_1_panel2860 = new Ext.Panel({ "layout": "hbox", "title": "Calendrier", "items": [ cal_left_panel2837, cal_RemindersByUser_grid2859 ], "frame": false, "layoutConfig": { "align": "stretch" }, "listeners": { "activate": Lino.on_tab_activate }, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var newcomers_CompetencesByUser_grid2865 = new Lino.newcomers.CompetencesByUser.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Comp\u00e9tences", "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.default_action) ], "master_panel": this });
    var main_panel2866 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel2822, cal_1_panel2860, newcomers_CompetencesByUser_grid2865 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel2866;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid2819.on_master_changed();
      cal_SubscriptionsByUser_grid2832.on_master_changed();
      cal_MembershipsByUser_grid2836.on_master_changed();
      cal_RemindersByUser_grid2859.on_master_changed();
      newcomers_CompetencesByUser_grid2865.on_master_changed();
    }
    Lino.users.MySettings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var title2867 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Allocution", "anchor": "-20", "name": "title" });
    var first_name2868 = new Ext.form.TextField({ "fieldLabel": "Pr\u00e9nom", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name2869 = new Ext.form.TextField({ "fieldLabel": "Nom de famille", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel2870 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2867, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2868, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2869, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender2874 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sexe", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ], "hiddenName": "genderHidden" });
    var language2875 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Langue</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "name": "language" });
    var main_2_panel2876 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2874, "labelAlign": "top" }, { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2875, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2879 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel2870, main_2_panel2876 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2879;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var name2886 = new Ext.form.TextField({ "fieldLabel": "Description", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2887 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2888 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2889 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2886, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2887, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2888, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type2893 = new Lino.ChoicesFieldElement({ "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var invite_team_members2894 = new Ext.form.Checkbox({ "boxLabel": "Inviter membres d'\u00e9quipe", "hideLabel": true, "checked": false, "name": "invite_team_members", "selectOnFocus": true, "anchor": "-20" });
    var color2895 = { "fieldLabel": "Couleur", "xtype": "numberfield", "value": 1, "name": "color", "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var main_2_panel2896 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2893, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members2894, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color2895, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2900 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel2889, main_2_panel2896 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2900;
    this.before_row_edit = function(record) {
    }
    Lino.cal.PanelCalendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.ContentTypesHandle
Lino.lino.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/lino/ContentTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "types de contenu",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail_action;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert_action;
    var ww = this.containing_window;
    var id2936 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name2937 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label2938 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model2939 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id2936, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name2937 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "app_label", "hidden": false, "editor": app_label2938 }, { "colIndex": 3, "sortable": true, "header": "nom de la classe python du mod\u00e8le", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "model", "hidden": false, "editor": model2939 } ];
    Lino.lino.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.ContentTypes.insert_actionPanel = Ext.extend(Lino.lino.ContentTypes.DetailFormPanel,{
  empty_title: "Nouveau types de contenu",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/lino/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail_action;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert_action;
    Lino.lino.ContentTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ContentTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.lino.ContentTypes.insert_actionPanel(p);
});

Lino.lino.ContentTypes.detail_actionPanel = Ext.extend(Lino.lino.ContentTypes.DetailFormPanel,{
  empty_title: "D\u00e9tail types de contenu",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/lino/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail_action;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert_action;
    Lino.lino.ContentTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ContentTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.ContentTypes.detail_actionPanel(p);
});
Lino.lino.ContentTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.HelpTextsHandle
Lino.lino.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/lino/HelpTexts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Textes d'aide",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" },'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field2945 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name2946 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text2947 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id2948 = { "selectOnFocus": true, "xtype": "numberfield" };
    var content_type2949 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    this.before_row_edit = function(record) {
      field2945.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type2949.on('change',Lino.chooser_handler(field2945,'content_type'));
      Lino.lino.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "field", "hidden": false, "editor": field2945 }, { "colIndex": 1, "sortable": false, "header": "Verbose name", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "verbose_name", "hidden": false }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text2947, "dataIndex": "help_text" }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id2948, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Mod\u00e8le", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('content_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": content_type2949, "dataIndex": "content_type" } ];
    Lino.lino.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.HelpTexts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.TextFieldTemplatesHandle
Lino.lino.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/lino/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Text Field Templates",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "name" }, { "name": "description" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.TextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.TextFieldTemplates.insert_action;
    var ww = this.containing_window;
    var id2956 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user2957 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var name2958 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description2959 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var text2960 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Texte mod\u00e8le" });
    this.before_row_edit = function(record) {
      description2959.refresh();
      text2960.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id2956, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user2957 }, { "colIndex": 2, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name2958 }, { "colIndex": 3, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": description2959, "dataIndex": "description" }, { "colIndex": 4, "sortable": false, "header": "text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": text2960, "dataIndex": "text" } ];
    Lino.lino.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.TextFieldTemplates.insert_actionPanel = Ext.extend(Lino.lino.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Nouveau Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/lino/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.TextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.TextFieldTemplates.insert_action;
    Lino.lino.TextFieldTemplates.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.TextFieldTemplates.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.lino.TextFieldTemplates.insert_actionPanel(p);
});

Lino.lino.TextFieldTemplates.detail_actionPanel = Ext.extend(Lino.lino.TextFieldTemplates.DetailFormPanel,{
  empty_title: "D\u00e9tail Text Field Templates",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/lino/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.TextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.TextFieldTemplates.insert_action;
    Lino.lino.TextFieldTemplates.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.TextFieldTemplates.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.TextFieldTemplates.detail_actionPanel(p);
});
Lino.lino.TextFieldTemplates.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.TextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIusers.MySettingsHandle
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  title : "Utilisateurs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" },'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" },'languageHidden', { "name": "partner" },'partnerHidden', { "name": "access_class" },'access_classHidden', { "name": "calendar" },'calendarHidden', { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 20,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail_action;
    this.ls_insert_handler = Lino.users.Users.insert_action;
    var ww = this.containing_window;
    var username2996 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile2997 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "100", "100 (Integration Agent)" ], [ "110", "110 (Integration Agent (Senior))" ], [ "200", "200 (Newcomers consultant)" ], [ "300", "300 (Debts consultant)" ], [ "400", "400 (Readonly User)" ], [ "500", "500 (CBSS only)" ], [ "900", "900 (Administrator)" ] ] });
    var first_name2998 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name2999 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id3000 = { "selectOnFocus": true, "xtype": "numberfield" };
    var created3001 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3002 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var email3003 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks3004 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language3005 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ] });
    var partner3006 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir partner..." });
    var access_class3007 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": [ [ "10", "Priv\u00e9" ], [ "20", "Montrer \"occup\u00e9\"" ], [ "30", "Public" ] ] });
    var calendar3008 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var newcomer_quota3009 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Nom d'utilisateur", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "username", "hidden": false, "editor": username2996 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(32), "dataIndex": "profile", "hidden": false, "editor": profile2997 }, { "colIndex": 2, "sortable": true, "header": "Pr\u00e9nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "first_name", "hidden": false, "editor": first_name2998 }, { "colIndex": 3, "sortable": true, "header": "Nom de famille", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "last_name", "hidden": false, "editor": last_name2999 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3000, "dataIndex": "id" }, { "width": Lino.chars2width(16), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 7, "sortable": true, "header": "adresse e-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email3003 }, { "colIndex": 8, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks3004, "dataIndex": "remarks" }, { "colIndex": 9, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language3005 }, { "colIndex": 10, "sortable": true, "header": "partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner3006, "dataIndex": "partner" }, { "colIndex": 11, "sortable": true, "header": "Classe d'acc\u00e8s par d\u00e9faut", "editable": true, "tooltip": "The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(31), "dataIndex": "access_class", "hidden": false, "editor": access_class3007 }, { "colIndex": 12, "sortable": true, "header": "Calendrier par d\u00e9faut", "editable": true, "tooltip": "Le calendrier par d\u00e9faut pour vos rendez-vous et t\u00e2ches.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "calendar", "hidden": false, "editor": calendar3008 }, { "colIndex": 13, "sortable": true, "header": "Quota nouvelles demandes", "editable": true, "tooltip": "Relative number expressing \n          how many Newcomer requests this User is able to treat.", "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "newcomer_quota", "hidden": false, "editor": newcomer_quota3009 } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.detail_actionPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "D\u00e9tail",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail_action;
    this.ls_insert_handler = Lino.users.Users.insert_action;
    Lino.users.MySettings.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detail_actionPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.LanguagesHandle
Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Langues",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name3032 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3033 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3034 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3035 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso23036 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3032 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3033 }, { "colIndex": 2, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3034 }, { "colIndex": 3, "sortable": true, "header": "id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(3), "dataIndex": "id", "hidden": false, "editor": id3035 }, { "colIndex": 4, "sortable": true, "header": "iso2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(3), "dataIndex": "iso2", "hidden": false, "editor": iso23036 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.CountriesHandle
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Pays",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail_action;
    this.ls_insert_handler = Lino.countries.Countries.insert_action;
    var ww = this.containing_window;
    var name3043 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3044 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3045 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode3046 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code3047 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso33048 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    var inscode3049 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3043 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3044 }, { "colIndex": 2, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3045 }, { "colIndex": 3, "sortable": true, "header": "isocode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "isocode", "hidden": false, "editor": isocode3046 }, { "colIndex": 4, "sortable": true, "header": "short code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "short_code", "hidden": false, "editor": short_code3047 }, { "colIndex": 5, "sortable": true, "header": "iso3", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(3), "dataIndex": "iso3", "hidden": false, "editor": iso33048 }, { "colIndex": 6, "sortable": true, "header": "Code INS", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(3), "dataIndex": "inscode", "hidden": false, "editor": inscode3049 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insert_actionPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Nouveau Pays",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail_action;
    this.ls_insert_handler = Lino.countries.Countries.insert_action;
    Lino.countries.Countries.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insert_actionPanel(p);
});

Lino.countries.Countries.detail_actionPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "D\u00e9tail Pays",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail_action;
    this.ls_insert_handler = Lino.countries.Countries.insert_action;
    Lino.countries.Countries.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detail_actionPanel(p);
});
Lino.countries.Countries.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.CitiesHandle
Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Endroits",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "country" },'countryHidden', { "name": "name" }, { "name": "type" },'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" },'parentHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail_action;
    this.ls_insert_handler = Lino.countries.Cities.insert_action;
    var ww = this.containing_window;
    var country3058 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Pays..." });
    var name3059 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type3060 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var zip_code3061 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id3062 = { "selectOnFocus": true, "xtype": "numberfield" };
    var parent3063 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var inscode3064 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      type3060.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3058.on('change',Lino.chooser_handler(type3060,'country'));
      Lino.countries.Cities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country3058, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3059 }, { "colIndex": 2, "sortable": true, "header": "Settlement Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "type", "hidden": false, "editor": type3060 }, { "colIndex": 3, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "zip_code", "hidden": false, "editor": zip_code3061 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3062, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Part of", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": parent3063, "dataIndex": "parent" }, { "colIndex": 6, "sortable": true, "header": "Code INS", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "inscode", "hidden": false, "editor": inscode3064 } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.insert_actionPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Nouveau Endroits",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail_action;
    this.ls_insert_handler = Lino.countries.Cities.insert_action;
    Lino.countries.Cities.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Cities.insert_actionPanel(p);
});

Lino.countries.Cities.detail_actionPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "D\u00e9tail Endroits",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail_action;
    this.ls_insert_handler = Lino.countries.Cities.insert_action;
    Lino.countries.Cities.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.detail_actionPanel(p);
});
Lino.countries.Cities.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropGroupsHandle
Lino.properties.PropGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropGroups",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Groupes de propri\u00e9t\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail_action;
    this.ls_insert_handler = Lino.properties.PropGroups.insert_action;
    var ww = this.containing_window;
    var id3073 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3074 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3075 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3076 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3073, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3074 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3075 }, { "colIndex": 3, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3076 } ];
    Lino.properties.PropGroups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.insert_actionPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Nouveau Groupes de propri\u00e9t\u00e9s",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/properties/PropGroups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail_action;
    this.ls_insert_handler = Lino.properties.PropGroups.insert_action;
    Lino.properties.PropGroups.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropGroups.insert_actionPanel(p);
});

Lino.properties.PropGroups.detail_actionPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "D\u00e9tail Groupes de propri\u00e9t\u00e9s",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/properties/PropGroups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail_action;
    this.ls_insert_handler = Lino.properties.PropGroups.insert_action;
    Lino.properties.PropGroups.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.detail_actionPanel(p);
});
Lino.properties.PropGroups.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropTypesHandle
Lino.properties.PropTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Types de propri\u00e9t\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "choicelist" },'choicelistHidden', { "name": "default_value" },'default_valueHidden', { "type": "boolean", "name": "limit_to_choices" }, { "type": "boolean", "name": "multiple_choices" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail_action;
    this.ls_insert_handler = Lino.properties.PropTypes.insert_action;
    var ww = this.containing_window;
    var id3082 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3083 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3084 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3085 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var choicelist3086 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "CityTypes", "Settlement Type" ], [ "DoYouLike", "Certainement pas...beaucoup" ], [ "Gender", "Sexe" ], [ "HowWell", "pas du tout...tr\u00e8s bien" ], [ "UserGroups", "User Group" ], [ "UserLevels", "User Level" ], [ "UserProfiles", "User Profile" ] ] });
    var default_value3087 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var limit_to_choices3088 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var multiple_choices3089 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      default_value3087.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      choicelist3086.on('change',Lino.chooser_handler(default_value3087,'choicelist'));
      Lino.properties.PropTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3082, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3083 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3084 }, { "colIndex": 3, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3085 }, { "colIndex": 4, "sortable": true, "header": "Liste de choix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "choicelist", "hidden": false, "editor": choicelist3086 }, { "colIndex": 5, "sortable": true, "header": "valeur par d\u00e9fault", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "default_value", "hidden": false, "editor": default_value3087 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Limite aux choix", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "limit_to_choices", "hidden": false }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "Choix multiples", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "multiple_choices", "hidden": false } ];
    Lino.properties.PropTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.insert_actionPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Nouveau Types de propri\u00e9t\u00e9s",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/properties/PropTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail_action;
    this.ls_insert_handler = Lino.properties.PropTypes.insert_action;
    Lino.properties.PropTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropTypes.insert_actionPanel(p);
});

Lino.properties.PropTypes.detail_actionPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "D\u00e9tail Types de propri\u00e9t\u00e9s",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/properties/PropTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail_action;
    this.ls_insert_handler = Lino.properties.PropTypes.insert_action;
    Lino.properties.PropTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.detail_actionPanel(p);
});
Lino.properties.PropTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropertiesHandle
Lino.properties.Properties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/Properties",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Propri\u00e9t\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "group" },'groupHidden', { "name": "type" },'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail_action;
    this.ls_insert_handler = Lino.properties.Properties.insert_action;
    var ww = this.containing_window;
    var id3099 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3100 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3101 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3102 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group3103 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s..." });
    var type3104 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Type de propri\u00e9t\u00e9..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3099, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3100 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3101 }, { "colIndex": 3, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3102 }, { "colIndex": 4, "sortable": true, "header": "Groupe de propri\u00e9t\u00e9s", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail_action'), "hidden": false, "editor": group3103, "dataIndex": "group" }, { "colIndex": 5, "sortable": true, "header": "Type de propri\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail_action'), "hidden": false, "editor": type3104, "dataIndex": "type" } ];
    Lino.properties.Properties.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.Properties.insert_actionPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "Nouveau Propri\u00e9t\u00e9s",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/properties/Properties",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail_action;
    this.ls_insert_handler = Lino.properties.Properties.insert_action;
    Lino.properties.Properties.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.Properties.insert_actionPanel(p);
});

Lino.properties.Properties.detail_actionPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "D\u00e9tail Propri\u00e9t\u00e9s",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/properties/Properties",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail_action;
    this.ls_insert_handler = Lino.properties.Properties.insert_action;
    Lino.properties.Properties.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.detail_actionPanel(p);
});
Lino.properties.Properties.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropChoicesHandle
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Choix de propri\u00e9t\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" },'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id3112 = { "selectOnFocus": true, "xtype": "numberfield" };
    var type3113 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Type de propri\u00e9t\u00e9..." });
    var value3114 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text3115 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr3116 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_en3117 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3112, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Type de propri\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail_action'), "hidden": false, "editor": type3113, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Valeur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "value", "hidden": false, "editor": value3114 }, { "colIndex": 3, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "text", "hidden": false, "editor": text3115 }, { "colIndex": 4, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "text_fr", "hidden": false, "editor": text_fr3116 }, { "colIndex": 5, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "text_en", "hidden": false, "editor": text_en3117 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcontacts.PartnersHandle
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail_action;
    this.ls_insert_handler = Lino.contacts.Partners.insert_action;
    var ww = this.containing_window;
    var name3140 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3141 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created3142 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3143 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3144 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city3145 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var region3146 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var zip_code3147 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr13148 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3149 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3150 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3151 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3152 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23153 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3154 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var url3155 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3156 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3157 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3158 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3159 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated3160 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3161 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account13162 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23163 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id3164 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city3145.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3145.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3146.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3144.on('change',Lino.chooser_handler(city3145,'country'));
      region3146.on('change',Lino.chooser_handler(city3145,'region'));
      country3144.on('change',Lino.chooser_handler(region3146,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3140 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email3141 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country3144, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Endroit", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city3145, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "R\u00e9gion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region3146, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Code postal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "hidden": false, "editor": zip_code3147 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr1", "hidden": false, "editor": addr13148 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix3149 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street", "hidden": false, "editor": street3150 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_no", "hidden": false, "editor": street_no3151 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_box", "hidden": false, "editor": street_box3152 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr2", "hidden": false, "editor": addr23153 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language3154 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "url", "hidden": false, "editor": url3155 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "phone", "hidden": false, "editor": phone3156 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "gsm", "hidden": false, "editor": gsm3157 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "fax", "hidden": false, "editor": fax3158 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks3159, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsol\u00e8te", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity3161 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account13162 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account23163 }, { "colIndex": 24, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3164, "dataIndex": "id" } ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Nouveau partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail_action;
    this.ls_insert_handler = Lino.contacts.Partners.insert_action;
    Lino.contacts.Partners.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insert_actionPanel(p);
});

Lino.contacts.Partners.detail_actionPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "D\u00e9tail partners",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail_action;
    this.ls_insert_handler = Lino.contacts.Partners.insert_action;
    Lino.contacts.Partners.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detail_actionPanel(p);
});
Lino.contacts.Partners.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcontacts.PersonsHandle
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Personnes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" },'languageHidden', { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "birth_date" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "title" }, { "name": "gender" },'genderHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail_action;
    this.ls_insert_handler = Lino.contacts.Persons.insert_action;
    var ww = this.containing_window;
    var name_column_disp3191 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp3192 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email3193 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone3194 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3195 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3196 = { "selectOnFocus": true, "xtype": "numberfield" };
    var language3197 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var created3198 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3199 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3200 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city3201 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var region3202 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var zip_code3203 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name3204 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr13205 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3206 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3207 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3208 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3209 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23210 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url3211 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3212 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3213 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated3214 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3215 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account13216 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23217 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var birth_date3218 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var first_name3219 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name3220 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var title3221 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender3222 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ] });
    this.before_row_edit = function(record) {
      city3201.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3201.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3202.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3200.on('change',Lino.chooser_handler(city3201,'country'));
      region3202.on('change',Lino.chooser_handler(city3201,'region'));
      country3200.on('change',Lino.chooser_handler(region3202,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(20), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Nom", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email3193 }, { "colIndex": 3, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "phone", "hidden": false, "editor": phone3194 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gsm", "hidden": false, "editor": gsm3195 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3196, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "hidden": false, "editor": language3197 }, { "width": Lino.chars2width(16), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country3200, "dataIndex": "country" }, { "colIndex": 10, "sortable": true, "header": "Endroit", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city3201, "dataIndex": "city" }, { "colIndex": 11, "sortable": true, "header": "R\u00e9gion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region3202, "dataIndex": "region" }, { "colIndex": 12, "sortable": true, "header": "Code postal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "hidden": false, "editor": zip_code3203 }, { "colIndex": 13, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3204 }, { "colIndex": 14, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr1", "hidden": false, "editor": addr13205 }, { "colIndex": 15, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix3206 }, { "colIndex": 16, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street", "hidden": false, "editor": street3207 }, { "colIndex": 17, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_no", "hidden": false, "editor": street_no3208 }, { "colIndex": 18, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_box", "hidden": false, "editor": street_box3209 }, { "colIndex": 19, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr2", "hidden": false, "editor": addr23210 }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "url", "hidden": false, "editor": url3211 }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "fax", "hidden": false, "editor": fax3212 }, { "colIndex": 22, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks3213, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "header": "obsol\u00e8te", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 24, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity3215 }, { "colIndex": 25, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account13216 }, { "colIndex": 26, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account23217 }, { "colIndex": 27, "sortable": true, "header": "Date de naissance", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "birth_date", "hidden": false, "editor": birth_date3218 }, { "colIndex": 28, "sortable": true, "header": "Pr\u00e9nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "first_name", "hidden": false, "editor": first_name3219 }, { "colIndex": 29, "sortable": true, "header": "Nom de famille", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "last_name", "hidden": false, "editor": last_name3220 }, { "colIndex": 30, "sortable": true, "header": "Allocution", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "title", "hidden": false, "editor": title3221 }, { "colIndex": 31, "sortable": true, "header": "Sexe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "gender", "hidden": false, "editor": gender3222 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.insert_actionPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "Nouveau Personnes",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail_action;
    this.ls_insert_handler = Lino.contacts.Persons.insert_action;
    Lino.contacts.Persons.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insert_actionPanel(p);
});

Lino.contacts.Persons.detail_actionPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "D\u00e9tail Personnes",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail_action;
    this.ls_insert_handler = Lino.contacts.Persons.insert_action;
    Lino.contacts.Persons.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detail_actionPanel(p);
});
Lino.contacts.Persons.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIoutbox.AttachmentsHandle
Lino.outbox.Attachments.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Attachments",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Pi\u00e8ces jointes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "mail" },'mailHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id3331 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type3332 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id3333 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_id", "method": "GET" }) }) });
    var mail3334 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Outgoing Mail..." });
    var owner_disp3335 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3333.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3332.on('change',Lino.chooser_handler(owner_id3333,'owner_type'));
      Lino.outbox.Attachments.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3331, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type3332, "dataIndex": "owner_type" }, { "colIndex": 2, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id3333 }, { "colIndex": 3, "sortable": true, "header": "Outgoing Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "mail", "hidden": false, "editor": mail3334 }, { "width": Lino.chars2width(30), "colIndex": 4, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "hidden": false, "editable": false } ];
    Lino.outbox.Attachments.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Attachments.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Attachments.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.PlacesHandle
Lino.cal.Places.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Places",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Endroits",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail_action;
    this.ls_insert_handler = Lino.cal.Places.insert_action;
    var ww = this.containing_window;
    var id3393 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3394 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3395 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3396 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3393, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3394 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3395 }, { "colIndex": 3, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3396 } ];
    Lino.cal.Places.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Places.insert_actionPanel = Ext.extend(Lino.cal.Places.DetailFormPanel,{
  empty_title: "Nouveau Endroits",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/Places",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail_action;
    this.ls_insert_handler = Lino.cal.Places.insert_action;
    Lino.cal.Places.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Places.insert_actionPanel(p);
});

Lino.cal.Places.detail_actionPanel = Ext.extend(Lino.cal.Places.DetailFormPanel,{
  empty_title: "D\u00e9tail Endroits",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/Places",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail_action;
    this.ls_insert_handler = Lino.cal.Places.insert_action;
    Lino.cal.Places.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Places.detail_actionPanel(p);
});
Lino.cal.Places.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Places.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.PrioritiesHandle
Lino.cal.Priorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Priorities",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Priorit\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "int", "name": "id" }, { "name": "ref" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name3402 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3403 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3404 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3405 = { "selectOnFocus": true, "xtype": "numberfield" };
    var ref3406 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": "1" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3402 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3403 }, { "colIndex": 2, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3404 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3405, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "ref", "hidden": false, "editor": ref3406 } ];
    Lino.cal.Priorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Priorities.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Priorities.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.TasksHandle
Lino.cal.Tasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Tasks",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "T\u00e2ches",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "state" },'stateHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "user" },'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "start_time" }, { "name": "uid" }, { "name": "description" }, { "name": "calendar" },'calendarHidden', { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 29,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail_action;
    this.ls_insert_handler = Lino.cal.Tasks.insert_action;
    var ww = this.containing_window;
    var start_date3564 = new Lino.DateField({ "selectOnFocus": true });
    var summary3565 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state3566 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "\u00e0 faire" ], [ "20", "D\u00e9marr\u00e9" ], [ "30", "accomplie" ], [ "40", "Dormant" ], [ "50", "Annul\u00e9" ] ] });
    var id3567 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type3568 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id3569 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_id", "method": "GET" }) }) });
    var user3570 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var created3571 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3572 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project3573 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var start_time3574 = new Lino.TimeField({ "selectOnFocus": true });
    var uid3575 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description3576 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var calendar3577 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var access_class3578 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": [ [ "10", "Priv\u00e9" ], [ "20", "Montrer \"occup\u00e9\"" ], [ "30", "Public" ] ] });
    var sequence3579 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type3580 = { "disabled": true, "xtype": "numberfield" };
    var due_date3581 = new Lino.DateField({ "selectOnFocus": true });
    var due_time3582 = new Lino.TimeField({ "selectOnFocus": true });
    var percent3583 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_disp3584 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3569.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description3576.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type3568.on('change',Lino.chooser_handler(owner_id3569,'owner_type'));
      Lino.cal.Tasks.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date d\u00e9but", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date3564 }, { "colIndex": 1, "sortable": true, "header": "Sommaire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "summary", "hidden": false, "editor": summary3565 }, { "colIndex": 2, "sortable": true, "header": "Etat", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "state", "hidden": false, "editor": state3566 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3567, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type3568, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id3569 }, { "colIndex": 6, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user3570 }, { "width": Lino.chars2width(16), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.AllClients.detail_action'), "hidden": false, "editor": project3573, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "Heure de d\u00e9but", "editable": true, "width": Lino.chars2width(8), "dataIndex": "start_time", "hidden": false, "editor": start_time3574 }, { "colIndex": 11, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "uid", "hidden": false, "editor": uid3575 }, { "colIndex": 12, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": description3576, "dataIndex": "description" }, { "colIndex": 13, "sortable": true, "header": "Calendrier", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "calendar", "hidden": false, "editor": calendar3577 }, { "colIndex": 14, "sortable": true, "header": "Classe d'acc\u00e8s", "editable": true, "tooltip": "Public, priv\u00e9 ou \"marquer occup\u00e9\".", "filter": { "type": "string" }, "width": Lino.chars2width(31), "dataIndex": "access_class", "hidden": false, "editor": access_class3578 }, { "colIndex": 15, "sortable": true, "header": "Version", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "sequence", "hidden": false, "editor": sequence3579 }, { "colIndex": 16, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "auto_type", "hidden": false }, { "colIndex": 17, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date d'\u00e9ch\u00e9ance", "dataIndex": "due_date", "hidden": false, "width": Lino.chars2width(8), "editor": due_date3581 }, { "colIndex": 18, "sortable": true, "header": "Heure d'\u00e9ch\u00e9ance", "editable": true, "width": Lino.chars2width(8), "dataIndex": "due_time", "hidden": false, "editor": due_time3582 }, { "colIndex": 19, "sortable": true, "header": "Dur\u00e9e (valeur)", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "percent", "hidden": false, "editor": percent3583 }, { "width": Lino.chars2width(30), "colIndex": 20, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "hidden": false, "editable": false } ];
    Lino.cal.Tasks.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.mark_10 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"mark_10");
};
Lino.cal.Tasks.mark_20 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"mark_20");
};
Lino.cal.Tasks.mark_30 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"mark_30");
};
Lino.cal.Tasks.mark_40 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"mark_40");
};
Lino.cal.Tasks.mark_50 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"mark_50");
};

Lino.cal.Tasks.insert_actionPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "Nouveau T\u00e2ches",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/Tasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail_action;
    this.ls_insert_handler = Lino.cal.Tasks.insert_action;
    Lino.cal.Tasks.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Tasks.insert_actionPanel(p);
});

Lino.cal.Tasks.detail_actionPanel = Ext.extend(Lino.cal.Tasks.DetailFormPanel,{
  empty_title: "D\u00e9tail T\u00e2ches",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/Tasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail_action;
    this.ls_insert_handler = Lino.cal.Tasks.insert_action;
    Lino.cal.Tasks.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.detail_actionPanel(p);
});
Lino.cal.Tasks.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.GuestRolesHandle
Lino.cal.GuestRoles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/GuestRoles",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "R\u014dles de participant",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "build_method" },'build_methodHidden', { "name": "template" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail_action;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert_action;
    var ww = this.containing_window;
    var id3607 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3608 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3609 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3610 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method3611 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template3612 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }) });
    var attach_to_email3613 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template3614 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    this.before_row_edit = function(record) {
      template3612.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method3611.on('change',Lino.chooser_handler(template3612,'build_method'));
      Lino.cal.GuestRoles.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3607, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3608 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3609 }, { "colIndex": 3, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3610 }, { "colIndex": 4, "sortable": true, "header": "M\u00e9thode de construction", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "build_method", "hidden": false, "editor": build_method3611 }, { "colIndex": 5, "sortable": true, "header": "Mod\u00e8le", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "template", "hidden": false, "editor": template3612 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Attach to email", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "attach_to_email", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "Email template", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "email_template", "hidden": false, "editor": email_template3614 } ];
    Lino.cal.GuestRoles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.insert_actionPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "Nouveau R\u014dles de participant",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/GuestRoles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail_action;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert_action;
    Lino.cal.GuestRoles.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.GuestRoles.insert_actionPanel(p);
});

Lino.cal.GuestRoles.detail_actionPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "D\u00e9tail R\u014dles de participant",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/GuestRoles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail_action;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert_action;
    Lino.cal.GuestRoles.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.detail_actionPanel(p);
});
Lino.cal.GuestRoles.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.GuestsHandle
Lino.cal.Guests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Guests",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Effacer la cache", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "do_print", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_mail", "text": "C\u00e9er courrier", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Participants",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "partner" },'partnerHidden', { "name": "role" },'roleHidden', { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "name": "event" },'eventHidden', { "type": "int", "name": "id" }, { "name": "build_time" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var partner3624 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir partner..." });
    var role3625 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir R\u00f4le de participant..." });
    var state3626 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Invit\u00e9" ], [ "20", "Accept\u00e9" ], [ "30", "Rejet\u00e9" ], [ "40", "Pr\u00e9sent" ], [ "50", "Absent" ] ] });
    var workflow_buttons_disp3627 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark3628 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event3629 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Rendez-vous..." });
    var id3630 = { "selectOnFocus": true, "xtype": "numberfield" };
    var build_time3631 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner3624, "dataIndex": "partner" }, { "colIndex": 1, "sortable": true, "header": "R\u00f4le", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail_action'), "hidden": false, "editor": role3625, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "Etat", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "state", "hidden": false, "editor": state3626 }, { "width": Lino.chars2width(30), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "remark", "hidden": false, "editor": remark3628 }, { "colIndex": 5, "sortable": true, "header": "Rendez-vous", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "event", "hidden": false, "editor": event3629 }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3630, "dataIndex": "id" }, { "width": Lino.chars2width(16), "colIndex": 7, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false } ];
    Lino.cal.Guests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.mark_10 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"mark_10");
};
Lino.cal.Guests.mark_20 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"mark_20");
};
Lino.cal.Guests.mark_30 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"mark_30");
};
Lino.cal.Guests.mark_40 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"mark_40");
};
Lino.cal.Guests.mark_50 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"mark_50");
};
Lino.cal.Guests.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"duplicate_row");
};
Lino.cal.Guests.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Guests.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.PanelCalendarsHandle
Lino.cal.PanelCalendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/PanelCalendars",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Calendriers",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "babel_name" }, { "name": "description" }, { "type": "int", "name": "color" }, { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail_action;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert_action;
    var ww = this.containing_window;
    var id3641 = { "selectOnFocus": true, "xtype": "numberfield" };
    var babel_name_disp3642 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var description3643 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var color3644 = { "selectOnFocus": true, "xtype": "numberfield", "value": 1, "allowBlank": false };
    var is_hidden_disp3645 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description3643.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3641, "dataIndex": "id" }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "babel_name", "header": "babel_name", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": description3643, "dataIndex": "description" }, { "colIndex": 3, "sortable": true, "header": "Couleur", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "color", "hidden": false, "editor": color3644 }, { "width": Lino.chars2width(20), "colIndex": 4, "sortable": false, "dataIndex": "is_hidden", "header": "Invisible", "hidden": false, "editable": false } ];
    Lino.cal.PanelCalendars.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.insert_actionPanel = Ext.extend(Lino.cal.PanelCalendars.InsertFormPanel,{
  empty_title: "Nouveau Calendriers",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail_action;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert_action;
    Lino.cal.PanelCalendars.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelCalendars.insert_actionPanel(p);
});

Lino.cal.PanelCalendars.detail_actionPanel = Ext.extend(Lino.cal.PanelCalendars.DetailFormPanel,{
  empty_title: "D\u00e9tail Calendriers",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail_action;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert_action;
    Lino.cal.PanelCalendars.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.detail_actionPanel(p);
});
Lino.cal.PanelCalendars.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.PanelEventsHandle
Lino.cal.PanelEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/PanelEvents",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Effacer la cache", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "C\u00e9er courrier", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Rendez-vous",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "start_dt" }, { "name": "end_dt" }, { "name": "summary" }, { "name": "description" }, { "name": "user" },'userHidden', { "name": "place" },'placeHidden', { "name": "calendar" },'calendarHidden', { "name": "url" }, { "type": "boolean", "name": "all_day" }, { "name": "reminder" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail_action;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert_action;
    var ww = this.containing_window;
    var id3652 = { "selectOnFocus": true, "xtype": "numberfield" };
    var start_dt3653 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_dt3654 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var summary3655 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var description3656 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var user3657 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var place3658 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var calendar3659 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Calendrier..." });
    var url_disp3660 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var all_day3661 = new Ext.form.Checkbox({ "disabled": true });
    var reminder_disp3662 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description3656.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3652, "dataIndex": "id" }, { "width": Lino.chars2width(16), "colIndex": 1, "sortable": false, "dataIndex": "start_dt", "header": "D\u00e9but", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": false, "dataIndex": "end_dt", "header": "Fin", "hidden": false, "editable": false }, { "colIndex": 3, "sortable": false, "header": "Sommaire", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(3), "dataIndex": "summary", "hidden": false }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": description3656, "dataIndex": "description" }, { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user3657 }, { "colIndex": 6, "sortable": true, "header": "Endroit", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail_action'), "hidden": false, "editor": place3658, "dataIndex": "place" }, { "colIndex": 7, "sortable": true, "header": "Calendrier", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "calendar", "hidden": false, "editor": calendar3659 }, { "width": Lino.chars2width(30), "colIndex": 8, "sortable": false, "dataIndex": "url", "header": "Link URL", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(10), "editable": false, "filter": { "type": "boolean" }, "header": "journ\u00e9e enti\u00e8re", "dataIndex": "all_day", "hidden": false }, { "width": Lino.chars2width(30), "colIndex": 10, "sortable": false, "dataIndex": "reminder", "header": "Rappel", "hidden": false, "editable": false } ];
    Lino.cal.PanelEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.mark_10 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_10");
};
Lino.cal.PanelEvents.mark_20 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_20");
};
Lino.cal.PanelEvents.mark_30 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_30");
};
Lino.cal.PanelEvents.mark_40 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_40");
};
Lino.cal.PanelEvents.mark_50 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_50");
};
Lino.cal.PanelEvents.mark_60 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_60");
};
Lino.cal.PanelEvents.mark_70 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_70");
};
Lino.cal.PanelEvents.mark_80 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_80");
};
Lino.cal.PanelEvents.mark_90 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_90");
};

Lino.cal.PanelEvents.insert_actionPanel = Ext.extend(Lino.cal.PanelEvents.InsertFormPanel,{
  empty_title: "Nouveau Rendez-vous",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/PanelEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail_action;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert_action;
    Lino.cal.PanelEvents.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelEvents.insert_actionPanel(p);
});
Lino.cal.PanelEvents.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"duplicate_row");
};

Lino.cal.PanelEvents.detail_actionPanel = Ext.extend(Lino.cal.PanelEvents.DetailFormPanel,{
  empty_title: "D\u00e9tail Rendez-vous",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Effacer la cache", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "C\u00e9er courrier", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/PanelEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail_action;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert_action;
    Lino.cal.PanelEvents.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelEvents.detail_actionPanel(p);
});
Lino.cal.PanelEvents.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelEvents.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIuploads.UploadTypesHandle
Lino.uploads.UploadTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/UploadTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Types d'upload",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var name3675 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var id3676 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3675 }, { "colIndex": 1, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3676, "dataIndex": "id" } ];
    Lino.uploads.UploadTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIuploads.UploadsHandle
Lino.uploads.Uploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/Uploads",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "user" },'userHidden', { "name": "created" }, { "name": "modified" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "mimetype" }, { "name": "type" },'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "description" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail_action;
    this.ls_insert_handler = Lino.uploads.Uploads.insert_action;
    var ww = this.containing_window;
    var file3680 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var user3681 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var created3682 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3683 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var id3684 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type3685 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir type de contenu..." });
    var owner_id3686 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_id", "method": "GET" }) }) });
    var mimetype3687 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var type3688 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'upload..." });
    var valid_until3689 = new Lino.DateField({ "selectOnFocus": true });
    var description3690 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_disp3691 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3686.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3685.on('change',Lino.chooser_handler(owner_id3686,'owner_type'));
      Lino.uploads.Uploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Datei", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "file", "hidden": false, "editor": file3680 }, { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user3681 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3684, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Contr\u00f4l\u00e9 par (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type3685, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Contr\u00f4l\u00e9 par (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id3686 }, { "colIndex": 7, "sortable": true, "header": "MIME-Art", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "mimetype", "hidden": false }, { "colIndex": 8, "sortable": true, "header": "Type d'upload", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type3688 }, { "colIndex": 9, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "expire le", "dataIndex": "valid_until", "hidden": false, "width": Lino.chars2width(8), "editor": valid_until3689 }, { "colIndex": 10, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "description", "hidden": false, "editor": description3690 }, { "width": Lino.chars2width(30), "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Contr\u00f4l\u00e9 par", "hidden": false, "editable": false } ];
    Lino.uploads.Uploads.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.insert_actionPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "Nouveau Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/uploads/Uploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail_action;
    this.ls_insert_handler = Lino.uploads.Uploads.insert_action;
    Lino.uploads.Uploads.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.Uploads.insert_actionPanel(p);
});

Lino.uploads.Uploads.detail_actionPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "D\u00e9tail Uploads",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/uploads/Uploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail_action;
    this.ls_insert_handler = Lino.uploads.Uploads.insert_action;
    Lino.uploads.Uploads.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.detail_actionPanel(p);
});
Lino.uploads.Uploads.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.TypesHandle
Lino.households.Types.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Types",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Types de m\u00e9nage",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail_action;
    this.ls_insert_handler = Lino.households.Types.insert_action;
    var ww = this.containing_window;
    var id3705 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3706 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3707 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3708 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3705, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3706 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3707 }, { "colIndex": 3, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3708 } ];
    Lino.households.Types.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.insert_actionPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Nouveau Types de m\u00e9nage",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/households/Types",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail_action;
    this.ls_insert_handler = Lino.households.Types.insert_action;
    Lino.households.Types.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Types.insert_actionPanel(p);
});

Lino.households.Types.detail_actionPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "D\u00e9tail Types de m\u00e9nage",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/households/Types",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail_action;
    this.ls_insert_handler = Lino.households.Types.insert_action;
    Lino.households.Types.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.detail_actionPanel(p);
});
Lino.households.Types.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.HouseholdsHandle
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "M\u00e9nages",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "type" },'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 32,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail_action;
    this.ls_insert_handler = Lino.households.Households.insert_action;
    var ww = this.containing_window;
    var name3714 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3715 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created3716 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3717 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3718 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city3719 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var region3720 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var zip_code3721 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr13722 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3723 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3724 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3725 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3726 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23727 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3728 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var url3729 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3730 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3731 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3732 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3733 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated3734 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3735 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account13736 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23737 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix3738 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type3739 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de m\u00e9nage..." });
    var id3740 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city3719.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3719.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3720.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3718.on('change',Lino.chooser_handler(city3719,'country'));
      region3720.on('change',Lino.chooser_handler(city3719,'region'));
      country3718.on('change',Lino.chooser_handler(region3720,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3714 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email3715 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country3718, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Endroit", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city3719, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "R\u00e9gion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region3720, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Code postal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "hidden": false, "editor": zip_code3721 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr1", "hidden": false, "editor": addr13722 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix3723 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street", "hidden": false, "editor": street3724 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_no", "hidden": false, "editor": street_no3725 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_box", "hidden": false, "editor": street_box3726 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr2", "hidden": false, "editor": addr23727 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language3728 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "url", "hidden": false, "editor": url3729 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "phone", "hidden": false, "editor": phone3730 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "gsm", "hidden": false, "editor": gsm3731 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "fax", "hidden": false, "editor": fax3732 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks3733, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsol\u00e8te", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity3735 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account13736 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account23737 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "prefix", "hidden": false, "editor": prefix3738 }, { "colIndex": 25, "sortable": true, "header": "Type de m\u00e9nage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.households.Types.detail_action'), "hidden": false, "editor": type3739, "dataIndex": "type" }, { "colIndex": 26, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3740, "dataIndex": "id" } ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Nouveau M\u00e9nages",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail_action;
    this.ls_insert_handler = Lino.households.Households.insert_action;
    Lino.households.Households.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insert_actionPanel(p);
});

Lino.households.Households.detail_actionPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "D\u00e9tail M\u00e9nages",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail_action;
    this.ls_insert_handler = Lino.households.Households.insert_action;
    Lino.households.Households.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detail_actionPanel(p);
});
Lino.households.Households.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.RolesHandle
Lino.households.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Roles",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "R\u00f4les dans m\u00e9nage",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "boolean", "name": "name_giving" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail_action;
    this.ls_insert_handler = Lino.households.Roles.insert_action;
    var ww = this.containing_window;
    var id3769 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3770 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3771 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3772 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_giving3773 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3769, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3770 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3771 }, { "colIndex": 3, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3772 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "donneur de nom", "editable": true, "tooltip": "When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "name_giving", "hidden": false } ];
    Lino.households.Roles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.insert_actionPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Nouveau R\u00f4les dans m\u00e9nage",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/households/Roles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail_action;
    this.ls_insert_handler = Lino.households.Roles.insert_action;
    Lino.households.Roles.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Roles.insert_actionPanel(p);
});

Lino.households.Roles.detail_actionPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "D\u00e9tail R\u00f4les dans m\u00e9nage",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/households/Roles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail_action;
    this.ls_insert_handler = Lino.households.Roles.insert_action;
    Lino.households.Roles.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.detail_actionPanel(p);
});
Lino.households.Roles.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.MembersHandle
Lino.households.Members.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Members",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Membres de m\u00e9nage",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "role" },'roleHidden', { "name": "household" },'householdHidden', { "name": "person" },'personHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id3780 = { "selectOnFocus": true, "xtype": "numberfield" };
    var role3781 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir R\u00f4le dans m\u00e9nage..." });
    var household3782 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/household", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir M\u00e9nage..." });
    var person3783 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Personne..." });
    var start_date3784 = new Lino.DateField({ "selectOnFocus": true });
    var end_date3785 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3780, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(20), "editable": true, "tooltip": "The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "header": "R\u00f4le dans m\u00e9nage", "renderer": Lino.fk_renderer('roleHidden','Lino.households.Roles.detail_action'), "hidden": false, "editor": role3781, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "M\u00e9nage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('householdHidden','Lino.households.Households.detail_action'), "hidden": false, "editor": household3782, "dataIndex": "household" }, { "colIndex": 3, "sortable": true, "header": "Personne", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail_action'), "hidden": false, "editor": person3783, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date3784 }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date3785 } ];
    Lino.households.Members.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Members.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Members.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.ChartsHandle
Lino.accounts.Charts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Charts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Plan comptables",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 43,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail_action;
    this.ls_insert_handler = Lino.accounts.Charts.insert_action;
    var ww = this.containing_window;
    var id3793 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3794 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3795 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3796 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3793, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3794 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3795 }, { "colIndex": 3, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3796 } ];
    Lino.accounts.Charts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.insert_actionPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Nouveau Plan comptables",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/accounts/Charts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail_action;
    this.ls_insert_handler = Lino.accounts.Charts.insert_action;
    Lino.accounts.Charts.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Charts.insert_actionPanel(p);
});

Lino.accounts.Charts.detail_actionPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "D\u00e9tail Plan comptables",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/accounts/Charts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail_action;
    this.ls_insert_handler = Lino.accounts.Charts.insert_action;
    Lino.accounts.Charts.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.detail_actionPanel(p);
});
Lino.accounts.Charts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.GroupsHandle
Lino.accounts.Groups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Groups",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Groupes de comptes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "chart" },'chartHidden', { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "account_type" },'account_typeHidden', { "type": "int", "name": "id" }, { "name": "help_text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail_action;
    this.ls_insert_handler = Lino.accounts.Groups.insert_action;
    var ww = this.containing_window;
    var chart3802 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Groups/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Plan comptable..." });
    var ref3803 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var name3804 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3805 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3806 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type3807 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "A", "Assets" ], [ "L", "Obligations" ], [ "I", "Revenus" ], [ "E", "D\u00e9penses" ], [ "C", "Capital" ] ] });
    var id3808 = { "selectOnFocus": true, "xtype": "numberfield" };
    var help_text3809 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Introduction" });
    this.before_row_edit = function(record) {
      help_text3809.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Plan comptable", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail_action'), "hidden": false, "editor": chart3802, "dataIndex": "chart" }, { "colIndex": 1, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "ref", "hidden": false, "editor": ref3803 }, { "colIndex": 2, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3804 }, { "colIndex": 3, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3805 }, { "colIndex": 4, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3806 }, { "colIndex": 5, "sortable": true, "header": "Type de compte", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "account_type", "hidden": false, "editor": account_type3807 }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3808, "dataIndex": "id" }, { "colIndex": 7, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text3809, "dataIndex": "help_text" } ];
    Lino.accounts.Groups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.insert_actionPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Nouveau Groupes de comptes",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/accounts/Groups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail_action;
    this.ls_insert_handler = Lino.accounts.Groups.insert_action;
    Lino.accounts.Groups.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Groups.insert_actionPanel(p);
});

Lino.accounts.Groups.detail_actionPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "D\u00e9tail Groupes de comptes",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/accounts/Groups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail_action;
    this.ls_insert_handler = Lino.accounts.Groups.insert_action;
    Lino.accounts.Groups.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.detail_actionPanel(p);
});
Lino.accounts.Groups.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.AccountsHandle
Lino.accounts.Accounts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Accounts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') } ],
  title : "Comptes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "int", "name": "seqno" }, { "name": "chart" },'chartHidden', { "name": "group" },'groupHidden', { "name": "ref" }, { "name": "type" },'typeHidden', { "name": "help_text" }, { "type": "boolean", "name": "required_for_household" }, { "type": "boolean", "name": "required_for_person" }, { "type": "float", "name": "periods" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 42,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var id3819 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3820 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3821 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3822 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var seqno3823 = { "selectOnFocus": true, "xtype": "numberfield" };
    var chart3824 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Plan comptable..." });
    var group3825 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Groupe de comptes..." });
    var ref3826 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var type3827 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": [ [ "A", "Assets" ], [ "L", "Obligations" ], [ "I", "Revenus" ], [ "E", "D\u00e9penses" ], [ "C", "Capital" ] ] });
    var help_text3828 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Introduction" });
    var required_for_household3829 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var required_for_person3830 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var periods3831 = { "xtype": "numberfield", "allowDecimals": false, "selectOnFocus": true, "value": 1, "allowBlank": false };
    this.before_row_edit = function(record) {
      help_text3828.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3819, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3820 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3821 }, { "colIndex": 3, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3822 }, { "colIndex": 4, "sortable": true, "header": "N\u00b0 de s\u00e9q", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "seqno", "hidden": false, "editor": seqno3823 }, { "colIndex": 5, "sortable": true, "header": "Plan comptable", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail_action'), "hidden": false, "editor": chart3824, "dataIndex": "chart" }, { "colIndex": 6, "sortable": true, "header": "Groupe de comptes", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.accounts.Groups.detail_action'), "hidden": false, "editor": group3825, "dataIndex": "group" }, { "colIndex": 7, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "ref", "hidden": false, "editor": ref3826 }, { "colIndex": 8, "sortable": true, "header": "Type de compte", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "type", "hidden": false, "editor": type3827 }, { "colIndex": 9, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text3828, "dataIndex": "help_text" }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "obligatoire pour m\u00e9nages", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "required_for_household", "hidden": false }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "obligatoire pour personnes", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "required_for_person", "hidden": false }, { "colIndex": 12, "sortable": true, "xtype": "numbercolumn", "format": "0/i", "align": "right", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(3), "dataIndex": "periods", "header": "P\u00e9riodes", "hidden": false, "editor": periods3831 } ];
    Lino.accounts.Accounts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.GridPanel(p);
});
Lino.accounts.Accounts.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts",pk,"duplicate_row");
};

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.NoteTypesHandle
Lino.notes.NoteTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/notes/NoteTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Types de note",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "build_method" },'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "type": "boolean", "name": "important" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 87,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail_action;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert_action;
    var ww = this.containing_window;
    var name3846 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3847 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3848 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method3849 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template3850 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }) });
    var id3851 = { "selectOnFocus": true, "xtype": "numberfield" };
    var attach_to_email3852 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template3853 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var important3854 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var remark3855 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      template3850.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method3849.on('change',Lino.chooser_handler(template3850,'build_method'));
      Lino.notes.NoteTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3846 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3847 }, { "colIndex": 2, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3848 }, { "colIndex": 3, "sortable": true, "header": "M\u00e9thode de construction", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "build_method", "hidden": false, "editor": build_method3849 }, { "colIndex": 4, "sortable": true, "header": "Mod\u00e8le", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "template", "hidden": false, "editor": template3850 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3851, "dataIndex": "id" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Attach to email", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "attach_to_email", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "Email template", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "email_template", "hidden": false, "editor": email_template3853 }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "important", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "important", "hidden": false }, { "colIndex": 9, "sortable": false, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark3855, "dataIndex": "remark" } ];
    Lino.notes.NoteTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.insert_actionPanel = Ext.extend(Lino.notes.NoteTypes.DetailFormPanel,{
  empty_title: "Nouveau Types de note",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/notes/NoteTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail_action;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert_action;
    Lino.notes.NoteTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NoteTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.NoteTypes.insert_actionPanel(p);
});

Lino.notes.NoteTypes.detail_actionPanel = Ext.extend(Lino.notes.NoteTypes.DetailFormPanel,{
  empty_title: "D\u00e9tail Types de note",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/notes/NoteTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail_action;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert_action;
    Lino.notes.NoteTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NoteTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NoteTypes.detail_actionPanel(p);
});
Lino.notes.NoteTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NoteTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.EventTypesHandle
Lino.notes.EventTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/notes/EventTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Types d'\u00e9v\u00e9nements",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "int", "name": "id" }, { "name": "remark" }, { "name": "body" }, { "name": "body_fr" }, { "name": "body_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 85,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail_action;
    this.ls_insert_handler = Lino.notes.EventTypes.insert_action;
    var ww = this.containing_window;
    var name3867 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3868 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3869 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3870 = { "selectOnFocus": true, "xtype": "numberfield" };
    var remark3871 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var body3872 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Contenu" });
    var body_fr3873 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Contenu (fr)" });
    var body_en3874 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Contenu (en)" });
    this.before_row_edit = function(record) {
      body3872.refresh();
      body_fr3873.refresh();
      body_en3874.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name3867 }, { "colIndex": 1, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3868 }, { "colIndex": 2, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en3869 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3870, "dataIndex": "id" }, { "colIndex": 4, "sortable": false, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark3871, "dataIndex": "remark" }, { "colIndex": 5, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body3872, "dataIndex": "body" }, { "colIndex": 6, "sortable": false, "header": "body_fr", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body_fr3873, "dataIndex": "body_fr" }, { "colIndex": 7, "sortable": false, "header": "body_en", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body_en3874, "dataIndex": "body_en" } ];
    Lino.notes.EventTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.insert_actionPanel = Ext.extend(Lino.notes.EventTypes.DetailFormPanel,{
  empty_title: "Nouveau Types d'\u00e9v\u00e9nements",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/notes/EventTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail_action;
    this.ls_insert_handler = Lino.notes.EventTypes.insert_action;
    Lino.notes.EventTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.EventTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.EventTypes.insert_actionPanel(p);
});

Lino.notes.EventTypes.detail_actionPanel = Ext.extend(Lino.notes.EventTypes.DetailFormPanel,{
  empty_title: "D\u00e9tail Types d'\u00e9v\u00e9nements",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/notes/EventTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail_action;
    this.ls_insert_handler = Lino.notes.EventTypes.insert_action;
    Lino.notes.EventTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.EventTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.EventTypes.detail_actionPanel(p);
});
Lino.notes.EventTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.EventTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.NotesHandle
Lino.notes.Notes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/notes/Notes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Effacer la cache", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "C\u00e9er courrier", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events/Notes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" },'userHidden', { "name": "event_type" },'event_typeHidden', { "name": "type" },'typeHidden', { "name": "project" },'projectHidden', { "name": "subject" }, { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "company" },'companyHidden', { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 86,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail_action;
    this.ls_insert_handler = Lino.notes.Notes.insert_action;
    var ww = this.containing_window;
    var id3884 = { "selectOnFocus": true, "xtype": "numberfield" };
    var date3885 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user3886 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var event_type3887 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Event Type..." });
    var type3888 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de note..." });
    var project3889 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var subject3890 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_time3891 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language3892 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ] });
    var company3893 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var body3894 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Contenu" });
    this.before_row_edit = function(record) {
      body3894.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3884, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date3885 }, { "colIndex": 2, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user3886 }, { "colIndex": 3, "sortable": true, "header": "Event Type (Form)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('event_typeHidden','Lino.notes.EventTypes.detail_action'), "hidden": false, "editor": event_type3887, "dataIndex": "event_type" }, { "colIndex": 4, "sortable": true, "header": "Note Type (Content)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.notes.NoteTypes.detail_action'), "hidden": false, "editor": type3888, "dataIndex": "type" }, { "colIndex": 5, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.AllClients.detail_action'), "hidden": false, "editor": project3889, "dataIndex": "project" }, { "colIndex": 6, "sortable": true, "header": "Objet", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "subject", "hidden": false, "editor": subject3890 }, { "width": Lino.chars2width(16), "colIndex": 7, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 8, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language3892 }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(20), "editable": true, "tooltip": "    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ", "filter": { "type": "string" }, "header": "Organisation", "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail_action'), "hidden": false, "editor": company3893, "dataIndex": "company" }, { "colIndex": 10, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body3894, "dataIndex": "body" } ];
    Lino.notes.Notes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.insert_actionPanel = Ext.extend(Lino.notes.Notes.InsertFormPanel,{
  empty_title: "Nouveau Events/Notes",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/notes/Notes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail_action;
    this.ls_insert_handler = Lino.notes.Notes.insert_action;
    Lino.notes.Notes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.Notes.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.Notes.insert_actionPanel(p);
});
Lino.notes.Notes.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/notes/Notes",pk,"duplicate_row");
};

Lino.notes.Notes.detail_actionPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "D\u00e9tail Events/Notes",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Effacer la cache", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "C\u00e9er courrier", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/notes/Notes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail_action;
    this.ls_insert_handler = Lino.notes.Notes.insert_action;
    Lino.notes.Notes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.Notes.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.Notes.detail_actionPanel(p);
});
Lino.notes.Notes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.Notes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcv.PersonPropertiesHandle
Lino.cv.PersonProperties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cv/PersonProperties",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Propri\u00e9t\u00e9s",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "group" },'groupHidden', { "name": "property" },'propertyHidden', { "name": "value" },'valueHidden', { "name": "person" },'personHidden', { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var id3907 = { "selectOnFocus": true, "xtype": "numberfield" };
    var group3908 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/PersonProperties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Groupe de propri\u00e9t\u00e9s..." });
    var property3909 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/PersonProperties/property", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Propri\u00e9t\u00e9..." });
    var value3910 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/PersonProperties/value", "method": "GET" }) }) });
    var person3911 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/PersonProperties/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Client..." });
    var remark3912 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      property3909.setContextValue('group',record ? record.data['groupHidden'] : undefined);
      value3910.setContextValue('property',record ? record.data['propertyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      group3908.on('change',Lino.chooser_handler(property3909,'group'));
      property3909.on('change',Lino.chooser_handler(value3910,'property'));
      Lino.cv.PersonProperties.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3907, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Groupe de propri\u00e9t\u00e9s", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail_action'), "hidden": true, "editor": group3908, "dataIndex": "group" }, { "colIndex": 2, "sortable": true, "header": "Propri\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('propertyHidden','Lino.properties.Properties.detail_action'), "hidden": false, "editor": property3909, "dataIndex": "property" }, { "colIndex": 3, "sortable": true, "header": "Valeur", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "value", "hidden": false, "editor": value3910 }, { "colIndex": 4, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.AllClients.detail_action'), "hidden": false, "editor": person3911, "dataIndex": "person" }, { "colIndex": 5, "sortable": true, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "remark", "hidden": false, "editor": remark3912 } ];
    Lino.cv.PersonProperties.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cv.PersonProperties.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cv.PersonProperties.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIisip.ContractsHandle
Lino.isip.Contracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/isip/Contracts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Effacer la cache", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "PIISs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "user" },'userHidden', { "name": "type" },'typeHidden', { "name": "build_time" }, { "name": "company" },'companyHidden', { "name": "contact" },'contactHidden', { "name": "person" },'personHidden', { "name": "language" },'languageHidden', { "type": "date", "name": "date_decided", "dateFormat": "d.m.Y" }, { "type": "date", "name": "date_issued", "dateFormat": "d.m.Y" }, { "name": "user_asd" },'user_asdHidden', { "name": "exam_policy" },'exam_policyHidden', { "name": "ending" },'endingHidden', { "type": "date", "name": "date_ended", "dateFormat": "d.m.Y" }, { "name": "stages" }, { "name": "goals" }, { "name": "duties_asd" }, { "name": "duties_dsbe" }, { "name": "duties_company" }, { "name": "duties_person" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 48,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 32,
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.Contracts.detail_action;
    this.ls_insert_handler = Lino.isip.Contracts.insert_action;
    var ww = this.containing_window;
    var id3973 = { "selectOnFocus": true, "xtype": "numberfield" };
    var applies_from3974 = new Lino.DateField({ "selectOnFocus": true });
    var applies_until3975 = new Lino.DateField({ "selectOnFocus": true });
    var user3976 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var type3977 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de PIIS..." });
    var build_time3978 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var company3979 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var contact3980 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Personne de contact..." });
    var person3981 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Client..." });
    var language3982 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var date_decided3983 = new Lino.DateField({ "selectOnFocus": true });
    var date_issued3984 = new Lino.DateField({ "selectOnFocus": true });
    var user_asd3985 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user_asd", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var exam_policy3986 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/exam_policy", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir M\u00e9thode d'examination..." });
    var ending3987 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Rupture/fin de contrat..." });
    var date_ended3988 = new Lino.DateField({ "selectOnFocus": true });
    var stages3989 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "stages" });
    var goals3990 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "buts" });
    var duties_asd3991 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "devoirs SSG" });
    var duties_dsbe3992 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "devois ISP" });
    var duties_company3993 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "devoirs entreprise" });
    var duties_person3994 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Devoirs personne" });
    this.before_row_edit = function(record) {
      contact3980.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      stages3989.refresh();
      goals3990.refresh();
      duties_asd3991.refresh();
      duties_dsbe3992.refresh();
      duties_company3993.refresh();
      duties_person3994.refresh();
    };
    this.onRender = function(ct, position) {
      company3979.on('change',Lino.chooser_handler(contact3980,'company'));
      Lino.isip.Contracts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3973, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9but de contrat", "dataIndex": "applies_from", "hidden": false, "width": Lino.chars2width(8), "editor": applies_from3974 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Fin pr\u00e9vue", "dataIndex": "applies_until", "hidden": false, "width": Lino.chars2width(8), "editor": applies_until3975 }, { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user3976 }, { "colIndex": 4, "sortable": true, "header": "Type de contrat", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type3977 }, { "width": Lino.chars2width(16), "colIndex": 5, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 6, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail_action'), "hidden": false, "editor": company3979, "dataIndex": "company" }, { "colIndex": 7, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "contact", "hidden": false, "editor": contact3980 }, { "colIndex": 8, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.AllClients.detail_action'), "hidden": false, "editor": person3981, "dataIndex": "person" }, { "colIndex": 9, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language3982 }, { "colIndex": 10, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9cid\u00e9 le", "dataIndex": "date_decided", "hidden": false, "width": Lino.chars2width(8), "editor": date_decided3983 }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9livr\u00e9 le", "dataIndex": "date_issued", "hidden": false, "width": Lino.chars2width(8), "editor": date_issued3984 }, { "colIndex": 12, "sortable": true, "header": "Responsable (SSG)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user_asd", "hidden": false, "editor": user_asd3985 }, { "colIndex": 13, "sortable": true, "header": "M\u00e9thode d'examination", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "exam_policy", "hidden": false, "editor": exam_policy3986 }, { "colIndex": 14, "sortable": true, "header": "Cause d'abandon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "ending", "hidden": false, "editor": ending3987 }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Abandon le", "dataIndex": "date_ended", "hidden": false, "width": Lino.chars2width(8), "editor": date_ended3988 }, { "colIndex": 16, "sortable": false, "header": "stages", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": stages3989, "dataIndex": "stages" }, { "colIndex": 17, "sortable": false, "header": "goals", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": goals3990, "dataIndex": "goals" }, { "colIndex": 18, "sortable": false, "header": "duties_asd", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": duties_asd3991, "dataIndex": "duties_asd" }, { "colIndex": 19, "sortable": false, "header": "duties_dsbe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": duties_dsbe3992, "dataIndex": "duties_dsbe" }, { "colIndex": 20, "sortable": false, "header": "duties_company", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": duties_company3993, "dataIndex": "duties_company" }, { "colIndex": 21, "sortable": false, "header": "duties_person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": duties_person3994, "dataIndex": "duties_person" } ];
    Lino.isip.Contracts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.insert_actionPanel = Ext.extend(Lino.isip.Contracts.DetailFormPanel,{
  empty_title: "Nouveau PIISs",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/isip/Contracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.Contracts.detail_action;
    this.ls_insert_handler = Lino.isip.Contracts.insert_action;
    Lino.isip.Contracts.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.isip.Contracts.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.isip.Contracts.insert_actionPanel(p);
});
Lino.isip.Contracts.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/isip/Contracts",pk,"duplicate_row");
};

Lino.isip.Contracts.detail_actionPanel = Ext.extend(Lino.isip.Contracts.DetailFormPanel,{
  empty_title: "D\u00e9tail PIISs",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Effacer la cache", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') } ],
  ls_url: "/isip/Contracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.Contracts.detail_action;
    this.ls_insert_handler = Lino.isip.Contracts.insert_action;
    Lino.isip.Contracts.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.isip.Contracts.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.isip.Contracts.detail_actionPanel(p);
});
Lino.isip.Contracts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.isip.Contracts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.PartnersHandle
Lino.pcsw.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/Partners",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Partners.detail_action;
    this.ls_insert_handler = Lino.pcsw.Partners.insert_action;
    var ww = this.containing_window;
    var name4018 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4019 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4020 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4021 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4022 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city4023 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var region4024 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var zip_code4025 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14026 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4027 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4028 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4029 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4030 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24031 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4032 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var url4033 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4034 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4035 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4036 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4037 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4038 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4039 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account14040 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24041 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id4042 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4023.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4023.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4024.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4022.on('change',Lino.chooser_handler(city4023,'country'));
      region4024.on('change',Lino.chooser_handler(city4023,'region'));
      country4022.on('change',Lino.chooser_handler(region4024,'country'));
      Lino.pcsw.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name4018 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email4019 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4022, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Endroit", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4023, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "R\u00e9gion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4024, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Code postal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4025 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr1", "hidden": false, "editor": addr14026 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4027 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street", "hidden": false, "editor": street4028 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_no", "hidden": false, "editor": street_no4029 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_box", "hidden": false, "editor": street_box4030 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr2", "hidden": false, "editor": addr24031 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4032 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "url", "hidden": false, "editor": url4033 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "phone", "hidden": false, "editor": phone4034 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "gsm", "hidden": false, "editor": gsm4035 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "fax", "hidden": false, "editor": fax4036 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4037, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsol\u00e8te", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4039 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14040 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24041 }, { "colIndex": 24, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4042, "dataIndex": "id" } ];
    Lino.pcsw.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Partners.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Nouveau partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Partners.detail_action;
    this.ls_insert_handler = Lino.pcsw.Partners.insert_action;
    Lino.pcsw.Partners.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Partners.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Partners.insert_actionPanel(p);
});

Lino.pcsw.Partners.detail_actionPanel = Ext.extend(Lino.pcsw.Partners.DetailFormPanel,{
  empty_title: "D\u00e9tail partners",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/pcsw/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Partners.detail_action;
    this.ls_insert_handler = Lino.pcsw.Partners.insert_action;
    Lino.pcsw.Partners.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Partners.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Partners.detail_actionPanel(p);
});
Lino.pcsw.Partners.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Partners.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcontacts.AllPartnersHandle
Lino.contacts.AllPartners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/AllPartners",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Alle partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.AllPartners.detail_action;
    this.ls_insert_handler = Lino.contacts.AllPartners.insert_action;
    var ww = this.containing_window;
    var name4069 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4070 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4071 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4072 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4073 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/AllPartners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city4074 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/AllPartners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var region4075 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/AllPartners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var zip_code4076 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14077 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4078 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4079 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4080 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4081 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24082 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4083 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var url4084 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4085 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4086 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4087 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4088 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4089 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4090 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/AllPartners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account14091 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24092 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id4093 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4074.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4074.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4075.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4073.on('change',Lino.chooser_handler(city4074,'country'));
      region4075.on('change',Lino.chooser_handler(city4074,'region'));
      country4073.on('change',Lino.chooser_handler(region4075,'country'));
      Lino.contacts.AllPartners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name4069 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email4070 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4073, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Endroit", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4074, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "R\u00e9gion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4075, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Code postal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4076 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr1", "hidden": false, "editor": addr14077 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4078 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street", "hidden": false, "editor": street4079 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_no", "hidden": false, "editor": street_no4080 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_box", "hidden": false, "editor": street_box4081 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr2", "hidden": false, "editor": addr24082 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4083 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "url", "hidden": false, "editor": url4084 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "phone", "hidden": false, "editor": phone4085 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "gsm", "hidden": false, "editor": gsm4086 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "fax", "hidden": false, "editor": fax4087 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4088, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsol\u00e8te", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4090 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14091 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24092 }, { "colIndex": 24, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4093, "dataIndex": "id" } ];
    Lino.contacts.AllPartners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.AllPartners.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Nouveau Alle partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/AllPartners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.AllPartners.detail_action;
    this.ls_insert_handler = Lino.contacts.AllPartners.insert_action;
    Lino.contacts.AllPartners.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.AllPartners.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.AllPartners.insert_actionPanel(p);
});

Lino.contacts.AllPartners.detail_actionPanel = Ext.extend(Lino.pcsw.Partners.DetailFormPanel,{
  empty_title: "D\u00e9tail Alle partners",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/AllPartners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.AllPartners.detail_action;
    this.ls_insert_handler = Lino.contacts.AllPartners.insert_action;
    Lino.contacts.AllPartners.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.AllPartners.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.AllPartners.detail_actionPanel(p);
});
Lino.contacts.AllPartners.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.AllPartners.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcontacts.CompaniesHandle
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Organisations",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" },'typeHidden', { "type": "float", "name": "hourly_rate" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 34,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 36,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail_action;
    this.ls_insert_handler = Lino.contacts.Companies.insert_action;
    var ww = this.containing_window;
    var name4120 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4121 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4122 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4123 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4124 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city4125 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var region4126 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var zip_code4127 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14128 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4129 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4130 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4131 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4132 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24133 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4134 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var url4135 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4136 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4137 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4138 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4139 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4140 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4141 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account14142 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24143 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix4144 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id4145 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type4146 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'organisation..." });
    var hourly_rate4147 = { "selectOnFocus": true, "decimalPrecision": 2, "xtype": "numberfield", "decimalSeparator": "," };
    var id4148 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4125.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4125.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4126.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4124.on('change',Lino.chooser_handler(city4125,'country'));
      region4126.on('change',Lino.chooser_handler(city4125,'region'));
      country4124.on('change',Lino.chooser_handler(region4126,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name4120 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email4121 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4124, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Endroit", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4125, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "R\u00e9gion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4126, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Code postal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4127 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr1", "hidden": false, "editor": addr14128 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4129 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street", "hidden": false, "editor": street4130 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_no", "hidden": false, "editor": street_no4131 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_box", "hidden": false, "editor": street_box4132 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr2", "hidden": false, "editor": addr24133 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4134 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "url", "hidden": false, "editor": url4135 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "phone", "hidden": false, "editor": phone4136 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "gsm", "hidden": false, "editor": gsm4137 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "fax", "hidden": false, "editor": fax4138 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4139, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsol\u00e8te", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4141 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14142 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24143 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "prefix", "hidden": false, "editor": prefix4144 }, { "colIndex": 25, "sortable": true, "header": "N\u00b0 de TVA", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "vat_id", "hidden": false, "editor": vat_id4145 }, { "colIndex": 26, "sortable": true, "header": "Type de soci\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type4146 }, { "colIndex": 27, "sortable": true, "xtype": "numbercolumn", "format": "0,00/i", "align": "right", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "hourly_rate", "header": "co\u00fbr horaire", "hidden": false, "editor": hourly_rate4147 }, { "colIndex": 28, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4148, "dataIndex": "id" } ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Nouveau Organisations",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail_action;
    this.ls_insert_handler = Lino.contacts.Companies.insert_action;
    Lino.contacts.Companies.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insert_actionPanel(p);
});

Lino.contacts.Companies.detail_actionPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "D\u00e9tail Organisations",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail_action;
    this.ls_insert_handler = Lino.contacts.Companies.insert_action;
    Lino.contacts.Companies.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detail_actionPanel(p);
});
Lino.contacts.Companies.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.AllClientsHandle
Lino.pcsw.AllClients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/AllClients",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "fiche eID", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Clients (tous)",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" },'aid_typeHidden', { "name": "coach1" },'coach1Hidden', { "name": "language" },'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 75,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.AllClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.AllClients.insert_action;
    var ww = this.containing_window;
    var name_column_disp4179 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var national_id4180 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gsm4181 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp4182 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp4183 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email4184 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone4185 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id4186 = { "selectOnFocus": true, "xtype": "numberfield" };
    var bank_account14187 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type4188 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/AllClients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'aide sociale..." });
    var coach14189 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var language4190 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(20), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Nom", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "NISS", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "national_id", "hidden": false, "editor": national_id4180 }, { "colIndex": 2, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gsm", "hidden": false, "editor": gsm4181 }, { "width": Lino.chars2width(30), "colIndex": 3, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "hidden": false, "editable": false }, { "width": Lino.chars2width(10), "colIndex": 4, "sortable": false, "dataIndex": "age", "header": "\u00c2ge", "hidden": false, "editable": false }, { "colIndex": 5, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email4184 }, { "colIndex": 6, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "phone", "hidden": false, "editor": phone4185 }, { "colIndex": 7, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4186, "dataIndex": "id" }, { "colIndex": 8, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14187 }, { "colIndex": 9, "sortable": true, "header": "Type d'aide sociale", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "aid_type", "hidden": false, "editor": aid_type4188 }, { "colIndex": 10, "sortable": true, "header": "Agent ISP", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "coach1", "hidden": false }, { "colIndex": 11, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "hidden": false, "editor": language4190 } ];
    Lino.pcsw.AllClients.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.AllClients.insert_actionPanel = Ext.extend(Lino.pcsw.AllClients.InsertFormPanel,{
  empty_title: "Nouveau Clients (tous)",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/AllClients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.AllClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.AllClients.insert_action;
    Lino.pcsw.AllClients.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.AllClients.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.AllClients.insert_actionPanel(p);
});

Lino.pcsw.AllClients.detail_actionPanel = Ext.extend(Lino.pcsw.AllClients.DetailFormPanel,{
  empty_title: "D\u00e9tail Clients (tous)",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "fiche eID", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') } ],
  ls_url: "/pcsw/AllClients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.AllClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.AllClients.insert_action;
    Lino.pcsw.AllClients.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.AllClients.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.AllClients.detail_actionPanel(p);
});
Lino.pcsw.AllClients.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.AllClients.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.ClientsHandle
Lino.pcsw.Clients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/Clients",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "fiche eID", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Clients",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" },'aid_typeHidden', { "name": "coach1" },'coach1Hidden', { "name": "language" },'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 75,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail_action;
    this.ls_insert_handler = Lino.pcsw.Clients.insert_action;
    var ww = this.containing_window;
    var name_column_disp4204 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var national_id4205 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gsm4206 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp4207 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp4208 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email4209 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone4210 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id4211 = { "selectOnFocus": true, "xtype": "numberfield" };
    var bank_account14212 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type4213 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'aide sociale..." });
    var coach14214 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var language4215 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(20), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Nom", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "NISS", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "national_id", "hidden": false, "editor": national_id4205 }, { "colIndex": 2, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gsm", "hidden": false, "editor": gsm4206 }, { "width": Lino.chars2width(30), "colIndex": 3, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "hidden": false, "editable": false }, { "width": Lino.chars2width(10), "colIndex": 4, "sortable": false, "dataIndex": "age", "header": "\u00c2ge", "hidden": false, "editable": false }, { "colIndex": 5, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email4209 }, { "colIndex": 6, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "phone", "hidden": false, "editor": phone4210 }, { "colIndex": 7, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4211, "dataIndex": "id" }, { "colIndex": 8, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14212 }, { "colIndex": 9, "sortable": true, "header": "Type d'aide sociale", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "aid_type", "hidden": false, "editor": aid_type4213 }, { "colIndex": 10, "sortable": true, "header": "Agent ISP", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "coach1", "hidden": false }, { "colIndex": 11, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "hidden": false, "editor": language4215 } ];
    Lino.pcsw.Clients.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.insert_actionPanel = Ext.extend(Lino.pcsw.AllClients.InsertFormPanel,{
  empty_title: "Nouveau Clients",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/Clients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail_action;
    this.ls_insert_handler = Lino.pcsw.Clients.insert_action;
    Lino.pcsw.Clients.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Clients.insert_actionPanel(p);
});

Lino.pcsw.Clients.detail_actionPanel = Ext.extend(Lino.pcsw.AllClients.DetailFormPanel,{
  empty_title: "D\u00e9tail Clients",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "fiche eID", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') } ],
  ls_url: "/pcsw/Clients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail_action;
    this.ls_insert_handler = Lino.pcsw.Clients.insert_action;
    Lino.pcsw.Clients.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Clients.detail_actionPanel(p);
});
Lino.pcsw.Clients.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Clients.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.MyClientsHandle
Lino.pcsw.MyClients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/MyClients",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "fiche eID", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Mes clients",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" },'aid_typeHidden', { "name": "coach1" },'coach1Hidden', { "name": "language" },'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 75,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.MyClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.MyClients.insert_action;
    var ww = this.containing_window;
    var name_column_disp4229 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var applies_from4230 = new Lino.DateField({ "disabled": true });
    var applies_until4231 = new Lino.DateField({ "disabled": true });
    var national_id4232 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gsm4233 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp4234 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp4235 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email4236 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone4237 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id4238 = { "selectOnFocus": true, "xtype": "numberfield" };
    var bank_account14239 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type4240 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyClients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'aide sociale..." });
    var coach14241 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var language4242 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(20), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Nom", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Contrat d\u00e9bute", "dataIndex": "applies_from", "hidden": false, "width": Lino.chars2width(8) }, { "colIndex": 2, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Contrat se termine", "dataIndex": "applies_until", "hidden": false, "width": Lino.chars2width(8) }, { "colIndex": 3, "sortable": true, "header": "NISS", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "national_id", "hidden": false, "editor": national_id4232 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gsm", "hidden": false, "editor": gsm4233 }, { "width": Lino.chars2width(30), "colIndex": 5, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "hidden": false, "editable": false }, { "width": Lino.chars2width(10), "colIndex": 6, "sortable": false, "dataIndex": "age", "header": "\u00c2ge", "hidden": false, "editable": false }, { "colIndex": 7, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email4236 }, { "colIndex": 8, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "phone", "hidden": false, "editor": phone4237 }, { "colIndex": 9, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4238, "dataIndex": "id" }, { "colIndex": 10, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14239 }, { "colIndex": 11, "sortable": true, "header": "Type d'aide sociale", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "aid_type", "hidden": false, "editor": aid_type4240 }, { "colIndex": 12, "sortable": true, "header": "Agent ISP", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "coach1", "hidden": false }, { "colIndex": 13, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "hidden": false, "editor": language4242 } ];
    Lino.pcsw.MyClients.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.MyClients.insert_actionPanel = Ext.extend(Lino.pcsw.AllClients.InsertFormPanel,{
  empty_title: "Nouveau Mes clients",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/MyClients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.MyClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.MyClients.insert_action;
    Lino.pcsw.MyClients.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.MyClients.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.MyClients.insert_actionPanel(p);
});

Lino.pcsw.MyClients.detail_actionPanel = Ext.extend(Lino.pcsw.AllClients.DetailFormPanel,{
  empty_title: "D\u00e9tail Mes clients",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "fiche eID", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') } ],
  ls_url: "/pcsw/MyClients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.MyClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.MyClients.insert_action;
    Lino.pcsw.MyClients.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.MyClients.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.MyClients.detail_actionPanel(p);
});
Lino.pcsw.MyClients.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.MyClients.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.MyActiveClientsHandle
Lino.pcsw.MyActiveClients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/MyActiveClients",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "fiche eID", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Clients",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" },'aid_typeHidden', { "name": "coach1" },'coach1Hidden', { "name": "language" },'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 75,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.MyActiveClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.MyActiveClients.insert_action;
    var ww = this.containing_window;
    var name_column_disp4258 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var applies_from4259 = new Lino.DateField({ "disabled": true });
    var applies_until4260 = new Lino.DateField({ "disabled": true });
    var national_id4261 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gsm4262 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp4263 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp4264 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email4265 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone4266 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id4267 = { "selectOnFocus": true, "xtype": "numberfield" };
    var bank_account14268 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type4269 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyActiveClients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'aide sociale..." });
    var coach14270 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var language4271 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(20), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Nom", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Contrat d\u00e9bute", "dataIndex": "applies_from", "hidden": false, "width": Lino.chars2width(8) }, { "colIndex": 2, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Contrat se termine", "dataIndex": "applies_until", "hidden": false, "width": Lino.chars2width(8) }, { "colIndex": 3, "sortable": true, "header": "NISS", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "national_id", "hidden": false, "editor": national_id4261 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gsm", "hidden": false, "editor": gsm4262 }, { "width": Lino.chars2width(30), "colIndex": 5, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "hidden": false, "editable": false }, { "width": Lino.chars2width(10), "colIndex": 6, "sortable": false, "dataIndex": "age", "header": "\u00c2ge", "hidden": false, "editable": false }, { "colIndex": 7, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email4265 }, { "colIndex": 8, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "phone", "hidden": false, "editor": phone4266 }, { "colIndex": 9, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4267, "dataIndex": "id" }, { "colIndex": 10, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14268 }, { "colIndex": 11, "sortable": true, "header": "Type d'aide sociale", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "aid_type", "hidden": false, "editor": aid_type4269 }, { "colIndex": 12, "sortable": true, "header": "Agent ISP", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "coach1", "hidden": false }, { "colIndex": 13, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "hidden": false, "editor": language4271 } ];
    Lino.pcsw.MyActiveClients.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.MyActiveClients.insert_actionPanel = Ext.extend(Lino.pcsw.AllClients.InsertFormPanel,{
  empty_title: "Nouveau Clients",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/MyActiveClients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.MyActiveClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.MyActiveClients.insert_action;
    Lino.pcsw.MyActiveClients.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.MyActiveClients.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.MyActiveClients.insert_actionPanel(p);
});

Lino.pcsw.MyActiveClients.detail_actionPanel = Ext.extend(Lino.pcsw.AllClients.DetailFormPanel,{
  empty_title: "D\u00e9tail Clients",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "fiche eID", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') } ],
  ls_url: "/pcsw/MyActiveClients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.MyActiveClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.MyActiveClients.insert_action;
    Lino.pcsw.MyActiveClients.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.MyActiveClients.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.MyActiveClients.detail_actionPanel(p);
});
Lino.pcsw.MyActiveClients.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.MyActiveClients.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.PersonSearchesHandle
Lino.pcsw.PersonSearches.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/PersonSearches",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_suchliste", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_suchliste') }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Recherches de personnes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "title" }, { "type": "int", "name": "aged_from" }, { "type": "int", "name": "aged_to" }, { "name": "gender" },'genderHidden', { "type": "boolean", "name": "only_my_persons" }, { "name": "coached_by" },'coached_byHidden', { "type": "date", "name": "period_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "period_until", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 79,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.PersonSearches.detail_action;
    this.ls_insert_handler = Lino.pcsw.PersonSearches.insert_action;
    var ww = this.containing_window;
    var id4348 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user4349 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/PersonSearches/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var title4350 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var aged_from4351 = { "selectOnFocus": true, "xtype": "numberfield" };
    var aged_to4352 = { "selectOnFocus": true, "xtype": "numberfield" };
    var gender4353 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ] });
    var only_my_persons4354 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var coached_by4355 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/PersonSearches/coached_by", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var period_from4356 = new Lino.DateField({ "selectOnFocus": true });
    var period_until4357 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4348, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user4349 }, { "colIndex": 2, "sortable": true, "header": "Intitul\u00e9 de la recherche", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "title", "hidden": false, "editor": title4350 }, { "colIndex": 3, "sortable": true, "header": "Age: de", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "aged_from", "hidden": false, "editor": aged_from4351 }, { "colIndex": 4, "sortable": true, "header": "Age: jusque", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "aged_to", "hidden": false, "editor": aged_to4352 }, { "colIndex": 5, "sortable": true, "header": "Sexe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "gender", "hidden": false, "editor": gender4353 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Only my clients", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "only_my_persons", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "AI", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "coached_by", "hidden": false, "editor": coached_by4355 }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "P\u00e9riode du", "dataIndex": "period_from", "hidden": false, "width": Lino.chars2width(8), "editor": period_from4356 }, { "colIndex": 9, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "jusque", "dataIndex": "period_until", "hidden": false, "width": Lino.chars2width(8), "editor": period_until4357 } ];
    Lino.pcsw.PersonSearches.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.PersonSearches.insert_actionPanel = Ext.extend(Lino.pcsw.PersonSearches.DetailFormPanel,{
  empty_title: "Nouveau Recherches de personnes",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/PersonSearches",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.PersonSearches.detail_action;
    this.ls_insert_handler = Lino.pcsw.PersonSearches.insert_action;
    Lino.pcsw.PersonSearches.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.PersonSearches.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.PersonSearches.insert_actionPanel(p);
});

Lino.pcsw.PersonSearches.detail_actionPanel = Ext.extend(Lino.pcsw.PersonSearches.DetailFormPanel,{
  empty_title: "D\u00e9tail Recherches de personnes",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_suchliste", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_suchliste') } ],
  ls_url: "/pcsw/PersonSearches",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.PersonSearches.detail_action;
    this.ls_insert_handler = Lino.pcsw.PersonSearches.insert_action;
    Lino.pcsw.PersonSearches.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.PersonSearches.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.PersonSearches.detail_actionPanel(p);
});
Lino.pcsw.PersonSearches.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.PersonSearches.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.OverlappingContractsHandle
Lino.pcsw.OverlappingContracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/OverlappingContracts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "contrats chevauchants",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "birth_date" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "title" }, { "name": "gender" },'genderHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    var ww = this.containing_window;
    var id4369 = { "selectOnFocus": true, "xtype": "numberfield" };
    var created4370 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4371 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4372 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city4373 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var region4374 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var zip_code4375 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name4376 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr14377 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4378 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4379 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4380 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4381 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24382 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4383 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var email4384 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url4385 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4386 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4387 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4388 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4389 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4390 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4391 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account14392 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24393 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var birth_date4394 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var first_name4395 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name4396 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var title4397 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender4398 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "M", "Masculin" ], [ "F", "F\u00e9minin" ] ] });
    this.before_row_edit = function(record) {
      city4373.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4373.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4374.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4372.on('change',Lino.chooser_handler(city4373,'country'));
      region4374.on('change',Lino.chooser_handler(city4373,'region'));
      country4372.on('change',Lino.chooser_handler(region4374,'country'));
      Lino.pcsw.OverlappingContracts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4369, "dataIndex": "id" }, { "width": Lino.chars2width(16), "colIndex": 1, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 3, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4372, "dataIndex": "country" }, { "colIndex": 4, "sortable": true, "header": "Endroit", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4373, "dataIndex": "city" }, { "colIndex": 5, "sortable": true, "header": "R\u00e9gion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4374, "dataIndex": "region" }, { "colIndex": 6, "sortable": true, "header": "Code postal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4375 }, { "colIndex": 7, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name4376 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr1", "hidden": false, "editor": addr14377 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4378 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street", "hidden": false, "editor": street4379 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_no", "hidden": false, "editor": street_no4380 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_box", "hidden": false, "editor": street_box4381 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr2", "hidden": false, "editor": addr24382 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4383 }, { "colIndex": 15, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email4384 }, { "colIndex": 16, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "url", "hidden": false, "editor": url4385 }, { "colIndex": 17, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "phone", "hidden": false, "editor": phone4386 }, { "colIndex": 18, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "gsm", "hidden": false, "editor": gsm4387 }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "fax", "hidden": false, "editor": fax4388 }, { "colIndex": 20, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4389, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": false, "xtype": "checkcolumn", "header": "obsol\u00e8te", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 22, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4391 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14392 }, { "colIndex": 24, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24393 }, { "colIndex": 25, "sortable": true, "header": "Date de naissance", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "birth_date", "hidden": false, "editor": birth_date4394 }, { "colIndex": 26, "sortable": true, "header": "Pr\u00e9nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "first_name", "hidden": false, "editor": first_name4395 }, { "colIndex": 27, "sortable": true, "header": "Nom de famille", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "last_name", "hidden": false, "editor": last_name4396 }, { "colIndex": 28, "sortable": true, "header": "Allocution", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "title", "hidden": false, "editor": title4397 }, { "colIndex": 29, "sortable": true, "header": "Sexe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "gender", "hidden": false, "editor": gender4398 } ];
    Lino.pcsw.OverlappingContracts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.OverlappingContracts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.OverlappingContracts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.ProjectContactsHandle
Lino.pcsw.ProjectContacts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/ProjectContacts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Contacts",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "project" },'projectHidden', { "name": "company" },'companyHidden', { "name": "contact" },'contactHidden', { "name": "type" },'typeHidden', { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 77,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var id4430 = { "selectOnFocus": true, "xtype": "numberfield" };
    var project4431 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ProjectContacts/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var company4432 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ProjectContacts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var contact4433 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/ProjectContacts/contact", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Personne de contact..." });
    var type4434 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Caisse d'assurance maladie" ], [ "20", "Pharmacie" ], [ "30", "Attorney" ], [ "40", "Job office" ], [ "90", "Other" ] ] });
    var remark4435 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      contact4433.setContextValue('company',record ? record.data['companyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      company4432.on('change',Lino.chooser_handler(contact4433,'company'));
      Lino.pcsw.ProjectContacts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4430, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.AllClients.detail_action'), "hidden": false, "editor": project4431, "dataIndex": "project" }, { "colIndex": 2, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail_action'), "hidden": false, "editor": company4432, "dataIndex": "company" }, { "colIndex": 3, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "contact", "hidden": false, "editor": contact4433 }, { "colIndex": 4, "sortable": true, "header": "Project Contact type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "type", "hidden": false, "editor": type4434 }, { "colIndex": 5, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark4435, "dataIndex": "remark" } ];
    Lino.pcsw.ProjectContacts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.ProjectContacts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.ProjectContacts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.CoachingsHandle
Lino.pcsw.Coachings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pcsw/Coachings",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Coachings",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "project" },'projectHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "type" },'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 76,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id4443 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user4444 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var project4445 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Coachings/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Client..." });
    var start_date4446 = new Lino.DateField({ "selectOnFocus": true });
    var end_date4447 = new Lino.DateField({ "selectOnFocus": true });
    var type4448 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": [ [ "10", "Primary coach" ], [ "20", "Secondary coach" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4443, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Coach", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user4444 }, { "colIndex": 2, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.AllClients.detail_action'), "hidden": false, "editor": project4445, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Accompagn\u00e9 depuis", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date4446 }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "jusque", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date4447 }, { "colIndex": 5, "sortable": true, "header": "Coaching type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "type", "hidden": false, "editor": type4448 } ];
    Lino.pcsw.Coachings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Coachings.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Coachings.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIjobs.JobProvidersHandle
Lino.jobs.JobProviders.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/JobProviders",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Employants",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" },'typeHidden', { "type": "float", "name": "hourly_rate" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 34,
  ls_grid_configs : [  ],
  content_type : 57,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 36,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.JobProviders.detail_action;
    this.ls_insert_handler = Lino.jobs.JobProviders.insert_action;
    var ww = this.containing_window;
    var name4474 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4475 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4476 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4477 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4478 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city4479 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var region4480 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var zip_code4481 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14482 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4483 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4484 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4485 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4486 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24487 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4488 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var url4489 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4490 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4491 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4492 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4493 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4494 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4495 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Activit\u00e9..." });
    var bank_account14496 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24497 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix4498 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id4499 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type4500 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'organisation..." });
    var hourly_rate4501 = { "selectOnFocus": true, "decimalPrecision": 2, "xtype": "numberfield", "decimalSeparator": "," };
    var id4502 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4479.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4479.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4480.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4478.on('change',Lino.chooser_handler(city4479,'country'));
      region4480.on('change',Lino.chooser_handler(city4479,'region'));
      country4478.on('change',Lino.chooser_handler(region4480,'country'));
      Lino.jobs.JobProviders.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name4474 }, { "colIndex": 1, "sortable": true, "header": "E-mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "email", "hidden": false, "editor": email4475 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4478, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Endroit", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4479, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "R\u00e9gion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4480, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Code postal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4481 }, { "colIndex": 8, "sortable": true, "header": "Ligne avant le nom de rue", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr1", "hidden": false, "editor": addr14482 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e9fixe rue", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4483 }, { "colIndex": 10, "sortable": true, "header": "Rue", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "street", "hidden": false, "editor": street4484 }, { "colIndex": 11, "sortable": true, "header": "N\u00b0", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_no", "hidden": false, "editor": street_no4485 }, { "colIndex": 12, "sortable": true, "header": "bo\u00eete", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "street_box", "hidden": false, "editor": street_box4486 }, { "colIndex": 13, "sortable": true, "header": "Ligne apr\u00e8s le nom de rue", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "addr2", "hidden": false, "editor": addr24487 }, { "colIndex": 14, "sortable": true, "header": "Langue", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4488 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "url", "hidden": false, "editor": url4489 }, { "colIndex": 16, "sortable": true, "header": "T\u00e9l\u00e9phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "phone", "hidden": false, "editor": phone4490 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "gsm", "hidden": false, "editor": gsm4491 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "fax", "hidden": false, "editor": fax4492 }, { "colIndex": 19, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4493, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "obsol\u00e8te", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4495 }, { "colIndex": 22, "sortable": true, "header": "Compte en banque 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14496 }, { "colIndex": 23, "sortable": true, "header": "Compte en banque 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24497 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "prefix", "hidden": false, "editor": prefix4498 }, { "colIndex": 25, "sortable": true, "header": "N\u00b0 de TVA", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "vat_id", "hidden": false, "editor": vat_id4499 }, { "colIndex": 26, "sortable": true, "header": "Type de soci\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type4500 }, { "colIndex": 27, "sortable": true, "xtype": "numbercolumn", "format": "0,00/i", "align": "right", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "hourly_rate", "header": "co\u00fbr horaire", "hidden": false, "editor": hourly_rate4501 }, { "colIndex": 28, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4502, "dataIndex": "id" } ];
    Lino.jobs.JobProviders.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobProviders.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Nouveau Employants",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/jobs/JobProviders",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.JobProviders.detail_action;
    this.ls_insert_handler = Lino.jobs.JobProviders.insert_action;
    Lino.jobs.JobProviders.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.JobProviders.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.jobs.JobProviders.insert_actionPanel(p);
});

Lino.jobs.JobProviders.detail_actionPanel = Ext.extend(Lino.jobs.JobProviders.DetailFormPanel,{
  empty_title: "D\u00e9tail Employants",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/jobs/JobProviders",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.JobProviders.detail_action;
    this.ls_insert_handler = Lino.jobs.JobProviders.insert_action;
    Lino.jobs.JobProviders.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.JobProviders.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.JobProviders.detail_actionPanel(p);
});
Lino.jobs.JobProviders.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.JobProviders.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIjobs.ContractsHandle
Lino.jobs.Contracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/Contracts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Effacer la cache", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Contrats de travail",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "job" },'jobHidden', { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "user" },'userHidden', { "name": "type" },'typeHidden', { "name": "build_time" }, { "name": "company" },'companyHidden', { "name": "contact" },'contactHidden', { "name": "person" },'personHidden', { "name": "language" },'languageHidden', { "type": "date", "name": "date_decided", "dateFormat": "d.m.Y" }, { "type": "date", "name": "date_issued", "dateFormat": "d.m.Y" }, { "name": "user_asd" },'user_asdHidden', { "name": "exam_policy" },'exam_policyHidden', { "name": "ending" },'endingHidden', { "type": "date", "name": "date_ended", "dateFormat": "d.m.Y" }, { "type": "int", "name": "duration" }, { "name": "regime" },'regimeHidden', { "name": "schedule" },'scheduleHidden', { "type": "float", "name": "hourly_rate" }, { "name": "refund_rate" }, { "name": "reference_person" }, { "name": "responsibilities" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 52,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 38,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Contracts.detail_action;
    this.ls_insert_handler = Lino.jobs.Contracts.insert_action;
    var ww = this.containing_window;
    var id4574 = { "selectOnFocus": true, "xtype": "numberfield" };
    var job4575 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Emploi..." });
    var applies_from4576 = new Lino.DateField({ "selectOnFocus": true });
    var applies_until4577 = new Lino.DateField({ "selectOnFocus": true });
    var user4578 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var type4579 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de contrat de travail..." });
    var build_time4580 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var company4581 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var contact4582 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Personne de contact..." });
    var person4583 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Client..." });
    var language4584 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var date_decided4585 = new Lino.DateField({ "selectOnFocus": true });
    var date_issued4586 = new Lino.DateField({ "selectOnFocus": true });
    var user_asd4587 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user_asd", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var exam_policy4588 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/exam_policy", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir M\u00e9thode d'examination..." });
    var ending4589 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Rupture/fin de contrat..." });
    var date_ended4590 = new Lino.DateField({ "selectOnFocus": true });
    var duration4591 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/duration", "method": "GET" }) }), "value": null });
    var regime4592 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/regime", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir R\u00e9gime de travail..." });
    var schedule4593 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/schedule", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Horaire..." });
    var hourly_rate4594 = { "selectOnFocus": true, "decimalPrecision": 2, "xtype": "numberfield", "decimalSeparator": "," };
    var refund_rate4595 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/refund_rate", "method": "GET" }) }) });
    var reference_person4596 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var responsibilities4597 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "responsabilit\u00e9s" });
    var remark4598 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      contact4582.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      responsibilities4597.refresh();
    };
    this.onRender = function(ct, position) {
      company4581.on('change',Lino.chooser_handler(contact4582,'company'));
      Lino.jobs.Contracts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4574, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Emploi", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('jobHidden','Lino.jobs.Jobs.detail_action'), "hidden": false, "editor": job4575, "dataIndex": "job" }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9but de contrat", "dataIndex": "applies_from", "hidden": false, "width": Lino.chars2width(8), "editor": applies_from4576 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Fin pr\u00e9vue", "dataIndex": "applies_until", "hidden": false, "width": Lino.chars2width(8), "editor": applies_until4577 }, { "colIndex": 4, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user4578 }, { "colIndex": 5, "sortable": true, "header": "Type de contrat", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type4579 }, { "width": Lino.chars2width(16), "colIndex": 6, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 7, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail_action'), "hidden": false, "editor": company4581, "dataIndex": "company" }, { "colIndex": 8, "sortable": true, "header": "repr\u00e9sent\u00e9 par", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "contact", "hidden": false, "editor": contact4582 }, { "colIndex": 9, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.AllClients.detail_action'), "hidden": false, "editor": person4583, "dataIndex": "person" }, { "colIndex": 10, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4584 }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9cid\u00e9 le", "dataIndex": "date_decided", "hidden": false, "width": Lino.chars2width(8), "editor": date_decided4585 }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9livr\u00e9 le", "dataIndex": "date_issued", "hidden": false, "width": Lino.chars2width(8), "editor": date_issued4586 }, { "colIndex": 13, "sortable": true, "header": "Responsable (SSG)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user_asd", "hidden": false, "editor": user_asd4587 }, { "colIndex": 14, "sortable": true, "header": "M\u00e9thode d'examination", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "exam_policy", "hidden": false, "editor": exam_policy4588 }, { "colIndex": 15, "sortable": true, "header": "Cause d'abandon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "ending", "hidden": false, "editor": ending4589 }, { "colIndex": 16, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Abandon le", "dataIndex": "date_ended", "hidden": false, "width": Lino.chars2width(8), "editor": date_ended4590 }, { "colIndex": 17, "sortable": true, "header": "dur\u00e9e (jours)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "duration", "hidden": false, "editor": duration4591 }, { "colIndex": 18, "sortable": true, "header": "R\u00e9gime de travail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "regime", "hidden": false, "editor": regime4592 }, { "colIndex": 19, "sortable": true, "header": "Horaire", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "schedule", "hidden": false, "editor": schedule4593 }, { "colIndex": 20, "sortable": true, "xtype": "numbercolumn", "format": "0,00/i", "align": "right", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "hourly_rate", "header": "co\u00fbr horaire", "hidden": false, "editor": hourly_rate4594 }, { "colIndex": 21, "sortable": true, "header": "tarif de remboursement", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "refund_rate", "hidden": false, "editor": refund_rate4595 }, { "colIndex": 22, "sortable": true, "header": "persone de r\u00e9f\u00e9rence", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "reference_person", "hidden": false, "editor": reference_person4596 }, { "colIndex": 23, "sortable": false, "header": "responsibilities", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": responsibilities4597, "dataIndex": "responsibilities" }, { "colIndex": 24, "sortable": false, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark4598, "dataIndex": "remark" } ];
    Lino.jobs.Contracts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.insert_actionPanel = Ext.extend(Lino.jobs.Contracts.DetailFormPanel,{
  empty_title: "Nouveau Contrats de travail",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/jobs/Contracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Contracts.detail_action;
    this.ls_insert_handler = Lino.jobs.Contracts.insert_action;
    Lino.jobs.Contracts.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Contracts.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.jobs.Contracts.insert_actionPanel(p);
});
Lino.jobs.Contracts.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/jobs/Contracts",pk,"duplicate_row");
};

Lino.jobs.Contracts.detail_actionPanel = Ext.extend(Lino.jobs.Contracts.DetailFormPanel,{
  empty_title: "D\u00e9tail Contrats de travail",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Effacer la cache", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') } ],
  ls_url: "/jobs/Contracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Contracts.detail_action;
    this.ls_insert_handler = Lino.jobs.Contracts.insert_action;
    Lino.jobs.Contracts.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Contracts.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Contracts.detail_actionPanel(p);
});
Lino.jobs.Contracts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Contracts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIjobs.OffersHandle
Lino.jobs.Offers.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/Offers",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Offres d'emploi",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "sector" },'sectorHidden', { "name": "function" },'functionHidden', { "name": "name" }, { "name": "provider" },'providerHidden', { "type": "date", "name": "selection_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "selection_until", "dateFormat": "d.m.Y" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 56,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Offers.detail_action;
    this.ls_insert_handler = Lino.jobs.Offers.insert_action;
    var ww = this.containing_window;
    var id4625 = { "selectOnFocus": true, "xtype": "numberfield" };
    var sector4626 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Secteur d'activit\u00e9..." });
    var function4627 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var name4628 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var provider4629 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/provider", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Employant..." });
    var selection_from4630 = new Lino.DateField({ "selectOnFocus": true });
    var selection_until4631 = new Lino.DateField({ "selectOnFocus": true });
    var start_date4632 = new Lino.DateField({ "selectOnFocus": true });
    var remark4633 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      function4627.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector4626.on('change',Lino.chooser_handler(function4627,'sector'));
      Lino.jobs.Offers.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4625, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Secteur d'activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "sector", "hidden": false, "editor": sector4626 }, { "colIndex": 2, "sortable": true, "header": "Fonction", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "function", "hidden": false, "editor": function4627 }, { "colIndex": 3, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name4628 }, { "colIndex": 4, "sortable": true, "header": "Employant", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('providerHidden','Lino.jobs.JobProviders.detail_action'), "hidden": false, "editor": provider4629, "dataIndex": "provider" }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "D\u00e9but de s\u00e9lection", "dataIndex": "selection_from", "hidden": false, "width": Lino.chars2width(8), "editor": selection_from4630 }, { "colIndex": 6, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Fin de s\u00e9lection", "dataIndex": "selection_until", "hidden": false, "width": Lino.chars2width(8), "editor": selection_until4631 }, { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date de d\u00e9but", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date4632 }, { "colIndex": 8, "sortable": false, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark4633, "dataIndex": "remark" } ];
    Lino.jobs.Offers.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Offers.insert_actionPanel = Ext.extend(Lino.jobs.Offers.DetailFormPanel,{
  empty_title: "Nouveau Offres d'emploi",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/jobs/Offers",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Offers.detail_action;
    this.ls_insert_handler = Lino.jobs.Offers.insert_action;
    Lino.jobs.Offers.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Offers.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.jobs.Offers.insert_actionPanel(p);
});

Lino.jobs.Offers.detail_actionPanel = Ext.extend(Lino.jobs.Offers.DetailFormPanel,{
  empty_title: "D\u00e9tail Offres d'emploi",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/jobs/Offers",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Offers.detail_action;
    this.ls_insert_handler = Lino.jobs.Offers.insert_action;
    Lino.jobs.Offers.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Offers.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Offers.detail_actionPanel(p);
});
Lino.jobs.Offers.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Offers.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIjobs.StudyTypesHandle
Lino.jobs.StudyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/StudyTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Type d'\u00e9tudes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 63,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var id4644 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name4645 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr4646 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en4647 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4644, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name4645 }, { "colIndex": 2, "sortable": true, "header": "Description (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_fr", "hidden": false, "editor": name_fr4646 }, { "colIndex": 3, "sortable": true, "header": "Description (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name_en", "hidden": false, "editor": name_en4647 } ];
    Lino.jobs.StudyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.StudyTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.StudyTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIjobs.StudiesHandle
Lino.jobs.Studies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/Studies",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "\u00c9tudes & formations",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "person" },'personHidden', { "name": "type" },'typeHidden', { "name": "content" }, { "type": "date", "name": "started", "dateFormat": "d.m.Y" }, { "type": "date", "name": "stopped", "dateFormat": "d.m.Y" }, { "type": "boolean", "name": "success" }, { "name": "language" },'languageHidden', { "name": "school" }, { "name": "remarks" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 62,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    var ww = this.containing_window;
    var id4653 = { "selectOnFocus": true, "xtype": "numberfield" };
    var country4654 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Studies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var city4655 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Studies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var person4656 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Studies/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Client..." });
    var type4657 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Studies/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Type d'\u00e9tude..." });
    var content4658 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var started4659 = new Lino.DateField({ "selectOnFocus": true, "format": "m/Y", "plugins": "monthPickerPlugin" });
    var stopped4660 = new Lino.DateField({ "selectOnFocus": true, "format": "m/Y", "plugins": "monthPickerPlugin" });
    var success4661 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var language4662 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Studies/language", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Langue..." });
    var school4663 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4664 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      city4655.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4654.on('change',Lino.chooser_handler(city4655,'country'));
      Lino.jobs.Studies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4653, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4654, "dataIndex": "country" }, { "colIndex": 2, "sortable": true, "header": "Endroit", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4655, "dataIndex": "city" }, { "colIndex": 3, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.AllClients.detail_action'), "hidden": false, "editor": person4656, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "header": "Type d'\u00e9tudes", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type4657 }, { "colIndex": 5, "sortable": true, "header": "Contenu des \u00e9tudes", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "content", "hidden": false, "editor": content4658 }, { "colIndex": 6, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "commenc\u00e9", "dataIndex": "started", "hidden": false, "width": Lino.chars2width(8), "editor": started4659 }, { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "arr\u00eat\u00e9", "dataIndex": "stopped", "hidden": false, "width": Lino.chars2width(8), "editor": stopped4660 }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "Succ\u00e8s", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "success", "hidden": false }, { "colIndex": 9, "sortable": true, "header": "Langue", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4662 }, { "colIndex": 10, "sortable": true, "header": "Ecole", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "school", "hidden": false, "editor": school4663 }, { "colIndex": 11, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4664, "dataIndex": "remarks" } ];
    Lino.jobs.Studies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Studies.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Studies.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIjobs.ExperiencesHandle
Lino.jobs.Experiences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/Experiences",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Exp\u00e9riences professionnelles",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "sector" },'sectorHidden', { "name": "function" },'functionHidden', { "name": "person" },'personHidden', { "name": "company" }, { "name": "title" }, { "name": "country" },'countryHidden', { "type": "date", "name": "started", "dateFormat": "d.m.Y" }, { "type": "date", "name": "stopped", "dateFormat": "d.m.Y" }, { "name": "remarks" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 54,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    var ww = this.containing_window;
    var id4678 = { "selectOnFocus": true, "xtype": "numberfield" };
    var sector4679 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Experiences/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Secteur d'activit\u00e9..." });
    var function4680 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Experiences/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var person4681 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Experiences/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Client..." });
    var company4682 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var title4683 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var country4684 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Experiences/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Pays..." });
    var started4685 = new Lino.DateField({ "selectOnFocus": true, "format": "m/Y", "plugins": "monthPickerPlugin" });
    var stopped4686 = new Lino.DateField({ "selectOnFocus": true, "format": "m/Y", "plugins": "monthPickerPlugin" });
    var remarks4687 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      function4680.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector4679.on('change',Lino.chooser_handler(function4680,'sector'));
      Lino.jobs.Experiences.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4678, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Secteur d'activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "sector", "hidden": false, "editor": sector4679 }, { "colIndex": 2, "sortable": true, "header": "Fonction", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "function", "hidden": false, "editor": function4680 }, { "colIndex": 3, "sortable": true, "header": "Client", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.AllClients.detail_action'), "hidden": false, "editor": person4681, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "header": "Soci\u00e9t\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "company", "hidden": false, "editor": company4682 }, { "colIndex": 5, "sortable": true, "header": "Intitul\u00e9 de la fonction", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "title", "hidden": false, "editor": title4683 }, { "colIndex": 6, "sortable": true, "header": "Pays", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4684, "dataIndex": "country" }, { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "commenc\u00e9", "dataIndex": "started", "hidden": false, "width": Lino.chars2width(8), "editor": started4685 }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "arr\u00eat\u00e9", "dataIndex": "stopped", "hidden": false, "width": Lino.chars2width(8), "editor": stopped4686 }, { "colIndex": 9, "sortable": false, "header": "Remarques", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4687, "dataIndex": "remarks" } ];
    Lino.jobs.Experiences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Experiences.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Experiences.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIjobs.JobsHandle
Lino.jobs.Jobs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/Jobs",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Emplois",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "provider" },'providerHidden', { "name": "sector" },'sectorHidden', { "name": "function" },'functionHidden', { "name": "type" },'typeHidden', { "name": "contract_type" },'contract_typeHidden', { "type": "float", "name": "hourly_rate" }, { "type": "int", "name": "capacity" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 14,
  ls_grid_configs : [  ],
  content_type : 50,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Jobs.detail_action;
    this.ls_insert_handler = Lino.jobs.Jobs.insert_action;
    var ww = this.containing_window;
    var name4714 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var provider4715 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/provider", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Employant..." });
    var sector4716 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/sector", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Secteur d'activit\u00e9..." });
    var function4717 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/function", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Fonction..." });
    var type4718 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type d'emploi..." });
    var contract_type4719 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/contract_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de contrat de travail..." });
    var hourly_rate4720 = { "selectOnFocus": true, "decimalPrecision": 2, "xtype": "numberfield", "decimalSeparator": "," };
    var capacity4721 = { "selectOnFocus": true, "xtype": "numberfield", "value": 1, "allowBlank": false };
    var remark4722 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id4723 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      function4717.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      sector4716.on('change',Lino.chooser_handler(function4717,'sector'));
      Lino.jobs.Jobs.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Nom", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "name", "hidden": false, "editor": name4714 }, { "colIndex": 1, "sortable": true, "header": "Employant", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('providerHidden','Lino.jobs.JobProviders.detail_action'), "hidden": false, "editor": provider4715, "dataIndex": "provider" }, { "colIndex": 2, "sortable": true, "header": "Secteur d'activit\u00e9", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "sector", "hidden": false, "editor": sector4716 }, { "colIndex": 3, "sortable": true, "header": "Fonction", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "function", "hidden": false, "editor": function4717 }, { "colIndex": 4, "sortable": true, "header": "Type d'emploi", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type4718 }, { "colIndex": 5, "sortable": true, "header": "Type de contrat", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "contract_type", "hidden": false, "editor": contract_type4719 }, { "colIndex": 6, "sortable": true, "xtype": "numbercolumn", "format": "0,00/i", "align": "right", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "hourly_rate", "header": "co\u00fbr horaire", "hidden": false, "editor": hourly_rate4720 }, { "colIndex": 7, "sortable": true, "header": "Capacit\u00e9", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "capacity", "hidden": false, "editor": capacity4721 }, { "colIndex": 8, "sortable": false, "header": "Remarque", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark4722, "dataIndex": "remark" }, { "colIndex": 9, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4723, "dataIndex": "id" } ];
    Lino.jobs.Jobs.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Jobs.insert_actionPanel = Ext.extend(Lino.jobs.Jobs.DetailFormPanel,{
  empty_title: "Nouveau Emplois",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Cr\u00e9er", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/jobs/Jobs",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Jobs.detail_action;
    this.ls_insert_handler = Lino.jobs.Jobs.insert_action;
    Lino.jobs.Jobs.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Jobs.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.jobs.Jobs.insert_actionPanel(p);
});

Lino.jobs.Jobs.detail_actionPanel = Ext.extend(Lino.jobs.Jobs.DetailFormPanel,{
  empty_title: "D\u00e9tail Emplois",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Enregistrer", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/jobs/Jobs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.Jobs.detail_action;
    this.ls_insert_handler = Lino.jobs.Jobs.insert_action;
    Lino.jobs.Jobs.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.jobs.Jobs.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Jobs.detail_actionPanel(p);
});
Lino.jobs.Jobs.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.jobs.Jobs.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIjobs.ContractsSearchHandle
Lino.jobs.ContractsSearch.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/jobs/ContractsSearch",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Supprimer", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Effacer la cache", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Nouveau", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Imprimer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Dupliquer", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "D\u00e9tail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Recherche contrats de travail",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "job" },'jobHidden', { "name": "person" },'personHidden', { "name": "person__city" },'person__cityHidden', { "name": "person__national_id" }, { "name": "person__gender" },'person__genderHidden', { "name": "user" },'userHidden', { "name": "type" },'typeHidden', { "name": "build_time" }, { "name": "company" },'companyHidden', { "name": "contact" },'contactHidden', { "name": "language" },'languageHidden', { "type": "date", "name": "date_decided", "dateFormat": "d.m.Y" }, { "type": "date", "name": "date_issued", "dateFormat": "d.m.Y" }, { "name": "user_asd" },'user_asdHidden', { "name": "exam_policy" },'exam_policyHidden', { "name": "ending" },'endingHidden', { "type": "date", "name": "date_ended", "dateFormat": "d.m.Y" }, { "type": "int", "name": "duration" }, { "name": "regime" },'regimeHidden', { "name": "schedule" },'scheduleHidden', { "type": "float", "name": "hourly_rate" }, { "name": "refund_rate" }, { "name": "reference_person" }, { "name": "responsibilities" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 52,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 43,
  initComponent : function() {
    this.ls_detail_handler = Lino.jobs.ContractsSearch.detail_action;
    this.ls_insert_handler = Lino.jobs.ContractsSearch.insert_action;
    var ww = this.containing_window;
    var id4744 = { "selectOnFocus": true, "xtype": "numberfield" };
    var applies_from4745 = new Lino.DateField({ "selectOnFocus": true });
    var applies_until4746 = new Lino.DateField({ "selectOnFocus": true });
    var job4747 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractsSearch/job", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Emploi..." });
    var person4748 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractsSearch/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Choisir Client..." });
    var person__city4749 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Choisir Endroit..." });
    var person__national_id4750 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var person__gender4751 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(1), "maxLength": 1 });
    var user4752 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractsSearch/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Utilisateur..." });
    var type4753 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractsSearch/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Type de contrat de travail..." });
    var build_time4754 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var company4755 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractsSearch/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Organisation..." });
    var contact4756 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/ContractsSearch/contact", "method": "GET" }) }), "pageSize": 20, "emptyText": "Choisir Personne de contact..." });
    var language4757 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Allemand" ], [ "fr", "Fran\u00e7ais" ], [ "en", "Anglais" ] ], "allowBlank": false, "value": "de" });
    var date_decided4758 = new Lino.DateField({ "selectOnFocus": true });
    var date_issued4759 = new Lino.DateField({ "selectOnFocus": true });
    var user_asd4760 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/