'use strict';goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.utils");goog.module.declareLegacyNamespace();exports.CLIENT_ID_RE=/^C\.[0-9a-fA-F]{16}$/;exports.camelCaseToDashDelimited=function(input){return input.replace(/\W+/g,"-").replace(/([A-Z])/g,"-$1").replace(/^-+/,"").replace(/-+$/,"").toLowerCase()};exports.upperCaseToTitleCase=function(input){return(input.charAt(0).toUpperCase()+input.slice(1).toLowerCase()).replace(/_/g," ")};exports.stringToList=function(input){var result=
[];angular.forEach((input||"").split(","),function(item){item=item.trim();if(item)result.push(item)});return result};exports.stripAff4Prefix=function(input){var aff4Prefix="aff4:/";if(input.toLowerCase().indexOf(aff4Prefix)==0)return input.substr(aff4Prefix.length);else return input};exports.getLastPathComponent=function(input){var components=input.split("/");return components[components.length-1]};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.acl.requestApprovalDialogDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var0=goog.require("grrUi.core.utils");var stringToList=$jscomp$destructuring$var0.stringToList;var RequestApprovalDialogController=function($scope,$q,grrApiService){this.scope_=$scope;this.q_=$q;this.grrApiService_=grrApiService;this.subjectTitle;this.ccAddresses=[];this.recentReasons;this.selectedRecentReason;this.approversList;this.reason;
this.useCcAddresses=true;this.keepClientAlive=true;this.scope_.$watch("approvalType",this.onApprovalTypeChange_.bind(this));this.scope_.$watch("controller.selectedRecentReason",this.onSelectedRecentReasonChange_.bind(this));this.grrApiService_.getCached("/config/Email.approval_optional_cc_address").then(this.onCcAddressResponse_.bind(this));this.grrApiService_.get("/users/me/approvals/client",{count:7}).then(this.onLatestApprovalsResponse_.bind(this))};RequestApprovalDialogController.prototype.onApprovalTypeChange_=
function(newValue){if(angular.isString(newValue))this.subjectTitle=newValue.charAt(0).toUpperCase()+newValue.slice(1).replace("-"," ")};RequestApprovalDialogController.prototype.onSelectedRecentReasonChange_=function(newValue){if(angular.isString(newValue)&&newValue)this.reason=newValue};RequestApprovalDialogController.prototype.onCcAddressResponse_=function(response){this.ccAddresses=stringToList(response["data"]["value"]["value"])};RequestApprovalDialogController.prototype.onLatestApprovalsResponse_=
function(response){this.recentReasons=[];var items=response["data"]["items"];for(var i=0;i<items.length;++i){var reason=items[i]["value"]["reason"]["value"];if(this.recentReasons.indexOf(reason)===-1)this.recentReasons.push(reason)}};RequestApprovalDialogController.prototype.proceed=function(){var deferred=this.q_.defer();var url=this.scope_["createRequestUrl"];var args=angular.copy(this.scope_["createRequestArgs"]);args["approval"]["reason"]=this.reason;args["approval"]["notified_users"]=stringToList(this.approversList);
if(this.useCcAddresses&&this.ccAddresses)args["approval"]["email_cc_addresses"]=this.ccAddresses;if(this.scope_["approvalType"]==="client"&&this.keepClientAlive)args["keep_client_alive"]=true;this.grrApiService_.post(url,args).then(function success(){deferred.resolve("Approval request was sent.")},function failure(response){deferred.reject(response["data"]["message"])});return deferred.promise};exports.RequestApprovalDialogDirective=function(){return{scope:{approvalType:"=",createRequestUrl:"=",createRequestArgs:"=",
accessErrorDescription:"="},restrict:"E",templateUrl:"/static/angular-components/acl/"+"request-approval-dialog.html",controller:RequestApprovalDialogController,controllerAs:"controller"}};exports.RequestApprovalDialogDirective.directive_name="grrRequestApprovalDialog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.acl.aclDialogService");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var1=goog.require("grrUi.acl.requestApprovalDialogDirective");var RequestApprovalDialogDirective=$jscomp$destructuring$var1.RequestApprovalDialogDirective;var $jscomp$destructuring$var2=goog.require("grrUi.core.utils");var stripAff4Prefix=$jscomp$destructuring$var2.stripAff4Prefix;exports.AclDialogService=function($rootScope,grrDialogService){this.rootScope_=
$rootScope;this.grrDialogService_=grrDialogService};var AclDialogService=exports.AclDialogService;AclDialogService.service_name="grrAclDialogService";AclDialogService.prototype.openRequestApprovalDialog=function(approvalType,createRequestUrl,createRequestArgs,opt_accessErrorDescription){$(".modal-dialog:visible").each(function(){$(this).scope()["$parent"]["$dismiss"]()});var directive=RequestApprovalDialogDirective;return this.grrDialogService_.openDirectiveDialog(directive.directive_name,{approvalType:approvalType,
createRequestUrl:createRequestUrl,createRequestArgs:createRequestArgs,accessErrorDescription:opt_accessErrorDescription})};AclDialogService.prototype.openRequestClientApprovalDialog=function(clientId,opt_accessErrorDescription){return this.openRequestApprovalDialog("client","/users/me/approvals/client/"+clientId,{client_id:clientId,approval:{}},opt_accessErrorDescription)};AclDialogService.prototype.openRequestHuntApprovalDialog=function(huntId,opt_accessErrorDescription){return this.openRequestApprovalDialog("hunt",
"/users/me/approvals/hunt/"+huntId,{hunt_id:huntId,approval:{}},opt_accessErrorDescription)};AclDialogService.prototype.openRequestCronJobApprovalDialog=function(cronJobId,opt_accessErrorDescription){return this.openRequestApprovalDialog("cron-job","/users/me/approvals/cron-job/"+cronJobId,{cron_job_id:cronJobId,approval:{}},opt_accessErrorDescription)};AclDialogService.prototype.openApprovalDialogForSubject=function(subject,message){var components=stripAff4Prefix(subject).split("/");if(/^C\.[0-9a-fA-F]{16}$/.test(components[0]))this.openRequestClientApprovalDialog(components[0],
message);else if(components[0]=="hunts")this.openRequestHuntApprovalDialog(components[1],message);else if(components[0]=="cron")this.openRequestCronJobApprovalDialog(components[1],message);else throw new Error("Can't determine type of resources.");};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.apiService");goog.module.declareLegacyNamespace();var UNAUTHORIZED_API_RESPONSE_EVENT="UnauthorizedApiResponse";exports.UNAUTHORIZED_API_RESPONSE_EVENT=UNAUTHORIZED_API_RESPONSE_EVENT;exports.encodeUrlPath=function(urlPath){var components=urlPath.split("/");var encodedComponents=components.map(encodeURIComponent);return encodedComponents.join("/")};var encodeUrlPath=exports.encodeUrlPath;exports.stripTypeInfo=function(richlyTypedValue){var recursiveStrip=
function(value){if(angular.isArray(value))value=value.map(recursiveStrip);else if(angular.isDefined(value.value)){value=value.value;if(angular.isObject(value))for(var k in value)value[k]=recursiveStrip(value[k])}return value};return recursiveStrip(angular.copy(richlyTypedValue))};var stripTypeInfo=exports.stripTypeInfo;var wrapCancellablePromise_=function(promise){var cancel=promise["cancel"];if(angular.isUndefined(promise["_oldThen"])){promise["_oldThen"]=promise["then"];promise["then"]=function(onFulfilled,
onRejected,progressBack){var result=promise["_oldThen"](onFulfilled,onRejected,progressBack);result["cancel"]=cancel;return wrapCancellablePromise_(result)}}if(angular.isUndefined(promise["_oldCatch"])){promise["_oldCatch"]=promise["catch"];promise["catch"]=function(callback){var result=promise["_oldCatch"](callback);result["cancel"]=cancel;return wrapCancellablePromise_(result)}}if(angular.isUndefined(promise["_oldFinally"])){promise["_oldFinally"]=promise["finally"];promise["finally"]=function(callback,
progressBack){var result=promise["_oldFinally"](callback,progressBack);result["cancel"]=cancel;return wrapCancellablePromise_(result)}}return promise};exports.ApiService=function($http,$q,$interval,$rootScope,grrLoadingIndicatorService){this.http_=$http;this.q_=$q;this.interval_=$interval;this.rootScope_=$rootScope;this.grrLoadingIndicatorService_=grrLoadingIndicatorService;this.authDeferred_=this.q_.defer()};var ApiService=exports.ApiService;ApiService.service_name="grrApiService";ApiService.prototype.waitForAuth_=
function(fn){return this.authDeferred_.promise.then(function(){return fn()})};ApiService.prototype.markAuthDone=function(){this.authDeferred_.resolve()};ApiService.prototype.sendRequestWithoutPayload_=function(method,apiPath,opt_params,opt_requestSettings){var requestParams=angular.extend({},opt_params);var requestSettings=angular.extend({},opt_requestSettings);var loadingKey=this.grrLoadingIndicatorService_.startLoading();var apiPrefix="/api/";if(requestSettings["useV2"])apiPrefix+="v2/";var url=
encodeUrlPath(apiPrefix+apiPath.replace(/^\//,""));return this.waitForAuth_(function(){var promise=this.http_({method:method,url:url,params:requestParams,cache:requestSettings["cache"]});return promise.finally(function(){this.grrLoadingIndicatorService_.stopLoading(loadingKey)}.bind(this))}.bind(this))};ApiService.prototype.head=function(apiPath,opt_params){return this.sendRequestWithoutPayload_("HEAD",apiPath,opt_params)};ApiService.prototype.get=function(apiPath,opt_params){return this.sendRequestWithoutPayload_("GET",
apiPath,opt_params)};ApiService.prototype.getV2=function(apiPath,opt_params){return this.sendRequestWithoutPayload_("GET",apiPath,opt_params,{"useV2":true})};ApiService.prototype.getCached=function(apiPath,opt_params){return this.sendRequestWithoutPayload_("GET",apiPath,opt_params,{cache:true})};ApiService.prototype.poll=function(apiPath,intervalMs,opt_params,opt_checkFn){if(angular.isUndefined(opt_checkFn))opt_checkFn=function(response){return response["data"]["state"]==="FINISHED"}.bind(this);var result=
this.q_.defer();var inProgress=false;var cancelled=false;var pollIteration=function(){inProgress=true;this.get(apiPath,opt_params).then(function success(response){if(cancelled)return;result.notify(response);if(opt_checkFn(response))result.resolve(response)}.bind(this),function failure(response){if(cancelled)return;result.reject(response)}.bind(this)).finally(function(){if(cancelled)return;inProgress=false}.bind(this))}.bind(this);pollIteration();var intervalPromise=this.interval_(function(){if(!inProgress)pollIteration()}.bind(this),
intervalMs);result.promise["cancel"]=function(){cancelled=true;this.interval_.cancel(intervalPromise)}.bind(this);result.promise.finally(result.promise["cancel"]);return wrapCancellablePromise_(result.promise)};ApiService.prototype.cancelPoll=function(pollPromise){if(angular.isDefined(pollPromise)){if(angular.isUndefined(pollPromise["cancel"]))throw new Error("Invalid promise to cancel: not cancelable.");pollPromise["cancel"]()}};ApiService.prototype.downloadFile=function(apiPath,opt_params){var requestParams=
angular.extend({},opt_params);var url=encodeUrlPath("/api/"+apiPath.replace(/^\//,""));return this.http_.head(url,{params:requestParams}).then(function(){var paramsString=Object.keys(requestParams).sort().map(function(key){return[key,requestParams[key]].map(encodeURIComponent).join("=")}).join("&");if(paramsString.length>0)url+="?"+paramsString;var deferred=this.q_.defer();var iframe=document.createElement("iframe");iframe.src=url;document.body.appendChild(iframe);var intervalPromise=this.interval_(function(){try{if(iframe.contentWindow.document.readyState===
"complete"){this.interval_.cancel(intervalPromise);deferred.resolve()}}catch(err){deferred.reject({data:{message:"Unknown error."}})}}.bind(this),500);return deferred.promise.finally(function(){this.interval_.cancel(intervalPromise)}.bind(this))}.bind(this),function failure(response){if(response.status==403){var headers=response.headers();this.rootScope_.$broadcast(UNAUTHORIZED_API_RESPONSE_EVENT,{subject:headers["x-grr-unauthorized-access-subject"],reason:headers["x-grr-unauthorized-access-reason"]})}return this.q_.reject(response)}.bind(this))};
ApiService.prototype.sendRequestWithPayload_=function(httpMethod,apiPath,opt_params,opt_stripTypeInfo,opt_files){if(opt_stripTypeInfo)opt_params=stripTypeInfo(opt_params);var request;if(angular.equals(opt_files||{},{}))request={method:httpMethod,url:encodeUrlPath("/api/"+apiPath.replace(/^\//,"")),data:opt_params,headers:{}};else{var fd=new FormData;angular.forEach(opt_files,function(value,key){fd.append(key,value)}.bind(this));fd.append("_params_",angular.toJson(opt_params||{}));request={method:httpMethod,
url:encodeUrlPath("/api/"+apiPath.replace(/^\//,"")),data:fd,transformRequest:angular.identity,headers:{"Content-Type":undefined}}}return this.waitForAuth_(function(){var loadingKey=this.grrLoadingIndicatorService_.startLoading();var promise=this.http_(request);return promise.finally(function(){this.grrLoadingIndicatorService_.stopLoading(loadingKey)}.bind(this))}.bind(this))};ApiService.prototype.post=function(apiPath,opt_params,opt_stripTypeInfo,opt_files){return this.sendRequestWithPayload_("POST",
apiPath,opt_params,opt_stripTypeInfo,opt_files)};ApiService.prototype.delete=function(apiPath,opt_params,opt_stripTypeInfo){return this.sendRequestWithPayload_("DELETE",apiPath,opt_params,opt_stripTypeInfo)};ApiService.prototype.patch=function(apiPath,opt_params,opt_stripTypeInfo){return this.sendRequestWithPayload_("PATCH",apiPath,opt_params,opt_stripTypeInfo)};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.acl.approvalInfoDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var3=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var3.ApiService;var stripTypeInfo=$jscomp$destructuring$var3.stripTypeInfo;var ApprovalInfoController=function($scope,$attrs,grrApiService){this.scope_=$scope;this.attrs_=$attrs;this.grrApiService_=grrApiService;this.fetchUrl;this.grantUrl;this.approvalTypeTitle;this.approvalObject;
this.requestSent;this.statusMessage;this.scope_.$watchGroup(["approvalType","objectId","approvalId"],this.onParamsChanged_.bind(this));this.scope_.$watch("controller.fetchUrl",this.onApprovalFetchUrlChanged_.bind(this))};ApprovalInfoController.prototype.onParamsChanged_=function(){if(angular.isString(this.scope_["approvalType"])&&angular.isString(this.scope_["username"])&&angular.isString(this.scope_["objectId"])&&angular.isString(this.scope_["approvalId"])){this.approvalTypeTitle=this.scope_["approvalType"].replace("-",
" ");this.fetchUrl=["users",this.scope_["username"],"approvals",this.scope_["approvalType"],this.scope_["objectId"],this.scope_["approvalId"]].join("/");this.grantUrl=this.fetchUrl+"/actions/grant"}};ApprovalInfoController.prototype.onApprovalFetchUrlChanged_=function(){this.approvalObject=null;if(angular.isString(this.fetchUrl))this.grrApiService_.get(this.fetchUrl).then(function(response){if(this.attrs_["approvalObject"])this.scope_["approvalObject"]=response["data"];this.approvalObject=stripTypeInfo(response["data"]);
if(this.approvalObject["is_valid"]){this.requestSent=true;this.statusMessage="This approval has already been granted!"}}.bind(this))};ApprovalInfoController.prototype.onClick=function(){if(!angular.isObject(this.approvalObject))return;this.requestSent=true;this.grrApiService_.post(this.grantUrl).then(function success(){this.statusMessage="Approval granted."}.bind(this),function failure(response){this.statusMessage="FAILURE: "+response["data"]["message"]}.bind(this))};exports.ApprovalInfoDirective=
function(){return{scope:{approvalType:"=",username:"=",objectId:"=",approvalId:"=",approvalObject:"="},restrict:"E",templateUrl:"/static/angular-components/acl/approval-info.html",controller:ApprovalInfoController,controllerAs:"controller"}};exports.ApprovalInfoDirective.directive_name="grrApprovalInfo";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.acl.clientApprovalViewDirective");goog.module.declareLegacyNamespace();var ClientApprovalViewController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.username;this.clientId;this.approvalId;this.grrRoutingService_.uiOnParamsChanged(this.scope_,["username","clientId","approvalId"],function(params){this.username=params[0];this.clientId=params[1];this.approvalId=params[2]}.bind(this))};
exports.ClientApprovalViewDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/acl/client-approval-view.html",controller:ClientApprovalViewController,controllerAs:"controller"}};exports.ClientApprovalViewDirective.directive_name="grrClientApprovalView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.acl.cronJobApprovalViewDirective");goog.module.declareLegacyNamespace();var CronJobApprovalViewController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.username;this.cronJobId;this.approvalId;this.grrRoutingService_.uiOnParamsChanged(this.scope_,["username","cronJobId","approvalId"],function(params){this.username=params[0];this.cronJobId=params[1];this.approvalId=params[2]}.bind(this))};
exports.CronJobApprovalViewDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/acl/cron-job-approval-view.html",controller:CronJobApprovalViewController,controllerAs:"controller"}};exports.CronJobApprovalViewDirective.directive_name="grrCronJobApprovalView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.acl.huntApprovalViewDirective");goog.module.declareLegacyNamespace();var HuntApprovalViewController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.username;this.huntId;this.approvalId;this.approvalObject;this.grrRoutingService_.uiOnParamsChanged(this.scope_,["username","huntId","approvalId"],function(params){this.username=params[0];this.huntId=params[1];this.approvalId=params[2]}.bind(this))};
exports.HuntApprovalViewDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/acl/hunt-approval-view.html",controller:HuntApprovalViewController,controllerAs:"controller"}};exports.HuntApprovalViewDirective.directive_name="grrHuntApprovalView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.acl.huntFromFlowCopyReviewDirective");goog.module.declareLegacyNamespace();var HuntFromFlowCopyReviewController=function($scope,grrRoutingService){this.scope_=$scope;this.sourceFlow;this.newFlow;this.scope_.$watchGroup(["sourceFlow","newHunt"],this.onValuesChanged_.bind(this))};HuntFromFlowCopyReviewController.prototype.onValuesChanged_=function(){if(angular.isDefined(this.scope_["sourceFlow"])&&angular.isDefined(this.scope_["newHunt"])){this.sourceFlow=
this.scope_["sourceFlow"];this.newFlow=angular.copy(this.sourceFlow);var newHunt=this.scope_["newHunt"];this.newFlow["value"]["name"]=newHunt["value"]["flow_name"];this.newFlow["value"]["args"]=newHunt["value"]["flow_args"]}};exports.HuntFromFlowCopyReviewDirective=function(){return{scope:{sourceFlow:"=",newHunt:"="},restrict:"E",templateUrl:"/static/angular-components/acl/hunt-from-flow-copy-review.html",controller:HuntFromFlowCopyReviewController,controllerAs:"controller"}};exports.HuntFromFlowCopyReviewDirective.directive_name=
"grrHuntFromFlowCopyReview";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.acl.huntFromHuntCopyReviewDirective");goog.module.declareLegacyNamespace();exports.HuntFromHuntCopyReviewDirective=function(){return{scope:{sourceHunt:"=",newHunt:"="},restrict:"E",templateUrl:"/static/angular-components/acl/hunt-from-hunt-copy-review.html"}};exports.HuntFromHuntCopyReviewDirective.directive_name="grrHuntFromHuntCopyReview";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.acl.acl");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var4=goog.require("grrUi.acl.aclDialogService");var AclDialogService=$jscomp$destructuring$var4.AclDialogService;var $jscomp$destructuring$var5=goog.require("grrUi.acl.approvalInfoDirective");var ApprovalInfoDirective=$jscomp$destructuring$var5.ApprovalInfoDirective;var $jscomp$destructuring$var6=goog.require("grrUi.acl.clientApprovalViewDirective");var ClientApprovalViewDirective=
$jscomp$destructuring$var6.ClientApprovalViewDirective;var $jscomp$destructuring$var7=goog.require("grrUi.acl.cronJobApprovalViewDirective");var CronJobApprovalViewDirective=$jscomp$destructuring$var7.CronJobApprovalViewDirective;var $jscomp$destructuring$var8=goog.require("grrUi.acl.huntApprovalViewDirective");var HuntApprovalViewDirective=$jscomp$destructuring$var8.HuntApprovalViewDirective;var $jscomp$destructuring$var9=goog.require("grrUi.acl.huntFromFlowCopyReviewDirective");var HuntFromFlowCopyReviewDirective=
$jscomp$destructuring$var9.HuntFromFlowCopyReviewDirective;var $jscomp$destructuring$var10=goog.require("grrUi.acl.huntFromHuntCopyReviewDirective");var HuntFromHuntCopyReviewDirective=$jscomp$destructuring$var10.HuntFromHuntCopyReviewDirective;var $jscomp$destructuring$var11=goog.require("grrUi.acl.requestApprovalDialogDirective");var RequestApprovalDialogDirective=$jscomp$destructuring$var11.RequestApprovalDialogDirective;var $jscomp$destructuring$var12=goog.require("grrUi.core.apiService");var UNAUTHORIZED_API_RESPONSE_EVENT=
$jscomp$destructuring$var12.UNAUTHORIZED_API_RESPONSE_EVENT;exports.aclModule=angular.module("grrUi.acl",["grrUi.core"]);exports.aclModule.service(AclDialogService.service_name,AclDialogService);exports.aclModule.directive(ApprovalInfoDirective.directive_name,ApprovalInfoDirective);exports.aclModule.directive(ClientApprovalViewDirective.directive_name,ClientApprovalViewDirective);exports.aclModule.directive(CronJobApprovalViewDirective.directive_name,CronJobApprovalViewDirective);exports.aclModule.directive(HuntApprovalViewDirective.directive_name,
HuntApprovalViewDirective);exports.aclModule.directive(HuntFromFlowCopyReviewDirective.directive_name,HuntFromFlowCopyReviewDirective);exports.aclModule.directive(HuntFromHuntCopyReviewDirective.directive_name,HuntFromHuntCopyReviewDirective);exports.aclModule.directive(RequestApprovalDialogDirective.directive_name,RequestApprovalDialogDirective);exports.aclModule.run(function($rootScope,grrAclDialogService){$rootScope.$on(UNAUTHORIZED_API_RESPONSE_EVENT,function(event,data){grrAclDialogService.openApprovalDialogForSubject(data["subject"],
data["reason"])})});return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.artifact.artifactDescriptorDirective");goog.module.declareLegacyNamespace();var ArtifactDescriptorController=function($scope){this.scope_=$scope};exports.ArtifactDescriptorDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/artifact/artifact-descriptor.html",controller:ArtifactDescriptorController,controllerAs:"controller"}};exports.ArtifactDescriptorDirective.directive_name="grrArtifactDescriptor";
exports.ArtifactDescriptorDirective.semantic_type="ArtifactDescriptor";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.artifact.artifactDescriptorsService");goog.module.declareLegacyNamespace();exports.ArtifactDescriptorsService=function($q,grrApiService){this.q_=$q;this.grrApiService_=grrApiService;this.fillCachePromise_;this.descriptorsCache_};var ArtifactDescriptorsService=exports.ArtifactDescriptorsService;ArtifactDescriptorsService.prototype.fillCacheIfNeeded_=function(){if(this.fillCachePromise_)return this.fillCachePromise_;var deferred=this.q_.defer();
if(!angular.isObject(this.descriptorsCache_)){this.grrApiService_.get("/artifacts").then(function success(response){this.descriptorsCache_={};angular.forEach(response["data"]["items"],function(descriptor){var name=descriptor["value"]["artifact"]["value"]["name"]["value"];this.descriptorsCache_[name]=descriptor}.bind(this));deferred.resolve()}.bind(this),function failure(response){deferred.reject(response["data"]["message"])}.bind(this)).finally(function(){this.fillCachePromise_=null}.bind(this));
this.fillCachePromise_=deferred.promise}else deferred.resolve();return deferred.promise};ArtifactDescriptorsService.prototype.listDescriptors=function(){return this.fillCacheIfNeeded_().then(function(){return angular.copy(this.descriptorsCache_)}.bind(this))};ArtifactDescriptorsService.prototype.getDescriptorByName=function(name){return this.fillCacheIfNeeded_().then(function(){return this.descriptorsCache_[name]}.bind(this))};ArtifactDescriptorsService.prototype.clearCache=function(){this.descriptorsCache_=
null};ArtifactDescriptorsService.service_name="grrArtifactDescriptorsService";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.artifact.deleteArtifactsDialogDirective");goog.module.declareLegacyNamespace();var DeleteArtifactsDialogController=function($scope,$q,grrApiService,grrArtifactDescriptorsService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrArtifactDescriptorsService_=grrArtifactDescriptorsService;this.q_=$q};DeleteArtifactsDialogController.prototype.proceed=function(){var deferred=this.q_.defer();this.grrApiService_.delete("/artifacts",
{names:this.scope_["names"]}).then(function success(){deferred.resolve("Artifacts were deleted successfully.");this.grrArtifactDescriptorsService_.clearCache()}.bind(this),function failure(response){deferred.reject(response.data.message)}.bind(this));return deferred.promise};exports.DeleteArtifactsDialogDirective=function(){return{scope:{names:"="},restrict:"E",templateUrl:"/static/angular-components/artifact/"+"delete-artifacts-dialog.html",controller:DeleteArtifactsDialogController,controllerAs:"controller"}};
exports.DeleteArtifactsDialogDirective.directive_name="grrDeleteArtifactsDialog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.artifact.uploadArtifactDialogDirective");goog.module.declareLegacyNamespace();var UploadArtifactDialogController=function($scope,$q,grrApiService,grrArtifactDescriptorsService){this.scope_=$scope;this.q_=$q;this.grrApiService_=grrApiService;this.grrArtifactDescriptorsService_=grrArtifactDescriptorsService;this.file;this.inProgress=false};UploadArtifactDialogController.prototype.onFileSet=function(files){this.scope_.$apply(function(){this.file=
files[0]}.bind(this))};UploadArtifactDialogController.prototype.proceed=function(){var deferred=this.q_.defer();this.inProgress=true;this.grrApiService_.post("/artifacts",{},false,{"artifact":this.file}).then(function success(){deferred.resolve("Artifact was successfully uploaded.");this.grrArtifactDescriptorsService_.clearCache()}.bind(this),function failure(response){deferred.reject(response.data.message)}.bind(this));return deferred.promise};exports.UploadArtifactDialogDirective=function(){return{scope:{},
restrict:"E",templateUrl:"/static/angular-components/artifact/"+"upload-artifact-dialog.html",controller:UploadArtifactDialogController,controllerAs:"controller"}};exports.UploadArtifactDialogDirective.directive_name="grrUploadArtifactDialog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.artifact.artifactDialogService");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var13=goog.require("grrUi.artifact.deleteArtifactsDialogDirective");var DeleteArtifactsDialogDirective=$jscomp$destructuring$var13.DeleteArtifactsDialogDirective;var $jscomp$destructuring$var14=goog.require("grrUi.artifact.uploadArtifactDialogDirective");var UploadArtifactDialogDirective=$jscomp$destructuring$var14.UploadArtifactDialogDirective;
exports.ArtifactDialogService=function(grrDialogService){this.grrDialogService_=grrDialogService};var ArtifactDialogService=exports.ArtifactDialogService;ArtifactDialogService.service_name="grrArtifactDialogService";ArtifactDialogService.prototype.openDeleteArtifacts=function(names){var directive=DeleteArtifactsDialogDirective;return this.grrDialogService_.openDirectiveDialog(directive.directive_name,{names:names})};ArtifactDialogService.prototype.openUploadArtifact=function(){var directive=UploadArtifactDialogDirective;
return this.grrDialogService_.openDirectiveDialog(directive.directive_name)};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.artifact.artifactManagerViewDirective");goog.module.declareLegacyNamespace();var ArtifactManagerViewController=function($scope,grrApiService,grrArtifactDialogService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrArtifactDialogService_=grrArtifactDialogService;this.triggerUpdate;this.descriptors=[];this.selectedDescriptors={};this.numSelectedDescriptors=0;this.allDescriptorsSelected=false};ArtifactManagerViewController.prototype.artifactsUrl=
"/artifacts";ArtifactManagerViewController.prototype.transformItems=function(items){this.descriptors=[];angular.forEach(items,function(item){if(item.value.is_custom.value)this.descriptors.push(item)}.bind(this));return this.descriptors};ArtifactManagerViewController.prototype.selectAll=function(){angular.forEach(this.descriptors,function(descriptor){this.selectedDescriptors[descriptor.value.artifact.value.name.value]=this.allDescriptorsSelected}.bind(this));this.updateNumSelectedDescriptors()};ArtifactManagerViewController.prototype.upload=
function(){var result=this.grrArtifactDialogService_.openUploadArtifact();result.then(function resolve(){this.triggerUpdate()}.bind(this))};ArtifactManagerViewController.prototype.deleteSelected=function(){var namesToDelete=[];for(var name in this.selectedDescriptors)if(this.selectedDescriptors[name])namesToDelete.push(name);var result=this.grrArtifactDialogService_.openDeleteArtifacts(namesToDelete);result.then(function resolve(){this.selectedDescriptors={};this.numSelectedDescriptors=0;this.triggerUpdate()}.bind(this))};
ArtifactManagerViewController.prototype.updateNumSelectedDescriptors=function(){var count=0;for(var key in this.selectedDescriptors)if(this.selectedDescriptors[key])++count;this.numSelectedDescriptors=count};exports.ArtifactManagerViewDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/artifact/"+"artifact-manager-view.html",controller:ArtifactManagerViewController,controllerAs:"controller"}};exports.ArtifactManagerViewDirective.directive_name="grrArtifactManagerView";
return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.artifact.artifactNameDirective");goog.module.declareLegacyNamespace();var SYSTEM_ARTIFACT_TYPE="SYSTEM";var USER_ARTIFACT_TYPE="USER";var UNKNOWN_ARTIFACT_TYPE="UNKNOWN";var ArtifactNameController=function($scope,grrArtifactDescriptorsService){this.scope_=$scope;this.grrArtifactDescriptorsService_=grrArtifactDescriptorsService;this.artifactType;this.scope_.$watch("::value",this.onValueChange_.bind(this))};ArtifactNameController.prototype.onValueChange_=
function(newArtifactName){if(!angular.isObject(newArtifactName))return;this.grrArtifactDescriptorsService_.getDescriptorByName(newArtifactName["value"]).then(function(descriptor){if(angular.isDefined(descriptor)){var isCustom=descriptor["value"]["is_custom"]["value"];this.artifactType=isCustom?USER_ARTIFACT_TYPE:SYSTEM_ARTIFACT_TYPE}else this.artifactType=UNKNOWN_ARTIFACT_TYPE}.bind(this))};exports.ArtifactNameDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/artifact/artifact-name.html",
controller:ArtifactNameController,controllerAs:"controller"}};exports.ArtifactNameDirective.directive_name="grrArtifactName";exports.ArtifactNameDirective.semantic_type="ArtifactName";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.artifact.artifactsListFormDirective");goog.module.declareLegacyNamespace();var ArtifactsListFormController=function($scope,grrArtifactDescriptorsService){this.scope_=$scope;this.grrArtifactDescriptorsService_=grrArtifactDescriptorsService;this.descriptorsList=[];this.descriptors;this.descriptorsError;this.selectedName;this.platforms=["","Darwin","Linux","Windows"];this.selectedPlatform="";this.search="";this.searchFilterRef=this.searchFilter.bind(this);
this.platformFilterRef=this.platformFilter.bind(this);this.grrArtifactDescriptorsService_.listDescriptors().then(this.onArtifactsResponse_.bind(this),this.onArtifactsRequestFailure_.bind(this));this.scope_.$watch("controller.descriptors",this.onDescriptorsOrValueChange_.bind(this));this.scope_.$watchCollection("value",this.onDescriptorsOrValueChange_.bind(this))};ArtifactsListFormController.prototype.searchFilter=function(descriptor){return!this.search||descriptor.value.artifact.value.name.value.toLowerCase().indexOf(this.search.toLowerCase())!=
-1};ArtifactsListFormController.prototype.platformFilter=function(descriptor){if(!this.selectedPlatform)return true;var checkOsList=function(osList){for(var i in osList){var os=osList[i];if(os.value==this.selectedPlatform)return true}return false}.bind(this);if(checkOsList(descriptor["value"]["artifact"]["value"]["supported_os"]||[]))return true;var sourceList=descriptor["value"]["artifact"]["value"]["sources"]||[];for(var index in sourceList){var source=sourceList[index];if(checkOsList(source["value"]["supported_os"]||
[]))return true}return false};ArtifactsListFormController.prototype.onArtifactsResponse_=function(descriptors){this.descriptors=descriptors};ArtifactsListFormController.prototype.onArtifactsRequestFailure_=function(error){this.descriptorsError=error};ArtifactsListFormController.prototype.add=function(name){var index=-1;for(var i=0;i<this.scope_.value.length;++i)if(this.scope_.value[i]["value"]==name["value"]){index=i;break}if(index==-1)this.scope_.value.push(name)};ArtifactsListFormController.prototype.remove=
function(name){var index=-1;for(var i=0;i<this.scope_.value.length;++i)if(this.scope_.value[i]["value"]==name["value"]){index=i;break}if(index!=-1)this.scope_.value.splice(index,1)};ArtifactsListFormController.prototype.clear=function(){angular.forEach(angular.copy(this.scope_.value),function(name){this.remove(name)}.bind(this))};ArtifactsListFormController.prototype.onDescriptorsOrValueChange_=function(){if(angular.isDefined(this.descriptors)&&angular.isDefined(this.scope_.value)){this.descriptorsList=
[];angular.forEach(this.descriptors,function(descriptor,name){var index=-1;for(var i=0;i<this.scope_.value.length;++i)if(this.scope_.value[i]["value"]==name){index=i;break}if(index==-1)this.descriptorsList.push(descriptor)}.bind(this))}};exports.ArtifactsListFormDirective=function(){return{restrict:"E",scope:{descriptor:"=",value:"="},templateUrl:"/static/angular-components/artifact/"+"artifacts-list-form.html",controller:ArtifactsListFormController,controllerAs:"controller"}};exports.ArtifactsListFormDirective.directive_name=
"grrArtifactsListForm";exports.ArtifactsListFormDirective.semantic_type="ArtifactName";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.aff4ObjectRepresentationDirective");goog.module.declareLegacyNamespace();var Aff4ObjectRepresentationController=function($scope){this.scope_=$scope;this.scope_.value;this.aff4ObjectRepresentation;this.scope_.$watch("::value",this.onValueChange.bind(this))};Aff4ObjectRepresentationController.prototype.onValueChange=function(){if(angular.isObject(this.scope_.value))this.aff4ObjectRepresentation=this.scope_.value.value;else this.aff4ObjectRepresentation=
this.scope_.value};exports.Aff4ObjectRepresentationDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/core/aff4-object-representation.html",controller:Aff4ObjectRepresentationController,controllerAs:"controller"}};exports.Aff4ObjectRepresentationDirective.directive_name="grrAff4ObjectRepresentation";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.itemsProviderController");goog.module.declareLegacyNamespace();exports.Items;exports.ItemsProviderController=function(){};var ItemsProviderController=exports.ItemsProviderController;ItemsProviderController.prototype.fetchItems=goog.abstractMethod;ItemsProviderController.prototype.fetchFilteredItems=goog.abstractMethod;return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.apiItemsProviderDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var15=goog.require("grrUi.core.itemsProviderController");var Items=$jscomp$destructuring$var15.Items;var ItemsProviderController=$jscomp$destructuring$var15.ItemsProviderController;exports.ApiItemsProviderController=function($scope,$attrs,$parse,grrApiService,$log){this.scope_=$scope;this.grrApiService_=grrApiService;this.log_=$log;this.url;
this.queryParams;this.transformItems;this.method;$scope.$watch($attrs["url"],function(){this.url=$scope.$eval($attrs["url"])}.bind(this));if($attrs["queryParams"])$scope.$watch($attrs["queryParams"],function(){this.queryParams=$scope.$eval($attrs["queryParams"])}.bind(this));if($attrs["transformItems"])this.transformItems=$parse($attrs["transformItems"]);if($attrs["method"])this.method=$attrs["method"]};var ApiItemsProviderController=exports.ApiItemsProviderController;ApiItemsProviderController.prototype.fetchItems=
function(offset,count,opt_withTotalCount){var params=angular.extend(this.queryParams||{},{"offset":offset,"count":count});if(this.method==="POST")return this.grrApiService_.post(this.url,params).then(this.onFetchedItems_.bind(this));else return this.grrApiService_.get(this.url,params).then(this.onFetchedItems_.bind(this))};ApiItemsProviderController.prototype.fetchFilteredItems=function(filter,offset,count){var params=angular.extend(this.queryParams||{},{"filter":filter,"offset":offset,"count":count});
if(this.method==="POST")return this.grrApiService_.post(this.url,params).then(this.onFetchedItems_.bind(this));else return this.grrApiService_.get(this.url,params).then(this.onFetchedItems_.bind(this))};ApiItemsProviderController.prototype.onFetchedItems_=function(response){var result={items:response.data["items"]||[],offset:response.data["offset"]};if(angular.isDefined(response.data["total_count"]))result.totalCount=response.data["total_count"];if(angular.isDefined(result.items)&&angular.isDefined(this.transformItems)){try{result.items=
this.transformItems(this.scope_,{"items":result.items})}catch(e){this.log_.error("transformItems (on url "+this.url+") failed: "+e);throw e;}if(angular.isUndefined(result.items)){var errorStr="transform-items function returned undefined";this.log_.error(errorStr);throw new Error(errorStr);}}return result};exports.ApiItemsProviderDirective=function(){return{restrict:"A",priority:2E3,controller:ApiItemsProviderController}};exports.ApiItemsProviderDirective.directive_name="grrApiItemsProvider";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.basenameFilter");goog.module.declareLegacyNamespace();var filterImplementation=function(input){if(!angular.isString(input))return input;else{var components=input.split("/");return components[components.length-1]}};exports.BasenameFilter=function(){return filterImplementation};exports.BasenameFilter.filter_name="grrBasename";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.bindKeyDirective");goog.module.declareLegacyNamespace();var BindKeyController=function($scope,$element,$attrs){this.scope_=$scope;this.element_=$element;this.key_=13;this.callbackExpr_;if($attrs["key"])this.key_=parseInt($attrs["key"],10);if($attrs["grrBindKey"])this.callbackExpr_=$attrs["grrBindKey"];$element.bind("keydown, keypress",this.onKeyDown_.bind(this))};BindKeyController.prototype.onKeyDown_=function(event){if(event["which"]===
this.key_){this.scope_.$apply(function(){this.scope_.$eval(this.callbackExpr_)}.bind(this));event.preventDefault()}};exports.BindKeyDirective=function(){return{restrict:"A",controller:BindKeyController}};exports.BindKeyDirective.directive_name="grrBindKey";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.bytesToHexFilter");goog.module.declareLegacyNamespace();var filterImplementation=function(bytes){var hex="";for(var i=0;i<bytes.length;i+=1){var char=bytes.charCodeAt(i).toString(16);hex+=("0"+char).substr(-2)}return hex};exports.BytesToHexFilter=function(){return function(input){return filterImplementation(input)}};exports.BytesToHexFilter.filter_name="grrBytesToHex";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.canaryOnlyDirective");goog.module.declareLegacyNamespace();var getCanaryModeValue=function(grrApiService,callback){grrApiService.getCached("/users/me").then(function(response){var canaryMode;try{canaryMode=response["data"]["value"]["settings"]["value"]["canary_mode"]["value"]}catch(err){canaryMode=false}callback(canaryMode)})};exports.CanaryOnlyDirective=function(){return{scope:{},restrict:"E",controller:function(grrApiService){this.canaryMode=
false;getCanaryModeValue(grrApiService,function(canaryMode){this.canaryMode=canaryMode}.bind(this))},controllerAs:"controller",transclude:true,template:"<ng-transclude ng-if='controller.canaryMode'></ng-transclude>"}};exports.CanaryOnlyDirective.directive_name="grrCanaryOnly";exports.NonCanaryOnlyDirective=function(){return{scope:{},restrict:"E",controller:function(grrApiService){this.canaryMode=true;getCanaryModeValue(grrApiService,function(canaryMode){this.canaryMode=canaryMode}.bind(this))},controllerAs:"controller",
transclude:true,template:"<ng-transclude ng-if='!controller.canaryMode'></ng-transclude>"}};exports.NonCanaryOnlyDirective.directive_name="grrNonCanaryOnly";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.clockDirective");goog.module.declareLegacyNamespace();var ClockController=function($scope,$interval,grrTimeService){this.grrTimeService_=grrTimeService;this.formattedClock;this.updateLiveClock_();$interval(this.updateLiveClock_.bind(this),1E3)};ClockController.prototype.updateLiveClock_=function(){this.formattedClock=this.grrTimeService_.formatAsUTC()};exports.ClockDirective=function(){return{scope:{},restrict:"E",template:'<div class="navbar-text pull-right">'+
"{$ controller.formattedClock $}"+"</div>",controller:ClockController,controllerAs:"controller"}};exports.ClockDirective.directive_name="grrLiveClock";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.confirmationDialogDirective");goog.module.declareLegacyNamespace();var ConfirmationDialogController=function($scope,$timeout){this.scope_=$scope;this.timeout_=$timeout;this.error;this.success};ConfirmationDialogController.prototype.proceed=function(){var result=this.scope_.proceed();if(result)result.then(function success(successMessage){this.success=successMessage;if(this.scope_["autoCloseOnSuccess"])this.timeout_(function(){this.close()}.bind(this),
1E3)}.bind(this),function failure(errorMessage){this.error=errorMessage}.bind(this))};ConfirmationDialogController.prototype.dismiss=function(){var curScope=this.scope_;while(curScope&&!curScope["$dismiss"])curScope=curScope.$parent;if(curScope)curScope["$dismiss"]()};ConfirmationDialogController.prototype.close=function(){var curScope=this.scope_;while(curScope&&!curScope["$close"])curScope=curScope.$parent;if(curScope)curScope["$close"]()};exports.ConfirmationDialogDirective=function(){return{scope:{title:"=",
closeName:"=",cancelName:"=",proceedName:"=",proceedClass:"=",proceed:"&",canProceed:"&?",autoCloseOnSuccess:"="},restrict:"E",transclude:true,templateUrl:"/static/angular-components/core/confirmation-dialog.html",controller:ConfirmationDialogController,controllerAs:"controller"}};exports.ConfirmationDialogDirective.directive_name="grrConfirmationDialog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.dialogService");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var16=goog.require("grrUi.core.utils");var camelCaseToDashDelimited=$jscomp$destructuring$var16.camelCaseToDashDelimited;exports.DialogService=function($rootScope,$uibModal){this.rootScope_=$rootScope;this.uibModal_=$uibModal};var DialogService=exports.DialogService;DialogService.service_name="grrDialogService";DialogService.prototype.openConfirmation=
function(title,message,proceed){var modalScope=this.rootScope_.$new();modalScope.title=title;modalScope.message=message;modalScope.proceed=proceed;var modalInstance=this.uibModal_.open({template:'<grr-confirmation-dialog title="title" proceed="proceed()" >'+'  <div class="vertically-padded">{$ message $}</div>'+"</grr-confirmation-dialog>",scope:modalScope});return modalInstance.result};DialogService.prototype.openDirectiveDialog=function(directive,opt_params,opt_modalParams){var modalScope=this.rootScope_.$new();
var paramString="";var tagName=camelCaseToDashDelimited(directive);if(angular.isDefined(opt_params))angular.forEach(opt_params||{},function(value,key){modalScope[key]=opt_params[key];paramString+=" "+camelCaseToDashDelimited(key)+'="'+key+'"'});var template="<"+tagName+" "+paramString+' close="$close()" />';var modalParams=angular.extend({template:template,scope:modalScope},opt_modalParams||{});var modalInstance=this.uibModal_.open(modalParams);return modalInstance.result};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.disableIfNoTraitDirective");goog.module.declareLegacyNamespace();var DisableIfNoTraitController=function($attrs,grrApiService){this.attrs_=$attrs;this.grrApiService_=grrApiService;this.traitName_;this.attrs_.$observe("grrDisableIfNoTrait",this.onTraitNameChange_.bind(this))};DisableIfNoTraitController.prototype.onTraitNameChange_=function(newValue){this.traitName_=newValue;if(angular.isUndefined(newValue))this.attrs_.$set("disable",
false);else this.grrApiService_.getCached("users/me").then(this.onUserInfo_.bind(this))};DisableIfNoTraitController.prototype.onUserInfo_=function(response){var traitValue=false;var interfaceTraits=response["data"]["value"]["interface_traits"];if(angular.isDefined(interfaceTraits))if(angular.isDefined(interfaceTraits["value"][this.traitName_]))traitValue=interfaceTraits["value"][this.traitName_]["value"];this.attrs_.$set("disabled",!traitValue)};exports.DisableIfNoTraitDirective=function(){return{scope:{},
restrict:"A",controller:DisableIfNoTraitController,controllerAs:"controller"}};exports.DisableIfNoTraitDirective.directive_name="grrDisableIfNoTrait";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.serverErrorButtonDirective");goog.module.declareLegacyNamespace();var ERROR_EVENT_NAME="ServerError";var ServerErrorButtonController=function($rootScope,$scope,$uibModal){this.rootScope_=$rootScope;this.scope_=$scope;this.uibModal_=$uibModal;this.error;this.buttonVisible;this.rootScope_.$on(ERROR_EVENT_NAME,this.onErrorEvent.bind(this))};ServerErrorButtonController.prototype.onErrorEvent=function(unused_event,error){if(!angular.isObject(error)||
!angular.isString(error.message))return;if(error.message.length){this.error=error;this.buttonVisible=true}else{this.error=null;this.buttonVisible=false}};ServerErrorButtonController.prototype.showError=function(){var modalScope=this.scope_.$new();modalScope.message=this.error.message;modalScope.traceBack=this.error.traceBack;modalScope.close=function(){modalInstance.close()};this.scope_.$on("$destroy",function(){modalScope.$destroy()});var modalInstance=this.uibModal_.open({template:'<grr-server-error-dialog close="close()" message="message" trace-back="traceBack" />',
scope:modalScope,windowClass:"wide-modal high-modal",size:"lg"});modalInstance.result.finally(function(){this.error=null;this.buttonVisible=false}.bind(this))};exports.ServerErrorButtonDirective=function(){return{scope:true,restrict:"E",replace:true,templateUrl:"/static/angular-components/core/server-error-button.html",controller:ServerErrorButtonController,controllerAs:"controller"}};var ServerErrorButtonDirective=exports.ServerErrorButtonDirective;ServerErrorButtonDirective.directive_name="grrServerErrorButton";
ServerErrorButtonDirective.error_event_name=ERROR_EVENT_NAME;return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.downloadCollectionAsDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var17=goog.require("grrUi.core.serverErrorButtonDirective");var ServerErrorButtonDirective=$jscomp$destructuring$var17.ServerErrorButtonDirective;var ERROR_EVENT_NAME=ServerErrorButtonDirective.error_event_name;var DownloadCollectionAsController=function($rootScope,$scope,grrApiService){this.rootScope_=$rootScope;this.scope_=$scope;this.grrApiService_=
grrApiService;this.pluginToDisplayName={"csv-zip":"CSV (Zipped)","flattened-yaml-zip":"Flattened YAML (Zipped)","sqlite-zip":"SQLite Scripts (Zipped)"};this.selectedPlugin="csv-zip"};DownloadCollectionAsController.prototype.downloadAs=function(pluginName){var url=this.scope_["baseUrl"]+"/"+pluginName;this.grrApiService_.downloadFile(url).then(function success(){}.bind(this),function failure(response){if(angular.isUndefined(response.status))this.rootScope_.$broadcast(ERROR_EVENT_NAME,{message:"Couldn't download exported results."})}.bind(this))};
exports.DownloadCollectionAsDirective=function(){return{scope:{baseUrl:"="},restrict:"E",templateUrl:"/static/angular-components/core/download-collection-as.html",controller:DownloadCollectionAsController,controllerAs:"controller"}};exports.DownloadCollectionAsDirective.directive_name="grrDownloadCollectionAs";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.downloadCollectionFilesDirective");goog.module.declareLegacyNamespace();exports.valuePointsToFile=function(value){if(value["type"]=="ApiFlowResult"||value["type"]=="ApiHuntResult")value=value["value"]["payload"];if(value["type"]=="StatEntry"||value["type"]=="FileFinderResult"||value["type"]=="ArtifactFilesDownloaderResult")return true;else return false};var DownloadCollectionFilesController=function($scope,$window,grrApiService){this.scope_=
$scope;this.grrApiService_=grrApiService;this.scope_.downloadUrl;this.primaryArchiveExtension;this.secondaryArchiveExtension;this.fileArchiveGenerationStarted;this.fileArchiveGenerationSuccess;this.fileArchiveGenerationError;this.exportCommand;if($window.navigator.appVersion.indexOf("Mac")!=-1){this.primaryArchiveExtension="tar.gz";this.secondaryArchiveExtension="zip"}else{this.primaryArchiveExtension="zip";this.secondaryArchiveExtension="tar.gz"}this.scope_.$watch("exportCommandUrl",function(newValue){if(angular.isUndefined(newValue))return;
this.grrApiService_.get(newValue).then(function(response){if(angular.isDefined(response["data"]["command"]))this.exportCommand=response["data"]["command"]}.bind(this))}.bind(this))};DownloadCollectionFilesController.prototype.generateFileArchive=function(format){var requestFormat=format.toUpperCase().replace(".","_");this.grrApiService_.downloadFile(this.scope_["downloadUrl"],{archive_format:requestFormat}).then(function success(){this.fileArchiveGenerationSuccess=true}.bind(this),function failure(response){this.fileArchiveGenerationError=
response.data["message"]}.bind(this));this.fileArchiveGenerationStarted=true};exports.DownloadCollectionFilesDirective=function(){return{scope:{exportCommandUrl:"=?",downloadUrl:"="},restrict:"E",templateUrl:"/static/angular-components/core/"+"download-collection-files.html",controller:DownloadCollectionFilesController,controllerAs:"controller"}};exports.DownloadCollectionFilesDirective.directive_name="grrDownloadCollectionFiles";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.encodeUriComponentFilter");goog.module.declareLegacyNamespace();exports.EncodeUriComponentFilter=function(){return window.encodeURIComponent};exports.EncodeUriComponentFilter.filter_name="grrEncodeUriComponent";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.firebaseService");goog.module.declareLegacyNamespace();exports.FirebaseService=function($http,grrApiService){this.http_=$http;this.grrApiService_=grrApiService};var FirebaseService=exports.FirebaseService;FirebaseService.service_name="grrFirebaseService";FirebaseService.prototype.setupIfNeeded=function(){if(angular.isUndefined(window.firebase)||firebase.apps.length==0){this.grrApiService_.markAuthDone();return}var firebaseError;
firebase.auth().getRedirectResult().then(function(result){}.bind(this)).catch(function(error){firebaseError=error;this.grrApiService_.markAuthDone()}.bind(this));firebase.auth().onAuthStateChanged(function(user){if(user)user.getToken().then(function(token){this.http_.defaults.headers["common"]["Authorization"]="Bearer "+token;this.grrApiService_.markAuthDone()}.bind(this));else if(!firebaseError){var providerName=firebase.apps[0].options["authProvider"];var provider=new firebase.auth[providerName];
firebase.auth().signInWithRedirect(provider)}}.bind(this))};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.forceRefreshDirective");goog.module.declareLegacyNamespace();var ForceRefreshController=function($scope,$element,$transclude){this.scope_=$scope;this.element_=$element;this.transclude_=$transclude;this.transcludedScope_;this.scope_.$watch("refreshTrigger",this.updateDom_.bind(this),true)};ForceRefreshController.prototype.updateDom_=function(){if(angular.isDefined(this.transcludedScope_)){this.transcludedScope_.$destroy();this.transcludedScope_=
undefined}this.element_.empty();this.transclude_(function(clone,scope){this.element_.empty();this.element_.append(clone);this.transcludedScope_=scope}.bind(this))};exports.ForceRefreshDirective=function(){return{scope:{refreshTrigger:"="},restrict:"EA",transclude:true,controller:ForceRefreshController,controllerAs:"controller"}};exports.ForceRefreshDirective.directive_name="grrForceRefresh";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.globalNotificationsDirective");goog.module.declareLegacyNamespace();var SECOND=1E3;var FETCH_INTERVAL=60*SECOND;var GlobalNotificationsController=function($scope,$interval,grrApiService){this.scope_=$scope;this.interval_=$interval;this.grrApiService_=grrApiService;this.globalNotifications=[];this.intervalPromise_;this.fetchGlobalNotifications_();this.intervalPromise_=this.interval_(this.fetchGlobalNotifications_.bind(this),FETCH_INTERVAL);
this.scope_.$on("$destroy",this.stopPollingGlobalNotifications_.bind(this))};GlobalNotificationsController.prototype.fetchGlobalNotifications_=function(){this.grrApiService_.get("users/me/notifications/pending/global").then(function(response){this.globalNotifications=response.data["items"]}.bind(this))};GlobalNotificationsController.prototype.deleteGlobalNotification=function(notification){var index=this.globalNotifications.indexOf(notification);this.globalNotifications.splice(index,1);var type=notification["value"]["type"]["value"];
var url="users/me/notifications/pending/global/"+type;this.grrApiService_.delete(url)};GlobalNotificationsController.prototype.stopPollingGlobalNotifications_=function(){this.interval_.cancel(this.intervalPromise_)};exports.GlobalNotificationsDirective=function(){return{scope:true,restrict:"E",templateUrl:"/static/angular-components/core/global-notifications.html",controller:GlobalNotificationsController,controllerAs:"controller"}};var GlobalNotificationsDirective=exports.GlobalNotificationsDirective;
GlobalNotificationsDirective.directive_name="grrGlobalNotifications";GlobalNotificationsDirective.fetch_interval=FETCH_INTERVAL;return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.hexNumberFilter");goog.module.declareLegacyNamespace();var filterImplementation=function(input){var hex=input.toString(16);var targetLength=Math.ceil(hex.length/8)*8;var leadingZeros=Array(targetLength-hex.length+1).join(0);return"0x"+leadingZeros+hex};exports.HexNumberFilter=function(){return function(input){return filterImplementation(input)}};exports.HexNumberFilter.filter_name="grrHexNumber";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.infiniteTableDirective");goog.module.declareLegacyNamespace();exports.InfiniteTableController=function($scope,$attrs,$element,$interval,$transclude,$parse,$log){this.scope_=$scope;this.attrs_=$attrs;this.element_=$element;this.interval_=$interval;this.transclude_=$transclude;this.log_=$log;this.itemsProvider;this.fetchedItems_=[];this.currentPage_=0;this.showUntilPage_=0;this.updateCounter_=0;this.filterValue_;this.loadingInProgress_=
false;this.autoRefreshInProgress_=false;this.rootElement_=this.element_.parent();this.pageSize_=Number($scope.$eval(this.attrs_["pageSize"]))||InfiniteTableController.DEFAULT_PAGE_SIZE;this.elementScopes_={};var template=angular.element(InfiniteTableController.LOADING_TEMPLATE);this.element_.replaceWith(template);if(angular.isDefined(this.attrs_["triggerUpdate"])){var parsedExpression=$parse(this.attrs_["triggerUpdate"]);parsedExpression.assign(this.scope_,this.triggerUpdate.bind(this))}var loadingTimer=
this.interval_(this.checkIfTableLoadingIsVisible_.bind(this),100);this.scope_.$on("$destroy",function(){this.interval_.cancel(loadingTimer)}.bind(this));this.autoRefreshInterval_=Number($scope.$eval(this.attrs_["autoRefreshInterval"]));if(this.autoRefreshInterval_){var refreshTimer=this.interval_(this.refreshData_.bind(this),this.autoRefreshInterval_);this.scope_.$on("$destroy",function(){this.interval_.cancel(refreshTimer)}.bind(this))}this.scope_.$watch(this.attrs_["filterValue"],this.onFilterChange_.bind(this))};
var InfiniteTableController=exports.InfiniteTableController;InfiniteTableController.DEFAULT_PAGE_SIZE=50;InfiniteTableController.LOADING_TEMPLATE='<tr><td colspan="100" '+'class="table-loading">Loading...</td></tr>';InfiniteTableController.UNIQUE_KEY_NAME="_grrTableKey";InfiniteTableController.ROW_HASH_NAME="_grrTableRowHash";InfiniteTableController.prototype.setFetchedItems_=function(newValue){if(newValue.length!=this.fetchedItems_.length){var loadingElement=$(this.rootElement_).find("tr:has(td.table-loading)");
for(var i=this.fetchedItems_.length;i<newValue.length;++i)this.transclude_(function(clone,scope){scope.item=newValue[i];var key=newValue[i][InfiniteTableController.UNIQUE_KEY_NAME];if(angular.isUndefined(key)&&this.autoRefreshInterval_)this.log_.error("items in infinite table with auto-refresh "+"have to have "+InfiniteTableController.UNIQUE_KEY_NAME+" set");key=key||"";var rowHash=newValue[i][InfiniteTableController.ROW_HASH_NAME];if(angular.isUndefined(rowHash)&&this.autoRefreshInterval_)this.log_.error("items in infinite table with auto-refresh "+
"have to have "+InfiniteTableController.ROW_HASH_NAME+" set");rowHash=rowHash||"";var startComment=document.createComment("-> "+key);var endComment=document.createComment("<- "+key);this.elementScopes_[key]=[startComment,endComment,scope,rowHash];$(startComment).insertBefore(loadingElement);clone.insertBefore(loadingElement);$(endComment).insertBefore(loadingElement)}.bind(this))}this.fetchedItems_=newValue};InfiniteTableController.prototype.triggerUpdate=function(graceful){if(graceful){if(!this.autoRefreshInterval_)throw new Error("graceful refresh is only possible in infinite tables "+
"with auto-refresh turned on");this.refreshData_()}else{this.updateCounter_++;this.loadingInProgress_=false;this.autoRefreshInProgress_=false;this.setFetchedItems_([]);this.currentPage_=0;this.rootElement_.html(InfiniteTableController.LOADING_TEMPLATE)}};InfiniteTableController.prototype.onFilterChange_=function(newFilterValue){if(newFilterValue!==this.filterValue_){this.filterValue_=newFilterValue;this.triggerUpdate(false)}};InfiniteTableController.prototype.checkIfTableLoadingIsVisible_=function(){if(this.loadingInProgress_)return;
$(this.rootElement_).find(".table-loading").each(function(index,loadingElement){var loadingOffset=loadingElement.getBoundingClientRect();var elem=document.elementFromPoint(Math.ceil(loadingOffset.left)+1,Math.ceil(loadingOffset.top)+1);if($(elem).hasClass("table-loading"))this.tableLoadingElementWasShown_();else if(this.showUntilPage_>this.currentPage_)this.tableLoadingElementWasShown_()}.bind(this))};InfiniteTableController.prototype.refreshData_=function(){if(this.loadingInProgress_||this.autoRefreshInProgress_)return;
this.autoRefreshInProgress_=true;var prevUpdateCounter=this.updateCounter_;this.itemsProvider.fetchItems(0,this.currentPage_*this.pageSize_).then(function(newItems){if(this.updateCounter_===prevUpdateCounter){this.autoRefreshInProgress_=false;this.onAutoRefreshDataFetched_(newItems)}}.bind(this))};InfiniteTableController.prototype.onAutoRefreshDataFetched_=function(newItems){for(var i=newItems.items.length-1;i>=0;--i){var newItem=newItems.items[i];var key=newItem[InfiniteTableController.UNIQUE_KEY_NAME];
var rowHash=newItem[InfiniteTableController.ROW_HASH_NAME];var elemScope=this.elementScopes_[key];if(angular.isDefined(elemScope)){var startComment=elemScope[0];var endComment=elemScope[1];var scope=elemScope[2];var oldRowHash=elemScope[3];if(angular.equals(oldRowHash,rowHash))continue;scope.$destroy();var toRemove=[];for(var e=startComment.nextSibling;e!==endComment;e=e.nextSibling)toRemove.push(e);$(toRemove).remove();this.transclude_(function(clone,scope){scope.item=newItem;this.elementScopes_[key]=
[startComment,endComment,scope,rowHash];clone.insertBefore(endComment)}.bind(this))}else{this.fetchedItems_.splice(0,0,newItem);this.transclude_(function(clone,scope){scope.item=newItem;var startComment=document.createComment("-> "+key);var endComment=document.createComment("<- "+key);this.elementScopes_[key]=[startComment,endComment,scope,rowHash];this.rootElement_.prepend([startComment,clone,endComment])}.bind(this))}}};InfiniteTableController.prototype.tableLoadingElementWasShown_=function(){this.loadingInProgress_=
true;var prevUpdateCounter=this.updateCounter_;if(!this.filterValue_)this.itemsProvider.fetchItems(this.currentPage_*this.pageSize_,this.pageSize_).then(function(values){if(this.updateCounter_===prevUpdateCounter)this.onItemsFetched_(values)}.bind(this));else this.itemsProvider.fetchFilteredItems(this.filterValue_,this.currentPage_*this.pageSize_,this.pageSize_).then(function(values){if(this.updateCounter_===prevUpdateCounter)this.onItemsFetched_(values)}.bind(this))};InfiniteTableController.prototype.onItemsFetched_=
function(newlyFetchedItems){this.setFetchedItems_(this.fetchedItems_.concat(newlyFetchedItems.items));if(newlyFetchedItems.items.length==0)$(this.rootElement_).find("tr:has(.table-loading)").remove();this.currentPage_+=1;if(this.currentPage_>this.showUntilPage_)this.showUntilPage_=this.currentPage_;this.loadingInProgress_=false};exports.InfiniteTableDirective=function(){return{transclude:"element",restrict:"A",priority:1E3,terminal:true,require:["grrInfiniteTable","?grrMemoryItemsProvider","?grrApiItemsProvider"],
controller:InfiniteTableController,link:function(scope,element,attrs,controllers){var providerController=undefined;for(var i=1;i<controllers.length;++i)if(angular.isObject(controllers[i])){if(angular.isDefined(providerController))throw new Error("Can have only 1 provider.");providerController=controllers[i]}if(angular.isUndefined(providerController))throw new Error("Data provider not specified.");controllers[0].itemsProvider=providerController}}};exports.InfiniteTableDirective.directive_name="grrInfiniteTable";
return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.loadingIndicatorDirective");goog.module.declareLegacyNamespace();var LOADING_STARTED_EVENT_NAME="grrLoadingStartedEvent";var LOADING_FINISHED_EVENT_NAME="grrLoadingFinishedEvent";var LoadingIndicatorController=function($rootScope,$scope){this.rootScope_=$rootScope;this.scope_=$scope;this.queue=[];this.queueIsEmpty=true;this.rootScope_.$on(LOADING_STARTED_EVENT_NAME,this.onLoadingStartedEvent_.bind(this));this.rootScope_.$on(LOADING_FINISHED_EVENT_NAME,
this.onLoadingFinishedEvent_.bind(this))};LoadingIndicatorController.prototype.onLoadingStartedEvent_=function(event,key){this.queue.push(key);this.queueIsEmpty=this.queue.length===0};LoadingIndicatorController.prototype.onLoadingFinishedEvent_=function(event,key){var index=this.queue.indexOf(key);if(index>=0){this.queue.splice(index,1);this.queueIsEmpty=this.queue.length===0}else;};exports.LoadingIndicatorDirective=function(){return{scope:true,restrict:"E",template:'<div id="ajax_spinner" class="ajax_spinner" ng-hide="controller.queueIsEmpty">'+
'    <img src="/static/images/ajax-loader.gif">'+"</div>",controller:LoadingIndicatorController,controllerAs:"controller"}};var LoadingIndicatorDirective=exports.LoadingIndicatorDirective;LoadingIndicatorDirective.directive_name="grrLoadingIndicator";LoadingIndicatorDirective.loading_started_event_name=LOADING_STARTED_EVENT_NAME;LoadingIndicatorDirective.loading_finished_event_name=LOADING_FINISHED_EVENT_NAME;return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.loadingIndicatorService");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var18=goog.require("grrUi.core.loadingIndicatorDirective");var LoadingIndicatorDirective=$jscomp$destructuring$var18.LoadingIndicatorDirective;var LOADING_STARTED_EVENT_NAME=LoadingIndicatorDirective.loading_started_event_name;var LOADING_FINISHED_EVENT_NAME=LoadingIndicatorDirective.loading_finished_event_name;exports.LoadingIndicatorService=
function($rootScope){this.rootScope_=$rootScope;this.key=0};var LoadingIndicatorService=exports.LoadingIndicatorService;LoadingIndicatorService.service_name="grrLoadingIndicatorService";LoadingIndicatorService.prototype.getNextKey_=function(){return this.key++};LoadingIndicatorService.prototype.startLoading=function(){var key=this.getNextKey_();this.rootScope_.$broadcast(LOADING_STARTED_EVENT_NAME,key);return key};LoadingIndicatorService.prototype.stopLoading=function(key){this.rootScope_.$broadcast(LOADING_FINISHED_EVENT_NAME,
key)};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.memoryItemsProviderDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var19=goog.require("grrUi.core.itemsProviderController");var Items=$jscomp$destructuring$var19.Items;var ItemsProviderController=$jscomp$destructuring$var19.ItemsProviderController;exports.MemoryItemsProviderController=function($scope,$q,$attrs,$parse){this.q_=$q;this.items_;if(angular.isUndefined($attrs.items))throw new Error('"items" attribute has to be specified.');
$scope.$watch($attrs.items,function(){this.items_=$scope.$eval($attrs.items)}.bind(this))};var MemoryItemsProviderController=exports.MemoryItemsProviderController;MemoryItemsProviderController.prototype.fetchItems=function(offset,count,opt_withTotalCount){if(angular.isUndefined(opt_withTotalCount))opt_withTotalCount=false;var items=this.items_;var deferred=this.q_.defer();var resultItems=items.slice(offset,offset+count);var result={offset:offset,items:resultItems};if(opt_withTotalCount)result.totalCount=
items.length;deferred.resolve(result);return deferred.promise};MemoryItemsProviderController.prototype.fetchFilteredItems=function(filter,offset,count){filter=filter.toLowerCase();var items=this.items_;var deferred=this.q_.defer();var filteredItems=[];angular.forEach(items,function(item){if(JSON.stringify(item).toLowerCase().indexOf(filter)!=-1)filteredItems.push(item)});filteredItems=filteredItems.slice(offset,offset+count);var result={offset:offset,items:filteredItems};deferred.resolve(result);
return deferred.promise};exports.MemoryItemsProviderDirective=function(){return{restrict:"A",priority:2E3,controller:MemoryItemsProviderController}};exports.MemoryItemsProviderDirective.directive_name="grrMemoryItemsProvider";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.onScrollIntoViewDirective");goog.module.declareLegacyNamespace();var OnScrollIntoViewController=function($scope,$element,$attrs,$interval,$window){this.scope_=$scope;this.attrs_=$attrs;this.element_=$element;this.window_=$window;this.currentlyVisible=false;var stop=$interval(this.onInterval.bind(this),100);$scope.$on("$destroy",function(){$interval.cancel(stop)})};OnScrollIntoViewController.prototype.onInterval=function(){var elemOffset=
$(this.element_).offset();var elemWidth=$(this.element_).width();var elemHeight=$(this.element_).height();var elem=document.elementFromPoint(elemOffset.left-$(this.window_).scrollLeft()+1,elemOffset.top-$(this.window_).scrollTop()+1);var isVisible=elem==$(this.element_)[0];if(!isVisible){elem=document.elementFromPoint(elemOffset.left+elemWidth-$(this.window_).scrollLeft()-1,elemOffset.top+elemHeight-$(this.window_).scrollTop()-1);isVisible=elem==$(this.element_)[0]}if(!isVisible){elem=document.elementFromPoint(elemOffset.left+
elemWidth/2-$(this.window_).scrollLeft(),elemOffset.top+elemHeight/2-$(this.window_).scrollTop());isVisible=elem==$(this.element_)[0]}if(this.currentlyVisible!=isVisible){this.currentlyVisible=isVisible;if(isVisible)this.scope_.$eval(this.attrs_["grrOnScrollIntoView"])}};exports.OnScrollIntoViewDirective=function(){return{restrict:"A",controller:OnScrollIntoViewController}};exports.OnScrollIntoViewDirective.directive_name="grrOnScrollIntoView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.pagedFilteredTableDirective");goog.module.declareLegacyNamespace();exports.TableTopDirective=function(){return{scope:{parentController:"="},require:"^grrPagedFilteredTable",templateUrl:"/static/angular-components/core/"+"paged-filtered-table-top.html",restrict:"E"}};exports.TableTopDirective.directive_name="grrPagedFilteredTableTop";exports.TableBottomDirective=function(){return{scope:{parentController:"="},require:"^grrPagedFilteredTable",
templateUrl:"/static/angular-components/core/"+"paged-filtered-table-bottom.html",restrict:"E"}};exports.TableBottomDirective.directive_name="grrPagedFilteredTableBottom";var PagedFilteredTableController=function($scope,$element,$transclude,$compile,$interval){this.scope_=$scope;this.scope_.pageSize;this.scope_.autoRefreshInterval;this.element_=$element;this.transclude_=$transclude;this.compile_=$compile;this.interval_=$interval;this.itemsProvider;this.currentPage=0;this.paginationSelectedPage=1;
this.showLoading=true;this.items=[];this.totalCount;this.pageSize=this.scope_.pageSize||PagedFilteredTableController.DEFAULT_PAGE_SIZE;this.filterEditedValue="";this.filterValue="";this.filterApplied=false;this.filterFinished=false;this.requestCounter_=0;this.autoRefreshInProgress_=false;this.addTopDirective_();this.addBottomDirective_();this.scope_.$watch("::controller.itemsProvider",function(){this.fetchUnfilteredItems(true)}.bind(this));if(this.scope_.autoRefreshInterval){var refreshTimer=this.interval_(this.onAutoRefresh_.bind(this),
this.scope_.autoRefreshInterval);this.scope_.$on("$destroy",function(){this.interval_.cancel(refreshTimer)}.bind(this))}};PagedFilteredTableController.DEFAULT_PAGE_SIZE=50;PagedFilteredTableController.prototype.addTopDirective_=function(){var template=angular.element('<grr-paged-filtered-table-top parent-controller="controller" />');var table=this.element_.closest("table");template.insertBefore(table);this.compile_(template)(this.scope_)};PagedFilteredTableController.prototype.addBottomDirective_=
function(){var template=angular.element('<grr-paged-filtered-table-bottom parent-controller="controller" />');var table=this.element_.closest("table");template.insertAfter(table);this.compile_(template)(this.scope_)};PagedFilteredTableController.prototype.wrapWithCounterCheck_=function(callback){this.requestCounter_+=1;var curRequestCounter=this.requestCounter_;return function(data){if(this.requestCounter_==curRequestCounter)return callback(data)}.bind(this)};PagedFilteredTableController.prototype.fetchUnfilteredItems=
function(withTotalCount){this.showLoading=true;this.setItems_([]);this.itemsProvider.fetchItems(this.currentPage*this.pageSize,this.pageSize,withTotalCount).then(this.wrapWithCounterCheck_(this.onFetchedUnfilteredItems_.bind(this)))};PagedFilteredTableController.prototype.onFetchedUnfilteredItems_=function(items){this.showLoading=false;this.setItems_(items.items);if(angular.isDefined(items.totalCount))this.totalCount=items.totalCount};PagedFilteredTableController.prototype.applyFilter=function(){this.filterValue=
this.filterEditedValue;this.filterApplied=this.filterValue!="";this.filterFinished=false;this.currentPage=0;this.paginationSelectedPage=1;this.setItems_([]);if(this.filterApplied)this.fetchFilteredItems();else this.fetchUnfilteredItems(false)};PagedFilteredTableController.prototype.fetchFilteredItems=function(opt_numPages){if(angular.isUndefined(opt_numPages))opt_numPages=1;this.showLoading=true;this.itemsProvider.fetchFilteredItems(this.filterValue,this.items.length,this.pageSize*opt_numPages).then(this.wrapWithCounterCheck_(this.onFetchedFilteredItems_.bind(this)))};
PagedFilteredTableController.prototype.onFetchedFilteredItems_=function(items){this.showLoading=false;this.setItems_(this.items.concat(items.items));if(items.items.length==0||items.items.length%this.pageSize!=0)this.filterFinished=true};PagedFilteredTableController.prototype.setItems_=function(newItems){var indexOffset=0;if(angular.equals(this.items,newItems.slice(0,this.items.length)))indexOffset=this.items.length;else this.element_.siblings().remove();this.items=newItems;for(var i=indexOffset;i<
this.items.length;++i)this.transclude_(function(clone,scope){scope.item=this.items[i];scope.$index=i;this.element_.parent().append(clone)}.bind(this),this.element_.parent())};PagedFilteredTableController.prototype.onAutoRefresh_=function(){if(this.filterApplied||this.items.length>=this.pageSize||this.autoRefreshInProgress_)return;var callback=this.wrapWithCounterCheck_(this.onFetchedUnfilteredItems_.bind(this));this.autoRefreshInProgress_=true;this.itemsProvider.fetchItems(this.currentPage*this.pageSize,
this.pageSize,true).then(callback).finally(function(){this.autoRefreshInProgress_=false}.bind(this))};PagedFilteredTableController.prototype.onPageChange=function(newPage){this.currentPage=newPage;if(!this.filterApplied)this.fetchUnfilteredItems(false)};exports.PagedFilteredTableDirective=function(){return{scope:{pageSize:"=?",autoRefreshInterval:"=?"},transclude:"element",restrict:"A",priority:1E3,terminal:true,require:["?grrMemoryItemsProvider","?grrApiItemsProvider"],controller:PagedFilteredTableController,
controllerAs:"controller",link:function(scope,element,attrs,controllers){var providerController=undefined;for(var i=0;i<controllers.length;++i)if(angular.isObject(controllers[i])){if(angular.isDefined(providerController))throw new Error("Can have only 1 provider.");providerController=controllers[i]}if(angular.isUndefined(providerController))throw new Error("Data provider not specified.");scope.controller.itemsProvider=providerController}}};exports.PagedFilteredTableDirective.directive_name="grrPagedFilteredTable";
return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.periodicRefreshDirective");goog.module.declareLegacyNamespace();var PeriodicRefreshController=function($scope,$interval){this.scope_=$scope;this.interval_=$interval;this.refreshTrigger=0;this.updateOperationInterval_;this.scope_.$watch("interval",this.onIntervalChange_.bind(this));this.scope_.$on("$destroy",function(){if(this.updateOperationInterval_)this.interval_.cancel(this.updateOperationInterval_)}.bind(this))};PeriodicRefreshController.prototype.onIntervalChange_=
function(newValue){if(this.updateOperationInterval_){this.interval_.cancel(this.updateOperationInterval_);this.updateOperationInterval_=null}if(angular.isDefined(newValue))this.updateOperationInterval_=this.interval_(this.onInterval_.bind(this),newValue)};PeriodicRefreshController.prototype.onInterval_=function(){this.refreshTrigger+=1;if(this.scope_["onRefresh"])this.scope_["onRefresh"]()};exports.PeriodicRefreshDirective=function(){return{scope:{interval:"=",onRefresh:"&"},restrict:"EA",transclude:true,
template:"<grr-force-refresh "+'refresh-trigger="controller.refreshTrigger">'+"<ng-transclude /></grr-force-refresh>",controller:PeriodicRefreshController,controllerAs:"controller"}};exports.PeriodicRefreshDirective.directive_name="grrPeriodicRefresh";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.reflectionService");goog.module.declareLegacyNamespace();exports.ReflectionService=function($q,grrApiService){this.q_=$q;this.grrApiService_=grrApiService;this.descriptorsCache_;this.requestsQueue_=[]};var ReflectionService=exports.ReflectionService;ReflectionService.service_name="grrReflectionService";ReflectionService.prototype.processRequestsQueue_=function(){angular.forEach(this.requestsQueue_,function(request){var result=
this.getRDFValueDescriptorFromCache_(request[1],request[2]);request[0].resolve(result)}.bind(this));this.requestsQueue_=[]};ReflectionService.prototype.getRDFValueDescriptorFromCache_=function(valueType,opt_withDeps){if(!opt_withDeps)return this.descriptorsCache_[valueType];else{var results={};var fillInResult=function(type){if(angular.isDefined(results[type]))return;var descriptor=this.descriptorsCache_[type];results[type]=descriptor;angular.forEach(descriptor["fields"],function(fieldDescriptor){if(angular.isDefined(fieldDescriptor["type"]))fillInResult(fieldDescriptor["type"])})}.bind(this);
fillInResult(valueType);return results}};ReflectionService.prototype.getRDFValueDescriptor=function(valueType,opt_withDeps){var deferred=this.q_.defer();if(angular.isDefined(this.descriptorsCache_)){var result=this.getRDFValueDescriptorFromCache_(valueType,opt_withDeps);deferred.resolve(result);return deferred.promise}else{if(this.requestsQueue_.length===0){var apiPromise=this.grrApiService_.get("reflection/rdfvalue/all");apiPromise.then(function(response){this.descriptorsCache_={};angular.forEach(response["data"]["items"],
function(item){this.descriptorsCache_[item["name"]]=item}.bind(this));return this.processRequestsQueue_()}.bind(this))}this.requestsQueue_.push([deferred,valueType,opt_withDeps]);return deferred.promise}};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.fileDownloadUtils");goog.module.declareLegacyNamespace();var AFF4_PREFIXES={"OS":"fs/os","TSK":"fs/tsk","REGISTRY":"registry","MEMORY":"devices/memory","TMPFILE":"temp"};var splitPathspec=function(pathspec){var result=[];var cur=pathspec["value"];while(angular.isDefined(cur["pathtype"])){result.push(cur);if(angular.isDefined(cur["nested_path"]))cur=cur["nested_path"]["value"];else break}return result};exports.pathSpecToAff4Path=
function(pathspec,clientId){var components=splitPathspec(pathspec);var firstComponent=components[0];var dev=firstComponent["path"]["value"];if(angular.isDefined(firstComponent["offset"]))dev+=":"+Math.round(firstComponent["offset"]["value"]/512);var result,start;if(components.length>1&&firstComponent["pathtype"]["value"]=="OS"&&components[1]["pathtype"]["value"]=="TSK"){result=["aff4:",clientId,AFF4_PREFIXES["TSK"],dev];start=1}else{result=["aff4:",clientId,AFF4_PREFIXES[firstComponent["pathtype"]["value"]]];
start=0}for(var i=start;i<components.length;++i){var p=components[i];var component=p["path"]["value"];if(component.startsWith("/"))component=component.substring(1);if(angular.isDefined(p["offset"]))component+=":"+Math.round(p["offset"]["value"]/512);if(angular.isDefined(p["stream_name"]))component+=":"+p["stream_name"]["value"];result.push(component)}return result.join("/")};var pathSpecToAff4Path=exports.pathSpecToAff4Path;exports.vfsRoots=["fs","registry","temp"];exports.downloadableVfsRoots=["fs",
"temp"];exports.getPathSpecFromValue=function(value){if(!value)return null;if(value["type"]=="ApiFlowResult"||value["type"]=="ApiHuntResult")value=value["value"]["payload"];switch(value["type"]){case "StatEntry":return value["value"]["pathspec"];case "FileFinderResult":var st=value["value"]["stat_entry"];if(angular.isDefined(st)&&angular.isDefined(st["value"]["pathspec"]))return st["value"]["pathspec"];return null;case "ArtifactFilesDownloaderResult":return exports.getPathSpecFromValue(value["value"]["downloaded_file"]);
default:return null}};var makeStatEntryDownloadable_=function(value,downloadUrl,downloadParams){var originalValue=angular.copy(value);for(var prop in value)if(value.hasOwnProperty(prop))delete value[prop];angular.extend(value,{type:"__DownloadableStatEntry",originalValue:originalValue,downloadUrl:downloadUrl,downloadParams:downloadParams})};var makeFileFinderResultDownloadable_=function(value,downloadUrl,downloadParams){makeStatEntryDownloadable_(value["value"]["stat_entry"],downloadUrl,downloadParams)};
var makeArtifactFilesDownloaderResultDownloadable_=function(value,downloadUrl,downloadParams){exports.makeValueDownloadable(value["value"]["downloaded_file"],downloadUrl,downloadParams)};exports.makeValueDownloadable=function(value,downloadUrl,downloadParams){if(!value)return false;if(value["type"]==="ApiFlowResult"||value["type"]==="ApiHuntResult")value=value["value"]["payload"];switch(value["type"]){case "StatEntry":makeStatEntryDownloadable_(value,downloadUrl,downloadParams);return true;case "FileFinderResult":makeFileFinderResultDownloadable_(value,
downloadUrl,downloadParams);return true;case "ArtifactFilesDownloaderResult":makeArtifactFilesDownloaderResultDownloadable_(value,downloadUrl,downloadParams);return true;default:return false}};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.resultsCollectionDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var20=goog.require("grrUi.core.fileDownloadUtils");var getPathSpecFromValue=$jscomp$destructuring$var20.getPathSpecFromValue;var AUTO_REFRESH_INTERVAL_MS=20*1E3;exports.setAutoRefreshInterval=function(millis){AUTO_REFRESH_INTERVAL_MS=millis};var MAX_ITEMS_TO_CHECK_FOR_FILES=50;var ResultsCollectionController=function($scope){this.scope_=
$scope;this.resultsArePresent;this.resultsAreFiles;this.autoRefreshInterval=AUTO_REFRESH_INTERVAL_MS;this.numCheckedItems_=0};ResultsCollectionController.prototype.transformItems=function(items){if(items.length>0)this.resultsArePresent=true;if(!this.resultsAreFiles&&this.numCheckedItems_<MAX_ITEMS_TO_CHECK_FOR_FILES){this.numCheckedItems_+=items.length;this.resultsAreFiles=false;for(var i=0;i<items.length;i++)if(getPathSpecFromValue(items[i])!=null){this.resultsAreFiles=true;break}}if(this.scope_["transformItems"])return this.scope_["transformItems"]({"items":items});
else return items};exports.ResultsCollectionDirective=function(){return{scope:{resultsUrl:"=",exportedResultsUrl:"=",outputPluginsUrl:"=",exportCommandUrl:"=?",downloadFilesUrl:"=",transformItems:"&?"},restrict:"E",templateUrl:"/static/angular-components/core/results-collection.html",controller:ResultsCollectionController,controllerAs:"controller"}};exports.ResultsCollectionDirective.directive_name="grrResultsCollection";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.searchBoxDirective");goog.module.declareLegacyNamespace();var SEARCH_KEYWORDS=["host","mac","ip","user","label"];var SearchBoxController=function($scope,$element,$interval,grrApiService,grrRoutingService){this.scope_=$scope;this.element_=$element;this.interval_=$interval;this.grrApiService_=grrApiService;this.grrRoutingService_=grrRoutingService;this.query="";this.labels=[];this.grrApiService_.get("/clients/labels").then(this.onGetLabels_.bind(this))};
SearchBoxController.prototype.onGetLabels_=function(response){angular.forEach(response["data"]["items"],function(label){this.labels.push("label:"+label["value"]["name"]["value"])}.bind(this))};SearchBoxController.prototype.submitQuery=function(){if(this.isHuntId_(this.query))this.checkHunt_(this.query);else this.grrRoutingService_.go("search",{q:this.query})};SearchBoxController.prototype.isHuntId_=function(input){var hunt_regex=/^[A-Z0-9]+:[A-F0-9]{6,12}$/i;if(!hunt_regex.test(input))return false;
var components=input.split(":");var potential_keyword=components[0].toLowerCase();return SEARCH_KEYWORDS.indexOf(potential_keyword)===-1};SearchBoxController.prototype.checkHunt_=function(huntId){this.grrApiService_.get("hunts/"+huntId).then(function success(response){var huntId=response.data["value"]["hunt_id"]["value"];this.grrRoutingService_.go("hunts",{huntId:huntId})}.bind(this),function error(){this.grrRoutingService_.go("search",{q:this.query})}.bind(this))};SearchBoxController.prototype.contextHelpUrl=
"investigating-with-grr/searching-for-client.html";exports.SearchBoxDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/core/search-box.html",controller:SearchBoxController,controllerAs:"controller"}};exports.SearchBoxDirective.directive_name="grrSearchBox";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.serverErrorDialogDirective");goog.module.declareLegacyNamespace();var ServerErrorDialogController=function($scope){this.scope_=$scope};exports.ServerErrorDialogDirective=function(){return{scope:{close:"&",message:"=",traceBack:"="},restrict:"E",templateUrl:"/static/angular-components/core/server-error-dialog.html",controller:ServerErrorDialogController,controllerAs:"controller"}};exports.ServerErrorDialogDirective.directive_name=
"grrServerErrorDialog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.serverErrorInterceptorFactory");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var21=goog.require("grrUi.core.serverErrorButtonDirective");var ServerErrorButtonDirective=$jscomp$destructuring$var21.ServerErrorButtonDirective;var ERROR_EVENT_NAME=ServerErrorButtonDirective.error_event_name;var INTERCEPTED_STATUS_CODES=[500];var needsInterception_=function(response){return INTERCEPTED_STATUS_CODES.indexOf(response.status)!==
-1};var extractError_=function(response){var data=response.data||{};return{message:data.message||"Unknown Server Error",traceBack:data.traceBack}};exports.ServerErrorInterceptorFactory=function($rootScope,$q){return{responseError:function(response){if(needsInterception_(response)){var error=extractError_(response);$rootScope.$broadcast(ERROR_EVENT_NAME,error)}return $q.reject(response)}}};var ServerErrorInterceptorFactory=exports.ServerErrorInterceptorFactory;ServerErrorInterceptorFactory.factory_name=
"grrServerErrorInterceptorFactory";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.serverErrorPreviewDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var22=goog.require("grrUi.core.serverErrorButtonDirective");var ServerErrorButtonDirective=$jscomp$destructuring$var22.ServerErrorButtonDirective;var ERROR_EVENT_NAME=ServerErrorButtonDirective.error_event_name;var ERROR_PREVIEW_INTERVAL=5E3;var ServerErrorPreviewController=function($rootScope,$scope,$timeout){this.rootScope_=$rootScope;
this.scope_=$scope;this.timeout_=$timeout;this.error;this.labelVisible;this.rootScope_.$on(ERROR_EVENT_NAME,this.onErrorEvent.bind(this))};ServerErrorPreviewController.prototype.onErrorEvent=function(unused_event,error){if(!angular.isObject(error)||!angular.isString(error.message))return;if(error.message.length){this.error=error;this.labelVisible=true;this.timeout_(function(){this.labelVisible=false}.bind(this),ERROR_PREVIEW_INTERVAL)}else{this.error=null;this.labelVisible=false}};exports.ServerErrorPreviewDirective=
function(){return{scope:true,restrict:"E",replace:true,template:'<div class="navbar-text" ng-show="controller.labelVisible">'+"    {$ controller.error.message $}"+"</div>",controller:ServerErrorPreviewController,controllerAs:"controller"}};var ServerErrorPreviewDirective=exports.ServerErrorPreviewDirective;ServerErrorPreviewDirective.directive_name="grrServerErrorPreview";ServerErrorPreviewDirective.error_preview_interval=5E3;return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.splitterDirective");goog.module.declareLegacyNamespace();var SplitterController=function($scope,$element,$interval){this.scope_=$scope;this.element_=$element;this.interval_=$interval;this.scope_.orientation;this.panes=[]};SplitterController.prototype.addPane=function(pane){this.panes.push(pane)};SplitterController.prototype.link=function(){var closeableTo;if(angular.isDefined(this.scope_["closeableTo"]))closeableTo=Number(this.scope_["closeableTo"]);
else closeableTo=100;var splitterOptions={animSpeed:50,closeableto:closeableTo,minAsize:this.scope_["minLeftPaneSize"]||0,maxAsize:this.scope_["maxLeftPaneSize"]||3E3};if(this.scope_.orientation==="horizontal")splitterOptions["splitHorizontal"]=true;else if(this.scope_.orientation==="vertical")splitterOptions["splitVertical"]=true;else throw Error('Orientation can be either "vertical" or "horizontal".');splitterOptions["A"]=$(this.panes[0].elem);splitterOptions["B"]=$(this.panes[1].elem);var count=
0;var stop;var registerSplitter=function(){if($(this.element_).width()>0&&$(this.element_).height()>0||count>5){$(this.element_).children("div.splitter").splitter(splitterOptions);this.interval_.cancel(stop)}else count+=1}.bind(this);stop=this.interval_(registerSplitter,100);registerSplitter();this.element_.on("$destroy",function(){this.interval_.cancel(stop)}.bind(this))};exports.SplitterDirective=function(){return{scope:{orientation:"@",closeableTo:"@",minLeftPaneSize:"@",maxLeftPaneSize:"@"},restrict:"EA",
transclude:true,template:'<div class="splitter fill-parent no-margins" '+"ng-transclude></div>",controller:SplitterController,controllerAs:"controller",link:function(scope,element,attrs){scope.controller.link()}}};exports.SplitterDirective.directive_name="grrSplitter";exports.SplitterPaneDirective=function(){return{scope:{},restrict:"EA",require:"^grrSplitter",transclude:true,template:'<div class="fill-parent no-margins" ng-transclude></div>',link:function(scope,element,attrs,grrSplitterCtrl){scope.elem=
element;grrSplitterCtrl.addPane(scope)}}};exports.SplitterPaneDirective.directive_name="grrSplitterPane";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.timeService");goog.module.declareLegacyNamespace();exports.TimeService=function(){};var TimeService=exports.TimeService;TimeService.service_name="grrTimeService";TimeService.prototype.getCurrentTimeMs=function(){return(new Date).getTime()};TimeService.prototype.formatAsUTC=function(opt_timestamp){var when=angular.isUndefined(opt_timestamp)?moment():moment(opt_timestamp);return when.utc().format("YYYY-MM-DD HH:mm:ss")+" UTC"};TimeService.prototype.getFormattedDiffFromCurrentTime=
function(timestamp){var diff=moment(timestamp).diff(moment());if(Math.abs(diff)<60*1E3)return"now";return moment.duration(diff).humanize(true)};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.timeSinceFilter");goog.module.declareLegacyNamespace();var filterImplementation=function(grrTimeService,input){var currentTimeMs=grrTimeService.getCurrentTimeMs();var inputTimeMs=input/1E3;if(inputTimeMs<1E-6)return"<invalid time value>";var differenceSec=Math.abs(Math.round((currentTimeMs-inputTimeMs)/1E3));var measureUnit;var measureValue;if(differenceSec<60){measureUnit="seconds";measureValue=differenceSec}else if(differenceSec<
60*60){measureUnit="minutes";measureValue=Math.floor(differenceSec/60)}else if(differenceSec<60*60*24){measureUnit="hours";measureValue=Math.floor(differenceSec/(60*60))}else{measureUnit="days";measureValue=Math.floor(differenceSec/(60*60*24))}if(currentTimeMs>=inputTimeMs)return measureValue+" "+measureUnit+" ago";else return"in "+measureValue+" "+measureUnit};exports.TimeSinceFilter=function(grrTimeService){return function(input){return filterImplementation(grrTimeService,input)}};exports.TimeSinceFilter.filter_name=
"grrTimeSince";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.timestampFilter");goog.module.declareLegacyNamespace();var filterImplementation=function(grrTimeService,value){if(angular.isNumber(value)){var timestamp=value/1E3;return grrTimeService.formatAsUTC(timestamp)}else return"-"};exports.TimestampFilter=function(grrTimeService){return function(input){return filterImplementation(grrTimeService,input)}};exports.TimestampFilter.filter_name="grrTimestamp";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.versionDropdownDirective");goog.module.declareLegacyNamespace();var REFRESH_VERSIONS_EVENT="RefreshVersionsEvent";var VersionDropdownController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.versions;this.version;this.requestCounter_=0;this.updateInProgress_;this.scope_.$watch("url",this.fetchVersions_.bind(this));this.scope_.$watch("version",this.onVersionBindingChange_.bind(this));this.scope_.$watch("controller.version",
this.onControllerVersionChange_.bind(this));this.scope_.$on(REFRESH_VERSIONS_EVENT,this.fetchVersions_.bind(this))};VersionDropdownController.prototype.onVersionBindingChange_=function(newValue){if(angular.isUndefined(newValue)&&this.version==="HEAD")return;if(angular.isDefined(this.versions))for(var i=0;i<this.versions.length;++i)if(newValue===this.versions[i]["value"]){this.version=this.scope_["version"].toString();return}this.syncSelectedVersion_()};VersionDropdownController.prototype.syncSelectedVersion_=
function(){if(angular.isUndefined(this.versions)||this.versions.length===0)return;if(this.scope_["version"]){this.versions.push({value:this.scope_["version"],type:"RDFDatetime"});this.versions.sort(function(v1,v2){if(v1["value"]<v2["value"])return 1;else if(v1["value"]==v2["value"])return 0;else return-1}.bind(this));this.versions=this.versions.filter(function(value,index,arr){if(index==0)return true;else return value["value"]!=arr[index-1]["value"]}.bind(this));this.version=this.scope_["version"].toString()}else this.version=
"HEAD"};VersionDropdownController.prototype.fetchVersions_=function(){var url=this.scope_["url"];if(angular.isDefined(url)){this.updateInProgress_=true;this.requestCounter_+=1;var curCounter=this.requestCounter_;this.grrApiService_.get(url).then(function(response){if(curCounter===this.requestCounter_){this.onVersionsFetched_(response);this.updateInProgress_=false}}.bind(this))}};VersionDropdownController.prototype.onVersionsFetched_=function(response){var responseField=this.scope_["responseField"]||
"times";this.versions=response["data"][responseField];if(!this.versions.length)return;this.syncSelectedVersion_()};VersionDropdownController.prototype.onControllerVersionChange_=function(){if(angular.isUndefined(this.version))return;if(this.version=="HEAD")this.scope_["version"]=undefined;else this.scope_["version"]=parseInt(this.version,10)};VersionDropdownController.prototype.isSelected=function(value){if(value=="HEAD")return this.version==value;else return parseInt(this.version,10)==value};VersionDropdownController.prototype.isLatestSelected=
function(){if(this.updateInProgress_)return true;if(this.version=="HEAD")return true;return!this.versions||this.versions.length===0||!this.scope_["version"]||this.version===this.versions[0].value.toString()};exports.VersionDropdownDirective=function(){return{restrict:"E",scope:{url:"=",version:"=",responseField:"@"},templateUrl:"/static/angular-components/core/version-dropdown.html",controller:VersionDropdownController,controllerAs:"controller"}};exports.VersionDropdownDirective.directive_name="grrVersionDropdown";
exports.VersionDropdownDirective.REFRESH_VERSIONS_EVENT=REFRESH_VERSIONS_EVENT;return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.wizardFormDirective");goog.module.declareLegacyNamespace();exports.WizardFormController=function($scope){this.scope_=$scope;this.pages=[];this.currentPage;this.currentPageIndex;this.scope_.$watchCollection("controller.pages",this.onPagesOrCurrentPageChange_.bind(this));this.scope_.$watch("controller.currentPage",this.onPagesOrCurrentPageChange_.bind(this));this.scope_.$watch("controller.currentPage",function(newValue){if(angular.isDefined(newValue))newValue.onShow()}.bind(this))};
var WizardFormController=exports.WizardFormController;WizardFormController.prototype.onPagesOrCurrentPageChange_=function(){this.currentPageIndex=this.pages.indexOf(this.currentPage)};WizardFormController.prototype.back=function(){var index=this.pages.indexOf(this.currentPage);if(index==0)throw new Error("Can't go back from the first page.");this.currentPage=this.pages[index-1]};WizardFormController.prototype.next=function(){var index=this.pages.indexOf(this.currentPage);if(index<this.pages.length-
1)this.currentPage=this.pages[index+1];else this.scope_["onResolve"]()};WizardFormController.prototype.reject=function(){this.scope_["onReject"]()};WizardFormController.prototype.registerPage=function(pageController){this.pages.push(pageController);if(angular.isUndefined(this.currentPage))this.currentPage=pageController};exports.WizardFormDirective=function(){return{scope:{title:"@",onResolve:"&",onReject:"&"},restrict:"E",transclude:true,templateUrl:"/static/angular-components/core/wizard-form.html",
controller:WizardFormController,controllerAs:"controller"}};exports.WizardFormDirective.directive_name="grrWizardForm";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.wizardFormPageDirective");goog.module.declareLegacyNamespace();exports.WizardFormPageController=function($scope,$attrs){this.scope_=$scope;this.attrs_=$attrs;this.formController;this.title;this.helpLink;this.prevButtonLabel="Back";this.nextButtonLabel="Next";this.noBackButton=false;this.isValid=true;this.scope_.$watch("title",function(newValue){this.title=newValue}.bind(this));this.scope_.$watch("prevButtonLabel",function(newValue){if(angular.isDefined(newValue))this.prevButtonLabel=
newValue}.bind(this));this.scope_.$watch("nextButtonLabel",function(newValue){if(angular.isDefined(newValue))this.nextButtonLabel=newValue}.bind(this));this.scope_.$watch("noBackButton",function(newValue){this.noBackButton=newValue}.bind(this));this.scope_.$watch("isValid",function(newValue){if(angular.isDefined(this.attrs_["isValid"]))this.isValid=newValue}.bind(this));this.scope_.$watch("helpLink",function(newValue){this.helpLink=newValue}.bind(this))};var WizardFormPageController=exports.WizardFormPageController;
WizardFormPageController.prototype.onShow=function(){this.scope_["onShow"]()};exports.WizardFormPageDirective=function(){return{scope:{title:"@",helpLink:"@",prevButtonLabel:"@",nextButtonLabel:"@",noBackButton:"=?",isValid:"=?",onShow:"&"},restrict:"E",transclude:true,templateUrl:"/static/angular-components/core/wizard-form-page.html",controller:WizardFormPageController,controllerAs:"controller",require:"^grrWizardForm",link:function(scope,element,attrs,formController){scope.controller.formController=
formController;formController.registerPage(scope.controller)}}};exports.WizardFormPageDirective.directive_name="grrWizardFormPage";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.core");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var23=goog.require("grrUi.core.aff4ObjectRepresentationDirective");var Aff4ObjectRepresentationDirective=$jscomp$destructuring$var23.Aff4ObjectRepresentationDirective;var $jscomp$destructuring$var24=goog.require("grrUi.core.apiItemsProviderDirective");var ApiItemsProviderDirective=$jscomp$destructuring$var24.ApiItemsProviderDirective;var $jscomp$destructuring$var25=
goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var25.ApiService;var $jscomp$destructuring$var26=goog.require("grrUi.core.basenameFilter");var BasenameFilter=$jscomp$destructuring$var26.BasenameFilter;var $jscomp$destructuring$var27=goog.require("grrUi.core.bindKeyDirective");var BindKeyDirective=$jscomp$destructuring$var27.BindKeyDirective;var $jscomp$destructuring$var28=goog.require("grrUi.core.bytesToHexFilter");var BytesToHexFilter=$jscomp$destructuring$var28.BytesToHexFilter;
var $jscomp$destructuring$var29=goog.require("grrUi.core.canaryOnlyDirective");var CanaryOnlyDirective=$jscomp$destructuring$var29.CanaryOnlyDirective;var NonCanaryOnlyDirective=$jscomp$destructuring$var29.NonCanaryOnlyDirective;var $jscomp$destructuring$var30=goog.require("grrUi.core.clockDirective");var ClockDirective=$jscomp$destructuring$var30.ClockDirective;var $jscomp$destructuring$var31=goog.require("grrUi.core.confirmationDialogDirective");var ConfirmationDialogDirective=$jscomp$destructuring$var31.ConfirmationDialogDirective;
var $jscomp$destructuring$var32=goog.require("grrUi.core.dialogService");var DialogService=$jscomp$destructuring$var32.DialogService;var $jscomp$destructuring$var33=goog.require("grrUi.core.disableIfNoTraitDirective");var DisableIfNoTraitDirective=$jscomp$destructuring$var33.DisableIfNoTraitDirective;var $jscomp$destructuring$var34=goog.require("grrUi.core.downloadCollectionAsDirective");var DownloadCollectionAsDirective=$jscomp$destructuring$var34.DownloadCollectionAsDirective;var $jscomp$destructuring$var35=
goog.require("grrUi.core.downloadCollectionFilesDirective");var DownloadCollectionFilesDirective=$jscomp$destructuring$var35.DownloadCollectionFilesDirective;var $jscomp$destructuring$var36=goog.require("grrUi.core.encodeUriComponentFilter");var EncodeUriComponentFilter=$jscomp$destructuring$var36.EncodeUriComponentFilter;var $jscomp$destructuring$var37=goog.require("grrUi.core.firebaseService");var FirebaseService=$jscomp$destructuring$var37.FirebaseService;var $jscomp$destructuring$var38=goog.require("grrUi.core.forceRefreshDirective");
var ForceRefreshDirective=$jscomp$destructuring$var38.ForceRefreshDirective;var $jscomp$destructuring$var39=goog.require("grrUi.core.globalNotificationsDirective");var GlobalNotificationsDirective=$jscomp$destructuring$var39.GlobalNotificationsDirective;var $jscomp$destructuring$var40=goog.require("grrUi.core.hexNumberFilter");var HexNumberFilter=$jscomp$destructuring$var40.HexNumberFilter;var $jscomp$destructuring$var41=goog.require("grrUi.core.infiniteTableDirective");var InfiniteTableDirective=
$jscomp$destructuring$var41.InfiniteTableDirective;var $jscomp$destructuring$var42=goog.require("grrUi.core.loadingIndicatorDirective");var LoadingIndicatorDirective=$jscomp$destructuring$var42.LoadingIndicatorDirective;var $jscomp$destructuring$var43=goog.require("grrUi.core.loadingIndicatorService");var LoadingIndicatorService=$jscomp$destructuring$var43.LoadingIndicatorService;var $jscomp$destructuring$var44=goog.require("grrUi.core.memoryItemsProviderDirective");var MemoryItemsProviderDirective=
$jscomp$destructuring$var44.MemoryItemsProviderDirective;var $jscomp$destructuring$var45=goog.require("grrUi.core.onScrollIntoViewDirective");var OnScrollIntoViewDirective=$jscomp$destructuring$var45.OnScrollIntoViewDirective;var $jscomp$destructuring$var46=goog.require("grrUi.core.pagedFilteredTableDirective");var PagedFilteredTableDirective=$jscomp$destructuring$var46.PagedFilteredTableDirective;var TableBottomDirective=$jscomp$destructuring$var46.TableBottomDirective;var TableTopDirective=$jscomp$destructuring$var46.TableTopDirective;
var $jscomp$destructuring$var47=goog.require("grrUi.core.periodicRefreshDirective");var PeriodicRefreshDirective=$jscomp$destructuring$var47.PeriodicRefreshDirective;var $jscomp$destructuring$var48=goog.require("grrUi.core.reflectionService");var ReflectionService=$jscomp$destructuring$var48.ReflectionService;var $jscomp$destructuring$var49=goog.require("grrUi.core.resultsCollectionDirective");var ResultsCollectionDirective=$jscomp$destructuring$var49.ResultsCollectionDirective;var $jscomp$destructuring$var50=
goog.require("grrUi.core.searchBoxDirective");var SearchBoxDirective=$jscomp$destructuring$var50.SearchBoxDirective;var $jscomp$destructuring$var51=goog.require("grrUi.core.serverErrorButtonDirective");var ServerErrorButtonDirective=$jscomp$destructuring$var51.ServerErrorButtonDirective;var $jscomp$destructuring$var52=goog.require("grrUi.core.serverErrorDialogDirective");var ServerErrorDialogDirective=$jscomp$destructuring$var52.ServerErrorDialogDirective;var $jscomp$destructuring$var53=goog.require("grrUi.core.serverErrorInterceptorFactory");
var ServerErrorInterceptorFactory=$jscomp$destructuring$var53.ServerErrorInterceptorFactory;var $jscomp$destructuring$var54=goog.require("grrUi.core.serverErrorPreviewDirective");var ServerErrorPreviewDirective=$jscomp$destructuring$var54.ServerErrorPreviewDirective;var $jscomp$destructuring$var55=goog.require("grrUi.core.splitterDirective");var SplitterDirective=$jscomp$destructuring$var55.SplitterDirective;var SplitterPaneDirective=$jscomp$destructuring$var55.SplitterPaneDirective;var $jscomp$destructuring$var56=
goog.require("grrUi.core.timeService");var TimeService=$jscomp$destructuring$var56.TimeService;var $jscomp$destructuring$var57=goog.require("grrUi.core.timeSinceFilter");var TimeSinceFilter=$jscomp$destructuring$var57.TimeSinceFilter;var $jscomp$destructuring$var58=goog.require("grrUi.core.timestampFilter");var TimestampFilter=$jscomp$destructuring$var58.TimestampFilter;var $jscomp$destructuring$var59=goog.require("grrUi.core.versionDropdownDirective");var VersionDropdownDirective=$jscomp$destructuring$var59.VersionDropdownDirective;
var $jscomp$destructuring$var60=goog.require("grrUi.core.wizardFormDirective");var WizardFormDirective=$jscomp$destructuring$var60.WizardFormDirective;var $jscomp$destructuring$var61=goog.require("grrUi.core.wizardFormPageDirective");var WizardFormPageDirective=$jscomp$destructuring$var61.WizardFormPageDirective;exports.coreModule=angular.module("grrUi.core",["ngCookies","ui.bootstrap"]);exports.coreModule.directive(Aff4ObjectRepresentationDirective.directive_name,Aff4ObjectRepresentationDirective);
exports.coreModule.directive(ApiItemsProviderDirective.directive_name,ApiItemsProviderDirective);exports.coreModule.directive(BindKeyDirective.directive_name,BindKeyDirective);exports.coreModule.directive(VersionDropdownDirective.directive_name,VersionDropdownDirective);exports.coreModule.directive(ForceRefreshDirective.directive_name,ForceRefreshDirective);exports.coreModule.directive(LoadingIndicatorDirective.directive_name,LoadingIndicatorDirective);exports.coreModule.directive(OnScrollIntoViewDirective.directive_name,
OnScrollIntoViewDirective);exports.coreModule.directive(MemoryItemsProviderDirective.directive_name,MemoryItemsProviderDirective);exports.coreModule.directive(PagedFilteredTableDirective.directive_name,PagedFilteredTableDirective);exports.coreModule.directive(TableTopDirective.directive_name,TableTopDirective);exports.coreModule.directive(TableBottomDirective.directive_name,TableBottomDirective);exports.coreModule.directive(PeriodicRefreshDirective.directive_name,PeriodicRefreshDirective);exports.coreModule.directive(InfiniteTableDirective.directive_name,
InfiniteTableDirective);exports.coreModule.directive(ResultsCollectionDirective.directive_name,ResultsCollectionDirective);exports.coreModule.directive(SplitterDirective.directive_name,SplitterDirective);exports.coreModule.directive(SplitterPaneDirective.directive_name,SplitterPaneDirective);exports.coreModule.directive(ClockDirective.directive_name,ClockDirective);exports.coreModule.directive(DownloadCollectionAsDirective.directive_name,DownloadCollectionAsDirective);exports.coreModule.directive(DownloadCollectionFilesDirective.directive_name,
DownloadCollectionFilesDirective);exports.coreModule.directive(WizardFormDirective.directive_name,WizardFormDirective);exports.coreModule.directive(WizardFormPageDirective.directive_name,WizardFormPageDirective);exports.coreModule.directive(ConfirmationDialogDirective.directive_name,ConfirmationDialogDirective);exports.coreModule.directive(DisableIfNoTraitDirective.directive_name,DisableIfNoTraitDirective);exports.coreModule.directive(CanaryOnlyDirective.directive_name,CanaryOnlyDirective);exports.coreModule.directive(NonCanaryOnlyDirective.directive_name,
NonCanaryOnlyDirective);exports.coreModule.directive(SearchBoxDirective.directive_name,SearchBoxDirective);exports.coreModule.directive(ServerErrorButtonDirective.directive_name,ServerErrorButtonDirective);exports.coreModule.directive(ServerErrorDialogDirective.directive_name,ServerErrorDialogDirective);exports.coreModule.directive(ServerErrorPreviewDirective.directive_name,ServerErrorPreviewDirective);exports.coreModule.directive(GlobalNotificationsDirective.directive_name,GlobalNotificationsDirective);
exports.coreModule.service(ApiService.service_name,ApiService);exports.coreModule.service(FirebaseService.service_name,FirebaseService);exports.coreModule.service(ReflectionService.service_name,ReflectionService);exports.coreModule.service(TimeService.service_name,TimeService);exports.coreModule.service(DialogService.service_name,DialogService);exports.coreModule.service(LoadingIndicatorService.service_name,LoadingIndicatorService);exports.coreModule.filter(BasenameFilter.filter_name,BasenameFilter);
exports.coreModule.filter(BytesToHexFilter.filter_name,BytesToHexFilter);exports.coreModule.filter(EncodeUriComponentFilter.filter_name,EncodeUriComponentFilter);exports.coreModule.filter(HexNumberFilter.filter_name,HexNumberFilter);exports.coreModule.filter(TimeSinceFilter.filter_name,TimeSinceFilter);exports.coreModule.filter(TimestampFilter.filter_name,TimestampFilter);exports.coreModule.factory(ServerErrorInterceptorFactory.factory_name,ServerErrorInterceptorFactory);exports.coreModule.config(function($httpProvider){$httpProvider.interceptors.push(ServerErrorInterceptorFactory.factory_name)});
return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.aff4AttributeFormDirective");goog.module.declareLegacyNamespace();var Aff4AttributeFormController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrApiService_.get("/reflection/aff4/attributes").then(this.onGetAttributes_.bind(this));this.allowedOptions=[]};Aff4AttributeFormController.prototype.onGetAttributes_=function(response){this.allowedOptions=[];angular.forEach(response["data"]["items"],
function(item){this.allowedOptions.push(item["value"]["name"]["value"])}.bind(this));this.allowedOptions=this.allowedOptions.sort();if(this.allowedOptions.length>0&&!this.scope_["value"]["value"])this.scope_["value"]["value"]=this.allowedOptions[0]};exports.Aff4AttributeFormDirective=function(){return{restrict:"E",scope:{value:"=",metadata:"="},templateUrl:"/static/angular-components/forms/aff4-attribute-form.html",controller:Aff4AttributeFormController,controllerAs:"controller"}};exports.Aff4AttributeFormDirective.directive_name=
"grrFormAff4Attribute";exports.Aff4AttributeFormDirective.semantic_type="AFF4Attribute";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.autoGeneratedAes128KeyFormDirective");goog.module.declareLegacyNamespace();exports.generateRandomBytes=function(length){var tokens="0123456789abcdef";var result=[];for(var i=0;i<length*2;++i)result.push(tokens[Math.floor(Math.random()*16)]);return result.join("")};var AutoGeneratedAES128KeyFormController=function($scope){this.scope_=$scope;this.scope_.$watch("value",this.onValueChange_.bind(this))};AutoGeneratedAES128KeyFormController.prototype.onValueChange_=
function(newValue){if(angular.isDefined(newValue)&&!newValue["value"])newValue["value"]=exports.generateRandomBytes(16)};exports.AutoGeneratedAES128KeyFormDirective=function(){return{scope:{value:"=",metadata:"=?",hiddenFields:"=?"},restrict:"E",templateUrl:"/static/angular-components/forms/"+"auto-generated-aes128-key-form.html",controller:AutoGeneratedAES128KeyFormController,controllerAs:"controller"}};exports.AutoGeneratedAES128KeyFormDirective.directive_name="grrFormAutoGeneratedAes128Key";exports.AutoGeneratedAES128KeyFormDirective.semantic_type=
"AutoGeneratedAES128Key";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.bytesFormDirective");goog.module.declareLegacyNamespace();exports.bytesToHexEncodedString=function(bytes){var segmentStart=0;var str=[];var blen=bytes.length;for(var i=0;i<blen;i+=1){var c=bytes.charCodeAt(i);if(c<32||c>126){var segmentLength=i-segmentStart;if(segmentLength>0)str.push(bytes.substr(segmentStart,segmentLength));segmentStart=i+1;var hc=c.toString(16);if(hc.length==1)hc="0"+hc;str.push("\\x"+hc)}}segmentLength=blen-
segmentStart;if(segmentLength>0)str.push(bytes.substr(segmentStart,segmentLength));return str.join("")};var bytesToHexEncodedString=exports.bytesToHexEncodedString;exports.hexEncodedStringToBytes=function(str){return str.replace(/\\x([0-9A-Fa-f]{2})/g,function(){return String.fromCharCode(parseInt(arguments[1],16))})};var hexEncodedStringToBytes=exports.hexEncodedStringToBytes;exports.isByteString=function(str){var blen=str.length;for(var i=0;i<blen;i+=1){var c=str.charCodeAt(i);if(c>=256)return false}return true};
var isByteString=exports.isByteString;var BytesFormController=function($scope,$window){this.scope_=$scope;this.window_=$window;this.valueString="";this.scope_.$watch("value.value",this.onValueChange_.bind(this));this.scope_.$watch("controller.valueString",this.onValueStringChange_.bind(this))};BytesFormController.prototype.onValueChange_=function(newValue){if(angular.isString(newValue))try{var base64DecodedBytes=this.window_.atob(newValue);if(base64DecodedBytes!=hexEncodedStringToBytes(this.valueString))this.valueString=
bytesToHexEncodedString(base64DecodedBytes)}catch(err){this.valueString=""}};BytesFormController.prototype.onValueStringChange_=function(newValue){if(angular.isUndefined(newValue))return;if(!isByteString(newValue)){this.scope_["value"]["validationError"]="Unicode characters are not allowed in a byte string.";return}else delete this.scope_["value"]["validationError"];this.scope_["value"]["value"]=this.window_.btoa(hexEncodedStringToBytes(newValue))};exports.BytesFormDirective=function(){return{restrict:"E",
scope:{value:"=",metadata:"="},templateUrl:"/static/angular-components/forms/bytes-form.html",controller:BytesFormController,controllerAs:"controller"}};exports.BytesFormDirective.directive_name="grrFormBytes";exports.BytesFormDirective.semantic_type="RDFBytes";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.clientLabelFormDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var62=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var62.ApiService;var stripTypeInfo=$jscomp$destructuring$var62.stripTypeInfo;var ClientLabelFormController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.labelsList;this.clientLabel;this.formLabel;this.hideEmptyOption;
this.emptyOptionLabel;this.grrApiService_.get("/clients/labels").then(function(response){this.labelsList=stripTypeInfo(response["data"]["items"]);this.scope_.$watch("controller.hideEmptyOption",function(){if(!this.clientLabel&&this.hideEmptyOption&&this.labelsList.length>0)this.clientLabel=this.labelsList[0]["name"]}.bind(this))}.bind(this))};ClientLabelFormController.prototype.$onInit=function(){this.hideEmptyOption=this.hideEmptyOption||false;this.emptyOptionLabel=this.emptyOptionLabel||"-- All clients --"};
exports.ClientLabelFormDirective=function(){return{scope:{clientLabel:"=",formLabel:"=?",hideEmptyOption:"=?",emptyOptionLabel:"=?"},bindToController:true,restrict:"E",templateUrl:"/static/angular-components/forms/client-label-form.html",controller:ClientLabelFormController,controllerAs:"controller"}};exports.ClientLabelFormDirective.directive_name="grrFormClientLabel";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.datetimeFormDirective");goog.module.declareLegacyNamespace();var DatetimeFormController=function($scope){this.scope_=$scope;this.valueString="";this.isInvalid=false;this.format="YYYY-MM-DD HH:mm";this.example=moment.utc("1989-04-20T13:42:00.000Z").utc().format(this.format);this.scope_.$watch("value.value",this.onValueChange_.bind(this));this.scope_.$watch("controller.valueString",this.onValueStringChange_.bind(this))};DatetimeFormController.prototype.onValueChange_=
function(newValue){if(angular.isNumber(newValue)){var parsed=moment.utc(newValue/1E3);if(parsed.isValid()){var newValueString=parsed.format(this.format);if(!moment.utc(this.valueString,this.format).isSame(parsed))this.valueString=newValueString}else this.valueString=""}};DatetimeFormController.prototype.onValueStringChange_=function(newValue){if(newValue==""){this.scope_.value.value=null;this.isInvalid=false}else{var parsed=moment.utc(newValue,this.format,true);if(parsed.isValid()){this.scope_.value.value=
parsed.valueOf()*1E3;this.isInvalid=false}else{this.scope_.value.value=null;this.isInvalid=true}}};DatetimeFormController.prototype.today=function(){this.scope_.value.value=moment().valueOf()*1E3};exports.DatetimeFormDirective=function(){return{restrict:"E",scope:{value:"=",metadata:"="},templateUrl:"/static/angular-components/forms/datetime-form.html",controller:DatetimeFormController,controllerAs:"controller"}};exports.DatetimeFormDirective.directive_name="grrFormDatetime";exports.DatetimeFormDirective.semantic_type=
"RDFDatetime";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.dictFormDirective");goog.module.declareLegacyNamespace();var DictFormController=function($scope,grrReflectionService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.keyValueList;this.keyValueDescriptor;this.stringDefault;this.grrReflectionService_.getRDFValueDescriptor("RDFString").then(function(descriptor){this.stringDefault=descriptor["default"];this.scope_.$watch("controller.keyValueList",this.onKeyValueListChange_.bind(this),
true);this.scope_.$watch("value.value",this.onValueChange_.bind(this),true)}.bind(this))};DictFormController.prototype.convertFromRDFString=function(value){if(angular.isUndefined(value)||value["type"]!="RDFString")return value;value=angular.copy(value);var s=value["value"].trim();if(/^\d+$/.test(s)){value["value"]=parseInt(s,10);value["type"]="RDFInteger"}else if(/^0x[0-9a-fA-F]+$/.test(s)){value["value"]=parseInt(s.substring(2),16);value["type"]="RDFInteger"}else if(s.toLowerCase()=="true"){value["value"]=
true;value["type"]="RDFBool"}else if(s.toLowerCase()=="false"){value["value"]=false;value["type"]="RDFBool"}return value};DictFormController.prototype.onKeyValueListChange_=function(newValue){if(angular.isDefined(newValue)){this.scope_.value.value={};for(var i=0;i<this.keyValueList.length;++i){var pair=this.keyValueList[i];this.scope_.value.value[pair["key"]]=this.convertFromRDFString(pair["value"])}}};DictFormController.prototype.onValueChange_=function(newValue){if(angular.isObject(newValue)){if(angular.isUndefined(this.keyValueList))this.keyValueList=
[];angular.forEach(newValue,function(value,key){var found=false;for(var i=0;i<this.keyValueList.length;++i){var pair=this.keyValueList[i];if(pair["key"]==key){found=true;if(!angular.equals(this.convertFromRDFString(pair["value"]),value))pair["value"]=value}}if(!found)this.keyValueList.push({key:key,value:value})}.bind(this))}else this.keyValueList=[]};DictFormController.prototype.addPair=function(){this.keyValueList.push({key:"",value:angular.copy(this.stringDefault)})};DictFormController.prototype.removePair=
function(index){this.keyValueList.splice(index,1)};exports.DictFormDirective=function(){return{restrict:"E",scope:{value:"="},templateUrl:"/static/angular-components/forms/dict-form.html",controller:DictFormController,controllerAs:"controller"}};exports.DictFormDirective.directive_name="grrFormDict";exports.DictFormDirective.semantic_types=["dict","Dict"];return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.durationDirective");goog.module.declareLegacyNamespace();var hasFraction_=function(value){return value-Math.floor(value)>1E-16};exports.stringifySeconds=function(value){if(value==0)return"0";var newDuration=moment.duration(value,"s");var unit;var units=["d","h","m","s"];for(var i=0;i<units.length;++i)if(!hasFraction_(newDuration.as(units[i]))){unit=units[i];break}if(angular.isUndefined(unit))throw new Error("Internal logic error: unit can't be undefined.");
var n=newDuration.as(unit);if(unit=="d"&&n%7==0){n=n/7;unit="w"}return n.toString()+unit};var DurationController=function($scope){this.scope_=$scope;this.stringifiedDuration;this.scope_.$watch("::value",this.onValueChange.bind(this))};DurationController.prototype.onValueChange=function(newValue){var duration=newValue.value;if(angular.isNumber(duration))this.stringifiedDuration=exports.stringifySeconds(duration);else this.stringifiedDuration="-"};exports.DurationDirective=function(){return{scope:{value:"="},
restrict:"E",template:'<nobr ng-if="::controller.stringifiedDuration">'+"{$ ::controller.stringifiedDuration $}</nobr>",controller:DurationController,controllerAs:"controller"}};exports.DurationDirective.directive_name="grrDuration";exports.DurationDirective.semantic_type="Duration";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.durationFormDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var63=goog.require("grrUi.semantic.durationDirective");var stringifySeconds=$jscomp$destructuring$var63.stringifySeconds;var DurationFormController=function($scope){this.scope_=$scope;this.valueString="";this.isInvalid=false;this.regex_=/^(\d+)([smhdw])?$/;this.scope_.$watch("value.value",this.onValueChange_.bind(this));this.scope_.$watch("controller.valueString",
this.onValueStringChange_.bind(this))};DurationFormController.prototype.parseString_=function(stringValue){var match=stringValue.trim().match(this.regex_);if(match==null)return null;else{var n=parseInt(match[1],10);var unit=match[2]||"s";return moment.duration(n,unit)}};DurationFormController.prototype.onValueChange_=function(newValue){if(angular.isNumber(newValue)){var currentParsedDuration=this.parseString_(this.valueString);if(currentParsedDuration!=null&&newValue==currentParsedDuration.asSeconds())return;
this.valueString=stringifySeconds(newValue)}};DurationFormController.prototype.onValueStringChange_=function(newValue){if(newValue==""){this.scope_.value.value=null;this.isInvalid=false}else{var duration=this.parseString_(newValue);this.scope_.value.value=duration!==null?duration.asSeconds():null;this.isInvalid=duration===null}};exports.DurationFormDirective=function(){return{restrict:"E",scope:{value:"=",metadata:"="},templateUrl:"/static/angular-components/forms/duration-form.html",controller:DurationFormController,
controllerAs:"controller"}};exports.DurationFormDirective.directive_name="grrFormDuration";exports.DurationFormDirective.semantic_type="Duration";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.foremanLabelRuleFormDirective");goog.module.declareLegacyNamespace();var ForemanLabelRuleFormController=function($scope,grrReflectionService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.defaultLabel_="";this.grrReflectionService_.getRDFValueDescriptor("ForemanLabelClientRule").then(function(descriptor){angular.forEach(descriptor["fields"],function(field){if(field["name"]=="match_mode")this.matchModeMetadata=
field}.bind(this));this.scope_.$watch("value.value",function(value){if(angular.isDefined(value)){if(angular.isUndefined(value["match_mode"]))value["match_mode"]=angular.copy(this.matchModeMetadata["default"]);if(angular.isUndefined(value["label_names"]))value["label_names"]=[];if(value["label_names"].length==0)this.addLabel()}}.bind(this))}.bind(this))};ForemanLabelRuleFormController.prototype.addLabel=function(){this.scope_["value"]["value"]["label_names"].push({type:"unicode",value:this.defaultLabel_})};
ForemanLabelRuleFormController.prototype.removeLabel=function(index){this.scope_["value"]["value"]["label_names"].splice(index,1)};exports.ForemanLabelRuleFormDirective=function(){return{restrict:"E",scope:{value:"=",metadata:"="},templateUrl:"/static/angular-components/forms/foreman-label-rule-form.html",controller:ForemanLabelRuleFormController,controllerAs:"controller"}};exports.ForemanLabelRuleFormDirective.directive_name="grrFormLabel";exports.ForemanLabelRuleFormDirective.semantic_type="ForemanLabelClientRule";
return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.globExpressionFormDirective");goog.module.declareLegacyNamespace();var GlobExpressionFormController=function($element,$interval,grrApiService){this.element_=$element;this.interval_=$interval;this.grrApiService_=grrApiService;this.grrApiService_.get("/clients/kb-fields").then(this.onGetFields_.bind(this))};GlobExpressionFormController.prototype.completionFilter_=function(completions,term){var matcher=new RegExp("^"+$["ui"]["autocomplete"]["escapeRegex"](term),
"i");return $["grep"](completions,function(value){return matcher.test(value.label||value.value||value)})};GlobExpressionFormController.prototype.buildCompleter_=function(element,completions){if(angular.isString(element))element=$("#"+element);var self=this;element.bind("keydown",function(event){if(event.keyCode===$["ui"]["keyCode"]["TAB"]&&$(this).data("ui-autocomplete")["menu"]["active"])event.preventDefault()})["autocomplete"]({minLength:0,source:function(request,response){var terms=request["term"].split(/%%/);
if(terms.length%2)response([]);else response(self.completionFilter_(completions,terms.pop()))},focus:function(){return false},select:function(event,ui){var terms=this.value.split(/%%/);terms.pop();terms.push(ui.item.value);terms.push("");this.value=terms.join("%%");$(this).change();return false}}).wrap('<abbr title="Type %% to open a list of possible completions."/>')};GlobExpressionFormController.prototype.onGetFields_=function(response){var fieldsNames=[];angular.forEach(response["data"]["items"],
function(field){fieldsNames.push(field["value"])}.bind(this));var intervalPromise=this.interval_(function(){var inputBox=$(this.element_).find("input");if(inputBox){this.buildCompleter_(inputBox,fieldsNames);this.interval_.cancel(intervalPromise)}}.bind(this),500,10)};exports.GlobExpressionFormDirective=function(){return{restrict:"E",scope:{value:"=",metadata:"="},templateUrl:"/static/angular-components/forms/glob-expression-form.html",controller:GlobExpressionFormController,controllerAs:"controller"}};
exports.GlobExpressionFormDirective.directive_name="grrFormGlobExpression";exports.GlobExpressionFormDirective.semantic_type="GlobExpression";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.globExpressionsListFormDirective");goog.module.declareLegacyNamespace();var GlobExpressionsListFormController=function($scope){this.scope_=$scope;this.scope_.$watchGroup(["descriptor","value","field"],this.onArgumentsChange_.bind(this))};GlobExpressionsListFormController.prototype.onArgumentsChange_=function(){if(angular.isDefined(this.scope_["descriptor"])&&angular.isDefined(this.scope_["field"])&&angular.isDefined(this.scope_["value"]))if(this.scope_["value"].length==
0){var newGlob=angular.copy(this.scope_["descriptor"]["default"]);this.scope_["value"].push(newGlob)}};exports.GlobExpressionsListFormDirective=function(){return{restrict:"E",scope:{descriptor:"=",value:"=",field:"="},templateUrl:"/static/angular-components/forms/"+"glob-expressions-list-form.html",controller:GlobExpressionsListFormController,controllerAs:"controller"}};exports.GlobExpressionsListFormDirective.directive_name="grrGlobExpressionsListForm";exports.GlobExpressionsListFormDirective.hideCustomTemplateLabel=
true;exports.GlobExpressionsListFormDirective.semantic_type="GlobExpression";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.outputPluginDescriptorFormDirective");goog.module.declareLegacyNamespace();var OutputPluginDescriptorFormController=function($scope,grrApiService,grrReflectionService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrReflectionService_=grrReflectionService;this.outputPluginsDescriptors;this.allowedPluginsNames;this.grrApiService_.get("/output-plugins/all").then(function(response){this.outputPluginsDescriptors={};angular.forEach(response["data"]["items"],
function(item){if(item["plugin_type"]==="LEGACY")this.outputPluginsDescriptors[item["name"]]=item}.bind(this));this.allowedPluginsNames=Object.keys(this.outputPluginsDescriptors).sort();if(angular.isUndefined(this.scope_.$eval("value.value.plugin_name.value")))this.scope_["value"]["value"]["plugin_name"]={type:"RDFString",value:this.allowedPluginsNames[0]};this.scope_.$watch("value.value.plugin_name.value",function(newValue){if(angular.isDefined(newValue)){var argsType=this.outputPluginsDescriptors[newValue]["args_type"];
var pluginArgs=this.scope_["value"]["value"]["plugin_args"];if(angular.isUndefined(pluginArgs)||pluginArgs["type"]!=argsType)this.grrReflectionService_.getRDFValueDescriptor(argsType).then(function(descriptor){this.scope_["value"]["value"]["plugin_args"]=angular.copy(descriptor["default"])}.bind(this))}}.bind(this))}.bind(this))};exports.OutputPluginDescriptorFormDirective=function(){return{restrict:"E",scope:{value:"="},templateUrl:"/static/angular-components/forms/"+"output-plugin-descriptor-form.html",
controller:OutputPluginDescriptorFormController,controllerAs:"controller"}};exports.OutputPluginDescriptorFormDirective.directive_name="grrOutputPluginDescriptorForm";exports.OutputPluginDescriptorFormDirective.semantic_type="OutputPluginDescriptor";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.semanticEnumFormDirective");goog.module.declareLegacyNamespace();var SemanticEnumFormController=function($scope){this.scope_=$scope;this.allowedOptions=[];this.scope_.$watch("metadata.allowed_values",this.onAllowedValuesChange_.bind(this))};SemanticEnumFormController.prototype.onAllowedValuesChange_=function(newValue){this.allowedOptions=[];if(angular.isDefined(newValue)){this.allowedOptions=[];angular.forEach(newValue,function(option){var defaultLabel=
"";var defaultOptionName=this.scope_.$eval("metadata.default.value");if(defaultOptionName==option.name)defaultLabel=" (default)";var label=option.name;if(option.doc)label=option.doc;this.allowedOptions.push({value:option.name,label:label+defaultLabel})}.bind(this))}};exports.SemanticEnumFormDirective=function(){return{restrict:"E",scope:{value:"=",metadata:"="},templateUrl:"/static/angular-components/forms/semantic-enum-form.html",controller:SemanticEnumFormController,controllerAs:"controller"}};
exports.SemanticEnumFormDirective.directive_name="grrFormEnum";exports.SemanticEnumFormDirective.semantic_type="EnumNamedValue";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.semanticPrimitiveFormDirective");goog.module.declareLegacyNamespace();var SemanticPrimitiveFormController=function($scope,grrReflectionService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.valueType;this.scope_.$watch("value.type",this.onValueTypeChange_.bind(this))};SemanticPrimitiveFormController.prototype.onValueTypeChange_=function(newValue){if(newValue===undefined){this.valueType=undefined;return}var descriptorHandler=
function(descriptor){var allowedTypes=exports.SemanticPrimitiveFormDirective.semantic_types;var typeIndex=-1;angular.forEach(allowedTypes,function(type){var index=descriptor["mro"].indexOf(type);if(index!=-1&&(typeIndex==-1||typeIndex>index)){typeIndex=index;this.valueType=type}}.bind(this));if(!this.valueType)this.valueType="RDFString"}.bind(this);this.grrReflectionService_.getRDFValueDescriptor(newValue).then(descriptorHandler)};exports.SemanticPrimitiveFormDirective=function(){return{restrict:"E",
scope:{value:"="},templateUrl:"/static/angular-components/forms/"+"semantic-primitive-form.html",controller:SemanticPrimitiveFormController,controllerAs:"controller"}};exports.SemanticPrimitiveFormDirective.directive_name="grrFormPrimitive";exports.SemanticPrimitiveFormDirective.semantic_types=["RDFBool","bool","RDFInteger","int","long","float","RDFString","basestring","RDFURN","bytes"];return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.semanticProtoFormDirective");goog.module.declareLegacyNamespace();var SemanticProtoFormController=function($scope,$attrs,grrReflectionService){this.scope_=$scope;this.scope_.value;this.grrReflectionService_=grrReflectionService;this.advancedShown=false;this.hasAdvancedFields=false;this.expanded=false;this.editedValue;if(angular.isDefined($attrs["hiddenFields"])&&angular.isDefined($attrs["visibleFields"]))throw new Error("Either hidden-fields or visible-fields attribute may "+
"be specified, not both.");this.scope_.$watch("value",this.onValueChange_.bind(this));this.scope_.$watch("controller.editedValue.value",this.onEditedValueChange_.bind(this),true);this.boundNotExplicitlyHiddenFields=this.notExplicitlyHiddenFields_.bind(this)};SemanticProtoFormController.prototype.notExplicitlyHiddenFields_=function(field,opt_index){if(angular.isDefined(this.scope_["hiddenFields"]))return this.scope_["hiddenFields"].indexOf(field["name"])==-1;else if(angular.isDefined(this.scope_["visibleFields"]))return this.scope_["visibleFields"].indexOf(field["name"])!=
-1;else return true};SemanticProtoFormController.prototype.regularFieldsOnly=function(field,index){return angular.isUndefined(field.labels)||field.labels.indexOf("HIDDEN")==-1&&field.labels.indexOf("ADVANCED")==-1};SemanticProtoFormController.prototype.advancedFieldsOnly=function(field,index){return angular.isDefined(field.labels)&&field.labels.indexOf("HIDDEN")==-1&&field.labels.indexOf("ADVANCED")!=-1};SemanticProtoFormController.prototype.onValueChange_=function(newValue,oldValue){if(angular.isUndefined(newValue)){this.descriptors=
undefined;this.valueDescriptor=undefined;this.editedValue=undefined;return}if(newValue!==oldValue||angular.isUndefined(this.valueDescriptor))this.grrReflectionService_.getRDFValueDescriptor(this.scope_.value.type,true).then(this.onDescriptorsFetched_.bind(this))};SemanticProtoFormController.prototype.onEditedValueChange_=function(newValue,oldValue){if(angular.isDefined(newValue)){if(angular.isDefined(oldValue))angular.forEach(newValue,function(value,key){if(!angular.equals(oldValue[key],newValue[key]))this.scope_.value.value[key]=
value}.bind(this));angular.forEach(this.valueDescriptor["fields"],function(field){if(this.notExplicitlyHiddenFields_(field))if(field.type&&angular.equals(this.scope_.value.value[field.name],this.descriptors[field.type]["default"])&&(angular.isUndefined(field["default"])||angular.equals(field["default"],this.descriptors[field.type]["default"])))delete this.scope_.value.value[field.name]}.bind(this))}};SemanticProtoFormController.prototype.onDescriptorsFetched_=function(descriptors){this.descriptors=
descriptors;this.valueDescriptor=angular.copy(descriptors[this.scope_.value.type]);this.editedValue=angular.copy(this.scope_.value);if(angular.isUndefined(this.editedValue.value))this.editedValue.value={};angular.forEach(this.valueDescriptor["fields"],function(field){if(angular.isDefined(field.labels)){if(field.labels.indexOf("HIDDEN")!=-1)return;if(field.labels.indexOf("ADVANCED")!=-1)this.hasAdvancedFields=true}if(field.repeated){field.depth=0;if(angular.isUndefined(this.editedValue.value[field.name]))this.editedValue.value[field.name]=
[]}else{field.depth=(this.scope_.$eval("metadata.depth")||0)+1;if(angular.isUndefined(this.editedValue.value[field.name]))if(angular.isDefined(field["default"]))this.editedValue.value[field.name]=angular.copy(field["default"]);else this.editedValue.value[field.name]=angular.copy(descriptors[field.type]["default"])}}.bind(this))};exports.SemanticProtoFormDirective=function(){return{scope:{value:"=",metadata:"=?",hiddenFields:"=?",visibleFields:"=?"},restrict:"E",templateUrl:"/static/angular-components/forms/semantic-proto-form.html",
controller:SemanticProtoFormController,controllerAs:"controller"}};exports.SemanticProtoFormDirective.directive_name="grrFormProto";exports.SemanticProtoFormDirective.semantic_type="RDFProtoStruct";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.semanticProtoRepeatedFieldFormDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var64=goog.require("grrUi.core.utils");var camelCaseToDashDelimited=$jscomp$destructuring$var64.camelCaseToDashDelimited;var SemanticProtoRepeatedFieldFormController=function($scope,$element,$compile,grrSemanticRepeatedFormDirectivesRegistryService){this.scope_=$scope;this.element_=$element;this.compile_=$compile;this.grrSemanticRepeatedFormDirectivesRegistryService_=
grrSemanticRepeatedFormDirectivesRegistryService;this.hasCustomTemplate;this.hideCustomTemplateLabel;this.scope_.$watchGroup(["field","descriptor","value"],this.onFieldDescriptorChange_.bind(this))};SemanticProtoRepeatedFieldFormController.prototype.onFieldDescriptorChange_=function(){if(angular.isDefined(this.scope_["field"])&&angular.isDefined(this.scope_["descriptor"])&&angular.isDefined(this.scope_["value"]))if(this.scope_["noCustomTemplate"])this.onCustomDirectiveNotFound_();else this.grrSemanticRepeatedFormDirectivesRegistryService_.findDirectiveForType(this.scope_["descriptor"]["mro"][0]).then(this.onCustomDirectiveFound_.bind(this),
this.onCustomDirectiveNotFound_.bind(this))};SemanticProtoRepeatedFieldFormController.prototype.onCustomDirectiveNotFound_=function(){this.hasCustomTemplate=false};SemanticProtoRepeatedFieldFormController.prototype.onCustomDirectiveFound_=function(directive){this.hasCustomTemplate=true;this.hideCustomTemplateLabel=directive["hideCustomTemplateLabel"];var element=angular.element("<span />");element.html("<"+camelCaseToDashDelimited(directive.directive_name)+' descriptor="descriptor" value="value" field="field" />');
var template=this.compile_(element);var customTemplateElement;if(this.hideCustomTemplateLabel)customTemplateElement=this.element_.find('div[name="custom-template-without-label"]');else customTemplateElement=this.element_.find('div[name="custom-template"]');customTemplateElement.html("");template(this.scope_,function(cloned,opt_scope){customTemplateElement.append(cloned)}.bind(this))};SemanticProtoRepeatedFieldFormController.prototype.addItem=function(){this.scope_.value.splice(0,0,angular.copy(this.scope_["descriptor"]["default"]))};
SemanticProtoRepeatedFieldFormController.prototype.removeItem=function(index){this.scope_.value.splice(index,1)};exports.SemanticProtoRepeatedFieldFormDirective=function(){return{scope:{value:"=",descriptor:"=",field:"=",noCustomTemplate:"="},restrict:"E",templateUrl:"/static/angular-components/forms/"+"semantic-proto-repeated-field-form.html",controller:SemanticProtoRepeatedFieldFormController,controllerAs:"controller"}};exports.SemanticProtoRepeatedFieldFormDirective.directive_name="grrFormProtoRepeatedField";
return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.semanticProtoSingleFieldFormDirective");goog.module.declareLegacyNamespace();exports.SemanticProtoSingleFieldFormDirective=function(){return{scope:{value:"=",field:"="},restrict:"E",templateUrl:"/static/angular-components/forms/"+"semantic-proto-single-field-form.html"}};exports.SemanticProtoSingleFieldFormDirective.directive_name="grrFormProtoSingleField";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.semanticProtoUnionFormDirective");goog.module.declareLegacyNamespace();var SemanticProtoUnionFormController=function($scope){this.scope_=$scope;this.unionField;this.unionFieldValue;$scope.$watch("descriptor",this.onDescriptorChange_.bind(this));$scope.$watch("value.value[controller.unionField.name].value",this.onUnionFieldValueChange_.bind(this))};SemanticProtoUnionFormController.prototype.onDescriptorChange_=function(newValue){if(angular.isUndefined(newValue))this.unionField=
undefined;else angular.forEach(newValue["fields"],function(field){if(field.name==newValue["union_field"])this.unionField=field}.bind(this))};SemanticProtoUnionFormController.prototype.onUnionFieldValueChange_=function(newValue,oldValue){if(angular.isDefined(newValue)){if(angular.isDefined(oldValue)&&oldValue!==newValue){var unionPart=this.scope_["value"]["value"][this.unionFieldValue];if(angular.isObject(unionPart)){unionPart["value"]={};this.scope_["value"]["value"][this.unionFieldValue]=angular.copy(unionPart)}}this.unionFieldValue=
newValue.toLowerCase()}else this.unionFieldValue=undefined};exports.SemanticProtoUnionFormDirective=function(){return{scope:{value:"=",descriptor:"="},restrict:"E",templateUrl:"/static/angular-components/forms/"+"semantic-proto-union-form.html",controller:SemanticProtoUnionFormController,controllerAs:"controller"}};exports.SemanticProtoUnionFormDirective.directive_name="grrFormProtoUnion";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.core.semanticRegistryService");goog.module.declareLegacyNamespace();exports.SemanticRegistryService=function($q,grrReflectionService){this.q_=$q;this.grrReflectionService_=grrReflectionService;this.directivesByType_={}};var SemanticRegistryService=exports.SemanticRegistryService;SemanticRegistryService.values_service_name="grrSemanticValueDirectivesRegistryService";SemanticRegistryService.forms_service_name="grrSemanticFormDirectivesRegistryService";
SemanticRegistryService.repeated_forms_service_name="grrSemanticRepeatedFormDirectivesRegistryService";SemanticRegistryService.output_plugins_service_name="grrOutputPluginsDirectivesRegistryService";SemanticRegistryService.prototype.registerDirective=function(type,directive){this.directivesByType_[type]=directive};SemanticRegistryService.prototype.findDirectiveForMro=function(mro,overrides){overrides=overrides||{};for(var i=0;i<mro.length;++i){var objType=mro[i];var directive=overrides[objType];if(angular.isUndefined(directive))directive=
this.directivesByType_[objType];if(angular.isDefined(directive))return directive}return undefined};SemanticRegistryService.prototype.findDirectiveForType=function(type,overrides){overrides=overrides||{};if(angular.isDefined(overrides[type])){var deferred=this.q_.defer();deferred.resolve(overrides[type]);return deferred.promise}if(angular.isDefined(this.directivesByType_[type])){var deferred=this.q_.defer();deferred.resolve(this.directivesByType_[type]);return deferred.promise}var handleDescriptor=
function(descriptor){var directive=this.findDirectiveForMro(descriptor["mro"],overrides);if(angular.isDefined(directive))return directive;else return this.q_.reject(new Error("No directive found."))}.bind(this);return this.grrReflectionService_.getRDFValueDescriptor(type).then(handleDescriptor)};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.semanticValueFormDirective");goog.module.declareLegacyNamespace();var templatesCache={};exports.clearCaches=function(){templatesCache={}};exports.SemanticValueFormController=function($scope,$compile,$element,grrSemanticFormDirectivesRegistryService){this.scope_=$scope;this.compile_=$compile;this.element_=$element;this.elementScope_;this.grrSemanticFormDirectivesRegistryService_=grrSemanticFormDirectivesRegistryService;this.scope_.$watch("value.type",
this.onValueTypeChange_.bind(this))};var SemanticValueFormController=exports.SemanticValueFormController;SemanticValueFormController.prototype.onValueTypeChange_=function(newValue){this.element_.html("");if(angular.isDefined(this.elementScope_)){this.elementScope_.$destroy();this.elementScope_=undefined}if(angular.isUndefined(newValue))return;var updateElement=function(tmpl){if(angular.isDefined(tmpl)){this.elementScope_=this.scope_.$new();tmpl(this.elementScope_,function(cloned,opt_scope){this.element_.append(cloned)}.bind(this))}else this.element_.text("Can't handle type: "+
this.value["type"])}.bind(this);var value=this.scope_.value;var template=templatesCache[value["type"]];if(angular.isUndefined(template))this.compileSingleTypedValueTemplate_(value).then(function(template){templatesCache[value["type"]]=template;updateElement(template)}.bind(this));else updateElement(template)};SemanticValueFormController.prototype.camelCaseToDashDelimited=function(directiveName){return directiveName.replace(/([a-z\d])([A-Z])/g,"$1-$2").toLowerCase()};SemanticValueFormController.prototype.compileSingleTypedValueTemplate_=
function(value){var successHandler=function success(directive){var element=angular.element("<span />");element.html("<"+this.camelCaseToDashDelimited(directive.directive_name)+' metadata="metadata" value="value" />');return this.compile_(element)}.bind(this);var failureHandler=function failure(){var element=angular.element("<span />");element.html('<p class="form-control-static">No directive '+"for type: {$ value.type $}.</p>");return this.compile_(element)}.bind(this);return this.grrSemanticFormDirectivesRegistryService_.findDirectiveForType(value["type"]).then(successHandler,
failureHandler)};exports.SemanticValueFormDirective=function(){return{restrict:"E",scope:{value:"=",metadata:"=?"},controller:SemanticValueFormController,controllerAs:"controller"}};exports.SemanticValueFormDirective.directive_name="grrFormValue";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.timerangeFormDirective");goog.module.declareLegacyNamespace();var TimerangeFormController=function($scope,grrReflectionService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.startTimeSecs;this.formStartTime;this.durationSecs;this.formDuration;this.startTimeLabel;this.durationLabel;this.grrReflectionService_.getRDFValueDescriptor("RDFDatetime").then(function(rdfDesc){this.formStartTime=angular.copy(rdfDesc["default"]);
return this.grrReflectionService_.getRDFValueDescriptor("Duration")}.bind(this)).then(function(rdfDesc){this.formDuration=angular.copy(rdfDesc["default"]);this.scope_.$watchGroup(["controller.startTimeSecs","controller.durationSecs"],this.onParamsChange_.bind(this));this.scope_.$watchGroup(["controller.formStartTime.value","controller.formDuration.value"],this.onSubformsChange_.bind(this));this.onParamsChange_()}.bind(this))};TimerangeFormController.prototype.onParamsChange_=function(){if(angular.isDefined(this.startTimeSecs))this.formStartTime["value"]=
this.startTimeSecs*1E6;if(angular.isDefined(this.durationSecs))this.formDuration["value"]=this.durationSecs};TimerangeFormController.prototype.onSubformsChange_=function(){this.startTimeSecs=this.formStartTime["value"]/1E6;this.durationSecs=this.formDuration["value"]};exports.TimerangeFormDirective=function(){return{scope:{startTimeSecs:"=",durationSecs:"=",startTimeLabel:"=?",durationLabel:"=?"},bindToController:true,restrict:"E",templateUrl:"/static/angular-components/forms/timerange-form.html",
controller:TimerangeFormController,controllerAs:"controller"}};exports.TimerangeFormDirective.directive_name="grrFormTimerange";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.forms");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var65=goog.require("grrUi.forms.aff4AttributeFormDirective");var Aff4AttributeFormDirective=$jscomp$destructuring$var65.Aff4AttributeFormDirective;var $jscomp$destructuring$var66=goog.require("grrUi.forms.autoGeneratedAes128KeyFormDirective");var AutoGeneratedAES128KeyFormDirective=$jscomp$destructuring$var66.AutoGeneratedAES128KeyFormDirective;var $jscomp$destructuring$var67=
goog.require("grrUi.forms.bytesFormDirective");var BytesFormDirective=$jscomp$destructuring$var67.BytesFormDirective;var $jscomp$destructuring$var68=goog.require("grrUi.forms.clientLabelFormDirective");var ClientLabelFormDirective=$jscomp$destructuring$var68.ClientLabelFormDirective;var $jscomp$destructuring$var69=goog.require("grrUi.forms.datetimeFormDirective");var DatetimeFormDirective=$jscomp$destructuring$var69.DatetimeFormDirective;var $jscomp$destructuring$var70=goog.require("grrUi.forms.dictFormDirective");
var DictFormDirective=$jscomp$destructuring$var70.DictFormDirective;var $jscomp$destructuring$var71=goog.require("grrUi.forms.durationFormDirective");var DurationFormDirective=$jscomp$destructuring$var71.DurationFormDirective;var $jscomp$destructuring$var72=goog.require("grrUi.forms.foremanLabelRuleFormDirective");var ForemanLabelRuleFormDirective=$jscomp$destructuring$var72.ForemanLabelRuleFormDirective;var $jscomp$destructuring$var73=goog.require("grrUi.forms.globExpressionFormDirective");var GlobExpressionFormDirective=
$jscomp$destructuring$var73.GlobExpressionFormDirective;var $jscomp$destructuring$var74=goog.require("grrUi.forms.globExpressionsListFormDirective");var GlobExpressionsListFormDirective=$jscomp$destructuring$var74.GlobExpressionsListFormDirective;var $jscomp$destructuring$var75=goog.require("grrUi.forms.outputPluginDescriptorFormDirective");var OutputPluginDescriptorFormDirective=$jscomp$destructuring$var75.OutputPluginDescriptorFormDirective;var $jscomp$destructuring$var76=goog.require("grrUi.forms.semanticEnumFormDirective");
var SemanticEnumFormDirective=$jscomp$destructuring$var76.SemanticEnumFormDirective;var $jscomp$destructuring$var77=goog.require("grrUi.forms.semanticPrimitiveFormDirective");var SemanticPrimitiveFormDirective=$jscomp$destructuring$var77.SemanticPrimitiveFormDirective;var $jscomp$destructuring$var78=goog.require("grrUi.forms.semanticProtoFormDirective");var SemanticProtoFormDirective=$jscomp$destructuring$var78.SemanticProtoFormDirective;var $jscomp$destructuring$var79=goog.require("grrUi.forms.semanticProtoRepeatedFieldFormDirective");
var SemanticProtoRepeatedFieldFormDirective=$jscomp$destructuring$var79.SemanticProtoRepeatedFieldFormDirective;var $jscomp$destructuring$var80=goog.require("grrUi.forms.semanticProtoSingleFieldFormDirective");var SemanticProtoSingleFieldFormDirective=$jscomp$destructuring$var80.SemanticProtoSingleFieldFormDirective;var $jscomp$destructuring$var81=goog.require("grrUi.forms.semanticProtoUnionFormDirective");var SemanticProtoUnionFormDirective=$jscomp$destructuring$var81.SemanticProtoUnionFormDirective;
var $jscomp$destructuring$var82=goog.require("grrUi.core.semanticRegistryService");var SemanticRegistryService=$jscomp$destructuring$var82.SemanticRegistryService;var $jscomp$destructuring$var83=goog.require("grrUi.forms.semanticValueFormDirective");var SemanticValueFormDirective=$jscomp$destructuring$var83.SemanticValueFormDirective;var $jscomp$destructuring$var84=goog.require("grrUi.forms.timerangeFormDirective");var TimerangeFormDirective=$jscomp$destructuring$var84.TimerangeFormDirective;var $jscomp$destructuring$var85=
goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var85.coreModule;exports.formsModule=angular.module("grrUi.forms",[coreModule.name,"ui.bootstrap"]);exports.formsModule.service(SemanticRegistryService.forms_service_name,SemanticRegistryService);exports.formsModule.service(SemanticRegistryService.repeated_forms_service_name,SemanticRegistryService);exports.formsModule.directive(Aff4AttributeFormDirective.directive_name,Aff4AttributeFormDirective);exports.formsModule.directive(AutoGeneratedAES128KeyFormDirective.directive_name,
AutoGeneratedAES128KeyFormDirective);exports.formsModule.directive(BytesFormDirective.directive_name,BytesFormDirective);exports.formsModule.directive(ClientLabelFormDirective.directive_name,ClientLabelFormDirective);exports.formsModule.directive(DatetimeFormDirective.directive_name,DatetimeFormDirective);exports.formsModule.directive(DictFormDirective.directive_name,DictFormDirective);exports.formsModule.directive(DurationFormDirective.directive_name,DurationFormDirective);exports.formsModule.directive(GlobExpressionFormDirective.directive_name,
GlobExpressionFormDirective);exports.formsModule.directive(GlobExpressionsListFormDirective.directive_name,GlobExpressionsListFormDirective);exports.formsModule.directive(OutputPluginDescriptorFormDirective.directive_name,OutputPluginDescriptorFormDirective);exports.formsModule.directive(SemanticEnumFormDirective.directive_name,SemanticEnumFormDirective);exports.formsModule.directive(ForemanLabelRuleFormDirective.directive_name,ForemanLabelRuleFormDirective);exports.formsModule.directive(SemanticPrimitiveFormDirective.directive_name,
SemanticPrimitiveFormDirective);exports.formsModule.directive(SemanticProtoFormDirective.directive_name,SemanticProtoFormDirective);exports.formsModule.directive(SemanticProtoSingleFieldFormDirective.directive_name,SemanticProtoSingleFieldFormDirective);exports.formsModule.directive(SemanticProtoRepeatedFieldFormDirective.directive_name,SemanticProtoRepeatedFieldFormDirective);exports.formsModule.directive(SemanticProtoUnionFormDirective.directive_name,SemanticProtoUnionFormDirective);exports.formsModule.directive(SemanticValueFormDirective.directive_name,
SemanticValueFormDirective);exports.formsModule.directive(TimerangeFormDirective.directive_name,TimerangeFormDirective);exports.formsModule.run(function(grrSemanticFormDirectivesRegistryService){var registry=grrSemanticFormDirectivesRegistryService;registry.registerDirective(Aff4AttributeFormDirective.semantic_type,Aff4AttributeFormDirective);registry.registerDirective(AutoGeneratedAES128KeyFormDirective.semantic_type,AutoGeneratedAES128KeyFormDirective);registry.registerDirective(BytesFormDirective.semantic_type,
BytesFormDirective);registry.registerDirective(DatetimeFormDirective.semantic_type,DatetimeFormDirective);var dictSemanticTypes=DictFormDirective.semantic_types;angular.forEach(dictSemanticTypes,function(dictSemanticType){registry.registerDirective(dictSemanticType,DictFormDirective)});registry.registerDirective(DurationFormDirective.semantic_type,DurationFormDirective);registry.registerDirective(GlobExpressionFormDirective.semantic_type,GlobExpressionFormDirective);registry.registerDirective(OutputPluginDescriptorFormDirective.semantic_type,
OutputPluginDescriptorFormDirective);var primitiveSemanticTypes=SemanticPrimitiveFormDirective.semantic_types;angular.forEach(primitiveSemanticTypes,function(primitiveSemanticType){registry.registerDirective(primitiveSemanticType,SemanticPrimitiveFormDirective)});registry.registerDirective(SemanticEnumFormDirective.semantic_type,SemanticEnumFormDirective);registry.registerDirective(ForemanLabelRuleFormDirective.semantic_type,ForemanLabelRuleFormDirective);registry.registerDirective(SemanticProtoFormDirective.semantic_type,
SemanticProtoFormDirective)});exports.formsModule.run(function(grrSemanticRepeatedFormDirectivesRegistryService){var registry=grrSemanticRepeatedFormDirectivesRegistryService;registry.registerDirective(GlobExpressionsListFormDirective.semantic_type,GlobExpressionsListFormDirective)});return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.apiHuntResultDirective");goog.module.declareLegacyNamespace();exports.ApiHuntResultDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/api-hunt-result.html"}};exports.ApiHuntResultDirective.directive_name="grrApiHuntResult";exports.ApiHuntResultDirective.semantic_type="ApiHuntResult";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.byteSizeDirective");goog.module.declareLegacyNamespace();var KB_UNIT=1024;var MB_UNIT=KB_UNIT*1024;var GB_UNIT=MB_UNIT*1024;var stringifyByteSize=function(value){if(value==0)return[0,""];if(value>GB_UNIT)return[value/GB_UNIT,"GiB"];else if(value>MB_UNIT)return[value/MB_UNIT,"MiB"];else if(value>KB_UNIT)return[value/KB_UNIT,"KiB"];else return[value,"B"]};var ByteSizeController=function($scope){this.scope_=$scope;this.stringifiedByteSize;
this.scope_.$watch("::value",this.onValueChange.bind(this))};ByteSizeController.prototype.onValueChange=function(newValue){var byteSize=newValue.value;if(angular.isNumber(byteSize)){var stringified=stringifyByteSize(byteSize);var size=stringified[0];var sizeToken=stringified[1];var result=[Math.floor(size).toString()];var decimalPart=Math.round(size%1*10).toString();if(decimalPart!=="0")result.push(".",decimalPart);result.push(sizeToken);this.stringifiedByteSize=result.join("")}else this.stringifiedByteSize=
"-"};exports.ByteSizeDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/byte-size.html",controller:ByteSizeController,controllerAs:"controller"}};exports.ByteSizeDirective.directive_name="grrByteSize";exports.ByteSizeDirective.semantic_type="ByteSize";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.bytesDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var86=goog.require("grrUi.forms.bytesFormDirective");var bytesToHexEncodedString=$jscomp$destructuring$var86.bytesToHexEncodedString;var BytesController=function($scope,$window){this.scope_=$scope;this.window_=$window;this.stringifiedBytes;this.scope_.$watch("::value",this.onValueChange.bind(this))};var FIRST_RENDER_LIMIT=1024;BytesController.prototype.onClick=
function(e){e.stopPropagation();var bytes=this.scope_["value"]["value"];try{this.stringifiedBytes=bytesToHexEncodedString(this.window_.atob(bytes))}catch(err){this.stringifiedBytes="base64decodeerror("+err.message+"):"+bytes}};BytesController.prototype.onValueChange=function(newValue){var bytes=newValue.value;if(angular.isString(bytes)){if(bytes.length<FIRST_RENDER_LIMIT)try{this.stringifiedBytes=bytesToHexEncodedString(this.window_.atob(bytes))}catch(err){this.stringifiedBytes="base64decodeerror("+
err.message+"):"+bytes}}else this.stringifiedBytes=""};exports.BytesDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/bytes.html",controller:BytesController,controllerAs:"controller"}};exports.BytesDirective.directive_name="grrBytes";exports.BytesDirective.semantic_types=["RDFBytes","str"];return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.clientUrnDirective");goog.module.declareLegacyNamespace();var ClientUrnController=function($scope,$uibModal,grrApiService){this.scope_=$scope;this.scope_.value;this.uibModal_=$uibModal;this.grrApiService_=grrApiService;this.clientDetails;this.clientId;this.scope_.$watch("::value",this.onValueChange.bind(this))};ClientUrnController.prototype.onValueChange=function(){var clientUrn;if(angular.isObject(this.scope_.value))clientUrn=
this.scope_.value.value;else clientUrn=this.scope_.value;if(angular.isString(clientUrn))this.clientId=clientUrn.replace(/^aff4:\//,"")};ClientUrnController.prototype.onInfoClick=function(){this.uibModal_.open({templateUrl:"/static/angular-components/semantic/client-urn-modal.html",scope:this.scope_});this.grrApiService_.get("clients/"+this.clientId).then(function(response){this.clientDetails=response.data}.bind(this))};exports.ClientUrnDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/client-urn.html",
controller:ClientUrnController,controllerAs:"controller"}};exports.ClientUrnDirective.directive_name="grrClientUrn";exports.ClientUrnDirective.semantic_types=["ClientURN","ApiClientId"];return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.dataObjectDirective");goog.module.declareLegacyNamespace();exports.DataObjectDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/data-object.html"}};exports.DataObjectDirective.directive_name="grrDataObject";exports.DataObjectDirective.semantic_type="ApiDataObject";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.dictDirective");goog.module.declareLegacyNamespace();exports.DictDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/dict.html"}};exports.DictDirective.directive_name="grrDict";exports.DictDirective.semantic_types=["dict","Dict"];return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.encryptionKeyDirective");goog.module.declareLegacyNamespace();exports.stringifyEncryptionKey=function(base64Bytes){var decoded=window.atob(base64Bytes);var result=[];for(var i=0;i<decoded.length;++i){var c=decoded.charCodeAt(i).toString(16);if(c.length==1)c="0"+c;result.push(c)}return result.join("")};var EncryptionKeyController=function($scope){this.scope_=$scope;this.stringifiedKey;this.scope_.$watch("::value.value",this.onValueChange.bind(this))};
EncryptionKeyController.prototype.onValueChange=function(newValue){if(angular.isDefined(newValue))this.stringifiedKey=exports.stringifyEncryptionKey(newValue)};exports.EncryptionKeyDirective=function(){return{scope:{value:"="},restrict:"E",template:"{$ ::controller.stringifiedKey $}",controller:EncryptionKeyController,controllerAs:"controller"}};exports.EncryptionKeyDirective.directive_name="grrEncryptionKey";exports.EncryptionKeyDirective.semantic_type="EncryptionKey";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.flowIdDirective");goog.module.declareLegacyNamespace();var FlowIdController=function($scope){this.scope_=$scope;this.clientId};exports.FlowIdDirective=function(){return{scope:{value:"="},require:"?^grrClientContext",restrict:"E",templateUrl:"/static/angular-components/semantic/flow-id.html",controller:FlowIdController,controllerAs:"controller",link:function(scope,element,attrs,grrClientContextCtrl){if(grrClientContextCtrl)scope["controller"].clientId=
grrClientContextCtrl.clientId}}};exports.FlowIdDirective.directive_name="grrFlowId";exports.FlowIdDirective.semantic_type="ApiFlowId";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.hashDigestDirective");goog.module.declareLegacyNamespace();var HashDigestController=function($scope,$window){this.scope_=$scope;this.window_=$window;this.stringifiedBytes;this.scope_.$watch("::value",this.onValueChange.bind(this))};HashDigestController.prototype.bytesToHexString=function(bytes){var hex="";for(var i=0;i<bytes.length;i+=1){var char=bytes.charCodeAt(i).toString(16);hex+=("0"+char).substr(-2)}return hex};HashDigestController.prototype.onValueChange=
function(newValue){var bytes=newValue.value;if(angular.isString(bytes))try{this.stringifiedBytes=this.bytesToHexString(this.window_.atob(bytes))}catch(err){this.stringifiedBytes="base64decodeerror("+err.message+"):"+bytes}else this.stringifiedBytes=""};exports.HashDigestDirective=function(){return{scope:{value:"="},restrict:"E",template:'<nobr ng-if="::controller.stringifiedBytes !== undefined">'+"{$ ::controller.stringifiedBytes $}</nobr>",controller:HashDigestController,controllerAs:"controller"}};
exports.HashDigestDirective.directive_name="grrHashDigest";exports.HashDigestDirective.semantic_type="HashDigest";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.hashListDirective");goog.module.declareLegacyNamespace();var HASH_SIZE=32;var HashListController=function($scope,$window){this.scope_=$scope;this.window_=$window;this.chunks=[];this.scope_.$watch("::value",this.onValueChange.bind(this))};HashListController.prototype.onValueChange=function(newValue){this.chunks=[];if(angular.isString(newValue.value)){var bytes=this.window_.atob(newValue.value);while(bytes){var chunkStr=bytes.substr(0,
HASH_SIZE);bytes=bytes.substr(HASH_SIZE);this.chunks.push({value:this.window_.btoa(chunkStr),type:"HashDigest"})}}};exports.HashListDirective=function(){return{scope:{value:"="},restrict:"E",template:'<grr-semantic-value value="::controller.chunks" />',controller:HashListController,controllerAs:"controller"}};exports.HashListDirective.directive_name="grrHashList";exports.HashListDirective.semantic_type="HashList";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.huntIdDirective");goog.module.declareLegacyNamespace();exports.HuntIdDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/hunt-id.html"}};exports.HuntIdDirective.directive_name="grrHuntId";exports.HuntIdDirective.semantic_type="ApiHuntId";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.jsonDirective");goog.module.declareLegacyNamespace();var JsonController=function($scope,$window){this.scope_=$scope;this.window_=$window;this.prettyJson;this.scope_.$watch("::value",this.onValueChange.bind(this))};var FIRST_RENDER_LIMIT=1024;JsonController.prototype.onClick=function(e){e.stopPropagation();var jsonStr=this.scope_["value"]["value"];try{var parsedJson=JSON.parse(jsonStr);this.prettyJson=JSON.stringify(parsedJson,
null,2)}catch(err){this.prettyJson="jsonerror("+err.message+"):"+jsonStr}};JsonController.prototype.onValueChange=function(newValue){var jsonStr=newValue.value;if(angular.isString(jsonStr)){if(jsonStr.length<FIRST_RENDER_LIMIT)try{var parsedJson=JSON.parse(jsonStr);this.prettyJson=JSON.stringify(parsedJson,null,2)}catch(err){this.prettyJson="jsonerror("+err.message+"):"+jsonStr}}else this.prettyJson=""};exports.JsonDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/json.html",
controller:JsonController,controllerAs:"controller"}};exports.JsonDirective.directive_name="grrJson";exports.JsonDirective.semantic_type="ZippedJSONBytes";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.macAddressDirective");goog.module.declareLegacyNamespace();var convertMacAddressToString=function(address){var result=[];for(var i=0;i<address.length;++i){var part=address.charCodeAt(i).toString(16);if(part.length===1)part="0"+part;result.push(part)}return result.join(":")};var MacAddressController=function($scope){this.scope_=$scope;this.convertedAddress;this.scope_.$watch("::value",this.onValueChange.bind(this))};MacAddressController.prototype.onValueChange=
function(newValue){var address=newValue.value;if(angular.isString(address))this.convertedAddress=convertMacAddressToString(window.atob(address));else this.convertedAddress="-"};exports.MacAddressDirective=function(){return{scope:{value:"="},restrict:"E",template:'<nobr ng-if="::controller.convertedAddress !== undefined">'+"{$ ::controller.convertedAddress $}</nobr>",controller:MacAddressController,controllerAs:"controller"}};exports.MacAddressDirective.directive_name="grrMacAddress";exports.MacAddressDirective.semantic_type=
"MacAddress";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.networkAddressDirective");goog.module.declareLegacyNamespace();var convertIpv4AddressToString=function(address){var result=[];for(var i=0;i<address.length;++i){var part=address.charCodeAt(i).toString(10);if(part.length===1)part="0"+part;result.push(part)}return result.join(".")};var convertIpv6AddressToString=function(address){var result=[];var colonCounter=0;for(var i=0;i<address.length;++i){var part=address.charCodeAt(i).toString(16);
if(part.length===1)part="0"+part;result.push(part);if(++colonCounter==2){result.push(":");colonCounter=0}}return result.join("")};var convertBase64AddressToString=function(address,addressType){if(angular.isUndefined(address))return"-";else switch(addressType){case "INET":return convertIpv4AddressToString(window.atob(address));case "INET6":return convertIpv6AddressToString(window.atob(address));default:return"<unknown address type>"}};var NetworkAddressController=function($scope){this.scope_=$scope;
this.convertedAddress;this.scope_.$watch("::value",this.onValueChange.bind(this))};NetworkAddressController.prototype.onValueChange=function(newValue){if(!angular.isObject(newValue)){this.convertedAddress="-";return}if(angular.isObject(newValue.value))if(angular.isDefined(newValue.value.packed_bytes))this.convertedAddress=convertBase64AddressToString(newValue.value.packed_bytes.value,newValue.value.address_type.value);else if(angular.isDefined(newValue.value.human_readable))this.convertedAddress=
newValue.value.human_readable.value;else this.convertedAddress="<unknown>";else if(angular.isObject(newValue))if(angular.isDefined(newValue.packed_bytes))this.convertedAddress=convertBase64AddressToString(newValue.packed_bytes,newValue.address_type);else if(angular.isDefined(newValue.human_readable))this.convertedAddress=newValue.human_readable;else this.convertedAddress="<unknown>"};exports.NetworkAddressDirective=function(){return{scope:{value:"="},restrict:"E",template:'<nobr ng-if="::controller.convertedAddress !== undefined">'+
"{$ ::controller.convertedAddress $}</nobr>",controller:NetworkAddressController,controllerAs:"controller"}};exports.NetworkAddressDirective.directive_name="grrNetworkAddress";exports.NetworkAddressDirective.semantic_type="NetworkAddress";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.objectLabelDirective");goog.module.declareLegacyNamespace();var ObjectLabelController=function($scope){this.scope_=$scope;this.labelName;this.labelOwner;this.scope_.$watch("::value",this.onValueChange_.bind(this))};ObjectLabelController.prototype.onValueChange_=function(newValue){if(!newValue)this.labelName=this.labelType=null;if(angular.isDefined(newValue["value"])){this.labelName=newValue["value"]["name"]["value"];this.labelOwner=
newValue["value"]["owner"]["value"]}else{this.labelName=newValue["name"];this.labelOwner=newValue["owner"]}};exports.ObjectLabelDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/object-label.html",controller:ObjectLabelController,controllerAs:"controller"}};exports.ObjectLabelDirective.directive_name="grrObjectLabel";exports.ObjectLabelDirective.semantic_type="ClientLabel";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.objectLabelsListDirective");goog.module.declareLegacyNamespace();exports.ObjectLabelsListDirective=function(){return{scope:{value:"="},restrict:"E",template:"<grr-object-label "+'ng-repeat="label in ::value.value.labels" '+'value="::label"></grr-object-label>',controllerAs:"controller"}};exports.ObjectLabelsListDirective.directive_name="grrObjectLabelsList";exports.ObjectLabelsListDirective.semantic_type="AFF4ObjectLabelsList";
return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.primitiveDirective");goog.module.declareLegacyNamespace();exports.PrimitiveDirective=function(){return{scope:{value:"="},restrict:"E",template:"{$ ::value.value $}"}};exports.PrimitiveDirective.directive_name="grrPrimitive";exports.PrimitiveDirective.semantic_types=["RDFBool","bool","RDFInteger","int","long","float","RDFString","basestring"];return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.semanticValueDirective");goog.module.declareLegacyNamespace();var singleValueTemplateCache={};var repeatedValuesTemplate;exports.clearCaches=function(){singleValueTemplateCache={};repeatedValuesTemplate=undefined};exports.getCachedSingleValueTemplate=function(name){return singleValueTemplateCache[name]};var RegistryOverrideController=function($scope){this.scope_=$scope;this.map;this.overrideKey;this.scope_.$watch(function(){return this.map}.bind(this),
this.onMapChange_.bind(this))};RegistryOverrideController.prototype.onMapChange_=function(newValue){this.overrideKey="";angular.forEach(Object.keys(this.map).sort(),function(key){var value=this.map[key];this.overrideKey+=":"+key+"_"+value["directive_name"]}.bind(this))};exports.RegistryOverrideDirective=function(){return{scope:{map:"="},controller:RegistryOverrideController,bindToController:true,restrict:"E",transclude:true,template:"<ng-transclude></ng-transclude>"}};exports.RegistryOverrideDirective.directive_name=
"grrSemanticValueRegistryOverride";var SemanticValueController=function($scope,$compile,$element,grrSemanticValueDirectivesRegistryService){this.scope_=$scope;this.scope_.value;this.compile_=$compile;this.element_=$element;this.grrSemanticValueDirectivesRegistryService_=grrSemanticValueDirectivesRegistryService;this.registryOverrideController;this.scope_.$watch("::value",this.onValueChange.bind(this))};SemanticValueController.prototype.camelCaseToDashDelimited=function(directiveName){return directiveName.replace(/\W+/g,
"-").replace(/([a-z\d])([A-Z])/g,"$1-$2").toLowerCase()};SemanticValueController.prototype.compileSingleTypedValueTemplate_=function(value){var successHandler=function(directive){var element=angular.element("<span />");element.html("<"+this.camelCaseToDashDelimited(directive.directive_name)+' value="::value" />');return this.compile_(element)}.bind(this);var failureHandler=function(directive){var element=angular.element("<span />");element.html("{$ ::value.value $}");return this.compile_(element)}.bind(this);
var overrides;if(this.registryOverrideController)overrides=this.registryOverrideController.map;return this.grrSemanticValueDirectivesRegistryService_.findDirectiveForType(value["type"],overrides).then(successHandler,failureHandler)};SemanticValueController.prototype.compileRepeatedValueTemplate_=function(){var element=angular.element('<div ng-repeat="item in ::repeatedValue || []">'+'<grr-semantic-value value="::item" /></div>');return this.compile_(element)};SemanticValueController.prototype.onValueChange=
function(){var value=this.scope_.value;if(value==null)return;var template;if(angular.isDefined(value["type"])){var handleTemplate=function(template){template(this.scope_,function(cloned,opt_scope){this.element_.html("");this.element_.append(cloned)}.bind(this))}.bind(this);var cacheKey=value["type"];if(this.registryOverrideController)cacheKey+=this.registryOverrideController.overrideKey;template=singleValueTemplateCache[cacheKey];if(angular.isUndefined(template))this.compileSingleTypedValueTemplate_(value).then(function(tmpl){singleValueTemplateCache[cacheKey]=
tmpl;handleTemplate(tmpl)}.bind(this));else handleTemplate(template)}else if(angular.isArray(value)){if(value.length>10){var continuation=value.slice(10);this.scope_.repeatedValue=value.slice(0,10);this.scope_.repeatedValue.push({type:"__FetchMoreLink",value:continuation})}else this.scope_.repeatedValue=value;if(angular.isUndefined(repeatedValuesTemplate))repeatedValuesTemplate=this.compileRepeatedValueTemplate_();template=repeatedValuesTemplate;template(this.scope_,function(cloned,opt_scope){this.element_.html("");
this.element_.append(cloned)}.bind(this))}else this.element_.text(value.toString()+" ")};exports.SemanticValueDirective=function(){return{scope:{value:"="},require:"?^grrSemanticValueRegistryOverride",restrict:"E",controller:SemanticValueController,controllerAs:"controller",link:function(scope,element,attrs,grrSemanticValueRegistryOverrideCtrl){if(grrSemanticValueRegistryOverrideCtrl)scope["controller"]["registryOverrideController"]=grrSemanticValueRegistryOverrideCtrl}}};exports.SemanticValueDirective.directive_name=
"grrSemanticValue";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekallResponseDirective");goog.module.declareLegacyNamespace();exports.RekallResponseDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/rekall-response.html"}};exports.RekallResponseDirective.directive_name="grrRekallResponse";exports.RekallResponseDirective.semantic_type="RekallResponse";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.semanticProtoDirective");goog.module.declareLegacyNamespace();exports.getUnionFieldValue=function(value,descriptor){var unionFieldName=descriptor["union_field"];if(angular.isUndefined(unionFieldName))throw new Error("Not a union-type structure.");if(angular.isDefined(value["value"][unionFieldName]))return value["value"][unionFieldName]["value"].toLowerCase();else{var fieldsLength=descriptor["fields"].length;for(var i=0;i<fieldsLength;++i){var field=
descriptor["fields"][i];if(field["name"]==unionFieldName)return field["default"]["value"].toLowerCase()}}throw new Error("Can't determine value of the union field.");};var getUnionFieldValue=exports.getUnionFieldValue;exports.buildUnionItems=function(value,descriptor){var items=[];var unionFieldName=descriptor["union_field"];var unionFieldValue=getUnionFieldValue(value,descriptor);var fieldsLength=descriptor["fields"].length;for(var i=0;i<fieldsLength;++i){var field=descriptor["fields"][i];var key=
field["name"];if(key!==unionFieldName&&key!==unionFieldValue)continue;var keyValue=value.value[key];if(angular.isUndefined(keyValue))keyValue=field["default"];items.push({"value":keyValue,"key":field["friendly_name"]||field["name"],"desc":field["doc"]})}return items};var buildUnionItems=exports.buildUnionItems;exports.buildNonUnionItems=function(value,descriptor,opt_visibleFields,opt_hiddenFields){if(angular.isUndefined(descriptor["fields"]))return[];var items=[];var fieldsLength=descriptor["fields"].length;
for(var i=0;i<fieldsLength;++i){var field=descriptor["fields"][i];var key=field["name"];var keyValue=value.value[key];if(opt_visibleFields&&opt_visibleFields.indexOf(key)==-1)continue;if(opt_hiddenFields&&opt_hiddenFields.indexOf(key)!=-1)continue;if(angular.isUndefined(keyValue))if(!opt_visibleFields)continue;else keyValue=angular.copy(field["default"]);items.push({"value":keyValue,"key":field["friendly_name"]||field["name"],"structKey":field["name"],"desc":field["doc"],"fieldDescriptor":field})}return items};
var buildNonUnionItems=exports.buildNonUnionItems;exports.buildItems=function(value,descriptor,opt_visibleFields,opt_hiddenFields){if(angular.isDefined(descriptor["union_field"]))return buildUnionItems(value,descriptor);else return buildNonUnionItems(value,descriptor,opt_visibleFields,opt_hiddenFields)};var buildItems=exports.buildItems;var SemanticProtoController=function($scope,grrReflectionService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.items;this.scope_.$watch("::value",
this.onValueChange.bind(this))};SemanticProtoController.prototype.onValueChange=function(newValue,oldValue){if(newValue===undefined&&oldValue===undefined)return;if(angular.isObject(this.scope_["value"])){var valueType=this.scope_["value"]["type"];this.grrReflectionService_.getRDFValueDescriptor(valueType).then(function success(descriptor){this.items=buildItems(this.scope_["value"],descriptor,this.scope_["visibleFields"],this.scope_["hiddenFields"])}.bind(this))}else this.items=[]};exports.SemanticProtoDirective=
function(){return{scope:{value:"=",visibleFields:"=",hiddenFields:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/semantic-proto.html",controller:SemanticProtoController,controllerAs:"controller"}};exports.SemanticProtoDirective.directive_name="grrSemanticProto";exports.SemanticProtoDirective.semantic_type="RDFProtoStruct";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.semanticDiffAnnotatedProtoDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var87=goog.require("grrUi.semantic.semanticProtoDirective");var buildItems=$jscomp$destructuring$var87.buildItems;var SemanticDiffAnnotatedProtoController=function($scope,grrReflectionService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.items;this.scope_.$watch("::value",this.onValueChange_.bind(this))};
SemanticDiffAnnotatedProtoController.prototype.onValueChange_=function(newValue,oldValue){if(newValue===undefined&&oldValue===undefined)return;if(angular.isObject(this.scope_["value"]))this.grrReflectionService_.getRDFValueDescriptor(this.scope_["value"]["type"]).then(function success(descriptor){this.items=buildItems(this.scope_["value"],descriptor,this.scope_["visibleFields"],this.scope_["hiddenFields"]);angular.forEach(this.items,function(item){item["isList"]=angular.isArray(item["value"])}.bind(this))}.bind(this));
else this.items=[]};exports.SemanticDiffAnnotatedProtoDirective=function(){return{scope:{value:"=",visibleFields:"=",hiddenFields:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/"+"semantic-diff-annotated-proto.html",controller:SemanticDiffAnnotatedProtoController,controllerAs:"controller"}};exports.SemanticDiffAnnotatedProtoDirective.directive_name="grrSemanticDiffAnnotatedProto";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.semanticProtosDiffDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var88=goog.require("grrUi.semantic.semanticDiffAnnotatedProtoDirective");var SemanticDiffAnnotatedProtoDirective=$jscomp$destructuring$var88.SemanticDiffAnnotatedProtoDirective;var $jscomp$destructuring$var89=goog.require("grrUi.semantic.semanticProtoDirective");var SemanticProtoDirective=$jscomp$destructuring$var89.SemanticProtoDirective;
var diffAnnotateArrays=function(originalValue,newValue){angular.forEach(originalValue,function(originalItem){var found=false;angular.forEach(newValue,function(newItem){if(angular.equals(originalItem,newItem))found=true});if(!found)originalItem["_diff"]="removed"});angular.forEach(newValue,function(newItem){var found=false;angular.forEach(originalValue,function(originalItem){if(angular.equals(originalItem,newItem))found=true});if(!found)newItem["_diff"]="added"})};exports.diffAnnotate=function(originalValue,
newValue){if(angular.isUndefined(originalValue)&&angular.isUndefined(newValue))return;if(angular.isUndefined(originalValue)){newValue["_diff"]="added";return}if(angular.isUndefined(newValue)){originalValue["_diff"]="removed";return}if(angular.isArray(originalValue)&&!angular.isArray(newValue)||!angular.isArray(originalValue)&&angular.isArray(newValue)){originalValue["_diff"]=newValue["_diff"]="changed";return}if(angular.isArray(originalValue)&&angular.isArray(newValue)){diffAnnotateArrays(originalValue,
newValue);return}if(originalValue["type"]!=newValue["type"]){originalValue["_diff"]=newValue["_diff"]="changed";return}if(angular.isString(originalValue["value"])||angular.isNumber(originalValue["value"])){if(!angular.equals(originalValue["value"],newValue["value"]))originalValue["_diff"]=newValue["_diff"]="changed";return}var allKeys=angular.extend({},originalValue["value"],newValue["value"]);for(var key in allKeys)diffAnnotate(originalValue["value"][key],newValue["value"][key])};var diffAnnotate=
exports.diffAnnotate;var SemanticProtosDiffController=function($scope){this.scope_=$scope;this.annotatedOriginalValue;this.annotatedNewValue;var protoType=SemanticProtoDirective.semantic_type;var protoDirectiveOverride=SemanticDiffAnnotatedProtoDirective;this.overrideMap={};this.overrideMap[protoType]=protoDirectiveOverride;this.scope_.$watchGroup(["originalValue","newValue"],this.onValuesChange_.bind(this))};SemanticProtosDiffController.prototype.onValuesChange_=function(){if(angular.isUndefined(this.scope_["originalValue"])||
angular.isUndefined(this.scope_["newValue"]))return;this.annotatedOriginalValue=angular.copy(this.scope_["originalValue"]);this.annotatedNewValue=angular.copy(this.scope_["newValue"]);diffAnnotate(this.annotatedOriginalValue,this.annotatedNewValue)};exports.SemanticProtosDiffDirective=function(){return{scope:{originalValue:"=",newValue:"=",visibleFields:"=",hiddenFields:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/"+"semantic-protos-diff.html",controller:SemanticProtosDiffController,
controllerAs:"controller"}};exports.SemanticProtosDiffDirective.directive_name="grrSemanticProtosDiff";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.semanticVersionedProtoDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var90=goog.require("grrUi.semantic.semanticProtoDirective");var buildNonUnionItems=$jscomp$destructuring$var90.buildNonUnionItems;var SemanticVersionedProtoController=function($scope,grrReflectionService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.items;this.scope_.$watch("::value",this.onValueChange_.bind(this))};
SemanticVersionedProtoController.prototype.processItems_=function(items,descriptors){angular.forEach(items,function(item){var itemType=item["fieldDescriptor"]["type"];item["recursiveItem"]=this.scope_["historyDepth"]>1&&descriptors[itemType]["kind"]==="struct"&&!item["fieldDescriptor"]["repeated"]&&!item["fieldDescriptor"]["dynamic"];if(!this.scope_["historyPath"])item["historyPath"]=item["structKey"];else item["historyPath"]=this.scope_["historyPath"]+"."+item["structKey"]}.bind(this));return items};
SemanticVersionedProtoController.prototype.onValueChange_=function(newValue,oldValue){if(newValue===undefined&&oldValue===undefined)return;if(angular.isObject(this.scope_["value"])){var valueType=this.scope_["value"]["type"];this.grrReflectionService_.getRDFValueDescriptor(valueType,true).then(function success(descriptors){var items=buildNonUnionItems(this.scope_["value"],descriptors[valueType]);this.items=this.processItems_(items,descriptors)}.bind(this))}else this.items=[]};exports.SemanticVersionedProtoDirective=
function(){return{scope:{value:"=",onFieldClick:"&",historyDepth:"=",historyPath:"=?"},restrict:"E",templateUrl:"/static/angular-components/semantic/semantic-versioned-proto.html",controller:SemanticVersionedProtoController,controllerAs:"controller"}};exports.SemanticVersionedProtoDirective.directive_name="grrSemanticVersionedProto";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.statEntryDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var91=goog.require("grrUi.core.serverErrorButtonDirective");var ServerErrorButtonDirective=$jscomp$destructuring$var91.ServerErrorButtonDirective;var $jscomp$destructuring$var92=goog.require("grrUi.core.fileDownloadUtils");var pathSpecToAff4Path=$jscomp$destructuring$var92.pathSpecToAff4Path;var ERROR_EVENT_NAME=ServerErrorButtonDirective.error_event_name;
var StatEntryController=function($rootScope,$scope,grrApiService){this.rootScope_=$rootScope;this.scope_=$scope;this.grrApiService_=grrApiService;this.clientId;this.aff4Path;this.statEntry;this.downloadUrl;this.downloadParams;this.scope_.$watch("::value",this.onValueChange_.bind(this))};StatEntryController.prototype.onValueChange_=function(newValue){if(angular.isUndefined(newValue))return;if(newValue["type"]=="__DownloadableStatEntry"){this.statEntry=newValue["originalValue"];this.downloadUrl=newValue["downloadUrl"];
this.downloadParams=newValue["downloadParams"]}else this.statEntry=newValue;if(this.clientId&&angular.isDefined(this.statEntry["value"]["pathspec"]))this.aff4Path={type:"RDFURN",value:pathSpecToAff4Path(this.statEntry["value"]["pathspec"],this.clientId)};else this.aff4Path={type:"RDFString",value:"<unknown>"}};StatEntryController.prototype.onDownloadClick=function(){this.grrApiService_.downloadFile(this.downloadUrl,this.downloadParams).then(function success(){}.bind(this),function failure(response){if(response.status!==
500)this.rootScope_.$broadcast(ERROR_EVENT_NAME,{message:"Couldn't download the file. Most likely "+"it was just referenced and not downloaded from the "+"client."})}.bind(this))};exports.StatEntryDirective=function(){return{scope:{value:"="},require:"?^grrClientContext",restrict:"E",templateUrl:"/static/angular-components/semantic/stat-entry.html",controller:StatEntryController,controllerAs:"controller",link:function(scope,element,attrs,grrClientContextCtrl){if(grrClientContextCtrl)scope["controller"].clientId=
grrClientContextCtrl.clientId}}};exports.StatEntryDirective.directive_name="grrStatEntry";exports.StatEntryDirective.semantic_types=["StatEntry","__DownloadableStatEntry"];return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.statExtFlagsLinuxDirective");goog.module.declareLegacyNamespace();var Flag;var FlagsStatus={MALFORMED:"MALFORMED",SOME:"SOME",NONE:"NONE"};var ORDER="suSDiadAcBZXEjItTehC";var FLAGS={"FS_SECRM_FL":{mask:1,symbol:"s",description:"secure deletion"},"FS_UNRM_FL":{mask:2,symbol:"u",description:"undelete"},"FS_COMPR_FL":{mask:4,symbol:"c",description:"compress file"},"FS_SYNC_FL":{mask:8,symbol:"S",description:"synchronous updates"},
"FS_IMMUTABLE_FL":{mask:16,symbol:"i",description:"immutable file"},"FS_APPEND_FL":{mask:32,symbol:"a",description:"writes to file may only append"},"FS_NODUMP_FL":{mask:64,symbol:"d",description:"do not dump file"},"FS_NOATIME_FL":{mask:128,symbol:"A",description:"do not update atime"},"FS_DIRTY_FL":{mask:256,symbol:"Z",description:"compressed file is dirty"},"FS_COMPRBLK_FL":{mask:512,symbol:"B",description:"one or more compressed clusters"},"FS_NOCOMP_FL":{mask:1024,symbol:"X",description:"do not compress"},
"FS_ECOMPR_FL":{mask:2048,symbol:"E",description:"compression error"},"FS_BTREE_FL":{mask:4096,symbol:undefined,description:"btree format dir"},"FS_INDEX_FL":{mask:4096,symbol:"I",description:"hash-indexed directory"},"FS_IMAGIC_FL":{mask:8192,symbol:undefined,description:"AFS directory"},"FS_JOURNAL_DATA_FL":{mask:16384,symbol:"j",description:"reserved for ext3"},"FS_NOTAIL_FL":{mask:32768,symbol:"t",description:"file tail should not be merged"},"FS_DIRSYNC_FL":{mask:65536,symbol:"D",description:"dirsync behaviour (directories only)"},
"FS_TOPDIR_FL":{mask:131072,symbol:"T",description:"top of directory hierarchies"},"EXT4_HUGE_FILE_FL":{mask:262144,symbol:"h",description:"set to each huge file"},"FS_EXTENT_FL":{mask:524288,symbol:"e",description:"extents"},"FS_DIRECTIO_FL":{mask:1048576,symbol:undefined,description:"use direct I/O"},"FS_NOCOW_FL":{mask:8388608,symbol:"C",description:"do not copy-on-write"}};var getFlagBySymbol=function(symbol){var flag=Object.values(FLAGS).find(function(flag){return flag.symbol===symbol});if(flag===
undefined)throw new Error("unknown symbol: "+symbol);return flag};var getMaskFlags=function(mask){return ORDER.split("").map(getFlagBySymbol).map(function(flag){return(flag.mask&mask)!==0?flag:null})};var StatExtFlagsLinuxController=function($scope){this.scope_=$scope;this.scope_.value;this.scope_.$watch("::value",this.onValueChange.bind(this));this.status=FlagsStatus.NONE;this.flags=[]};StatExtFlagsLinuxController.prototype.onValueChange=function(value){if(angular.isUndefined(value))return;var mask=
value.value;if(!Number.isInteger(mask)||mask<0){this.status=FlagsStatus.MALFORMED;return}this.status=FlagsStatus.SOME;this.flags=getMaskFlags(mask)};exports.StatExtFlagsLinuxDirective=function($filter){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/stat-ext-flags-linux.html",controller:StatExtFlagsLinuxController,controllerAs:"controller"}};var StatExtFlagsLinuxDirective=exports.StatExtFlagsLinuxDirective;StatExtFlagsLinuxDirective.directive_name="grrStatExtFlagsLinux";
StatExtFlagsLinuxDirective.semantic_type="StatExtFlagsLinux";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.statExtFlagsOsxDirective");goog.module.declareLegacyNamespace();var Flag;var FLAGS={"UF_NODUMP":{mask:1,keyword:"nodump",description:"do not dump file"},"UF_IMMUTABLE":{mask:2,keyword:"uchg",description:"file may not be changed"},"UF_APPEND":{mask:4,keyword:"uappnd",description:"writes to file may only append"},"UF_OPAQUE":{mask:8,keyword:"opaque",description:"directory is opaque wrt. union"},"UF_COMPRESSED":{mask:32,keyword:undefined,
description:"file is compressed (some file-systems)"},"UF_TRACKED":{mask:64,keyword:undefined,description:"used for dealing with document ids"},"UF_DATAVAULT":{mask:128,keyword:undefined,description:"entitlement required for reading and writing"},"UF_HIDDEN":{mask:32768,keyword:"hidden",description:"hint that this item should not be displayed in a GUI"},"SF_ARCHIVED":{mask:65536,keyword:"arch",description:"file is archived"},"SF_IMMUTABLE":{mask:131072,keyword:"schg",description:"file may not be changed"},
"SF_APPEND":{mask:262144,keyword:"sappnd",description:"writes to file may only append"},"SF_RESTRICTED":{mask:524288,keyword:undefined,description:"entitlement required for writing"},"SF_NOUNLINK":{mask:1048576,keyword:"sunlnk",description:"item may not be removed, renamed or mounted on"}};var FlagsStatus={MALFORMED:"MALFORMED",SOME:"SOME",NONE:"NONE"};var StatExtFlagsOsxController=function($scope){this.scope_=$scope;this.scope_.value;this.scope_.$watch("::value",this.onValueChange.bind(this));this.status=
FlagsStatus.NONE;this.flags=[]};StatExtFlagsOsxController.prototype.onValueChange=function(value){if(angular.isUndefined(value))return;var mask=value.value;if(!Number.isInteger(mask)||mask<0){this.status=FlagsStatus.MALFORMED;return}this.status=FlagsStatus.SOME;this.flags=Object.values(FLAGS).filter(function(flag){return(flag.mask&mask)!==0})};exports.StatExtFlagsOsxDirective=function($filter){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/stat-ext-flags-osx.html",
controller:StatExtFlagsOsxController,controllerAs:"controller"}};var StatExtFlagsOsxDirective=exports.StatExtFlagsOsxDirective;StatExtFlagsOsxDirective.directive_name="grrStatExtFlagsOsx";StatExtFlagsOsxDirective.semantic_type="StatExtFlagsOsx";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.statModeDirective");goog.module.declareLegacyNamespace();var S_IFMT=61440;var S_IFIFO=4096;var S_IFCHR=8192;var S_IFDIR=16384;var S_IFBLK=24576;var S_IFREG=32768;var S_IFLNK=40960;var S_IFSOCK=49152;var S_IFWHT=57344;var S_IMODE=4095;var S_ISUID=2048;var S_ISGID=1024;var S_ISVTX=512;var S_IRUSR=256;var S_IWUSR=128;var S_IXUSR=64;var S_IRGRP=32;var S_IWGRP=16;var S_IXGRP=8;var S_IROTH=4;var S_IWOTH=2;var S_IXOTH=1;var StatModeController=
function($scope){this.scope_=$scope;this.scope_.value;this.statMode;this.octalStatMode;this.scope_.$watch("::value",this.onValueChange.bind(this))};StatModeController.prototype.onValueChange=function(newValue){if(!newValue||!angular.isNumber(newValue.value)){this.octalStatMode="-";this.statMode="-"}else{var statMode=newValue.value;this.octalStatMode=this.calculateOctalMode_(statMode);this.statMode=this.calculateModeString_(statMode)}};StatModeController.prototype.calculateOctalMode_=function(statMode){return this.getMode_(statMode).toString(8)};
StatModeController.prototype.calculateModeString_=function(statMode){var fileType="-";if(this.isRegularFile_(statMode))fileType="-";else if(this.isBlockDevice_(statMode))fileType="b";else if(this.isCharacterDevice_(statMode))fileType="c";else if(this.isDirectory_(statMode))fileType="d";else if(this.isFifo_(statMode))fileType="p";else if(this.isLink_(statMode))fileType="l";else if(this.isSocket_(statMode))fileType="s";var permissions="";permissions+=statMode&S_IRUSR?"r":"-";permissions+=statMode&S_IWUSR?
"w":"-";if(statMode&S_ISUID)permissions+=statMode&S_IXUSR?"s":"S";else permissions+=statMode&S_IXUSR?"x":"-";permissions+=statMode&S_IRGRP?"r":"-";permissions+=statMode&S_IWGRP?"w":"-";if(statMode&S_ISGID)permissions+=statMode&S_IXGRP?"s":"S";else permissions+=statMode&S_IXGRP?"x":"-";permissions+=statMode&S_IROTH?"r":"-";permissions+=statMode&S_IWOTH?"w":"-";if(statMode&S_ISVTX)permissions+=statMode&S_IXOTH?"t":"T";else permissions+=statMode&S_IXOTH?"x":"-";return fileType+permissions};StatModeController.prototype.getMode_=
function(mode){return mode&S_IMODE};StatModeController.prototype.getType_=function(mode){return mode&S_IFMT};StatModeController.prototype.isDirectory_=function(mode){return this.getType_(mode)===S_IFDIR};StatModeController.prototype.isCharacterDevice_=function(mode){return this.getType_(mode)===S_IFCHR};StatModeController.prototype.isBlockDevice_=function(mode){return this.getType_(mode)===S_IFBLK};StatModeController.prototype.isRegularFile_=function(mode){return this.getType_(mode)===S_IFREG};StatModeController.prototype.isFifo_=
function(mode){return this.getType_(mode)===S_IFIFO};StatModeController.prototype.isLink_=function(mode){return this.getType_(mode)===S_IFLNK};StatModeController.prototype.isSocket_=function(mode){return this.getType_(mode)===S_IFSOCK};exports.StatModeDirective=function($filter){return{scope:{value:"="},restrict:"E",template:'<abbr title="Mode {$ ::controller.octalStatMode $}">'+"  {$ ::controller.statMode $}"+"</abbr>",controller:StatModeController,controllerAs:"controller"}};exports.StatModeDirective.directive_name=
"grrStatMode";exports.StatModeDirective.semantic_type="StatMode";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.timestampDirective");goog.module.declareLegacyNamespace();var TimestampController=function($scope,$element,grrTimeService){this.scope_=$scope;this.scope_.value;this.formattedTimestamp;this.formattedTimestampComponents;this.value;this.element_=$element;this.timeService_=grrTimeService;this.scope_.$watch("::value",this.onValueChange.bind(this))};TimestampController.prototype.onValueChange=function(newValue){if(angular.isDefined(newValue))if(newValue===
null||newValue===0)this.formattedTimestamp="-";else{var timestamp;if(angular.isObject(newValue))timestamp=newValue.value/1E3;else timestamp=newValue/1E3;this.value=timestamp;this.formattedTimestamp=this.timeService_.formatAsUTC(timestamp);this.formattedTimestampComponents=this.formattedTimestamp.split(" ")}};TimestampController.prototype.onMouseEnter=function(){var span=$(this.element_).find("span")[0];if(angular.isDefined(this.value))span.title=this.timeService_.getFormattedDiffFromCurrentTime(Number(this.value))};
exports.TimestampDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/timestamp.html",controller:TimestampController,controllerAs:"controller"}};exports.TimestampDirective.directive_name="grrTimestamp";exports.TimestampDirective.semantic_type="RDFDatetime";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.timestampSecondsDirective");goog.module.declareLegacyNamespace();var TimestampSecondsController=function($scope){this.scope_=$scope;this.scope_.value;this.timestampValue;this.scope_.$watch("::value",this.onValueChange.bind(this))};TimestampSecondsController.prototype.onValueChange=function(newValue){if(angular.isDefined(newValue)){var timestamp;if(angular.isObject(newValue))timestamp=newValue.value;else timestamp=newValue;
this.timestampValue=timestamp*1E6}};exports.TimestampSecondsDirective=function(){return{scope:{value:"="},restrict:"E",template:'<grr-timestamp value="::controller.timestampValue"></grr-timestamp>',controller:TimestampSecondsController,controllerAs:"controller"}};exports.TimestampSecondsDirective.directive_name="grrTimestampSeconds";exports.TimestampSecondsDirective.semantic_type="RDFDatetimeSeconds";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.routing.aff4UrnToUrl");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var93=goog.require("grrUi.core.utils");var CLIENT_ID_RE=$jscomp$destructuring$var93.CLIENT_ID_RE;var stripAff4Prefix=$jscomp$destructuring$var93.stripAff4Prefix;var $jscomp$destructuring$var94=goog.require("grrUi.core.fileDownloadUtils");var vfsRoots=$jscomp$destructuring$var94.vfsRoots;exports.aff4UrnToUrl=function(urn){var components=stripAff4Prefix(urn).split("/");
if(CLIENT_ID_RE.test(components[0]))if(vfsRoots.includes(components[1]))return{state:"client.vfs",params:{clientId:components[0],path:components.slice(1).join("/")}};else if(components[1]==="flows"&&components.length===3)return{state:"client.flows",params:{clientId:components[0],flowId:components[2]}};else return{state:"client",params:{clientId:components[0]}};else if(components[0]==="hunts")return{state:"hunts",params:{huntId:components[1]}};else if(components[0]==="cron")return{state:"crons",params:{cronJobId:components[1]}};
else if(components[0]==="ACL")if(CLIENT_ID_RE.test(components[1]))return{state:"clientApproval",params:{clientId:components[1],username:components[components.length-2],approvalId:components[components.length-1]}};else if(components[1]=="hunts")return{state:"huntApproval",params:{huntId:components[2],username:components[components.length-2],approvalId:components[components.length-1]}};else if(components[1]=="cron")return{state:"cronJobApproval",params:{cronJobId:components[2],username:components[components.length-
2],approvalId:components[components.length-1]}};return null};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.urnDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var95=goog.require("grrUi.routing.aff4UrnToUrl");var aff4UrnToUrl=$jscomp$destructuring$var95.aff4UrnToUrl;var UrnController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.plainValue;this.ref;this.refState;this.refParams;this.scope_.$watch("::value",this.onValueChange_.bind(this))};UrnController.prototype.onValueChange_=
function(newValue){if(angular.isObject(newValue))this.plainValue=newValue.value;else if(angular.isString(newValue))this.plainValue=newValue;else return;var urlResult=aff4UrnToUrl(this.plainValue);if(urlResult){this.refState=urlResult.state;this.refParams=urlResult.params;this.ref=this.grrRoutingService_.href(urlResult.state,urlResult.params)}};UrnController.prototype.onClick=function(){this.grrRoutingService_.go("client.vfs",this.refParams)};exports.UrnDirective=function(){return{scope:{value:"="},
restrict:"E",templateUrl:"/static/angular-components/semantic/urn.html",controller:UrnController,controllerAs:"controller"}};exports.UrnDirective.directive_name="grrUrn";exports.UrnDirective.semantic_type="RDFURN";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.pseudo.fetchMoreLinkDirective");goog.module.declareLegacyNamespace();exports.FetchMoreLinkDirective=function(){return{scope:{value:"="},link:function(scope){scope.onClick=function(e){scope.continuationShown=true;e.stopPropagation()}},restrict:"E",templateUrl:"/static/angular-components/semantic/pseudo/"+"fetch-more-link.html"}};exports.FetchMoreLinkDirective.directive_name="grrFetchMoreLink";exports.FetchMoreLinkDirective.semantic_type=
"__FetchMoreLink";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.pseudo.pseudo");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var96=goog.require("grrUi.semantic.pseudo.fetchMoreLinkDirective");var FetchMoreLinkDirective=$jscomp$destructuring$var96.FetchMoreLinkDirective;var $jscomp$destructuring$var97=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var97.coreModule;exports.pseudoModule=angular.module("grrUi.semantic.pseudo",[coreModule.name,"ui.bootstrap"]);
exports.pseudoModule.directive(FetchMoreLinkDirective.directive_name,FetchMoreLinkDirective);exports.pseudoModule.run(function(grrSemanticValueDirectivesRegistryService){var registry=grrSemanticValueDirectivesRegistryService;registry.registerDirective(FetchMoreLinkDirective.semantic_type,FetchMoreLinkDirective)});return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekall.logDirective");goog.module.declareLegacyNamespace();exports.LogDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/rekall/log.html"}};exports.LogDirective.directive_name="grrRekallLog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekall.metadataDirective");goog.module.declareLegacyNamespace();exports.MetadataDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/rekall/metadata.html"}};exports.MetadataDirective.directive_name="grrRekallMetadata";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekall.registeredUnixTimeStampDirective");goog.module.declareLegacyNamespace();exports.RegisteredUnixTimeStampDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/rekall/"+"registered-unix-time-stamp.html"}};exports.RegisteredUnixTimeStampDirective.directive_name="grrRekallRegisteredUnixTimeStamp";exports.RegisteredUnixTimeStampDirective.rekall_type="UnixTimeStamp";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekall.rekallDefaultValueDirective");goog.module.declareLegacyNamespace();exports.RekallDefaultValueDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/rekall/rekall-default-value.html"}};exports.RekallDefaultValueDirective.directive_name="grrRekallDefaultValue";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekall.utils");goog.module.declareLegacyNamespace();exports.cropRekallJson=function(jsonStr,targetLen){if(targetLen<=2||jsonStr==="[]")return"[]";if(jsonStr.length<=targetLen)return jsonStr;if(!jsonStr.startsWith("[["))throw new Error("Malformed Rekall JSON message.");var lastMsgEnd=1;var depth=1;var escaped=false;var insideString=false;for(var i=2;i<targetLen-1;++i){if(!insideString)if(jsonStr[i]==="[")++depth;else if(jsonStr[i]===
"]"){--depth;if(depth==0)lastMsgEnd=i+1;else if(depth<0)throw new Error("Syntax error in Rekall JSON message.");}if(!escaped&&jsonStr[i]=='"')insideString=!insideString;escaped=!escaped&&jsonStr[i]==="\\"}return jsonStr.slice(0,lastMsgEnd)+"]"};exports.stackRekallTables=function(parsed){var ret=[];var lastTableRows;angular.forEach(parsed,function(message){var type=message[0];var content=message[1];if(type=="t"){lastTableRows=[];ret.push(["t",{"header":content,"rows":lastTableRows}])}else if(type==
"r"){if(angular.isUndefined(lastTableRows)){lastTableRows=[];ret.push(["t",{"header":undefined,"rows":lastTableRows}])}lastTableRows.push(content)}else ret.push(message)});return ret};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekall.rekallJsonDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var98=goog.require("grrUi.semantic.rekall.utils");var cropRekallJson=$jscomp$destructuring$var98.cropRekallJson;var stackRekallTables=$jscomp$destructuring$var98.stackRekallTables;var RekallJsonController=function($scope){this.scope_=$scope;this.parsedJson;this.error="";this.jsonContextStr;this.compressedJsonStr;this.state;this.renderIncomplete=
true;this.scope_.$watchGroup(["jsonContextMessages","compressedJsonMessages"],this.onScopeChange_.bind(this))};var FIRST_RENDER_LIMIT=1024;RekallJsonController.prototype.onClick=function(e){e.stopPropagation();this.render_()};RekallJsonController.prototype.render_=function(opt_renderLimit){var renderLimit=opt_renderLimit||Infinity;if(this.jsonContextStr.length+this.compressedJsonStr.length<=renderLimit)this.renderIncomplete=false;try{this.parsedJson=JSON.parse(cropRekallJson(this.jsonContextStr,renderLimit)).concat(JSON.parse(cropRekallJson(this.compressedJsonStr,
renderLimit-this.jsonContextStr.length)))}catch(err){this.error="error: "+err.message+", in:"+this.jsonContextStr+", "+this.compressedJsonStr;return}this.state=stackRekallTables(this.parsedJson)};RekallJsonController.prototype.onScopeChange_=function(){if(angular.isDefined(this.state))return;var jsonContext=this.scope_["jsonContextMessages"];var compressedJson=this.scope_["compressedJsonMessages"];if(angular.isUndefined(jsonContext)||angular.isUndefined(compressedJson))return;this.jsonContextStr=
jsonContext.value;this.compressedJsonStr=compressedJson.value;if(!angular.isString(this.jsonContextStr)||!angular.isString(this.compressedJsonStr)){this.error="Expected strings, got "+typeof this.jsonContextStr+" and "+typeof this.compressedJsonStr+".";return}this.render_(FIRST_RENDER_LIMIT)};exports.RekallJsonDirective=function(){return{scope:{jsonContextMessages:"=",compressedJsonMessages:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/rekall/rekall-json.html",controller:RekallJsonController,
controllerAs:"controller"}};exports.RekallJsonDirective.directive_name="grrRekallJson";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekall.rekallRegistryService");goog.module.declareLegacyNamespace();exports.RekallRegistryService=function(){this.directivesByType_={}};var RekallRegistryService=exports.RekallRegistryService;RekallRegistryService.service_name="grrRekallDirectivesRegistryService";RekallRegistryService.prototype.registerDirective=function(type,directive){this.directivesByType_[type]=directive};RekallRegistryService.prototype.findDirectiveForMro=
function(mro){if(angular.isUndefined(mro))return undefined;var splittedMro=mro.split(":");for(var i=0;i<splittedMro.length;++i){var objType=splittedMro[i];var directive=this.directivesByType_[objType];if(angular.isDefined(directive))return directive}return undefined};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekall.rekallValueDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var99=goog.require("grrUi.core.utils");var camelCaseToDashDelimited=$jscomp$destructuring$var99.camelCaseToDashDelimited;var RekallValueController=function($scope,$element,$compile,grrRekallDirectivesRegistryService){this.scope_=$scope;this.element_=$element;this.compile_=$compile;this.grrRekallDirectivesRegistryService_=grrRekallDirectivesRegistryService;
this.scope_.$watch("::value",this.onValueChange_.bind(this))};RekallValueController.prototype.onValueChange_=function(value){if(value===null||angular.isUndefined(value))return;if(!angular.isObject(value)){this.element_.text(value.toString());return}var directive=this.grrRekallDirectivesRegistryService_.findDirectiveForMro(value["mro"]);var tag="grr-rekall-default-value";if(angular.isDefined(directive))tag=camelCaseToDashDelimited(directive.directive_name);this.element_.html("<"+tag+' value="::value"></'+
tag+">");this.compile_(this.element_.contents())(this.scope_)};exports.RekallValueDirective=function(){return{scope:{value:"="},restrict:"E",controller:RekallValueController,controllerAs:"controller"}};exports.RekallValueDirective.directive_name="grrRekallValue";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekall.tableDirective");goog.module.declareLegacyNamespace();exports.TableDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/semantic/rekall/table.html"}};exports.TableDirective.directive_name="grrRekallTable";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.rekall.rekall");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var100=goog.require("grrUi.semantic.rekall.logDirective");var LogDirective=$jscomp$destructuring$var100.LogDirective;var $jscomp$destructuring$var101=goog.require("grrUi.semantic.rekall.metadataDirective");var MetadataDirective=$jscomp$destructuring$var101.MetadataDirective;var $jscomp$destructuring$var102=goog.require("grrUi.semantic.rekall.registeredUnixTimeStampDirective");
var RegisteredUnixTimeStampDirective=$jscomp$destructuring$var102.RegisteredUnixTimeStampDirective;var $jscomp$destructuring$var103=goog.require("grrUi.semantic.rekall.rekallDefaultValueDirective");var RekallDefaultValueDirective=$jscomp$destructuring$var103.RekallDefaultValueDirective;var $jscomp$destructuring$var104=goog.require("grrUi.semantic.rekall.rekallJsonDirective");var RekallJsonDirective=$jscomp$destructuring$var104.RekallJsonDirective;var $jscomp$destructuring$var105=goog.require("grrUi.semantic.rekall.rekallRegistryService");
var RekallRegistryService=$jscomp$destructuring$var105.RekallRegistryService;var $jscomp$destructuring$var106=goog.require("grrUi.semantic.rekall.rekallValueDirective");var RekallValueDirective=$jscomp$destructuring$var106.RekallValueDirective;var $jscomp$destructuring$var107=goog.require("grrUi.semantic.rekall.tableDirective");var TableDirective=$jscomp$destructuring$var107.TableDirective;var $jscomp$destructuring$var108=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var108.coreModule;
exports.rekallModule=angular.module("grrUi.semantic.rekall",[coreModule.name,"ui.bootstrap"]);exports.rekallModule.directive(LogDirective.directive_name,LogDirective);exports.rekallModule.directive(MetadataDirective.directive_name,MetadataDirective);exports.rekallModule.directive(RegisteredUnixTimeStampDirective.directive_name,RegisteredUnixTimeStampDirective);exports.rekallModule.directive(RekallDefaultValueDirective.directive_name,RekallDefaultValueDirective);exports.rekallModule.directive(RekallJsonDirective.directive_name,
RekallJsonDirective);exports.rekallModule.directive(RekallValueDirective.directive_name,RekallValueDirective);exports.rekallModule.directive(TableDirective.directive_name,TableDirective);exports.rekallModule.service(RekallRegistryService.service_name,RekallRegistryService);exports.rekallModule.run(function(grrRekallDirectivesRegistryService){var registry=grrRekallDirectivesRegistryService;registry.registerDirective(RegisteredUnixTimeStampDirective.rekall_type,RegisteredUnixTimeStampDirective)});return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.routing.routingService");goog.module.declareLegacyNamespace();exports.RoutingService=function($state){this.state_=$state};var RoutingService=exports.RoutingService;RoutingService.service_name="grrRoutingService";RoutingService.prototype.href=function(targetState,opt_params){return this.state_.href(targetState,opt_params)};RoutingService.prototype.go=function(targetState,opt_params){var currentState=this.state_.current.name;return this.state_.go(targetState,
opt_params,{notify:currentState!==targetState})};RoutingService.prototype.uiOnParamsChanged=function(scope,paramNames,callback,opt_stateAgnostic){var currentStateName=this.state_.current.name;if(!angular.isArray(paramNames)){var paramName=paramNames;paramNames=[paramName]}return scope.$watchCollection(function(){return paramNames.map(function(paramName){return this.state_.params[paramName]}.bind(this))}.bind(this),function(newValues,oldValues){if(!opt_stateAgnostic&&!this.state_.includes(currentStateName))return;
if(newValues.length===1)callback(newValues[0],this.state_.params);else callback(newValues,this.state_.params)}.bind(this))};RoutingService.prototype.onStateChange=function(scope,callback){callback(this.state_.current.name,this.state_.params);return scope.$on("$stateChangeSuccess",function(event,state,params){callback(state.name,params)}.bind(this))};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.utils");goog.module.declareLegacyNamespace();exports.ensurePathIsFolder=function(path){if(path.endsWith("/"))return path;else return path+"/"};exports.getFolderFromPath=function(path){if(!path)return"";var components=path.split("/");return components.slice(0,-1).join("/")};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.fileViewDirective");goog.module.declareLegacyNamespace();var replaceInvalidChars_=function(item){return item.replace(/[^a-zA-Z0-9]/g,function(invChar){var hex=invChar.charCodeAt(0).toString(16);return"_"+hex.toUpperCase()})};exports.getFileId=function(filePath){var components=filePath.split("/");var result=components.map(replaceInvalidChars_);return"_"+result.join("-")};exports.getFilePathFromId=function(fileId){var replaceEncodedChars=
function(item){return item.replace(/_[0-9A-F][0-9A-F]?/g,function(encChar){var charNum=parseInt(encChar.substr(1),16);return String.fromCharCode(charNum)})};var components=fileId.substr(1).split("-");var mapped=components.map(replaceEncodedChars);return mapped.join("/")};var FileViewController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.selectedFilePath;this.viewMode="list";this.tab="stats";this.fileVersion;this.clientId;this.grrRoutingService_.uiOnParamsChanged(this.scope_,
["clientId","path","version","mode","tab"],this.onUrlRoutingParamsChanged_.bind(this));this.scope_.$watchGroup(["controller.selectedFilePath","controller.fileVersion","controller.viewMode","controller.tab"],this.onFileContextRoutingParamsChange_.bind(this))};FileViewController.prototype.onUrlRoutingParamsChanged_=function(params){this.clientId=params[0];this.selectedFilePath=params[1];this.fileVersion=parseInt(params[2],10)||undefined;this.viewMode=params[3]||"list";this.tab=params[4]||"stats"};FileViewController.prototype.onFileContextRoutingParamsChange_=
function(){var params={path:this.selectedFilePath};params["version"]=this.fileVersion||undefined;if(!this.viewMode||this.viewMode=="list")params["mode"]=undefined;else params["mode"]=this.viewMode;if(!this.tab||this.tab=="stats")params["tab"]=undefined;else params["tab"]=this.tab;this.grrRoutingService_.go("client.vfs",params)};exports.FileViewDirective=function(){return{restrict:"E",scope:{},templateUrl:"/static/angular-components/client/virtual-file-system/file-view.html",controller:FileViewController,
controllerAs:"controller"}};exports.FileViewDirective.directive_name="grrFileView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.routing.rewriteUrl");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var109=goog.require("grrUi.routing.aff4UrnToUrl");var aff4UrnToUrl=$jscomp$destructuring$var109.aff4UrnToUrl;var $jscomp$destructuring$var110=goog.require("grrUi.core.apiService");var encodeUrlPath=$jscomp$destructuring$var110.encodeUrlPath;var $jscomp$destructuring$var111=goog.require("grrUi.client.virtualFileSystem.utils");var ensurePathIsFolder=$jscomp$destructuring$var111.ensurePathIsFolder;
var $jscomp$destructuring$var112=goog.require("grrUi.client.virtualFileSystem.fileViewDirective");var getFilePathFromId=$jscomp$destructuring$var112.getFilePathFromId;var parseHash=function(hash){if(hash.indexOf("#")==0)hash=hash.substr(1);var result={};var parts=hash.split("&");for(var i=0;i<parts.length;i++){var kv=parts[i].split("=");if(kv[0]&&kv[1])result[kv[0]]=decodeURIComponent(kv[1].replace(/\+/g," ")||"")}return result};exports.rewriteUrl=function(url){var hashState=parseHash(url);var clientId=
hashState["c"];if(clientId&&clientId.indexOf("aff4:/")===0)clientId=clientId.split("/")[1];var main=hashState["main"];switch(main){case "ManageCron":var cronJobUrn=hashState["cron_job_urn"];var cronJobId=cronJobUrn?cronJobUrn.split("/")[2]:"";return"/crons/"+cronJobId;case "ManageHunts":var huntUrn=hashState["hunt_id"];var huntId=huntUrn?huntUrn.split("/")[2]:"";return"/hunts/"+huntId;case "GlobalLaunchFlows":return"/global-flows";case "ServerLoadView":return"/server-load";case "BinaryConfigurationView":return"/manage-binaries";
case "ConfigManager":return"/config";case "ArtifactManagerView":return"/artifacts";case "ApiDocumentation":return"/api-docs";case "GrantAccess":var acl=hashState["acl"]||"";var routingState=aff4UrnToUrl(acl);switch(routingState["state"]){case "clientApproval":return["/users",routingState["params"]["username"],"approvals","client",routingState["params"]["clientId"],routingState["params"]["approvalId"]].join("/");case "huntApproval":return["/users",routingState["params"]["username"],"approvals","hunt",
routingState["params"]["huntId"],routingState["params"]["approvalId"]].join("/");case "cronJobApproval":return["/users",routingState["params"]["username"],"approvals","cron-job",routingState["params"]["cronJobId"],routingState["params"]["approvalId"]].join("/");default:break}return"/";case "CanaryTestRenderer":return"/canary-test";case "HostTable":var q=hashState["q"]||"";return"/search?q="+q;case "HostInformation":return"/clients/"+clientId;case "VirtualFileSystemView":var path;if(hashState["aff4_path"])path=
hashState["aff4_path"].slice(hashState["c"].length+1);else path=ensurePathIsFolder(getFilePathFromId(hashState["t"]||""));return"/clients/"+clientId+"/vfs/"+encodeUrlPath(path);case "TimelineMain":case "ContainerViewer":var path=hashState["container"]||"";var query=hashState["query"]||"";return"/clients/"+clientId+"/vfs-container"+"?path="+path+"&query="+query;case "LaunchFlows":return"/clients/"+clientId+"/launch-flow";case "ManageFlows":var flowUrn=hashState["flow"];var flowId=flowUrn?flowUrn.split("/")[3]:
"";return"/clients/"+clientId+"/flows/"+flowId;case "DebugClientRequestsView":return"/clients/"+clientId+"/debug-requests";case "ClientLoadView":return"/clients/"+clientId+"/load";case "ClientCrashesRenderer":return"/clients/"+clientId+"/crashes";case "ClientStatsView":return"/clients/"+clientId+"/stats";default:if(clientId)return"/clients/"+clientId;return null}};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.routing.routing");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var113=goog.require("grrUi.routing.routingService");var RoutingService=$jscomp$destructuring$var113.RoutingService;var $jscomp$destructuring$var114=goog.require("grrUi.core.apiService");var encodeUrlPath=$jscomp$destructuring$var114.encodeUrlPath;var $jscomp$destructuring$var115=goog.require("grrUi.routing.rewriteUrl");var rewriteUrl=$jscomp$destructuring$var115.rewriteUrl;
exports.routingModule=angular.module("grrUi.routing",["ui.router"]);exports.routingModule.service(RoutingService.service_name,RoutingService);exports.routingModule.config(function($stateProvider,$urlRouterProvider,$urlMatcherFactoryProvider){$urlMatcherFactoryProvider.type("pathWithUnescapedSlashes",{encode:function(item){if(!item)return"";else return encodeUrlPath(item)},decode:function(item){if(!item)return"";else return decodeURIComponent(item)},pattern:/.*/});$urlRouterProvider.deferIntercept();
$stateProvider.state("userDashboard",{url:"",template:"<grr-user-dashboard />",title:"Home"}).state("search",{url:"/search?q",template:"<grr-clients-list />",title:function(params){if(params["q"])return'Search for "'+params["q"]+'"';else return"Client List"}}).state("apiDocs",{url:"/api-docs",template:"<grr-api-docs />",title:"API Docs"}).state("clientApproval",{url:"/users/:username/approvals/client/:clientId/:approvalId",template:"<grr-client-approval-view />",title:function(params){return["Approvals",
params["username"],params["clientId"]]}}).state("huntApproval",{url:"/users/:username/approvals/hunt/:huntId/:approvalId",template:"<grr-hunt-approval-view />",title:function(params){return["Approvals",params["username"],params["huntId"]]}}).state("cronJobApproval",{url:"/users/:username/approvals/cron-job/:cronJobId/:approvalId",template:"<grr-cron-job-approval-view />",title:function(params){return["Approvals",params["username"],params["cronJobId"]]}}).state("crons",{url:"/crons/:cronJobId/:tab",
template:"<grr-cron-view />",params:{cronJobId:{value:null,squash:true},tab:{value:null,squash:true}},title:function(params){if(params["cronJobId"])return["Cron Jobs",params["cronJobId"]];else return"Cron Jobs"}}).state("hunts",{url:"/hunts/:huntId/:tab",template:"<grr-hunts-view />",params:{huntId:{value:null,squash:true},tab:{value:null,squash:true}},title:function(params){if(params["huntId"])return params["huntId"];else return"Hunts"}}).state("stats",{url:"/stats/:name/:client_label?start_time&duration",
template:"<grr-stats-view />",params:{name:{value:null,squash:true},client_label:{value:null,squash:true}},title:"Stats"}).state("serverLoad",{url:"/server-load",template:"<grr-server-load />",title:"Server Load"}).state("manageBinaries",{url:"/manage-binaries",template:"<grr-config-binaries-view />",title:"Manage Binaries"}).state("config",{url:"/config",template:"<grr-config-view />",title:"Configuration"}).state("artifacts",{url:"/artifacts",template:"<grr-artifact-manager-view />",title:"Artifacts"}).state("client",
{url:"/clients/:clientId",redirectTo:"client.hostInfo",template:"<div ui-view></div>",title:function(params){return params["clientId"]}}).state("client.hostInfo",{url:"/host-info",template:"<grr-host-info />",title:"Host Information"}).state("client.launchFlows",{url:"/launch-flow",template:"<grr-start-flow-view />",title:"Launch Flows"}).state("client.vfs",{url:"/vfs/{path:pathWithUnescapedSlashes}?version&mode&tab",template:"<grr-file-view />",title:function(params){return"/"+(params["path"]||"")}}).state("client.flows",
{url:"/flows/:flowId/:tab",template:"<grr-client-flows-view />",params:{flowId:{value:null,squash:true},tab:{value:null,squash:true}},title:function(params){if(params["flowId"])return params["flowId"];else return"Flows"}}).state("client.crashes",{url:"/crashes",template:"<grr-client-crashes />",title:"Crashes"}).state("client.debugRequests",{url:"/debug-requests",template:"<grr-debug-requests-view />",title:"Debug Requests"}).state("client.loadStats",{url:"/load-stats",template:"<grr-client-load-view />",
title:"Load Stats"})}).run(function($rootScope,$location,$state,$urlRouter,$document){var updateTitle=function(){var breadcrumbs=[];var curState=$state["$current"];while(angular.isDefined(curState)){if(angular.isString(curState.title))breadcrumbs.splice(0,0,curState.title);else if(angular.isFunction(curState.title)){var newItem=curState.title($state.params);if(angular.isArray(newItem))breadcrumbs=newItem.concat(breadcrumbs);else breadcrumbs.splice(0,0,newItem)}curState=curState.parent}breadcrumbs.splice(0,
0,"GRR");$document[0].title=breadcrumbs.join(" | ")};$rootScope.$on("$stateChangeStart",function(evt,to,params){if(to.redirectTo){evt.preventDefault();$state.go(to.redirectTo,params)}});$rootScope.$on("$stateChangeSuccess",updateTitle);$rootScope.$on("$locationChangeSuccess",function(evt){evt.preventDefault();var url=$location.url().substring(1);var rewrittenUrl=rewriteUrl(url);if(rewrittenUrl)$location.url(rewrittenUrl);$urlRouter.sync();updateTitle()});$urlRouter.listen()});return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.semantic.semantic");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var116=goog.require("grrUi.semantic.apiHuntResultDirective");var ApiHuntResultDirective=$jscomp$destructuring$var116.ApiHuntResultDirective;var $jscomp$destructuring$var117=goog.require("grrUi.semantic.byteSizeDirective");var ByteSizeDirective=$jscomp$destructuring$var117.ByteSizeDirective;var $jscomp$destructuring$var118=goog.require("grrUi.semantic.bytesDirective");
var BytesDirective=$jscomp$destructuring$var118.BytesDirective;var $jscomp$destructuring$var119=goog.require("grrUi.semantic.clientUrnDirective");var ClientUrnDirective=$jscomp$destructuring$var119.ClientUrnDirective;var $jscomp$destructuring$var120=goog.require("grrUi.semantic.dataObjectDirective");var DataObjectDirective=$jscomp$destructuring$var120.DataObjectDirective;var $jscomp$destructuring$var121=goog.require("grrUi.semantic.dictDirective");var DictDirective=$jscomp$destructuring$var121.DictDirective;
var $jscomp$destructuring$var122=goog.require("grrUi.semantic.durationDirective");var DurationDirective=$jscomp$destructuring$var122.DurationDirective;var $jscomp$destructuring$var123=goog.require("grrUi.semantic.encryptionKeyDirective");var EncryptionKeyDirective=$jscomp$destructuring$var123.EncryptionKeyDirective;var $jscomp$destructuring$var124=goog.require("grrUi.semantic.flowIdDirective");var FlowIdDirective=$jscomp$destructuring$var124.FlowIdDirective;var $jscomp$destructuring$var125=goog.require("grrUi.semantic.hashDigestDirective");
var HashDigestDirective=$jscomp$destructuring$var125.HashDigestDirective;var $jscomp$destructuring$var126=goog.require("grrUi.semantic.hashListDirective");var HashListDirective=$jscomp$destructuring$var126.HashListDirective;var $jscomp$destructuring$var127=goog.require("grrUi.semantic.huntIdDirective");var HuntIdDirective=$jscomp$destructuring$var127.HuntIdDirective;var $jscomp$destructuring$var128=goog.require("grrUi.semantic.jsonDirective");var JsonDirective=$jscomp$destructuring$var128.JsonDirective;
var $jscomp$destructuring$var129=goog.require("grrUi.semantic.macAddressDirective");var MacAddressDirective=$jscomp$destructuring$var129.MacAddressDirective;var $jscomp$destructuring$var130=goog.require("grrUi.semantic.networkAddressDirective");var NetworkAddressDirective=$jscomp$destructuring$var130.NetworkAddressDirective;var $jscomp$destructuring$var131=goog.require("grrUi.semantic.objectLabelDirective");var ObjectLabelDirective=$jscomp$destructuring$var131.ObjectLabelDirective;var $jscomp$destructuring$var132=
goog.require("grrUi.semantic.objectLabelsListDirective");var ObjectLabelsListDirective=$jscomp$destructuring$var132.ObjectLabelsListDirective;var $jscomp$destructuring$var133=goog.require("grrUi.semantic.primitiveDirective");var PrimitiveDirective=$jscomp$destructuring$var133.PrimitiveDirective;var $jscomp$destructuring$var134=goog.require("grrUi.semantic.semanticValueDirective");var RegistryOverrideDirective=$jscomp$destructuring$var134.RegistryOverrideDirective;var SemanticValueDirective=$jscomp$destructuring$var134.SemanticValueDirective;
var $jscomp$destructuring$var135=goog.require("grrUi.semantic.rekallResponseDirective");var RekallResponseDirective=$jscomp$destructuring$var135.RekallResponseDirective;var $jscomp$destructuring$var136=goog.require("grrUi.semantic.semanticDiffAnnotatedProtoDirective");var SemanticDiffAnnotatedProtoDirective=$jscomp$destructuring$var136.SemanticDiffAnnotatedProtoDirective;var $jscomp$destructuring$var137=goog.require("grrUi.semantic.semanticProtoDirective");var SemanticProtoDirective=$jscomp$destructuring$var137.SemanticProtoDirective;
var $jscomp$destructuring$var138=goog.require("grrUi.semantic.semanticProtosDiffDirective");var SemanticProtosDiffDirective=$jscomp$destructuring$var138.SemanticProtosDiffDirective;var $jscomp$destructuring$var139=goog.require("grrUi.core.semanticRegistryService");var SemanticRegistryService=$jscomp$destructuring$var139.SemanticRegistryService;var $jscomp$destructuring$var140=goog.require("grrUi.semantic.semanticVersionedProtoDirective");var SemanticVersionedProtoDirective=$jscomp$destructuring$var140.SemanticVersionedProtoDirective;
var $jscomp$destructuring$var141=goog.require("grrUi.semantic.statEntryDirective");var StatEntryDirective=$jscomp$destructuring$var141.StatEntryDirective;var $jscomp$destructuring$var142=goog.require("grrUi.semantic.statExtFlagsLinuxDirective");var StatExtFlagsLinuxDirective=$jscomp$destructuring$var142.StatExtFlagsLinuxDirective;var $jscomp$destructuring$var143=goog.require("grrUi.semantic.statExtFlagsOsxDirective");var StatExtFlagsOsxDirective=$jscomp$destructuring$var143.StatExtFlagsOsxDirective;
var $jscomp$destructuring$var144=goog.require("grrUi.semantic.statModeDirective");var StatModeDirective=$jscomp$destructuring$var144.StatModeDirective;var $jscomp$destructuring$var145=goog.require("grrUi.semantic.timestampDirective");var TimestampDirective=$jscomp$destructuring$var145.TimestampDirective;var $jscomp$destructuring$var146=goog.require("grrUi.semantic.timestampSecondsDirective");var TimestampSecondsDirective=$jscomp$destructuring$var146.TimestampSecondsDirective;var $jscomp$destructuring$var147=
goog.require("grrUi.semantic.urnDirective");var UrnDirective=$jscomp$destructuring$var147.UrnDirective;var $jscomp$destructuring$var148=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var148.coreModule;var $jscomp$destructuring$var149=goog.require("grrUi.semantic.pseudo.pseudo");var pseudoModule=$jscomp$destructuring$var149.pseudoModule;var $jscomp$destructuring$var150=goog.require("grrUi.semantic.rekall.rekall");var rekallModule=$jscomp$destructuring$var150.rekallModule;var $jscomp$destructuring$var151=
goog.require("grrUi.routing.routing");var routingModule=$jscomp$destructuring$var151.routingModule;exports.semanticModule=angular.module("grrUi.semantic",[coreModule.name,routingModule.name,pseudoModule.name,rekallModule.name,"ui.bootstrap"]);exports.semanticModule.directive(ApiHuntResultDirective.directive_name,ApiHuntResultDirective);exports.semanticModule.directive(ByteSizeDirective.directive_name,ByteSizeDirective);exports.semanticModule.directive(BytesDirective.directive_name,BytesDirective);
exports.semanticModule.directive(ClientUrnDirective.directive_name,ClientUrnDirective);exports.semanticModule.directive(DataObjectDirective.directive_name,DataObjectDirective);exports.semanticModule.directive(DictDirective.directive_name,DictDirective);exports.semanticModule.directive(DurationDirective.directive_name,DurationDirective);exports.semanticModule.directive(EncryptionKeyDirective.directive_name,EncryptionKeyDirective);exports.semanticModule.directive(FlowIdDirective.directive_name,FlowIdDirective);
exports.semanticModule.directive(HashDigestDirective.directive_name,HashDigestDirective);exports.semanticModule.directive(HashListDirective.directive_name,HashListDirective);exports.semanticModule.directive(HuntIdDirective.directive_name,HuntIdDirective);exports.semanticModule.directive(JsonDirective.directive_name,JsonDirective);exports.semanticModule.directive(MacAddressDirective.directive_name,MacAddressDirective);exports.semanticModule.directive(NetworkAddressDirective.directive_name,NetworkAddressDirective);
exports.semanticModule.directive(ObjectLabelDirective.directive_name,ObjectLabelDirective);exports.semanticModule.directive(ObjectLabelsListDirective.directive_name,ObjectLabelsListDirective);exports.semanticModule.directive(PrimitiveDirective.directive_name,PrimitiveDirective);exports.semanticModule.directive(RekallResponseDirective.directive_name,RekallResponseDirective);exports.semanticModule.directive(SemanticDiffAnnotatedProtoDirective.directive_name,SemanticDiffAnnotatedProtoDirective);exports.semanticModule.directive(SemanticProtoDirective.directive_name,
SemanticProtoDirective);exports.semanticModule.directive(RegistryOverrideDirective.directive_name,RegistryOverrideDirective);exports.semanticModule.directive(SemanticValueDirective.directive_name,SemanticValueDirective);exports.semanticModule.directive(SemanticProtosDiffDirective.directive_name,SemanticProtosDiffDirective);exports.semanticModule.directive(SemanticVersionedProtoDirective.directive_name,SemanticVersionedProtoDirective);exports.semanticModule.directive(StatEntryDirective.directive_name,
StatEntryDirective);exports.semanticModule.directive(StatExtFlagsLinuxDirective.directive_name,StatExtFlagsLinuxDirective);exports.semanticModule.directive(StatExtFlagsOsxDirective.directive_name,StatExtFlagsOsxDirective);exports.semanticModule.directive(StatModeDirective.directive_name,StatModeDirective);exports.semanticModule.directive(TimestampDirective.directive_name,TimestampDirective);exports.semanticModule.directive(TimestampSecondsDirective.directive_name,TimestampSecondsDirective);exports.semanticModule.directive(UrnDirective.directive_name,
UrnDirective);exports.semanticModule.service(SemanticRegistryService.values_service_name,SemanticRegistryService);exports.semanticModule.run(function(grrSemanticValueDirectivesRegistryService){var registry=grrSemanticValueDirectivesRegistryService;registry.registerDirective(ApiHuntResultDirective.semantic_type,ApiHuntResultDirective);registry.registerDirective(ByteSizeDirective.semantic_type,ByteSizeDirective);angular.forEach(BytesDirective.semantic_types,function(type){registry.registerDirective(type,
BytesDirective)}.bind(this));angular.forEach(ClientUrnDirective.semantic_types,function(type){registry.registerDirective(type,ClientUrnDirective)}.bind(this));registry.registerDirective(DataObjectDirective.semantic_type,DataObjectDirective);angular.forEach(DictDirective.semantic_types,function(type){registry.registerDirective(type,DictDirective)}.bind(this));registry.registerDirective(DurationDirective.semantic_type,DurationDirective);registry.registerDirective(EncryptionKeyDirective.semantic_type,
EncryptionKeyDirective);registry.registerDirective(FlowIdDirective.semantic_type,FlowIdDirective);registry.registerDirective(HashDigestDirective.semantic_type,HashDigestDirective);registry.registerDirective(HashListDirective.semantic_type,HashListDirective);registry.registerDirective(HuntIdDirective.semantic_type,HuntIdDirective);registry.registerDirective(JsonDirective.semantic_type,JsonDirective);registry.registerDirective(MacAddressDirective.semantic_type,MacAddressDirective);registry.registerDirective(NetworkAddressDirective.semantic_type,
NetworkAddressDirective);registry.registerDirective(ObjectLabelDirective.semantic_type,ObjectLabelDirective);registry.registerDirective(ObjectLabelDirective.semantic_type,ObjectLabelDirective);registry.registerDirective(ObjectLabelsListDirective.semantic_type,ObjectLabelsListDirective);angular.forEach(PrimitiveDirective.semantic_types,function(type){registry.registerDirective(type,PrimitiveDirective)}.bind(this));registry.registerDirective(RekallResponseDirective.semantic_type,RekallResponseDirective);
registry.registerDirective(SemanticProtoDirective.semantic_type,SemanticProtoDirective);angular.forEach(StatEntryDirective.semantic_types,function(type){registry.registerDirective(type,StatEntryDirective)}.bind(this));registry.registerDirective(StatExtFlagsLinuxDirective.semantic_type,StatExtFlagsLinuxDirective);registry.registerDirective(StatExtFlagsOsxDirective.semantic_type,StatExtFlagsOsxDirective);registry.registerDirective(StatModeDirective.semantic_type,StatModeDirective);registry.registerDirective(TimestampDirective.semantic_type,
TimestampDirective);registry.registerDirective(TimestampSecondsDirective.semantic_type,TimestampSecondsDirective);registry.registerDirective(UrnDirective.semantic_type,UrnDirective)});return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.artifact.artifact");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var152=goog.require("grrUi.artifact.artifactDescriptorDirective");var ArtifactDescriptorDirective=$jscomp$destructuring$var152.ArtifactDescriptorDirective;var $jscomp$destructuring$var153=goog.require("grrUi.artifact.artifactDescriptorsService");var ArtifactDescriptorsService=$jscomp$destructuring$var153.ArtifactDescriptorsService;var $jscomp$destructuring$var154=
goog.require("grrUi.artifact.artifactDialogService");var ArtifactDialogService=$jscomp$destructuring$var154.ArtifactDialogService;var $jscomp$destructuring$var155=goog.require("grrUi.artifact.artifactManagerViewDirective");var ArtifactManagerViewDirective=$jscomp$destructuring$var155.ArtifactManagerViewDirective;var $jscomp$destructuring$var156=goog.require("grrUi.artifact.artifactNameDirective");var ArtifactNameDirective=$jscomp$destructuring$var156.ArtifactNameDirective;var $jscomp$destructuring$var157=
goog.require("grrUi.artifact.artifactsListFormDirective");var ArtifactsListFormDirective=$jscomp$destructuring$var157.ArtifactsListFormDirective;var $jscomp$destructuring$var158=goog.require("grrUi.artifact.deleteArtifactsDialogDirective");var DeleteArtifactsDialogDirective=$jscomp$destructuring$var158.DeleteArtifactsDialogDirective;var $jscomp$destructuring$var159=goog.require("grrUi.artifact.uploadArtifactDialogDirective");var UploadArtifactDialogDirective=$jscomp$destructuring$var159.UploadArtifactDialogDirective;
var $jscomp$destructuring$var160=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var160.coreModule;var $jscomp$destructuring$var161=goog.require("grrUi.forms.forms");var formsModule=$jscomp$destructuring$var161.formsModule;var $jscomp$destructuring$var162=goog.require("grrUi.semantic.semantic");var semanticModule=$jscomp$destructuring$var162.semanticModule;exports.artifactModule=angular.module("grrUi.artifact",[coreModule.name,formsModule.name,semanticModule.name,"ui.bootstrap"]);
exports.artifactModule.directive(ArtifactDescriptorDirective.directive_name,ArtifactDescriptorDirective);exports.artifactModule.directive(ArtifactNameDirective.directive_name,ArtifactNameDirective);exports.artifactModule.directive(ArtifactManagerViewDirective.directive_name,ArtifactManagerViewDirective);exports.artifactModule.directive(ArtifactsListFormDirective.directive_name,ArtifactsListFormDirective);exports.artifactModule.directive(DeleteArtifactsDialogDirective.directive_name,DeleteArtifactsDialogDirective);
exports.artifactModule.directive(UploadArtifactDialogDirective.directive_name,UploadArtifactDialogDirective);exports.artifactModule.service(ArtifactDescriptorsService.service_name,ArtifactDescriptorsService);exports.artifactModule.service(ArtifactDialogService.service_name,ArtifactDialogService);exports.artifactModule.run(function(grrSemanticRepeatedFormDirectivesRegistryService){var registry=grrSemanticRepeatedFormDirectivesRegistryService;registry.registerDirective(ArtifactsListFormDirective.semantic_type,
ArtifactsListFormDirective)});exports.artifactModule.run(function(grrSemanticValueDirectivesRegistryService){var registry=grrSemanticValueDirectivesRegistryService;registry.registerDirective(ArtifactDescriptorDirective.semantic_type,ArtifactDescriptorDirective);registry.registerDirective(ArtifactNameDirective.semantic_type,ArtifactNameDirective)});return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.addClientsLabelsDialogDirective");goog.module.declareLegacyNamespace();var AddClientsLabelsDialogController=function($scope,$q,grrApiService){this.scope_=$scope;this.q_=$q;this.grrApiService_=grrApiService;this.labelName};AddClientsLabelsDialogController.prototype.proceed=function(){var clients=[];angular.forEach(this.scope_["clients"],function(clientObj){clients.push(clientObj["value"]["client_id"]["value"])});var deferred=
this.q_.defer();var url="/clients/labels/add";var params={client_ids:clients,labels:[this.labelName]};this.grrApiService_.post(url,params).then(function success(){deferred.resolve("Label was successfully added.")}.bind(this),function failure(response){deferred.reject(response.data.message)}.bind(this));return deferred.promise};exports.AddClientsLabelsDialogDirective=function(){return{scope:{clients:"="},restrict:"E",templateUrl:"/static/angular-components/client/"+"add-clients-labels-dialog.html",
controller:AddClientsLabelsDialogController,controllerAs:"controller"}};exports.AddClientsLabelsDialogDirective.directive_name="grrAddClientsLabelsDialog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.checkClientAccessDirective");goog.module.declareLegacyNamespace();var CheckClientAccessController=function($scope,$timeout,grrApiService,grrRoutingService){this.scope_=$scope;this.timeout_=$timeout;this.grrApiService_=grrApiService;this.grrRoutingService_=grrRoutingService;this.scope_.$watch("clientId",this.onClientIdChange_.bind(this))};CheckClientAccessController.prototype.onClientIdChange_=function(clientId){if(angular.isDefined(clientId)){this.scope_["outHasAccess"]=
undefined;this.grrApiService_.head("clients/"+clientId+"/flows").then(this.onClientAccessPermitted_.bind(this),this.onClientAccessRejected_.bind(this))}};CheckClientAccessController.prototype.onClientAccessPermitted_=function(){this.scope_["outHasAccess"]=true};CheckClientAccessController.prototype.onClientAccessRejected_=function(){this.scope_["outHasAccess"]=false;if(!this.scope_["noRedirect"])this.timeout_(function(){var clientId=this.scope_["clientId"];if(angular.isDefined(clientId))this.grrRoutingService_.go("client",
{clientId:clientId})}.bind(this),1E3)};exports.CheckClientAccessDirective=function(){return{scope:{noRedirect:"=",clientId:"=",outHasAccess:"=?"},transclude:true,restrict:"E",templateUrl:"/static/angular-components/client/check-client-access.html",controller:CheckClientAccessController,controllerAs:"controller"}};exports.CheckClientAccessDirective.directive_name="grrCheckClientAccess";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.clientContextDirective");goog.module.declareLegacyNamespace();var ClientContextController=function($scope){this.clientId;$scope.$watch("clientId",this.onClientIdChange_.bind(this))};ClientContextController.prototype.onClientIdChange_=function(clientId){this.clientId=clientId};exports.ClientContextDirective=function(){return{scope:{clientId:"="},restrict:"E",transclude:true,template:'<ng-transclude ng-if="controller.clientId"></ng-transclude>',
controller:ClientContextController,controllerAs:"controller"}};exports.ClientContextDirective.directive_name="grrClientContext";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.clientCrashesDirective");goog.module.declareLegacyNamespace();var ClientCrashesController=function($scope,grrApiService,grrRoutingService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrRoutingService_=grrRoutingService;this.clientId;this.crashes;this.grrRoutingService_.uiOnParamsChanged(this.scope_,"clientId",this.onClientIdChange_.bind(this))};ClientCrashesController.prototype.onClientIdChange_=function(clientId){this.clientId=
clientId;this.grrApiService_.get("clients/"+clientId+"/crashes").then(function(response){this.crashes=response["data"]["items"]}.bind(this))};exports.ClientCrashesDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/client/client-crashes.html",controller:ClientCrashesController,controllerAs:"controller"}};exports.ClientCrashesDirective.directive_name="grrClientCrashes";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.removeClientsLabelsDialogDirective");goog.module.declareLegacyNamespace();var RemoveClientsLabelsDialogController=function($scope,$q,grrApiService){this.scope_=$scope;this.q_=$q;this.grrApiService_=grrApiService;this.availableLabels=[];this.labelName;this.scope_.$watch("clients",this.onClientsChange_.bind(this))};RemoveClientsLabelsDialogController.prototype.onClientsChange_=function(newValue){var labelsSet={};if(angular.isDefined(newValue))angular.forEach(newValue,
function(client){if(angular.isDefined(client["value"]["labels"]))angular.forEach(client["value"]["labels"],function(label){if(label["value"]["owner"]["value"]!=="GRR")labelsSet[label["value"]["name"]["value"]]=true})}.bind(this));this.availableLabels=Object.keys(labelsSet);if(this.availableLabels.length>0)this.labelName=this.availableLabels[0]};RemoveClientsLabelsDialogController.prototype.proceed=function(){var clients=[];angular.forEach(this.scope_["clients"],function(clientObj){clients.push(clientObj["value"]["client_id"]["value"])});
var deferred=this.q_.defer();var url="/clients/labels/remove";var params={client_ids:clients,labels:[this.labelName]};this.grrApiService_.post(url,params).then(function success(){deferred.resolve("Label was successfully removed.")}.bind(this),function failure(response){deferred.reject(response.data.message)}.bind(this));return deferred.promise};exports.RemoveClientsLabelsDialogDirective=function(){return{scope:{clients:"="},restrict:"E",templateUrl:"/static/angular-components/client/"+"remove-clients-labels-dialog.html",
controller:RemoveClientsLabelsDialogController,controllerAs:"controller"}};exports.RemoveClientsLabelsDialogDirective.directive_name="grrRemoveClientsLabelsDialog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.clientDialogService");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var163=goog.require("grrUi.client.addClientsLabelsDialogDirective");var AddClientsLabelsDialogDirective=$jscomp$destructuring$var163.AddClientsLabelsDialogDirective;var $jscomp$destructuring$var164=goog.require("grrUi.client.removeClientsLabelsDialogDirective");var RemoveClientsLabelsDialogDirective=$jscomp$destructuring$var164.RemoveClientsLabelsDialogDirective;
exports.ClientDialogService=function(grrDialogService){this.grrDialogService_=grrDialogService};var ClientDialogService=exports.ClientDialogService;ClientDialogService.service_name="grrClientDialogService";ClientDialogService.prototype.openAddClientLabels=function(clients){var directive=AddClientsLabelsDialogDirective;return this.grrDialogService_.openDirectiveDialog(directive.directive_name,{clients:clients})};ClientDialogService.prototype.openRemoveClientLabels=function(clients){var directive=RemoveClientsLabelsDialogDirective;
return this.grrDialogService_.openDirectiveDialog(directive.directive_name,{clients:clients})};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.clientLoadGraphSerieDirective");goog.module.declareLegacyNamespace();exports.ClientLoadGraphSerieDirective=function(){return{scope:{clientId:"=",metric:"@",rate:"@",label:"@"},restrict:"E",require:"^grrTimeseriesGraph",link:function(scope,element,attrs,grrTimeseriesGrpahCtrl){scope.$watch("::clientId",function(){if(angular.isUndefined(scope.clientId))return;var options={};if(scope.rate)options["rate"]=scope.rate;var path="clients/"+
scope.clientId+"/load-stats/"+scope.metric;grrTimeseriesGrpahCtrl.addSerieDescriptor({label:scope.label,requestPath:path,requestOptions:options})})}}};exports.ClientLoadGraphSerieDirective.directive_name="grrClientLoadGraphSerie";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.clientLoadViewDirective");goog.module.declareLegacyNamespace();var ClientLoadViewController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.cliendId;this.startTime;this.endTime;this.duration=60;this.grrRoutingService_.uiOnParamsChanged(this.scope_,"clientId",this.onClientIdChange_.bind(this));this.scope_.$watch("controller.duration",this.onDurationChange.bind(this))};ClientLoadViewController.prototype.onClientIdChange_=
function(clientId){this.clientId=clientId};ClientLoadViewController.prototype.onDurationChange=function(newValue){this.endTime=Math.round((new Date).getTime()*1E3);this.startTime=this.endTime-this.duration*60*1E6};exports.ClientLoadViewDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/client/client-load-view.html",controller:ClientLoadViewController,controllerAs:"controller"}};exports.ClientLoadViewDirective.directive_name="grrClientLoadView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.clientStatusIconsDirective");goog.module.declareLegacyNamespace();var ClientStatusIconsController=function($scope,grrTimeService){this.scope_=$scope;this.grrTimeService_=grrTimeService;this.iconName;this.crashTime;this.diskWarnings=[];this.lastPing;this.scope_.$watch("::client",this.onClientChange_.bind(this))};ClientStatusIconsController.prototype.onClientChange_=function(newValue){this.iconName=this.showCrashIcon=null;this.diskWarnings=
[];if(angular.isObject(newValue)){this.lastPing=this.scope_.$eval("client.value.last_seen_at.value");if(angular.isUndefined(this.lastPing))this.lastPing=0;var currentTimeMs=this.grrTimeService_.getCurrentTimeMs();var timeLastSeenSecs=(currentTimeMs-this.lastPing/1E3)/1E3;if(timeLastSeenSecs<60*15)this.iconName="online";else if(timeLastSeenSecs<60*60*24)this.iconName="online-1d";else this.iconName="offline";var crashTime=this.scope_.$eval("client.value.last_crash_at.value");if(angular.isDefined(crashTime)&&
currentTimeMs/1E3-crashTime/1E6<60*60*24)this.crashTime=crashTime;angular.forEach(newValue["value"]["volumes"]||[],function(volume){if(volume["value"]["windowsvolume"]&&volume["value"]["windowsvolume"]["value"]["drive_type"]["value"]=="DRIVE_CDROM")return;if(angular.isDefined(volume["value"]["actual_available_allocation_units"])&&angular.isDefined(volume["value"]["total_allocation_units"])){var percent=volume["value"]["actual_available_allocation_units"]["value"]/volume["value"]["total_allocation_units"]["value"]*
100;if(percent<=5){var volumeName="";if(volume["value"]["name"])volumeName=volume["value"]["name"]["value"];this.diskWarnings.push([volumeName,percent])}}}.bind(this))}};exports.ClientStatusIconsDirective=function(){return{scope:{client:"="},restrict:"E",templateUrl:"/static/angular-components/client/"+"client-status-icons.html",controller:ClientStatusIconsController,controllerAs:"controller"}};exports.ClientStatusIconsDirective.directive_name="grrClientStatusIcons";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.clientUsernamesDirective");goog.module.declareLegacyNamespace();var ClientUsernamesController=function($scope){this.scope_=$scope;this.scope_.usernames;this.scope_.$watch("::value",this.onValueChange_.bind(this))};ClientUsernamesController.prototype.onValueChange_=function(){if(angular.isDefined(this.scope_.value)){var users=this.scope_.value.value.split(" ");var array=[];angular.forEach(users,function(value){array.push({"type":"RDFString",
"value":value})});this.scope_.usernames=array}};exports.ClientUsernamesDirective=function(){return{scope:{value:"="},restrict:"E",template:'<grr-semantic-value value="::usernames" />',controller:ClientUsernamesController,controllerAs:"controller"}};exports.ClientUsernamesDirective.directive_name="grrClientUsernames";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.clientsListDirective");goog.module.declareLegacyNamespace();var ClientsListController=function($scope,grrClientDialogService,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.grrClientDialogService_=grrClientDialogService;this.triggerUpdate;this.clients={};this.selectedClients={};this.allClientsSelected=false;this.numSelectedClients=0;this.query;this.grrRoutingService_.uiOnParamsChanged(this.scope_,
"q",this.onQueryChange_.bind(this))};ClientsListController.prototype.onQueryChange_=function(query){this.query=query;if(this.triggerUpdate)this.triggerUpdate()};ClientsListController.prototype.onClientClick=function(client){var clientId=client["value"]["client_id"]["value"];this.grrRoutingService_.go("client",{clientId:clientId})};ClientsListController.prototype.updateNumSelectedClients=function(){var count=0;for(var key in this.selectedClients)if(this.selectedClients[key])++count;this.numSelectedClients=
count};ClientsListController.prototype.onClientsFetched=function(items){angular.forEach(items,function(item){var clientId=item["value"]["client_id"]["value"];this.clients[clientId]=item;this.selectedClients[clientId]=false;item["_mac_addresses"]=[];angular.forEach(item["value"]["interfaces"],function(iface){if(angular.isDefined(iface["value"]["mac_address"]))item["_mac_addresses"].push(iface["value"]["mac_address"])}.bind(this));item["_usernames"]=[];angular.forEach(item["value"]["users"],function(user){item["_usernames"].push(user["value"]["username"])}.bind(this));
item["tableKey"]=clientId}.bind(this));return items};ClientsListController.prototype.selectAll=function(){for(var key in this.selectedClients)this.selectedClients[key]=this.allClientsSelected;this.updateNumSelectedClients()};ClientsListController.prototype.showLabelsDialog=function(action){var clients=[];for(var clientId in this.selectedClients)if(this.selectedClients[clientId])clients.push(this.clients[clientId]);var result;if(action=="add")result=this.grrClientDialogService_.openAddClientLabels(clients);
else if(action=="remove")result=this.grrClientDialogService_.openRemoveClientLabels(clients);else throw Error("Unexpected action: "+action);result.then(function resolve(){this.triggerUpdate()}.bind(this),function dismiss(){}.bind(this))};ClientsListController.prototype.clientsQueryUrl="/clients";exports.ClientsListDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/client/clients-list.html",controller:ClientsListController,controllerAs:"controller"}};exports.ClientsListDirective.directive_name=
"grrClientsList";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.debugRequestsViewDirective");goog.module.declareLegacyNamespace();var DebugRequestsViewController=function($scope,grrApiService,grrRoutingService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrRoutingService_=grrRoutingService;this.cliendId;this.actionRequests;this.grrRoutingService_.uiOnParamsChanged(this.scope_,"clientId",this.onClientIdChange_.bind(this))};DebugRequestsViewController.prototype.onClientIdChange_=
function(clientId){this.clientId=clientId;this.actionRequests=undefined;if(angular.isDefined(this.clientId)){var url="clients/"+this.clientId+"/action-requests";var fetchResponses=1;if(angular.isDefined(this.scope_["fetchResponses"]))fetchResponses=this.scope_["fetchResponses"];this.grrApiService_.get(url,{"fetch_responses":fetchResponses}).then(function(response){this.actionRequests=response["data"]["items"]||[]}.bind(this))}};exports.DebugRequestsViewDirective=function(){return{scope:{fetchResponses:"="},
restrict:"E",templateUrl:"/static/angular-components/client/debug-requests-view.html",controller:DebugRequestsViewController,controllerAs:"controller"}};exports.DebugRequestsViewDirective.directive_name="grrDebugRequestsView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.hostHistoryDialogDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var165=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var165.ApiService;var stripTypeInfo=$jscomp$destructuring$var165.stripTypeInfo;var $jscomp$destructuring$var166=goog.require("grrUi.core.timeService");var TimeService=$jscomp$destructuring$var166.TimeService;var HostHistoryDialogController=function($scope,
grrApiService,grrTimeService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrTimeService_=grrTimeService;this.items;this.endTime;this.startTime;this.scope_.$watchGroup(["clientId","fieldPath"],this.onParamsChange_.bind(this))};HostHistoryDialogController.prototype.onParamsChange_=function(){var clientId=this.scope_["clientId"];var fieldPath=this.scope_["fieldPath"];if(angular.isDefined(clientId)&&angular.isDefined(fieldPath)){var endTime=this.grrTimeService_.getCurrentTimeMs()*1E3;var startTime=
endTime-1E6*60*60*24*365;this.startTime={type:"RDFDatetime",value:startTime};this.endTime={type:"RDFDatetime",value:endTime};this.grrApiService_.get("/clients/"+clientId+"/versions",{mode:"DIFF",start:startTime,end:endTime}).then(function(response){this.buildItems_(response["data"]["items"])}.bind(this))}};HostHistoryDialogController.prototype.getFieldFromVersion_=function(version,fieldPath){var components=fieldPath.split(".");var curValue=version;for(var i=0;i<components.length;++i){var component=
components[i];curValue=curValue["value"][component];if(angular.isUndefined(curValue))break}return curValue};HostHistoryDialogController.prototype.buildItems_=function(versions){var fieldPath=this.scope_["fieldPath"];var prevCompareValue;this.items=[];angular.forEach(versions,function(version){var versionValue=this.getFieldFromVersion_(version,fieldPath);if(angular.isUndefined(versionValue))return;var compareValue=stripTypeInfo(versionValue);if(angular.equals(prevCompareValue,compareValue))return;
this.items.push([version["value"]["age"],versionValue]);prevCompareValue=compareValue}.bind(this));this.items.reverse()};exports.HostHistoryDialogDirective=function(){return{scope:{clientId:"=",fieldPath:"=",close:"&"},restrict:"E",templateUrl:"/static/angular-components/client/host-history-dialog.html",controller:HostHistoryDialogController,controllerAs:"controller"}};exports.HostHistoryDialogDirective.directive_name="grrHostHistoryDialog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.hostInfoDirective");goog.module.declareLegacyNamespace();var OPERATION_POLL_INTERVAL_MS=1E3;var HostInfoController=function($scope,$interval,grrApiService,grrRoutingService,grrAclDialogService,grrDialogService){this.scope_=$scope;this.interval_=$interval;this.grrApiService_=grrApiService;this.grrRoutingService_=grrRoutingService;this.grrAclDialogService_=grrAclDialogService;this.grrDialogService_=grrDialogService;this.clientVersionUrl;
this.clientId;this.clientVersion;this.client;this.hasClientAccess;this.fetchDetailsRequestId=0;this.interrogateOperationId;this.interrogateOperationInterval_;this.grrRoutingService_.uiOnParamsChanged(this.scope_,"clientId",this.onClientIdChange_.bind(this));this.scope_.$watch("clientId",this.onClientIdChange_.bind(this));this.scope_.$watch("controller.clientVersion",this.onClientVersionChange_.bind(this));this.scope_.$on("$destroy",this.stopMonitorInterrogateOperation_.bind(this))};HostInfoController.prototype.onClientIdChange_=
function(clientId){if(angular.isDefined(clientId)){this.clientId=clientId;this.clientVersionUrl="/clients/"+clientId+"/version-times";this.fetchClientDetails_()}};HostInfoController.prototype.onClientVersionChange_=function(newValue){if(angular.isUndefined(newValue))return;if(angular.isUndefined(this.client)||this.client["value"]["age"]["value"]!==newValue)this.fetchClientDetails_()};HostInfoController.prototype.fetchClientDetails_=function(){var url="/clients/"+this.clientId;var params={};if(this.clientVersion)params["timestamp"]=
this.clientVersion;this.fetchDetailsRequestId+=1;var requestId=this.fetchDetailsRequestId;this.grrApiService_.get(url,params).then(function success(response){if(this.fetchDetailsRequestId!=requestId)return;this.client=response.data;this.clientVersion=response.data["value"]["age"]["value"]}.bind(this))};HostInfoController.prototype.requestApproval=function(){this.grrAclDialogService_.openRequestClientApprovalDialog(this.clientId)};HostInfoController.prototype.interrogate=function(){var url="/clients/"+
this.clientId+"/actions/interrogate";this.grrApiService_.post(url).then(function success(response){this.interrogateOperationId=response["data"]["operation_id"];this.monitorInterrogateOperation_()}.bind(this),function failure(response){this.stopMonitorInterrogateOperation_()}.bind(this))};HostInfoController.prototype.monitorInterrogateOperation_=function(){this.interrogateOperationInterval_=this.interval_(this.pollInterrogateOperationState_.bind(this),OPERATION_POLL_INTERVAL_MS)};HostInfoController.prototype.pollInterrogateOperationState_=
function(){var url="clients/"+this.clientId+"/actions/interrogate/"+this.interrogateOperationId;this.grrApiService_.get(url).then(function success(response){if(response["data"]["state"]==="FINISHED"){this.stopMonitorInterrogateOperation_();this.clientVersion=null;this.fetchClientDetails_()}}.bind(this),function failure(response){this.stopMonitorInterrogateOperation_()}.bind(this))};HostInfoController.prototype.stopMonitorInterrogateOperation_=function(){this.interrogateOperationId=null;this.interval_.cancel(this.interrogateOperationInterval_)};
HostInfoController.prototype.showHistoryDialog=function(fieldPath){this.grrDialogService_.openDirectiveDialog("grrHostHistoryDialog",{clientId:this.clientId,fieldPath:fieldPath},{windowClass:"high-modal"})};exports.HostInfoDirective=function(){return{scope:{"clientId":"=","readOnly":"="},restrict:"E",templateUrl:"/static/angular-components/client/host-info.html",controller:HostInfoController,controllerAs:"controller"}};exports.HostInfoDirective.directive_name="grrHostInfo";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.auditChartDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var167=goog.require("grrUi.core.apiService");var stripTypeInfo=$jscomp$destructuring$var167.stripTypeInfo;var $jscomp$destructuring$var168=goog.require("grrUi.core.utils");var upperCaseToTitleCase=$jscomp$destructuring$var168.upperCaseToTitleCase;var AuditChartController=function($scope,$element){this.scope_=$scope;this.element_=$element;this.auditUsedFields;
this.auditTitleCaseUsedFields;this.typedAuditRows;this.errorMsg="";this.scope_.$watch("typedData",function(typedData){if(angular.isDefined(typedData)&&angular.isDefined(typedData["value"]))this.initAuditChart_(typedData["value"]["audit_chart"])}.bind(this))};AuditChartController.prototype.initAuditChart_=function(typedAuditChartData){var auditChartData=stripTypeInfo(typedAuditChartData);this.auditUsedFields=undefined;this.auditTitleCaseUsedFields=undefined;this.typedAuditRows=undefined;if(angular.isUndefined(auditChartData["rows"])||
auditChartData["rows"].length==0||angular.isUndefined(auditChartData["used_fields"])||auditChartData["used_fields"].length==0){this.errorMsg="No data to display.";return}this.auditUsedFields=auditChartData["used_fields"];this.auditTitleCaseUsedFields=auditChartData["used_fields"].map(upperCaseToTitleCase);this.typedAuditRows=typedAuditChartData["value"]["rows"]};exports.AuditChartDirective=function(){return{scope:{typedData:"="},restrict:"E",templateUrl:"/static/angular-components/stats/audit-chart.html",
controller:AuditChartController,controllerAs:"controller"}};exports.AuditChartDirective.directive_name="grrAuditChart";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.chartDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var169=goog.require("grrUi.core.apiService");var stripTypeInfo=$jscomp$destructuring$var169.stripTypeInfo;var DEFAULT_HOVER_TEXT="";var ChartController=function($scope,$element){this.scope_=$scope;this.element_=$element;this.chartElement_=this.element_.find(".chart");this.hoverElement_=this.element_.find(".hover");this.hoverColor="#000";this.hoverText=
DEFAULT_HOVER_TEXT;this.errorMsg="";this.scope_.$watch("typedData",function(){var typedData=this.scope_["typedData"];if(angular.isDefined(typedData)){var data=stripTypeInfo(typedData);this.initChart_(data,typedData)}}.bind(this))};ChartController.prototype.initChart_=function(data,typedData){this.hoverText=DEFAULT_HOVER_TEXT;this.errorMsg="";switch(data["representation_type"]){case "STACK_CHART":this.initStackChart_(data["stack_chart"]);break;case "PIE_CHART":this.initPieChart_(data["pie_chart"]);
break;case "LINE_CHART":this.initLineChart_(data["line_chart"]);break;case "AUDIT_CHART":break;default:this.errorMsg="Unexpected representation type."}};ChartController.prototype.initStackChart_=function(stackChartData){if(angular.isUndefined(stackChartData["data"])||stackChartData["data"].length==0){this.errorMsg="No data to display.";return}var specs=stackChartData["data"].map(function(series){return{label:series["label"],data:series["points"].map(function(point){return[point["x"],point["y"]]}.bind(this))}}.bind(this));
var extractTicks=function(protoTick){return[protoTick["x"],protoTick["label"]]}.bind(this);var x_ticks=undefined;var y_ticks=undefined;if(angular.isDefined(stackChartData["x_ticks"]))x_ticks=stackChartData["x_ticks"].map(extractTicks);if(angular.isDefined(stackChartData["y_ticks"]))y_ticks=stackChartData["y_ticks"].map(extractTicks);var barWidth=stackChartData["bar_width"]||.6;this.chartElement_.resize(function(){this.chartElement_.html("");$.plot($(this.chartElement_),specs,{series:{stack:true,bars:{show:true,
barWidth:barWidth},label:{show:true,radius:.5},background:{opacity:.8}},grid:{hoverable:true,clickable:true},xaxis:{min:0,ticks:x_ticks},yaxis:{min:0,ticks:y_ticks}})}.bind(this));this.chartElement_.bind("plothover",function(event,pos,obj){if(obj){this.hoverColor=obj.series.color;this.hoverText=obj.series.label+": "+(obj.datapoint[1]-obj.datapoint[2])}}.bind(this));this.chartElement_.resize()};ChartController.prototype.initPieChart_=function(pieChartData){if(angular.isUndefined(pieChartData["data"])||
pieChartData["data"].length==0){this.errorMsg="No data to display.";return}var specs=pieChartData["data"].map(function(point){return{label:point["label"],data:point["x"]}}.bind(this));this.chartElement_.resize(function(){this.chartElement_.html("");$.plot($(this.chartElement_),specs,{series:{pie:{show:true,label:{show:true,radius:.5,formatter:function(label,series){return'<div class="pie-label">'+label+"<br/>"+Math.round(series["percent"])+"%"+"</div>"},background:{opacity:.8}}}},grid:{hoverable:true,
clickable:true}})}.bind(this));this.chartElement_.bind("plothover",function(event,pos,obj){if(obj){var percent=parseFloat(obj.series.percent).toFixed(2);this.hoverColor=obj.series.color;this.hoverText=obj.series.label+" "+obj.series.data[0][1]+" ("+percent+"%)"}}.bind(this));this.chartElement_.resize()};ChartController.prototype.initLineChart_=function(lineChartData){if(angular.isUndefined(lineChartData["data"])||lineChartData["data"].length==0){this.errorMsg="No data to display.";return}var specs=
lineChartData["data"].map(function(series){return{label:series["label"],data:series["points"].map(function(point){return[point["x"],point["y"]]}.bind(this))}}.bind(this));this.chartElement_.resize(function(){this.chartElement_.html("");$.plot($(this.chartElement_),specs,{xaxis:{mode:"time",timeformat:"%y/%m/%d"},lines:{show:true},points:{show:true},zoom:{interactive:true},pan:{interactive:true},grid:{clickable:true,autohighlight:true}})}.bind(this));this.chartElement_.bind("plotclick",function(event,
pos,obj){if(obj){var date=new Date(obj.datapoint[0]);this.hoverColor=obj.series.color;this.hoverText="On "+date.toDateString()+", there were "+obj.datapoint[1]+" "+obj.series.label+" systems."}}.bind(this));this.chartElement_.resize()};exports.ChartDirective=function(){return{scope:{typedData:"="},restrict:"E",templateUrl:"/static/angular-components/stats/chart.html",controller:ChartController,controllerAs:"controller"}};exports.ChartDirective.directive_name="grrChart";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.reportDescsService");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var170=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var170.ApiService;var stripTypeInfo=$jscomp$destructuring$var170.stripTypeInfo;exports.ReportDescsService=function($q,grrApiService){this.q_=$q;this.grrApiService_=grrApiService;this.reports_;this.descsByName_};var ReportDescsService=exports.ReportDescsService;ReportDescsService.service_name=
"grrReportDescsService";ReportDescsService.prototype.getDescs=function(){var deferred=this.q_.defer();if(angular.isDefined(this.reports_))deferred.resolve(this.reports_);else this.grrApiService_.get("stats/reports").then(function(response){this.reports_=stripTypeInfo(response["data"]["reports"]);deferred.resolve(this.reports_)}.bind(this));return deferred.promise};ReportDescsService.prototype.getDescByName=function(name){var deferred=this.q_.defer();if(angular.isDefined(this.descsByName_))deferred.resolve(this.descsByName_[name]);
else this.getDescs().then(function(reports){this.descsByName_={};for(var i=0;i<reports.length;i++){var desc=reports[i]["desc"];this.descsByName_[desc["name"]]=desc}deferred.resolve(this.descsByName_[name])}.bind(this));return deferred.promise};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.reportDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var171=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var171.ApiService;var stripTypeInfo=$jscomp$destructuring$var171.stripTypeInfo;var $jscomp$destructuring$var172=goog.require("grrUi.core.reflectionService");var ReflectionService=$jscomp$destructuring$var172.ReflectionService;var $jscomp$destructuring$var173=goog.require("grrUi.stats.reportDescsService");
var ReportDescsService=$jscomp$destructuring$var173.ReportDescsService;var $jscomp$destructuring$var174=goog.require("grrUi.core.timeService");var TimeService=$jscomp$destructuring$var174.TimeService;var $jscomp$destructuring$var175=goog.require("grrUi.core.utils");var upperCaseToTitleCase=$jscomp$destructuring$var175.upperCaseToTitleCase;var WEEK_SECONDS=7*24*60*60;var DEFAULT_START_TIME_SECS=Math.ceil(moment().valueOf()/1E3-WEEK_SECONDS);var DEFAULT_DURATION_SECS=WEEK_SECONDS;var DEFAULT_CLIENT_LABEL=
"";var ReportController=function($scope,grrApiService,grrReflectionService,grrTimeService,grrReportDescsService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrReflectionService_=grrReflectionService;this.grrTimeService_=grrTimeService;this.grrReportDescsService_=grrReportDescsService;this.state="INITIAL";this.titleCasedType;this.typedReportData;this.reportData;this.reportDesc;this.startTime=null;this.duration=null;this.clientLabel=null;this.latestFetchTime_=0;this.scope_.$watch("name",
function(name){this.grrReportDescsService_.getDescByName(name).then(function(desc){if(angular.isUndefined(desc))return;this.reportDesc=desc;this.titleCasedType=upperCaseToTitleCase(this.reportDesc["type"]);this.onParamsChange_()}.bind(this))}.bind(this));this.scope_.$watchGroup(["startTime","duration","clientLabel"],this.onParamsChange_.bind(this))};ReportController.prototype.onParamsChange_=function(){var startTime=this.scope_["startTime"];if(angular.isDefined(startTime))this.startTime=startTime;
var duration=this.scope_["duration"];if(angular.isDefined(duration))this.duration=duration;var clientLabel=this.scope_["clientLabel"];if(angular.isDefined(clientLabel))this.clientLabel=clientLabel;this.fetchData_()};ReportController.prototype.refreshReport=function(){this.scope_["startTime"]=this.startTime;this.scope_["duration"]=this.duration;this.scope_["clientLabel"]=this.clientLabel};ReportController.prototype.fetchData_=function(){if(angular.isUndefined(this.reportDesc))return;var name=this.reportDesc["name"];
if(!name)return;this.state="LOADING";var startTime=DEFAULT_START_TIME_SECS;if(this.startTime!==null)startTime=this.startTime;var duration=DEFAULT_DURATION_SECS;if(this.duration!==null)duration=this.duration;var clientLabel=DEFAULT_CLIENT_LABEL;if(this.clientLabel!==null)clientLabel=this.clientLabel;var apiUrl="stats/reports/"+name;var apiParams={start_time:startTime*1E6,duration:duration,client_label:clientLabel};if(this.reportDesc["requires_time_range"]){this.startTime=startTime;this.duration=duration}if(this.reportDesc["type"]===
"CLIENT")this.clientLabel=clientLabel;var fetchTime=this.grrTimeService_.getCurrentTimeMs();this.latestFetchTime_=fetchTime;this.grrApiService_.get(apiUrl,apiParams).then(function(response){if(fetchTime!==this.latestFetchTime_)return;this.typedReportData=response["data"]["data"];this.reportData=stripTypeInfo(this.typedReportData);this.state="LOADED"}.bind(this))};exports.ReportDirective=function(){return{scope:{name:"=?",startTime:"=?",duration:"=?",clientLabel:"=?"},restrict:"E",templateUrl:"/static/angular-components/stats/report.html",
controller:ReportController,controllerAs:"controller"}};exports.ReportDirective.directive_name="grrReport";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.reportListingDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var176=goog.require("grrUi.core.utils");var upperCaseToTitleCase=$jscomp$destructuring$var176.upperCaseToTitleCase;exports.parseStatsReportsApiResponse=function(reports){var ret=[];var reportsByType={};angular.forEach(reports,function(report){var desc=report["desc"];var reportType=desc["type"];var typeReportListing;if(angular.isUndefined(reportsByType[reportType])){typeReportListing=
[];reportsByType[reportType]=typeReportListing;ret.push({text:upperCaseToTitleCase(reportType),children:typeReportListing,state:{opened:true,disabled:true}})}else typeReportListing=reportsByType[reportType];var leaf={id:desc["name"],text:desc["title"],desc:desc};typeReportListing.push(leaf)});return ret};var parseStatsReportsApiResponse=exports.parseStatsReportsApiResponse;var ReportListingController=function($scope,$element,grrReportDescsService){this.scope_=$scope;this.element_=$element;this.grrReportDescsService_=
grrReportDescsService;this.treeElement_=this.element_.find(".report-listing-tree");this.tree_;this.selectionName_;this.reportListing_;this.grrReportDescsService_.getDescs().then(function(reports){this.reportListing_=parseStatsReportsApiResponse(reports);this.initTree_()}.bind(this));this.scope_.$watch("selectionName",function(selectionName){if(angular.isUndefined(selectionName))return;this.selectionName_=selectionName}.bind(this));this.scope_.$watch("controller.selectionName_",function(){if(angular.isUndefined(this.selectionName_))return;
this.scope_["selectionName"]=this.selectionName_;this.updateTreeSelection_()}.bind(this))};ReportListingController.prototype.initTree_=function(){this.treeElement_.jstree({"core":{"data":this.reportListing_}});this.tree_=this.treeElement_.jstree(true);this.treeElement_.on("loaded.jstree",function(event,data){this.updateTreeSelection_()}.bind(this));this.treeElement_.on("select_node.jstree",function(event,data){var desc=data["node"]["original"]["desc"];this.selectionName_=desc["name"]}.bind(this))};
ReportListingController.prototype.updateTreeSelection_=function(){if(angular.isUndefined(this.tree_))return;this.tree_["deselect_all"]();this.tree_["select_node"](this.selectionName_)};exports.ReportListingDirective=function(){return{restrict:"E",scope:{selectionName:"=?"},templateUrl:"/static/angular-components/stats/report-listing.html",controller:ReportListingController,controllerAs:"controller"}};exports.ReportListingDirective.directive_name="grrReportListing";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.serverLoadDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var177=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var177.ApiService;exports.ServerLoadIndicatorService=function($q,grrApiService){this.q_=$q;this.grrApiService_=grrApiService};var ServerLoadIndicatorService=exports.ServerLoadIndicatorService;ServerLoadIndicatorService.service_name="grrServerLoadIndicatorService";
ServerLoadIndicatorService.prototype.calculateMean_=function(timeseries){if(timeseries.length==0)return 0;var result=0;for(var i=0;i<timeseries.length;++i){var dataPoint=timeseries[i];if(dataPoint.length!=2)throw new Error("Invalid data: timeseries data point is not an array "+"with 2 numbers.");result+=dataPoint[1]}return result/timeseries.length};ServerLoadIndicatorService.prototype.fetchRatioIndicator=function(component,numeratorMetric,denominatorMetric,warningRatio,dangerRatio){var endTime=Math.round((new Date).getTime()*
1E3);var startTime=endTime-10*60*1E6;var options={start:startTime,end:endTime,aggregation:"mean"};var metricsCache={numerator:undefined,denominator:undefined};var deferred=this.q_.defer();var responseHandler=function(response){if(response.data["metric_name"]==numeratorMetric)metricsCache.numerator=this.calculateMean_(response.data["data_points"]);else if(response.data["metric_name"]==denominatorMetric)metricsCache.denominator=this.calculateMean_(response.data["data_points"]);else throw new Error("Unexpected metric name: "+
response.data["metric_name"]);if(angular.isDefined(metricsCache.numerator)&&angular.isDefined(metricsCache.denominator))if(metricsCache.denominator==0)deferred.resolve("unknown");else{var ratio=metricsCache.numerator/metricsCache.denominator;if(ratio>dangerRatio)deferred.resolve("danger");else if(ratio>warningRatio)deferred.resolve("warning");else deferred.resolve("normal")}};this.grrApiService_.get("stats/store/"+component.toUpperCase()+"/metrics/"+numeratorMetric,options).then(responseHandler.bind(this));
this.grrApiService_.get("stats/store/"+component.toUpperCase()+"/metrics/"+denominatorMetric,options).then(responseHandler.bind(this));return deferred.promise};var ServerLoadController=function($scope,grrServerLoadIndicatorService){this.scope_=$scope;this.grrServerLoadIndicatorService_=grrServerLoadIndicatorService;this.startTime;this.endTime;this.indicators={};this.duration=1;this.scope_.$watch("controller.duration",this.onDurationChange.bind(this))};ServerLoadController.prototype.onDurationChange=
function(newValue){this.endTime=Math.round((new Date).getTime()*1E3);this.startTime=this.endTime-this.duration*60*60*1E6;this.fetchIndicators_()};ServerLoadController.prototype.fetchIndicators_=function(){this.grrServerLoadIndicatorService_.fetchRatioIndicator("frontend","frontend_active_count","frontend_max_active_count",.35,.75).then(function(result){this.indicators["frontendLoad"]=result}.bind(this));this.grrServerLoadIndicatorService_.fetchRatioIndicator("worker","grr_threadpool_outstanding_tasks",
"grr_threadpool_threads",4,10).then(function(result){this.indicators["workerLoad"]=result}.bind(this))};exports.ServerLoadDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/stats/server-load.html",controller:ServerLoadController,controllerAs:"controller"}};exports.ServerLoadDirective.directive_name="grrServerLoad";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.serverLoadGraphSerieDirective");goog.module.declareLegacyNamespace();exports.ServerLoadGraphSerieDirective=function(){return{scope:{component:"@",metric:"@",rate:"@",aggregation:"@",distributionHandling:"@",label:"@"},restrict:"E",require:"^grrTimeseriesGraph",link:function(scope,element,attrs,grrTimeseriesGrpahCtrl){var options={};if(scope.distributionHandling)options["distribution_handling_mode"]=scope.distributionHandling;
if(scope.aggregation)options["aggregation_mode"]=scope.aggregation;if(scope.rate)options["rate"]=scope.rate;var path="stats/store/"+scope.component.toUpperCase()+"/metrics/"+scope.metric;grrTimeseriesGrpahCtrl.addSerieDescriptor({label:scope.label,requestPath:path,requestOptions:options})}}};exports.ServerLoadGraphSerieDirective.directive_name="grrServerLoadGraphSerie";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.serverLoadIndicatorDirective");goog.module.declareLegacyNamespace();var ServerLoadIndicatorController=function($scope){this.scope_=$scope;this.imageFile;this.files_={normal:"online.png",warning:"online-1d.png",danger:"offline.png",unknown:"unknown-indicator.png"};this.scope_.$watch("status",function(newValue){if(angular.isDefined(newValue)&&newValue!=="normal"&&newValue!=="warning"&&newValue!=="danger"&&newValue!=="unknown")throw new Error('status can be undefined or "normal", '+
'"danger", "warning" or "unknown".');if(angular.isUndefined(newValue))this.imageFile=this.files_["unknown"];else this.imageFile=this.files_[newValue]}.bind(this))};exports.ServerLoadIndicatorDirective=function(){return{scope:{status:"="},restrict:"E",templateUrl:"/static/angular-components/stats/"+"server-load-indicator.html",controller:ServerLoadIndicatorController,controllerAs:"controller"}};exports.ServerLoadIndicatorDirective.directive_name="grrServerLoadIndicator";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.statsViewDirective");goog.module.declareLegacyNamespace();var StatsViewController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.selectionName;this.startTime;this.duration;this.clientLabel;this.oldSelectionName_;this.grrRoutingService_.uiOnParamsChanged(this.scope_,["name","start_time","duration","client_label"],this.onUrlParamsChange_.bind(this));this.scope_.$watchGroup(["controller.selectionName",
"controller.startTime","controller.duration","controller.clientLabel"],this.onControllerParamsChange_.bind(this))};StatsViewController.prototype.onUrlParamsChange_=function(unused_values,params){var selectionName=params["name"];if(angular.isDefined(selectionName))this.selectionName=selectionName;var startTimeStr=params["start_time"];if(angular.isDefined(startTimeStr))this.startTime=parseInt(startTimeStr,10);var durationStr=params["duration"];if(angular.isDefined(durationStr))this.duration=parseInt(durationStr,
10);var clientLabel=params["client_label"];if(angular.isDefined(clientLabel))this.clientLabel=clientLabel};StatsViewController.prototype.onControllerParamsChange_=function(){if(angular.isUndefined(this.selectionName))return;if(angular.isDefined(this.oldSelectionName_)&&this.oldSelectionName_!==this.selectionName){this.startTime=null;this.duration=null;this.clientLabel=null}this.oldSelectionName_=this.selectionName;var urlParams={name:this.selectionName};if(angular.isDefined(this.startTime))urlParams["start_time"]=
this.startTime;if(angular.isDefined(this.duration))urlParams["duration"]=this.duration;if(angular.isDefined(this.clientLabel))urlParams["client_label"]=this.clientLabel;this.grrRoutingService_.go("stats",urlParams)};exports.StatsViewDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/stats/stats-view.html",controller:StatsViewController,controllerAs:"controller"}};exports.StatsViewDirective.directive_name="grrStatsView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.timeseriesGraphDirective");goog.module.declareLegacyNamespace();var TimeserieDescriptor;var TimeseriesGraphController=function($scope,$element,$interval,grrApiService){this.scope_=$scope;this.element_=$element;this.interval_=$interval;this.grrApiService_=grrApiService;this.timeRange=[NaN,NaN];this.seriesDescriptors=[];this.fetchedSeries={};this.inProgress=false;this.scope_.$watch("startTime",this.onStartTimeChange_.bind(this));
this.scope_.$watch("endTime",this.onEndTimeChange_.bind(this));this.scope_.$watch("controller.timeRange",this.onConfigurationChange_.bind(this),true);this.scope_.$watch("controller.seriesDescriptors",this.onConfigurationChange_.bind(this),true)};TimeseriesGraphController.prototype.onStartTimeChange_=function(newValue){this.timeRange[0]=newValue};TimeseriesGraphController.prototype.onEndTimeChange_=function(newValue){this.timeRange[1]=newValue};TimeseriesGraphController.prototype.computeDelta_=function(points){if(points.length<
2)return;var prevPointValue=points.shift()[1];for(var i=0;i<points.length;++i){var pointValue=points[i][1];points[i][1]=points[i][1]-prevPointValue;prevPointValue=pointValue}};TimeseriesGraphController.prototype.onConfigurationChange_=function(){this.inProgress=true;this.fetchedSeries={};angular.forEach(this.seriesDescriptors,function(descriptor){var options={start:this.timeRange[0],end:this.timeRange[1]};angular.extend(options,descriptor.requestOptions||{});var prevTimeRange=this.timeRange.slice();
this.grrApiService_.get(descriptor.requestPath,options).then(function(response){if(angular.equals(prevTimeRange,this.timeRange)){var serie=response["data"];serie["data_points"]=serie["data_points"]||[];if(this.scope_["computeDelta"])this.computeDelta_(serie["data_points"]);this.fetchedSeries[descriptor.label]=serie;this.buildGraphIfNeeded_()}}.bind(this))}.bind(this))};TimeseriesGraphController.prototype.addSerieDescriptor=function(descriptor){this.seriesDescriptors.push(descriptor)};TimeseriesGraphController.prototype.buildGraphIfNeeded_=
function(){if(Object.keys(this.fetchedSeries).length==this.seriesDescriptors.length){this.inProgress=false;var data=[];for(var label in this.fetchedSeries){var item=this.fetchedSeries[label];data.push({label:label,data:item["data_points"]})}var config={xaxis:{mode:"time",axisLabel:"Time"},yaxis:{axisLabel:label}};var intervalPromise=this.interval_(function(){var graphElement=$(this.element_).find(".timeseries-graph");if(graphElement){$.plot(graphElement,data,config);this.interval_.cancel(intervalPromise)}}.bind(this),
500,10)}};exports.TimeseriesGraphDirective=function(){return{scope:{title:"@",computeDelta:"@",startTime:"=",endTime:"="},restrict:"E",templateUrl:"/static/angular-components/stats/timeseries-graph.html",transclude:true,controller:TimeseriesGraphController,controllerAs:"controller"}};exports.TimeseriesGraphDirective.directive_name="grrTimeseriesGraph";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.stats.stats");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var178=goog.require("grrUi.stats.auditChartDirective");var AuditChartDirective=$jscomp$destructuring$var178.AuditChartDirective;var $jscomp$destructuring$var179=goog.require("grrUi.stats.chartDirective");var ChartDirective=$jscomp$destructuring$var179.ChartDirective;var $jscomp$destructuring$var180=goog.require("grrUi.stats.reportDescsService");var ReportDescsService=
$jscomp$destructuring$var180.ReportDescsService;var $jscomp$destructuring$var181=goog.require("grrUi.stats.reportDirective");var ReportDirective=$jscomp$destructuring$var181.ReportDirective;var $jscomp$destructuring$var182=goog.require("grrUi.stats.reportListingDirective");var ReportListingDirective=$jscomp$destructuring$var182.ReportListingDirective;var $jscomp$destructuring$var183=goog.require("grrUi.stats.serverLoadDirective");var ServerLoadDirective=$jscomp$destructuring$var183.ServerLoadDirective;
var ServerLoadIndicatorService=$jscomp$destructuring$var183.ServerLoadIndicatorService;var $jscomp$destructuring$var184=goog.require("grrUi.stats.serverLoadGraphSerieDirective");var ServerLoadGraphSerieDirective=$jscomp$destructuring$var184.ServerLoadGraphSerieDirective;var $jscomp$destructuring$var185=goog.require("grrUi.stats.serverLoadIndicatorDirective");var ServerLoadIndicatorDirective=$jscomp$destructuring$var185.ServerLoadIndicatorDirective;var $jscomp$destructuring$var186=goog.require("grrUi.stats.statsViewDirective");
var StatsViewDirective=$jscomp$destructuring$var186.StatsViewDirective;var $jscomp$destructuring$var187=goog.require("grrUi.stats.timeseriesGraphDirective");var TimeseriesGraphDirective=$jscomp$destructuring$var187.TimeseriesGraphDirective;var $jscomp$destructuring$var188=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var188.coreModule;exports.statsModule=angular.module("grrUi.stats",[coreModule.name]);exports.statsModule.directive(AuditChartDirective.directive_name,AuditChartDirective);
exports.statsModule.directive(ChartDirective.directive_name,ChartDirective);exports.statsModule.directive(ReportDirective.directive_name,ReportDirective);exports.statsModule.directive(ReportListingDirective.directive_name,ReportListingDirective);exports.statsModule.directive(ServerLoadDirective.directive_name,ServerLoadDirective);exports.statsModule.directive(ServerLoadGraphSerieDirective.directive_name,ServerLoadGraphSerieDirective);exports.statsModule.directive(ServerLoadIndicatorDirective.directive_name,
ServerLoadIndicatorDirective);exports.statsModule.directive(StatsViewDirective.directive_name,StatsViewDirective);exports.statsModule.directive(TimeseriesGraphDirective.directive_name,TimeseriesGraphDirective);exports.statsModule.service(ServerLoadIndicatorService.service_name,ServerLoadIndicatorService);exports.statsModule.service(ReportDescsService.service_name,ReportDescsService);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.breadcrumbsDirective");goog.module.declareLegacyNamespace();var BreadcrumbsController=function($rootScope,$scope,grrApiService){this.rootScope_=$rootScope;this.scope_=$scope;this.items;this.activeItem;this.scope_.$watchGroup(["path","stripEndingSlash"],this.onDirectiveArgsChange_.bind(this))};BreadcrumbsController.prototype.onDirectiveArgsChange_=function(){var pathArg=this.scope_["path"];var stripEndingSlashArg=
this.scope_["stripEndingSlash"];this.items=[];this.activeItem=undefined;if(!pathArg)return;var components=pathArg.split("/");if(stripEndingSlashArg&&pathArg.endsWith("/"))components=components.slice(0,components.length-1);if(components.length<2)return;components=components.slice(0,-1);var currentPath="";angular.forEach(components.slice(0,-1),function(component){currentPath+=component+"/";this.items.push({name:component,path:currentPath})}.bind(this));this.activeItem=components[components.length-1]};
BreadcrumbsController.prototype.selectPath=function(path){this.scope_["path"]=path};exports.BreadcrumbsDirective=function(){return{restrict:"E",scope:{path:"=",stripEndingSlash:"="},templateUrl:"/static/angular-components/client/virtual-file-system/breadcrumbs.html",controller:BreadcrumbsController,controllerAs:"controller"}};exports.BreadcrumbsDirective.directive_name="grrBreadcrumbs";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.encodingsDropdownDirective");goog.module.declareLegacyNamespace();var EncodingsDropdownController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrApiService_.get("reflection/file-encodings").then(function(response){this.encodings=response.data["encodings"]}.bind(this))};exports.EncodingsDropdownDirective=function(){return{restrict:"E",scope:{encoding:"="},templateUrl:"/static/angular-components/client/virtual-file-system/encodings-dropdown.html",
controller:EncodingsDropdownController,controllerAs:"controller"}};exports.EncodingsDropdownDirective.directive_name="grrEncodingsDropdown";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.fileContextDirective");goog.module.declareLegacyNamespace();exports.FileContextController=function($scope){this.scope_=$scope;this.clientId;this.selectedFilePath;this.selectedFileVersion;this.scope_.$watchGroup(["clientId","selectedFilePath","selectedFileVersion"],this.onDirectiveArgumentsChange_.bind(this));this.scope_.$watchGroup(["controller.clientId","controller.selectedFilePath","controller.selectedFileVersion"],
this.onControllerValuesChange_.bind(this))};var FileContextController=exports.FileContextController;FileContextController.prototype.onDirectiveArgumentsChange_=function(){this.clientId=this.scope_["clientId"];this.selectedFilePath=this.scope_["selectedFilePath"];this.selectedFileVersion=this.scope_["selectedFileVersion"]};FileContextController.prototype.onControllerValuesChange_=function(){this.scope_["clientId"]=this.clientId;this.scope_["selectedFilePath"]=this.selectedFilePath;this.scope_["selectedFileVersion"]=
this.selectedFileVersion};FileContextController.prototype.selectFile=function(filePath,opt_fileVersion){this.selectedFilePath=filePath;this.selectedFileVersion=opt_fileVersion||undefined};exports.FileContextDirective=function(){return{restrict:"E",scope:{clientId:"=",selectedFilePath:"=",selectedFileVersion:"="},transclude:true,template:"<ng-transclude />",controller:FileContextController,controllerAs:"controller"}};exports.FileContextDirective.directive_name="grrFileContext";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.events");goog.module.declareLegacyNamespace();exports.REFRESH_FOLDER_EVENT="RefreshFolderEvent";exports.REFRESH_FILE_EVENT="RefreshFileEvent";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.fileDetailsDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var189=goog.require("grrUi.client.virtualFileSystem.events");var REFRESH_FILE_EVENT=$jscomp$destructuring$var189.REFRESH_FILE_EVENT;var $jscomp$destructuring$var190=goog.require("grrUi.core.versionDropdownDirective");var VersionDropdownDirective=$jscomp$destructuring$var190.VersionDropdownDirective;var REFRESH_VERSIONS_EVENT=
VersionDropdownDirective.REFRESH_VERSIONS_EVENT;var FileDetailsController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.shownFileName;this.fileVersionUrl;this.fileContext;this.fileIsDirectory;this.downloadQueryParams;this.currentTab="stats";this.scope_.$on(REFRESH_FILE_EVENT,this.refreshFile_.bind(this));this.scope_.$watch("currentTab",this.onDirectiveTabChange_.bind(this));this.scope_.$watch("controller.currentTab",this.onControllerTabChange_.bind(this));
this.scope_.$watchGroup(["controller.fileContext.clientId","controller.fileContext.selectedFilePath","controller.fileContext.selectedFileVersion"],this.onContextChange_.bind(this))};FileDetailsController.prototype.onDirectiveTabChange_=function(newValue){if(angular.isString(newValue))this.currentTab=newValue};FileDetailsController.prototype.onControllerTabChange_=function(newValue,oldValue){if(newValue!==oldValue)this.scope_["currentTab"]=newValue};FileDetailsController.prototype.onContextChange_=
function(){var clientId=this.fileContext["clientId"];var selectedFilePath=this.fileContext["selectedFilePath"];if(angular.isDefined(clientId)&&angular.isDefined(selectedFilePath))this.fetchFileDetails_()};FileDetailsController.prototype.fetchFileDetails_=function(){var clientId=this.fileContext["clientId"];var selectedFilePath=this.fileContext["selectedFilePath"];var fileVersion=this.fileContext["selectedFileVersion"];var url="clients/"+clientId+"/vfs-details/"+selectedFilePath;var params={};if(fileVersion)params["timestamp"]=
fileVersion;this.grrApiService_.get(url,params).then(this.onFileDetailsFetched_.bind(this))};FileDetailsController.prototype.onFileDetailsFetched_=function(response){var clientId=this.fileContext["clientId"];var selectedFilePath=this.fileContext["selectedFilePath"];var fileVersion=this.fileContext["selectedFileVersion"];var fileDetails=response.data["file"];this.fileVersionUrl="clients/"+clientId+"/vfs-version-times/"+selectedFilePath;this.fileIsDirectory=fileDetails["value"]["is_directory"]["value"];
this.downloadQueryParams={clientId:clientId,aff4_path:"aff4:/"+clientId+"/"+selectedFilePath};if(fileVersion)this.downloadQueryParams["age"]=fileVersion;var components=fileDetails["value"]["path"]["value"].split("/");this.selectedFileName=components[components.length-1]};FileDetailsController.prototype.refreshFile_=function(){this.fileContext["selectedFileVersion"]=undefined;this.scope_.$broadcast(REFRESH_VERSIONS_EVENT,{});this.fetchFileDetails_()};FileDetailsController.prototype.targetsCurrentSelection_=
function(fileDetails){var selectedFilePath=this.fileContext["selectedFilePath"];return fileDetails["value"]["path"]["value"]===selectedFilePath};exports.FileDetailsDirective=function(){return{restrict:"E",scope:{currentTab:"="},require:"^grrFileContext",templateUrl:"/static/angular-components/client/virtual-file-system/file-details.html",controller:FileDetailsController,controllerAs:"controller",link:function(scope,element,attrs,fileContextController){scope.controller.fileContext=fileContextController}}};
exports.FileDetailsDirective.directive_name="grrFileDetails";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.fileDownloadViewDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var191=goog.require("grrUi.client.virtualFileSystem.events");var REFRESH_FILE_EVENT=$jscomp$destructuring$var191.REFRESH_FILE_EVENT;var $jscomp$destructuring$var192=goog.require("grrUi.core.serverErrorButtonDirective");var ServerErrorButtonDirective=$jscomp$destructuring$var192.ServerErrorButtonDirective;var ERROR_EVENT_NAME=
ServerErrorButtonDirective.error_event_name;var OPERATION_POLL_INTERVAL_MS=1E3;var FileDownloadViewController=function($rootScope,$scope,$interval,grrApiService){this.rootScope_=$rootScope;this.scope_=$scope;this.interval_=$interval;this.fileContext;this.grrApiService_=grrApiService;this.updateOperationId;this.updateOperationInterval_;this.updateInProgress;this.downloadCommand;this.fileDetails;this.scope_.$watchGroup(["controller.fileContext.clientId","controller.fileContext.selectedFilePath","controller.fileContext.selectedFileVersion"],
this.onContextChange_.bind(this));this.scope_.$on("$destroy",this.stopMonitorUpdateOperation_.bind(this))};FileDownloadViewController.prototype.onContextChange_=function(){var clientId=this.fileContext["clientId"];var filePath=this.fileContext["selectedFilePath"];var fileVersion=this.fileContext["selectedFileVersion"];if(angular.isDefined(clientId)&&angular.isDefined(filePath)){var commandUrl="clients/"+clientId+"/vfs-download-command/"+filePath;this.grrApiService_.get(commandUrl).then(function(response){this.downloadCommand=
response.data["command"]}.bind(this));var detailsUrl="clients/"+clientId+"/vfs-details/"+filePath;var params={};if(fileVersion)params["timestamp"]=fileVersion;this.fileDetails=undefined;this.grrApiService_.get(detailsUrl,params).then(function(response){this.fileDetails=response.data["file"]}.bind(this))}};FileDownloadViewController.prototype.updateFile=function(){if(this.updateInProgress)return;var clientId=this.fileContext["clientId"];var selectedFilePath=this.fileContext["selectedFilePath"];var url=
"clients/"+clientId+"/vfs-update";var params={file_path:selectedFilePath};this.updateInProgress=true;this.grrApiService_.post(url,params).then(function success(response){this.updateOperationId=response["data"]["operation_id"];this.monitorUpdateOperation_()}.bind(this),function failure(response){this.stopMonitorUpdateOperation_()}.bind(this))};FileDownloadViewController.prototype.monitorUpdateOperation_=function(){this.updateOperationInterval_=this.interval_(this.pollUpdateOperationState_.bind(this),
OPERATION_POLL_INTERVAL_MS)};FileDownloadViewController.prototype.pollUpdateOperationState_=function(){var clientId=this.fileContext["clientId"];var url="clients/"+clientId+"/vfs-update/"+this.updateOperationId;this.grrApiService_.get(url).then(function success(response){if(response["data"]["state"]==="FINISHED"){this.rootScope_.$broadcast(REFRESH_FILE_EVENT);this.stopMonitorUpdateOperation_()}}.bind(this),function failure(response){this.stopMonitorUpdateOperation_()}.bind(this))};FileDownloadViewController.prototype.stopMonitorUpdateOperation_=
function(){this.updateOperationId=null;this.updateInProgress=false;this.interval_.cancel(this.updateOperationInterval_)};FileDownloadViewController.prototype.downloadFile=function(){var clientId=this.fileContext["clientId"];var filePath=this.fileContext["selectedFilePath"];var fileVersion=this.fileContext["selectedFileVersion"];var url="clients/"+clientId+"/vfs-blob/"+filePath;var params={};if(fileVersion)params["timestamp"]=fileVersion;this.grrApiService_.downloadFile(url,params).then(function success(){}.bind(this),
function failure(response){if(angular.isUndefined(response.status))this.rootScope_.$broadcast(ERROR_EVENT_NAME,{message:"Couldn't download file."})}.bind(this))};exports.FileDownloadViewDirective=function(){return{restrict:"E",scope:{},require:"^grrFileContext",templateUrl:"/static/angular-components/client/virtual-file-system/file-download-view.html",controller:FileDownloadViewController,controllerAs:"controller",link:function(scope,element,attrs,fileContextController){scope.controller.fileContext=
fileContextController}}};exports.FileDownloadViewDirective.directive_name="grrFileDownloadView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.fileHexViewDirective");goog.module.declareLegacyNamespace();var FileHexViewController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.fileContext;this.hexDataRows;this.page=1;this.pageCount=1;this.rows_=25;this.columns_=32;this.offset_=0;this.chunkSize_=this.rows_*this.columns_;this.scope_.$watchGroup(["controller.fileContext.clientId","controller.fileContext.selectedFilePath",
"controller.fileContext.selectedFileVersion"],this.onContextChange_.bind(this));this.scope_.$watch("controller.page",this.onPageChange_.bind(this))};FileHexViewController.prototype.onContextChange_=function(){var clientId=this.fileContext["clientId"];var filePath=this.fileContext["selectedFilePath"];if(angular.isDefined(clientId)&&angular.isDefined(filePath))this.fetchText_()};FileHexViewController.prototype.onPageChange_=function(page,oldPage){if(this.page!==oldPage){this.offset_=(this.page-1)*this.chunkSize_;
this.fetchText_()}};FileHexViewController.prototype.fetchText_=function(){var clientId=this.fileContext["clientId"];var filePath=this.fileContext["selectedFilePath"];var fileVersion=this.fileContext["selectedFileVersion"];var url="clients/"+clientId+"/vfs-blob/"+filePath;var headParams={};if(fileVersion)headParams["timestamp"]=fileVersion;this.grrApiService_.head(url,headParams).then(function(response){var total_size=response.headers("Content-Length");this.pageCount=Math.ceil(total_size/this.chunkSize_);
var params={};params["offset"]=this.offset_;params["length"]=this.chunkSize_;if(fileVersion)params["timestamp"]=fileVersion;return this.grrApiService_.get(url,params)}.bind(this)).then(function(response){this.parseFileContentToHexRepresentation_(response.data)}.bind(this),function(){this.hexDataRows=null}.bind(this))};FileHexViewController.prototype.parseFileContentToHexRepresentation_=function(fileContent){this.hexDataRows=[];if(!fileContent)return;for(var i=0;i<this.rows_;i++){var rowOffset=this.offset_+
i*this.columns_;this.hexDataRows.push({offset:rowOffset,data:fileContent.substr(i*this.columns_,this.columns_)})}};exports.FileHexViewDirective=function(){return{restrict:"E",scope:{},require:"^grrFileContext",templateUrl:"/static/angular-components/client/virtual-file-system/file-hex-view.html",controller:FileHexViewController,controllerAs:"controller",link:function(scope,element,attrs,fileContextController){scope.controller.fileContext=fileContextController}}};exports.FileHexViewDirective.directive_name=
"grrFileHexView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.fileStatsViewDirective");goog.module.declareLegacyNamespace();var FileStatsViewController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.fileContext;this.details;this.scope_.$watchGroup(["controller.fileContext.clientId","controller.fileContext.selectedFilePath","controller.fileContext.selectedFileVersion"],this.onContextChange_.bind(this))};FileStatsViewController.prototype.onContextChange_=
function(){var clientId=this.fileContext["clientId"];var filePath=this.fileContext["selectedFilePath"];var fileVersion=this.fileContext["selectedFileVersion"];if(angular.isDefined(clientId)&&angular.isDefined(filePath)){var fileDetailsUrl="clients/"+clientId+"/vfs-details/"+filePath;var params={};if(fileVersion)params["timestamp"]=fileVersion;this.grrApiService_.get(fileDetailsUrl,params).then(function(response){this.details=response.data["file"]["value"]["details"]}.bind(this))}};exports.FileStatsViewDirective=
function(){return{restrict:"E",scope:{},require:"^grrFileContext",templateUrl:"/static/angular-components/client/virtual-file-system/file-stats-view.html",controller:FileStatsViewController,controllerAs:"controller",link:function(scope,element,attrs,fileContextController){scope.controller.fileContext=fileContextController}}};exports.FileStatsViewDirective.directive_name="grrFileStatsView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.fileTableDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var193=goog.require("grrUi.client.virtualFileSystem.events");var REFRESH_FILE_EVENT=$jscomp$destructuring$var193.REFRESH_FILE_EVENT;var REFRESH_FOLDER_EVENT=$jscomp$destructuring$var193.REFRESH_FOLDER_EVENT;var $jscomp$destructuring$var194=goog.require("grrUi.core.serverErrorButtonDirective");var ServerErrorButtonDirective=$jscomp$destructuring$var194.ServerErrorButtonDirective;
var $jscomp$destructuring$var195=goog.require("grrUi.client.virtualFileSystem.utils");var ensurePathIsFolder=$jscomp$destructuring$var195.ensurePathIsFolder;var getFolderFromPath=$jscomp$destructuring$var195.getFolderFromPath;var ERROR_EVENT_NAME=ServerErrorButtonDirective.error_event_name;var OPERATION_POLL_INTERVAL_MS=1E3;var FileTableController=function($rootScope,$scope,$interval,grrApiService){this.rootScope_=$rootScope;this.scope_=$scope;this.interval_=$interval;this.grrApiService_=grrApiService;
this.selectedFilePath_;this.fileListUrl;this.lastRefreshOperationId;this.filterEditedValue="";this.filterValue="";this.fileContext;this.triggerUpdate;this.scope_.$on(REFRESH_FOLDER_EVENT,this.refreshFileList_.bind(this));this.scope_.$on(REFRESH_FILE_EVENT,this.refreshFileList_.bind(this));this.scope_.$watch("controller.fileContext.clientId",this.refreshFileList_.bind(this));this.scope_.$watch("controller.fileContext.selectedFilePath",this.onFilePathChange_.bind(this))};FileTableController.prototype.setViewMode=
function(mode){this.scope_["viewMode"]=mode};FileTableController.prototype.onFilePathChange_=function(newValue,oldValue){var newFolder=getFolderFromPath(newValue);var oldFolder=getFolderFromPath(oldValue);if(newFolder!==oldFolder){this.refreshFileList_();this.lastRefreshOperationId=null}};FileTableController.prototype.refreshFileList_=function(){var clientId=this.fileContext["clientId"];var selectedFilePath=this.fileContext["selectedFilePath"]||"";var selectedFolderPath=getFolderFromPath(selectedFilePath);
this.filter="";this.fileListUrl="clients/"+clientId+"/vfs-index/"+selectedFolderPath;if(this.triggerUpdate)this.triggerUpdate()};FileTableController.prototype.selectFile=function(file){this.fileContext.selectFile(file["value"]["path"]["value"],0)};FileTableController.prototype.selectFolder=function(file){var clientId=this.fileContext["clientId"];var filePath=file["value"]["path"]["value"];filePath=ensurePathIsFolder(filePath);this.fileContext.selectFile(filePath,0);this.fileListUrl="clients/"+clientId+
"/vfs-index/"+filePath};FileTableController.prototype.startVfsRefreshOperation=function(){var clientId=this.fileContext["clientId"];var selectedFilePath=this.fileContext["selectedFilePath"];var selectedFolderPath=getFolderFromPath(selectedFilePath);var url="clients/"+clientId+"/vfs-refresh-operations";var refreshOperation={file_path:selectedFolderPath,max_depth:1,notify_user:false};var operationId=this.lastRefreshOperationId="unknown";this.grrApiService_.post(url,refreshOperation).then(function success(response){operationId=
this.lastRefreshOperationId=response["data"]["operation_id"];var pollPromise=this.grrApiService_.poll(url+"/"+operationId,OPERATION_POLL_INTERVAL_MS);this.scope_.$on("$destroy",function(){this.grrApiService_.cancelPoll(pollPromise)}.bind(this));return pollPromise}.bind(this)).then(function success(){this.rootScope_.$broadcast(REFRESH_FOLDER_EVENT,ensurePathIsFolder(selectedFolderPath))}.bind(this)).finally(function(){if(this.lastRefreshOperationId==operationId)this.lastRefreshOperationId=null}.bind(this))};
FileTableController.prototype.updateFilter=function(){this.filterValue=this.filterEditedValue};FileTableController.prototype.downloadTimeline=function(){var clientId=this.fileContext["clientId"];var selectedFilePath=this.fileContext["selectedFilePath"]||"";var selectedFolderPath=getFolderFromPath(selectedFilePath);var url="clients/"+clientId+"/vfs-timeline-csv/"+selectedFolderPath;this.grrApiService_.downloadFile(url).then(function success(){}.bind(this),function failure(response){if(angular.isUndefined(response.status))this.rootScope_.$broadcast(ERROR_EVENT_NAME,
{message:"Couldn't export the timeline."})}.bind(this))};exports.FileTableDirective=function(){return{restrict:"E",scope:{viewMode:"="},require:"^grrFileContext",templateUrl:"/static/angular-components/client/virtual-file-system/file-table.html",controller:FileTableController,controllerAs:"controller",link:function(scope,element,attrs,fileContextController){scope.controller.fileContext=fileContextController}}};exports.FileTableDirective.directive_name="grrFileTable";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.fileTextViewDirective");goog.module.declareLegacyNamespace();var FileTextViewController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.fileContext;this.fileContent;this.encoding="UTF_8";this.page=1;this.pageCount=1;this.chunkSize_=1E4;this.scope_.$watchGroup(["controller.fileContext.clientId","controller.fileContext.selectedFilePath","controller.fileContext.selectedFileVersion"],
this.onContextChange_.bind(this));this.scope_.$watch("controller.encoding",this.onEncodingChange_.bind(this));this.scope_.$watch("controller.page",this.onPageChange_.bind(this))};FileTextViewController.prototype.onContextChange_=function(){var clientId=this.fileContext["clientId"];var filePath=this.fileContext["selectedFilePath"];if(angular.isDefined(clientId)&&angular.isDefined(filePath))this.fetchText_()};FileTextViewController.prototype.onPageChange_=function(page,oldPage){if(this.page!==oldPage)this.fetchText_()};
FileTextViewController.prototype.onEncodingChange_=function(encoding,oldEncoding){if(this.encoding!==oldEncoding)this.fetchText_()};FileTextViewController.prototype.fetchText_=function(){var clientId=this.fileContext["clientId"];var filePath=this.fileContext["selectedFilePath"];var fileVersion=this.fileContext["selectedFileVersion"];var offset=(this.page-1)*this.chunkSize_;var url="clients/"+clientId+"/vfs-text/"+filePath;var params={};params["encoding"]=this.encoding;params["offset"]=offset;params["length"]=
this.chunkSize_;if(fileVersion)params["timestamp"]=fileVersion;this.grrApiService_.get(url,params).then(function(response){this.fileContent=response.data["content"];var total_size=response.data["total_size"];this.pageCount=Math.ceil(total_size/this.chunkSize_)}.bind(this),function(){this.fileContent=null}.bind(this))};exports.FileTextViewDirective=function(){return{restrict:"E",scope:{},require:"^grrFileContext",templateUrl:"/static/angular-components/client/virtual-file-system/file-text-view.html",
controller:FileTextViewController,controllerAs:"controller",link:function(scope,element,attrs,fileContextController){scope.controller.fileContext=fileContextController}}};exports.FileTextViewDirective.directive_name="grrFileTextView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.fileTimelineDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var196=goog.require("grrUi.client.virtualFileSystem.events");var REFRESH_FILE_EVENT=$jscomp$destructuring$var196.REFRESH_FILE_EVENT;var REFRESH_FOLDER_EVENT=$jscomp$destructuring$var196.REFRESH_FOLDER_EVENT;var $jscomp$destructuring$var197=goog.require("grrUi.client.virtualFileSystem.utils");var getFolderFromPath=$jscomp$destructuring$var197.getFolderFromPath;
var FileTimelineController=function($scope,$interval,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.fileContext;this.timelineItems;this.selectedItem;this.inProgress;this.currentFolder;this.triggerUpdate;this.scope_.$on(REFRESH_FOLDER_EVENT,this.refreshTimeline_.bind(this));this.scope_.$on(REFRESH_FILE_EVENT,this.refreshTimeline_.bind(this));this.scope_.$watch("controller.fileContext.clientId",this.refreshTimeline_.bind(this));this.scope_.$watch("controller.fileContext.selectedFilePath",
this.onFilePathChange_.bind(this))};FileTimelineController.prototype.onFilePathChange_=function(newFilePath){if(angular.isUndefined(newFilePath))return;var newFolder=getFolderFromPath(newFilePath);if(newFilePath.endsWith("/")||angular.isUndefined(this.currentFolder)){this.currentFolder=newFolder;this.refreshTimeline_();return}var newFolderComponents=newFolder.split("/");var currentFolderComponents=this.currentFolder.split("/");for(var i=0;i<currentFolderComponents.length;++i)if(newFolderComponents[i]!=
currentFolderComponents[i]){this.refreshTimeline_();this.currentFolder=newFolder}};FileTimelineController.prototype.refreshTimeline_=function(){var clientId=this.fileContext["clientId"];var selectedFolderPath=getFolderFromPath(this.fileContext["selectedFilePath"]);if(angular.isUndefined(this.currentFolder))this.currentFolder=selectedFolderPath;this.inProgress=true;var url="clients/"+clientId+"/vfs-timeline/"+selectedFolderPath;this.grrApiService_.get(url).then(this.onTimelineFetched_.bind(this)).finally(function(){this.inProgress=
false}.bind(this))};FileTimelineController.prototype.onTimelineFetched_=function(response){var selectedFilePath=this.fileContext["selectedFilePath"];var selectedFileVersion=this.fileContext["selectedFileVersion"];this.timelineItems=response.data["items"];this.selectedItem=this.timelineItems.find(function(item){var v=item["value"];if(v["file_path"]["value"]===selectedFilePath)return!selectedFileVersion||v["timestamp"]["value"]===selectedFileVersion}.bind(this))||null;if(this.selectedItem&&!selectedFileVersion)this.fileContext["selectedFileVersion"]=
this.selectedItem["value"]["timestamp"]["value"];if(this.triggerUpdate)this.triggerUpdate()};FileTimelineController.prototype.selectFile=function(timelineItem){this.selectedItem=timelineItem;var clientId=this.fileContext["clientId"];var selectedFilePath=timelineItem["value"]["file_path"]["value"];var timestamp=timelineItem["value"]["timestamp"]["value"];var url="clients/"+clientId+"/vfs-version-times/"+selectedFilePath;this.grrApiService_.get(url).then(function success(response){var versions=response.data["times"];
var fileVersion=Number.MAX_VALUE;angular.forEach(versions,function(version){if(version["value"]>=timestamp)fileVersion=Math.min(fileVersion,version["value"])});if(fileVersion===Number.MAX_VALUE)if(versions.length)fileVersion=versions[0]["value"];else fileVersion=null;this.fileContext.selectFile(selectedFilePath,fileVersion)}.bind(this))};exports.FileTimelineDirective=function(){return{restrict:"E",scope:{filterValue:"=?"},require:"^grrFileContext",templateUrl:"/static/angular-components/client/virtual-file-system/file-timeline.html",
controller:FileTimelineController,controllerAs:"controller",link:function(scope,element,attrs,fileContextController){scope.controller.fileContext=fileContextController}}};exports.FileTimelineDirective.directive_name="grrFileTimeline";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.fileTreeDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var198=goog.require("grrUi.client.virtualFileSystem.events");var REFRESH_FOLDER_EVENT=$jscomp$destructuring$var198.REFRESH_FOLDER_EVENT;var $jscomp$destructuring$var199=goog.require("grrUi.client.virtualFileSystem.utils");var ensurePathIsFolder=$jscomp$destructuring$var199.ensurePathIsFolder;var getFolderFromPath=$jscomp$destructuring$var199.getFolderFromPath;
var $jscomp$destructuring$var200=goog.require("grrUi.client.virtualFileSystem.fileViewDirective");var getFileId=$jscomp$destructuring$var200.getFileId;var FileTreeController=function($rootScope,$scope,$element,grrApiService,grrRoutingService){this.rootScope_=$rootScope;this.scope_=$scope;this.element_=$element;this.treeElement_=$element.find("#file-tree");this.grrApiService_=grrApiService;this.grrRoutingService_=grrRoutingService;this.fileContext;this.scope_.$on(REFRESH_FOLDER_EVENT,this.onRefreshFolderEvent_.bind(this));
this.scope_.$watch("controller.fileContext.clientId",this.onClientIdChange_.bind(this));this.scope_.$watch("controller.fileContext.selectedFilePath",this.onSelectedFilePathChange_.bind(this))};FileTreeController.prototype.onClientIdChange_=function(){if(angular.isDefined(this.fileContext["clientId"]))this.initTree_()};FileTreeController.prototype.initTree_=function(){var controller=this;this.treeElement_.jstree({"core":{"multiple":false,"data":function(node,cb){if(node.id==="#")controller.getChildFiles_("").then(cb);
else controller.getChildFiles_(node.data.path).then(cb)}}});this.treeElement_.on("changed.jstree",function(e,data){if(data["action"]!=="select_node")return;var selectionId=data.selected[0];var node=this.treeElement_.jstree("get_node",selectionId);var folderPath=node.data.path;if(getFolderFromPath(this.fileContext["selectedFilePath"])===folderPath)this.rootScope_.$broadcast(REFRESH_FOLDER_EVENT,ensurePathIsFolder(folderPath));else this.fileContext.selectFile(ensurePathIsFolder(folderPath));var treeInstance=
data["instance"];treeInstance["refresh_node"](data.node)}.bind(this));this.treeElement_.on("close_node.jstree",function(e,data){data.node["data"]["refreshOnOpen"]=true}.bind(this));this.treeElement_.on("open_node.jstree",function(e,data){if(data.node["data"]["refreshOnOpen"]){data.node["data"]["refreshOnOpen"]=false;var treeInstance=data["instance"];treeInstance["refresh_node"](data.node)}}.bind(this));this.treeElement_.on("loaded.jstree",function(){var selectedFilePath=this.fileContext["selectedFilePath"];
if(selectedFilePath)this.expandToFilePath_(getFileId(getFolderFromPath(selectedFilePath)),true)}.bind(this));this.treeElement_.on("select_node.jstree",function(event,data){$(this)["jstree"]("open_node","#"+data.node.id);return true})};FileTreeController.prototype.getChildFiles_=function(folderPath){var clientId_=this.fileContext["clientId"];var url="clients/"+clientId_+"/vfs-index/"+folderPath;var params={directories_only:1};return this.grrApiService_.get(url,params).then(this.parseFileResponse_.bind(this))};
FileTreeController.prototype.parseFileResponse_=function(response){var files=response.data["items"];var result=[];angular.forEach(files,function(file){var filePath=file["value"]["path"]["value"];var fileId=getFileId(filePath);result.push({id:fileId,text:file["value"]["name"]["value"],data:{path:filePath},children:true})}.bind(this));return result};FileTreeController.prototype.onRefreshFolderEvent_=function(e,path){if(angular.isUndefined(path))path=this.fileContext["selectedFilePath"];var nodeId=getFileId(getFolderFromPath(path));
var node=$("#"+nodeId);this.treeElement_.jstree(true)["refresh_node"](node)};FileTreeController.prototype.onSelectedFilePathChange_=function(){var selectedFilePath=this.fileContext["selectedFilePath"];if(selectedFilePath){var selectedFolderPath=getFolderFromPath(selectedFilePath);this.expandToFilePath_(getFileId(selectedFolderPath),true)}};FileTreeController.prototype.expandToFilePath_=function(filePathId,opt_suppressEvent){if(!filePathId)return;var element=this.treeElement_;var parts=filePathId.split("-");
var cb=function(i,prev_node){var id_to_open=parts.slice(0,i+1).join("-");var node=$("#"+id_to_open);if(node.length)if(parts[i+1])element.jstree("open_node",node,function(){cb(i+1,node)},"no_hash");else{element.jstree(true)["deselect_all"](true);element.jstree(true)["select_node"](node,opt_suppressEvent)}else if(prev_node){element.jstree(true)["deselect_all"](true);element.jstree(true)["select_node"](prev_node,opt_suppressEvent)}}.bind(this);cb(0,null)};exports.FileTreeDirective=function(){return{restrict:"E",
scope:{},require:"^grrFileContext",templateUrl:"/static/angular-components/client/virtual-file-system/file-tree.html",controller:FileTreeController,controllerAs:"controller",link:function(scope,element,attrs,fileContextController){scope.controller.fileContext=fileContextController}}};exports.FileTreeDirective.directive_name="grrFileTree";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.rWeOwnedButtonDirective");goog.module.declareLegacyNamespace();var phrases=["It is certain","You were eaten by a Grue!","\u4e2d\u56fd got you!!","All your bases are belong to us!","Maybe it was the Russians?","It is decidedly so","Without a doubt","Yes - definitely","You may rely on it","As I see it, yes","Most likely","Outlook good","Signs point to yes","Yes","Reply hazy, try again","Ask again later","Better not tell you now",
"Cannot predict now","Concentrate and ask again","Don't count on it","My reply is no","My sources say no","Outlook not so good","Very doubtful"];var RWeOwnedButtonController=function($scope,$uibModal){this.scope_=$scope;this.uibModal_=$uibModal;this.phrase};RWeOwnedButtonController.prototype.onClick=function(){var randomIndex=Math.floor(Math.random()*phrases.length);this.scope_.phrase=phrases[randomIndex];this.uibModal_.open({templateUrl:"/static/angular-components/client/virtual-file-system/"+"r-we-owned-button-modal.html",
scope:this.scope_})};exports.RWeOwnedButtonDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/client/virtual-file-system/r-we-owned-button.html",controller:RWeOwnedButtonController,controllerAs:"controller"}};exports.RWeOwnedButtonDirective.directive_name="grrRWeOwnedButton";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.recursiveListButtonDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var201=goog.require("grrUi.client.virtualFileSystem.events");var REFRESH_FOLDER_EVENT=$jscomp$destructuring$var201.REFRESH_FOLDER_EVENT;var $jscomp$destructuring$var202=goog.require("grrUi.client.virtualFileSystem.utils");var ensurePathIsFolder=$jscomp$destructuring$var202.ensurePathIsFolder;var getFolderFromPath=$jscomp$destructuring$var202.getFolderFromPath;
var OPERATION_POLL_INTERVAL_MS=1E3;var RecursiveListButtonController=function($rootScope,$scope,$timeout,$uibModal,grrApiService,grrReflectionService){this.rootScope_=$rootScope;this.scope_=$scope;this.timeout_=$timeout;this.uibModal_=$uibModal;this.grrApiService_=grrApiService;this.grrReflectionService_=grrReflectionService;this.lastOperationId;this.refreshOperation;this.done;this.error;this.modalInstance;this.scope_.$watchGroup(["clientId","filePath"],this.onClientOrPathChange_.bind(this))};RecursiveListButtonController.MAX_DEPTH=
5;RecursiveListButtonController.prototype.onClientOrPathChange_=function(){this.lastOperationId=null};RecursiveListButtonController.prototype.onClick=function(){this.isDisabled=true;this.done=false;this.error=null;this.grrReflectionService_.getRDFValueDescriptor("ApiCreateVfsRefreshOperationArgs",true).then(function(descriptors){this.refreshOperation=angular.copy(descriptors["ApiCreateVfsRefreshOperationArgs"]["default"]);var filePath=angular.copy(descriptors["RDFString"]["default"]);filePath["value"]=
getFolderFromPath(this.scope_["filePath"]);this.refreshOperation["value"]["file_path"]=filePath;var maxDepth=angular.copy(descriptors["RDFInteger"]["default"]);maxDepth["value"]=RecursiveListButtonController.MAX_DEPTH;this.refreshOperation["value"]["max_depth"]=maxDepth;this.refreshOperation["value"]["notify_user"]=true;this.modalInstance=this.uibModal_.open({templateUrl:"/static/angular-components/client/virtual-file-system/"+"recursive-list-button-modal.html",scope:this.scope_})}.bind(this))};RecursiveListButtonController.prototype.createRefreshOperation=
function(){var aff4Prefix="aff4:/";var clientId=this.scope_["clientId"];if(clientId.toLowerCase().indexOf(aff4Prefix)==0)clientId=clientId.substr(aff4Prefix.length);var url="clients/"+clientId+"/vfs-refresh-operations";var refreshOperation=angular.copy(this.refreshOperation);var operationId=this.lastOperationId="unknown";this.grrApiService_.post(url,refreshOperation,true).then(function success(response){this.done=true;this.timeout_(function(){this.modalInstance.close()}.bind(this),1E3);operationId=
this.lastOperationId=response["data"]["operation_id"];var pollPromise=this.grrApiService_.poll(url+"/"+operationId,OPERATION_POLL_INTERVAL_MS);this.scope_.$on("$destroy",function(){this.grrApiService_.cancelPoll(pollPromise)}.bind(this));return pollPromise}.bind(this),function failure(response){this.done=true;this.error=response["data"]["message"]||"Unknown error."}.bind(this)).then(function success(){var path=refreshOperation["value"]["file_path"]["value"];this.rootScope_.$broadcast(REFRESH_FOLDER_EVENT,
ensurePathIsFolder(path))}.bind(this)).finally(function(){if(this.lastOperationId==operationId)this.lastOperationId=null}.bind(this))};exports.RecursiveListButtonDirective=function(){return{scope:{clientId:"=",filePath:"="},restrict:"E",templateUrl:"/static/angular-components/client/virtual-file-system/"+"recursive-list-button.html",controller:RecursiveListButtonController,controllerAs:"controller"}};exports.RecursiveListButtonDirective.directive_name="grrRecursiveListButton";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.vfsFilesArchiveButtonDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var203=goog.require("grrUi.core.serverErrorButtonDirective");var ServerErrorButtonDirective=$jscomp$destructuring$var203.ServerErrorButtonDirective;var $jscomp$destructuring$var204=goog.require("grrUi.client.virtualFileSystem.utils");var getFolderFromPath=$jscomp$destructuring$var204.getFolderFromPath;var ERROR_EVENT_NAME=
ServerErrorButtonDirective.error_event_name;exports.DOWNLOAD_EVERYTHING_REENABLE_DELAY=3E4;var DOWNLOAD_EVERYTHING_REENABLE_DELAY=exports.DOWNLOAD_EVERYTHING_REENABLE_DELAY;var VfsFilesArchiveButtonController=function($rootScope,$scope,$timeout,grrApiService){this.rootScope_=$rootScope;this.scope_=$scope;this.timeout_=$timeout;this.grrApiService_=grrApiService;this.downloadEverythingDisabled=false;this.downloadCurrentFolderDisabled=false;this.scope_.$watch("clientId",function(){this.downloadEverythingDisabled=
false}.bind(this));this.scope_.$watch("filePath",function(value){this.downloadCurrentFolderDisabled=false}.bind(this))};VfsFilesArchiveButtonController.prototype._download=function(path){var clientId=this.scope_["clientId"];var url="clients/"+clientId+"/vfs-files-archive/"+path;this.grrApiService_.downloadFile(url).then(function success(){}.bind(this),function failure(response){if(angular.isUndefined(response.status))this.rootScope_.$broadcast(ERROR_EVENT_NAME,{message:"Couldn't download the VFS archive."})}.bind(this))};
VfsFilesArchiveButtonController.prototype.downloadCurrentFolder=function(e){e.preventDefault();if(!this.downloadCurrentFolderDisabled){var folderPath=getFolderFromPath(this.scope_["filePath"]);this._download(folderPath);this.downloadCurrentFolderDisabled=true}};VfsFilesArchiveButtonController.prototype.downloadEverything=function(e){e.preventDefault();if(!this.downloadEverythingDisabled){this._download("");this.downloadEverythingDisabled=true;this.timeout_(function(){this.downloadEverythingDisabled=
false}.bind(this),DOWNLOAD_EVERYTHING_REENABLE_DELAY)}};exports.VfsFilesArchiveButtonDirective=function(){return{scope:{clientId:"=",filePath:"="},restrict:"E",templateUrl:"/static/angular-components/client/virtual-file-system/"+"vfs-files-archive-button.html",controller:VfsFilesArchiveButtonController,controllerAs:"controller"}};exports.VfsFilesArchiveButtonDirective.directive_name="grrVfsFilesArchiveButton";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.virtualFileSystem.virtualFileSystem");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var205=goog.require("grrUi.client.virtualFileSystem.breadcrumbsDirective");var BreadcrumbsDirective=$jscomp$destructuring$var205.BreadcrumbsDirective;var $jscomp$destructuring$var206=goog.require("grrUi.client.virtualFileSystem.encodingsDropdownDirective");var EncodingsDropdownDirective=$jscomp$destructuring$var206.EncodingsDropdownDirective;
var $jscomp$destructuring$var207=goog.require("grrUi.client.virtualFileSystem.fileContextDirective");var FileContextDirective=$jscomp$destructuring$var207.FileContextDirective;var $jscomp$destructuring$var208=goog.require("grrUi.client.virtualFileSystem.fileDetailsDirective");var FileDetailsDirective=$jscomp$destructuring$var208.FileDetailsDirective;var $jscomp$destructuring$var209=goog.require("grrUi.client.virtualFileSystem.fileDownloadViewDirective");var FileDownloadViewDirective=$jscomp$destructuring$var209.FileDownloadViewDirective;
var $jscomp$destructuring$var210=goog.require("grrUi.client.virtualFileSystem.fileHexViewDirective");var FileHexViewDirective=$jscomp$destructuring$var210.FileHexViewDirective;var $jscomp$destructuring$var211=goog.require("grrUi.client.virtualFileSystem.fileStatsViewDirective");var FileStatsViewDirective=$jscomp$destructuring$var211.FileStatsViewDirective;var $jscomp$destructuring$var212=goog.require("grrUi.client.virtualFileSystem.fileTableDirective");var FileTableDirective=$jscomp$destructuring$var212.FileTableDirective;
var $jscomp$destructuring$var213=goog.require("grrUi.client.virtualFileSystem.fileTextViewDirective");var FileTextViewDirective=$jscomp$destructuring$var213.FileTextViewDirective;var $jscomp$destructuring$var214=goog.require("grrUi.client.virtualFileSystem.fileTimelineDirective");var FileTimelineDirective=$jscomp$destructuring$var214.FileTimelineDirective;var $jscomp$destructuring$var215=goog.require("grrUi.client.virtualFileSystem.fileTreeDirective");var FileTreeDirective=$jscomp$destructuring$var215.FileTreeDirective;
var $jscomp$destructuring$var216=goog.require("grrUi.client.virtualFileSystem.fileViewDirective");var FileViewDirective=$jscomp$destructuring$var216.FileViewDirective;var $jscomp$destructuring$var217=goog.require("grrUi.client.virtualFileSystem.rWeOwnedButtonDirective");var RWeOwnedButtonDirective=$jscomp$destructuring$var217.RWeOwnedButtonDirective;var $jscomp$destructuring$var218=goog.require("grrUi.client.virtualFileSystem.recursiveListButtonDirective");var RecursiveListButtonDirective=$jscomp$destructuring$var218.RecursiveListButtonDirective;
var $jscomp$destructuring$var219=goog.require("grrUi.client.virtualFileSystem.vfsFilesArchiveButtonDirective");var VfsFilesArchiveButtonDirective=$jscomp$destructuring$var219.VfsFilesArchiveButtonDirective;var $jscomp$destructuring$var220=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var220.coreModule;var $jscomp$destructuring$var221=goog.require("grrUi.semantic.semantic");var semanticModule=$jscomp$destructuring$var221.semanticModule;exports.virtualFileSystemModule=angular.module("grrUi.client.virtualFileSystem",
[coreModule.name,semanticModule.name]);exports.virtualFileSystemModule.directive(BreadcrumbsDirective.directive_name,BreadcrumbsDirective);exports.virtualFileSystemModule.directive(EncodingsDropdownDirective.directive_name,EncodingsDropdownDirective);exports.virtualFileSystemModule.directive(FileContextDirective.directive_name,FileContextDirective);exports.virtualFileSystemModule.directive(FileDetailsDirective.directive_name,FileDetailsDirective);exports.virtualFileSystemModule.directive(FileDownloadViewDirective.directive_name,
FileDownloadViewDirective);exports.virtualFileSystemModule.directive(FileHexViewDirective.directive_name,FileHexViewDirective);exports.virtualFileSystemModule.directive(FileStatsViewDirective.directive_name,FileStatsViewDirective);exports.virtualFileSystemModule.directive(FileTableDirective.directive_name,FileTableDirective);exports.virtualFileSystemModule.directive(FileTimelineDirective.directive_name,FileTimelineDirective);exports.virtualFileSystemModule.directive(FileTextViewDirective.directive_name,
FileTextViewDirective);exports.virtualFileSystemModule.directive(FileTreeDirective.directive_name,FileTreeDirective);exports.virtualFileSystemModule.directive(FileViewDirective.directive_name,FileViewDirective);exports.virtualFileSystemModule.directive(RecursiveListButtonDirective.directive_name,RecursiveListButtonDirective);exports.virtualFileSystemModule.directive(VfsFilesArchiveButtonDirective.directive_name,VfsFilesArchiveButtonDirective);exports.virtualFileSystemModule.directive(RWeOwnedButtonDirective.directive_name,
RWeOwnedButtonDirective);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.client.client");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var222=goog.require("grrUi.client.addClientsLabelsDialogDirective");var AddClientsLabelsDialogDirective=$jscomp$destructuring$var222.AddClientsLabelsDialogDirective;var $jscomp$destructuring$var223=goog.require("grrUi.client.checkClientAccessDirective");var CheckClientAccessDirective=$jscomp$destructuring$var223.CheckClientAccessDirective;var $jscomp$destructuring$var224=
goog.require("grrUi.client.clientContextDirective");var ClientContextDirective=$jscomp$destructuring$var224.ClientContextDirective;var $jscomp$destructuring$var225=goog.require("grrUi.client.clientCrashesDirective");var ClientCrashesDirective=$jscomp$destructuring$var225.ClientCrashesDirective;var $jscomp$destructuring$var226=goog.require("grrUi.client.clientDialogService");var ClientDialogService=$jscomp$destructuring$var226.ClientDialogService;var $jscomp$destructuring$var227=goog.require("grrUi.client.clientLoadGraphSerieDirective");
var ClientLoadGraphSerieDirective=$jscomp$destructuring$var227.ClientLoadGraphSerieDirective;var $jscomp$destructuring$var228=goog.require("grrUi.client.clientLoadViewDirective");var ClientLoadViewDirective=$jscomp$destructuring$var228.ClientLoadViewDirective;var $jscomp$destructuring$var229=goog.require("grrUi.client.clientStatusIconsDirective");var ClientStatusIconsDirective=$jscomp$destructuring$var229.ClientStatusIconsDirective;var $jscomp$destructuring$var230=goog.require("grrUi.client.clientUsernamesDirective");
var ClientUsernamesDirective=$jscomp$destructuring$var230.ClientUsernamesDirective;var $jscomp$destructuring$var231=goog.require("grrUi.client.clientsListDirective");var ClientsListDirective=$jscomp$destructuring$var231.ClientsListDirective;var $jscomp$destructuring$var232=goog.require("grrUi.client.debugRequestsViewDirective");var DebugRequestsViewDirective=$jscomp$destructuring$var232.DebugRequestsViewDirective;var $jscomp$destructuring$var233=goog.require("grrUi.client.hostHistoryDialogDirective");
var HostHistoryDialogDirective=$jscomp$destructuring$var233.HostHistoryDialogDirective;var $jscomp$destructuring$var234=goog.require("grrUi.client.hostInfoDirective");var HostInfoDirective=$jscomp$destructuring$var234.HostInfoDirective;var $jscomp$destructuring$var235=goog.require("grrUi.client.removeClientsLabelsDialogDirective");var RemoveClientsLabelsDialogDirective=$jscomp$destructuring$var235.RemoveClientsLabelsDialogDirective;var $jscomp$destructuring$var236=goog.require("grrUi.core.core");
var coreModule=$jscomp$destructuring$var236.coreModule;var $jscomp$destructuring$var237=goog.require("grrUi.semantic.semantic");var semanticModule=$jscomp$destructuring$var237.semanticModule;var $jscomp$destructuring$var238=goog.require("grrUi.stats.stats");var statsModule=$jscomp$destructuring$var238.statsModule;var $jscomp$destructuring$var239=goog.require("grrUi.client.virtualFileSystem.virtualFileSystem");var virtualFileSystemModule=$jscomp$destructuring$var239.virtualFileSystemModule;exports.clientModule=
angular.module("grrUi.client",[virtualFileSystemModule.name,coreModule.name,semanticModule.name,statsModule.name]);exports.clientModule.directive(AddClientsLabelsDialogDirective.directive_name,AddClientsLabelsDialogDirective);exports.clientModule.directive(CheckClientAccessDirective.directive_name,CheckClientAccessDirective);exports.clientModule.directive(ClientContextDirective.directive_name,ClientContextDirective);exports.clientModule.directive(ClientCrashesDirective.directive_name,ClientCrashesDirective);
exports.clientModule.directive(ClientsListDirective.directive_name,ClientsListDirective);exports.clientModule.directive(ClientLoadGraphSerieDirective.directive_name,ClientLoadGraphSerieDirective);exports.clientModule.directive(ClientLoadViewDirective.directive_name,ClientLoadViewDirective);exports.clientModule.directive(ClientStatusIconsDirective.directive_name,ClientStatusIconsDirective);exports.clientModule.directive(ClientUsernamesDirective.directive_name,ClientUsernamesDirective);exports.clientModule.directive(DebugRequestsViewDirective.directive_name,
DebugRequestsViewDirective);exports.clientModule.directive(HostHistoryDialogDirective.directive_name,HostHistoryDialogDirective);exports.clientModule.directive(HostInfoDirective.directive_name,HostInfoDirective);exports.clientModule.directive(RemoveClientsLabelsDialogDirective.directive_name,RemoveClientsLabelsDialogDirective);exports.clientModule.service(ClientDialogService.service_name,ClientDialogService);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.config.binariesListDirective");goog.module.declareLegacyNamespace();exports.sortBinaries=function(binaries){return binaries.map(function(b){var newB=angular.copy(b);var pathComponents=newB["value"]["path"]["value"].split("/");newB["pathLen"]=pathComponents.length;newB["baseName"]=pathComponents.pop();newB["dirName"]=pathComponents.join("/");return newB}).sort(function(a,b){if(a["pathLen"]!==b["pathLen"])return b["pathLen"]-a["pathLen"];
return a["value"]["path"]["value"].localeCompare(b["value"]["path"]["value"])})};var sortBinaries=exports.sortBinaries;var BinariesListController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.binaries;this.scope_.$watchGroup(["binaries","binaryType"],this.onBinariesChange_.bind(this))};BinariesListController.prototype.onBinariesChange_=function(){this.binaries=[];if(angular.isDefined(this.scope_["binaries"])){var filteredBinaries=this.scope_["binaries"].filter(function(b){return b["value"]["type"]["value"]===
this.scope_["typeFilter"]}.bind(this));this.binaries=sortBinaries(filteredBinaries)}};BinariesListController.prototype.onBinaryClicked=function(binary){var url="/config/binaries"+"/"+binary["value"]["type"]["value"]+"/"+binary["value"]["path"]["value"];this.grrApiService_.downloadFile(url)};exports.BinariesListDirective=function(){return{restrict:"E",scope:{binaries:"=",typeFilter:"@"},templateUrl:"/static/angular-components/config/binaries-list.html",controller:BinariesListController,controllerAs:"controller"}};
exports.BinariesListDirective.directive_name="grrBinariesList";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.config.configBinariesViewDirective");goog.module.declareLegacyNamespace();var ConfigBinariesViewController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.binaries;this.grrApiService_.get("/config/binaries").then(function(response){this.binaries=response["data"]["items"]}.bind(this))};exports.ConfigBinariesViewDirective=function(){return{restrict:"E",scope:{},templateUrl:"/static/angular-components/config/config-binaries-view.html",
controller:ConfigBinariesViewController,controllerAs:"controller"}};exports.ConfigBinariesViewDirective.directive_name="grrConfigBinariesView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.config.configViewDirective");goog.module.declareLegacyNamespace();var ConfigViewController=function($scope,$http){$http.get("/api/config").then(function(config){this.items={};angular.forEach(config["data"]["sections"],function(section){var sectionName=section["value"]["name"]["value"];var sectionOptions=section["value"]["options"];this.items[sectionName]={};angular.forEach(sectionOptions,function(option){this.items[sectionName][option["value"]["name"]["value"]]=
option}.bind(this))}.bind(this))}.bind(this))};exports.ConfigViewDirective=function(){return{restrict:"E",scope:{},templateUrl:"/static/angular-components/config/config-view.html",controller:ConfigViewController,controllerAs:"controller"}};exports.ConfigViewDirective.directive_name="grrConfigView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.config.config");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var240=goog.require("grrUi.config.binariesListDirective");var BinariesListDirective=$jscomp$destructuring$var240.BinariesListDirective;var $jscomp$destructuring$var241=goog.require("grrUi.config.configBinariesViewDirective");var ConfigBinariesViewDirective=$jscomp$destructuring$var241.ConfigBinariesViewDirective;var $jscomp$destructuring$var242=goog.require("grrUi.config.configViewDirective");
var ConfigViewDirective=$jscomp$destructuring$var242.ConfigViewDirective;var $jscomp$destructuring$var243=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var243.coreModule;exports.configModule=angular.module("grrUi.config",[coreModule.name]);exports.configModule.directive(BinariesListDirective.directive_name,BinariesListDirective);exports.configModule.directive(ConfigBinariesViewDirective.directive_name,ConfigBinariesViewDirective);exports.configModule.directive(ConfigViewDirective.directive_name,
ConfigViewDirective);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.cronJobFlowsListDirective");goog.module.declareLegacyNamespace();var CronJobFlowsListController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.flowsUrl;this.cronJobId;this.selectedFlowId;this.scope_.$watch("cronJobId",this.onCronJobIdChange_.bind(this))};CronJobFlowsListController.prototype.onCronJobIdChange_=function(cronJobId){if(angular.isString(cronJobId)){var components=cronJobId.split("/");
this.cronJobId=components[components.length-1];this.flowsUrl="/cron-jobs/"+this.cronJobId+"/flows"}};CronJobFlowsListController.prototype.closeDetails=function(){this.selectedFlowId=null};exports.CronJobFlowsListDirective=function(){return{scope:{cronJobId:"=",selectedFlowId:"=?"},restrict:"E",templateUrl:"/static/angular-components/cron/cron-job-flows-list.html",controller:CronJobFlowsListController,controllerAs:"controller"}};exports.CronJobFlowsListDirective.directive_name="grrCronJobFlowsList";
return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.cronJobInspectorDirective");goog.module.declareLegacyNamespace();exports.CronJobInspectorDirective=function(){return{scope:{cronJobId:"="},restrict:"E",templateUrl:"/static/angular-components/cron/cron-job-inspector.html"}};exports.CronJobInspectorDirective.directive_name="grrCronJobInspector";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.cronJobOverviewDirective");goog.module.declareLegacyNamespace();var CronJobOverviewController=function($scope,grrApiService){this.scope_=$scope;this.scope_.cronJobId;this.grrApiService_=grrApiService;this.cronJob;this.cronJobId;this.scope_.$watch("cronJobId",this.onCronJobIdChange.bind(this))};CronJobOverviewController.prototype.onCronJobIdChange=function(newCronJobId){this.cronJob=null;if(angular.isDefined(newCronJobId)){this.cronJobId=
newCronJobId;this.grrApiService_.get("cron-jobs/"+this.cronJobId).then(this.onCronJobFetched.bind(this))}};CronJobOverviewController.prototype.onCronJobFetched=function(response){this.cronJob=response.data};exports.CronJobOverviewDirective=function(){return{scope:{cronJobId:"="},restrict:"E",templateUrl:"/static/angular-components/cron/cron-job-overview.html",controller:CronJobOverviewController,controllerAs:"controller"}};exports.CronJobOverviewDirective.directive_name="grrCronJobOverview";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.cronJobStatusIconDirective");goog.module.declareLegacyNamespace();exports.CronJobStatusIconDirective=function(){return{scope:{cronJob:"="},restrict:"E",templateUrl:"/static/angular-components/cron/cron-job-status-icon.html"}};exports.CronJobStatusIconDirective.directive_name="grrCronJobStatusIcon";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.cronJobsListDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var244=goog.require("grrUi.core.utils");var stripAff4Prefix=$jscomp$destructuring$var244.stripAff4Prefix;var CronJobsListController=function($scope,$uibModal,$q,grrTimeService,grrApiService,grrDialogService,grrAclDialogService){this.scope_=$scope;this.uibModal_=$uibModal;this.q_=$q;this.timeService_=grrTimeService;this.grrApiService_=grrApiService;
this.grrDialogService_=grrDialogService;this.grrAclDialogService_=grrAclDialogService;this.cronJobsById={};this.selectedCronJobId;this.triggerUpdate;this.ooCronHuntsEnabled;this.scope_.$watch("controller.selectedCronJobId",function(newValue){if(angular.isDefined(newValue))this.scope_["selectedCronJobId"]=newValue}.bind(this));this.scope_.$watch("selectedCronJobId",function(newValue){if(angular.isDefined(newValue))this.selectedCronJobId=newValue}.bind(this))};CronJobsListController.prototype.cronUrl=
"/cron-jobs";CronJobsListController.prototype.wrapApiPromise_=function(promise,successMessage){return promise.then(function success(){return successMessage}.bind(this),function failure(response){var message=response["data"]["message"];if(response["status"]===403){var subject=response["data"]["subject"];var cronJobId=stripAff4Prefix(subject).split("/")[1];this.grrAclDialogService_.openRequestCronJobApprovalDialog(cronJobId,message)}return this.q_.reject(message)}.bind(this))};CronJobsListController.prototype.buildCronJobUrl_=
function(cronJobId){return"cron-jobs/"+cronJobId};CronJobsListController.prototype.selectItem=function(item){this.selectedCronJobId=item["value"]["cron_job_id"]["value"]};CronJobsListController.prototype.transformItems=function(items){items=angular.copy(items);angular.forEach(items,function(item,index){var cronJobId=item["value"]["cron_job_id"]["value"];this.cronJobsById[cronJobId]=item;var periodicity=item["value"]["periodicity"]["value"];var currentTime=this.timeService_.getCurrentTimeMs()/1E3;
var last_run_time;if(angular.isDefined(item["value"]["last_run_time"]))last_run_time=item["value"]["last_run_time"]["value"]/1E3;else last_run_time=0;item.isStuck=currentTime-last_run_time>periodicity*2}.bind(this));return items};CronJobsListController.prototype.newCronJob=function(){var modalScope=this.scope_.$new();modalScope.resolve=function(){modalInstance.close()};modalScope.reject=function(){modalInstance.dismiss()};this.scope_.$on("$destroy",function(){modalScope.$destroy()});modalScope.result=
{};var modalInstance=this.uibModal_.open({template:'<grr-new-cron-job-wizard-form on-resolve="resolve()" '+'on-reject="reject()" cron-job="result.cronJob" />',scope:modalScope,windowClass:"wide-modal high-modal",size:"lg"});modalInstance.result.then(function resolve(){this.triggerUpdate();this.selectedCronJobId=modalScope["result"]["cronJob"]["value"]["cron_job_id"]["value"]}.bind(this))};CronJobsListController.prototype.enableCronJob=function(){var modalPromise=this.grrDialogService_.openConfirmation("Enable this cron job?",
"Are you sure you want to ENABLE this cron job?",function(){var promise=this.grrApiService_.patch(this.buildCronJobUrl_(this.selectedCronJobId),{state:"ENABLED"});return this.wrapApiPromise_(promise,"Cron job was ENABLED successfully!")}.bind(this));modalPromise.then(function resolve(){this.triggerUpdate()}.bind(this),function dismiss(){this.triggerUpdate()}.bind(this))};CronJobsListController.prototype.disableCronJob=function(){var modalPromise=this.grrDialogService_.openConfirmation("Disable this cron job?",
"Are you sure you want to DISABLE this cron job?",function(){var promise=this.grrApiService_.patch(this.buildCronJobUrl_(this.selectedCronJobId),{state:"DISABLED"});return this.wrapApiPromise_(promise,"Cron job was DISABLED successfully!")}.bind(this));modalPromise.then(function resolve(){this.triggerUpdate()}.bind(this),function dismiss(){this.triggerUpdate()}.bind(this))};CronJobsListController.prototype.showDeleteCronJobConfirmation=function(){var dialogResult=this.grrDialogService_.openConfirmation("Delete cron job",
"Are you sure you want to DELETE this cron job?",this.deleteCronJob_.bind(this));dialogResult.then(function resolve(){this.triggerUpdate()}.bind(this))};CronJobsListController.prototype.deleteCronJob_=function(){var url=this.buildCronJobUrl_(this.selectedCronJobId);var deferred=this.q_.defer();this.grrApiService_.delete(url).then(function success(){deferred.resolve("Cron job was deleted successfully!")},function failure(response){if(response.status===403){var headers=response.headers();this.grrAclDialogService_.openRequestCronJobApprovalDialog(headers["x-grr-unauthorized-access-subject"],
headers["x-grr-unauthorized-access-reason"])}else deferred.reject(response.data.message)}.bind(this));return deferred.promise};CronJobsListController.prototype.forceRunCronJob=function(){var modalPromise=this.grrDialogService_.openConfirmation("Force-run this cron job?","Are you sure you want to FORCE-RUN this cron job?",function(){var promise=this.grrApiService_.post(this.buildCronJobUrl_(this.selectedCronJobId)+"/actions/force-run");return this.wrapApiPromise_(promise,"Cron job flow was FORCE-STARTED successfully!")}.bind(this));
modalPromise.then(function resolve(){this.triggerUpdate()}.bind(this),function dismiss(){this.triggerUpdate()}.bind(this))};exports.CronJobsListDirective=function(){return{scope:{selectedCronJobId:"=?"},restrict:"E",templateUrl:"/static/angular-components/cron/cron-jobs-list.html",controller:CronJobsListController,controllerAs:"controller"}};exports.CronJobsListDirective.directive_name="grrCronJobsList";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.cronViewDirective");goog.module.declareLegacyNamespace();var CronViewController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.selectedCronJobId;this.scope_.$watch("controller.selectedCronJobId",this.onSelectedCronJobIdChange_.bind(this));this.grrRoutingService_.uiOnParamsChanged(this.scope_,"cronJobId",this.onParamsChange_.bind(this))};CronViewController.prototype.onParamsChange_=
function(cronJobId){if(cronJobId)this.selectedCronJobId=cronJobId};CronViewController.prototype.onSelectedCronJobIdChange_=function(newValue){if(angular.isDefined(newValue))this.grrRoutingService_.go("crons",{cronJobId:newValue})};exports.CronViewDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/cron/cron-view.html",controller:CronViewController,controllerAs:"controller"}};exports.CronViewDirective.directive_name="grrCronView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.newCronJobWizard.configureSchedulePageDirective");goog.module.declareLegacyNamespace();exports.ConfigureSchedulePageDirective=function(){return{scope:{cronJob:"="},restrict:"E",templateUrl:"/static/angular-components/cron/new-cron-job-wizard/"+"configure-schedule-page.html",controllerAs:"controller"}};exports.ConfigureSchedulePageDirective.directive_name="grrConfigureSchedulePage";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.newHuntWizard.formDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var245=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var245.ApiService;var stripTypeInfo=$jscomp$destructuring$var245.stripTypeInfo;var $jscomp$destructuring$var246=goog.require("grrUi.core.reflectionService");var ReflectionService=$jscomp$destructuring$var246.ReflectionService;exports.DEFAULT_PLUGIN_URL="/config/"+
"AdminUI.new_hunt_wizard.default_output_plugin";var DEFAULT_PLUGIN_URL=exports.DEFAULT_PLUGIN_URL;var FormController=function($scope,grrReflectionService,grrApiService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.grrApiService_=grrApiService;this.descriptors_={};this.defaultOutputPluginName;this.configureFlowPageHasErrors;this.grrApiService_.get(DEFAULT_PLUGIN_URL).then(function(response){if(angular.isDefined(response["data"]["value"]))this.defaultOutputPluginName=response["data"]["value"]["value"];
return this.grrReflectionService_.getRDFValueDescriptor("ApiCreateHuntArgs",true)}.bind(this)).then(function(descriptors){angular.extend(this.descriptors_,descriptors);this.scope_.$watch("createHuntArgs",this.onCreateHuntArgsChange_.bind(this))}.bind(this))};FormController.prototype.onCreateHuntArgsChange_=function(newValue){if(angular.isUndefined(newValue))newValue=this.scope_["createHuntArgs"]=angular.copy(this.descriptors_["ApiCreateHuntArgs"]["default"]);if(angular.isUndefined(newValue["value"]["flow_name"]))newValue["value"]["flow_name"]=
angular.copy(this.descriptors_["RDFString"]["default"]);var hra=newValue["value"]["hunt_runner_args"];if(angular.isUndefined(hra))hra=newValue["value"]["hunt_runner_args"]=angular.copy(this.descriptors_["HuntRunnerArgs"]["default"]);if(angular.isUndefined(hra["value"]["output_plugins"]))if(this.defaultOutputPluginName){var defaultPluginDescriptor=angular.copy(this.descriptors_["OutputPluginDescriptor"]["default"]);defaultPluginDescriptor["value"]["plugin_name"]=angular.copy(this.descriptors_["RDFString"]["default"]);
defaultPluginDescriptor["value"]["plugin_name"]["value"]=this.defaultOutputPluginName;hra["value"]["output_plugins"]=[defaultPluginDescriptor]}else if(angular.isUndefined(newValue["value"]["output_plugins"]))hra["value"]["output_plugins"]=[];if(angular.isUndefined(hra["value"]["client_rule_set"]))hra["value"]["client_rule_set"]=angular.copy(this.descriptors_["ForemanClientRuleSet"]["default"])};FormController.prototype.sendRequest=function(){this.grrApiService_.post("/hunts",stripTypeInfo(this.scope_["createHuntArgs"])).then(function resolve(response){this.serverResponse=
response}.bind(this),function reject(response){this.serverResponse=response;this.serverResponse["error"]=true}.bind(this))};FormController.prototype.resolve=function(){var onResolve=this.scope_["onResolve"];if(onResolve&&this.serverResponse){var huntId=this.serverResponse["data"]["value"]["hunt_id"]["value"];onResolve({huntId:huntId})}};exports.FormDirective=function(){return{scope:{createHuntArgs:"=?",onResolve:"&",onReject:"&"},restrict:"E",templateUrl:"/static/angular-components/hunt/new-hunt-wizard/form.html",
controller:FormController,controllerAs:"controller"}};exports.FormDirective.directive_name="grrNewHuntWizardForm";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.newCronJobWizard.formDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var247=goog.require("grrUi.hunt.newHuntWizard.formDirective");var DEFAULT_PLUGIN_URL=$jscomp$destructuring$var247.DEFAULT_PLUGIN_URL;var FormController=function($scope,grrReflectionService,grrApiService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.grrApiService_=grrApiService;this.descriptors_={};this.defaultOutputPluginName;
this.grrApiService_.get(DEFAULT_PLUGIN_URL).then(function(response){if(angular.isDefined(response["data"]["value"]))this.defaultOutputPluginName=response["data"]["value"]["value"];return this.grrReflectionService_.getRDFValueDescriptor("CreateGenericHuntFlowArgs",true)}.bind(this)).then(function(descriptors){angular.extend(this.descriptors_,descriptors);return this.grrReflectionService_.getRDFValueDescriptor("ApiCronJob",true)}.bind(this)).then(function(descriptors){angular.extend(this.descriptors_,
descriptors);this.scope_.$watch("cronJob",this.onCronJobChange_.bind(this))}.bind(this));this.scope_.$watch("cronJob.value.flow_args.value.hunt_args",function(newValue){this.genericHuntArgs=newValue}.bind(this));this.scope_.$watch("cronJob.value.flow_args.value.hunt_runner_args",function(newValue){this.huntRunnerArgs=newValue}.bind(this));this.scope_.$watch("cronJob.value.description.value",this.onCronJobDescriptionChange_.bind(this))};FormController.prototype.onCronJobDescriptionChange_=function(newValue,
oldValue){if(newValue&&this.huntRunnerArgs){oldValue=oldValue||"";var huntDescription;if(angular.isDefined(this.huntRunnerArgs.value.description))huntDescription=this.huntRunnerArgs.value.description.value;var cronSuffix=" (cron)";if(angular.isUndefined(huntDescription)||huntDescription==oldValue+cronSuffix)this.huntRunnerArgs.value.description={type:"RDFString",value:newValue+cronSuffix}}};FormController.prototype.onCronJobChange_=function(newValue){if(angular.isUndefined(newValue))newValue=this.scope_["cronJob"]=
angular.copy(this.descriptors_["ApiCronJob"]["default"]);newValue["value"]["flow_name"]={type:"RDFString",value:"CreateAndRunGenericHuntFlow"};if(angular.isUndefined(newValue["value"]["periodicity"]))newValue["value"]["periodicity"]={type:"Duration",value:60*60*24*7};if(angular.isUndefined(newValue["value"]["lifetime"]))newValue["value"]["lifetime"]={type:"Duration",value:60*60*1};if(angular.isUndefined(newValue["value"]["flow_args"]))newValue["value"]["flow_args"]=angular.copy(this.descriptors_["CreateGenericHuntFlowArgs"]["default"]);
var createHuntFlowArgs=newValue["value"]["flow_args"]["value"];if(angular.isUndefined(createHuntFlowArgs["hunt_args"]))createHuntFlowArgs["hunt_args"]=angular.copy(this.descriptors_["GenericHuntArgs"]["default"]);var huntArgs=createHuntFlowArgs["hunt_args"]["value"];if(angular.isUndefined(huntArgs["flow_runner_args"]))huntArgs["flow_runner_args"]=angular.copy(this.descriptors_["FlowRunnerArgs"]["default"]);if(angular.isUndefined(huntArgs["flow_runner_args"]["value"]["flow_name"]))huntArgs["flow_runner_args"]["value"]["flow_name"]=
angular.copy(this.descriptors_["RDFString"]["default"]);if(angular.isUndefined(createHuntFlowArgs["hunt_runner_args"]))createHuntFlowArgs["hunt_runner_args"]=angular.copy(this.descriptors_["HuntRunnerArgs"]["default"]);var huntRunnerArgs=createHuntFlowArgs["hunt_runner_args"]["value"];if(angular.isUndefined(huntRunnerArgs["client_rule_set"]))huntRunnerArgs["client_rule_set"]=angular.copy(this.descriptors_["ForemanClientRuleSet"]["default"]);if(angular.isUndefined(huntRunnerArgs["output_plugins"]))if(this.defaultOutputPluginName){var defaultPluginDescriptor=
angular.copy(this.descriptors_["OutputPluginDescriptor"]["default"]);defaultPluginDescriptor["value"]["plugin_name"]=angular.copy(this.descriptors_["RDFString"]["default"]);defaultPluginDescriptor["value"]["plugin_name"]["value"]=this.defaultOutputPluginName;huntRunnerArgs["output_plugins"]=[defaultPluginDescriptor]}else huntRunnerArgs["output_plugins"]=[]};FormController.prototype.sendRequest=function(){this.grrApiService_.post("/cron-jobs",this.scope_["cronJob"],true).then(function resolve(response){this.serverResponse=
response;this.scope_["cronJob"]=response["data"]}.bind(this),function reject(response){this.serverResponse=response;this.serverResponse["error"]=true}.bind(this))};exports.FormDirective=function(){return{scope:{cronJob:"=?",onResolve:"&",onReject:"&"},restrict:"E",templateUrl:"/static/angular-components/cron/new-cron-job-wizard/"+"form.html",controller:FormController,controllerAs:"controller"}};exports.FormDirective.directive_name="grrNewCronJobWizardForm";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.newCronJobWizard.reviewPageDirective");goog.module.declareLegacyNamespace();exports.ReviewPageDirective=function(){return{scope:{cronJob:"="},restrict:"E",templateUrl:"/static/angular-components/cron/new-cron-job-wizard/"+"review-page.html",controllerAs:"controller"}};exports.ReviewPageDirective.directive_name="grrNewCronJobReviewPage";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.newCronJobWizard.statusPageDirective");goog.module.declareLegacyNamespace();exports.StatusPageDirective=function(){return{scope:{response:"="},restrict:"E",templateUrl:"/static/angular-components/cron/new-cron-job-wizard/"+"status-page.html"}};exports.StatusPageDirective.directive_name="grrNewCronJobStatusPage";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.newCronJobWizard.newCronJobWizard");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var248=goog.require("grrUi.cron.newCronJobWizard.configureSchedulePageDirective");var ConfigureSchedulePageDirective=$jscomp$destructuring$var248.ConfigureSchedulePageDirective;var $jscomp$destructuring$var249=goog.require("grrUi.cron.newCronJobWizard.formDirective");var FormDirective=$jscomp$destructuring$var249.FormDirective;var $jscomp$destructuring$var250=
goog.require("grrUi.cron.newCronJobWizard.reviewPageDirective");var ReviewPageDirective=$jscomp$destructuring$var250.ReviewPageDirective;var $jscomp$destructuring$var251=goog.require("grrUi.cron.newCronJobWizard.statusPageDirective");var StatusPageDirective=$jscomp$destructuring$var251.StatusPageDirective;var $jscomp$destructuring$var252=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var252.coreModule;exports.newCronJobWizardModule=angular.module("grrUi.cron.newCronJobWizard",
["ui.bootstrap",coreModule.name]);exports.newCronJobWizardModule.directive(FormDirective.directive_name,FormDirective);exports.newCronJobWizardModule.directive(ReviewPageDirective.directive_name,ReviewPageDirective);exports.newCronJobWizardModule.directive(StatusPageDirective.directive_name,StatusPageDirective);exports.newCronJobWizardModule.directive(ConfigureSchedulePageDirective.directive_name,ConfigureSchedulePageDirective);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.cron.cron");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var253=goog.require("grrUi.cron.cronJobFlowsListDirective");var CronJobFlowsListDirective=$jscomp$destructuring$var253.CronJobFlowsListDirective;var $jscomp$destructuring$var254=goog.require("grrUi.cron.cronJobInspectorDirective");var CronJobInspectorDirective=$jscomp$destructuring$var254.CronJobInspectorDirective;var $jscomp$destructuring$var255=goog.require("grrUi.cron.cronJobOverviewDirective");
var CronJobOverviewDirective=$jscomp$destructuring$var255.CronJobOverviewDirective;var $jscomp$destructuring$var256=goog.require("grrUi.cron.cronJobStatusIconDirective");var CronJobStatusIconDirective=$jscomp$destructuring$var256.CronJobStatusIconDirective;var $jscomp$destructuring$var257=goog.require("grrUi.cron.cronJobsListDirective");var CronJobsListDirective=$jscomp$destructuring$var257.CronJobsListDirective;var $jscomp$destructuring$var258=goog.require("grrUi.cron.cronViewDirective");var CronViewDirective=
$jscomp$destructuring$var258.CronViewDirective;var $jscomp$destructuring$var259=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var259.coreModule;var $jscomp$destructuring$var260=goog.require("grrUi.cron.newCronJobWizard.newCronJobWizard");var newCronJobWizardModule=$jscomp$destructuring$var260.newCronJobWizardModule;exports.cronModule=angular.module("grrUi.cron",[coreModule.name,newCronJobWizardModule.name]);exports.cronModule.directive(CronJobFlowsListDirective.directive_name,
CronJobFlowsListDirective);exports.cronModule.directive(CronJobInspectorDirective.directive_name,CronJobInspectorDirective);exports.cronModule.directive(CronJobsListDirective.directive_name,CronJobsListDirective);exports.cronModule.directive(CronJobOverviewDirective.directive_name,CronJobOverviewDirective);exports.cronModule.directive(CronJobStatusIconDirective.directive_name,CronJobStatusIconDirective);exports.cronModule.directive(CronViewDirective.directive_name,CronViewDirective);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.docs.apiDescriptionDirective");goog.module.declareLegacyNamespace();var ApiDescriptionController=function($scope){this.scope_=$scope;this.paragraphs=[];this.scope_.$watch("::value",this.onValueChange.bind(this))};ApiDescriptionController.prototype.onValueChange=function(newValue){if(angular.isString(newValue))this.paragraphs=newValue.split("\n\n")};exports.ApiDescriptionDirective=function(){return{scope:{value:"="},restrict:"E",templateUrl:"/static/angular-components/docs/api-description.html",
controller:ApiDescriptionController,controllerAs:"controller"}};exports.ApiDescriptionDirective.directive_name="grrApiDescription";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.docs.apiDocsDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var261=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var261.ApiService;var stripTypeInfo=$jscomp$destructuring$var261.stripTypeInfo;var ApiDocsController=function($element,$http,grrApiService){this.element_=$element;this.http_=$http;this.grrApiService_=grrApiService;this.apiMethodsByCategory;this.examplesByMethod;this.categories;
this.visibleCategory;this.grrApiService_.get("reflection/api-methods").then(this.onApiMethodsListFetched_.bind(this));this.http_.get("/static/angular-components/docs/api-docs-examples.json").then(this.onExamplesFetched_.bind(this))};ApiDocsController.prototype.onApiMethodsListFetched_=function(response){var categoriesDict={};var items=stripTypeInfo(response["data"]["items"]);angular.forEach(items,function(descriptor){var category=descriptor["category"];if(!category)category="Other";if(categoriesDict[category]===
undefined)categoriesDict[category]=[];categoriesDict[category].push(descriptor)}.bind(this));angular.forEach(categoriesDict,function(descriptors){descriptors.sort(function(a,b){var astr=a["name"]+"_"+a["http_route"];var bstr=b["name"]+"_"+b["http_route"];if(astr>bstr)return 1;else if(astr<bstr)return-1;else return 0})}.bind(this));this.apiMethodsByCategory=categoriesDict;this.categories=Object.keys(categoriesDict).sort();this.visibleCategory=this.categories[0]};ApiDocsController.prototype.onExamplesFetched_=
function(response){this.examplesByMethod={};angular.forEach(response.data,function(handlerExamples){angular.forEach(handlerExamples,function(example){var apiMethod=example["api_method"];if(!this.examplesByMethod[apiMethod])this.examplesByMethod[apiMethod]=[];this.examplesByMethod[apiMethod].push(example)}.bind(this))}.bind(this))};ApiDocsController.prototype.onCategoryLinkClick=function(category){var index=this.categories.indexOf(category);var headingElement=$("#docs-category-"+index.toString());
var scrollableContainer=headingElement.parent();while(scrollableContainer.length!=0){if(scrollableContainer.scrollTop()>0||Math.abs(scrollableContainer[0].clientHeight-scrollableContainer[0].scrollHeight)>1){var offset=headingElement.offset()["top"]-scrollableContainer.offset()["top"]+scrollableContainer.scrollTop();var prevOffset=scrollableContainer.scrollTop();scrollableContainer.scrollTop(offset);if(scrollableContainer.scrollTop()!=prevOffset||Math.abs(prevOffset-offset)<=1)break}scrollableContainer=
scrollableContainer.parent()}};exports.ApiDocsDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/docs/api-docs.html",controller:ApiDocsController,controllerAs:"controller"}};exports.ApiDocsDirective.directive_name="grrApiDocs";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.docs.apiHelperCurlService");goog.module.declareLegacyNamespace();exports.ApiHelperCurlService=function($q,$window){this.q_=$q;this.window_=$window};var ApiHelperCurlService=exports.ApiHelperCurlService;ApiHelperCurlService.service_name="grrApiHelperCurlService";ApiHelperCurlService.prototype.buildStartFlow=function(clientId,createFlowJson){var deferred=this.q_.defer();var result="CSRFTOKEN=`curl "+this.window_.location.origin+" -o /dev/null -s -c - | grep csrftoken  | cut -f 7`; \\\n\t"+
'curl -X POST -H "Content-Type: application/json" '+'-H "X-CSRFToken: $CSRFTOKEN" \\\n\t'+this.window_.location.origin+"/api/v2/clients/"+clientId+"/flows -d @- << EOF\n";result+=JSON.stringify(createFlowJson,null,2);result+="\nEOF";deferred.resolve(result);return deferred.promise};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.docs.apiHelperService");goog.module.declareLegacyNamespace();exports.ApiHelperService=function($q,grrApiService){this.q_=$q;this.grrApiService_=grrApiService;this.helperTuples_=[]};var ApiHelperService=exports.ApiHelperService;ApiHelperService.service_name="grrApiHelperService";ApiHelperService.prototype.clear=function(){this.helperTuples_=[]};ApiHelperService.prototype.registerHelper=function(type,webAuthType,helper){this.helperTuples_.push([type,
webAuthType,helper])};ApiHelperService.prototype.buildStartFlow_=function(webAuthType,clientId,createFlowJson){var helpersByType={};for(var i=0;i<this.helperTuples_.length;++i){var helperTuple=this.helperTuples_[i];var helperType=helperTuple[0];var helperWebAuthType=helperTuple[1];if(!helpersByType[helperType]&&!helperWebAuthType||helperWebAuthType==webAuthType)helpersByType[helperType]=helperTuple}var result={};var promises=[];angular.forEach(helpersByType,function(helperTuple,key){var helperWebAuthType=
helperTuple[1];var helper=helperTuple[2];var promise=helper["buildStartFlow"](clientId,createFlowJson).then(function(data){result[key]={webAuthType:helperWebAuthType,data:data}}.bind(this));promises.push(promise)}.bind(this));return this.q_.all(promises).then(function(){return result}.bind(this))};ApiHelperService.prototype.buildStartFlow=function(clientId,createFlowJson){return this.grrApiService_.getCached("/config/AdminUI.webauth_manager").then(function(response){var webAuthType=response["data"]["value"]["value"];
return this.buildStartFlow_(webAuthType,clientId,createFlowJson)}.bind(this))};return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.docs.apiQuerySpecDirective");goog.module.declareLegacyNamespace();var ApiQuerySpecController=function($scope,grrReflectionService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.descriptorFields;this.descriptorsCache;this.typeHints={"RDFDatetime":"Time since epoch in microseconds.","RDFBool":"Either 1 or 0.","RDFURN":'Path string with components separated by "/", i.e. '+'"foo/bar/blah".'};this.scope_.$watch("argsType",
this.onArgsTypeChange.bind(this))};ApiQuerySpecController.prototype.onArgsTypeChange=function(newValue){this.argsDescriptor=null;if(angular.isString(newValue))this.grrReflectionService_.getRDFValueDescriptor(newValue,true).then(function(result){this.descriptorFields=[];angular.forEach(result[newValue]["fields"],function(field){if(field.name!=="additional_args")this.descriptorFields.push(field)}.bind(this));this.descriptorsCache=result}.bind(this))};exports.ApiQuerySpecDirective=function(){return{scope:{argsType:"=",
prefix:"=",noHeader:"@"},restrict:"E",templateUrl:"/static/angular-components/docs/api-query-spec.html",controller:ApiQuerySpecController,controllerAs:"controller"}};exports.ApiQuerySpecDirective.directive_name="grrApiQuerySpec";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.docs.apiRouteDirective");goog.module.declareLegacyNamespace();var RouteComponent;var ApiRouteController=function($scope){this.scope_=$scope;this.routeComponents;this.queryParameters;this.hasQueryParameters;this.scope_.$watch("::value",this.onValueChange.bind(this))};ApiRouteController.prototype.onValueChange=function(){var routeComponents=this.routeComponents=[];var queryParameters=this.queryParameters={};if(angular.isString(this.scope_.value)){var route=
this.scope_.value;var questionMarkIndex=route.indexOf("?");if(questionMarkIndex!=-1){var queryParamString=route.substring(questionMarkIndex+1,route.length);route=route.substring(0,questionMarkIndex);var vars=queryParamString.split("&");angular.forEach(vars,function(variable){var pair=variable.split("=");if(pair.length==2)queryParameters[pair[0]]=pair[1];else queryParameters[pair[0]]=null})}var components=route.split("/");angular.forEach(components,function(component){if(component.length>0)if(component[0]===
"<"){component=component.substring(1,component.length-1);var componentParts=component.split(":");var componentType,componentValue;if(componentParts.length===1){componentType="string";componentValue=componentParts[0]}else{componentType=componentParts[0];componentValue=componentParts[1]}routeComponents.push({type:componentType,value:componentValue})}else routeComponents.push({value:component})}.bind(this))}this.hasQueryParameters=Object.keys(queryParameters).length>0};exports.ApiRouteDirective=function(){return{scope:{value:"="},
restrict:"E",templateUrl:"/static/angular-components/docs/api-route.html",controller:ApiRouteController,controllerAs:"controller"}};exports.ApiRouteDirective.directive_name="grrApiRoute";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.docs.docs");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var262=goog.require("grrUi.docs.apiDescriptionDirective");var ApiDescriptionDirective=$jscomp$destructuring$var262.ApiDescriptionDirective;var $jscomp$destructuring$var263=goog.require("grrUi.docs.apiDocsDirective");var ApiDocsDirective=$jscomp$destructuring$var263.ApiDocsDirective;var $jscomp$destructuring$var264=goog.require("grrUi.docs.apiHelperCurlService");
var ApiHelperCurlService=$jscomp$destructuring$var264.ApiHelperCurlService;var $jscomp$destructuring$var265=goog.require("grrUi.docs.apiHelperService");var ApiHelperService=$jscomp$destructuring$var265.ApiHelperService;var $jscomp$destructuring$var266=goog.require("grrUi.docs.apiQuerySpecDirective");var ApiQuerySpecDirective=$jscomp$destructuring$var266.ApiQuerySpecDirective;var $jscomp$destructuring$var267=goog.require("grrUi.docs.apiRouteDirective");var ApiRouteDirective=$jscomp$destructuring$var267.ApiRouteDirective;
var $jscomp$destructuring$var268=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var268.coreModule;exports.docsModule=angular.module("grrUi.docs",[coreModule.name]);exports.docsModule.directive(ApiDescriptionDirective.directive_name,ApiDescriptionDirective);exports.docsModule.directive(ApiDocsDirective.directive_name,ApiDocsDirective);exports.docsModule.directive(ApiRouteDirective.directive_name,ApiRouteDirective);exports.docsModule.directive(ApiQuerySpecDirective.directive_name,
ApiQuerySpecDirective);exports.docsModule.service(ApiHelperService.service_name,ApiHelperService);exports.docsModule.service(ApiHelperCurlService.service_name,ApiHelperCurlService);exports.docsModule.run(function(grrApiHelperService,grrApiHelperCurlService){grrApiHelperService.registerHelper("HTTP",null,grrApiHelperCurlService)});return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.clientFlowsListDirective");goog.module.declareLegacyNamespace();var ClientFlowsListController=function($scope,$timeout,$uibModal,grrApiService,grrRoutingService){this.scope_=$scope;this.timeout_=$timeout;this.uibModal_=$uibModal;this.grrApiService_=grrApiService;this.grrRoutingService_=grrRoutingService;this.flowsUrl;this.triggerUpdate;this.scope_.$watch("clientId",this.onClientIdChange_.bind(this))};ClientFlowsListController.prototype.onClientIdChange_=
function(newValue){if(angular.isString(newValue)){var components=newValue.split("/");var basename=components[components.length-1];this.flowsUrl="/clients/"+basename+"/flows"}else this.flowsUrl=null};ClientFlowsListController.prototype.cancelButtonClicked=function(){var cancelUrl=[this.flowsUrl,this.scope_["selectedFlowId"],"actions/cancel"].join("/");this.grrApiService_.post(cancelUrl,{}).then(function(){this.triggerUpdate();var flowId=this.scope_["selectedFlowId"];this.scope_["selectedFlowId"]=undefined;
this.timeout_(function(){this.scope_["selectedFlowId"]=flowId}.bind(this),0)}.bind(this))};ClientFlowsListController.prototype.createHuntFromFlow=function(){var huntId;var modalScope=this.scope_.$new();modalScope["clientId"]=this.scope_["clientId"];modalScope["flowId"]=this.scope_["selectedFlowId"];modalScope["resolve"]=function(newHuntId){huntId=newHuntId;modalInstance.close()}.bind(this);modalScope["reject"]=function(){modalInstance.dismiss()}.bind(this);this.scope_.$on("$destroy",function(){modalScope.$destroy()});
var modalInstance=this.uibModal_.open({template:'<grr-new-hunt-wizard-create-from-flow-form on-resolve="resolve(huntId)" '+'on-reject="reject()" flow-id="flowId" client-id="clientId" />',scope:modalScope,windowClass:"wide-modal high-modal",size:"lg"});modalInstance.result.then(function resolve(){this.grrRoutingService_.go("hunts",{huntId:huntId})}.bind(this))};ClientFlowsListController.prototype.copyFlow=function(){var newFlowId;var modalScope=this.scope_.$new();modalScope["clientId"]=this.scope_["clientId"];
modalScope["flowId"]=this.scope_["selectedFlowId"];modalScope["resolve"]=function(newFlowObj){newFlowId=newFlowObj["value"]["flow_id"]["value"];modalInstance.close()}.bind(this);this.scope_.$on("$destroy",function(){modalScope.$destroy()});var modalInstance=this.uibModal_.open({template:'<grr-copy-flow-form on-resolve="resolve(flow)" '+'flow-id="flowId" client-id="clientId" />',scope:modalScope,windowClass:"wide-modal high-modal",size:"lg"});modalInstance.result.then(function resolve(){if(angular.isDefined(newFlowId)){this.grrRoutingService_.go("client.flows",
{flowId:newFlowId});this.triggerUpdate()}}.bind(this))};exports.ClientFlowsListDirective=function(){return{scope:{clientId:"=",selectedFlowId:"=?"},restrict:"E",templateUrl:"/static/angular-components/flow/client-flows-list.html",controller:ClientFlowsListController,controllerAs:"controller"}};exports.ClientFlowsListDirective.directive_name="grrClientFlowsList";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.clientFlowsViewDirective");goog.module.declareLegacyNamespace();var ClientFlowsViewController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.clientId;this.selectedFlowId;this.tab;this.flowApiBasePath;this.scope_.$watchGroup(["controller.selectedFlowId","controller.tab"],this.onSelectionOrTabChange_.bind(this));this.grrRoutingService_.uiOnParamsChanged(this.scope_,["clientId",
"flowId","tab"],this.onRoutingParamsChange_.bind(this))};ClientFlowsViewController.prototype.onRoutingParamsChange_=function(unused_newValues,opt_stateParams){this.clientId=opt_stateParams["clientId"];this.selectedFlowId=opt_stateParams["flowId"];this.tab=opt_stateParams["tab"];this.flowApiBasePath=["clients",this.clientId,"flows"].join("/")};ClientFlowsViewController.prototype.onSelectionOrTabChange_=function(){if(angular.isDefined(this.selectedFlowId))this.grrRoutingService_.go("client.flows",{flowId:this.selectedFlowId,
tab:this.tab})};exports.ClientFlowsViewDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/flow/client-flows-view.html",controller:ClientFlowsViewController,controllerAs:"controller"}};exports.ClientFlowsViewDirective.directive_name="grrClientFlowsView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.copyFlowFormDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var269=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var269.ApiService;var stripTypeInfo=$jscomp$destructuring$var269.stripTypeInfo;var CopyFlowFormController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.flow;this.flowFormHasErrors;this.scope_.$watchGroup(["flowId","clientId"],
this.onFlowIdClientIdChange_.bind(this))};CopyFlowFormController.prototype.onFlowIdClientIdChange_=function(newValues){if(newValues.every(angular.isDefined)){var flowUrl=["clients",this.scope_["clientId"],"flows",this.scope_["flowId"]].join("/");this.grrApiService_.get(flowUrl).then(function(response){this.flow=response["data"]}.bind(this))}};CopyFlowFormController.prototype.proceed=function(){var strippedFlow=stripTypeInfo(this.flow);return this.grrApiService_.post("clients/"+this.scope_["clientId"]+
"/flows",{flow:{runner_args:strippedFlow["runner_args"],args:strippedFlow["args"]},original_flow:{flow_id:this.scope_["flowId"],client_id:this.scope_["clientId"]}}).then(function success(response){this.scope_["onResolve"]({"flow":response["data"]});return"Flow was successfully launched!"}.bind(this),function failure(response){var e=response["data"]["message"]||"Unknown error";throw e;}.bind(this))};exports.CopyFlowFormDirective=function(){return{scope:{flowId:"=",clientId:"=",onResolve:"&"},restrict:"E",
templateUrl:"/static/angular-components/flow/copy-flow-form.html",controller:CopyFlowFormController,controllerAs:"controller"}};exports.CopyFlowFormDirective.directive_name="grrCopyFlowForm";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowApiHelperDirective");goog.module.declareLegacyNamespace();var FlowApiHelperController=function($scope,grrApiService,grrApiHelperService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrApiHelperService_=grrApiHelperService;this.clientId;this.result;this.scope_.$watchGroup(["flowId","apiBasePath"],this.onFlowIdOrBasePathChange_.bind(this))};FlowApiHelperController.prototype.onFlowIdOrBasePathChange_=function(newValues){this.flow=
null;this.result=null;if(newValues.every(angular.isDefined)){var flowUrl=this.scope_["apiBasePath"]+"/"+this.scope_["flowId"];this.grrApiService_.getV2(flowUrl).then(function(response){var flow={args:response.data["args"],name:response.data["name"]};if(response.data["runnerArgs"]&&response.data["runnerArgs"]["outputPlugins"])flow["runnerArgs"]={outputPlugins:response.data["runnerArgs"]["outputPlugins"]};var createFlow={flow:flow};this.grrApiHelperService_.buildStartFlow(this.clientId,createFlow).then(function(result){this.result=
result}.bind(this))}.bind(this))}};exports.FlowApiHelperDirective=function(){return{scope:{flowId:"=",apiBasePath:"="},require:"?^grrClientContext",restrict:"E",templateUrl:"/static/angular-components/flow/flow-api-helper.html",controller:FlowApiHelperController,controllerAs:"controller",link:function(scope,element,attrs,grrClientContextCtrl){if(grrClientContextCtrl)scope["controller"].clientId=grrClientContextCtrl.clientId}}};exports.FlowApiHelperDirective.directive_name="grrFlowApiHelper";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowDescriptorsTreeDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var270=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var270.ApiService;var stripTypeInfo=$jscomp$destructuring$var270.stripTypeInfo;var FlowDescriptorsTreeController=function($scope,$element,grrApiService){this.scope_=$scope;this.element_=$element;this.grrApiService_=grrApiService;this.flowsDescriptors;this.userSettings;
this.grrApiService_.get("/users/me").then(function(response){this.userSettings=response.data["value"]["settings"]}.bind(this));this.grrApiService_.get("/flows/descriptors").then(function(response){this.flowsDescriptors=this.groupDescriptorsByCategory_(response["data"]["items"])}.bind(this));this.scope_.$watchGroup(["controller.userSettings","controller.flowsDescriptors"],this.onDescriptorsOrSettingsChange_.bind(this))};FlowDescriptorsTreeController.prototype.groupDescriptorsByCategory_=function(items){var result=
{};angular.forEach(items,function(item){var category=item["value"]["category"]["value"];result[category]=result[category]||[];result[category].push(item)}.bind(this));return result};FlowDescriptorsTreeController.prototype.onDescriptorsOrSettingsChange_=function(){if(angular.isUndefined(this.flowsDescriptors)||angular.isUndefined(this.userSettings))return;var mode=this.scope_.$eval("controller.userSettings.value.mode.value");if(angular.isUndefined(mode))mode="BASIC";var treeNodes=[];var descriptorsKeys=
Object.keys(this.flowsDescriptors).sort();angular.forEach(descriptorsKeys,function(category){var categoryNode={text:category,li_attr:{id:"_"+category},children:[]};var descriptors=this.flowsDescriptors[category].sort(function(a,b){a=stripTypeInfo(a);b=stripTypeInfo(b);var aName=a["friendly_name"]||a["name"];var bName=b["friendly_name"]||b["name"];if(aName<bName)return-1;else if(aName>bName)return 1;else return 0});angular.forEach(descriptors,function(descriptor){var strippedDescriptor=stripTypeInfo(descriptor);
if(mode=="DEBUG"||strippedDescriptor["behaviours"].indexOf(mode)!=-1)categoryNode["children"].push({data:{descriptor:descriptor},li_attr:{id:"_"+category+"-"+strippedDescriptor["name"]},text:strippedDescriptor["friendly_name"]||strippedDescriptor["name"],icon:"file"})}.bind(this));treeNodes.push(categoryNode)}.bind(this));var treeElem=$(this.element_).children("div.tree");treeElem.jstree({"core":{"data":treeNodes}});treeElem.on("select_node.jstree",function(e,data){data["instance"]["toggle_node"](data["node"]);
if(data.node.data!==null){var descriptor=data.node.data.descriptor;this.scope_.$apply(function(){this.scope_.selectedDescriptor=descriptor}.bind(this))}}.bind(this))};exports.FlowDescriptorsTreeDirective=function(){return{scope:{selectedDescriptor:"=?"},restrict:"E",template:'<div class="tree"></div>',controller:FlowDescriptorsTreeController,controllerAs:"controller"}};exports.FlowDescriptorsTreeDirective.directive_name="grrFlowDescriptorsTree";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.forms.utils");goog.module.declareLegacyNamespace();exports.valueHasErrors=function(value){if(!angular.isObject(value))return false;if(value["validationError"])return true;if(angular.isArray(value)){var alen=value.length;for(var i=0;i<alen;++i)if(valueHasErrors(value[i]))return true;return false}if(angular.isObject(value["value"])){var nestedValue=value["value"];for(var k in nestedValue)if(valueHasErrors(nestedValue[k]))return true}return false};
var valueHasErrors=exports.valueHasErrors;return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowFormDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var271=goog.require("grrUi.forms.utils");var valueHasErrors=$jscomp$destructuring$var271.valueHasErrors;var FlowFormController=function($scope,grrReflectionService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.outputPluginsField;this.outputPluginDescriptor;this.grrReflectionService_.getRDFValueDescriptor("FlowRunnerArgs").then(function(descriptor){angular.forEach(descriptor["fields"],
function(field){if(field.name=="output_plugins")this.outputPluginsField=field}.bind(this));return this.grrReflectionService_.getRDFValueDescriptor("OutputPluginDescriptor")}.bind(this)).then(function(descriptor){this.outputPluginDescriptor=descriptor}.bind(this));this.scope_.$watch("flowRunnerArgs.value.output_plugins",this.onOutputPluginsChanged_.bind(this));this.scope_.$watch(function(){return[this.scope_["flowArgs"],this.scope_["flowRunnerArgs"]]}.bind(this),this.onArgsDeepChange_.bind(this),true)};
FlowFormController.prototype.onArgsDeepChange_=function(){this.scope_["hasErrors"]=valueHasErrors(this.scope_["flowArgs"])||valueHasErrors(this.scope_["flowRunnerArgs"])};FlowFormController.prototype.onOutputPluginsChanged_=function(newValue){if(!this.scope_["withOutputPlugins"])return;var flowRunnerArgs=this.scope_["flowRunnerArgs"];if(angular.isUndefined(newValue)&&angular.isDefined(flowRunnerArgs))flowRunnerArgs["value"]["output_plugins"]=[]};exports.FlowFormDirective=function(){return{scope:{flowArgs:"=",
flowRunnerArgs:"=",withOutputPlugins:"=",hasErrors:"=?"},restrict:"E",templateUrl:"/static/angular-components/flow/flow-form.html",controller:FlowFormController,controllerAs:"controller"}};exports.FlowFormDirective.directive_name="grrFlowForm";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowInfoDirective");goog.module.declareLegacyNamespace();var FlowInfoController=function($scope){this.scope_=$scope};exports.FlowInfoDirective=function(){return{scope:{descriptor:"="},restrict:"E",templateUrl:"/static/angular-components/flow/flow-info.html",controller:FlowInfoController,controllerAs:"controller"}};exports.FlowInfoDirective.directive_name="grrFlowInfo";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowInspectorDirective");goog.module.declareLegacyNamespace();var FlowInspectorController=function($scope){this.scope_=$scope;this.activeTab="";this.tabsShown={};this.scope_.$watch("activeTab",this.onDirectiveArgumentsChange_.bind(this));this.scope_.$watch("controller.activeTab",this.onTabChange_.bind(this))};FlowInspectorController.prototype.onDirectiveArgumentsChange_=function(newValue){if(angular.isString(newValue))this.activeTab=
newValue};FlowInspectorController.prototype.onTabChange_=function(newValue,oldValue){if(newValue!==oldValue)this.scope_["activeTab"]=newValue;this.tabsShown[newValue]=true};exports.FlowInspectorDirective=function(){return{scope:{flowId:"=",apiBasePath:"=",activeTab:"=?"},controller:FlowInspectorController,controllerAs:"controller",restrict:"E",templateUrl:"/static/angular-components/flow/flow-inspector.html"}};exports.FlowInspectorDirective.directive_name="grrFlowInspector";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowLogDirective");goog.module.declareLegacyNamespace();var AUTO_REFRESH_INTERVAL_MS=20*1E3;exports.setAutoRefreshInterval=function(millis){AUTO_REFRESH_INTERVAL_MS=millis};var FlowLogController=function($scope){this.scope_=$scope;this.logsUrl;this.autoRefreshInterval=AUTO_REFRESH_INTERVAL_MS;this.scope_.$watchGroup(["flowId","apiBasePath"],this.onFlowIdOrBasePathChange_.bind(this))};FlowLogController.prototype.onFlowIdOrBasePathChange_=
function(newValue){if(angular.isDefined(this.scope_["flowId"])&&angular.isDefined(this.scope_["apiBasePath"]))this.logsUrl=[this.scope_["apiBasePath"],this.scope_["flowId"],"log"].join("/")};exports.FlowLogDirective=function(){return{scope:{flowId:"=",apiBasePath:"="},restrict:"E",templateUrl:"/static/angular-components/flow/flow-log.html",controller:FlowLogController,controllerAs:"controller"}};exports.FlowLogDirective.directive_name="grrFlowLog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowOverviewDirective");goog.module.declareLegacyNamespace();var AUTO_REFRESH_INTERVAL_MS=15*1E3;exports.setAutoRefreshInterval=function(millis){AUTO_REFRESH_INTERVAL_MS=millis};var FlowOverviewController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.flow;this.pollPromise_;this.scope_.$on("$destroy",function(){this.grrApiService_.cancelPoll(this.pollPromise_)}.bind(this));this.scope_.$watchGroup(["flowId",
"apiBasePath"],this.startPolling.bind(this))};FlowOverviewController.prototype.startPolling=function(){this.grrApiService_.cancelPoll(this.pollPromise_);this.pollPromise_=undefined;if(angular.isDefined(this.scope_["apiBasePath"])&&angular.isDefined(this.scope_["flowId"])){var flowUrl=this.scope_["apiBasePath"]+"/"+this.scope_["flowId"];var interval=AUTO_REFRESH_INTERVAL_MS;this.pollPromise_=this.grrApiService_.poll(flowUrl,interval);this.pollPromise_.then(undefined,undefined,function notify(response){this.flow=
response["data"]}.bind(this))}};exports.FlowOverviewDirective=function(){return{scope:{flowId:"=",apiBasePath:"="},restrict:"E",templateUrl:"/static/angular-components/flow/flow-overview.html",controller:FlowOverviewController,controllerAs:"controller"}};exports.FlowOverviewDirective.directive_name="grrFlowOverview";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowRequestsDirective");goog.module.declareLegacyNamespace();var FlowRequestsController=function($scope){this.scope_=$scope;this.requestsUrl;this.scope_.$watchGroup(["flowId","apiBasePath"],this.onFlowIdOrBasePathChange_.bind(this))};FlowRequestsController.prototype.onFlowIdOrBasePathChange_=function(newValues){if(newValues.every(angular.isDefined))this.requestsUrl=[this.scope_["apiBasePath"],this.scope_["flowId"],"requests"].join("/")};
exports.FlowRequestsDirective=function(){return{scope:{flowId:"=",apiBasePath:"="},restrict:"E",templateUrl:"/static/angular-components/flow/flow-requests.html",controller:FlowRequestsController,controllerAs:"controller"}};exports.FlowRequestsDirective.directive_name="grrFlowRequests";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowResultsDirective");goog.module.declareLegacyNamespace();var FlowResultsController=function($scope){this.scope_=$scope;this.flowResultsUrl;this.flowExportedResultsUrl;this.outputPluginsMetadataUrl;this.downloadFilesUrl;this.exportCommand;this.scope_.$watchGroup(["flowId","apiBasePath"],this.onFlowIdOrBasePathChange_.bind(this))};FlowResultsController.prototype.onFlowIdOrBasePathChange_=function(newValues){this.flowResultsUrl=
this.outputPluginsMetadataUrl=this.downloadFilesUrl=null;if(newValues.every(angular.isDefined)){var flowUrl=this.scope_["apiBasePath"]+"/"+this.scope_["flowId"];this.flowResultsUrl=flowUrl+"/results";this.flowExportedResultsUrl=flowUrl+"/exported-results";this.outputPluginsUrl=flowUrl+"/output-plugins";this.exportCommandUrl=flowUrl+"/results/export-command";this.downloadFilesUrl=flowUrl+"/results/files-archive"}};exports.FlowResultsDirective=function(){return{scope:{flowId:"=",apiBasePath:"="},restrict:"E",
templateUrl:"/static/angular-components/flow/flow-results.html",controller:FlowResultsController,controllerAs:"controller"}};exports.FlowResultsDirective.directive_name="grrFlowResults";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowStatusIconDirective");goog.module.declareLegacyNamespace();exports.FlowStatusIconDirective=function(){return{scope:{flow:"="},restrict:"E",templateUrl:"/static/angular-components/flow/flow-status-icon.html"}};exports.FlowStatusIconDirective.directive_name="grrFlowStatusIcon";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flowsListDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var272=goog.require("grrUi.core.infiniteTableDirective");var InfiniteTableController=$jscomp$destructuring$var272.InfiniteTableController;var TABLE_KEY_NAME=InfiniteTableController.UNIQUE_KEY_NAME;var TABLE_ROW_HASH=InfiniteTableController.ROW_HASH_NAME;var AUTO_REFRESH_INTERVAL_MS=30*1E3;exports.setAutoRefreshInterval=function(millis){AUTO_REFRESH_INTERVAL_MS=
millis};var PAGE_SIZE=100;exports.flattenFlowsList=function(flows,opt_currentDepth){if(angular.isUndefined(opt_currentDepth))opt_currentDepth=0;var result=[];for(var i=0;i<flows.length;++i){var flow=angular.copy(flows[i]);flow["depth"]=opt_currentDepth;result.push(flow);if(angular.isDefined(flow["value"])&&angular.isDefined(flow["value"]["nested_flows"])){result=result.concat(exports.flattenFlowsList(flow["value"]["nested_flows"],opt_currentDepth+1));delete flow["value"]["nested_flows"]}}return result};
var flattenFlowsList=exports.flattenFlowsList;exports.toggleFlowExpansion=function(flows,index){var flowToExpand=flows[index];var i;flowToExpand.expanded=!flowToExpand.expanded;if(!flowToExpand.expanded)for(i=index+1;i<flows.length;++i)if(flows[i].depth>flowToExpand.depth)flows[i].shown=false;else break;else{var ignoreDepth=null;for(i=index+1;i<flows.length;++i)if(flows[i].depth>flowToExpand.depth){if(!ignoreDepth||ignoreDepth>=flows[i].depth){flows[i].shown=true;ignoreDepth=flows[i].expanded?null:
flows[i].depth}}else break}return flows};var toggleFlowExpansion=exports.toggleFlowExpansion;var FlowsListController=function($scope,$element,grrApiService){this.scope_=$scope;this.element_=$element;this.flowsById={};this.selectedFlowId;this.triggerTableUpdate;this.autoRefreshInterval=AUTO_REFRESH_INTERVAL_MS;this.pageSize=PAGE_SIZE;this.scope_.$watch("controller.selectedFlowId",function(newValue){if(angular.isDefined(newValue))this.scope_["selectedFlowId"]=newValue}.bind(this));this.scope_.$watch("selectedFlowId",
function(newValue){if(angular.isDefined(newValue))this.selectedFlowId=newValue}.bind(this));this.scope_["triggerUpdate"]=this.triggerUpdate.bind(this)};FlowsListController.prototype.selectItem=function(item){this.selectedFlowId=item["value"]["flow_id"]["value"]};FlowsListController.prototype.transformItems=function(items){var flattenedItems=flattenFlowsList(items);angular.forEach(flattenedItems,function(item,index){var components=item["value"]["flow_id"]["value"].split("/");item.shortId=components[components.length-
1];item.shown=item.depth==0;if(index<flattenedItems.length-1&&flattenedItems[index+1].depth>item.depth)item.expanded=false;item.expand=function(e){e.stopPropagation();toggleFlowExpansion(flattenedItems,index)};var state="BROKEN";if(angular.isDefined(item["value"]["state"]))state=item["value"]["state"]["value"];var last_active_at=0;if(angular.isDefined(item["value"]["last_active_at"]))last_active_at=item["value"]["last_active_at"]["value"];item[TABLE_KEY_NAME]=item["value"]["flow_id"]["value"];item[TABLE_ROW_HASH]=
[state,last_active_at]}.bind(this));return flattenedItems};FlowsListController.prototype.triggerUpdate=function(){this.triggerTableUpdate(true)};exports.FlowsListDirective=function(){return{scope:{flowsUrl:"=",selectedFlowId:"=?",triggerUpdate:"=?"},restrict:"E",templateUrl:"/static/angular-components/flow/flows-list.html",controller:FlowsListController,controllerAs:"controller"}};exports.FlowsListDirective.directive_name="grrFlowsList";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.startFlowFormDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var273=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var273.ApiService;var stripTypeInfo=$jscomp$destructuring$var273.stripTypeInfo;var $jscomp$destructuring$var274=goog.require("grrUi.core.reflectionService");var ReflectionService=$jscomp$destructuring$var274.ReflectionService;var StartFlowFormController=function($scope,
grrApiService,grrReflectionService){this.scope_=$scope;this.scope_.clientId;this.grrApiService_=grrApiService;this.grrReflectionService_=grrReflectionService;this.flowArguments;this.flowRunnerArguments;this.requestSent=false;this.responseError;this.responseData;this.outputPluginsField;this.outputPluginDescriptor;this.flowFormHasErrors;this.scope_.$watch("descriptor",function(flowDescriptor){this.requestSent=false;this.responseError=null;this.responseData=null;if(angular.isDefined(flowDescriptor)){this.flowArguments=
angular.copy(flowDescriptor["value"]["default_args"]);this.grrReflectionService_.getRDFValueDescriptor("FlowRunnerArgs").then(function(descriptor){this.flowRunnerArguments=angular.copy(descriptor["default"]);this.flowRunnerArguments["value"]["flow_name"]=flowDescriptor["value"]["name"]}.bind(this))}}.bind(this))};StartFlowFormController.prototype.startClientFlow=function(){var clientIdComponents=this.scope_["clientId"].split("/");var clientId;if(clientIdComponents[0]=="aff4:")clientId=clientIdComponents[1];
else clientId=clientIdComponents[0];this.grrApiService_.post("/clients/"+clientId+"/flows",{flow:{runner_args:stripTypeInfo(this.flowRunnerArguments),args:stripTypeInfo(this.flowArguments)}}).then(function success(response){this.responseData=response["data"]}.bind(this),function failure(response){this.responseError=response["data"]["message"]||"Unknown error"}.bind(this));this.requestSent=true};exports.StartFlowFormDirective=function(){return{scope:{clientId:"=?",descriptor:"="},restrict:"E",templateUrl:"/static/angular-components/flow/start-flow-form.html",
controller:StartFlowFormController,controllerAs:"controller"}};exports.StartFlowFormDirective.directive_name="grrStartFlowForm";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.startFlowViewDirective");goog.module.declareLegacyNamespace();var StartFlowViewController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.cliendId;this.selection={};this.grrRoutingService_.uiOnParamsChanged(this.scope_,"clientId",this.onClientIdChange_.bind(this))};StartFlowViewController.prototype.onClientIdChange_=function(clientId){this.clientId=clientId};exports.StartFlowViewDirective=
function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/flow/start-flow-view.html",controller:StartFlowViewController,controllerAs:"controller"}};exports.StartFlowViewDirective.directive_name="grrStartFlowView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.flow.flow");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var275=goog.require("grrUi.flow.clientFlowsListDirective");var ClientFlowsListDirective=$jscomp$destructuring$var275.ClientFlowsListDirective;var $jscomp$destructuring$var276=goog.require("grrUi.flow.clientFlowsViewDirective");var ClientFlowsViewDirective=$jscomp$destructuring$var276.ClientFlowsViewDirective;var $jscomp$destructuring$var277=goog.require("grrUi.flow.copyFlowFormDirective");
var CopyFlowFormDirective=$jscomp$destructuring$var277.CopyFlowFormDirective;var $jscomp$destructuring$var278=goog.require("grrUi.flow.flowApiHelperDirective");var FlowApiHelperDirective=$jscomp$destructuring$var278.FlowApiHelperDirective;var $jscomp$destructuring$var279=goog.require("grrUi.flow.flowDescriptorsTreeDirective");var FlowDescriptorsTreeDirective=$jscomp$destructuring$var279.FlowDescriptorsTreeDirective;var $jscomp$destructuring$var280=goog.require("grrUi.flow.flowFormDirective");var FlowFormDirective=
$jscomp$destructuring$var280.FlowFormDirective;var $jscomp$destructuring$var281=goog.require("grrUi.flow.flowInfoDirective");var FlowInfoDirective=$jscomp$destructuring$var281.FlowInfoDirective;var $jscomp$destructuring$var282=goog.require("grrUi.flow.flowInspectorDirective");var FlowInspectorDirective=$jscomp$destructuring$var282.FlowInspectorDirective;var $jscomp$destructuring$var283=goog.require("grrUi.flow.flowLogDirective");var FlowLogDirective=$jscomp$destructuring$var283.FlowLogDirective;var $jscomp$destructuring$var284=
goog.require("grrUi.flow.flowOverviewDirective");var FlowOverviewDirective=$jscomp$destructuring$var284.FlowOverviewDirective;var $jscomp$destructuring$var285=goog.require("grrUi.flow.flowRequestsDirective");var FlowRequestsDirective=$jscomp$destructuring$var285.FlowRequestsDirective;var $jscomp$destructuring$var286=goog.require("grrUi.flow.flowResultsDirective");var FlowResultsDirective=$jscomp$destructuring$var286.FlowResultsDirective;var $jscomp$destructuring$var287=goog.require("grrUi.flow.flowStatusIconDirective");
var FlowStatusIconDirective=$jscomp$destructuring$var287.FlowStatusIconDirective;var $jscomp$destructuring$var288=goog.require("grrUi.flow.flowsListDirective");var FlowsListDirective=$jscomp$destructuring$var288.FlowsListDirective;var $jscomp$destructuring$var289=goog.require("grrUi.flow.startFlowFormDirective");var StartFlowFormDirective=$jscomp$destructuring$var289.StartFlowFormDirective;var $jscomp$destructuring$var290=goog.require("grrUi.flow.startFlowViewDirective");var StartFlowViewDirective=
$jscomp$destructuring$var290.StartFlowViewDirective;var $jscomp$destructuring$var291=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var291.coreModule;exports.flowModule=angular.module("grrUi.flow",[coreModule.name]);exports.flowModule.directive(ClientFlowsListDirective.directive_name,ClientFlowsListDirective);exports.flowModule.directive(ClientFlowsViewDirective.directive_name,ClientFlowsViewDirective);exports.flowModule.directive(CopyFlowFormDirective.directive_name,CopyFlowFormDirective);
exports.flowModule.directive(FlowApiHelperDirective.directive_name,FlowApiHelperDirective);exports.flowModule.directive(FlowDescriptorsTreeDirective.directive_name,FlowDescriptorsTreeDirective);exports.flowModule.directive(FlowFormDirective.directive_name,FlowFormDirective);exports.flowModule.directive(FlowInfoDirective.directive_name,FlowInfoDirective);exports.flowModule.directive(FlowInspectorDirective.directive_name,FlowInspectorDirective);exports.flowModule.directive(FlowLogDirective.directive_name,
FlowLogDirective);exports.flowModule.directive(FlowOverviewDirective.directive_name,FlowOverviewDirective);exports.flowModule.directive(FlowRequestsDirective.directive_name,FlowRequestsDirective);exports.flowModule.directive(FlowResultsDirective.directive_name,FlowResultsDirective);exports.flowModule.directive(FlowStatusIconDirective.directive_name,FlowStatusIconDirective);exports.flowModule.directive(FlowsListDirective.directive_name,FlowsListDirective);exports.flowModule.directive(StartFlowFormDirective.directive_name,
StartFlowFormDirective);exports.flowModule.directive(StartFlowViewDirective.directive_name,StartFlowViewDirective);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntClientsDirective");goog.module.declareLegacyNamespace();var HuntClientsController=function($scope){this.scope_=$scope;this.huntClientsUrl;this.clientType="completed";this.scope_.$watchGroup(["huntId","controller.clientType"],this.onHuntIdOrClientTypeChange_.bind(this))};HuntClientsController.prototype.onHuntIdOrClientTypeChange_=function(){var huntId=this.scope_["huntId"];if(!angular.isString(huntId)||!angular.isString(this.clientType))return;
this.huntClientsUrl="/hunts/"+huntId+"/clients/"+this.clientType};exports.HuntClientsDirective=function(){return{scope:{huntId:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-clients.html",controller:HuntClientsController,controllerAs:"controller"}};exports.HuntClientsDirective.directive_name="grrHuntClients";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntContextDirective");goog.module.declareLegacyNamespace();var HuntContextController=function($scope,grrApiService){this.grrApiService_=grrApiService;this.context;this.state;$scope.$watch("huntId",this.onHuntIdChange_.bind(this))};HuntContextController.prototype.onHuntIdChange_=function(huntId){if(!angular.isString(huntId))return;var url="/hunts/"+huntId+"/context";this.grrApiService_.get(url).then(function success(response){this.context=
response.data["context"];this.state=response.data["state"]}.bind(this))};exports.HuntContextDirective=function(){return{scope:{huntId:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-context.html",controller:HuntContextController,controllerAs:"controller"}};exports.HuntContextDirective.directive_name="grrHuntContext";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntCrashesDirective");goog.module.declareLegacyNamespace();var AUTO_REFRESH_INTERVAL_MS=20*1E3;exports.setAutoRefreshInterval=function(millis){AUTO_REFRESH_INTERVAL_MS=millis};var HuntCrashesController=function($scope){this.scope_=$scope;this.scope_.huntId;this.crashesUrl;this.autoRefreshInterval=AUTO_REFRESH_INTERVAL_MS;this.scope_.$watch("huntId",this.onHuntIdChange_.bind(this))};HuntCrashesController.prototype.onHuntIdChange_=
function(huntId){if(angular.isDefined(huntId))this.crashesUrl="hunts/"+huntId+"/crashes"};exports.HuntCrashesDirective=function(){return{scope:{huntId:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-crashes.html",controller:HuntCrashesController,controllerAs:"controller"}};exports.HuntCrashesDirective.directive_name="grrHuntCrashes";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntErrorsDirective");goog.module.declareLegacyNamespace();var AUTO_REFRESH_INTERVAL_MS=20*1E3;exports.setAutoRefreshInterval=function(millis){AUTO_REFRESH_INTERVAL_MS=millis};var HuntErrorsController=function($scope){this.scope_=$scope;this.scope_.huntId;this.errorsUrl;this.autoRefreshInterval=AUTO_REFRESH_INTERVAL_MS;this.scope_.$watch("huntId",this.onHuntIdChange_.bind(this))};HuntErrorsController.prototype.onHuntIdChange_=
function(huntId){if(angular.isDefined(huntId))this.errorsUrl="hunts/"+huntId+"/errors"};exports.HuntErrorsDirective=function(){return{scope:{huntId:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-errors.html",controller:HuntErrorsController,controllerAs:"controller"}};exports.HuntErrorsDirective.directive_name="grrHuntErrors";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntGraphDirective");goog.module.declareLegacyNamespace();var HuntGraphController=function($scope,$element,grrApiService){this.scope_=$scope;this.element_=$element;this.grrApiService_=grrApiService;this.scope_.huntId;this.inProgress=false;this.clientStartPoints;this.clientFinishPoints;this.informationAvailable;this.maxSampleSize=1E3;this.scope_.$watch("huntId",this.onHuntIdChange_.bind(this))};HuntGraphController.prototype.onHuntIdChange_=
function(){this.hunt=null;this.huntSummary=null;if(angular.isDefined(this.scope_.huntId)){this.huntId=this.scope_["huntId"];this.inProgress=true;var url="hunts/"+this.huntId+"/client-completion-stats";var params={"strip_type_info":1,"size":this.maxSampleSize};this.grrApiService_.get(url,params).then(this.onHuntGraphFetched_.bind(this))}};HuntGraphController.prototype.onHuntGraphFetched_=function(response){this.clientStartPoints=this.parseDataPoints_(response.data["start_points"]);this.clientFinishPoints=
this.parseDataPoints_(response.data["complete_points"]);this.informationAvailable=angular.isArray(this.clientStartPoints)&&this.clientStartPoints.length>0||angular.isArray(this.clientFinishPoints)&&this.clientFinishPoints.length>0;this.drawGraph_();this.inProgress=false};HuntGraphController.prototype.parseDataPoints_=function(points){var result=[];angular.forEach(points,function(point){result.push([point["x_value"],point["y_value"]])});return result};HuntGraphController.prototype.drawGraph_=function(){var graphElement=
$(this.element_).find(".client-completion-graph");if(graphElement&&this.informationAvailable)$.plot(graphElement,[{label:"Agents issued.",data:this.clientStartPoints},{label:"Agents completed.",data:this.clientFinishPoints}],{series:{lines:{show:true},points:{show:true}},xaxis:{min:0,tickDecimals:4},yaxis:{tickDecimals:0}})};exports.HuntGraphDirective=function(){return{scope:{huntId:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-graph.html",controller:HuntGraphController,controllerAs:"controller"}};
exports.HuntGraphDirective.directive_name="grrHuntGraph";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntInspectorDirective");goog.module.declareLegacyNamespace();var HuntInspectorController=function($scope){this.scope_=$scope;this.shownHuntId;this.activeTab="";this.tabsShown={};this.scope_.$watchGroup(["huntId","activeTab"],this.onDirectiveArgumentsChange_.bind(this));this.scope_.$watch("controller.activeTab",this.onTabChange_.bind(this))};HuntInspectorController.prototype.onDirectiveArgumentsChange_=function(){if(angular.isString(this.scope_["activeTab"]))this.activeTab=
this.scope_["activeTab"];this.scope_.$evalAsync(function(){this.shownHuntId=this.scope_["huntId"]}.bind(this))};HuntInspectorController.prototype.onTabChange_=function(newValue,oldValue){if(newValue!==oldValue)this.scope_["activeTab"]=newValue;this.tabsShown[newValue]=true};exports.HuntInspectorDirective=function(){return{scope:{huntId:"=",activeTab:"=?"},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-inspector.html",controller:HuntInspectorController,controllerAs:"controller"}};exports.HuntInspectorDirective.directive_name=
"grrHuntInspector";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntLogDirective");goog.module.declareLegacyNamespace();var AUTO_REFRESH_INTERVAL_MS=20*1E3;exports.setAutoRefreshInterval=function(millis){AUTO_REFRESH_INTERVAL_MS=millis};var HuntLogController=function($scope){this.scope_=$scope;this.scope_.huntId;this.autoRefreshInterval=AUTO_REFRESH_INTERVAL_MS;this.scope_.$watch("huntId",this.onHuntIdChange_.bind(this))};HuntLogController.prototype.onHuntIdChange_=function(huntId){if(angular.isDefined(huntId))this.logsUrl=
"hunts/"+huntId+"/log"};HuntLogController.prototype.transformItems=function(items){var clientId=null;var highlighted=false;for(var i=0;i<items.length;++i){var item=items[i];var itemClientId=null;if(item.value.client_id!==undefined)itemClientId=item.value.client_id.value;if(clientId!==itemClientId){clientId=itemClientId;highlighted=!highlighted}else item.value.client_id=null;item.highlighted=highlighted}return items};exports.HuntLogDirective=function(){return{scope:{huntId:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-log.html",
controller:HuntLogController,controllerAs:"controller"}};exports.HuntLogDirective.directive_name="grrHuntLog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntOverviewDirective");goog.module.declareLegacyNamespace();var AUTO_REFRESH_INTERVAL_MS=15*1E3;exports.setAutoRefreshInterval=function(millis){AUTO_REFRESH_INTERVAL_MS=millis};var HuntOverviewController=function($scope,grrApiService,grrRoutingService){this.scope_=$scope;this.scope_.huntId;this.grrApiService_=grrApiService;this.grrRoutingService_=grrRoutingService;this.huntId;this.hunt;this.pollPromise_;this.scope_.$on("$destroy",
function(){this.grrApiService_.cancelPoll(this.pollPromise_)}.bind(this));this.scope_.$watch("huntId",this.startPolling_.bind(this))};HuntOverviewController.prototype.startPolling_=function(){this.grrApiService_.cancelPoll(this.pollPromise_);this.pollPromise_=undefined;if(angular.isDefined(this.scope_["huntId"])){this.huntId=this.scope_["huntId"];var huntUrl="hunts/"+this.huntId;var interval=AUTO_REFRESH_INTERVAL_MS;this.pollPromise_=this.grrApiService_.poll(huntUrl,interval);this.pollPromise_.then(undefined,
undefined,function notify(response){this.hunt=response["data"]}.bind(this))}};exports.HuntOverviewDirective=function(){return{scope:{huntId:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-overview.html",controller:HuntOverviewController,controllerAs:"controller"}};exports.HuntOverviewDirective.directive_name="grrHuntOverview";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntResultsDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var292=goog.require("grrUi.core.fileDownloadUtils");var downloadableVfsRoots=$jscomp$destructuring$var292.downloadableVfsRoots;var getPathSpecFromValue=$jscomp$destructuring$var292.getPathSpecFromValue;var makeValueDownloadable=$jscomp$destructuring$var292.makeValueDownloadable;var pathSpecToAff4Path=$jscomp$destructuring$var292.pathSpecToAff4Path;
var $jscomp$destructuring$var293=goog.require("grrUi.core.utils");var stripAff4Prefix=$jscomp$destructuring$var293.stripAff4Prefix;var HuntResultsController=function($scope){this.scope_=$scope;this.resultsUrl;this.exportedResultsUrl;this.outputPluginsUrl;this.downloadFilesUrl;this.exportCommandUrl;$scope.$watch("huntId",this.onHuntIdChange.bind(this))};HuntResultsController.prototype.onHuntIdChange=function(huntId){if(!angular.isString(huntId))return;this.resultsUrl="/hunts/"+huntId+"/results";this.exportedResultsUrl=
"/hunts/"+huntId+"/exported-results";this.downloadFilesUrl=this.resultsUrl+"/files-archive";this.exportCommandUrl=this.resultsUrl+"/export-command";this.outputPluginsUrl="/hunts/"+huntId+"/output-plugins"};HuntResultsController.prototype.transformItems=function(items){var urlPrefix="/hunts/"+this.scope_["huntId"]+"/results/clients";var newItems=items.map(function(item){var pathSpec=getPathSpecFromValue(item);if(!pathSpec)return item;var clientId=item["value"]["client_id"]["value"];var aff4Path=stripAff4Prefix(pathSpecToAff4Path(pathSpec,
clientId));var components=aff4Path.split("/");var vfsPath=components.slice(1).join("/");var legitimatePath=downloadableVfsRoots.some(function(vfsRoot){var prefix=vfsRoot+"/";return vfsPath.startsWith(prefix)}.bind(this));if(!legitimatePath)return item;var downloadUrl=urlPrefix+"/"+clientId+"/vfs-blob/"+vfsPath;var downloadParams={"timestamp":item["value"]["timestamp"]["value"]};var downloadableItem=angular.copy(item);makeValueDownloadable(downloadableItem,downloadUrl,downloadParams);return downloadableItem});
return newItems};exports.HuntResultsDirective=function(){return{scope:{huntId:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-results.html",controller:HuntResultsController,controllerAs:"controller"}};exports.HuntResultsDirective.directive_name="grrHuntResults";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntStatsDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var294=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var294.ApiService;var stripTypeInfo=$jscomp$destructuring$var294.stripTypeInfo;var HuntStatsController=function($scope,$element,grrApiService){this.scope_=$scope;this.element_=$element;this.grrApiService_=grrApiService;this.stats;this.userCpuStats;this.systemCpuStats;
this.networkBytesStats;this.totalClientCount;$scope.$watch("huntId",this.onHuntIdChange_.bind(this))};HuntStatsController.prototype.onHuntIdChange_=function(huntId){if(!angular.isString(huntId))return;var url="/hunts/"+huntId+"/stats";this.grrApiService_.get(url).then(function success(response){this.stats=response.data["stats"];var strippedStats=stripTypeInfo(this.stats);this.userCpuStats=this.parseStats_(strippedStats["user_cpu_stats"],null);this.systemCpuStats=this.parseStats_(strippedStats["system_cpu_stats"],
null);this.networkBytesStats=this.parseStats_(strippedStats["network_bytes_sent_stats"],this.formatBytes_);if(strippedStats["user_cpu_stats"])this.totalClientCount=strippedStats["user_cpu_stats"]["num"];this.drawHistograms_()}.bind(this))};HuntStatsController.prototype.formatBytes_=function(value){if(value<1024)return value+"B";else return Math.round(value/1024)+"K"};HuntStatsController.prototype.parseStats_=function(stats,xAxisFormatter){if(!stats)return null;var mean=0;if(stats["num"])mean=stats["sum"]/
stats["num"];var stdev=0;if(stats["num"])stdev=Math.sqrt(stats["sum_sq"]/stats["num"]-Math.pow(mean,2));var histogramData=[];var histogramTicks=[];angular.forEach(stats["histogram"]["bins"],function(item,index){var value=item["num"]||0;histogramData.push([index,value]);var range=item["range_max_value"];var xValue=range%1!=0?range.toFixed(1):range;if(xAxisFormatter)xValue=xAxisFormatter(xValue);histogramTicks.push([index+.5,xValue])});return{mean:mean,stdev:stdev,histogram:{data:histogramData,ticks:histogramTicks}}};
HuntStatsController.prototype.drawHistograms_=function(){if(this.userCpuStats){var userCpuGraphElement=this.element_.find(".user-cpu-histogram");this.drawSingleHistogram_(userCpuGraphElement,this.userCpuStats.histogram)}if(this.systemCpuStats){var systemCpuGraphElement=this.element_.find(".system-cpu-histogram");this.drawSingleHistogram_(systemCpuGraphElement,this.systemCpuStats.histogram)}if(this.networkBytesStats){var networkBytesGraphElement=this.element_.find(".network-bytes-histogram");this.drawSingleHistogram_(networkBytesGraphElement,
this.networkBytesStats.histogram)}};HuntStatsController.prototype.drawSingleHistogram_=function(element,histogram){$.plot(element,[{data:histogram["data"],bars:{show:true,lineWidth:1}}],{xaxis:{tickLength:0,ticks:histogram["ticks"]},yaxis:{minTickSize:1,tickDecimals:0}})};exports.HuntStatsDirective=function(){return{scope:{huntId:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-stats.html",controller:HuntStatsController,controllerAs:"controller"}};exports.HuntStatsDirective.directive_name=
"grrHuntStats";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntStatusIconDirective");goog.module.declareLegacyNamespace();exports.HuntStatusIconDirective=function(){return{scope:{hunt:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/hunt-status-icon.html"}};exports.HuntStatusIconDirective.directive_name="grrHuntStatusIcon";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntsListDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var295=goog.require("grrUi.acl.aclDialogService");var AclDialogService=$jscomp$destructuring$var295.AclDialogService;var $jscomp$destructuring$var296=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var296.ApiService;var $jscomp$destructuring$var297=goog.require("grrUi.core.dialogService");var DialogService=$jscomp$destructuring$var297.DialogService;
var $jscomp$destructuring$var298=goog.require("grrUi.core.utils");var stripAff4Prefix=$jscomp$destructuring$var298.stripAff4Prefix;var HuntsListController=function($scope,$q,$uibModal,grrDialogService,grrApiService,grrAclDialogService){this.scope_=$scope;this.q_=$q;this.uibModal_=$uibModal;this.grrDialogService_=grrDialogService;this.grrApiService_=grrApiService;this.grrAclDialogService_=grrAclDialogService;this.huntsById={};this.showRobotHunts=false;this.triggerUpdate};HuntsListController.prototype.huntsUrl=
"/hunts";HuntsListController.prototype.buildHuntUrl_=function(){var components=this.scope_["selectedHuntId"].split("/");var basename=components[components.length-1];return this.huntsUrl+"/"+basename};HuntsListController.prototype.wrapApiPromise_=function(promise,successMessage){return promise.then(function success(){return successMessage}.bind(this),function failure(response){var message=response["data"]["message"];if(response["status"]===403){var subject=response["data"]["subject"];var huntId=stripAff4Prefix(subject).split("/")[1];
this.grrAclDialogService_.openRequestHuntApprovalDialog(huntId,message)}return this.q_.reject(message)}.bind(this))};HuntsListController.prototype.selectItem=function(item){this.scope_["selectedHuntId"]=item.value.hunt_id.value};HuntsListController.prototype.newHunt=function(){var modalScope=this.scope_.$new();modalScope.resolve=function(){modalInstance.close()};modalScope.reject=function(){modalInstance.dismiss()};this.scope_.$on("$destroy",function(){modalScope.$destroy()});var modalInstance=this.uibModal_.open({template:'<grr-new-hunt-wizard-form on-resolve="resolve()" '+
'on-reject="reject()" />',scope:modalScope,windowClass:"wide-modal high-modal",size:"lg"});modalInstance.result.then(function resolve(){this.triggerUpdate()}.bind(this))};HuntsListController.prototype.runHunt=function(){var modalPromise=this.grrDialogService_.openConfirmation("Run this hunt?","Are you sure you want to run this hunt?",function(){var promise=this.grrApiService_.patch(this.buildHuntUrl_(),{state:"STARTED"});return this.wrapApiPromise_(promise,"Hunt started successfully!")}.bind(this));
modalPromise.then(function resolve(){this.triggerUpdate()}.bind(this),function dismiss(){this.triggerUpdate()}.bind(this))};HuntsListController.prototype.stopHunt=function(){var modalPromise=this.grrDialogService_.openConfirmation("Stop this hunt?","Are you sure you want to stop this hunt? Once a hunt is "+"stopped, resuming it is not possible.",function(){var promise=this.grrApiService_.patch(this.buildHuntUrl_(),{state:"STOPPED"});return this.wrapApiPromise_(promise,"Hunt stopped successfully!")}.bind(this));
modalPromise.then(function resolve(){this.triggerUpdate()}.bind(this),function dismiss(){this.triggerUpdate()}.bind(this))};HuntsListController.prototype.modifyHunt=function(){var components=this.scope_["selectedHuntId"].split("/");var huntId=components[components.length-1];var argsObj={};var modalPromise=this.grrDialogService_.openDirectiveDialog("grrModifyHuntDialog",{huntId:huntId});modalPromise.then(function resolve(){this.triggerUpdate()}.bind(this),function dismiss(){this.triggerUpdate()}.bind(this))};
HuntsListController.prototype.copyHunt=function(){var modalScope=this.scope_.$new();modalScope.huntId=this.scope_["selectedHuntId"];modalScope.resolve=function(){modalInstance.close()};modalScope.reject=function(){modalInstance.dismiss()};this.scope_.$on("$destroy",function(){modalScope.$destroy()});var modalInstance=this.uibModal_.open({template:'<grr-new-hunt-wizard-copy-form on-resolve="resolve()" '+'on-reject="reject()" hunt-id="huntId" />',scope:modalScope,windowClass:"wide-modal high-modal",
size:"lg"});modalInstance.result.then(function resolve(){this.triggerUpdate()}.bind(this))};HuntsListController.prototype.deleteHunt=function(){var modalPromise=this.grrDialogService_.openConfirmation("Delete this hunt?","Are you sure you want to delete this hunt?",function(){var promise=this.grrApiService_.delete(this.buildHuntUrl_());return this.wrapApiPromise_(promise,"Hunt deleted successfully!")}.bind(this));modalPromise.then(function resolve(){this.triggerUpdate()}.bind(this),function dismiss(){this.triggerUpdate()}.bind(this))};
HuntsListController.prototype.transformItems=function(items){angular.forEach(items,function(item){this.huntsById[item["value"]["hunt_id"]["value"]]=item}.bind(this));return items};exports.HuntsListDirective=function(){return{scope:{selectedHuntId:"=?"},restrict:"E",templateUrl:"/static/angular-components/hunt/hunts-list.html",controller:HuntsListController,controllerAs:"controller"}};exports.HuntsListDirective.directive_name="grrHuntsList";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.huntsViewDirective");goog.module.declareLegacyNamespace();var HuntsViewController=function($scope,grrRoutingService){this.scope_=$scope;this.grrRoutingService_=grrRoutingService;this.selectedHuntId;this.tab;this.scope_.$watchGroup(["controller.selectedHuntId","controller.tab"],this.onSelectionChange_.bind(this));this.grrRoutingService_.uiOnParamsChanged(this.scope_,["huntId","tab"],this.onParamsChange_.bind(this))};HuntsViewController.prototype.onParamsChange_=
function(newValues,opt_stateParams){if(opt_stateParams["huntId"])this.selectedHuntId=opt_stateParams["huntId"];this.tab=opt_stateParams["tab"]};HuntsViewController.prototype.onSelectionChange_=function(){if(angular.isDefined(this.selectedHuntId))this.grrRoutingService_.go("hunts",{huntId:this.selectedHuntId,tab:this.tab})};exports.HuntsViewDirective=function(){return{restrict:"E",scope:{},templateUrl:"/static/angular-components/hunt/hunts-view.html",controller:HuntsViewController,controllerAs:"controller"}};
exports.HuntsViewDirective.directive_name="grrHuntsView";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.modifyHuntDialogDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var299=goog.require("grrUi.acl.aclDialogService");var AclDialogService=$jscomp$destructuring$var299.AclDialogService;var $jscomp$destructuring$var300=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var300.ApiService;var stripTypeInfo=$jscomp$destructuring$var300.stripTypeInfo;var $jscomp$destructuring$var301=goog.require("grrUi.core.utils");
var stripAff4Prefix=$jscomp$destructuring$var301.stripAff4Prefix;var ModifyHuntDialogController=function($scope,$q,grrApiService,grrAclDialogService){this.scope_=$scope;this.q_=$q;this.grrApiService_=grrApiService;this.grrAclDialogService_=grrAclDialogService;this.argsObj;this.scope_.$watch("huntId",this.onHuntIdChange_.bind(this))};ModifyHuntDialogController.prototype.onHuntIdChange_=function(newValue){this.argsObj=undefined;if(angular.isString(newValue))this.grrApiService_.get("/hunts/"+newValue).then(function(response){var hunt=
response["data"];this.argsObj={type:"ApiModifyHuntArgs",value:{}};angular.forEach(["client_limit","client_rate","expires"],function(k){var v=hunt["value"][k];if(v)this.argsObj["value"][k]=angular.copy(v)}.bind(this))}.bind(this))};ModifyHuntDialogController.prototype.proceed=function(){var request=stripTypeInfo(this.argsObj);return this.grrApiService_.patch("/hunts/"+this.scope_["huntId"],request).then(function success(){return"Hunt modified successfully!"}.bind(this),function failure(response){var message=
response["data"]["message"];if(response["status"]===403){var subject=response["data"]["subject"];var huntId=stripAff4Prefix(subject).split("/")[1];this.grrAclDialogService_.openRequestHuntApprovalDialog(huntId,message)}return this.q_.reject(message)}.bind(this))};exports.ModifyHuntDialogDirective=function(){return{scope:{huntId:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/modify-hunt-dialog.html",controller:ModifyHuntDialogController,controllerAs:"controller"}};exports.ModifyHuntDialogDirective.directive_name=
"grrModifyHuntDialog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.newHuntWizard.configureFlowPageDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var302=goog.require("grrUi.forms.utils");var valueHasErrors=$jscomp$destructuring$var302.valueHasErrors;var ConfigureFlowPageController=function($scope){this.scope_=$scope;this.flowDescriptor;this.scope_.$watch("controller.flowDescriptor",function(flowDescriptor){if(angular.isUndefined(flowDescriptor))return;this.scope_.flowName=
flowDescriptor["value"]["name"]["value"];this.scope_["flowArguments"]=angular.copy(flowDescriptor["value"]["default_args"])}.bind(this));this.scope_.$watch("flowArguments",this.onFlowArgumentsDeepChange_.bind(this),true)};ConfigureFlowPageController.prototype.onFlowArgumentsDeepChange_=function(newValue){this.scope_["hasErrors"]=valueHasErrors(newValue)};exports.ConfigureFlowPageDirective=function(){return{scope:{flowName:"=",flowArguments:"=",hasErrors:"=?"},restrict:"E",templateUrl:"/static/angular-components/hunt/new-hunt-wizard/"+
"configure-flow-page.html",controller:ConfigureFlowPageController,controllerAs:"controller"}};exports.ConfigureFlowPageDirective.directive_name="grrConfigureFlowPage";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.newHuntWizard.configureHuntPageDirective");goog.module.declareLegacyNamespace();exports.ConfigureHuntPageDirective=function(){return{scope:{huntRunnerArgs:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/new-hunt-wizard/"+"configure-hunt-page.html"}};exports.ConfigureHuntPageDirective.directive_name="grrConfigureHuntPage";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.newHuntWizard.configureOutputPluginsPageDirective");goog.module.declareLegacyNamespace();var ConfigureOutputPluginsPageController=function($scope,grrReflectionService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.outputPluginsField;this.outputPluginDescriptor;this.grrReflectionService_.getRDFValueDescriptor("GenericHuntArgs",true).then(this.onDescriptors_.bind(this))};ConfigureOutputPluginsPageController.prototype.onDescriptors_=
function(descriptors){angular.forEach(descriptors["GenericHuntArgs"]["fields"],function(field){if(field.name=="output_plugins")this.outputPluginsField=field}.bind(this));this.outputPluginDescriptor=descriptors["OutputPluginDescriptor"]};exports.ConfigureOutputPluginsPageDirective=function(){return{scope:{outputPlugins:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/new-hunt-wizard/"+"configure-output-plugins-page.html",controller:ConfigureOutputPluginsPageController,controllerAs:"controller"}};
exports.ConfigureOutputPluginsPageDirective.directive_name="grrConfigureOutputPluginsPage";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.newHuntWizard.configureRulesPageDirective");goog.module.declareLegacyNamespace();exports.ConfigureRulesPageDirective=function(){return{scope:{clientRuleSet:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/new-hunt-wizard/"+"configure-rules-page.html"}};exports.ConfigureRulesPageDirective.directive_name="grrConfigureRulesPage";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.newHuntWizard.copyFormDirective");goog.module.declareLegacyNamespace();var CopyFormController=function($scope,grrReflectionService,grrApiService){this.scope_=$scope;this.grrReflectionService_=grrReflectionService;this.grrApiService_=grrApiService;this.createHuntArgs;this.createHuntArgsDescriptor;this.grrReflectionService_.getRDFValueDescriptor("ApiCreateHuntArgs",true).then(function(descriptor){this.createHuntArgsDescriptor=descriptor["ApiCreateHuntArgs"];
this.huntRefDescriptor=descriptor["ApiHuntReference"];this.scope_.$watch("huntId",this.onHuntIdChange_.bind(this))}.bind(this))};CopyFormController.prototype.onHuntIdChange_=function(){if(angular.isDefined(this.scope_["huntId"])){this.huntId=this.scope_["huntId"];this.grrApiService_.get("hunts/"+this.huntId).then(this.onHuntFetched_.bind(this))}};CopyFormController.prototype.onHuntFetched_=function(response){var hunt=response["data"];this.createHuntArgs=angular.copy(this.createHuntArgsDescriptor["default"]);
this.createHuntArgs["value"]["flow_name"]=angular.copy(hunt["value"]["flow_name"]);this.createHuntArgs["value"]["flow_args"]=angular.copy(hunt["value"]["flow_args"]);var huntRunnerArgs=this.createHuntArgs["value"]["hunt_runner_args"]=angular.copy(hunt["value"]["hunt_runner_args"]);if(angular.isDefined(huntRunnerArgs["value"]["description"]))huntRunnerArgs["value"]["description"]["value"]+=" (copy)";this.createHuntArgs["value"]["original_hunt"]=angular.copy(this.huntRefDescriptor["default"]);this.createHuntArgs["value"]["original_hunt"]["value"]["hunt_id"]=
hunt["value"]["hunt_id"]};exports.CopyFormDirective=function(){return{scope:{huntId:"=",onResolve:"&",onReject:"&"},restrict:"E",templateUrl:"/static/angular-components/hunt/new-hunt-wizard/"+"copy-form.html",controller:CopyFormController,controllerAs:"controller"}};exports.CopyFormDirective.directive_name="grrNewHuntWizardCopyForm";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.newHuntWizard.createHuntFromFlowFormDirective");goog.module.declareLegacyNamespace();var CreateHuntFromFlowFormController=function($scope,grrApiService,grrReflectionService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrReflectionService_=grrReflectionService;this.createHuntArgs;this.flow_;this.descriptors_={};this.grrReflectionService_.getRDFValueDescriptor("ApiCreateHuntArgs",true).then(function(descriptors){angular.extend(this.descriptors_,
descriptors);this.scope_.$watchGroup(["flowId","clientId"],this.onFlowIdClientIdChange_.bind(this))}.bind(this))};CreateHuntFromFlowFormController.prototype.onFlowIdClientIdChange_=function(newValues){if(newValues.every(angular.isDefined)){var flowUrl=["clients",this.scope_["clientId"],"flows",this.scope_["flowId"]].join("/");this.grrApiService_.get(flowUrl).then(function(response){this.flow_=response["data"]}.bind(this)).then(this.onFlowDataFetched_.bind(this))}};CreateHuntFromFlowFormController.prototype.onFlowDataFetched_=
function(){var huntArgs=angular.copy(this.descriptors_["ApiCreateHuntArgs"]["default"]);huntArgs["value"]["flow_name"]=angular.copy(this.flow_["value"]["name"]);huntArgs["value"]["flow_args"]=angular.copy(this.flow_["value"]["args"]);huntArgs["value"]["original_flow"]=angular.copy(this.descriptors_["FlowReference"]["default"]);huntArgs["value"]["original_flow"]["value"]["flow_id"]=this.flow_["value"]["flow_id"]["value"];huntArgs["value"]["original_flow"]["value"]["client_id"]=this.scope_["clientId"];
this.createHuntArgs=huntArgs};exports.CreateHuntFromFlowFormDirective=function(){return{scope:{flowId:"=",clientId:"=",onResolve:"&",onReject:"&"},restrict:"E",templateUrl:"/static/angular-components/hunt/new-hunt-wizard/"+"create-hunt-from-flow-form.html",controller:CreateHuntFromFlowFormController,controllerAs:"controller"}};exports.CreateHuntFromFlowFormDirective.directive_name="grrNewHuntWizardCreateFromFlowForm";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.newHuntWizard.reviewPageDirective");goog.module.declareLegacyNamespace();exports.ReviewPageDirective=function(){return{scope:{createHuntArgs:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/new-hunt-wizard/"+"review-page.html"}};exports.ReviewPageDirective.directive_name="grrNewHuntReviewPage";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.newHuntWizard.statusPageDirective");goog.module.declareLegacyNamespace();exports.StatusPageDirective=function(){return{scope:{response:"="},restrict:"E",templateUrl:"/static/angular-components/hunt/new-hunt-wizard/"+"status-page.html"}};exports.StatusPageDirective.directive_name="grrNewHuntStatusPage";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.newHuntWizard.newHuntWizard");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var303=goog.require("grrUi.hunt.newHuntWizard.configureFlowPageDirective");var ConfigureFlowPageDirective=$jscomp$destructuring$var303.ConfigureFlowPageDirective;var $jscomp$destructuring$var304=goog.require("grrUi.hunt.newHuntWizard.configureHuntPageDirective");var ConfigureHuntPageDirective=$jscomp$destructuring$var304.ConfigureHuntPageDirective;
var $jscomp$destructuring$var305=goog.require("grrUi.hunt.newHuntWizard.configureOutputPluginsPageDirective");var ConfigureOutputPluginsPageDirective=$jscomp$destructuring$var305.ConfigureOutputPluginsPageDirective;var $jscomp$destructuring$var306=goog.require("grrUi.hunt.newHuntWizard.configureRulesPageDirective");var ConfigureRulesPageDirective=$jscomp$destructuring$var306.ConfigureRulesPageDirective;var $jscomp$destructuring$var307=goog.require("grrUi.hunt.newHuntWizard.copyFormDirective");var CopyFormDirective=
$jscomp$destructuring$var307.CopyFormDirective;var $jscomp$destructuring$var308=goog.require("grrUi.hunt.newHuntWizard.createHuntFromFlowFormDirective");var CreateHuntFromFlowFormDirective=$jscomp$destructuring$var308.CreateHuntFromFlowFormDirective;var $jscomp$destructuring$var309=goog.require("grrUi.hunt.newHuntWizard.formDirective");var FormDirective=$jscomp$destructuring$var309.FormDirective;var $jscomp$destructuring$var310=goog.require("grrUi.hunt.newHuntWizard.reviewPageDirective");var ReviewPageDirective=
$jscomp$destructuring$var310.ReviewPageDirective;var $jscomp$destructuring$var311=goog.require("grrUi.hunt.newHuntWizard.statusPageDirective");var StatusPageDirective=$jscomp$destructuring$var311.StatusPageDirective;var $jscomp$destructuring$var312=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var312.coreModule;exports.newHuntWizardModule=angular.module("grrUi.hunt.newHuntWizard",["ui.bootstrap",coreModule.name]);exports.newHuntWizardModule.directive(ConfigureFlowPageDirective.directive_name,
ConfigureFlowPageDirective);exports.newHuntWizardModule.directive(ConfigureHuntPageDirective.directive_name,ConfigureHuntPageDirective);exports.newHuntWizardModule.directive(ConfigureOutputPluginsPageDirective.directive_name,ConfigureOutputPluginsPageDirective);exports.newHuntWizardModule.directive(ConfigureRulesPageDirective.directive_name,ConfigureRulesPageDirective);exports.newHuntWizardModule.directive(ReviewPageDirective.directive_name,ReviewPageDirective);exports.newHuntWizardModule.directive(StatusPageDirective.directive_name,
StatusPageDirective);exports.newHuntWizardModule.directive(CopyFormDirective.directive_name,CopyFormDirective);exports.newHuntWizardModule.directive(FormDirective.directive_name,FormDirective);exports.newHuntWizardModule.directive(CreateHuntFromFlowFormDirective.directive_name,CreateHuntFromFlowFormDirective);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.hunt.hunt");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var313=goog.require("grrUi.hunt.huntClientsDirective");var HuntClientsDirective=$jscomp$destructuring$var313.HuntClientsDirective;var $jscomp$destructuring$var314=goog.require("grrUi.hunt.huntContextDirective");var HuntContextDirective=$jscomp$destructuring$var314.HuntContextDirective;var $jscomp$destructuring$var315=goog.require("grrUi.hunt.huntCrashesDirective");
var HuntCrashesDirective=$jscomp$destructuring$var315.HuntCrashesDirective;var $jscomp$destructuring$var316=goog.require("grrUi.hunt.huntErrorsDirective");var HuntErrorsDirective=$jscomp$destructuring$var316.HuntErrorsDirective;var $jscomp$destructuring$var317=goog.require("grrUi.hunt.huntGraphDirective");var HuntGraphDirective=$jscomp$destructuring$var317.HuntGraphDirective;var $jscomp$destructuring$var318=goog.require("grrUi.hunt.huntInspectorDirective");var HuntInspectorDirective=$jscomp$destructuring$var318.HuntInspectorDirective;
var $jscomp$destructuring$var319=goog.require("grrUi.hunt.huntLogDirective");var HuntLogDirective=$jscomp$destructuring$var319.HuntLogDirective;var $jscomp$destructuring$var320=goog.require("grrUi.hunt.huntOverviewDirective");var HuntOverviewDirective=$jscomp$destructuring$var320.HuntOverviewDirective;var $jscomp$destructuring$var321=goog.require("grrUi.hunt.huntResultsDirective");var HuntResultsDirective=$jscomp$destructuring$var321.HuntResultsDirective;var $jscomp$destructuring$var322=goog.require("grrUi.hunt.huntStatsDirective");
var HuntStatsDirective=$jscomp$destructuring$var322.HuntStatsDirective;var $jscomp$destructuring$var323=goog.require("grrUi.hunt.huntStatusIconDirective");var HuntStatusIconDirective=$jscomp$destructuring$var323.HuntStatusIconDirective;var $jscomp$destructuring$var324=goog.require("grrUi.hunt.huntsListDirective");var HuntsListDirective=$jscomp$destructuring$var324.HuntsListDirective;var $jscomp$destructuring$var325=goog.require("grrUi.hunt.huntsViewDirective");var HuntsViewDirective=$jscomp$destructuring$var325.HuntsViewDirective;
var $jscomp$destructuring$var326=goog.require("grrUi.hunt.modifyHuntDialogDirective");var ModifyHuntDialogDirective=$jscomp$destructuring$var326.ModifyHuntDialogDirective;var $jscomp$destructuring$var327=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var327.coreModule;var $jscomp$destructuring$var328=goog.require("grrUi.hunt.newHuntWizard.newHuntWizard");var newHuntWizardModule=$jscomp$destructuring$var328.newHuntWizardModule;exports.huntModule=angular.module("grrUi.hunt",["ui.bootstrap",
coreModule.name,newHuntWizardModule.name]);exports.huntModule.directive(HuntClientsDirective.directive_name,HuntClientsDirective);exports.huntModule.directive(HuntContextDirective.directive_name,HuntContextDirective);exports.huntModule.directive(HuntCrashesDirective.directive_name,HuntCrashesDirective);exports.huntModule.directive(HuntErrorsDirective.directive_name,HuntErrorsDirective);exports.huntModule.directive(HuntGraphDirective.directive_name,HuntGraphDirective);exports.huntModule.directive(HuntInspectorDirective.directive_name,
HuntInspectorDirective);exports.huntModule.directive(HuntLogDirective.directive_name,HuntLogDirective);exports.huntModule.directive(HuntOverviewDirective.directive_name,HuntOverviewDirective);exports.huntModule.directive(HuntResultsDirective.directive_name,HuntResultsDirective);exports.huntModule.directive(HuntStatusIconDirective.directive_name,HuntStatusIconDirective);exports.huntModule.directive(HuntStatsDirective.directive_name,HuntStatsDirective);exports.huntModule.directive(HuntsListDirective.directive_name,
HuntsListDirective);exports.huntModule.directive(HuntsViewDirective.directive_name,HuntsViewDirective);exports.huntModule.directive(ModifyHuntDialogDirective.directive_name,ModifyHuntDialogDirective);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.outputPlugins.outputPluginLogsDirective");goog.module.declareLegacyNamespace();var OutputPluginLogsController=function($scope,$uibModal,grrApiService){this.scope_=$scope;this.uibModal_=$uibModal;this.grrApiService_=grrApiService;this.itemsCount;this.scope_.$watch("url",this.onUrlChange_.bind(this))};OutputPluginLogsController.prototype.onUrlChange_=function(newValue){if(angular.isDefined(newValue))this.grrApiService_.get(newValue,{count:1}).then(function(response){this.itemsCount=
response["data"]["total_count"]}.bind(this))};OutputPluginLogsController.prototype.onClick=function(){this.uibModal_.open({templateUrl:"/static/angular-components/output-plugins/"+"output-plugin-logs-modal.html",scope:this.scope_,windowClass:"wide-modal high-modal",size:"lg"})};exports.OutputPluginLogsDirective=function(){return{scope:{url:"=",label:"@",cssClass:"@",icon:"@"},restrict:"E",templateUrl:"/static/angular-components/output-plugins/"+"output-plugin-logs.html",controller:OutputPluginLogsController,
controllerAs:"controller"}};exports.OutputPluginLogsDirective.directive_name="grrOutputPluginLogs";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.outputPlugins.outputPluginNoteBodyDirective");goog.module.declareLegacyNamespace();var OutputPluginNoteBodyController=function($scope,$compile,$element,grrOutputPluginsDirectivesRegistryService){this.scope_=$scope;this.scope_.outputPlugin;this.compile_=$compile;this.element_=$element;this.grrOutputPluginsDirectivesRegistryService_=grrOutputPluginsDirectivesRegistryService;this.scope_.$watch("outputPlugin",this.onOutputPluginChange_.bind(this))};
OutputPluginNoteBodyController.prototype.camelCaseToDashDelimited=function(directiveName){return directiveName.replace(/([a-z\d])([A-Z])/g,"$1-$2").toLowerCase()};OutputPluginNoteBodyController.prototype.onOutputPluginChange_=function(){if(angular.isDefined(this.scope_["outputPlugin"])){var descriptor=this.scope_["outputPlugin"]["value"]["plugin_descriptor"];var pluginName=descriptor["value"]["plugin_name"]["value"];var directive=this.grrOutputPluginsDirectivesRegistryService_.findDirectiveForMro([pluginName]);
if(angular.isDefined(directive)){var element=angular.element("<span />");element.html("<"+this.camelCaseToDashDelimited(directive.directive_name)+' output-plugin="outputPlugin" />');var template=this.compile_(element);template(this.scope_,function(cloned,opt_scope){this.element_.html("");this.element_.append(cloned)}.bind(this))}else this.element_.html("")}};exports.OutputPluginNoteBodyDirective=function(){return{scope:{outputPlugin:"="},restrict:"E",controller:OutputPluginNoteBodyController,controllerAs:"controller"}};
exports.OutputPluginNoteBodyDirective.directive_name="grrOutputPluginNoteBody";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.outputPlugins.outputPluginNoteDirective");goog.module.declareLegacyNamespace();var OutputPluginNoteController=function($scope,grrOutputPluginsDirectivesRegistryService){this.scope_=$scope;this.scope_.outputPlugin;this.pluginTitle;this.pluginLogsUrl;this.pluginErrorsUrl;this.grrOutputPluginsDirectivesRegistryService_=grrOutputPluginsDirectivesRegistryService;this.scope_.$watchGroup(["outputPlugin","outputPluginsUrl"],this.onOutputPluginChange_.bind(this))};
OutputPluginNoteController.prototype.onOutputPluginChange_=function(){if(angular.isDefined(this.scope_["outputPlugin"])&&angular.isDefined(this.scope_["outputPluginsUrl"])){var descriptor=this.scope_["outputPlugin"]["value"]["plugin_descriptor"];var pluginName=descriptor["value"]["plugin_name"]["value"];var directive=this.grrOutputPluginsDirectivesRegistryService_.findDirectiveForMro([pluginName]);if(angular.isDefined(directive))this.pluginTitle=directive.output_plugin_title;else this.pluginTitle=
pluginName;var logsUrlBase=this.scope_["outputPluginsUrl"]+"/"+this.scope_["outputPlugin"]["value"]["id"]["value"];this.pluginLogsUrl=logsUrlBase+"/logs";this.pluginErrorsUrl=logsUrlBase+"/errors"}};exports.OutputPluginNoteDirective=function(){return{scope:{outputPluginsUrl:"=",outputPlugin:"="},restrict:"E",templateUrl:"/static/angular-components/output-plugins/"+"output-plugin-note.html",controller:OutputPluginNoteController,controllerAs:"controller"}};exports.OutputPluginNoteDirective.directive_name=
"grrOutputPluginNote";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.outputPlugins.outputPluginsNotesDirective");goog.module.declareLegacyNamespace();var OutputPluginsNotesController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.error;this.outputPlugins;this.scope_.$watch("outputPluginsUrl",this.onOutputPluginsUrlChange_.bind(this))};OutputPluginsNotesController.prototype.onOutputPluginsUrlChange_=function(newValue){if(angular.isDefined(newValue))this.grrApiService_.get(newValue).then(function success(response){this.outputPlugins=
response["data"]["items"]}.bind(this),function failure(response){this.error=response["data"]["message"]}.bind(this))};exports.OutputPluginsNotesDirective=function(){return{scope:{outputPluginsUrl:"="},restrict:"E",templateUrl:"/static/angular-components/output-plugins/"+"output-plugins-notes.html",controller:OutputPluginsNotesController,controllerAs:"controller"}};exports.OutputPluginsNotesDirective.directive_name="grrOutputPluginsNotes";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.outputPlugins.outputPlugins");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var329=goog.require("grrUi.outputPlugins.outputPluginLogsDirective");var OutputPluginLogsDirective=$jscomp$destructuring$var329.OutputPluginLogsDirective;var $jscomp$destructuring$var330=goog.require("grrUi.outputPlugins.outputPluginNoteBodyDirective");var OutputPluginNoteBodyDirective=$jscomp$destructuring$var330.OutputPluginNoteBodyDirective;
var $jscomp$destructuring$var331=goog.require("grrUi.outputPlugins.outputPluginNoteDirective");var OutputPluginNoteDirective=$jscomp$destructuring$var331.OutputPluginNoteDirective;var $jscomp$destructuring$var332=goog.require("grrUi.outputPlugins.outputPluginsNotesDirective");var OutputPluginsNotesDirective=$jscomp$destructuring$var332.OutputPluginsNotesDirective;var $jscomp$destructuring$var333=goog.require("grrUi.core.semanticRegistryService");var SemanticRegistryService=$jscomp$destructuring$var333.SemanticRegistryService;
var $jscomp$destructuring$var334=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var334.coreModule;exports.outputPluginsModule=angular.module("grrUi.outputPlugins",[coreModule.name,"ui.bootstrap"]);exports.outputPluginsModule.directive(OutputPluginsNotesDirective.directive_name,OutputPluginsNotesDirective);exports.outputPluginsModule.directive(OutputPluginLogsDirective.directive_name,OutputPluginLogsDirective);exports.outputPluginsModule.directive(OutputPluginNoteDirective.directive_name,
OutputPluginNoteDirective);exports.outputPluginsModule.directive(OutputPluginNoteBodyDirective.directive_name,OutputPluginNoteBodyDirective);exports.outputPluginsModule.service(SemanticRegistryService.output_plugins_service_name,SemanticRegistryService);exports.outputPluginsModule.run(function(grrOutputPluginsDirectivesRegistryService){});return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.sidebar.clientSummaryDirective");goog.module.declareLegacyNamespace();var ClientSummaryController=function($scope,grrApiService,grrTimeService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrTimeService_=grrTimeService;this.approvalReason;this.lastIP;this.crashTime;this.scope_.$watch("client",this.onClientChange_.bind(this))};ClientSummaryController.prototype.onClientChange_=function(){if(!this.scope_["client"])return;
if(this.scope_["client"]["value"]["last_crash_at"]){var currentTimeMs=this.grrTimeService_.getCurrentTimeMs();var crashTime=this.scope_["client"]["value"]["last_crash_at"]["value"];if(angular.isDefined(crashTime)&&currentTimeMs/1E3-crashTime/1E6<60*60*24)this.crashTime=crashTime}var clientId=this.scope_["client"]["value"]["client_id"]["value"];var lastIPUrl="clients/"+clientId+"/last-ip";this.grrApiService_.get(lastIPUrl).then(function(response){this.lastIP=response.data}.bind(this));var approvalUrl=
"users/me/approvals/client/"+clientId;this.grrApiService_.get(approvalUrl).then(function(response){var approvals=response.data["items"];if(approvals&&approvals.length)this.approvalReason=approvals[0]["value"]["reason"]["value"]}.bind(this))};exports.ClientSummaryDirective=function(){return{scope:{client:"="},restrict:"E",templateUrl:"/static/angular-components/sidebar/client-summary.html",controller:ClientSummaryController,controllerAs:"controller"}};exports.ClientSummaryDirective.directive_name=
"grrClientSummary";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.sidebar.navDropdownDirective");goog.module.declareLegacyNamespace();exports.NavDropdownController=function(){this.isCollapsed=true};var NavDropdownController=exports.NavDropdownController;exports.NavDropdownDirective=function(){return{scope:{title:"@"},restrict:"A",transclude:true,templateUrl:"/static/angular-components/sidebar/nav-dropdown.html",controller:NavDropdownController,controllerAs:"controller"}};exports.NavDropdownDirective.directive_name=
"grrNavDropdown";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.sidebar.navLinkDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var335=goog.require("grrUi.sidebar.navDropdownDirective");var NavDropdownController=$jscomp$destructuring$var335.NavDropdownController;var $jscomp$destructuring$var336=goog.require("grrUi.routing.routingService");var RoutingService=$jscomp$destructuring$var336.RoutingService;var NavLinkController=function($scope,$element,grrRoutingService){this.scope_=
$scope;this.element_=$element;this.grrRoutingService_=grrRoutingService;this.navDropdownController;this.isActive=false;this.href;this.scope_.$watchGroup(["state","params"],this.onStateOrParamsChange_.bind(this));this.grrRoutingService_.onStateChange(this.scope_,this.applyActiveState_.bind(this))};NavLinkController.prototype.onStateOrParamsChange_=function(){this.href="#";if(angular.isDefined(this.scope_["state"]))this.href=this.grrRoutingService_.href(this.scope_["state"],this.scope_["params"])};
NavLinkController.prototype.openLink=function(event){event.preventDefault();if(this.scope_["disabled"])return;this.grrRoutingService_.go(this.scope_["state"],this.scope_["params"])};NavLinkController.prototype.applyActiveState_=function(activeState){this.isActive=activeState===this.scope_["state"];if(this.isActive){this.element_.addClass("active");if(this.navDropdownController)this.navDropdownController.isCollapsed=false}else this.element_.removeClass("active")};exports.NavLinkDirective=function(){return{scope:{state:"@",
params:"=?",disabled:"=?"},restrict:"A",require:"?^grrNavDropdown",transclude:true,templateUrl:"/static/angular-components/sidebar/nav-link.html",controller:NavLinkController,controllerAs:"controller",link:function(scope,elem,attr,navDropdownController){scope.controller.navDropdownController=navDropdownController}}};exports.NavLinkDirective.directive_name="grrNavLink";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.sidebar.navigatorDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var337=goog.require("grrUi.core.apiService");var ApiService=$jscomp$destructuring$var337.ApiService;var stripTypeInfo=$jscomp$destructuring$var337.stripTypeInfo;var $jscomp$destructuring$var338=goog.require("grrUi.routing.routingService");var RoutingService=$jscomp$destructuring$var338.RoutingService;var NavigatorController=function($scope,grrApiService,
grrRoutingService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrRoutingService_=grrRoutingService;this.client;this.clientId;this.hasClientAccess=false;this.uiTraits;this.grrApiService_.getCached("users/me").then(function(response){this.uiTraits=stripTypeInfo(response["data"])["interface_traits"]}.bind(this));this.grrRoutingService_.uiOnParamsChanged(this.scope_,"clientId",this.onClientSelectionChange_.bind(this),true)};NavigatorController.prototype.onClientSelectionChange_=function(clientId){if(!clientId)return;
if(clientId.indexOf("aff4:/")===0)clientId=clientId.split("/")[1];if(this.clientId===clientId)return;this.clientId=clientId;this.client=null;this.refreshClientDetails();this.checkClientAccess_()};NavigatorController.prototype.refreshClientDetails=function(){var url="clients/"+this.clientId;this.grrApiService_.get(url).then(this.onClientDetailsFetched_.bind(this))};NavigatorController.prototype.onClientDetailsFetched_=function(response){this.client=response["data"]};NavigatorController.prototype.checkClientAccess_=
function(){this.grrApiService_.head("clients/"+this.clientId+"/flows").then(function resolve(){this.hasClientAccess=true}.bind(this),function reject(){this.hasClientAccess=false}.bind(this))};exports.NavigatorDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/sidebar/navigator.html",controller:NavigatorController,controllerAs:"controller"}};exports.NavigatorDirective.directive_name="grrNavigator";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.sidebar.sidebar");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var339=goog.require("grrUi.sidebar.clientSummaryDirective");var ClientSummaryDirective=$jscomp$destructuring$var339.ClientSummaryDirective;var $jscomp$destructuring$var340=goog.require("grrUi.sidebar.navDropdownDirective");var NavDropdownDirective=$jscomp$destructuring$var340.NavDropdownDirective;var $jscomp$destructuring$var341=goog.require("grrUi.sidebar.navLinkDirective");
var NavLinkDirective=$jscomp$destructuring$var341.NavLinkDirective;var $jscomp$destructuring$var342=goog.require("grrUi.sidebar.navigatorDirective");var NavigatorDirective=$jscomp$destructuring$var342.NavigatorDirective;exports.sidebarModule=angular.module("grrUi.sidebar",[]);exports.sidebarModule.directive(ClientSummaryDirective.directive_name,ClientSummaryDirective);exports.sidebarModule.directive(NavDropdownDirective.directive_name,NavDropdownDirective);exports.sidebarModule.directive(NavLinkDirective.directive_name,
NavLinkDirective);exports.sidebarModule.directive(NavigatorDirective.directive_name,NavigatorDirective);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.user.userDashboardDirective");goog.module.declareLegacyNamespace();var UserDashboardController=function($scope,grrApiService,grrRoutingService){this.scope_=$scope;this.grrApiService_=grrApiService;this.grrRoutingService_=grrRoutingService;this.clientApprovals;this.grrApiService_.get("/users/me/approvals/client",{count:7}).then(this.onApprovals_.bind(this));this.grrApiService_.get("/hunts",{count:5,active_within:"31d",created_by:"me"}).then(this.onHunts_.bind(this))};
UserDashboardController.prototype.onApprovals_=function(response){this.clientApprovals=response["data"]["items"]};UserDashboardController.prototype.onHunts_=function(response){this.hunts=response["data"]["items"]};UserDashboardController.prototype.onClientClicked=function(clientId){this.grrRoutingService_.go("client",{clientId:clientId})};UserDashboardController.prototype.onHuntClicked=function(hunt){var huntId=hunt["value"]["urn"]["value"].split("/")[2];this.grrRoutingService_.go("hunts",{huntId:huntId})};
exports.UserDashboardDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/user/user-dashboard.html",controller:UserDashboardController,controllerAs:"controller"}};exports.UserDashboardDirective.directive_name="grrUserDashboard";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.user.userNotificationButtonDirective");goog.module.declareLegacyNamespace();var SECOND=1E3;var FETCH_INTERVAL=10*SECOND;var UserNotificationButtonController=function($scope,$interval,$uibModal,grrApiService){this.scope_=$scope;this.interval_=$interval;this.uibModal_=$uibModal;this.grrApiService_=grrApiService;this.notificationCount=0;this.fetchNotificationCount_();this.interval_(this.fetchNotificationCount_.bind(this),FETCH_INTERVAL)};
UserNotificationButtonController.prototype.fetchNotificationCount_=function(){this.grrApiService_.get("users/me/notifications/pending/count").then(function(response){this.notificationCount=response.data["count"]}.bind(this))};UserNotificationButtonController.prototype.showNotifications=function(){var modalScope=this.scope_.$new();var modalInstance=this.uibModal_.open({template:'<grr-user-notification-dialog close="$close()" />',scope:modalScope,size:"lg"});modalInstance.result.finally(function(){this.notificationCount=
0}.bind(this))};exports.UserNotificationButtonDirective=function(){return{scope:true,restrict:"E",templateUrl:"/static/angular-components/user/user-notification-button.html",controller:UserNotificationButtonController,controllerAs:"controller"}};var UserNotificationButtonDirective=exports.UserNotificationButtonDirective;UserNotificationButtonDirective.directive_name="grrUserNotificationButton";UserNotificationButtonDirective.fetch_interval=FETCH_INTERVAL;return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.user.userNotificationItemDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var343=goog.require("grrUi.core.apiService");var encodeUrlPath=$jscomp$destructuring$var343.encodeUrlPath;var stripTypeInfo=$jscomp$destructuring$var343.stripTypeInfo;var $jscomp$destructuring$var344=goog.require("grrUi.core.utils");var getLastPathComponent=$jscomp$destructuring$var344.getLastPathComponent;var stripAff4Prefix=$jscomp$destructuring$var344.stripAff4Prefix;
exports.openReference=function(notification,angularWindow){if(!notification["isFileDownload"]&&notification["link"]){angularWindow.location.href="#/"+notification["link"];return true}else return false};var openReference=exports.openReference;exports.annotateApiNotification=function(notification){notification["isPending"]=notification["value"]["is_pending"]["value"];if(angular.isDefined(notification["value"]["reference"])){notification["link"]=getLink_(notification);notification["refType"]=notification["value"]["reference"]["value"]["type"]["value"]}};
var annotateApiNotification=exports.annotateApiNotification;var getLink_=function(notification){var strippedNotification=stripTypeInfo(notification);if(!strippedNotification["reference"]||!strippedNotification["reference"]["type"])return null;var reference=strippedNotification["reference"];var referenceType=reference["type"];var referenceDetails=reference[referenceType.toLowerCase()];var urlParameters={};if(referenceType==="DISCOVERY")return["clients",stripAff4Prefix(referenceDetails["client_id"])].join("/");
else if(referenceType==="HUNT"){var huntId=getLastPathComponent(referenceDetails["hunt_urn"]);return["hunts",huntId].join("/")}else if(referenceType==="CRON"){var cronJobName=getLastPathComponent(referenceDetails["cron_job_urn"]);return["crons",cronJobName].join("/")}else if(referenceType==="VFS")return["clients",stripAff4Prefix(referenceDetails["client_id"]),"vfs",encodeUrlPath(stripAff4Prefix(referenceDetails["vfs_path"]))].join("/");else if(referenceType=="FLOW"){var flowId=referenceDetails["flow_id"];
return["clients",stripAff4Prefix(referenceDetails["client_id"]),"flows",flowId].join("/")}else if(referenceType==="CLIENT_APPROVAL"){var clientId=stripAff4Prefix(referenceDetails["client_id"]);return["users",referenceDetails["username"],"approvals","client",clientId,referenceDetails["approval_id"]].join("/")}else if(referenceType==="HUNT_APPROVAL")return["users",referenceDetails["username"],"approvals","hunt",referenceDetails["hunt_id"],referenceDetails["approval_id"]].join("/");else if(referenceType===
"CRON_JOB_APPROVAL")return["users",referenceDetails["username"],"approvals","cron-job",referenceDetails["cron_job_id"],referenceDetails["approval_id"]].join("/");return null};var UserNotificationItemController=function($scope,$window){this.scope_=$scope;this.window_=$window;this.scope_.$watch("notification",this.onNotificationChanged_.bind(this))};UserNotificationItemController.prototype.onNotificationChanged_=function(notification){annotateApiNotification(notification)};UserNotificationItemController.prototype.openReference=
function(){if(openReference(this.scope_["notification"],this.window_))this.scope_["close"]()};exports.UserNotificationItemDirective=function(){return{scope:{notification:"=",close:"&"},restrict:"E",templateUrl:"/static/angular-components/user/user-notification-item.html",controller:UserNotificationItemController,controllerAs:"controller"}};exports.UserNotificationItemDirective.directive_name="grrUserNotificationItem";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.user.userDesktopNotificationsDirective");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var345=goog.require("grrUi.user.userNotificationButtonDirective");var UserNotificationButtonDirective=$jscomp$destructuring$var345.UserNotificationButtonDirective;var $jscomp$destructuring$var346=goog.require("grrUi.user.userNotificationItemDirective");var annotateApiNotification=$jscomp$destructuring$var346.annotateApiNotification;
var openReference=$jscomp$destructuring$var346.openReference;document.addEventListener("DOMContentLoaded",function(){if(Notification&&Notification.permission!=="granted")Notification.requestPermission()});var FETCH_INTERVAL=UserNotificationButtonDirective.fetch_interval;var MAX_DISPLAYED_NOTIFICATIONS=2;var UserDesktopNotificationsController=function($scope,$interval,$window,grrApiService,grrTimeService){if(!Notification)return;this.scope_=$scope;this.interval_=$interval;this.window_=$window;this.grrApiService_=
grrApiService;this.timeService_=grrTimeService;this.notifications_=[];this.lastTimestamp_=this.timeService_.getCurrentTimeMs()*1E3;this.interval_(this.fetchPendingNotifications_.bind(this),FETCH_INTERVAL)};UserDesktopNotificationsController.prototype.notify_=function(title,body,tag,opt_onclick){var notification=new Notification(title,{body:body,icon:"static/images/grr_logo_notification.png",tag:tag});notification.onclick=function(){this.window_.focus();notification.close();if(angular.isDefined(opt_onclick))opt_onclick()}.bind(this);
this.notifications_.push(notification);if(this.notifications_.length>MAX_DISPLAYED_NOTIFICATIONS)this.notifications_.shift().close();return notification};UserDesktopNotificationsController.prototype.fetchPendingNotifications_=function(){this.grrApiService_.get("users/me/notifications/pending",{timestamp:this.lastTimestamp_}).then(function(response){var items=response["data"]["items"];if(items.length==0)return;items.sort(function(lhs,rhs){return lhs["value"]["timestamp"]["value"]-rhs["value"]["timestamp"]["value"]});
this.lastTimestamp_=items[items.length-1]["value"]["timestamp"]["value"];if(items.length>MAX_DISPLAYED_NOTIFICATIONS)items=items.slice(-MAX_DISPLAYED_NOTIFICATIONS);for(var i=0;i<items.length;++i){var item=items[i];annotateApiNotification(item);this.notify_("GRR",item["value"]["message"]["value"],"GRR"+item["value"]["timestamp"]["value"],function(){this.grrApiService_.delete("users/me/notifications/pending/"+item["value"]["timestamp"]["value"]);openReference(item,this.window_)}.bind(this))}}.bind(this))};
exports.UserDesktopNotificationsDirective=function(){return{scope:true,restrict:"E",controller:UserDesktopNotificationsController,controllerAs:"controller"}};var UserDesktopNotificationsDirective=exports.UserDesktopNotificationsDirective;UserDesktopNotificationsDirective.directive_name="grrUserDesktopNotifications";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.user.userLabelDirective");goog.module.declareLegacyNamespace();var UserLabelController=function($scope,grrApiService){this.scope_=$scope;this.grrApiService_=grrApiService;this.username;this.error;this.grrApiService_.getCached("users/me").then(function(response){this.username=response.data["value"]["username"]["value"]}.bind(this),function(error){if(error["status"]==403)this.error="Authentication Error";else this.error=error["statusText"]||
"Error"}.bind(this))};exports.UserLabelDirective=function(){return{scope:true,restrict:"E",templateUrl:"/static/angular-components/user/user-label.html",controller:UserLabelController,controllerAs:"controller"}};var UserLabelDirective=exports.UserLabelDirective;UserLabelDirective.directive_name="grrUserLabel";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.user.userNotificationDialogDirective");goog.module.declareLegacyNamespace();var UserNotificationDialogController=function($scope){this.scope_=$scope;this.notificationUrl="users/me/notifications"};exports.UserNotificationDialogDirective=function(){return{scope:{close:"&"},restrict:"E",templateUrl:"/static/angular-components/user/user-notification-dialog.html",controller:UserNotificationDialogController,controllerAs:"controller"}};exports.UserNotificationDialogDirective.directive_name=
"grrUserNotificationDialog";return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.user.userSettingsButtonDirective");goog.module.declareLegacyNamespace();var UserSettingsButtonController=function($scope,$uibModal,$timeout,$window,grrApiService){this.scope_=$scope;this.uibModal_=$uibModal;this.timeout_=$timeout;this.window_=$window;this.grrApiService_=grrApiService;this.requestSent;this.done;this.error;this.userSettings};UserSettingsButtonController.prototype.onClick=function(){this.requestSent=false;this.done=false;
this.error=undefined;this.userSettings=undefined;this.grrApiService_.getCached("users/me").then(function(response){this.userSettings=response["data"]["value"]["settings"]}.bind(this));this.uibModal_.open({templateUrl:"/static/angular-components/user/"+"user-settings-button-modal.html",scope:this.scope_})};UserSettingsButtonController.prototype.saveSettings=function(){var newUser={type:"GRRUser",value:{settings:this.userSettings}};this.grrApiService_.post("users/me",newUser,true).then(function success(){this.done=
true;this.timeout_(this.window_.location.reload.bind(this.window_.location),500)}.bind(this),function failure(response){this.done=true;this.error=response.data.message||"Unknown error."}.bind(this));this.requestSent=true};exports.UserSettingsButtonDirective=function(){return{scope:{},restrict:"E",templateUrl:"/static/angular-components/user/"+"user-settings-button.html",controller:UserSettingsButtonController,controllerAs:"controller"}};exports.UserSettingsButtonDirective.directive_name="grrUserSettingsButton";
return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.user.user");goog.module.declareLegacyNamespace();var $jscomp$destructuring$var347=goog.require("grrUi.user.userDashboardDirective");var UserDashboardDirective=$jscomp$destructuring$var347.UserDashboardDirective;var $jscomp$destructuring$var348=goog.require("grrUi.user.userDesktopNotificationsDirective");var UserDesktopNotificationsDirective=$jscomp$destructuring$var348.UserDesktopNotificationsDirective;var $jscomp$destructuring$var349=
goog.require("grrUi.user.userLabelDirective");var UserLabelDirective=$jscomp$destructuring$var349.UserLabelDirective;var $jscomp$destructuring$var350=goog.require("grrUi.user.userNotificationButtonDirective");var UserNotificationButtonDirective=$jscomp$destructuring$var350.UserNotificationButtonDirective;var $jscomp$destructuring$var351=goog.require("grrUi.user.userNotificationDialogDirective");var UserNotificationDialogDirective=$jscomp$destructuring$var351.UserNotificationDialogDirective;var $jscomp$destructuring$var352=
goog.require("grrUi.user.userNotificationItemDirective");var UserNotificationItemDirective=$jscomp$destructuring$var352.UserNotificationItemDirective;var $jscomp$destructuring$var353=goog.require("grrUi.user.userSettingsButtonDirective");var UserSettingsButtonDirective=$jscomp$destructuring$var353.UserSettingsButtonDirective;var $jscomp$destructuring$var354=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var354.coreModule;var $jscomp$destructuring$var355=goog.require("grrUi.forms.forms");
var formsModule=$jscomp$destructuring$var355.formsModule;exports.userModule=angular.module("grrUi.user",[coreModule.name,formsModule.name]);exports.userModule.directive(UserDashboardDirective.directive_name,UserDashboardDirective);exports.userModule.directive(UserDesktopNotificationsDirective.directive_name,UserDesktopNotificationsDirective);exports.userModule.directive(UserLabelDirective.directive_name,UserLabelDirective);exports.userModule.directive(UserNotificationButtonDirective.directive_name,
UserNotificationButtonDirective);exports.userModule.directive(UserNotificationDialogDirective.directive_name,UserNotificationDialogDirective);exports.userModule.directive(UserNotificationItemDirective.directive_name,UserNotificationItemDirective);exports.userModule.directive(UserSettingsButtonDirective.directive_name,UserSettingsButtonDirective);return exports});goog.loadModule(function(exports){"use strict";goog.module("grrUi.appController");goog.module.declareLegacyNamespace();var templatesModule=goog.require("grrUi.templates.templates.templatesModule");var $jscomp$destructuring$var356=goog.require("grrUi.acl.acl");var aclModule=$jscomp$destructuring$var356.aclModule;var $jscomp$destructuring$var357=goog.require("grrUi.artifact.artifact");var artifactModule=$jscomp$destructuring$var357.artifactModule;var $jscomp$destructuring$var358=goog.require("grrUi.client.client");
var clientModule=$jscomp$destructuring$var358.clientModule;var $jscomp$destructuring$var359=goog.require("grrUi.config.config");var configModule=$jscomp$destructuring$var359.configModule;var $jscomp$destructuring$var360=goog.require("grrUi.core.core");var coreModule=$jscomp$destructuring$var360.coreModule;var $jscomp$destructuring$var361=goog.require("grrUi.cron.cron");var cronModule=$jscomp$destructuring$var361.cronModule;var $jscomp$destructuring$var362=goog.require("grrUi.docs.docs");var docsModule=
$jscomp$destructuring$var362.docsModule;var $jscomp$destructuring$var363=goog.require("grrUi.flow.flow");var flowModule=$jscomp$destructuring$var363.flowModule;var $jscomp$destructuring$var364=goog.require("grrUi.forms.forms");var formsModule=$jscomp$destructuring$var364.formsModule;var $jscomp$destructuring$var365=goog.require("grrUi.hunt.hunt");var huntModule=$jscomp$destructuring$var365.huntModule;var $jscomp$destructuring$var366=goog.require("grrUi.local.local");var localModule=$jscomp$destructuring$var366.localModule;
var $jscomp$destructuring$var367=goog.require("grrUi.outputPlugins.outputPlugins");var outputPluginsModule=$jscomp$destructuring$var367.outputPluginsModule;var $jscomp$destructuring$var368=goog.require("grrUi.routing.routing");var routingModule=$jscomp$destructuring$var368.routingModule;var $jscomp$destructuring$var369=goog.require("grrUi.semantic.semantic");var semanticModule=$jscomp$destructuring$var369.semanticModule;var $jscomp$destructuring$var370=goog.require("grrUi.sidebar.sidebar");var sidebarModule=
$jscomp$destructuring$var370.sidebarModule;var $jscomp$destructuring$var371=goog.require("grrUi.stats.stats");var statsModule=$jscomp$destructuring$var371.statsModule;var $jscomp$destructuring$var372=goog.require("grrUi.user.user");var userModule=$jscomp$destructuring$var372.userModule;exports.appControllerModule=angular.module("grrUi.appController",[aclModule.name,artifactModule.name,clientModule.name,configModule.name,coreModule.name,cronModule.name,docsModule.name,flowModule.name,formsModule.name,
huntModule.name,localModule.name,outputPluginsModule.name,routingModule.name,semanticModule.name,statsModule.name,sidebarModule.name,templatesModule.name,userModule.name]);window.grrInterceptedErrors_=[];exports.appControllerModule.config(function($httpProvider,$interpolateProvider,$qProvider,$locationProvider,$rootScopeProvider,$provide){$interpolateProvider.startSymbol("{$");$interpolateProvider.endSymbol("$}");$httpProvider.defaults.headers.post["Content-Type"]="application/x-www-form-urlencoded";
$qProvider.errorOnUnhandledRejections(false);$locationProvider.hashPrefix("");$rootScopeProvider.digestTtl(50);$provide.decorator("$exceptionHandler",function($delegate){return function(exception,cause){window.grrInterceptedErrors_.push(exception.stack||exception.toString());$delegate(exception,cause)}})});exports.appControllerModule.run(function($injector,$http,$cookies,grrFirebaseService,grrReflectionService){$http.defaults.headers.post["X-CSRFToken"]=$cookies.get("csrftoken");$http.defaults.headers.delete=
$http.defaults.headers.patch={"X-CSRFToken":$cookies.get("csrftoken")};grrFirebaseService.setupIfNeeded();grrReflectionService.getRDFValueDescriptor("ACLToken")});$["jstree"]["_themes"]="/static/third-party/jstree/themes/";jQuery["migrateMute"]=true;exports.appControllerModule.controller("GrrUiAppController",function(){});return exports});
//# sourceMappingURL=grr-ui.bundle.js.map