/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.util.cache.FileCache;
import ucar.unidata.geoloc.LatLonRect;

public abstract class FeatureDatasetImpl
implements FeatureDataset {
    protected NetcdfDataset ncfile;
    protected String title;
    protected String desc;
    protected String location;
    protected List<VariableSimpleIF> dataVariables;
    protected Formatter parseInfo = new Formatter();
    protected CalendarDateRange dateRange;
    protected LatLonRect boundingBox;
    protected FileCache fileCache;

    protected FeatureDatasetImpl(FeatureDatasetImpl from) {
        this.ncfile = from.ncfile;
        this.title = from.title;
        this.desc = from.desc;
        this.location = from.location;
        this.dataVariables = new ArrayList<VariableSimpleIF>(from.dataVariables);
        this.parseInfo = new Formatter();
        String fromInfo = from.parseInfo.toString().trim();
        if (fromInfo.length() > 0) {
            this.parseInfo.format("%s\n", fromInfo);
        }
        this.parseInfo.format("Subsetted from original\n", new Object[0]);
    }

    public FeatureDatasetImpl() {
    }

    public FeatureDatasetImpl(String title, String description, String location) {
        this.title = title;
        this.desc = description;
        this.location = location;
    }

    public FeatureDatasetImpl(NetcdfDataset ncfile) {
        this.ncfile = ncfile;
        this.location = ncfile.getLocation();
        this.title = ncfile.getTitle();
        if (this.title == null) {
            this.title = ncfile.findAttValueIgnoreCase(null, "title", null);
        }
        if (this.desc == null) {
            this.desc = ncfile.findAttValueIgnoreCase(null, "description", null);
        }
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setDescription(String desc) {
        this.desc = desc;
    }

    protected void setLocationURI(String location) {
        this.location = location;
    }

    protected void setDateRange(CalendarDateRange dateRange) {
        this.dateRange = dateRange;
    }

    protected void setBoundingBox(LatLonRect boundingBox) {
        this.boundingBox = boundingBox;
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        if (this.ncfile == null) {
            return new ArrayList<Attribute>();
        }
        return this.ncfile.getGlobalAttributes();
    }

    @Override
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        if (this.ncfile == null) {
            return null;
        }
        return this.ncfile.findGlobalAttributeIgnoreCase(name);
    }

    @Override
    public void getDetailInfo(Formatter sf) {
        sf.format("FeatureDataset on location= %s\n", this.getLocation());
        sf.format("  featureType= %s\n", new Object[]{this.getFeatureType()});
        sf.format("  title= %s\n", this.getTitle());
        sf.format("  desc= %s\n", this.getDescription());
        sf.format("  range= %s\n", this.getCalendarDateRange());
        sf.format("  start= %s\n", this.getCalendarDateEnd());
        sf.format("  end  = %s\n", this.getCalendarDateEnd());
        LatLonRect bb = this.getBoundingBox();
        sf.format("  bb   = %s\n", bb);
        if (bb != null) {
            sf.format("  bb   = %s\n", this.getBoundingBox().toString2());
        }
        sf.format("  has netcdf = %b\n", this.getNetcdfFile() != null);
        List<Attribute> ga = this.getGlobalAttributes();
        if (ga.size() > 0) {
            sf.format("  Attributes\n", new Object[0]);
            for (Attribute a : ga) {
                sf.format("    %s\n", a);
            }
        }
        List<VariableSimpleIF> vars = this.getDataVariables();
        sf.format("  Data Variables (%d)\n", vars.size());
        for (VariableSimpleIF v : vars) {
            sf.format("    name='%s' desc='%s' units=%s' type='%s'\n", new Object[]{v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType()});
        }
        sf.format("\nparseInfo=\n%s\n", this.parseInfo);
    }

    @Override
    public CalendarDateRange getCalendarDateRange() {
        return this.dateRange;
    }

    @Override
    public CalendarDate getCalendarDateStart() {
        return this.dateRange == null ? null : this.dateRange.getStart();
    }

    @Override
    public CalendarDate getCalendarDateEnd() {
        return this.dateRange == null ? null : this.dateRange.getEnd();
    }

    @Override
    public DateRange getDateRange() {
        return this.dateRange == null ? null : this.dateRange.toDateRange();
    }

    @Override
    public Date getStartDate() {
        return this.getDateRange() == null ? null : this.getDateRange().getStart().getDate();
    }

    @Override
    public Date getEndDate() {
        return this.getDateRange() == null ? null : this.getDateRange().getEnd().getDate();
    }

    @Override
    public LatLonRect getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public List<VariableSimpleIF> getDataVariables() {
        return this.dataVariables == null ? new ArrayList() : this.dataVariables;
    }

    @Override
    public VariableSimpleIF getDataVariable(String shortName) {
        for (VariableSimpleIF s : this.getDataVariables()) {
            String ss = s.getShortName();
            if (!shortName.equals(ss)) continue;
            return s;
        }
        return null;
    }

    @Override
    public String getImplementationName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.fileCache != null) {
            this.fileCache.release(this);
        } else {
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
            }
            finally {
                this.ncfile = null;
            }
        }
    }

    @Override
    public long getLastModified() {
        return this.ncfile != null ? this.ncfile.getLastModified() : 0L;
    }

    @Override
    public void setFileCache(FileCache fileCache) {
        this.fileCache = fileCache;
    }
}

