/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteOrder;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJLoader;

public class TJCompressor {
    private static final String NO_ASSOC_ERROR = "No source image is associated with this instance";
    private long handle = 0L;
    private byte[] srcBuf = null;
    private int srcWidth = 0;
    private int srcHeight = 0;
    private int srcPitch = 0;
    private int srcPixelFormat = -1;
    private int subsamp = -1;
    private int jpegQuality = -1;
    private int compressedSize = 0;
    private ByteOrder byteOrder = null;

    public TJCompressor() throws Exception {
        this.init();
    }

    public TJCompressor(byte[] srcImage, int width, int pitch, int height, int pixelFormat) throws Exception {
        this.setSourceImage(srcImage, width, pitch, height, pixelFormat);
    }

    public void setSourceImage(byte[] srcImage, int width, int pitch, int height, int pixelFormat) throws Exception {
        if (this.handle == 0L) {
            this.init();
        }
        if (srcImage == null || width < 1 || height < 1 || pitch < 0 || pixelFormat < 0 || pixelFormat >= 11) {
            throw new Exception("Invalid argument in setSourceImage()");
        }
        this.srcBuf = srcImage;
        this.srcWidth = width;
        this.srcPitch = pitch == 0 ? width * TJ.getPixelSize(pixelFormat) : pitch;
        this.srcHeight = height;
        this.srcPixelFormat = pixelFormat;
    }

    public void setSubsamp(int newSubsamp) throws Exception {
        if (newSubsamp < 0 || newSubsamp >= 5) {
            throw new Exception("Invalid argument in setSubsamp()");
        }
        this.subsamp = newSubsamp;
    }

    public void setJPEGQuality(int quality) throws Exception {
        if (quality < 1 || quality > 100) {
            throw new Exception("Invalid argument in setJPEGQuality()");
        }
        this.jpegQuality = quality;
    }

    public void compress(byte[] dstBuf, int flags) throws Exception {
        if (dstBuf == null || flags < 0) {
            throw new Exception("Invalid argument in compress()");
        }
        if (this.srcBuf == null) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        if (this.jpegQuality < 0) {
            throw new Exception("JPEG Quality not set");
        }
        if (this.subsamp < 0) {
            throw new Exception("Subsampling level not set");
        }
        this.compressedSize = this.compress(this.srcBuf, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, dstBuf, this.subsamp, this.jpegQuality, flags);
    }

    public byte[] compress(int flags) throws Exception {
        if (this.srcWidth < 1 || this.srcHeight < 1) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        byte[] buf = new byte[TJ.bufSize(this.srcWidth, this.srcHeight, this.subsamp)];
        this.compress(buf, flags);
        return buf;
    }

    public void compress(BufferedImage srcImage, byte[] dstBuf, int flags) throws Exception {
        int pixelFormat;
        if (srcImage == null || dstBuf == null || flags < 0) {
            throw new Exception("Invalid argument in compress()");
        }
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        boolean intPixels = false;
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.nativeOrder();
        }
        switch (srcImage.getType()) {
            case 5: {
                pixelFormat = 1;
                break;
            }
            case 6: 
            case 7: {
                pixelFormat = 4;
                break;
            }
            case 10: {
                pixelFormat = 6;
                break;
            }
            case 4: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 2;
                intPixels = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 5 : 3;
                intPixels = true;
                break;
            }
            default: {
                throw new Exception("Unsupported BufferedImage format");
            }
        }
        WritableRaster wr = srcImage.getRaster();
        if (this.jpegQuality < 0) {
            throw new Exception("JPEG Quality not set");
        }
        if (this.subsamp < 0) {
            throw new Exception("Subsampling level not set");
        }
        if (intPixels) {
            SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)srcImage.getSampleModel();
            int pitch = sm.getScanlineStride();
            DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
            int[] buf = db.getData();
            this.compressedSize = this.compress(buf, width, pitch, height, pixelFormat, dstBuf, this.subsamp, this.jpegQuality, flags);
        } else {
            ComponentSampleModel sm = (ComponentSampleModel)srcImage.getSampleModel();
            int pixelSize = sm.getPixelStride();
            if (pixelSize != TJ.getPixelSize(pixelFormat)) {
                throw new Exception("Inconsistency between pixel format and pixel size in BufferedImage");
            }
            int pitch = sm.getScanlineStride();
            DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
            byte[] buf = db.getData();
            this.compressedSize = this.compress(buf, width, pitch, height, pixelFormat, dstBuf, this.subsamp, this.jpegQuality, flags);
        }
    }

    public byte[] compress(BufferedImage srcImage, int flags) throws Exception {
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        byte[] buf = new byte[TJ.bufSize(width, height, this.subsamp)];
        this.compress(srcImage, buf, flags);
        return buf;
    }

    public void encodeYUV(byte[] dstBuf, int flags) throws Exception {
        if (dstBuf == null || flags < 0) {
            throw new Exception("Invalid argument in compress()");
        }
        if (this.srcBuf == null) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        if (this.subsamp < 0) {
            throw new Exception("Subsampling level not set");
        }
        this.encodeYUV(this.srcBuf, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, dstBuf, this.subsamp, flags);
        this.compressedSize = TJ.bufSizeYUV(this.srcWidth, this.srcHeight, this.subsamp);
    }

    public byte[] encodeYUV(int flags) throws Exception {
        if (this.srcWidth < 1 || this.srcHeight < 1) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        if (this.subsamp < 0) {
            throw new Exception("Subsampling level not set");
        }
        byte[] buf = new byte[TJ.bufSizeYUV(this.srcWidth, this.srcHeight, this.subsamp)];
        this.encodeYUV(buf, flags);
        return buf;
    }

    public void encodeYUV(BufferedImage srcImage, byte[] dstBuf, int flags) throws Exception {
        int pixelFormat;
        if (srcImage == null || dstBuf == null || flags < 0) {
            throw new Exception("Invalid argument in encodeYUV()");
        }
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        boolean intPixels = false;
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.nativeOrder();
        }
        switch (srcImage.getType()) {
            case 5: {
                pixelFormat = 1;
                break;
            }
            case 6: 
            case 7: {
                pixelFormat = 4;
                break;
            }
            case 10: {
                pixelFormat = 6;
                break;
            }
            case 4: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 2;
                intPixels = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 5 : 3;
                intPixels = true;
                break;
            }
            default: {
                throw new Exception("Unsupported BufferedImage format");
            }
        }
        WritableRaster wr = srcImage.getRaster();
        if (this.subsamp < 0) {
            throw new Exception("Subsampling level not set");
        }
        if (intPixels) {
            SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)srcImage.getSampleModel();
            int pitch = sm.getScanlineStride();
            DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
            int[] buf = db.getData();
            this.encodeYUV(buf, width, pitch, height, pixelFormat, dstBuf, this.subsamp, flags);
        } else {
            ComponentSampleModel sm = (ComponentSampleModel)srcImage.getSampleModel();
            int pixelSize = sm.getPixelStride();
            if (pixelSize != TJ.getPixelSize(pixelFormat)) {
                throw new Exception("Inconsistency between pixel format and pixel size in BufferedImage");
            }
            int pitch = sm.getScanlineStride();
            DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
            byte[] buf = db.getData();
            this.encodeYUV(buf, width, pitch, height, pixelFormat, dstBuf, this.subsamp, flags);
        }
        this.compressedSize = TJ.bufSizeYUV(width, height, this.subsamp);
    }

    public byte[] encodeYUV(BufferedImage srcImage, int flags) throws Exception {
        if (this.subsamp < 0) {
            throw new Exception("Subsampling level not set");
        }
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        byte[] buf = new byte[TJ.bufSizeYUV(width, height, this.subsamp)];
        this.encodeYUV(srcImage, buf, flags);
        return buf;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    public void close() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private native void init() throws Exception;

    private native void destroy() throws Exception;

    private native int compress(byte[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9) throws Exception;

    private native int compress(int[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9) throws Exception;

    private native void encodeYUV(byte[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8) throws Exception;

    private native void encodeYUV(int[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8) throws Exception;

    static {
        TJLoader.load();
    }
}

