/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.meta;

import java.util.List;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.xml.meta.AbstractOMEXMLMetadata;
import ome.xml.meta.MetadataRoot;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.AffineTransform;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Arc;
import ome.xml.model.BinaryFile;
import ome.xml.model.BinaryOnly;
import ome.xml.model.BooleanAnnotation;
import ome.xml.model.Channel;
import ome.xml.model.CommentAnnotation;
import ome.xml.model.Dataset;
import ome.xml.model.DatasetRef;
import ome.xml.model.Detector;
import ome.xml.model.DetectorSettings;
import ome.xml.model.Dichroic;
import ome.xml.model.DichroicRef;
import ome.xml.model.DoubleAnnotation;
import ome.xml.model.Ellipse;
import ome.xml.model.EmissionFilterRef;
import ome.xml.model.ExcitationFilterRef;
import ome.xml.model.Experiment;
import ome.xml.model.ExperimentRef;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.ExperimenterGroupRef;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Filament;
import ome.xml.model.FileAnnotation;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.FilterSetRef;
import ome.xml.model.GenericExcitationSource;
import ome.xml.model.Image;
import ome.xml.model.ImageRef;
import ome.xml.model.ImagingEnvironment;
import ome.xml.model.Instrument;
import ome.xml.model.InstrumentRef;
import ome.xml.model.Label;
import ome.xml.model.Laser;
import ome.xml.model.Leader;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightPath;
import ome.xml.model.LightSource;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.Line;
import ome.xml.model.ListAnnotation;
import ome.xml.model.LongAnnotation;
import ome.xml.model.Map;
import ome.xml.model.MapAnnotation;
import ome.xml.model.MapPair;
import ome.xml.model.MapPairs;
import ome.xml.model.Mask;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.MicrobeamManipulationRef;
import ome.xml.model.Microscope;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.Objective;
import ome.xml.model.ObjectiveSettings;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.Plate;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.PlateRef;
import ome.xml.model.Point;
import ome.xml.model.Polygon;
import ome.xml.model.Polyline;
import ome.xml.model.Project;
import ome.xml.model.Pump;
import ome.xml.model.ROI;
import ome.xml.model.ROIRef;
import ome.xml.model.Reagent;
import ome.xml.model.ReagentRef;
import ome.xml.model.Rectangle;
import ome.xml.model.Rights;
import ome.xml.model.Screen;
import ome.xml.model.Shape;
import ome.xml.model.StageLabel;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.TagAnnotation;
import ome.xml.model.TermAnnotation;
import ome.xml.model.TiffData;
import ome.xml.model.TimestampAnnotation;
import ome.xml.model.TransmittanceRange;
import ome.xml.model.UUID;
import ome.xml.model.Union;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import ome.xml.model.WellSampleRef;
import ome.xml.model.XMLAnnotation;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.LineCap;
import ome.xml.model.enums.Marker;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public class OMEXMLMetadataImpl
extends AbstractOMEXMLMetadata {
    private OMEXMLMetadataRoot root;
    private OMEModel model;

    public OMEXMLMetadataImpl() {
        this.createRoot();
    }

    @Override
    public void createRoot() {
        this.root = new OMEXMLMetadataRoot();
        this.model = new OMEModelImpl();
    }

    @Override
    public MetadataRoot getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(MetadataRoot root) {
        if (!(root instanceof OMEXMLMetadataRoot)) {
            throw new IllegalArgumentException("Expecting OMEXMLMetadataRoot class or subclass.");
        }
        this.root = (OMEXMLMetadataRoot)root;
        this.model = new OMEModelImpl();
    }

    @Override
    public String dumpXML() {
        this.resolveReferences();
        return super.dumpXML();
    }

    @Override
    public int resolveReferences() {
        return this.model.resolveReferences();
    }

    @Override
    public int getPixelsBinDataCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfBinDataList();
    }

    @Override
    public int getBooleanAnnotationAnnotationCount(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getCommentAnnotationAnnotationCount(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getDoubleAnnotationAnnotationCount(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getFileAnnotationAnnotationCount(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getListAnnotationAnnotationCount(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getLongAnnotationAnnotationCount(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getMapAnnotationAnnotationCount(int mapAnnotationIndex) {
        return this.root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getTagAnnotationAnnotationCount(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getTermAnnotationAnnotationCount(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getTimestampAnnotationAnnotationCount(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getXMLAnnotationAnnotationCount(int xmlAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(xmlAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public String getLightSourceType(int instrumentIndex, int lightSourceIndex) {
        LightSource o = this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        String className = o.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1, className.length());
    }

    @Override
    public String getShapeType(int roiIndex, int shapeIndex) {
        Shape o = this.root.getROI(roiIndex).getUnion().getShape(shapeIndex);
        String className = o.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1, className.length());
    }

    @Override
    public int getLightSourceAnnotationRefCount(int instrumentIndex, int lightSourceIndex) {
        return this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getInstrumentAnnotationRefCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getObjectiveAnnotationRefCount(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getDetectorAnnotationRefCount(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getChannelAnnotationRefCount(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getPlateAnnotationRefCount(int plateIndex) {
        return this.root.getPlate(plateIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getExperimenterGroupAnnotationRefCount(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getScreenAnnotationRefCount(int screenIndex) {
        return this.root.getScreen(screenIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getReagentAnnotationRefCount(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getPlaneAnnotationRefCount(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getExperimenterAnnotationRefCount(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getDichroicAnnotationRefCount(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getWellAnnotationRefCount(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getFilterAnnotationRefCount(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getPlateAcquisitionAnnotationRefCount(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getROIAnnotationRefCount(int ROIIndex) {
        return this.root.getROI(ROIIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getProjectAnnotationRefCount(int projectIndex) {
        return this.root.getProject(projectIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getLightPathAnnotationRefCount(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().sizeOfLinkedAnnotationList();
    }

    @Override
    public int getImageAnnotationRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getDatasetAnnotationRefCount(int datasetIndex) {
        return this.root.getDataset(datasetIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getShapeAnnotationRefCount(int ROIIndex, int shapeIndex) {
        return this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex).sizeOfLinkedAnnotationList();
    }

    @Override
    public int getBooleanAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfBooleanAnnotationList();
    }

    @Override
    public int getChannelCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfChannelList();
    }

    @Override
    public int getCommentAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfCommentAnnotationList();
    }

    @Override
    public int getDatasetCount() {
        return this.root.sizeOfDatasetList();
    }

    @Override
    public int getDatasetRefCount(int projectIndex) {
        return this.root.getProject(projectIndex).sizeOfLinkedDatasetList();
    }

    @Override
    public int getDetectorCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfDetectorList();
    }

    @Override
    public int getDichroicCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfDichroicList();
    }

    @Override
    public int getDoubleAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfDoubleAnnotationList();
    }

    @Override
    public int getLightPathEmissionFilterRefCount(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().sizeOfLinkedEmissionFilterList();
    }

    @Override
    public int getFilterSetEmissionFilterRefCount(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).sizeOfLinkedEmissionFilterList();
    }

    @Override
    public int getLightPathExcitationFilterRefCount(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().sizeOfLinkedExcitationFilterList();
    }

    @Override
    public int getFilterSetExcitationFilterRefCount(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).sizeOfLinkedExcitationFilterList();
    }

    @Override
    public int getExperimentCount() {
        return this.root.sizeOfExperimentList();
    }

    @Override
    public int getExperimenterCount() {
        return this.root.sizeOfExperimenterList();
    }

    @Override
    public int getExperimenterGroupCount() {
        return this.root.sizeOfExperimenterGroupList();
    }

    @Override
    public int getExperimenterGroupExperimenterRefCount(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).sizeOfLinkedExperimenterList();
    }

    @Override
    public int getFileAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfFileAnnotationList();
    }

    @Override
    public int getFilterCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfFilterList();
    }

    @Override
    public int getFilterSetCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfFilterSetList();
    }

    @Override
    public int getImageCount() {
        return this.root.sizeOfImageList();
    }

    @Override
    public int getDatasetImageRefCount(int datasetIndex) {
        return this.root.getDataset(datasetIndex).sizeOfLinkedImageList();
    }

    @Override
    public int getInstrumentCount() {
        return this.root.sizeOfInstrumentList();
    }

    @Override
    public int getLeaderCount(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).sizeOfLinkedLeaderList();
    }

    @Override
    public int getLightSourceCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfLightSourceList();
    }

    @Override
    public int getMicrobeamManipulationLightSourceSettingsCount(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).sizeOfLightSourceSettingsList();
    }

    @Override
    public int getListAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfListAnnotationList();
    }

    @Override
    public int getLongAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfLongAnnotationList();
    }

    @Override
    public int getMapAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfMapAnnotationList();
    }

    @Override
    public int getMicrobeamManipulationCount(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).sizeOfMicrobeamManipulationList();
    }

    @Override
    public int getMicrobeamManipulationRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).sizeOfLinkedMicrobeamManipulationList();
    }

    @Override
    public int getObjectiveCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfObjectiveList();
    }

    @Override
    public int getPlaneCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfPlaneList();
    }

    @Override
    public int getPlateCount() {
        return this.root.sizeOfPlateList();
    }

    @Override
    public int getPlateAcquisitionCount(int plateIndex) {
        return this.root.getPlate(plateIndex).sizeOfPlateAcquisitionList();
    }

    @Override
    public int getPlateRefCount(int screenIndex) {
        return this.root.getScreen(screenIndex).sizeOfLinkedPlateList();
    }

    @Override
    public int getProjectCount() {
        return this.root.sizeOfProjectList();
    }

    @Override
    public int getROICount() {
        return this.root.sizeOfROIList();
    }

    @Override
    public int getImageROIRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).sizeOfLinkedROIList();
    }

    @Override
    public int getMicrobeamManipulationROIRefCount(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).sizeOfLinkedROIList();
    }

    @Override
    public int getReagentCount(int screenIndex) {
        return this.root.getScreen(screenIndex).sizeOfReagentList();
    }

    @Override
    public int getScreenCount() {
        return this.root.sizeOfScreenList();
    }

    @Override
    public int getShapeCount(int ROIIndex) {
        return this.root.getROI(ROIIndex).getUnion().sizeOfShapeList();
    }

    @Override
    public int getTagAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfTagAnnotationList();
    }

    @Override
    public int getTermAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfTermAnnotationList();
    }

    @Override
    public int getTiffDataCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfTiffDataList();
    }

    @Override
    public int getTimestampAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfTimestampAnnotationList();
    }

    @Override
    public void setUUIDValue(String value, int imageIndex, int tiffDataIndex) {
        TiffData o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        if ((o3 = o2.getTiffData(tiffDataIndex)).getUUID() == null) {
            o3.setUUID(new UUID());
        }
        UUID o4 = o3.getUUID();
        o4.setValue(value);
    }

    @Override
    public String getUUIDValue(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getUUID().getValue();
    }

    @Override
    public int getWellCount(int plateIndex) {
        return this.root.getPlate(plateIndex).sizeOfWellList();
    }

    @Override
    public int getWellSampleCount(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).sizeOfWellSampleList();
    }

    @Override
    public int getWellSampleRefCount(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).sizeOfLinkedWellSampleList();
    }

    @Override
    public int getXMLAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfXMLAnnotationList();
    }

    @Override
    public Boolean getPixelsBinDataBigEndian(int imageIndex, int binDataIndex) {
        Boolean bigEndian = this.root.getImage(imageIndex).getPixels().getBigEndian();
        if (bigEndian != null) {
            return bigEndian;
        }
        return this.root.getImage(imageIndex).getPixels().getBinData(binDataIndex).getBigEndian();
    }

    @Override
    public String getUUID() {
        return this.root.getUUID();
    }

    @Override
    public List<MapPair> getMapAnnotationValue(int mapAnnotationIndex) {
        return this.root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getValue().getPairs();
    }

    @Override
    public List<MapPair> getGenericExcitationSourceMap(int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = (GenericExcitationSource)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getMap().getPairs();
    }

    @Override
    public List<MapPair> getImagingEnvironmentMap(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getMap().getPairs();
    }

    @Override
    public String getArcAnnotationRef(int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getArcID(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    @Override
    public String getArcLotNumber(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    @Override
    public String getArcManufacturer(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    @Override
    public String getArcModel(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    @Override
    public Power getArcPower(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    @Override
    public String getArcSerialNumber(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    @Override
    public ArcType getArcType(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getType();
    }

    @Override
    public String getBinaryFileFileName(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getFileName();
    }

    @Override
    public String getBinaryFileMIMEType(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getMIMEType();
    }

    @Override
    public NonNegativeLong getBinaryFileSize(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getSize();
    }

    @Override
    public String getBinaryOnlyMetadataFile() {
        return this.root.getBinaryOnly().getMetadataFile();
    }

    @Override
    public String getBinaryOnlyUUID() {
        return this.root.getBinaryOnly().getUUID();
    }

    @Override
    public String getBooleanAnnotationAnnotationRef(int booleanAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getBooleanAnnotationAnnotator(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getAnnotator();
    }

    @Override
    public String getBooleanAnnotationDescription(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getDescription();
    }

    @Override
    public String getBooleanAnnotationID(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getID();
    }

    @Override
    public String getBooleanAnnotationNamespace(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getNamespace();
    }

    @Override
    public Boolean getBooleanAnnotationValue(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getValue();
    }

    @Override
    public AcquisitionMode getChannelAcquisitionMode(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getAcquisitionMode();
    }

    @Override
    public String getChannelAnnotationRef(int imageIndex, int channelIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Color getChannelColor(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getColor();
    }

    @Override
    public ContrastMethod getChannelContrastMethod(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getContrastMethod();
    }

    @Override
    public Length getChannelEmissionWavelength(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getEmissionWavelength();
    }

    @Override
    public Length getChannelExcitationWavelength(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getExcitationWavelength();
    }

    @Override
    public String getChannelFilterSetRef(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLinkedFilterSet().getID();
    }

    @Override
    public String getChannelFluor(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getFluor();
    }

    @Override
    public String getChannelID(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getID();
    }

    @Override
    public IlluminationType getChannelIlluminationType(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getIlluminationType();
    }

    @Override
    public Double getChannelNDFilter(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getNDFilter();
    }

    @Override
    public String getChannelName(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getName();
    }

    @Override
    public Length getChannelPinholeSize(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getPinholeSize();
    }

    @Override
    public Integer getChannelPockelCellSetting(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getPockelCellSetting();
    }

    @Override
    public PositiveInteger getChannelSamplesPerPixel(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getSamplesPerPixel();
    }

    @Override
    public String getCommentAnnotationAnnotationRef(int commentAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getCommentAnnotationAnnotator(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getAnnotator();
    }

    @Override
    public String getCommentAnnotationDescription(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getDescription();
    }

    @Override
    public String getCommentAnnotationID(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getID();
    }

    @Override
    public String getCommentAnnotationNamespace(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getNamespace();
    }

    @Override
    public String getCommentAnnotationValue(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getValue();
    }

    @Override
    public String getDatasetAnnotationRef(int datasetIndex, int annotationRefIndex) {
        return this.root.getDataset(datasetIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getDatasetDescription(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getDescription();
    }

    @Override
    public String getDatasetExperimenterGroupRef(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getLinkedExperimenterGroup().getID();
    }

    @Override
    public String getDatasetExperimenterRef(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getLinkedExperimenter().getID();
    }

    @Override
    public String getDatasetID(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getID();
    }

    @Override
    public String getDatasetImageRef(int datasetIndex, int imageRefIndex) {
        return this.root.getDataset(datasetIndex).getLinkedImage(imageRefIndex).getID();
    }

    @Override
    public String getDatasetName(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getName();
    }

    @Override
    public Double getDetectorAmplificationGain(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getAmplificationGain();
    }

    @Override
    public String getDetectorAnnotationRef(int instrumentIndex, int detectorIndex, int annotationRefIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Double getDetectorGain(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getGain();
    }

    @Override
    public String getDetectorID(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getID();
    }

    @Override
    public String getDetectorLotNumber(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getLotNumber();
    }

    @Override
    public String getDetectorManufacturer(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getManufacturer();
    }

    @Override
    public String getDetectorModel(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getModel();
    }

    @Override
    public Double getDetectorOffset(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getOffset();
    }

    @Override
    public String getDetectorSerialNumber(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getSerialNumber();
    }

    @Override
    public DetectorType getDetectorType(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getType();
    }

    @Override
    public ElectricPotential getDetectorVoltage(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getVoltage();
    }

    @Override
    public Double getDetectorZoom(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getZoom();
    }

    @Override
    public Binning getDetectorSettingsBinning(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getBinning();
    }

    @Override
    public Double getDetectorSettingsGain(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getGain();
    }

    @Override
    public String getDetectorSettingsID(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getID();
    }

    @Override
    public PositiveInteger getDetectorSettingsIntegration(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getIntegration();
    }

    @Override
    public Double getDetectorSettingsOffset(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getOffset();
    }

    @Override
    public Frequency getDetectorSettingsReadOutRate(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getReadOutRate();
    }

    @Override
    public ElectricPotential getDetectorSettingsVoltage(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getVoltage();
    }

    @Override
    public Double getDetectorSettingsZoom(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getZoom();
    }

    @Override
    public String getDichroicAnnotationRef(int instrumentIndex, int dichroicIndex, int annotationRefIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getDichroicID(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getID();
    }

    @Override
    public String getDichroicLotNumber(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getLotNumber();
    }

    @Override
    public String getDichroicManufacturer(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getManufacturer();
    }

    @Override
    public String getDichroicModel(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getModel();
    }

    @Override
    public String getDichroicSerialNumber(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getSerialNumber();
    }

    @Override
    public String getDoubleAnnotationAnnotationRef(int doubleAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getDoubleAnnotationAnnotator(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getAnnotator();
    }

    @Override
    public String getDoubleAnnotationDescription(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getDescription();
    }

    @Override
    public String getDoubleAnnotationID(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getID();
    }

    @Override
    public String getDoubleAnnotationNamespace(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getNamespace();
    }

    @Override
    public Double getDoubleAnnotationValue(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getValue();
    }

    @Override
    public String getEllipseAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Color getEllipseFillColor(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    @Override
    public FillRule getEllipseFillRule(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    @Override
    public FontFamily getEllipseFontFamily(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    @Override
    public Length getEllipseFontSize(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    @Override
    public FontStyle getEllipseFontStyle(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    @Override
    public String getEllipseID(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    @Override
    public LineCap getEllipseLineCap(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    @Override
    public Boolean getEllipseLocked(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    @Override
    public Color getEllipseStrokeColor(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    @Override
    public String getEllipseStrokeDashArray(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    @Override
    public Length getEllipseStrokeWidth(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    @Override
    public String getEllipseText(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    @Override
    public NonNegativeInteger getEllipseTheC(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    @Override
    public NonNegativeInteger getEllipseTheT(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    @Override
    public NonNegativeInteger getEllipseTheZ(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    @Override
    public AffineTransform getEllipseTransform(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    @Override
    public Boolean getEllipseVisible(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    @Override
    public Double getEllipseRadiusX(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getRadiusX();
    }

    @Override
    public Double getEllipseRadiusY(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getRadiusY();
    }

    @Override
    public Double getEllipseX(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    @Override
    public Double getEllipseY(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    @Override
    public String getExperimentDescription(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getDescription();
    }

    @Override
    public String getExperimentExperimenterRef(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getLinkedExperimenter().getID();
    }

    @Override
    public String getExperimentID(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getID();
    }

    @Override
    public ExperimentType getExperimentType(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getType();
    }

    @Override
    public String getExperimenterAnnotationRef(int experimenterIndex, int annotationRefIndex) {
        return this.root.getExperimenter(experimenterIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getExperimenterEmail(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getEmail();
    }

    @Override
    public String getExperimenterFirstName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getFirstName();
    }

    @Override
    public String getExperimenterID(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getID();
    }

    @Override
    public String getExperimenterInstitution(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getInstitution();
    }

    @Override
    public String getExperimenterLastName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getLastName();
    }

    @Override
    public String getExperimenterMiddleName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getMiddleName();
    }

    @Override
    public String getExperimenterUserName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getUserName();
    }

    @Override
    public String getExperimenterGroupAnnotationRef(int experimenterGroupIndex, int annotationRefIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getExperimenterGroupDescription(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getDescription();
    }

    @Override
    public String getExperimenterGroupExperimenterRef(int experimenterGroupIndex, int experimenterRefIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getLinkedExperimenter(experimenterRefIndex).getID();
    }

    @Override
    public String getExperimenterGroupID(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getID();
    }

    @Override
    public String getExperimenterGroupLeader(int experimenterGroupIndex, int leaderIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getLinkedLeader(leaderIndex).getID();
    }

    @Override
    public String getExperimenterGroupName(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getName();
    }

    @Override
    public String getFilamentAnnotationRef(int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getFilamentID(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    @Override
    public String getFilamentLotNumber(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    @Override
    public String getFilamentManufacturer(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    @Override
    public String getFilamentModel(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    @Override
    public Power getFilamentPower(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    @Override
    public String getFilamentSerialNumber(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    @Override
    public FilamentType getFilamentType(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getType();
    }

    @Override
    public String getFileAnnotationAnnotationRef(int fileAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getFileAnnotationAnnotator(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getAnnotator();
    }

    @Override
    public String getFileAnnotationDescription(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getDescription();
    }

    @Override
    public String getFileAnnotationID(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getID();
    }

    @Override
    public String getFileAnnotationNamespace(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getNamespace();
    }

    @Override
    public String getFilterAnnotationRef(int instrumentIndex, int filterIndex, int annotationRefIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getFilterFilterWheel(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getFilterWheel();
    }

    @Override
    public String getFilterID(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getID();
    }

    @Override
    public String getFilterLotNumber(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getLotNumber();
    }

    @Override
    public String getFilterManufacturer(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getManufacturer();
    }

    @Override
    public String getFilterModel(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getModel();
    }

    @Override
    public String getFilterSerialNumber(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getSerialNumber();
    }

    @Override
    public FilterType getFilterType(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getType();
    }

    @Override
    public String getFilterSetDichroicRef(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedDichroic().getID();
    }

    @Override
    public String getFilterSetEmissionFilterRef(int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedEmissionFilter(emissionFilterRefIndex).getID();
    }

    @Override
    public String getFilterSetExcitationFilterRef(int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedExcitationFilter(excitationFilterRefIndex).getID();
    }

    @Override
    public String getFilterSetID(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getID();
    }

    @Override
    public String getFilterSetLotNumber(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLotNumber();
    }

    @Override
    public String getFilterSetManufacturer(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getManufacturer();
    }

    @Override
    public String getFilterSetModel(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getModel();
    }

    @Override
    public String getFilterSetSerialNumber(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getSerialNumber();
    }

    @Override
    public String getGenericExcitationSourceAnnotationRef(int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        GenericExcitationSource o = (GenericExcitationSource)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getGenericExcitationSourceID(int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = (GenericExcitationSource)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    @Override
    public String getGenericExcitationSourceLotNumber(int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = (GenericExcitationSource)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    @Override
    public String getGenericExcitationSourceManufacturer(int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = (GenericExcitationSource)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    @Override
    public String getGenericExcitationSourceModel(int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = (GenericExcitationSource)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    @Override
    public Power getGenericExcitationSourcePower(int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = (GenericExcitationSource)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    @Override
    public String getGenericExcitationSourceSerialNumber(int instrumentIndex, int lightSourceIndex) {
        GenericExcitationSource o = (GenericExcitationSource)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    @Override
    public Timestamp getImageAcquisitionDate(int imageIndex) {
        return this.root.getImage(imageIndex).getAcquisitionDate();
    }

    @Override
    public String getImageAnnotationRef(int imageIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getImageDescription(int imageIndex) {
        return this.root.getImage(imageIndex).getDescription();
    }

    @Override
    public String getImageExperimentRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedExperiment().getID();
    }

    @Override
    public String getImageExperimenterGroupRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedExperimenterGroup().getID();
    }

    @Override
    public String getImageExperimenterRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedExperimenter().getID();
    }

    @Override
    public String getImageID(int imageIndex) {
        return this.root.getImage(imageIndex).getID();
    }

    @Override
    public String getImageInstrumentRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedInstrument().getID();
    }

    @Override
    public String getImageMicrobeamManipulationRef(int imageIndex, int microbeamManipulationRefIndex) {
        return this.root.getImage(imageIndex).getLinkedMicrobeamManipulation(microbeamManipulationRefIndex).getID();
    }

    @Override
    public String getImageName(int imageIndex) {
        return this.root.getImage(imageIndex).getName();
    }

    @Override
    public String getImageROIRef(int imageIndex, int ROIRefIndex) {
        return this.root.getImage(imageIndex).getLinkedROI(ROIRefIndex).getID();
    }

    @Override
    public Pressure getImagingEnvironmentAirPressure(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getAirPressure();
    }

    @Override
    public PercentFraction getImagingEnvironmentCO2Percent(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getCO2Percent();
    }

    @Override
    public PercentFraction getImagingEnvironmentHumidity(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getHumidity();
    }

    @Override
    public Temperature getImagingEnvironmentTemperature(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getTemperature();
    }

    @Override
    public String getInstrumentAnnotationRef(int instrumentIndex, int annotationRefIndex) {
        return this.root.getInstrument(instrumentIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getInstrumentID(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getID();
    }

    @Override
    public String getLabelAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Color getLabelFillColor(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    @Override
    public FillRule getLabelFillRule(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    @Override
    public FontFamily getLabelFontFamily(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    @Override
    public Length getLabelFontSize(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    @Override
    public FontStyle getLabelFontStyle(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    @Override
    public String getLabelID(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    @Override
    public LineCap getLabelLineCap(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    @Override
    public Boolean getLabelLocked(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    @Override
    public Color getLabelStrokeColor(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    @Override
    public String getLabelStrokeDashArray(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    @Override
    public Length getLabelStrokeWidth(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    @Override
    public String getLabelText(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    @Override
    public NonNegativeInteger getLabelTheC(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    @Override
    public NonNegativeInteger getLabelTheT(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    @Override
    public NonNegativeInteger getLabelTheZ(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    @Override
    public AffineTransform getLabelTransform(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    @Override
    public Boolean getLabelVisible(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    @Override
    public Double getLabelX(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    @Override
    public Double getLabelY(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    @Override
    public String getLaserAnnotationRef(int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getLaserID(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    @Override
    public String getLaserLotNumber(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    @Override
    public String getLaserManufacturer(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    @Override
    public String getLaserModel(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    @Override
    public Power getLaserPower(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    @Override
    public String getLaserSerialNumber(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    @Override
    public PositiveInteger getLaserFrequencyMultiplication(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getFrequencyMultiplication();
    }

    @Override
    public LaserMedium getLaserLaserMedium(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLaserMedium();
    }

    @Override
    public Boolean getLaserPockelCell(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPockelCell();
    }

    @Override
    public Pulse getLaserPulse(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPulse();
    }

    @Override
    public String getLaserPump(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLinkedPump().getID();
    }

    @Override
    public Frequency getLaserRepetitionRate(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getRepetitionRate();
    }

    @Override
    public Boolean getLaserTuneable(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getTuneable();
    }

    @Override
    public LaserType getLaserType(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getType();
    }

    @Override
    public Length getLaserWavelength(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getWavelength();
    }

    @Override
    public String getLightEmittingDiodeAnnotationRef(int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getLightEmittingDiodeID(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    @Override
    public String getLightEmittingDiodeLotNumber(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    @Override
    public String getLightEmittingDiodeManufacturer(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    @Override
    public String getLightEmittingDiodeModel(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    @Override
    public Power getLightEmittingDiodePower(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    @Override
    public String getLightEmittingDiodeSerialNumber(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    @Override
    public String getLightPathAnnotationRef(int imageIndex, int channelIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getLightPathDichroicRef(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedDichroic().getID();
    }

    @Override
    public String getLightPathEmissionFilterRef(int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedEmissionFilter(emissionFilterRefIndex).getID();
    }

    @Override
    public String getLightPathExcitationFilterRef(int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedExcitationFilter(excitationFilterRefIndex).getID();
    }

    @Override
    public PercentFraction getChannelLightSourceSettingsAttenuation(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getAttenuation();
    }

    @Override
    public PercentFraction getMicrobeamManipulationLightSourceSettingsAttenuation(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getAttenuation();
    }

    @Override
    public String getChannelLightSourceSettingsID(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getID();
    }

    @Override
    public String getMicrobeamManipulationLightSourceSettingsID(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getID();
    }

    @Override
    public Length getChannelLightSourceSettingsWavelength(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getWavelength();
    }

    @Override
    public Length getMicrobeamManipulationLightSourceSettingsWavelength(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getWavelength();
    }

    @Override
    public String getLineAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Color getLineFillColor(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    @Override
    public FillRule getLineFillRule(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    @Override
    public FontFamily getLineFontFamily(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    @Override
    public Length getLineFontSize(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    @Override
    public FontStyle getLineFontStyle(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    @Override
    public String getLineID(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    @Override
    public LineCap getLineLineCap(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    @Override
    public Boolean getLineLocked(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    @Override
    public Color getLineStrokeColor(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    @Override
    public String getLineStrokeDashArray(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    @Override
    public Length getLineStrokeWidth(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    @Override
    public String getLineText(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    @Override
    public NonNegativeInteger getLineTheC(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    @Override
    public NonNegativeInteger getLineTheT(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    @Override
    public NonNegativeInteger getLineTheZ(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    @Override
    public AffineTransform getLineTransform(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    @Override
    public Boolean getLineVisible(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    @Override
    public Marker getLineMarkerEnd(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getMarkerEnd();
    }

    @Override
    public Marker getLineMarkerStart(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getMarkerStart();
    }

    @Override
    public Double getLineX1(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX1();
    }

    @Override
    public Double getLineX2(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX2();
    }

    @Override
    public Double getLineY1(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY1();
    }

    @Override
    public Double getLineY2(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY2();
    }

    @Override
    public String getListAnnotationAnnotationRef(int listAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getListAnnotationAnnotator(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getAnnotator();
    }

    @Override
    public String getListAnnotationDescription(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getDescription();
    }

    @Override
    public String getListAnnotationID(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getID();
    }

    @Override
    public String getListAnnotationNamespace(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getNamespace();
    }

    @Override
    public String getLongAnnotationAnnotationRef(int longAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getLongAnnotationAnnotator(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getAnnotator();
    }

    @Override
    public String getLongAnnotationDescription(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getDescription();
    }

    @Override
    public String getLongAnnotationID(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getID();
    }

    @Override
    public String getLongAnnotationNamespace(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getNamespace();
    }

    @Override
    public Long getLongAnnotationValue(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getValue();
    }

    @Override
    public String getMapAnnotationAnnotationRef(int mapAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getMapAnnotationAnnotator(int mapAnnotationIndex) {
        return this.root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getAnnotator();
    }

    @Override
    public String getMapAnnotationDescription(int mapAnnotationIndex) {
        return this.root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getDescription();
    }

    @Override
    public String getMapAnnotationID(int mapAnnotationIndex) {
        return this.root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getID();
    }

    @Override
    public String getMapAnnotationNamespace(int mapAnnotationIndex) {
        return this.root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getNamespace();
    }

    @Override
    public String getMaskAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Color getMaskFillColor(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    @Override
    public FillRule getMaskFillRule(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    @Override
    public FontFamily getMaskFontFamily(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    @Override
    public Length getMaskFontSize(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    @Override
    public FontStyle getMaskFontStyle(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    @Override
    public String getMaskID(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    @Override
    public LineCap getMaskLineCap(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    @Override
    public Boolean getMaskLocked(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    @Override
    public Color getMaskStrokeColor(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    @Override
    public String getMaskStrokeDashArray(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    @Override
    public Length getMaskStrokeWidth(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    @Override
    public String getMaskText(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    @Override
    public NonNegativeInteger getMaskTheC(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    @Override
    public NonNegativeInteger getMaskTheT(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    @Override
    public NonNegativeInteger getMaskTheZ(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    @Override
    public AffineTransform getMaskTransform(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    @Override
    public Boolean getMaskVisible(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    @Override
    public Double getMaskHeight(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getHeight();
    }

    @Override
    public Double getMaskWidth(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getWidth();
    }

    @Override
    public Double getMaskX(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    @Override
    public Double getMaskY(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    @Override
    public String getMicrobeamManipulationDescription(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getDescription();
    }

    @Override
    public String getMicrobeamManipulationExperimenterRef(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLinkedExperimenter().getID();
    }

    @Override
    public String getMicrobeamManipulationID(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getID();
    }

    @Override
    public String getMicrobeamManipulationROIRef(int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLinkedROI(ROIRefIndex).getID();
    }

    @Override
    public MicrobeamManipulationType getMicrobeamManipulationType(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getType();
    }

    @Override
    public String getMicroscopeLotNumber(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getLotNumber();
    }

    @Override
    public String getMicroscopeManufacturer(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getManufacturer();
    }

    @Override
    public String getMicroscopeModel(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getModel();
    }

    @Override
    public String getMicroscopeSerialNumber(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getSerialNumber();
    }

    @Override
    public MicroscopeType getMicroscopeType(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getType();
    }

    @Override
    public String getObjectiveAnnotationRef(int instrumentIndex, int objectiveIndex, int annotationRefIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Double getObjectiveCalibratedMagnification(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getCalibratedMagnification();
    }

    @Override
    public Correction getObjectiveCorrection(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getCorrection();
    }

    @Override
    public String getObjectiveID(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getID();
    }

    @Override
    public Immersion getObjectiveImmersion(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getImmersion();
    }

    @Override
    public Boolean getObjectiveIris(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getIris();
    }

    @Override
    public Double getObjectiveLensNA(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getLensNA();
    }

    @Override
    public String getObjectiveLotNumber(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getLotNumber();
    }

    @Override
    public String getObjectiveManufacturer(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getManufacturer();
    }

    @Override
    public String getObjectiveModel(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getModel();
    }

    @Override
    public Double getObjectiveNominalMagnification(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getNominalMagnification();
    }

    @Override
    public String getObjectiveSerialNumber(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getSerialNumber();
    }

    @Override
    public Length getObjectiveWorkingDistance(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getWorkingDistance();
    }

    @Override
    public Double getObjectiveSettingsCorrectionCollar(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getCorrectionCollar();
    }

    @Override
    public String getObjectiveSettingsID(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getID();
    }

    @Override
    public Medium getObjectiveSettingsMedium(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getMedium();
    }

    @Override
    public Double getObjectiveSettingsRefractiveIndex(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getRefractiveIndex();
    }

    @Override
    public Boolean getPixelsBigEndian(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getBigEndian();
    }

    @Override
    public DimensionOrder getPixelsDimensionOrder(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getDimensionOrder();
    }

    @Override
    public String getPixelsID(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getID();
    }

    @Override
    public Boolean getPixelsInterleaved(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getInterleaved();
    }

    @Override
    public Length getPixelsPhysicalSizeX(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getPhysicalSizeX();
    }

    @Override
    public Length getPixelsPhysicalSizeY(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getPhysicalSizeY();
    }

    @Override
    public Length getPixelsPhysicalSizeZ(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getPhysicalSizeZ();
    }

    @Override
    public PositiveInteger getPixelsSignificantBits(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSignificantBits();
    }

    @Override
    public PositiveInteger getPixelsSizeC(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeC();
    }

    @Override
    public PositiveInteger getPixelsSizeT(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeT();
    }

    @Override
    public PositiveInteger getPixelsSizeX(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeX();
    }

    @Override
    public PositiveInteger getPixelsSizeY(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeY();
    }

    @Override
    public PositiveInteger getPixelsSizeZ(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeZ();
    }

    @Override
    public Time getPixelsTimeIncrement(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getTimeIncrement();
    }

    @Override
    public PixelType getPixelsType(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getType();
    }

    @Override
    public String getPlaneAnnotationRef(int imageIndex, int planeIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Time getPlaneDeltaT(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getDeltaT();
    }

    @Override
    public Time getPlaneExposureTime(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getExposureTime();
    }

    @Override
    public String getPlaneHashSHA1(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getHashSHA1();
    }

    @Override
    public Length getPlanePositionX(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionX();
    }

    @Override
    public Length getPlanePositionY(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionY();
    }

    @Override
    public Length getPlanePositionZ(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionZ();
    }

    @Override
    public NonNegativeInteger getPlaneTheC(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheC();
    }

    @Override
    public NonNegativeInteger getPlaneTheT(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheT();
    }

    @Override
    public NonNegativeInteger getPlaneTheZ(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheZ();
    }

    @Override
    public String getPlateAnnotationRef(int plateIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public NamingConvention getPlateColumnNamingConvention(int plateIndex) {
        return this.root.getPlate(plateIndex).getColumnNamingConvention();
    }

    @Override
    public PositiveInteger getPlateColumns(int plateIndex) {
        return this.root.getPlate(plateIndex).getColumns();
    }

    @Override
    public String getPlateDescription(int plateIndex) {
        return this.root.getPlate(plateIndex).getDescription();
    }

    @Override
    public String getPlateExternalIdentifier(int plateIndex) {
        return this.root.getPlate(plateIndex).getExternalIdentifier();
    }

    @Override
    public NonNegativeInteger getPlateFieldIndex(int plateIndex) {
        return this.root.getPlate(plateIndex).getFieldIndex();
    }

    @Override
    public String getPlateID(int plateIndex) {
        return this.root.getPlate(plateIndex).getID();
    }

    @Override
    public String getPlateName(int plateIndex) {
        return this.root.getPlate(plateIndex).getName();
    }

    @Override
    public NamingConvention getPlateRowNamingConvention(int plateIndex) {
        return this.root.getPlate(plateIndex).getRowNamingConvention();
    }

    @Override
    public PositiveInteger getPlateRows(int plateIndex) {
        return this.root.getPlate(plateIndex).getRows();
    }

    @Override
    public String getPlateStatus(int plateIndex) {
        return this.root.getPlate(plateIndex).getStatus();
    }

    @Override
    public Length getPlateWellOriginX(int plateIndex) {
        return this.root.getPlate(plateIndex).getWellOriginX();
    }

    @Override
    public Length getPlateWellOriginY(int plateIndex) {
        return this.root.getPlate(plateIndex).getWellOriginY();
    }

    @Override
    public String getPlateAcquisitionAnnotationRef(int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getPlateAcquisitionDescription(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getDescription();
    }

    @Override
    public Timestamp getPlateAcquisitionEndTime(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getEndTime();
    }

    @Override
    public String getPlateAcquisitionID(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getID();
    }

    @Override
    public PositiveInteger getPlateAcquisitionMaximumFieldCount(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getMaximumFieldCount();
    }

    @Override
    public String getPlateAcquisitionName(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getName();
    }

    @Override
    public Timestamp getPlateAcquisitionStartTime(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getStartTime();
    }

    @Override
    public String getPlateAcquisitionWellSampleRef(int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getLinkedWellSample(wellSampleRefIndex).getID();
    }

    @Override
    public String getPointAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Color getPointFillColor(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    @Override
    public FillRule getPointFillRule(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    @Override
    public FontFamily getPointFontFamily(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    @Override
    public Length getPointFontSize(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    @Override
    public FontStyle getPointFontStyle(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    @Override
    public String getPointID(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    @Override
    public LineCap getPointLineCap(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    @Override
    public Boolean getPointLocked(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    @Override
    public Color getPointStrokeColor(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    @Override
    public String getPointStrokeDashArray(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    @Override
    public Length getPointStrokeWidth(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    @Override
    public String getPointText(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    @Override
    public NonNegativeInteger getPointTheC(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    @Override
    public NonNegativeInteger getPointTheT(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    @Override
    public NonNegativeInteger getPointTheZ(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    @Override
    public AffineTransform getPointTransform(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    @Override
    public Boolean getPointVisible(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    @Override
    public Double getPointX(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    @Override
    public Double getPointY(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    @Override
    public String getPolygonAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Color getPolygonFillColor(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    @Override
    public FillRule getPolygonFillRule(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    @Override
    public FontFamily getPolygonFontFamily(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    @Override
    public Length getPolygonFontSize(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    @Override
    public FontStyle getPolygonFontStyle(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    @Override
    public String getPolygonID(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    @Override
    public LineCap getPolygonLineCap(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    @Override
    public Boolean getPolygonLocked(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    @Override
    public Color getPolygonStrokeColor(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    @Override
    public String getPolygonStrokeDashArray(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    @Override
    public Length getPolygonStrokeWidth(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    @Override
    public String getPolygonText(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    @Override
    public NonNegativeInteger getPolygonTheC(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    @Override
    public NonNegativeInteger getPolygonTheT(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    @Override
    public NonNegativeInteger getPolygonTheZ(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    @Override
    public AffineTransform getPolygonTransform(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    @Override
    public Boolean getPolygonVisible(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    @Override
    public String getPolygonPoints(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getPoints();
    }

    @Override
    public String getPolylineAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Color getPolylineFillColor(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    @Override
    public FillRule getPolylineFillRule(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    @Override
    public FontFamily getPolylineFontFamily(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    @Override
    public Length getPolylineFontSize(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    @Override
    public FontStyle getPolylineFontStyle(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    @Override
    public String getPolylineID(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    @Override
    public LineCap getPolylineLineCap(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    @Override
    public Boolean getPolylineLocked(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    @Override
    public Color getPolylineStrokeColor(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    @Override
    public String getPolylineStrokeDashArray(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    @Override
    public Length getPolylineStrokeWidth(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    @Override
    public String getPolylineText(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    @Override
    public NonNegativeInteger getPolylineTheC(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    @Override
    public NonNegativeInteger getPolylineTheT(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    @Override
    public NonNegativeInteger getPolylineTheZ(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    @Override
    public AffineTransform getPolylineTransform(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    @Override
    public Boolean getPolylineVisible(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    @Override
    public Marker getPolylineMarkerEnd(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getMarkerEnd();
    }

    @Override
    public Marker getPolylineMarkerStart(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getMarkerStart();
    }

    @Override
    public String getPolylinePoints(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getPoints();
    }

    @Override
    public String getProjectAnnotationRef(int projectIndex, int annotationRefIndex) {
        return this.root.getProject(projectIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getProjectDatasetRef(int projectIndex, int datasetRefIndex) {
        return this.root.getProject(projectIndex).getLinkedDataset(datasetRefIndex).getID();
    }

    @Override
    public String getProjectDescription(int projectIndex) {
        return this.root.getProject(projectIndex).getDescription();
    }

    @Override
    public String getProjectExperimenterGroupRef(int projectIndex) {
        return this.root.getProject(projectIndex).getLinkedExperimenterGroup().getID();
    }

    @Override
    public String getProjectExperimenterRef(int projectIndex) {
        return this.root.getProject(projectIndex).getLinkedExperimenter().getID();
    }

    @Override
    public String getProjectID(int projectIndex) {
        return this.root.getProject(projectIndex).getID();
    }

    @Override
    public String getProjectName(int projectIndex) {
        return this.root.getProject(projectIndex).getName();
    }

    @Override
    public String getROIAnnotationRef(int ROIIndex, int annotationRefIndex) {
        return this.root.getROI(ROIIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getROIDescription(int ROIIndex) {
        return this.root.getROI(ROIIndex).getDescription();
    }

    @Override
    public String getROIID(int ROIIndex) {
        return this.root.getROI(ROIIndex).getID();
    }

    @Override
    public String getROIName(int ROIIndex) {
        return this.root.getROI(ROIIndex).getName();
    }

    @Override
    public String getROINamespace(int ROIIndex) {
        return this.root.getROI(ROIIndex).getNamespace();
    }

    @Override
    public String getReagentAnnotationRef(int screenIndex, int reagentIndex, int annotationRefIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getReagentDescription(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getDescription();
    }

    @Override
    public String getReagentID(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getID();
    }

    @Override
    public String getReagentName(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getName();
    }

    @Override
    public String getReagentReagentIdentifier(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getReagentIdentifier();
    }

    @Override
    public String getRectangleAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Color getRectangleFillColor(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    @Override
    public FillRule getRectangleFillRule(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    @Override
    public FontFamily getRectangleFontFamily(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    @Override
    public Length getRectangleFontSize(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    @Override
    public FontStyle getRectangleFontStyle(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    @Override
    public String getRectangleID(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    @Override
    public LineCap getRectangleLineCap(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    @Override
    public Boolean getRectangleLocked(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    @Override
    public Color getRectangleStrokeColor(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    @Override
    public String getRectangleStrokeDashArray(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    @Override
    public Length getRectangleStrokeWidth(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    @Override
    public String getRectangleText(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    @Override
    public NonNegativeInteger getRectangleTheC(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    @Override
    public NonNegativeInteger getRectangleTheT(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    @Override
    public NonNegativeInteger getRectangleTheZ(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    @Override
    public AffineTransform getRectangleTransform(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    @Override
    public Boolean getRectangleVisible(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    @Override
    public Double getRectangleHeight(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getHeight();
    }

    @Override
    public Double getRectangleWidth(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getWidth();
    }

    @Override
    public Double getRectangleX(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    @Override
    public Double getRectangleY(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    @Override
    public String getRightsRightsHeld() {
        return this.root.getRights().getRightsHeld();
    }

    @Override
    public String getRightsRightsHolder() {
        return this.root.getRights().getRightsHolder();
    }

    @Override
    public String getScreenAnnotationRef(int screenIndex, int annotationRefIndex) {
        return this.root.getScreen(screenIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getScreenDescription(int screenIndex) {
        return this.root.getScreen(screenIndex).getDescription();
    }

    @Override
    public String getScreenID(int screenIndex) {
        return this.root.getScreen(screenIndex).getID();
    }

    @Override
    public String getScreenName(int screenIndex) {
        return this.root.getScreen(screenIndex).getName();
    }

    @Override
    public String getScreenPlateRef(int screenIndex, int plateRefIndex) {
        return this.root.getScreen(screenIndex).getLinkedPlate(plateRefIndex).getID();
    }

    @Override
    public String getScreenProtocolDescription(int screenIndex) {
        return this.root.getScreen(screenIndex).getProtocolDescription();
    }

    @Override
    public String getScreenProtocolIdentifier(int screenIndex) {
        return this.root.getScreen(screenIndex).getProtocolIdentifier();
    }

    @Override
    public String getScreenReagentSetDescription(int screenIndex) {
        return this.root.getScreen(screenIndex).getReagentSetDescription();
    }

    @Override
    public String getScreenReagentSetIdentifier(int screenIndex) {
        return this.root.getScreen(screenIndex).getReagentSetIdentifier();
    }

    @Override
    public String getScreenType(int screenIndex) {
        return this.root.getScreen(screenIndex).getType();
    }

    @Override
    public String getStageLabelName(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getName();
    }

    @Override
    public Length getStageLabelX(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getX();
    }

    @Override
    public Length getStageLabelY(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getY();
    }

    @Override
    public Length getStageLabelZ(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getZ();
    }

    @Override
    public String getTagAnnotationAnnotationRef(int tagAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getTagAnnotationAnnotator(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getAnnotator();
    }

    @Override
    public String getTagAnnotationDescription(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getDescription();
    }

    @Override
    public String getTagAnnotationID(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getID();
    }

    @Override
    public String getTagAnnotationNamespace(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getNamespace();
    }

    @Override
    public String getTagAnnotationValue(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getValue();
    }

    @Override
    public String getTermAnnotationAnnotationRef(int termAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getTermAnnotationAnnotator(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getAnnotator();
    }

    @Override
    public String getTermAnnotationDescription(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getDescription();
    }

    @Override
    public String getTermAnnotationID(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getID();
    }

    @Override
    public String getTermAnnotationNamespace(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getNamespace();
    }

    @Override
    public String getTermAnnotationValue(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getValue();
    }

    @Override
    public NonNegativeInteger getTiffDataFirstC(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstC();
    }

    @Override
    public NonNegativeInteger getTiffDataFirstT(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstT();
    }

    @Override
    public NonNegativeInteger getTiffDataFirstZ(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstZ();
    }

    @Override
    public NonNegativeInteger getTiffDataIFD(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getIFD();
    }

    @Override
    public NonNegativeInteger getTiffDataPlaneCount(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getPlaneCount();
    }

    @Override
    public String getTimestampAnnotationAnnotationRef(int timestampAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getTimestampAnnotationAnnotator(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getAnnotator();
    }

    @Override
    public String getTimestampAnnotationDescription(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getDescription();
    }

    @Override
    public String getTimestampAnnotationID(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getID();
    }

    @Override
    public String getTimestampAnnotationNamespace(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getNamespace();
    }

    @Override
    public Timestamp getTimestampAnnotationValue(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getValue();
    }

    @Override
    public Length getTransmittanceRangeCutIn(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutIn();
    }

    @Override
    public Length getTransmittanceRangeCutInTolerance(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutInTolerance();
    }

    @Override
    public Length getTransmittanceRangeCutOut(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutOut();
    }

    @Override
    public Length getTransmittanceRangeCutOutTolerance(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutOutTolerance();
    }

    @Override
    public PercentFraction getTransmittanceRangeTransmittance(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getTransmittance();
    }

    @Override
    public String getUUIDFileName(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getUUID().getFileName();
    }

    @Override
    public String getWellAnnotationRef(int plateIndex, int wellIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public Color getWellColor(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getColor();
    }

    @Override
    public NonNegativeInteger getWellColumn(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getColumn();
    }

    @Override
    public String getWellExternalDescription(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getExternalDescription();
    }

    @Override
    public String getWellExternalIdentifier(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getExternalIdentifier();
    }

    @Override
    public String getWellID(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getID();
    }

    @Override
    public String getWellReagentRef(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getLinkedReagent().getID();
    }

    @Override
    public NonNegativeInteger getWellRow(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getRow();
    }

    @Override
    public String getWellType(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getType();
    }

    @Override
    public String getWellSampleID(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getID();
    }

    @Override
    public String getWellSampleImageRef(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getLinkedImage().getID();
    }

    @Override
    public NonNegativeInteger getWellSampleIndex(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getIndex();
    }

    @Override
    public Length getWellSamplePositionX(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getPositionX();
    }

    @Override
    public Length getWellSamplePositionY(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getPositionY();
    }

    @Override
    public Timestamp getWellSampleTimepoint(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getTimepoint();
    }

    @Override
    public String getXMLAnnotationAnnotationRef(int XMLAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    @Override
    public String getXMLAnnotationAnnotator(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getAnnotator();
    }

    @Override
    public String getXMLAnnotationDescription(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getDescription();
    }

    @Override
    public String getXMLAnnotationID(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getID();
    }

    @Override
    public String getXMLAnnotationNamespace(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getNamespace();
    }

    @Override
    public String getXMLAnnotationValue(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getValue();
    }

    @Override
    public void setPixelsBinDataBigEndian(Boolean bigEndian, int imageIndex, int binDataIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setBigEndian(bigEndian);
    }

    @Override
    public void setMaskBinData(byte[] binData, int ROIIndex, int shapeIndex) {
    }

    @Override
    public void setUUID(String uuid) {
        this.root.setUUID(uuid);
    }

    @Override
    public void setMapAnnotationValue(List<MapPair> value, int mapAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfMapAnnotationList() == mapAnnotationIndex) {
            o1.addMapAnnotation(new MapAnnotation());
        }
        MapAnnotation o2 = o1.getMapAnnotation(mapAnnotationIndex);
        MapPairs valueAsPairs = new MapPairs(value);
        o2.setValue(valueAsPairs);
    }

    @Override
    public void setGenericExcitationSourceMap(List<MapPair> map, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new GenericExcitationSource());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        Map mapAsOmeMap = new Map(map);
        ((GenericExcitationSource)o2).setMap(mapAsOmeMap);
    }

    @Override
    public void setImagingEnvironmentMap(List<MapPair> map, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        Map mapAsOmeMap = new Map(map);
        o2.setMap(mapAsOmeMap);
    }

    @Override
    public void setArcAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex), annotationLinks_reference);
    }

    @Override
    public void setArcID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, o2);
        ((Arc)o2).setID(id);
    }

    @Override
    public void setArcLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setLotNumber(lotNumber);
    }

    @Override
    public void setArcManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setManufacturer(manufacturer);
    }

    @Override
    public void setArcModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setModel(model);
    }

    @Override
    public void setArcPower(Power power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setPower(power);
    }

    @Override
    public void setArcSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setSerialNumber(serialNumber);
    }

    @Override
    public void setArcType(ArcType type, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setType(type);
    }

    @Override
    public void setBinaryFileFileName(String fileName, int fileAnnotationIndex) {
        FileAnnotation o2;
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        if ((o2 = o1.getFileAnnotation(fileAnnotationIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setFileName(fileName);
    }

    @Override
    public void setBinaryFileMIMEType(String mimeType, int fileAnnotationIndex) {
        FileAnnotation o2;
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        if ((o2 = o1.getFileAnnotation(fileAnnotationIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setMIMEType(mimeType);
    }

    @Override
    public void setBinaryFileSize(NonNegativeLong size, int fileAnnotationIndex) {
        FileAnnotation o2;
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        if ((o2 = o1.getFileAnnotation(fileAnnotationIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setSize(size);
    }

    @Override
    public void setBinaryOnlyMetadataFile(String metadataFile) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getBinaryOnly() == null) {
            o0.setBinaryOnly(new BinaryOnly());
        }
        BinaryOnly o1 = o0.getBinaryOnly();
        o1.setMetadataFile(metadataFile);
    }

    @Override
    public void setBinaryOnlyUUID(String uuid) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getBinaryOnly() == null) {
            o0.setBinaryOnly(new BinaryOnly());
        }
        BinaryOnly o1 = o0.getBinaryOnly();
        o1.setUUID(uuid);
    }

    @Override
    public void setBooleanAnnotationAnnotationRef(String annotation, int booleanAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setBooleanAnnotationAnnotator(String annotator, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setBooleanAnnotationDescription(String description, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setBooleanAnnotationID(String id, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setBooleanAnnotationNamespace(String namespace, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setBooleanAnnotationValue(Boolean value, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        o2.setValue(value);
    }

    @Override
    public void setChannelAcquisitionMode(AcquisitionMode acquisitionMode, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setAcquisitionMode(acquisitionMode);
    }

    @Override
    public void setChannelAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex), annotationLinks_reference);
    }

    @Override
    public void setChannelColor(Color color, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setColor(color);
    }

    @Override
    public void setChannelContrastMethod(ContrastMethod contrastMethod, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setContrastMethod(contrastMethod);
    }

    @Override
    public void setChannelEmissionWavelength(Length emissionWavelength, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setEmissionWavelength(emissionWavelength);
    }

    @Override
    public void setChannelExcitationWavelength(Length excitationWavelength, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setExcitationWavelength(excitationWavelength);
    }

    @Override
    public void setChannelFilterSetRef(String filterSet, int imageIndex, int channelIndex) {
        FilterSetRef filterSet_reference = new FilterSetRef();
        filterSet_reference.setID(filterSet);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex), filterSet_reference);
    }

    @Override
    public void setChannelFluor(String fluor, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setFluor(fluor);
    }

    @Override
    public void setChannelID(String id, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        this.model.addModelObject(id, o3);
        o3.setID(id);
        if (o3.getLightPath() == null) {
            o3.setLightPath(new LightPath());
        }
    }

    @Override
    public void setChannelIlluminationType(IlluminationType illuminationType, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setIlluminationType(illuminationType);
    }

    @Override
    public void setChannelNDFilter(Double ndFilter, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setNDFilter(ndFilter);
    }

    @Override
    public void setChannelName(String name, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setName(name);
    }

    @Override
    public void setChannelPinholeSize(Length pinholeSize, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setPinholeSize(pinholeSize);
    }

    @Override
    public void setChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setPockelCellSetting(pockelCellSetting);
    }

    @Override
    public void setChannelSamplesPerPixel(PositiveInteger samplesPerPixel, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setSamplesPerPixel(samplesPerPixel);
    }

    @Override
    public void setCommentAnnotationAnnotationRef(String annotation, int commentAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setCommentAnnotationAnnotator(String annotator, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setCommentAnnotationDescription(String description, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setCommentAnnotationID(String id, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setCommentAnnotationNamespace(String namespace, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setCommentAnnotationValue(String value, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        o2.setValue(value);
    }

    @Override
    public void setDatasetAnnotationRef(String annotation, int datasetIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getDataset(datasetIndex), annotationLinks_reference);
    }

    @Override
    public void setDatasetDescription(String description, int datasetIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfDatasetList() == datasetIndex) {
            o0.addDataset(new Dataset());
        }
        Dataset o1 = o0.getDataset(datasetIndex);
        o1.setDescription(description);
    }

    @Override
    public void setDatasetExperimenterGroupRef(String experimenterGroup, int datasetIndex) {
        ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
        experimenterGroup_reference.setID(experimenterGroup);
        this.model.addReference(this.root.getDataset(datasetIndex), experimenterGroup_reference);
    }

    @Override
    public void setDatasetExperimenterRef(String experimenter, int datasetIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference(this.root.getDataset(datasetIndex), experimenter_reference);
    }

    @Override
    public void setDatasetID(String id, int datasetIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfDatasetList() == datasetIndex) {
            o0.addDataset(new Dataset());
        }
        Dataset o1 = o0.getDataset(datasetIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    @Override
    public void setDatasetImageRef(String image, int datasetIndex, int imageRefIndex) {
        ImageRef imageLinks_reference = new ImageRef();
        imageLinks_reference.setID(image);
        this.model.addReference(this.root.getDataset(datasetIndex), imageLinks_reference);
    }

    @Override
    public void setDatasetName(String name, int datasetIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfDatasetList() == datasetIndex) {
            o0.addDataset(new Dataset());
        }
        Dataset o1 = o0.getDataset(datasetIndex);
        o1.setName(name);
    }

    @Override
    public void setDetectorAmplificationGain(Double amplificationGain, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setAmplificationGain(amplificationGain);
    }

    @Override
    public void setDetectorAnnotationRef(String annotation, int instrumentIndex, int detectorIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getDetector(detectorIndex), annotationLinks_reference);
    }

    @Override
    public void setDetectorGain(Double gain, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setGain(gain);
    }

    @Override
    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setDetectorLotNumber(String lotNumber, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setLotNumber(lotNumber);
    }

    @Override
    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setManufacturer(manufacturer);
    }

    @Override
    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setModel(model);
    }

    @Override
    public void setDetectorOffset(Double offset, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setOffset(offset);
    }

    @Override
    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setSerialNumber(serialNumber);
    }

    @Override
    public void setDetectorType(DetectorType type, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setType(type);
    }

    @Override
    public void setDetectorVoltage(ElectricPotential voltage, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setVoltage(voltage);
    }

    @Override
    public void setDetectorZoom(Double zoom, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setZoom(zoom);
    }

    @Override
    public void setDetectorSettingsBinning(Binning binning, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setBinning(binning);
    }

    @Override
    public void setDetectorSettingsGain(Double gain, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setGain(gain);
    }

    @Override
    public void setDetectorSettingsID(String id, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        this.model.addModelObject(id, o4);
        o4.setID(id);
    }

    @Override
    public void setDetectorSettingsIntegration(PositiveInteger integration, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setIntegration(integration);
    }

    @Override
    public void setDetectorSettingsOffset(Double offset, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setOffset(offset);
    }

    @Override
    public void setDetectorSettingsReadOutRate(Frequency readOutRate, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setReadOutRate(readOutRate);
    }

    @Override
    public void setDetectorSettingsVoltage(ElectricPotential voltage, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setVoltage(voltage);
    }

    @Override
    public void setDetectorSettingsZoom(Double zoom, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setZoom(zoom);
    }

    @Override
    public void setDichroicAnnotationRef(String annotation, int instrumentIndex, int dichroicIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex), annotationLinks_reference);
    }

    @Override
    public void setDichroicID(String id, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setDichroicLotNumber(String lotNumber, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setLotNumber(lotNumber);
    }

    @Override
    public void setDichroicManufacturer(String manufacturer, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setManufacturer(manufacturer);
    }

    @Override
    public void setDichroicModel(String model, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setModel(model);
    }

    @Override
    public void setDichroicSerialNumber(String serialNumber, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setSerialNumber(serialNumber);
    }

    @Override
    public void setDoubleAnnotationAnnotationRef(String annotation, int doubleAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setDoubleAnnotationAnnotator(String annotator, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setDoubleAnnotationDescription(String description, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setDoubleAnnotationID(String id, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setDoubleAnnotationNamespace(String namespace, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setDoubleAnnotationValue(Double value, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        o2.setValue(value);
    }

    @Override
    public void setEllipseAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex), annotationLinks_reference);
    }

    @Override
    public void setEllipseFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFillColor(fillColor);
    }

    @Override
    public void setEllipseFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFillRule(fillRule);
    }

    @Override
    public void setEllipseFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFontFamily(fontFamily);
    }

    @Override
    public void setEllipseFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFontSize(fontSize);
    }

    @Override
    public void setEllipseFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFontStyle(fontStyle);
    }

    @Override
    public void setEllipseID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Ellipse)o3).setID(id);
    }

    @Override
    public void setEllipseLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setLineCap(lineCap);
    }

    @Override
    public void setEllipseLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setLocked(locked);
    }

    @Override
    public void setEllipseStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setStrokeColor(strokeColor);
    }

    @Override
    public void setEllipseStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setStrokeDashArray(strokeDashArray);
    }

    @Override
    public void setEllipseStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setStrokeWidth(strokeWidth);
    }

    @Override
    public void setEllipseText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setText(text);
    }

    @Override
    public void setEllipseTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTheC(theC);
    }

    @Override
    public void setEllipseTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTheT(theT);
    }

    @Override
    public void setEllipseTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTheZ(theZ);
    }

    @Override
    public void setEllipseTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTransform(transform);
    }

    @Override
    public void setEllipseVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setVisible(visible);
    }

    @Override
    public void setEllipseRadiusX(Double radiusX, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setRadiusX(radiusX);
    }

    @Override
    public void setEllipseRadiusY(Double radiusY, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setRadiusY(radiusY);
    }

    @Override
    public void setEllipseX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setX(x);
    }

    @Override
    public void setEllipseY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setY(y);
    }

    @Override
    public void setExperimentDescription(String description, int experimentIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        Experiment o1 = o0.getExperiment(experimentIndex);
        o1.setDescription(description);
    }

    @Override
    public void setExperimentExperimenterRef(String experimenter, int experimentIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference(this.root.getExperiment(experimentIndex), experimenter_reference);
    }

    @Override
    public void setExperimentID(String id, int experimentIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        Experiment o1 = o0.getExperiment(experimentIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    @Override
    public void setExperimentType(ExperimentType type, int experimentIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        Experiment o1 = o0.getExperiment(experimentIndex);
        o1.setType(type);
    }

    @Override
    public void setExperimenterAnnotationRef(String annotation, int experimenterIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getExperimenter(experimenterIndex), annotationLinks_reference);
    }

    @Override
    public void setExperimenterEmail(String email, int experimenterIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setEmail(email);
    }

    @Override
    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setFirstName(firstName);
    }

    @Override
    public void setExperimenterID(String id, int experimenterIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    @Override
    public void setExperimenterInstitution(String institution, int experimenterIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setInstitution(institution);
    }

    @Override
    public void setExperimenterLastName(String lastName, int experimenterIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setLastName(lastName);
    }

    @Override
    public void setExperimenterMiddleName(String middleName, int experimenterIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setMiddleName(middleName);
    }

    @Override
    public void setExperimenterUserName(String userName, int experimenterIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setUserName(userName);
    }

    @Override
    public void setExperimenterGroupAnnotationRef(String annotation, int experimenterGroupIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getExperimenterGroup(experimenterGroupIndex), annotationLinks_reference);
    }

    @Override
    public void setExperimenterGroupDescription(String description, int experimenterGroupIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimenterGroupList() == experimenterGroupIndex) {
            o0.addExperimenterGroup(new ExperimenterGroup());
        }
        ExperimenterGroup o1 = o0.getExperimenterGroup(experimenterGroupIndex);
        o1.setDescription(description);
    }

    @Override
    public void setExperimenterGroupExperimenterRef(String experimenter, int experimenterGroupIndex, int experimenterRefIndex) {
        ExperimenterRef experimenterLinks_reference = new ExperimenterRef();
        experimenterLinks_reference.setID(experimenter);
        this.model.addReference(this.root.getExperimenterGroup(experimenterGroupIndex), experimenterLinks_reference);
    }

    @Override
    public void setExperimenterGroupID(String id, int experimenterGroupIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimenterGroupList() == experimenterGroupIndex) {
            o0.addExperimenterGroup(new ExperimenterGroup());
        }
        ExperimenterGroup o1 = o0.getExperimenterGroup(experimenterGroupIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    @Override
    public void setExperimenterGroupLeader(String leader, int experimenterGroupIndex, int leaderIndex) {
        Leader leaders_reference = new Leader();
        leaders_reference.setID(leader);
        this.model.addReference(this.root.getExperimenterGroup(experimenterGroupIndex), leaders_reference);
    }

    @Override
    public void setExperimenterGroupName(String name, int experimenterGroupIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimenterGroupList() == experimenterGroupIndex) {
            o0.addExperimenterGroup(new ExperimenterGroup());
        }
        ExperimenterGroup o1 = o0.getExperimenterGroup(experimenterGroupIndex);
        o1.setName(name);
    }

    @Override
    public void setFilamentAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex), annotationLinks_reference);
    }

    @Override
    public void setFilamentID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, o2);
        ((Filament)o2).setID(id);
    }

    @Override
    public void setFilamentLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setLotNumber(lotNumber);
    }

    @Override
    public void setFilamentManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setManufacturer(manufacturer);
    }

    @Override
    public void setFilamentModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setModel(model);
    }

    @Override
    public void setFilamentPower(Power power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setPower(power);
    }

    @Override
    public void setFilamentSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setSerialNumber(serialNumber);
    }

    @Override
    public void setFilamentType(FilamentType type, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setType(type);
    }

    @Override
    public void setFileAnnotationAnnotationRef(String annotation, int fileAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setFileAnnotationAnnotator(String annotator, int fileAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setFileAnnotationDescription(String description, int fileAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setFileAnnotationID(String id, int fileAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setFileAnnotationNamespace(String namespace, int fileAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setFilterAnnotationRef(String annotation, int instrumentIndex, int filterIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getFilter(filterIndex), annotationLinks_reference);
    }

    @Override
    public void setFilterFilterWheel(String filterWheel, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setFilterWheel(filterWheel);
    }

    @Override
    public void setFilterID(String id, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setFilterLotNumber(String lotNumber, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setLotNumber(lotNumber);
    }

    @Override
    public void setFilterManufacturer(String manufacturer, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setManufacturer(manufacturer);
    }

    @Override
    public void setFilterModel(String model, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setModel(model);
    }

    @Override
    public void setFilterSerialNumber(String serialNumber, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setSerialNumber(serialNumber);
    }

    @Override
    public void setFilterType(FilterType type, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setType(type);
    }

    @Override
    public void setFilterSetDichroicRef(String dichroic, int instrumentIndex, int filterSetIndex) {
        DichroicRef dichroic_reference = new DichroicRef();
        dichroic_reference.setID(dichroic);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex), dichroic_reference);
    }

    @Override
    public void setFilterSetEmissionFilterRef(String emissionFilter, int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        EmissionFilterRef emissionFilterLinks_reference = new EmissionFilterRef();
        emissionFilterLinks_reference.setID(emissionFilter);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex), emissionFilterLinks_reference);
    }

    @Override
    public void setFilterSetExcitationFilterRef(String excitationFilter, int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        ExcitationFilterRef excitationFilterLinks_reference = new ExcitationFilterRef();
        excitationFilterLinks_reference.setID(excitationFilter);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex), excitationFilterLinks_reference);
    }

    @Override
    public void setFilterSetID(String id, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setFilterSetLotNumber(String lotNumber, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setLotNumber(lotNumber);
    }

    @Override
    public void setFilterSetManufacturer(String manufacturer, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setManufacturer(manufacturer);
    }

    @Override
    public void setFilterSetModel(String model, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setModel(model);
    }

    @Override
    public void setFilterSetSerialNumber(String serialNumber, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setSerialNumber(serialNumber);
    }

    @Override
    public void setGenericExcitationSourceAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex), annotationLinks_reference);
    }

    @Override
    public void setGenericExcitationSourceID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new GenericExcitationSource());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, o2);
        ((GenericExcitationSource)o2).setID(id);
    }

    @Override
    public void setGenericExcitationSourceLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new GenericExcitationSource());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((GenericExcitationSource)o2).setLotNumber(lotNumber);
    }

    @Override
    public void setGenericExcitationSourceManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new GenericExcitationSource());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((GenericExcitationSource)o2).setManufacturer(manufacturer);
    }

    @Override
    public void setGenericExcitationSourceModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new GenericExcitationSource());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((GenericExcitationSource)o2).setModel(model);
    }

    @Override
    public void setGenericExcitationSourcePower(Power power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new GenericExcitationSource());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((GenericExcitationSource)o2).setPower(power);
    }

    @Override
    public void setGenericExcitationSourceSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new GenericExcitationSource());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((GenericExcitationSource)o2).setSerialNumber(serialNumber);
    }

    @Override
    public void setImageAcquisitionDate(Timestamp acquisitionDate, int imageIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        o1.setAcquisitionDate(acquisitionDate);
    }

    @Override
    public void setImageAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getImage(imageIndex), annotationLinks_reference);
    }

    @Override
    public void setImageDescription(String description, int imageIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        o1.setDescription(description);
    }

    @Override
    public void setImageExperimentRef(String experiment, int imageIndex) {
        ExperimentRef experiment_reference = new ExperimentRef();
        experiment_reference.setID(experiment);
        this.model.addReference(this.root.getImage(imageIndex), experiment_reference);
    }

    @Override
    public void setImageExperimenterGroupRef(String experimenterGroup, int imageIndex) {
        ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
        experimenterGroup_reference.setID(experimenterGroup);
        this.model.addReference(this.root.getImage(imageIndex), experimenterGroup_reference);
    }

    @Override
    public void setImageExperimenterRef(String experimenter, int imageIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference(this.root.getImage(imageIndex), experimenter_reference);
    }

    @Override
    public void setImageID(String id, int imageIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    @Override
    public void setImageInstrumentRef(String instrument, int imageIndex) {
        InstrumentRef instrument_reference = new InstrumentRef();
        instrument_reference.setID(instrument);
        this.model.addReference(this.root.getImage(imageIndex), instrument_reference);
    }

    @Override
    public void setImageMicrobeamManipulationRef(String microbeamManipulation, int imageIndex, int microbeamManipulationRefIndex) {
        MicrobeamManipulationRef microbeamManipulationLinks_reference = new MicrobeamManipulationRef();
        microbeamManipulationLinks_reference.setID(microbeamManipulation);
        this.model.addReference(this.root.getImage(imageIndex), microbeamManipulationLinks_reference);
    }

    @Override
    public void setImageName(String name, int imageIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        o1.setName(name);
    }

    @Override
    public void setImageROIRef(String roi, int imageIndex, int ROIRefIndex) {
        ROIRef roiLinks_reference = new ROIRef();
        roiLinks_reference.setID(roi);
        this.model.addReference(this.root.getImage(imageIndex), roiLinks_reference);
    }

    @Override
    public void setImagingEnvironmentAirPressure(Pressure airPressure, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setAirPressure(airPressure);
    }

    @Override
    public void setImagingEnvironmentCO2Percent(PercentFraction co2Percent, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setCO2Percent(co2Percent);
    }

    @Override
    public void setImagingEnvironmentHumidity(PercentFraction humidity, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setHumidity(humidity);
    }

    @Override
    public void setImagingEnvironmentTemperature(Temperature temperature, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setTemperature(temperature);
    }

    @Override
    public void setInstrumentAnnotationRef(String annotation, int instrumentIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getInstrument(instrumentIndex), annotationLinks_reference);
    }

    @Override
    public void setInstrumentID(String id, int instrumentIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        Instrument o1 = o0.getInstrument(instrumentIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    @Override
    public void setLabelAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex), annotationLinks_reference);
    }

    @Override
    public void setLabelFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setFillColor(fillColor);
    }

    @Override
    public void setLabelFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setFillRule(fillRule);
    }

    @Override
    public void setLabelFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setFontFamily(fontFamily);
    }

    @Override
    public void setLabelFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setFontSize(fontSize);
    }

    @Override
    public void setLabelFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setFontStyle(fontStyle);
    }

    @Override
    public void setLabelID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Label)o3).setID(id);
    }

    @Override
    public void setLabelLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setLineCap(lineCap);
    }

    @Override
    public void setLabelLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setLocked(locked);
    }

    @Override
    public void setLabelStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setStrokeColor(strokeColor);
    }

    @Override
    public void setLabelStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setStrokeDashArray(strokeDashArray);
    }

    @Override
    public void setLabelStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setStrokeWidth(strokeWidth);
    }

    @Override
    public void setLabelText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setText(text);
    }

    @Override
    public void setLabelTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setTheC(theC);
    }

    @Override
    public void setLabelTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setTheT(theT);
    }

    @Override
    public void setLabelTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setTheZ(theZ);
    }

    @Override
    public void setLabelTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setTransform(transform);
    }

    @Override
    public void setLabelVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setVisible(visible);
    }

    @Override
    public void setLabelX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setX(x);
    }

    @Override
    public void setLabelY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setY(y);
    }

    @Override
    public void setLaserAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex), annotationLinks_reference);
    }

    @Override
    public void setLaserID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, o2);
        ((Laser)o2).setID(id);
    }

    @Override
    public void setLaserLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setLotNumber(lotNumber);
    }

    @Override
    public void setLaserManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setManufacturer(manufacturer);
    }

    @Override
    public void setLaserModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setModel(model);
    }

    @Override
    public void setLaserPower(Power power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setPower(power);
    }

    @Override
    public void setLaserSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setSerialNumber(serialNumber);
    }

    @Override
    public void setLaserFrequencyMultiplication(PositiveInteger frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setFrequencyMultiplication(frequencyMultiplication);
    }

    @Override
    public void setLaserLaserMedium(LaserMedium laserMedium, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setLaserMedium(laserMedium);
    }

    @Override
    public void setLaserPockelCell(Boolean pockelCell, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setPockelCell(pockelCell);
    }

    @Override
    public void setLaserPulse(Pulse pulse, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setPulse(pulse);
    }

    @Override
    public void setLaserPump(String pump, int instrumentIndex, int lightSourceIndex) {
        Pump pump_reference = new Pump();
        pump_reference.setID(pump);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex), pump_reference);
    }

    @Override
    public void setLaserRepetitionRate(Frequency repetitionRate, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setRepetitionRate(repetitionRate);
    }

    @Override
    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setTuneable(tuneable);
    }

    @Override
    public void setLaserType(LaserType type, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setType(type);
    }

    @Override
    public void setLaserWavelength(Length wavelength, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setWavelength(wavelength);
    }

    @Override
    public void setLightEmittingDiodeAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex), annotationLinks_reference);
    }

    @Override
    public void setLightEmittingDiodeID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, o2);
        ((LightEmittingDiode)o2).setID(id);
    }

    @Override
    public void setLightEmittingDiodeLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setLotNumber(lotNumber);
    }

    @Override
    public void setLightEmittingDiodeManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setManufacturer(manufacturer);
    }

    @Override
    public void setLightEmittingDiodeModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setModel(model);
    }

    @Override
    public void setLightEmittingDiodePower(Power power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setPower(power);
    }

    @Override
    public void setLightEmittingDiodeSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setSerialNumber(serialNumber);
    }

    @Override
    public void setLightPathAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(), annotationLinks_reference);
    }

    @Override
    public void setLightPathDichroicRef(String dichroic, int imageIndex, int channelIndex) {
        DichroicRef dichroic_reference = new DichroicRef();
        dichroic_reference.setID(dichroic);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(), dichroic_reference);
    }

    @Override
    public void setLightPathEmissionFilterRef(String emissionFilter, int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        EmissionFilterRef emissionFilterLinks_reference = new EmissionFilterRef();
        emissionFilterLinks_reference.setID(emissionFilter);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(), emissionFilterLinks_reference);
    }

    @Override
    public void setLightPathExcitationFilterRef(String excitationFilter, int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        ExcitationFilterRef excitationFilterLinks_reference = new ExcitationFilterRef();
        excitationFilterLinks_reference.setID(excitationFilter);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(), excitationFilterLinks_reference);
    }

    @Override
    public void setChannelLightSourceSettingsAttenuation(PercentFraction attenuation, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getLightSourceSettings() == null) {
            o3.setLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o4 = o3.getLightSourceSettings();
        o4.setAttenuation(attenuation);
    }

    @Override
    public void setMicrobeamManipulationLightSourceSettingsAttenuation(PercentFraction attenuation, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        MicrobeamManipulation o2;
        Experiment o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        if ((o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex)).sizeOfLightSourceSettingsList() == lightSourceSettingsIndex) {
            o2.addLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
        o3.setAttenuation(attenuation);
    }

    @Override
    public void setChannelLightSourceSettingsID(String id, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getLightSourceSettings() == null) {
            o3.setLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o4 = o3.getLightSourceSettings();
        this.model.addModelObject(id, o4);
        o4.setID(id);
    }

    @Override
    public void setMicrobeamManipulationLightSourceSettingsID(String id, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        MicrobeamManipulation o2;
        Experiment o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        if ((o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex)).sizeOfLightSourceSettingsList() == lightSourceSettingsIndex) {
            o2.addLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
        this.model.addModelObject(id, o3);
        o3.setID(id);
    }

    @Override
    public void setChannelLightSourceSettingsWavelength(Length wavelength, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getLightSourceSettings() == null) {
            o3.setLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o4 = o3.getLightSourceSettings();
        o4.setWavelength(wavelength);
    }

    @Override
    public void setMicrobeamManipulationLightSourceSettingsWavelength(Length wavelength, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        MicrobeamManipulation o2;
        Experiment o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        if ((o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex)).sizeOfLightSourceSettingsList() == lightSourceSettingsIndex) {
            o2.addLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
        o3.setWavelength(wavelength);
    }

    @Override
    public void setLineAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex), annotationLinks_reference);
    }

    @Override
    public void setLineFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFillColor(fillColor);
    }

    @Override
    public void setLineFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFillRule(fillRule);
    }

    @Override
    public void setLineFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFontFamily(fontFamily);
    }

    @Override
    public void setLineFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFontSize(fontSize);
    }

    @Override
    public void setLineFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFontStyle(fontStyle);
    }

    @Override
    public void setLineID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Line)o3).setID(id);
    }

    @Override
    public void setLineLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setLineCap(lineCap);
    }

    @Override
    public void setLineLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setLocked(locked);
    }

    @Override
    public void setLineStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setStrokeColor(strokeColor);
    }

    @Override
    public void setLineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setStrokeDashArray(strokeDashArray);
    }

    @Override
    public void setLineStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setStrokeWidth(strokeWidth);
    }

    @Override
    public void setLineText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setText(text);
    }

    @Override
    public void setLineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTheC(theC);
    }

    @Override
    public void setLineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTheT(theT);
    }

    @Override
    public void setLineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTheZ(theZ);
    }

    @Override
    public void setLineTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTransform(transform);
    }

    @Override
    public void setLineVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setVisible(visible);
    }

    @Override
    public void setLineMarkerEnd(Marker markerEnd, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setMarkerEnd(markerEnd);
    }

    @Override
    public void setLineMarkerStart(Marker markerStart, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setMarkerStart(markerStart);
    }

    @Override
    public void setLineX1(Double x1, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setX1(x1);
    }

    @Override
    public void setLineX2(Double x2, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setX2(x2);
    }

    @Override
    public void setLineY1(Double y1, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setY1(y1);
    }

    @Override
    public void setLineY2(Double y2, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setY2(y2);
    }

    @Override
    public void setListAnnotationAnnotationRef(String annotation, int listAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setListAnnotationAnnotator(String annotator, int listAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfListAnnotationList() == listAnnotationIndex) {
            o1.addListAnnotation(new ListAnnotation());
        }
        ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setListAnnotationDescription(String description, int listAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfListAnnotationList() == listAnnotationIndex) {
            o1.addListAnnotation(new ListAnnotation());
        }
        ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setListAnnotationID(String id, int listAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfListAnnotationList() == listAnnotationIndex) {
            o1.addListAnnotation(new ListAnnotation());
        }
        ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setListAnnotationNamespace(String namespace, int listAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfListAnnotationList() == listAnnotationIndex) {
            o1.addListAnnotation(new ListAnnotation());
        }
        ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setLongAnnotationAnnotationRef(String annotation, int longAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setLongAnnotationAnnotator(String annotator, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setLongAnnotationDescription(String description, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setLongAnnotationID(String id, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setLongAnnotationNamespace(String namespace, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setLongAnnotationValue(Long value, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        o2.setValue(value);
    }

    @Override
    public void setMapAnnotationAnnotationRef(String annotation, int mapAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setMapAnnotationAnnotator(String annotator, int mapAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfMapAnnotationList() == mapAnnotationIndex) {
            o1.addMapAnnotation(new MapAnnotation());
        }
        MapAnnotation o2 = o1.getMapAnnotation(mapAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setMapAnnotationDescription(String description, int mapAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfMapAnnotationList() == mapAnnotationIndex) {
            o1.addMapAnnotation(new MapAnnotation());
        }
        MapAnnotation o2 = o1.getMapAnnotation(mapAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setMapAnnotationID(String id, int mapAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfMapAnnotationList() == mapAnnotationIndex) {
            o1.addMapAnnotation(new MapAnnotation());
        }
        MapAnnotation o2 = o1.getMapAnnotation(mapAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setMapAnnotationNamespace(String namespace, int mapAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfMapAnnotationList() == mapAnnotationIndex) {
            o1.addMapAnnotation(new MapAnnotation());
        }
        MapAnnotation o2 = o1.getMapAnnotation(mapAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setMaskAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex), annotationLinks_reference);
    }

    @Override
    public void setMaskFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFillColor(fillColor);
    }

    @Override
    public void setMaskFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFillRule(fillRule);
    }

    @Override
    public void setMaskFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFontFamily(fontFamily);
    }

    @Override
    public void setMaskFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFontSize(fontSize);
    }

    @Override
    public void setMaskFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFontStyle(fontStyle);
    }

    @Override
    public void setMaskID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Mask)o3).setID(id);
    }

    @Override
    public void setMaskLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setLineCap(lineCap);
    }

    @Override
    public void setMaskLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setLocked(locked);
    }

    @Override
    public void setMaskStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setStrokeColor(strokeColor);
    }

    @Override
    public void setMaskStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setStrokeDashArray(strokeDashArray);
    }

    @Override
    public void setMaskStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setStrokeWidth(strokeWidth);
    }

    @Override
    public void setMaskText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setText(text);
    }

    @Override
    public void setMaskTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTheC(theC);
    }

    @Override
    public void setMaskTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTheT(theT);
    }

    @Override
    public void setMaskTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTheZ(theZ);
    }

    @Override
    public void setMaskTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTransform(transform);
    }

    @Override
    public void setMaskVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setVisible(visible);
    }

    @Override
    public void setMaskHeight(Double height, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setHeight(height);
    }

    @Override
    public void setMaskWidth(Double width, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setWidth(width);
    }

    @Override
    public void setMaskX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setX(x);
    }

    @Override
    public void setMaskY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setY(y);
    }

    @Override
    public void setMicrobeamManipulationDescription(String description, int experimentIndex, int microbeamManipulationIndex) {
        Experiment o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setMicrobeamManipulationExperimenterRef(String experimenter, int experimentIndex, int microbeamManipulationIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference(this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex), experimenter_reference);
    }

    @Override
    public void setMicrobeamManipulationID(String id, int experimentIndex, int microbeamManipulationIndex) {
        Experiment o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setMicrobeamManipulationROIRef(String roi, int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        ROIRef roiLinks_reference = new ROIRef();
        roiLinks_reference.setID(roi);
        this.model.addReference(this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex), roiLinks_reference);
    }

    @Override
    public void setMicrobeamManipulationType(MicrobeamManipulationType type, int experimentIndex, int microbeamManipulationIndex) {
        Experiment o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
        o2.setType(type);
    }

    @Override
    public void setMicroscopeLotNumber(String lotNumber, int instrumentIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setLotNumber(lotNumber);
    }

    @Override
    public void setMicroscopeManufacturer(String manufacturer, int instrumentIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setManufacturer(manufacturer);
    }

    @Override
    public void setMicroscopeModel(String model, int instrumentIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setModel(model);
    }

    @Override
    public void setMicroscopeSerialNumber(String serialNumber, int instrumentIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setSerialNumber(serialNumber);
    }

    @Override
    public void setMicroscopeType(MicroscopeType type, int instrumentIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setType(type);
    }

    @Override
    public void setObjectiveAnnotationRef(String annotation, int instrumentIndex, int objectiveIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex), annotationLinks_reference);
    }

    @Override
    public void setObjectiveCalibratedMagnification(Double calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setCalibratedMagnification(calibratedMagnification);
    }

    @Override
    public void setObjectiveCorrection(Correction correction, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setCorrection(correction);
    }

    @Override
    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setObjectiveImmersion(Immersion immersion, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setImmersion(immersion);
    }

    @Override
    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setIris(iris);
    }

    @Override
    public void setObjectiveLensNA(Double lensNA, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setLensNA(lensNA);
    }

    @Override
    public void setObjectiveLotNumber(String lotNumber, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setLotNumber(lotNumber);
    }

    @Override
    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setManufacturer(manufacturer);
    }

    @Override
    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setModel(model);
    }

    @Override
    public void setObjectiveNominalMagnification(Double nominalMagnification, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setNominalMagnification(nominalMagnification);
    }

    @Override
    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setSerialNumber(serialNumber);
    }

    @Override
    public void setObjectiveWorkingDistance(Length workingDistance, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setWorkingDistance(workingDistance);
    }

    @Override
    public void setObjectiveSettingsCorrectionCollar(Double correctionCollar, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        o2.setCorrectionCollar(correctionCollar);
    }

    @Override
    public void setObjectiveSettingsID(String id, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setObjectiveSettingsMedium(Medium medium, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        o2.setMedium(medium);
    }

    @Override
    public void setObjectiveSettingsRefractiveIndex(Double refractiveIndex, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        o2.setRefractiveIndex(refractiveIndex);
    }

    @Override
    public void setPixelsBigEndian(Boolean bigEndian, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setBigEndian(bigEndian);
    }

    @Override
    public void setPixelsDimensionOrder(DimensionOrder dimensionOrder, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setDimensionOrder(dimensionOrder);
    }

    @Override
    public void setPixelsID(String id, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setPixelsInterleaved(Boolean interleaved, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setInterleaved(interleaved);
    }

    @Override
    public void setPixelsPhysicalSizeX(Length physicalSizeX, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setPhysicalSizeX(physicalSizeX);
    }

    @Override
    public void setPixelsPhysicalSizeY(Length physicalSizeY, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setPhysicalSizeY(physicalSizeY);
    }

    @Override
    public void setPixelsPhysicalSizeZ(Length physicalSizeZ, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setPhysicalSizeZ(physicalSizeZ);
    }

    @Override
    public void setPixelsSignificantBits(PositiveInteger significantBits, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSignificantBits(significantBits);
    }

    @Override
    public void setPixelsSizeC(PositiveInteger sizeC, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeC(sizeC);
    }

    @Override
    public void setPixelsSizeT(PositiveInteger sizeT, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeT(sizeT);
    }

    @Override
    public void setPixelsSizeX(PositiveInteger sizeX, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeX(sizeX);
    }

    @Override
    public void setPixelsSizeY(PositiveInteger sizeY, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeY(sizeY);
    }

    @Override
    public void setPixelsSizeZ(PositiveInteger sizeZ, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeZ(sizeZ);
    }

    @Override
    public void setPixelsTimeIncrement(Time timeIncrement, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setTimeIncrement(timeIncrement);
    }

    @Override
    public void setPixelsType(PixelType type, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setType(type);
    }

    @Override
    public void setPlaneAnnotationRef(String annotation, int imageIndex, int planeIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getPlane(planeIndex), annotationLinks_reference);
    }

    @Override
    public void setPlaneDeltaT(Time deltaT, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setDeltaT(deltaT);
    }

    @Override
    public void setPlaneExposureTime(Time exposureTime, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setExposureTime(exposureTime);
    }

    @Override
    public void setPlaneHashSHA1(String hashSHA1, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setHashSHA1(hashSHA1);
    }

    @Override
    public void setPlanePositionX(Length positionX, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setPositionX(positionX);
    }

    @Override
    public void setPlanePositionY(Length positionY, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setPositionY(positionY);
    }

    @Override
    public void setPlanePositionZ(Length positionZ, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setPositionZ(positionZ);
    }

    @Override
    public void setPlaneTheC(NonNegativeInteger theC, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setTheC(theC);
    }

    @Override
    public void setPlaneTheT(NonNegativeInteger theT, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setTheT(theT);
    }

    @Override
    public void setPlaneTheZ(NonNegativeInteger theZ, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setTheZ(theZ);
    }

    @Override
    public void setPlateAnnotationRef(String annotation, int plateIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getPlate(plateIndex), annotationLinks_reference);
    }

    @Override
    public void setPlateColumnNamingConvention(NamingConvention columnNamingConvention, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setColumnNamingConvention(columnNamingConvention);
    }

    @Override
    public void setPlateColumns(PositiveInteger columns, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setColumns(columns);
    }

    @Override
    public void setPlateDescription(String description, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setDescription(description);
    }

    @Override
    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setExternalIdentifier(externalIdentifier);
    }

    @Override
    public void setPlateFieldIndex(NonNegativeInteger fieldIndex, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setFieldIndex(fieldIndex);
    }

    @Override
    public void setPlateID(String id, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    @Override
    public void setPlateName(String name, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setName(name);
    }

    @Override
    public void setPlateRowNamingConvention(NamingConvention rowNamingConvention, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setRowNamingConvention(rowNamingConvention);
    }

    @Override
    public void setPlateRows(PositiveInteger rows, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setRows(rows);
    }

    @Override
    public void setPlateStatus(String status, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setStatus(status);
    }

    @Override
    public void setPlateWellOriginX(Length wellOriginX, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setWellOriginX(wellOriginX);
    }

    @Override
    public void setPlateWellOriginY(Length wellOriginY, int plateIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setWellOriginY(wellOriginY);
    }

    @Override
    public void setPlateAcquisitionAnnotationRef(String annotation, int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex), annotationLinks_reference);
    }

    @Override
    public void setPlateAcquisitionDescription(String description, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setDescription(description);
    }

    @Override
    public void setPlateAcquisitionEndTime(Timestamp endTime, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setEndTime(endTime);
    }

    @Override
    public void setPlateAcquisitionID(String id, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setPlateAcquisitionMaximumFieldCount(PositiveInteger maximumFieldCount, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setMaximumFieldCount(maximumFieldCount);
    }

    @Override
    public void setPlateAcquisitionName(String name, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setName(name);
    }

    @Override
    public void setPlateAcquisitionStartTime(Timestamp startTime, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setStartTime(startTime);
    }

    @Override
    public void setPlateAcquisitionWellSampleRef(String wellSample, int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        WellSampleRef wellSamples_reference = new WellSampleRef();
        wellSamples_reference.setID(wellSample);
        this.model.addReference(this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex), wellSamples_reference);
    }

    @Override
    public void setPointAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex), annotationLinks_reference);
    }

    @Override
    public void setPointFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFillColor(fillColor);
    }

    @Override
    public void setPointFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFillRule(fillRule);
    }

    @Override
    public void setPointFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFontFamily(fontFamily);
    }

    @Override
    public void setPointFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFontSize(fontSize);
    }

    @Override
    public void setPointFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFontStyle(fontStyle);
    }

    @Override
    public void setPointID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Point)o3).setID(id);
    }

    @Override
    public void setPointLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setLineCap(lineCap);
    }

    @Override
    public void setPointLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setLocked(locked);
    }

    @Override
    public void setPointStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setStrokeColor(strokeColor);
    }

    @Override
    public void setPointStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setStrokeDashArray(strokeDashArray);
    }

    @Override
    public void setPointStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setStrokeWidth(strokeWidth);
    }

    @Override
    public void setPointText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setText(text);
    }

    @Override
    public void setPointTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTheC(theC);
    }

    @Override
    public void setPointTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTheT(theT);
    }

    @Override
    public void setPointTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTheZ(theZ);
    }

    @Override
    public void setPointTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTransform(transform);
    }

    @Override
    public void setPointVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setVisible(visible);
    }

    @Override
    public void setPointX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setX(x);
    }

    @Override
    public void setPointY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setY(y);
    }

    @Override
    public void setPolygonAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex), annotationLinks_reference);
    }

    @Override
    public void setPolygonFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setFillColor(fillColor);
    }

    @Override
    public void setPolygonFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setFillRule(fillRule);
    }

    @Override
    public void setPolygonFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setFontFamily(fontFamily);
    }

    @Override
    public void setPolygonFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setFontSize(fontSize);
    }

    @Override
    public void setPolygonFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setFontStyle(fontStyle);
    }

    @Override
    public void setPolygonID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Polygon)o3).setID(id);
    }

    @Override
    public void setPolygonLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setLineCap(lineCap);
    }

    @Override
    public void setPolygonLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setLocked(locked);
    }

    @Override
    public void setPolygonStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setStrokeColor(strokeColor);
    }

    @Override
    public void setPolygonStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setStrokeDashArray(strokeDashArray);
    }

    @Override
    public void setPolygonStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setStrokeWidth(strokeWidth);
    }

    @Override
    public void setPolygonText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setText(text);
    }

    @Override
    public void setPolygonTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setTheC(theC);
    }

    @Override
    public void setPolygonTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setTheT(theT);
    }

    @Override
    public void setPolygonTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setTheZ(theZ);
    }

    @Override
    public void setPolygonTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setTransform(transform);
    }

    @Override
    public void setPolygonVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setVisible(visible);
    }

    @Override
    public void setPolygonPoints(String points, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setPoints(points);
    }

    @Override
    public void setPolylineAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex), annotationLinks_reference);
    }

    @Override
    public void setPolylineFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFillColor(fillColor);
    }

    @Override
    public void setPolylineFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFillRule(fillRule);
    }

    @Override
    public void setPolylineFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFontFamily(fontFamily);
    }

    @Override
    public void setPolylineFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFontSize(fontSize);
    }

    @Override
    public void setPolylineFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFontStyle(fontStyle);
    }

    @Override
    public void setPolylineID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Polyline)o3).setID(id);
    }

    @Override
    public void setPolylineLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setLineCap(lineCap);
    }

    @Override
    public void setPolylineLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setLocked(locked);
    }

    @Override
    public void setPolylineStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setStrokeColor(strokeColor);
    }

    @Override
    public void setPolylineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setStrokeDashArray(strokeDashArray);
    }

    @Override
    public void setPolylineStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setStrokeWidth(strokeWidth);
    }

    @Override
    public void setPolylineText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setText(text);
    }

    @Override
    public void setPolylineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTheC(theC);
    }

    @Override
    public void setPolylineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTheT(theT);
    }

    @Override
    public void setPolylineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTheZ(theZ);
    }

    @Override
    public void setPolylineTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTransform(transform);
    }

    @Override
    public void setPolylineVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setVisible(visible);
    }

    @Override
    public void setPolylineMarkerEnd(Marker markerEnd, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setMarkerEnd(markerEnd);
    }

    @Override
    public void setPolylineMarkerStart(Marker markerStart, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setMarkerStart(markerStart);
    }

    @Override
    public void setPolylinePoints(String points, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setPoints(points);
    }

    @Override
    public void setProjectAnnotationRef(String annotation, int projectIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getProject(projectIndex), annotationLinks_reference);
    }

    @Override
    public void setProjectDatasetRef(String dataset, int projectIndex, int datasetRefIndex) {
        DatasetRef datasetLinks_reference = new DatasetRef();
        datasetLinks_reference.setID(dataset);
        this.model.addReference(this.root.getProject(projectIndex), datasetLinks_reference);
    }

    @Override
    public void setProjectDescription(String description, int projectIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfProjectList() == projectIndex) {
            o0.addProject(new Project());
        }
        Project o1 = o0.getProject(projectIndex);
        o1.setDescription(description);
    }

    @Override
    public void setProjectExperimenterGroupRef(String experimenterGroup, int projectIndex) {
        ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
        experimenterGroup_reference.setID(experimenterGroup);
        this.model.addReference(this.root.getProject(projectIndex), experimenterGroup_reference);
    }

    @Override
    public void setProjectExperimenterRef(String experimenter, int projectIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference(this.root.getProject(projectIndex), experimenter_reference);
    }

    @Override
    public void setProjectID(String id, int projectIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfProjectList() == projectIndex) {
            o0.addProject(new Project());
        }
        Project o1 = o0.getProject(projectIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    @Override
    public void setProjectName(String name, int projectIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfProjectList() == projectIndex) {
            o0.addProject(new Project());
        }
        Project o1 = o0.getProject(projectIndex);
        o1.setName(name);
    }

    @Override
    public void setROIAnnotationRef(String annotation, int ROIIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getROI(ROIIndex), annotationLinks_reference);
    }

    @Override
    public void setROIDescription(String description, int ROIIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        o1.setDescription(description);
    }

    @Override
    public void setROIID(String id, int ROIIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    @Override
    public void setROIName(String name, int ROIIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        o1.setName(name);
    }

    @Override
    public void setROINamespace(String namespace, int ROIIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        o1.setNamespace(namespace);
    }

    @Override
    public void setReagentAnnotationRef(String annotation, int screenIndex, int reagentIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getScreen(screenIndex).getReagent(reagentIndex), annotationLinks_reference);
    }

    @Override
    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        Screen o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        o2.setDescription(description);
    }

    @Override
    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        Screen o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        Screen o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        o2.setName(name);
    }

    @Override
    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        Screen o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        o2.setReagentIdentifier(reagentIdentifier);
    }

    @Override
    public void setRectangleAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex), annotationLinks_reference);
    }

    @Override
    public void setRectangleFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFillColor(fillColor);
    }

    @Override
    public void setRectangleFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFillRule(fillRule);
    }

    @Override
    public void setRectangleFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFontFamily(fontFamily);
    }

    @Override
    public void setRectangleFontSize(Length fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFontSize(fontSize);
    }

    @Override
    public void setRectangleFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFontStyle(fontStyle);
    }

    @Override
    public void setRectangleID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Rectangle)o3).setID(id);
    }

    @Override
    public void setRectangleLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setLineCap(lineCap);
    }

    @Override
    public void setRectangleLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setLocked(locked);
    }

    @Override
    public void setRectangleStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setStrokeColor(strokeColor);
    }

    @Override
    public void setRectangleStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setStrokeDashArray(strokeDashArray);
    }

    @Override
    public void setRectangleStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setStrokeWidth(strokeWidth);
    }

    @Override
    public void setRectangleText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setText(text);
    }

    @Override
    public void setRectangleTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTheC(theC);
    }

    @Override
    public void setRectangleTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTheT(theT);
    }

    @Override
    public void setRectangleTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTheZ(theZ);
    }

    @Override
    public void setRectangleTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTransform(transform);
    }

    @Override
    public void setRectangleVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setVisible(visible);
    }

    @Override
    public void setRectangleHeight(Double height, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setHeight(height);
    }

    @Override
    public void setRectangleWidth(Double width, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setWidth(width);
    }

    @Override
    public void setRectangleX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setX(x);
    }

    @Override
    public void setRectangleY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setY(y);
    }

    @Override
    public void setRightsRightsHeld(String rightsHeld) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getRights() == null) {
            o0.setRights(new Rights());
        }
        Rights o1 = o0.getRights();
        o1.setRightsHeld(rightsHeld);
    }

    @Override
    public void setRightsRightsHolder(String rightsHolder) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getRights() == null) {
            o0.setRights(new Rights());
        }
        Rights o1 = o0.getRights();
        o1.setRightsHolder(rightsHolder);
    }

    @Override
    public void setScreenAnnotationRef(String annotation, int screenIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getScreen(screenIndex), annotationLinks_reference);
    }

    @Override
    public void setScreenDescription(String description, int screenIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setDescription(description);
    }

    @Override
    public void setScreenID(String id, int screenIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    @Override
    public void setScreenName(String name, int screenIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setName(name);
    }

    @Override
    public void setScreenPlateRef(String plate, int screenIndex, int plateRefIndex) {
        PlateRef plateLinks_reference = new PlateRef();
        plateLinks_reference.setID(plate);
        this.model.addReference(this.root.getScreen(screenIndex), plateLinks_reference);
    }

    @Override
    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setProtocolDescription(protocolDescription);
    }

    @Override
    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setProtocolIdentifier(protocolIdentifier);
    }

    @Override
    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setReagentSetDescription(reagentSetDescription);
    }

    @Override
    public void setScreenReagentSetIdentifier(String reagentSetIdentifier, int screenIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setReagentSetIdentifier(reagentSetIdentifier);
    }

    @Override
    public void setScreenType(String type, int screenIndex) {
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setType(type);
    }

    @Override
    public void setStageLabelName(String name, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setName(name);
    }

    @Override
    public void setStageLabelX(Length x, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setX(x);
    }

    @Override
    public void setStageLabelY(Length y, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setY(y);
    }

    @Override
    public void setStageLabelZ(Length z, int imageIndex) {
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setZ(z);
    }

    @Override
    public void setTagAnnotationAnnotationRef(String annotation, int tagAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setTagAnnotationAnnotator(String annotator, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setTagAnnotationDescription(String description, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setTagAnnotationID(String id, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setTagAnnotationNamespace(String namespace, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setTagAnnotationValue(String value, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        o2.setValue(value);
    }

    @Override
    public void setTermAnnotationAnnotationRef(String annotation, int termAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setTermAnnotationAnnotator(String annotator, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setTermAnnotationDescription(String description, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setTermAnnotationID(String id, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setTermAnnotationNamespace(String namespace, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setTermAnnotationValue(String value, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        o2.setValue(value);
    }

    @Override
    public void setTiffDataFirstC(NonNegativeInteger firstC, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setFirstC(firstC);
    }

    @Override
    public void setTiffDataFirstT(NonNegativeInteger firstT, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setFirstT(firstT);
    }

    @Override
    public void setTiffDataFirstZ(NonNegativeInteger firstZ, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setFirstZ(firstZ);
    }

    @Override
    public void setTiffDataIFD(NonNegativeInteger ifd, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setIFD(ifd);
    }

    @Override
    public void setTiffDataPlaneCount(NonNegativeInteger planeCount, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setPlaneCount(planeCount);
    }

    @Override
    public void setTimestampAnnotationAnnotationRef(String annotation, int timestampAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setTimestampAnnotationAnnotator(String annotator, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setTimestampAnnotationDescription(String description, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setTimestampAnnotationID(String id, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setTimestampAnnotationNamespace(String namespace, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setTimestampAnnotationValue(Timestamp value, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        o2.setValue(value);
    }

    @Override
    public void setTransmittanceRangeCutIn(Length cutIn, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutIn(cutIn);
    }

    @Override
    public void setTransmittanceRangeCutInTolerance(Length cutInTolerance, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutInTolerance(cutInTolerance);
    }

    @Override
    public void setTransmittanceRangeCutOut(Length cutOut, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutOut(cutOut);
    }

    @Override
    public void setTransmittanceRangeCutOutTolerance(Length cutOutTolerance, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutOutTolerance(cutOutTolerance);
    }

    @Override
    public void setTransmittanceRangeTransmittance(PercentFraction transmittance, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setTransmittance(transmittance);
    }

    @Override
    public void setUUIDFileName(String fileName, int imageIndex, int tiffDataIndex) {
        TiffData o3;
        Pixels o2;
        Image o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        if ((o3 = o2.getTiffData(tiffDataIndex)).getUUID() == null) {
            o3.setUUID(new UUID());
        }
        UUID o4 = o3.getUUID();
        o4.setFileName(fileName);
    }

    @Override
    public void setWellAnnotationRef(String annotation, int plateIndex, int wellIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getPlate(plateIndex).getWell(wellIndex), annotationLinks_reference);
    }

    @Override
    public void setWellColor(Color color, int plateIndex, int wellIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setColor(color);
    }

    @Override
    public void setWellColumn(NonNegativeInteger column, int plateIndex, int wellIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setColumn(column);
    }

    @Override
    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setExternalDescription(externalDescription);
    }

    @Override
    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setExternalIdentifier(externalIdentifier);
    }

    @Override
    public void setWellID(String id, int plateIndex, int wellIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setWellReagentRef(String reagent, int plateIndex, int wellIndex) {
        ReagentRef reagent_reference = new ReagentRef();
        reagent_reference.setID(reagent);
        this.model.addReference(this.root.getPlate(plateIndex).getWell(wellIndex), reagent_reference);
    }

    @Override
    public void setWellRow(NonNegativeInteger row, int plateIndex, int wellIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setRow(row);
    }

    @Override
    public void setWellType(String type, int plateIndex, int wellIndex) {
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setType(type);
    }

    @Override
    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        this.model.addModelObject(id, o3);
        o3.setID(id);
    }

    @Override
    public void setWellSampleImageRef(String image, int plateIndex, int wellIndex, int wellSampleIndex) {
        ImageRef image_reference = new ImageRef();
        image_reference.setID(image);
        this.model.addReference(this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex), image_reference);
    }

    @Override
    public void setWellSampleIndex(NonNegativeInteger index, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setIndex(index);
    }

    @Override
    public void setWellSamplePositionX(Length positionX, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setPositionX(positionX);
    }

    @Override
    public void setWellSamplePositionY(Length positionY, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setPositionY(positionY);
    }

    @Override
    public void setWellSampleTimepoint(Timestamp timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setTimepoint(timepoint);
    }

    @Override
    public void setXMLAnnotationAnnotationRef(String annotation, int XMLAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex), annotationLinks_reference);
    }

    @Override
    public void setXMLAnnotationAnnotator(String annotator, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        o2.setAnnotator(annotator);
    }

    @Override
    public void setXMLAnnotationDescription(String description, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        o2.setDescription(description);
    }

    @Override
    public void setXMLAnnotationID(String id, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    @Override
    public void setXMLAnnotationNamespace(String namespace, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        o2.setNamespace(namespace);
    }

    @Override
    public void setXMLAnnotationValue(String value, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OMEXMLMetadataRoot o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        o2.setValue(value);
    }
}

