/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.symbol.hash;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.helper.HashMap;
import org.maltparser.core.symbol.SymbolException;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.nullvalue.InputNullValues;
import org.maltparser.core.symbol.nullvalue.NullValues;
import org.maltparser.core.symbol.nullvalue.OutputNullValues;

public final class HashSymbolTable
implements SymbolTable {
    private final String name;
    private final Map<String, Integer> symbolCodeMap;
    private final SortedMap<Integer, String> codeSymbolMap;
    private final NullValues nullValues;
    private final int columnCategory;
    private int valueCounter;

    public HashSymbolTable(String name, int columnCategory, String nullValueStrategy) throws MaltChainedException {
        this.name = name;
        this.columnCategory = columnCategory;
        this.symbolCodeMap = new HashMap<String, Integer>();
        this.codeSymbolMap = new TreeMap<Integer, String>();
        this.nullValues = columnCategory == 1 ? new InputNullValues(nullValueStrategy, this) : (columnCategory == 3 ? new OutputNullValues(nullValueStrategy, this) : new InputNullValues(nullValueStrategy, this));
        this.valueCounter = this.nullValues.getNextCode();
    }

    public HashSymbolTable(String name) {
        this.name = name;
        this.columnCategory = -1;
        this.symbolCodeMap = new HashMap<String, Integer>();
        this.codeSymbolMap = new TreeMap<Integer, String>();
        this.nullValues = new InputNullValues("one", this);
        this.valueCounter = 1;
    }

    @Override
    public int addSymbol(String symbol) throws MaltChainedException {
        if (this.nullValues == null || !this.nullValues.isNullValue(symbol)) {
            if (symbol == null || symbol.length() == 0) {
                throw new SymbolException("Symbol table error: empty string cannot be added to the symbol table");
            }
            if (!this.symbolCodeMap.containsKey(symbol)) {
                int code = this.valueCounter++;
                this.symbolCodeMap.put(symbol, code);
                this.codeSymbolMap.put(code, symbol);
                return code;
            }
            return this.symbolCodeMap.get(symbol);
        }
        return this.nullValues.symbolToCode(symbol);
    }

    @Override
    public String getSymbolCodeToString(int code) throws MaltChainedException {
        if (code >= 0) {
            if (this.nullValues == null || !this.nullValues.isNullValue(code)) {
                if (this.codeSymbolMap.containsKey(code)) {
                    return (String)this.codeSymbolMap.get(code);
                }
                return null;
            }
            return this.nullValues.codeToSymbol(code);
        }
        throw new SymbolException("The symbol code '" + code + "' cannot be found in the symbol table. ");
    }

    @Override
    public int getSymbolStringToCode(String symbol) throws MaltChainedException {
        if (symbol != null) {
            if (this.nullValues == null || !this.nullValues.isNullValue(symbol)) {
                if (this.symbolCodeMap.containsKey(symbol)) {
                    return this.symbolCodeMap.get(symbol);
                }
                return -1;
            }
            return this.nullValues.symbolToCode(symbol);
        }
        throw new SymbolException("The symbol code '" + symbol + "' cannot be found in the symbol table. ");
    }

    @Override
    public String printSymbolTable() throws MaltChainedException {
        StringBuilder sb = new StringBuilder();
        for (Integer code : this.codeSymbolMap.keySet()) {
            sb.append(code + "\t" + (String)this.codeSymbolMap.get(code) + "\n");
        }
        return sb.toString();
    }

    public void saveHeader(BufferedWriter out) throws MaltChainedException {
        try {
            out.append('\t');
            out.append(this.getName());
            out.append('\t');
            out.append(Integer.toString(this.getColumnCategory()));
            out.append('\t');
            out.append(this.getNullValueStrategy());
            out.append('\n');
        }
        catch (IOException e) {
            throw new SymbolException("Could not save the symbol table. ", e);
        }
    }

    public int getColumnCategory() {
        return this.columnCategory;
    }

    public String getNullValueStrategy() {
        if (this.nullValues == null) {
            return null;
        }
        return this.nullValues.getNullValueStrategy();
    }

    @Override
    public int size() {
        return this.symbolCodeMap.size();
    }

    @Override
    public void save(BufferedWriter out) throws MaltChainedException {
        try {
            out.write(this.name);
            out.write(10);
            for (Integer code : this.codeSymbolMap.keySet()) {
                out.write(Integer.toString(code));
                out.write(9);
                out.write((String)this.codeSymbolMap.get(code));
                out.write(10);
            }
            out.write(10);
        }
        catch (IOException e) {
            throw new SymbolException("Could not save the symbol table. ", e);
        }
    }

    @Override
    public void load(BufferedReader in) throws MaltChainedException {
        int max = 0;
        Pattern splitPattern = Pattern.compile("\t");
        try {
            String fileLine;
            while ((fileLine = in.readLine()) != null) {
                if (fileLine.length() == 0) {
                    this.valueCounter = max + 1;
                    break;
                }
                String[] items = splitPattern.split(fileLine);
                int code = Integer.parseInt(items[0]);
                this.symbolCodeMap.put(items[1], code);
                this.codeSymbolMap.put(code, items[1]);
                if (max >= code) continue;
                max = code;
            }
        }
        catch (NumberFormatException e) {
            throw new SymbolException("The symbol table file (.sym) contains a non-integer value in the first column. ", e);
        }
        catch (IOException e) {
            throw new SymbolException("Could not load the symbol table. ", e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getValueCounter() {
        return this.valueCounter;
    }

    @Override
    public int getNullValueCode(NullValues.NullValueId nullValueIdentifier) throws MaltChainedException {
        if (this.nullValues == null) {
            throw new SymbolException("The symbol table does not have any null-values. ");
        }
        return this.nullValues.nullvalueToCode(nullValueIdentifier);
    }

    @Override
    public String getNullValueSymbol(NullValues.NullValueId nullValueIdentifier) throws MaltChainedException {
        if (this.nullValues == null) {
            throw new SymbolException("The symbol table does not have any null-values. ");
        }
        return this.nullValues.nullvalueToSymbol(nullValueIdentifier);
    }

    @Override
    public boolean isNullValue(String symbol) throws MaltChainedException {
        if (this.nullValues != null) {
            return this.nullValues.isNullValue(symbol);
        }
        return false;
    }

    @Override
    public boolean isNullValue(int code) throws MaltChainedException {
        if (this.nullValues != null) {
            return this.nullValues.isNullValue(code);
        }
        return false;
    }

    public Set<Integer> getCodes() {
        return this.codeSymbolMap.keySet();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashSymbolTable other = (HashSymbolTable)obj;
        return this.name == null ? other.name == null : this.name.equals(other.name);
    }

    public int hashCode() {
        return 217 + (null == this.name ? 0 : this.name.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(' ');
        sb.append(this.valueCounter);
        return sb.toString();
    }
}

