/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.util;

import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.FraasisPaiknemiseKoht;
import ee.ut.soras.wrappers.mudel.MorfAnRida;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArvSonaFraasideTuvastaja {
    private static final Object[][] murdJaEriArvulised = new Object[][]{{"veerand", new Double(0.25)}, {"pool(e)?", new Double(0.5)}, {"kolmveerand", new Double(0.75)}, {"pool(e)?teis(e|t)", new Double(1.5)}, {"veerandsa(d|j)a", new Integer(25)}, {"veerandtuhat", new Integer(250)}, {"poolsada", new Integer(50)}, {"poolesaja", new Integer(50)}, {"pooltuhat", new Integer(500)}};
    private static final String[] yhelised = new String[]{"null(ine|is)?", "((\u00fc(ks|he(ne)?){1})|(esimene))", "(ka(ks|he(ne)?){1}|teine)", "kolm(e(ne)?|as)?", "nel(i|ja(ne)?|jas){1}", "vii(s|e(ne)?|es){1}", "kuu(s|e(ne)?|es){1}", "seits(e|me(ne)?|mes){1}", "kaheksa(ne|s)?", "\u00fcheksa(ne|s)?"};
    private static final String[] teistkymnelised = new String[]{"k\u00fcm(me|ne(ne)?|nes)", "((\u00fcksteist(k\u00fcmmend)?)|(\u00fcheteist)|(\u00fcheteistk\u00fcmne(ne|s)?))", "((kaksteist(k\u00fcmmend)?)|(kaheteist)|(kaheteistk\u00fcmne(ne|s)?))", "((kolmteist(k\u00fcmmend)?)|(kolmeteist)|(kolmeteistk\u00fcmne(ne|s)?))", "((neliteist(k\u00fcmmend)?)|(neljateist)|(neljateistk\u00fcmne(ne|s)?))", "((viisteist(k\u00fcmmend)?)|(viieteist)|(viieteistk\u00fcmne(ne|s)?))", "((kuusteist(k\u00fcmmend)?)|(kuueteist)|(kuueteistk\u00fcmne(ne|s)?))", "((seitseteist(k\u00fcmmend)?)|(seitsmeteist)|(seitsmeteistk\u00fcmne(ne|s)?))", "((kaheksateist(k\u00fcmmend)?)|(kaheksateist)|(kaheksateistk\u00fcmne(ne|s)?))", "((\u00fcheksateist(k\u00fcmmend)?)|(\u00fcheksateist)|(\u00fcheksateistk\u00fcmne(ne|s)?))"};
    private static final String[] kymnelised = new String[]{"((kaksk\u00fcmmend)|(kahek\u00fcmne(ne|s)?))", "((kolmk\u00fcmmend)|(kolmek\u00fcmne(ne|s)?))", "((nelik\u00fcmmend)|(neljak\u00fcmne(ne|s)?))", "((viisk\u00fcmmend)|(viiek\u00fcmne(ne|s)?))", "((kuusk\u00fcmmend)|(kuuek\u00fcmne(ne|s)?))", "((seitsek\u00fcmmend)|(seitsmek\u00fcmne(ne|s)?))", "((kaheksak\u00fcmmend)|(kaheksak\u00fcmne(ne|s)?))", "((\u00fcheksak\u00fcmmend)|(\u00fcheksak\u00fcmne(ne|s)?))"};
    private static final String[] sajalised = new String[]{"sa(da|ja(ne)?|jas){1}", "((\u00fckssada)|(\u00fchesaja(ne|s)?))", "((kakssada)|(kahesaja(ne|s)?))", "((kolmsada)|(kolmesaja(ne|s)?))", "((nelisada)|(neljasaja(ne|s)?))", "((viissada)|(viiesaja(ne|s)?))", "((kuussada)|(kuuesaja(ne|s)?))", "((seitsesada)|(seitsmesaja(ne|s)?))", "((kaheksasada)|(kaheksasaja(ne|s)?))", "((\u00fcheksasada)|(\u00fcheksasaja(ne|s)?))"};
    private static final String tuhat = "tuha(t|nde(ne)?|ndes){1}";
    private static final String prefiksiteKontrollAvaldis = "((null|veeran|pool|\u00fcks|\u00fche|esim|kaks|kahe|tei|kolm|nel|vii|kuu|seits|k\u00fcm|sa|tuha){1}).*";
    private Map<Pattern, Object> murdJaEriArvulisteKompilRegExp;
    private Pattern[] yhelisedKompilRegExp;
    private Pattern[] teistkymnelisedKompilRegExp;
    private Pattern[] kymnelisedKompilRegExp;
    private Pattern[] sajalisedKompilRegExp;
    private Pattern tuhatKompilRegExp;
    private Pattern prefiksiKontrollKompilRegExp;
    private boolean viimaneEtteantudSoneOliArvsona = false;
    private int loodavTaisArv = -1;
    private double loodavMurdArv = -1.0;
    private int loodavaArvSonaFraasiPikkus = 0;
    private int eelmiseArvuKlass = 0;
    private List<AjavtSona> labitavTekst = null;

    public ArvSonaFraasideTuvastaja(List<AjavtSona> labitavTekst) {
        this.labitavTekst = labitavTekst;
        this.kompileeriRegulaarAvaldised();
    }

    private void kompileeriRegulaarAvaldised() {
        this.murdJaEriArvulisteKompilRegExp = new HashMap<Pattern, Object>(murdJaEriArvulised.length);
        for (Object[] murdArvuliseAvaldis : murdJaEriArvulised) {
            this.murdJaEriArvulisteKompilRegExp.put(Pattern.compile((String)murdArvuliseAvaldis[0], 64), murdArvuliseAvaldis[1]);
        }
        this.yhelisedKompilRegExp = new Pattern[yhelised.length];
        int i = 0;
        for (String yheliseAvaldis : yhelised) {
            this.yhelisedKompilRegExp[i++] = Pattern.compile(yheliseAvaldis, 64);
        }
        this.teistkymnelisedKompilRegExp = new Pattern[teistkymnelised.length];
        i = 0;
        for (String teistkymneliseAvaldis : teistkymnelised) {
            this.teistkymnelisedKompilRegExp[i++] = Pattern.compile(teistkymneliseAvaldis, 64);
        }
        this.kymnelisedKompilRegExp = new Pattern[kymnelised.length];
        i = 0;
        for (String kymneliseAvaldis : kymnelised) {
            this.kymnelisedKompilRegExp[i++] = Pattern.compile(kymneliseAvaldis, 64);
        }
        this.sajalisedKompilRegExp = new Pattern[sajalised.length];
        i = 0;
        for (String sajaliseAvaldis : sajalised) {
            this.sajalisedKompilRegExp[i++] = Pattern.compile(sajaliseAvaldis, 64);
        }
        this.tuhatKompilRegExp = Pattern.compile(tuhat, 64);
        this.prefiksiKontrollKompilRegExp = Pattern.compile(prefiksiteKontrollAvaldis, 64);
    }

    public Object leiaArvSonaArvulineVaartus(String s) {
        Matcher m;
        int i;
        for (Pattern pattern : this.murdJaEriArvulisteKompilRegExp.keySet()) {
            Matcher m2 = pattern.matcher(s);
            if (!m2.matches()) continue;
            return this.murdJaEriArvulisteKompilRegExp.get(pattern);
        }
        for (i = 0; i < this.yhelisedKompilRegExp.length; ++i) {
            m = this.yhelisedKompilRegExp[i].matcher(s);
            if (!m.matches()) continue;
            return new Integer(i);
        }
        for (i = 0; i < this.teistkymnelisedKompilRegExp.length; ++i) {
            m = this.teistkymnelisedKompilRegExp[i].matcher(s);
            if (!m.matches()) continue;
            return new Integer(10 + i);
        }
        for (i = 0; i < this.kymnelisedKompilRegExp.length; ++i) {
            m = this.kymnelisedKompilRegExp[i].matcher(s);
            if (!m.matches()) continue;
            return new Integer(10 * (i + 2));
        }
        for (i = 0; i < this.sajalisedKompilRegExp.length; ++i) {
            m = this.sajalisedKompilRegExp[i].matcher(s);
            if (!m.matches()) continue;
            return new Integer(i < 2 ? 100 : 100 * i);
        }
        Matcher m3 = this.tuhatKompilRegExp.matcher(s);
        if (m3.matches()) {
            return new Integer(1000);
        }
        return null;
    }

    public boolean tuvastaArvSonaFraas(AjavtSona sona) {
        boolean leidusArvSona = false;
        if (sona.kasLeidusAnalyys()) {
            for (MorfAnRida anRida : sona.getAnalyysiTulemused()) {
                String lemma = anRida.getLemmaIlmaVahemarkideta();
                Matcher m = this.prefiksiKontrollKompilRegExp.matcher(lemma);
                if (!m.matches()) continue;
                Object arvObjektina = this.leiaArvSonaArvulineVaartus(lemma);
                if (arvObjektina != null && arvObjektina instanceof Integer) {
                    int arv = (Integer)arvObjektina;
                    leidusArvSona = true;
                    int arvuKlass = this.leiaArvuKlass(arv);
                    if (this.viimaneEtteantudSoneOliArvsona) {
                        if (this.loodavTaisArv > -1) {
                            if (arv == 1000 && this.loodavTaisArv < arv) {
                                this.loodavTaisArv *= arv;
                                ++this.loodavaArvSonaFraasiPikkus;
                            } else if (this.esimeneArvuKlassOnSuurem(this.eelmiseArvuKlass, arvuKlass)) {
                                this.loodavTaisArv += arv;
                                ++this.loodavaArvSonaFraasiPikkus;
                            } else {
                                this.sulgeArvSonaFraas(sona);
                                this.loodavaArvSonaFraasiPikkus = 1;
                                this.loodavTaisArv = arv;
                            }
                        } else {
                            this.sulgeArvSonaFraas(sona);
                            this.loodavaArvSonaFraasiPikkus = 1;
                            this.loodavTaisArv = arv;
                        }
                    } else {
                        this.loodavTaisArv = arv;
                        this.loodavaArvSonaFraasiPikkus = 1;
                    }
                    this.eelmiseArvuKlass = arvuKlass;
                    break;
                }
                if (arvObjektina == null || !(arvObjektina instanceof Double)) continue;
                if (this.viimaneEtteantudSoneOliArvsona) {
                    this.sulgeArvSonaFraas(sona);
                }
                this.loodavaArvSonaFraasiPikkus = 1;
                this.loodavMurdArv = (Double)arvObjektina;
                leidusArvSona = true;
            }
        }
        if (!leidusArvSona && this.viimaneEtteantudSoneOliArvsona) {
            this.sulgeArvSonaFraas(sona);
        }
        this.viimaneEtteantudSoneOliArvsona = leidusArvSona;
        return leidusArvSona;
    }

    private int leiaArvuKlass(int arv) {
        if (arv >= 0 && arv < 10) {
            return 1;
        }
        if (arv < 20) {
            return 11;
        }
        if (arv < 100) {
            return 50;
        }
        if (arv < 1000) {
            return 100;
        }
        return 1000;
    }

    private boolean esimeneArvuKlassOnSuurem(int esimene, int teine) {
        if (esimene == 11) {
            return false;
        }
        if (teine == 11) {
            return esimene > 50;
        }
        return esimene > teine;
    }

    public void sulgeArvSonaFraas(AjavtSona valjajaetavSona) {
        if ((this.loodavTaisArv > -1 || this.loodavMurdArv > -1.0) && this.loodavaArvSonaFraasiPikkus > 0 && this.labitavTekst != null) {
            int startFrom = this.labitavTekst.size() - 1;
            if (valjajaetavSona != null && this.labitavTekst.get(this.labitavTekst.size() - 1).equals(valjajaetavSona)) {
                --startFrom;
            }
            if (this.loodavaArvSonaFraasiPikkus == 1) {
                this.labitavTekst.get(startFrom).setArvSonaFraasis(FraasisPaiknemiseKoht.AINUSSONA);
                if (this.loodavTaisArv > -1) {
                    this.labitavTekst.get(startFrom).setArvSonaTaisArvVaartus(new Integer(this.loodavTaisArv));
                } else {
                    this.labitavTekst.get(startFrom).setArvSonaMurdArvVaartus(new Double(this.loodavMurdArv));
                }
            } else {
                for (int i = startFrom; i >= startFrom - this.loodavaArvSonaFraasiPikkus + 1; --i) {
                    if (i == startFrom) {
                        this.labitavTekst.get(i).setArvSonaFraasis(FraasisPaiknemiseKoht.LOPUS);
                        if (this.loodavTaisArv > -1) {
                            this.labitavTekst.get(i).setArvSonaTaisArvVaartus(new Integer(this.loodavTaisArv));
                            continue;
                        }
                        this.labitavTekst.get(i).setArvSonaMurdArvVaartus(new Double(this.loodavMurdArv));
                        continue;
                    }
                    if (i == startFrom - this.loodavaArvSonaFraasiPikkus + 1) {
                        this.labitavTekst.get(i).setArvSonaFraasis(FraasisPaiknemiseKoht.ALGUSES);
                        if (this.loodavTaisArv > -1) {
                            this.labitavTekst.get(i).setArvSonaTaisArvVaartus(new Integer(this.loodavTaisArv));
                            continue;
                        }
                        this.labitavTekst.get(i).setArvSonaMurdArvVaartus(new Double(this.loodavMurdArv));
                        continue;
                    }
                    this.labitavTekst.get(i).setArvSonaFraasis(FraasisPaiknemiseKoht.KESKEL);
                    if (this.loodavTaisArv > -1) {
                        this.labitavTekst.get(i).setArvSonaTaisArvVaartus(new Integer(this.loodavTaisArv));
                        continue;
                    }
                    this.labitavTekst.get(i).setArvSonaMurdArvVaartus(new Double(this.loodavMurdArv));
                }
            }
            this.loodavTaisArv = -1;
            this.loodavMurdArv = -1.0;
            this.loodavaArvSonaFraasiPikkus = 0;
        }
    }
}

